/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class VMWrapper {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static Reference<Path> cachedCtSym = new SoftReference<Object>(null);

    private VMWrapper() {
    }

    public static String[] getRuntimeArguments() {
        return new String[0];
    }

    public static Path findCtSym() {
        Path path = cachedCtSym.get();
        if (path instanceof Path) {
            return path;
        }
        try {
            Enumeration<URL> enumeration;
            URL uRL;
            ClassLoader classLoader = VMWrapper.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            URL uRL2 = uRL = (enumeration = classLoader.getResources("META-INF/services/com.sun.tools.javac.platform.PlatformProvider")).hasMoreElements() ? enumeration.nextElement() : null;
            if (uRL == null) {
                String string = System.getProperty("java.home");
                Path path2 = Paths.get(string, new String[0]);
                for (String string2 : symbolFileLocation) {
                    path2 = path2.resolve(string2);
                }
                if (!Files.exists(path2, new LinkOption[0])) {
                    throw new IllegalStateException("Cannot find ct.sym at " + path2);
                }
                return FileSystems.newFileSystem(path2, (ClassLoader)null).getRootDirectories().iterator().next();
            }
            if (!uRL.getProtocol().equals("jar")) {
                uRL = enumeration.hasMoreElements() ? enumeration.nextElement() : null;
            }
            URL uRL3 = ((JarURLConnection)uRL.openConnection()).getJarFileURL();
            Path path3 = Paths.get(uRL3.toURI());
            FileSystem fileSystem = FileSystems.newFileSystem(path3, (ClassLoader)null);
            Path path4 = fileSystem.getPath("META-INF", "ct.sym");
            cachedCtSym = new SoftReference<Path>(path4);
            return path4;
        }
        catch (IOException | URISyntaxException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path) throws IOException {
        final ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Path path2 : Files.newDirectoryStream(path)) {
            String string = path2.getFileName().toString();
            if (string.endsWith("/")) {
                arrayList.add(path.resolve(string.substring(0, string.length() - 1)));
                continue;
            }
            arrayList.add(path2);
        }
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return arrayList.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    public static FileSystem pathFs(final Path path) {
        return new FileSystem(){

            @Override
            public FileSystemProvider provider() {
                return path.getFileSystem().provider();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean isOpen() {
                return path.getFileSystem().isOpen();
            }

            @Override
            public boolean isReadOnly() {
                return path.getFileSystem().isReadOnly();
            }

            @Override
            public String getSeparator() {
                return path.getFileSystem().getSeparator();
            }

            @Override
            public Iterable<Path> getRootDirectories() {
                return Collections.singleton(path);
            }

            @Override
            public Iterable<FileStore> getFileStores() {
                return path.getFileSystem().getFileStores();
            }

            @Override
            public Set<String> supportedFileAttributeViews() {
                return path.getFileSystem().supportedFileAttributeViews();
            }

            @Override
            public Path getPath(String string, String ... stringArray) {
                Path path2 = path.resolve(string);
                for (String string2 : stringArray) {
                    path2 = path2.resolve(string2);
                }
                return path2;
            }

            @Override
            public PathMatcher getPathMatcher(String string) {
                return path.getFileSystem().getPathMatcher(string);
            }

            @Override
            public UserPrincipalLookupService getUserPrincipalLookupService() {
                return path.getFileSystem().getUserPrincipalLookupService();
            }

            @Override
            public WatchService newWatchService() throws IOException {
                return path.getFileSystem().newWatchService();
            }
        };
    }

    public static <T> Stream<T> optional2Stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }
}

