/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.ToolProvider;
import nbjavac.ModuleWrapper;

public class ServiceLoaderWrapper<T>
implements Iterable<T> {
    private final ServiceLoader<T> loader;

    public ServiceLoaderWrapper(ServiceLoader<T> serviceLoader) {
        this.loader = serviceLoader;
    }

    public static <T> ServiceLoader<T> load(ModuleWrapper.ModuleLayer moduleLayer, Class<T> clazz) {
        ModuleWrapper.ensureUses(clazz);
        return ServiceLoader.load(clazz);
    }

    public static <T> ServiceLoaderWrapper<T> load(Class<T> clazz) {
        ModuleWrapper.ensureUses(clazz);
        return new ServiceLoaderWrapper<T>(ServiceLoader.load(clazz));
    }

    public static <T> ServiceLoaderWrapper<T> load(Class<T> clazz, ClassLoader classLoader) {
        ModuleWrapper.ensureUses(clazz);
        return new ServiceLoaderWrapper<T>(ServiceLoader.load(clazz, classLoader));
    }

    public static <T> ServiceLoader<T> loadWithClassLoader(Class<T> clazz, ClassLoader classLoader) {
        ModuleWrapper.ensureUses(clazz);
        return ServiceLoader.load(clazz, classLoader);
    }

    public static <T> ServiceLoader<T> loadTool(Class<T> clazz) {
        ModuleWrapper.ensureUses(clazz);
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, ToolProvider.class.getClassLoader());
        if (serviceLoader.iterator().hasNext()) {
            return serviceLoader;
        }
        return ServiceLoader.load(clazz, ClassLoader.getSystemClassLoader());
    }

    public Stream<Provider<T>> stream() {
        return StreamSupport.stream(this.loader.spliterator(), false).map(object -> new Provider<T>(){

            @Override
            public Class<? extends T> type() {
                return object.getClass();
            }

            @Override
            public T get() {
                return object;
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return this.loader.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.loader.forEach(consumer);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.loader.spliterator();
    }

    public static interface Provider<T> {
        public Class<? extends T> type();

        public T get();
    }
}

