/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;

public class FileSystemsWrapper {
    private static final Method newFS13;

    public static FileSystem newFileSystem(Path path, Map<String, ?> map, ClassLoader classLoader) throws IOException {
        if (newFS13 != null) {
            try {
                return (FileSystem)newFS13.invoke(null, path, map, classLoader);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException();
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new RuntimeException(invocationTargetException);
            }
        }
        return FileSystems.newFileSystem(path, classLoader);
    }

    static {
        Method method = null;
        try {
            method = FileSystems.class.getDeclaredMethod("newFileSystem", Path.class, Map.class, ClassLoader.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        newFS13 = method;
    }
}

