/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;

public abstract class Utf8NameTable
extends Name.Table {
    protected Utf8NameTable(Names names) {
        super(names);
    }

    protected static int hashValue(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            n3 = (n3 << 5) - n3 + byArray[n++];
        }
        return n3;
    }

    protected static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (n3-- > 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    protected static abstract class NameImpl
    extends Name {
        NameImpl(Utf8NameTable utf8NameTable) {
            super(utf8NameTable);
        }

        protected abstract byte[] getByteData();

        protected abstract int getByteOffset();

        protected abstract int getByteLength();

        protected abstract int getNameIndex();

        @Override
        protected boolean nameEquals(Name name) {
            return ((NameImpl)name).getNameIndex() == this.getNameIndex();
        }

        @Override
        public int length() {
            return Convert.utfNumChars(this.getByteData(), this.getByteOffset(), this.getByteLength());
        }

        @Override
        public String toString() {
            try {
                return Convert.utf2string(this.getByteData(), this.getByteOffset(), this.getByteLength(), Convert.Validation.NONE);
            }
            catch (InvalidUtfException invalidUtfException) {
                throw new AssertionError("invalid UTF8 data", invalidUtfException);
            }
        }

        @Override
        public int hashCode() {
            return this.getNameIndex();
        }

        @Override
        public int compareTo(Name name) {
            int n;
            if (!(name instanceof NameImpl)) {
                return super.compareTo(name);
            }
            NameImpl nameImpl = (NameImpl)name;
            byte[] byArray = this.getByteData();
            byte[] byArray2 = nameImpl.getByteData();
            int n2 = this.getByteOffset();
            int n3 = nameImpl.getByteOffset();
            int n4 = this.getByteLength();
            for (n = nameImpl.getByteLength(); n4 > 0 && n > 0; --n4, --n) {
                int n5;
                int n6 = byArray[n2++] & 0xFF;
                int n7 = byArray2[n3++] & 0xFF;
                if (n6 == 192 && (byArray[n2] & 0x3F) == 0) {
                    n6 = 0;
                    ++n2;
                    --n4;
                }
                if (n7 == 192 && (byArray2[n3] & 0x3F) == 0) {
                    n7 = 0;
                    ++n3;
                    --n;
                }
                if ((n5 = n6 - n7) == 0) continue;
                return n5;
            }
            return n4 > 0 ? 1 : (n > 0 ? -1 : 0);
        }

        @Override
        public Name append(Name name) {
            NameImpl nameImpl = (NameImpl)name;
            Assert.check(nameImpl.table == this.table);
            byte[] byArray = this.getByteData();
            byte[] byArray2 = nameImpl.getByteData();
            int n = this.getByteOffset();
            int n2 = nameImpl.getByteOffset();
            int n3 = this.getByteLength();
            int n4 = nameImpl.getByteLength();
            byte[] byArray3 = new byte[n3 + n4];
            System.arraycopy(byArray, n, byArray3, 0, n3);
            System.arraycopy(byArray2, n2, byArray3, n3, n4);
            try {
                return this.table.fromUtf(byArray3, 0, byArray3.length, Convert.Validation.NONE);
            }
            catch (InvalidUtfException invalidUtfException) {
                throw new AssertionError("invalid UTF8 data", invalidUtfException);
            }
        }

        @Override
        public Name append(char c, Name name) {
            Assert.check((c & 0xFFFFFF80) == 0);
            NameImpl nameImpl = (NameImpl)name;
            Assert.check(nameImpl.table == this.table);
            byte[] byArray = this.getByteData();
            byte[] byArray2 = nameImpl.getByteData();
            int n = this.getByteOffset();
            int n2 = nameImpl.getByteOffset();
            int n3 = this.getByteLength();
            int n4 = nameImpl.getByteLength();
            byte[] byArray3 = new byte[n3 + 1 + n4];
            System.arraycopy(byArray, n, byArray3, 0, n3);
            byArray3[n3] = (byte)c;
            System.arraycopy(byArray2, n2, byArray3, n3 + 1, n4);
            try {
                return this.table.fromUtf(byArray3, 0, byArray3.length, Convert.Validation.NONE);
            }
            catch (InvalidUtfException invalidUtfException) {
                throw new AssertionError("invalid UTF8 data", invalidUtfException);
            }
        }

        @Override
        public int lastIndexOfAscii(char c) {
            int n;
            Assert.check((c & 0xFFFFFF80) == 0);
            byte by = (byte)c;
            byte[] byArray = this.getByteData();
            int n2 = this.getByteOffset();
            int n3 = this.getByteLength();
            for (n = n3 - 1; n >= 0 && byArray[n2 + n] != by; --n) {
            }
            if (n <= 0) {
                return n;
            }
            return Convert.utfNumChars(byArray, n2, n);
        }

        @Override
        public boolean startsWith(Name name) {
            NameImpl nameImpl = (NameImpl)name;
            Assert.check(nameImpl.table == this.table);
            int n = this.getByteLength();
            int n2 = nameImpl.getByteLength();
            if (n < n2) {
                return false;
            }
            byte[] byArray = this.getByteData();
            byte[] byArray2 = nameImpl.getByteData();
            int n3 = this.getByteOffset() + n2;
            int n4 = nameImpl.getByteOffset() + n2;
            while (n2-- > 0) {
                if (byArray[--n3] == byArray2[--n4]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getUtf8Length() {
            return this.getByteLength();
        }

        @Override
        public void getUtf8Bytes(byte[] byArray, int n) {
            System.arraycopy(this.getByteData(), this.getByteOffset(), byArray, n, this.getByteLength());
        }
    }
}

