/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String toLowerCase(String string) {
        return string.toLowerCase(Locale.US);
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase(Locale.US);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtils.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        Matcher matcher = Pattern.compile(Pattern.quote(string2), 2).matcher(string);
        return matcher.find(n) ? matcher.start() : -1;
    }

    public static final class DamerauLevenshteinDistance {
        private final int INF;
        private final int[][] h;
        private final String a;
        private final String b;
        private static final int Wi = 1;
        private static final int Wd = 1;
        private static final int Wc = 1;
        private static final int Ws = 1;
        private int[] smallDA;
        private Map<Character, Integer> bigDA;

        public static int of(String string, String string2) {
            return new DamerauLevenshteinDistance(string, string2).calculate();
        }

        private int calculate() {
            int n;
            for (n = 0; n <= this.a.length(); ++n) {
                this.h(n, 0, n * 1);
                this.h(n, -1, this.INF);
            }
            for (n = 0; n <= this.b.length(); ++n) {
                this.h(0, n, n * 1);
                this.h(-1, n, this.INF);
            }
            for (n = 1; n <= this.a.length(); ++n) {
                int n2 = 0;
                for (int i = 1; i <= this.b.length(); ++i) {
                    int n3;
                    int n4 = this.da(this.characterAt(this.b, i));
                    int n5 = n2;
                    boolean bl = this.characterAt(this.a, n) == this.characterAt(this.b, i);
                    int n6 = n3 = bl ? 0 : 1;
                    if (bl) {
                        n2 = i;
                    }
                    int n7 = DamerauLevenshteinDistance.min(this.h(n - 1, i - 1) + n3, this.h(n, i - 1) + 1, this.h(n - 1, i) + 1, this.h(n4 - 1, n5 - 1) + (n - n4 - 1) * 1 + 1 + (i - n5 - 1) * 1);
                    this.h(n, i, n7);
                }
                this.da(this.characterAt(this.a, n), n);
            }
            return this.h(this.a.length(), this.b.length());
        }

        private int characterAt(String string, int n) {
            return string.charAt(n - 1);
        }

        private void h(int n, int n2, int n3) {
            this.h[n + 1][n2 + 1] = n3;
        }

        private int h(int n, int n2) {
            return this.h[n + 1][n2 + 1];
        }

        private int da(int n) {
            if (this.smallDA != null && n < 128) {
                return this.smallDA[n];
            }
            if (this.bigDA != null) {
                Integer n2 = this.bigDA.get(Character.valueOf((char)n));
                return n2 == null ? 0 : n2;
            }
            return 0;
        }

        private void da(int n, int n2) {
            if (this.bigDA == null && n < 128) {
                if (this.smallDA == null) {
                    this.smallDA = new int[127];
                }
                this.smallDA[n] = n2;
            } else {
                if (this.bigDA == null) {
                    this.bigDA = new HashMap<Character, Integer>();
                    if (this.smallDA != null) {
                        for (int i = 0; i < this.smallDA.length; ++i) {
                            int n3 = this.smallDA[i];
                            if (n3 == 0) continue;
                            this.bigDA.put(Character.valueOf((char)i), n3);
                        }
                        this.smallDA = null;
                    }
                }
                this.bigDA.put(Character.valueOf((char)n), n2);
            }
            assert (this.smallDA == null ^ this.bigDA == null);
        }

        private static int min(int n, int n2, int n3, int n4) {
            return Math.min(n, Math.min(n2, Math.min(n3, n4)));
        }

        private DamerauLevenshteinDistance(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.h = new int[this.a.length() + 2][this.b.length() + 2];
            this.INF = this.a.length() * 1 + this.b.length() * 1 + 1;
            if (this.INF < 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }
}

