/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;

public class StringNameTable
extends Name.Table {
    private final HashMap<String, Name> nameMap;
    private final boolean intern;

    public static StringNameTable create(Names names, boolean bl) {
        return new StringNameTable(names, bl);
    }

    public StringNameTable(Names names, boolean bl) {
        this(names, 32768, bl);
    }

    public StringNameTable(Names names, int n, boolean bl) {
        super(names);
        this.nameMap = new HashMap(n);
        this.intern = bl;
    }

    @Override
    public Name fromString(String string) {
        Name name = this.nameMap.get(string);
        if (name == null) {
            if (this.intern) {
                string = string.intern();
            }
            name = new NameImpl(this, string);
            this.nameMap.put(string, name);
        }
        return name;
    }

    @Override
    public Name fromChars(char[] cArray, int n, int n2) {
        return this.fromString(new String(cArray, n, n2));
    }

    @Override
    public Name fromUtf(byte[] byArray, int n, int n2, Convert.Validation validation) throws InvalidUtfException {
        return this.fromString(Convert.utf2string(byArray, n, n2, validation));
    }

    @Override
    public void dispose() {
        this.nameMap.clear();
    }

    private static final class NameImpl
    extends Name {
        private final String string;

        NameImpl(StringNameTable stringNameTable, String string) {
            super(stringNameTable);
            this.string = string;
        }

        @Override
        public String toString() {
            return this.string;
        }

        @Override
        public boolean contentEquals(CharSequence charSequence) {
            return this.string.contentEquals(charSequence);
        }

        @Override
        protected boolean nameEquals(Name name) {
            return ((NameImpl)name).string.equals(this.string);
        }

        @Override
        public int hashCode() {
            return this.string.hashCode();
        }

        @Override
        public int getUtf8Length() {
            int n = this.string.length();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = this.string.charAt(i);
                if (c <= '\u007f' && c != '\u0000') continue;
                ++n2;
                if (c <= '\u07ff') continue;
                ++n2;
            }
            return n + n2;
        }

        @Override
        public void getUtf8Bytes(byte[] byArray, int n) {
            Convert.chars2utf(this.string.toCharArray(), 0, byArray, n, this.string.length());
        }
    }
}

