/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Utf8NameTable;
import java.lang.ref.SoftReference;

public class SharedNameTable
extends Utf8NameTable {
    private static List<SoftReference<SharedNameTable>> freelist = List.nil();
    private NameImpl[] hashes;
    public byte[] bytes;
    private int hashMask;
    private int nc = 0;

    public static synchronized SharedNameTable create(Names names) {
        while (freelist.nonEmpty()) {
            SharedNameTable sharedNameTable = (SharedNameTable)((SoftReference)SharedNameTable.freelist.head).get();
            freelist = SharedNameTable.freelist.tail;
            if (sharedNameTable == null) continue;
            return sharedNameTable;
        }
        return new SharedNameTable(names);
    }

    private static synchronized void dispose(SharedNameTable sharedNameTable) {
        freelist = freelist.prepend(new SoftReference<SharedNameTable>(sharedNameTable));
    }

    public SharedNameTable(Names names, int n, int n2) {
        super(names);
        if (Integer.bitCount(n) != 1) {
            throw new IllegalArgumentException();
        }
        this.hashMask = n - 1;
        this.hashes = new NameImpl[n];
        this.bytes = new byte[n2];
    }

    public SharedNameTable(Names names) {
        this(names, 32768, 131072);
    }

    @Override
    public Name fromChars(char[] cArray, int n, int n2) {
        int n3 = this.nc;
        this.bytes = ArrayUtils.ensureCapacity(this.bytes, n3 + n2 * 3);
        byte[] byArray = this.bytes;
        int n4 = Convert.chars2utf(cArray, n, byArray, n3, n2) - n3;
        int n5 = SharedNameTable.hashValue(byArray, n3, n4) & this.hashMask;
        NameImpl nameImpl = this.hashes[n5];
        while (!(nameImpl == null || nameImpl.getByteLength() == n4 && SharedNameTable.equals(byArray, nameImpl.index, byArray, n3, n4))) {
            nameImpl = nameImpl.next;
        }
        if (nameImpl == null) {
            nameImpl = this.addName(n3, n4, n5);
        }
        return nameImpl;
    }

    @Override
    public Name fromUtf(byte[] byArray, int n, int n2, Convert.Validation validation) throws InvalidUtfException {
        if (validation != Convert.Validation.NONE) {
            Convert.utfValidate(byArray, n, n2, validation);
        }
        int n3 = SharedNameTable.hashValue(byArray, n, n2) & this.hashMask;
        NameImpl nameImpl = this.hashes[n3];
        byte[] byArray2 = this.bytes;
        while (!(nameImpl == null || nameImpl.getByteLength() == n2 && SharedNameTable.equals(byArray2, nameImpl.index, byArray, n, n2))) {
            nameImpl = nameImpl.next;
        }
        if (nameImpl == null) {
            byArray2 = this.bytes = ArrayUtils.ensureCapacity(byArray2, this.nc + n2);
            System.arraycopy(byArray, n, byArray2, this.nc, n2);
            nameImpl = this.addName(this.nc, n2, n3);
        }
        return nameImpl;
    }

    private NameImpl addName(int n, int n2, int n3) {
        NameImpl nameImpl;
        this.hashes[n3] = nameImpl = new NameImpl(this, n, n2, this.hashes[n3]);
        this.nc = n + Math.max(n2, 1);
        return nameImpl;
    }

    @Override
    public void dispose() {
        SharedNameTable.dispose(this);
    }

    static final class NameImpl
    extends Utf8NameTable.NameImpl {
        final NameImpl next;
        final int index;
        final int length;

        NameImpl(SharedNameTable sharedNameTable, int n, int n2, NameImpl nameImpl) {
            super(sharedNameTable);
            this.index = n;
            this.length = n2;
            this.next = nameImpl;
        }

        @Override
        protected byte[] getByteData() {
            return ((SharedNameTable)this.table).bytes;
        }

        @Override
        protected int getByteOffset() {
            return this.index;
        }

        @Override
        protected int getByteLength() {
            return this.length;
        }

        @Override
        protected int getNameIndex() {
            return this.index;
        }
    }
}

