/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.ListBuffer;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collector;

public class List<A>
extends AbstractCollection<A>
implements java.util.List<A> {
    public A head;
    public List<A> tail;
    private static final List<?> EMPTY_LIST = new List<Object>(null, null){

        @Override
        public List<Object> setTail(List<Object> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    List(A a, List<A> list) {
        this.tail = list;
        this.head = a;
    }

    public static <A> List<A> nil() {
        return EMPTY_LIST;
    }

    public static <A> List<A> filter(List<A> list, A a) {
        Assert.checkNonNull(a);
        List<A> list2 = List.nil();
        for (A a2 : list) {
            if (a2 == null || a2.equals(a)) continue;
            list2 = list2.prepend(a2);
        }
        return list2.reverse();
    }

    public List<A> intersect(List<A> list) {
        ListBuffer<A> listBuffer = new ListBuffer<A>();
        for (A a : this) {
            if (!list.contains(a)) continue;
            listBuffer.append(a);
        }
        return listBuffer.toList();
    }

    public List<A> diff(List<A> list) {
        ListBuffer<A> listBuffer = new ListBuffer<A>();
        for (A a : this) {
            if (list.contains(a)) continue;
            listBuffer.append(a);
        }
        return listBuffer.toList();
    }

    public List<A> take(int n) {
        ListBuffer<A> listBuffer = new ListBuffer<A>();
        int n2 = 0;
        for (A a : this) {
            if (n2++ == n) break;
            listBuffer.append(a);
        }
        return listBuffer.toList();
    }

    public static <A> List<A> of(A a) {
        return new List<A>(a, List.nil());
    }

    public static <A> List<A> of(A a, A a2) {
        return new List<A>(a, List.of(a2));
    }

    public static <A> List<A> of(A a, A a2, A a3) {
        return new List<A>(a, List.of(a2, a3));
    }

    public static <A> List<A> of(A a, A a2, A a3, A ... AArray) {
        return new List<A>(a, new List<A>(a2, new List<A>(a3, List.from(AArray))));
    }

    public static <A> List<A> from(A[] AArray) {
        List<A> list = List.nil();
        if (AArray != null) {
            for (int i = AArray.length - 1; i >= 0; --i) {
                list = new List<A>(AArray[i], list);
            }
        }
        return list;
    }

    public static <A> List<A> from(Iterable<? extends A> iterable) {
        ListBuffer<A> listBuffer = new ListBuffer<A>();
        for (A a : iterable) {
            listBuffer.append(a);
        }
        return listBuffer.toList();
    }

    @Deprecated
    public static <A> List<A> fill(int n, A a) {
        List<A> list = List.nil();
        for (int i = 0; i < n; ++i) {
            list = new List<A>(a, list);
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        List<A> list = this;
        int n = 0;
        while (list.tail != null) {
            list = list.tail;
            ++n;
        }
        return n;
    }

    @Override
    public int size() {
        return this.length();
    }

    public List<A> setTail(List<A> list) {
        this.tail = list;
        return list;
    }

    public List<A> prepend(A a) {
        return new List<A>(a, this);
    }

    public List<A> prependList(List<A> list) {
        if (this.isEmpty()) {
            return list;
        }
        if (list.isEmpty()) {
            return this;
        }
        if (list.tail.isEmpty()) {
            return this.prepend(list.head);
        }
        List<A> list2 = this;
        List<A> list3 = list.reverse();
        Assert.check(list3 != list);
        while (list3.nonEmpty()) {
            List<A> list4 = list3;
            list3 = list3.tail;
            list4.setTail(list2);
            list2 = list4;
        }
        return list2;
    }

    public List<A> reverse() {
        if (this.isEmpty() || this.tail.isEmpty()) {
            return this;
        }
        List<A> list = List.nil();
        List<A> list2 = this;
        while (list2.nonEmpty()) {
            list = new List<A>(list2.head, list);
            list2 = list2.tail;
        }
        return list;
    }

    public List<A> append(A a) {
        return List.of(a).prependList(this);
    }

    public List<A> appendList(List<A> list) {
        return list.prependList(this);
    }

    public List<A> appendList(ListBuffer<A> listBuffer) {
        return this.appendList(listBuffer.toList());
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n;
        List<A> list = this;
        T[] TArray = objectArray;
        for (n = 0; list.nonEmpty() && n < objectArray.length; ++n) {
            TArray[n] = list.head;
            list = list.tail;
        }
        if (list.isEmpty()) {
            if (n < objectArray.length) {
                objectArray[n] = null;
            }
            return objectArray;
        }
        objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        return this.toArray(objectArray);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public String toString(String string) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.head);
        List<A> list = this.tail;
        while (list.nonEmpty()) {
            stringBuilder.append(string);
            stringBuilder.append(list.head);
            list = list.tail;
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toString(",");
    }

    @Override
    public int hashCode() {
        List<A> list = this;
        int n = 1;
        while (list.tail != null) {
            n = n * 31 + (list.head == null ? 0 : list.head.hashCode());
            list = list.tail;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return List.equals(this, list);
        }
        if (object instanceof java.util.List) {
            java.util.List list = (java.util.List)object;
            List<A> list2 = this;
            Iterator iterator = list.iterator();
            while (list2.tail != null && iterator.hasNext()) {
                Object e = iterator.next();
                if (!(list2.head != null ? list2.head.equals(e) : e == null)) {
                    return false;
                }
                list2 = list2.tail;
            }
            return list2.isEmpty() && !iterator.hasNext();
        }
        return false;
    }

    public static boolean equals(List<?> list, List<?> list2) {
        while (list.tail != null && list2.tail != null) {
            if (list.head == null ? list2.head != null : !list.head.equals(list2.head)) {
                return false;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return list.tail == null && list2.tail == null;
    }

    @Override
    public boolean contains(Object object) {
        List<A> list = this;
        while (list.tail != null) {
            if (object == null ? list.head == null : list.head.equals(object)) {
                return true;
            }
            list = list.tail;
        }
        return false;
    }

    public A last() {
        A a = null;
        List<A> list = this;
        while (list.tail != null) {
            a = list.head;
            list = list.tail;
        }
        return a;
    }

    public <Z> List<Z> map(Function<A, Z> function) {
        if (this.isEmpty()) {
            return this;
        }
        boolean bl = false;
        ListBuffer<Z> listBuffer = new ListBuffer<Z>();
        for (A a : this) {
            Z z = function.apply(a);
            listBuffer.append(z);
            bl |= z != a;
        }
        return bl ? listBuffer.toList() : this;
    }

    public static <T> List<T> convert(Class<T> clazz, List<?> list) {
        if (list == null) {
            return null;
        }
        for (Object obj : list) {
            clazz.cast(obj);
        }
        return list;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.tail == null) {
            return Iterators.emptyIterator();
        }
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = List.this;
            }

            @Override
            public boolean hasNext() {
                return this.elems.tail != null;
            }

            @Override
            public A next() {
                if (this.elems.tail == null) {
                    throw new NoSuchElementException();
                }
                Object a = this.elems.head;
                this.elems = this.elems.tail;
                return a;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public A get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        List<A> list = this;
        int n2 = n;
        while (n2-- > 0 && !list.isEmpty()) {
            list = list.tail;
        }
        if (list.isEmpty()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size());
        }
        return list.head;
    }

    @Override
    public boolean addAll(int n, Collection<? extends A> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public A set(int n, A a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, A a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public A remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        List<A> list = this;
        while (list.tail != null) {
            if (list.head == null ? object == null : list.head.equals(object)) {
                return n;
            }
            list = list.tail;
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = -1;
        int n2 = 0;
        List<A> list = this;
        while (list.tail != null) {
            if (list.head == null ? object == null : list.head.equals(object)) {
                n = n2;
            }
            list = list.tail;
            ++n2;
        }
        return n;
    }

    @Override
    public ListIterator<A> listIterator() {
        return Collections.unmodifiableList(new ArrayList(this)).listIterator();
    }

    @Override
    public ListIterator<A> listIterator(int n) {
        return Collections.unmodifiableList(new ArrayList(this)).listIterator(n);
    }

    @Override
    public java.util.List<A> subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IllegalArgumentException();
        }
        ArrayList<A> arrayList = new ArrayList<A>(n2 - n);
        List<A> list = this;
        for (int i = 0; list.tail != null && i != n2; ++i) {
            if (i >= n) {
                arrayList.add(list.head);
            }
            list = list.tail;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <Z> Collector<Z, ListBuffer<Z>, List<Z>> collector() {
        return Collector.of(ListBuffer::new, ListBuffer::add, (listBuffer, listBuffer2) -> {
            listBuffer.addAll(listBuffer2);
            return listBuffer;
        }, ListBuffer::toList, new Collector.Characteristics[0]);
    }
}

