/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JavacMessages
implements Messages {
    public static final Context.Key<JavacMessages> messagesKey = new Context.Key();
    private Map<Locale, SoftReference<List<ResourceBundle>>> bundleCache;
    private List<ResourceBundleHelper> bundleHelpers = List.nil();
    private Locale currentLocale;
    private List<ResourceBundle> currentBundles;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    private JCDiagnostic.Factory diagFactory;
    Context context;
    private static final String defaultBundleName = "com.sun.tools.javac.resources.compiler";
    private static ResourceBundle defaultBundle;
    private static JavacMessages defaultMessages;

    public static JavacMessages instance(Context context) {
        JavacMessages javacMessages = context.get(messagesKey);
        if (javacMessages == null) {
            javacMessages = new JavacMessages(context);
        }
        return javacMessages;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.currentBundles = this.getBundles(locale);
        this.currentLocale = locale;
    }

    public JavacMessages(Context context) {
        this(defaultBundleName, context.get(Locale.class));
        this.context = context;
        context.put(messagesKey, this);
        this.diagFormatter = new BasicDiagnosticFormatter(this);
        Options.instance(context).whenReady(this::initOptions);
    }

    private void initOptions(Options options) {
        boolean bl = options.isSet("rawDiagnostics");
        this.diagFormatter = bl ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this);
    }

    public JavacMessages(String string) throws MissingResourceException {
        this(string, null);
    }

    public JavacMessages(String string, Locale locale) throws MissingResourceException {
        this.bundleCache = new HashMap<Locale, SoftReference<List<ResourceBundle>>>();
        this.add(string);
        this.setCurrentLocale(locale);
    }

    public JavacMessages() throws MissingResourceException {
        this(defaultBundleName);
    }

    @Override
    public void add(String string) throws MissingResourceException {
        this.add((Locale locale) -> ResourceBundle.getBundle(string, locale));
    }

    public void add(ResourceBundleHelper resourceBundleHelper) {
        this.bundleHelpers = this.bundleHelpers.prepend(resourceBundleHelper);
        if (!this.bundleCache.isEmpty()) {
            this.bundleCache.clear();
        }
        this.currentBundles = null;
    }

    public List<ResourceBundle> getBundles(Locale locale) {
        List<ResourceBundle> list;
        if (locale == this.currentLocale && this.currentBundles != null) {
            return this.currentBundles;
        }
        SoftReference<List<ResourceBundle>> softReference = this.bundleCache.get(locale);
        List<ResourceBundle> list2 = list = softReference == null ? null : softReference.get();
        if (list == null) {
            list = List.nil();
            for (ResourceBundleHelper resourceBundleHelper : this.bundleHelpers) {
                try {
                    ResourceBundle resourceBundle = resourceBundleHelper.getResourceBundle(locale);
                    list = list.prepend(resourceBundle);
                }
                catch (MissingResourceException missingResourceException) {
                    throw new InternalError("Cannot find requested resource bundle for locale " + locale, missingResourceException);
                }
            }
            this.bundleCache.put(locale, new SoftReference<List<ResourceBundle>>(list));
        }
        return list;
    }

    public String getLocalizedString(String string, Object ... objectArray) {
        return this.getLocalizedString(this.currentLocale, string, objectArray);
    }

    public String getLocalizedString(JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        return this.getLocalizedString(this.currentLocale, diagnosticInfo);
    }

    @Override
    public String getLocalizedString(Locale locale, String string, Object ... objectArray) {
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        return JavacMessages.getLocalizedString(this.getBundles(locale), string, objectArray);
    }

    public String getLocalizedString(Locale locale, JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        return this.getLocalizedString(this.getBundles(locale), diagnosticInfo);
    }

    static String getDefaultLocalizedString(String string, Object ... objectArray) {
        return JavacMessages.getLocalizedString(List.of(JavacMessages.getDefaultBundle()), string, objectArray);
    }

    @Deprecated
    static JavacMessages getDefaultMessages() {
        if (defaultMessages == null) {
            defaultMessages = new JavacMessages(defaultBundleName);
        }
        return defaultMessages;
    }

    public static ResourceBundle getDefaultBundle() {
        try {
            if (defaultBundle == null) {
                defaultBundle = ResourceBundle.getBundle(defaultBundleName);
            }
            return defaultBundle;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for compiler is missing", missingResourceException);
        }
    }

    private static String getLocalizedString(List<ResourceBundle> list, String string, Object ... objectArray) {
        String string2 = null;
        List<ResourceBundle> list2 = list;
        while (list2.nonEmpty() && string2 == null) {
            ResourceBundle resourceBundle = (ResourceBundle)list2.head;
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            list2 = list2.tail;
        }
        if (string2 == null) {
            string2 = "compiler message file broken: key=" + string + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
        }
        return MessageFormat.format(string2, objectArray);
    }

    private String getLocalizedString(List<ResourceBundle> list, JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        String string = null;
        List<ResourceBundle> list2 = list;
        while (list2.nonEmpty() && string == null) {
            ResourceBundle resourceBundle = (ResourceBundle)list2.head;
            try {
                string = resourceBundle.getString(diagnosticInfo.key());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            list2 = list2.tail;
        }
        if (string == null) {
            string = "compiler message file broken: key=" + diagnosticInfo.key() + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
        }
        if (diagnosticInfo == CompilerProperties.Errors.Error) {
            return MessageFormat.format(string, new Object[0]);
        }
        return this.diagFormatter.format(this.getDiagFactory().create(DiagnosticSource.NO_SOURCE, null, diagnosticInfo), this.getCurrentLocale());
    }

    JCDiagnostic.Factory getDiagFactory() {
        if (this.diagFactory == null) {
            this.diagFactory = JCDiagnostic.Factory.instance(this.context);
        }
        return this.diagFactory;
    }

    public static interface ResourceBundleHelper {
        public ResourceBundle getResourceBundle(Locale var1);
    }
}

