/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterators {
    private static final Iterator<?> EMPTY = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY;
    }

    public static <I, O> Iterator<O> createCompoundIterator(Iterable<I> iterable, Function<I, Iterator<O>> function) {
        return new CompoundIterator<I, O>(iterable, function);
    }

    public static <E> Iterator<E> createFilterIterator(final Iterator<E> iterator, final Predicate<E> predicate) {
        return new Iterator<E>(){
            private E current = this.update();

            private E update() {
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!predicate.test(e)) continue;
                    return e;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public E next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object e = this.current;
                this.current = this.update();
                return e;
            }
        };
    }

    private static class CompoundIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> inputs;
        private final Function<I, Iterator<O>> converter;
        private Iterator<O> currentIterator = Iterators.emptyIterator();

        public CompoundIterator(Iterable<I> iterable, Function<I, Iterator<O>> function) {
            this.inputs = iterable.iterator();
            this.converter = function;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                if (!this.inputs.hasNext()) break;
                this.currentIterator = this.converter.apply(this.inputs.next());
            }
            return false;
        }

        @Override
        public O next() {
            while (!this.currentIterator.hasNext() && this.inputs.hasNext()) {
                this.currentIterator = this.converter.apply(this.inputs.next());
            }
            return this.currentIterator.next();
        }
    }
}

