/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;

public class Convert {
    public static int string2int(String string, int n) throws NumberFormatException {
        if (n == 10) {
            return Integer.parseInt(string, n);
        }
        char[] cArray = string.toCharArray();
        int n2 = Integer.MAX_VALUE / (n / 2);
        int n3 = 0;
        for (char c : cArray) {
            int n4 = Character.digit(c, n);
            if (n3 < 0 || n3 > n2 || n3 * n > Integer.MAX_VALUE - n4) {
                throw new NumberFormatException();
            }
            n3 = n3 * n + n4;
        }
        return n3;
    }

    public static long string2long(String string, int n) throws NumberFormatException {
        if (n == 10) {
            return Long.parseLong(string, n);
        }
        char[] cArray = string.toCharArray();
        long l = Long.MAX_VALUE / (long)(n / 2);
        long l2 = 0L;
        for (char c : cArray) {
            int n2 = Character.digit(c, n);
            if (l2 < 0L || l2 > l || l2 * (long)n > Long.MAX_VALUE - (long)n2) {
                throw new NumberFormatException();
            }
            l2 = l2 * (long)n + (long)n2;
        }
        return l2;
    }

    public static void utfValidate(byte[] byArray, int n, int n2, Validation validation) throws InvalidUtfException {
        Convert.utf2chars(byArray, n, null, 0, n2, validation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int utf2chars(byte[] byArray, int n, char[] cArray, int n2, int n3, Validation validation) throws InvalidUtfException {
        int n4 = n2;
        while (n3-- > 0) {
            int n5;
            int n6 = n;
            if ((n5 = byArray[n++]) < 0) {
                byte by;
                if ((n5 & 0xE0) == 192) {
                    if (n3-- > 0) {
                        by = byArray[n++];
                    } else {
                        if (!validation.allowAnything()) throw new InvalidUtfException(n6);
                        by = 0;
                    }
                    if (!validation.allowAnything() && (by & 0xC0) != 128) {
                        throw new InvalidUtfException(n6);
                    }
                    n5 = (n5 & 0x1F) << 6 | by & 0x3F;
                    if (!validation.allowLongEncoding() && (n5 & 0xFFFFFF80) == 0 && n5 != 0) {
                        throw new InvalidUtfException(n6);
                    }
                } else if ((n5 & 0xF0) == 224) {
                    byte by2;
                    if ((n3 -= 2) >= 0) {
                        by = byArray[n++];
                        by2 = byArray[n++];
                    } else {
                        if (!validation.allowAnything()) throw new InvalidUtfException(n6);
                        by = 0;
                        by2 = 0;
                    }
                    if (!(validation.allowAnything() || (by & 0xC0) == 128 && (by2 & 0xC0) == 128)) {
                        throw new InvalidUtfException(n6);
                    }
                    n5 = (n5 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F;
                    if (!validation.allowLongEncoding() && (n5 & 0xFFFFF800) == 0) {
                        throw new InvalidUtfException(n6);
                    }
                } else {
                    if (!validation.allowAnything()) throw new InvalidUtfException(n6);
                    n5 &= 0xFF;
                }
            } else if (!validation.allowSingleByteNul() && n5 == 0) {
                throw new InvalidUtfException(n6);
            }
            if (cArray != null) {
                cArray[n2] = (char)n5;
            }
            ++n2;
        }
        return n2 - n4;
    }

    public static char[] utf2chars(byte[] byArray, int n, int n2, Validation validation) throws InvalidUtfException {
        char[] cArray = new char[n2];
        int n3 = Convert.utf2chars(byArray, n, cArray, 0, n2, validation);
        if (n3 == n2) {
            return cArray;
        }
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, 0, cArray2, 0, n3);
        return cArray2;
    }

    public static String utf2string(byte[] byArray, int n, int n2, Validation validation) throws InvalidUtfException {
        char[] cArray = new char[n2];
        int n3 = Convert.utf2chars(byArray, n, cArray, 0, n2, validation);
        return new String(cArray, 0, n3);
    }

    public static int utfNumChars(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            if ((byArray[n++] & 0xC0) == 128) continue;
            ++n3;
        }
        return n3;
    }

    public static int chars2utf(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n + n3;
        for (int i = n; i < n5; ++i) {
            char c = cArray[i];
            if ('\u0001' <= c && c <= '\u007f') {
                byArray[n4++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c >> 6);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n4++] = (byte)(0xE0 | c >> 12);
            byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n4++] = (byte)(0x80 | c & 0x3F);
        }
        return n4;
    }

    public static byte[] chars2utf(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2 * 3];
        int n3 = Convert.chars2utf(cArray, n, byArray, 0, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] chars2utf(char[] cArray) {
        return Convert.chars2utf(cArray, 0, cArray.length);
    }

    public static byte[] string2utf(String string) {
        return Convert.chars2utf(string.toCharArray());
    }

    public static String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(Convert.quote(string.charAt(i), false));
        }
        return stringBuilder.toString();
    }

    public static String quote(char c, boolean bl) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return bl ? "\\'" : "'";
            }
            case '\"': {
                return bl ? "\"" : "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Convert.isPrintableAscii(c) ? String.valueOf(c) : String.format("\\u%04x", c);
    }

    private static boolean isPrintableAscii(char c) {
        return c >= ' ' && c <= '~';
    }

    public static String escapeUnicode(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u00ff') {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, n2));
                while (n2 < n) {
                    c = string.charAt(n2);
                    if (c > '\u00ff') {
                        stringBuilder.append("\\u");
                        stringBuilder.append(Character.forDigit((c >> 12) % 16, 16));
                        stringBuilder.append(Character.forDigit((c >> 8) % 16, 16));
                        stringBuilder.append(Character.forDigit((c >> 4) % 16, 16));
                        stringBuilder.append(Character.forDigit(c % 16, 16));
                    } else {
                        stringBuilder.append(c);
                    }
                    ++n2;
                }
                string = stringBuilder.toString();
                continue;
            }
            ++n2;
        }
        return string;
    }

    public static Name shortName(Name name) {
        int n = name.lastIndexOfAscii('.') + 1;
        return n > 0 ? name.subName(n) : name;
    }

    public static String shortName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static Name packagePart(Name name) {
        int n = Math.max(name.lastIndexOfAscii('.'), 0);
        return name.subName(0, n);
    }

    public static String packagePart(String string) {
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(0, n);
    }

    public static List<Name> enclosingCandidates(Name name) {
        int n;
        List<Name> list = List.nil();
        while ((n = name.lastIndexOfAscii('$')) > 0) {
            name = name.subName(0, n);
            list = list.prepend(name);
        }
        return list;
    }

    public static List<Name> classCandidates(Name name) {
        List<Name> list = List.nil();
        String string = name.toString();
        int n = -1;
        while ((n = string.indexOf(46, n + 1)) > 0) {
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1).replace('.', '$');
            list = list.prepend(name.table.names.fromString(string2 + string3));
        }
        return list.reverse();
    }

    public static enum Validation {
        NONE(true, true, true),
        PREJDK14(true, true, false),
        STRICT(false, false, false);

        private final boolean allowSingleByteNul;
        private final boolean allowLongEncoding;
        private final boolean allowAnything;

        private Validation(boolean bl, boolean bl2, boolean bl3) {
            this.allowSingleByteNul = bl;
            this.allowLongEncoding = bl2;
            this.allowAnything = bl3;
        }

        public boolean allowSingleByteNul() {
            return this.allowSingleByteNul;
        }

        public boolean allowLongEncoding() {
            return this.allowLongEncoding;
        }

        public boolean allowAnything() {
            return this.allowAnything;
        }
    }
}

