/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;

public class Constants {
    public static Object decode(Object object, Type type) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            int n2 = n;
            switch (type.getTag()) {
                case BOOLEAN: {
                    return n2 != 0;
                }
                case CHAR: {
                    return Character.valueOf((char)n2);
                }
                case BYTE: {
                    return (byte)n2;
                }
                case SHORT: {
                    return (short)n2;
                }
            }
        }
        return object;
    }

    public static String format(Object object, Type type) {
        object = Constants.decode(object, type);
        switch (type.getTag()) {
            case BYTE: {
                return Constants.formatByte((Byte)object);
            }
            case LONG: {
                return Constants.formatLong((Long)object);
            }
            case FLOAT: {
                return Constants.formatFloat(((Float)object).floatValue());
            }
            case DOUBLE: {
                return Constants.formatDouble((Double)object);
            }
            case CHAR: {
                return Constants.formatChar(((Character)object).charValue());
            }
        }
        if (object instanceof String) {
            String string = (String)object;
            return Constants.formatString(string);
        }
        return object + "";
    }

    public static String format(Object object) {
        if (object instanceof Byte) {
            Byte by = (Byte)object;
            return Constants.formatByte(by);
        }
        if (object instanceof Short) {
            Short s = (Short)object;
            return Constants.formatShort(s);
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return Constants.formatLong(l);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return Constants.formatFloat(f.floatValue());
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return Constants.formatDouble(d);
        }
        if (object instanceof Character) {
            Character c = (Character)object;
            return Constants.formatChar(c.charValue());
        }
        if (object instanceof String) {
            String string = (String)object;
            return Constants.formatString(string);
        }
        if (object instanceof Integer || object instanceof Boolean) {
            return object.toString();
        }
        throw new IllegalArgumentException("Argument is not a primitive type or a string; it " + (object == null ? "is a null value." : "has class " + object.getClass().getName()) + ".");
    }

    private static String formatByte(byte by) {
        return String.format("(byte)0x%02x", by);
    }

    private static String formatShort(short s) {
        return String.format("(short)%d", s);
    }

    private static String formatLong(long l) {
        return l + "L";
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        return f + "f";
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        return d + "";
    }

    private static String formatChar(char c) {
        return '\'' + Convert.quote(c, true) + '\'';
    }

    private static String formatString(String string) {
        return '\"' + Convert.quote(string) + '\"';
    }
}

