/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int n) {
        this(new byte[n]);
    }

    public ByteBuffer(byte[] byArray) {
        this.elems = byArray;
    }

    public void appendByte(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length);
        this.elems[this.length++] = (byte)n;
    }

    public void appendBytes(byte[] byArray, int n, int n2) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + n2);
        System.arraycopy(byArray, n, this.elems, this.length, n2);
        this.length += n2;
    }

    public void appendBytes(byte[] byArray) {
        this.appendBytes(byArray, 0, byArray.length);
    }

    public void appendChar(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 1);
        this.elems[this.length] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(n & 0xFF);
        this.length += 2;
    }

    public void appendInt(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 3);
        this.elems[this.length] = (byte)(n >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(n >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(n & 0xFF);
        this.length += 4;
    }

    public void appendLong(long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendFloat(float f) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeFloat(f);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendDouble(double d) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeDouble(d);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendName(Name name) {
        int n = name.getUtf8Length();
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + n);
        name.getUtf8Bytes(this.elems, this.length);
        this.length += n;
    }

    public void appendStream(InputStream inputStream) throws IOException {
        while (true) {
            int n = Math.max(inputStream.available(), 64);
            this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + n);
            int n2 = inputStream.read(this.elems, this.length, n);
            if (n2 == -1) break;
            this.length += n2;
            if (n2 != n) continue;
            int n3 = inputStream.read();
            if (n3 == -1) break;
            this.elems[this.length++] = (byte)n3;
        }
    }

    public int getInt(int n) throws UnderflowException {
        this.verifyRange(n, 4);
        return ((this.elems[n] & 0xFF) << 24) + ((this.elems[n + 1] & 0xFF) << 16) + ((this.elems[n + 2] & 0xFF) << 8) + (this.elems[n + 3] & 0xFF);
    }

    public long getLong(int n) throws UnderflowException {
        this.verifyRange(n, 8);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.elems, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public float getFloat(int n) throws UnderflowException {
        this.verifyRange(n, 4);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.elems, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public double getDouble(int n) throws UnderflowException {
        this.verifyRange(n, 8);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.elems, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public char getChar(int n) throws UnderflowException {
        this.verifyRange(n, 2);
        return (char)(((this.elems[n] & 0xFF) << 8) + (this.elems[n + 1] & 0xFF));
    }

    public byte getByte(int n) throws UnderflowException {
        this.verifyRange(n, 1);
        return this.elems[n];
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName(Names names) throws InvalidUtfException {
        return names.fromUtf(this.elems, 0, this.length, Convert.Validation.STRICT);
    }

    public void verifyRange(int n, int n2) throws UnderflowException {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("off=" + n + ", len=" + n2);
        }
        if (n + n2 < 0 || n + n2 > this.length) {
            throw new UnderflowException(this.length);
        }
    }

    public java.nio.ByteBuffer asByteBuffer() {
        return java.nio.ByteBuffer.wrap(this.elems, 0, this.length);
    }

    public static class UnderflowException
    extends Exception {
        private static final long serialVersionUID = 0L;
        private final int length;

        public UnderflowException(int n) {
            this.length = n;
        }

        public int getLength() {
            return this.length;
        }
    }
}

