/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.ModuleTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;

public class Pretty
extends JCTree.Visitor {
    private final boolean sourceOutput;
    Writer out;
    public int width = 4;
    int lmargin = 0;
    Name enclClassName;
    DocCommentTable docComments = null;
    private static final String trimSequence = "[...]";
    private static final int PREFERRED_LENGTH = 20;
    String lineSep = System.getProperty("line.separator");
    int prec;

    public Pretty(Writer writer, boolean bl) {
        this.out = writer;
        this.sourceOutput = bl;
    }

    void align() throws IOException {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.write(" ");
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(int n, int n2) throws IOException {
        if (n2 < n) {
            this.out.write("(");
        }
    }

    void close(int n, int n2) throws IOException {
        if (n2 < n) {
            this.out.write(")");
        }
    }

    public void print(Object object) throws IOException {
        this.out.write(Convert.escapeUnicode(object.toString()));
    }

    private void print(char c) throws IOException {
        this.out.write(c);
    }

    public void println() throws IOException {
        this.out.write(this.lineSep);
    }

    public static String toSimpleString(JCTree jCTree) {
        return Pretty.toSimpleString(jCTree, 20);
    }

    public static String toSimpleString(JCTree jCTree, int n) {
        StringWriter stringWriter = new StringWriter();
        try {
            new Pretty(stringWriter, false).printExpr(jCTree);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        String string = stringWriter.toString().trim().replaceAll("\\s+", " ").replaceAll("/\\*missing\\*/", "");
        if (string.length() < n) {
            return string;
        }
        int n2 = (n - trimSequence.length()) * 2 / 3;
        int n3 = n - trimSequence.length() - n2;
        return string.substring(0, n2) + trimSequence + string.substring(string.length() - n3);
    }

    public void printExpr(JCTree jCTree, int n) throws IOException {
        int n2 = this.prec;
        try {
            this.prec = n;
            if (jCTree == null) {
                this.print("/*missing*/");
            } else {
                jCTree.accept(this);
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
        finally {
            this.prec = n2;
        }
    }

    public void printExpr(JCTree jCTree) throws IOException {
        this.printExpr(jCTree, 0);
    }

    public void printStat(JCTree jCTree) throws IOException {
        this.printExpr(jCTree, -1);
    }

    public <T extends JCTree> void printExprs(List<T> list, String string) throws IOException {
        if (list.nonEmpty()) {
            this.printExpr((JCTree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(string);
                this.printExpr((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public <T extends JCTree> void printExprs(List<T> list) throws IOException {
        this.printExprs(list, ", ");
    }

    public void printPattern(JCTree jCTree) throws IOException {
        this.printExpr(jCTree);
    }

    public void printStats(List<? extends JCTree> list) throws IOException {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.align();
            this.printStat((JCTree)list2.head);
            this.println();
            list2 = list2.tail;
        }
    }

    public void printFlags(long l) throws IOException {
        if ((l & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(l));
        if ((l & 0xC000080000000FFFL) != 0L) {
            this.print(' ');
        }
        if ((l & 0x2000L) != 0L) {
            this.print('@');
        }
    }

    public void printAnnotations(List<JCTree.JCAnnotation> list) throws IOException {
        List<JCTree.JCAnnotation> list2 = list;
        while (list2.nonEmpty()) {
            this.printStat((JCTree)list2.head);
            this.println();
            this.align();
            list2 = list2.tail;
        }
    }

    public void printTypeAnnotations(List<JCTree.JCAnnotation> list) throws IOException {
        List<JCTree.JCAnnotation> list2 = list;
        while (list2.nonEmpty()) {
            this.printExpr((JCTree)list2.head);
            this.print(' ');
            list2 = list2.tail;
        }
    }

    public void printDocComment(JCTree jCTree) throws IOException {
        String string;
        if (this.docComments != null && (string = this.docComments.getCommentText(jCTree)) != null) {
            this.print("/**");
            this.println();
            int n = 0;
            int n2 = Pretty.lineEndPos(string, n);
            while (n < string.length()) {
                this.align();
                this.print(" *");
                if (n < string.length() && string.charAt(n) > ' ') {
                    this.print(' ');
                }
                this.print(string.substring(n, n2));
                this.println();
                n = n2 + 1;
                n2 = Pretty.lineEndPos(string, n);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String string, int n) {
        int n2 = string.indexOf(10, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        return n2;
    }

    public void printTypeParameters(List<JCTree.JCTypeParameter> list) throws IOException {
        if (list.nonEmpty()) {
            this.print('<');
            this.printExprs(list);
            this.print('>');
        }
    }

    public void printBlock(List<? extends JCTree> list) throws IOException {
        this.print('{');
        this.println();
        this.indent();
        this.printStats(list);
        this.undent();
        this.align();
        this.print('}');
    }

    public void printEnumBody(List<JCTree> list) throws IOException {
        this.print('{');
        this.println();
        this.indent();
        boolean bl = true;
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            if (this.isEnumerator((JCTree)list2.head)) {
                if (!bl) {
                    this.print(',');
                    this.println();
                }
                this.align();
                this.printStat((JCTree)list2.head);
                bl = false;
            }
            list2 = list2.tail;
        }
        this.print(';');
        this.println();
        list2 = list;
        while (list2.nonEmpty()) {
            if (!this.isEnumerator((JCTree)list2.head)) {
                this.align();
                this.printStat((JCTree)list2.head);
                this.println();
            }
            list2 = list2.tail;
        }
        this.undent();
        this.align();
        this.print('}');
    }

    boolean isEnumerator(JCTree jCTree) {
        return jCTree.hasTag(JCTree.Tag.VARDEF) && (((JCTree.JCVariableDecl)jCTree).mods.flags & 0x4000L) != 0L;
    }

    public void printUnit(JCTree.JCCompilationUnit jCCompilationUnit, JCTree.JCClassDecl jCClassDecl) throws IOException {
        this.docComments = jCCompilationUnit.docComments;
        this.printDocComment(jCCompilationUnit);
        boolean bl = true;
        List<JCTree> list = jCCompilationUnit.defs;
        while (list.nonEmpty() && (jCClassDecl == null || ((JCTree)list.head).hasTag(JCTree.Tag.IMPORT) || ((JCTree)list.head).hasTag(JCTree.Tag.PACKAGEDEF))) {
            Object object = list.head;
            if (object instanceof JCTree.JCImportBase) {
                JCTree.JCImportBase jCImportBase = (JCTree.JCImportBase)object;
                if ((object = TreeInfo.name(jCImportBase.getQualifiedIdentifier())) == ((Name)object).table.names.asterisk || jCClassDecl == null || jCImportBase instanceof JCTree.JCModuleImport || this.isUsed(TreeInfo.symbol(jCImportBase.getQualifiedIdentifier()), jCClassDecl)) {
                    if (bl) {
                        bl = false;
                        this.println();
                    }
                    this.printStat(jCImportBase);
                }
            } else {
                this.printStat((JCTree)list.head);
            }
            list = list.tail;
        }
        if (jCClassDecl != null) {
            this.printStat(jCClassDecl);
            this.println();
        }
    }

    boolean isUsed(final Symbol symbol, JCTree jCTree) {
        class UsedVisitor
        extends TreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(JCTree jCTree) {
                if (jCTree != null && !this.result) {
                    jCTree.accept(this);
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                if (jCIdent.sym == symbol) {
                    this.result = true;
                }
            }
        }
        UsedVisitor usedVisitor = new UsedVisitor();
        usedVisitor.scan(jCTree);
        return usedVisitor.result;
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        try {
            this.printUnit(jCCompilationUnit, null);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitPackageDef(JCTree.JCPackageDecl jCPackageDecl) {
        try {
            this.printDocComment(jCPackageDecl);
            this.printAnnotations(jCPackageDecl.annotations);
            if (jCPackageDecl.pid != null) {
                this.print("package ");
                this.printExpr(jCPackageDecl.pid);
                this.print(';');
                this.println();
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        try {
            this.printDocComment(jCModuleDecl);
            this.printAnnotations(jCModuleDecl.mods.annotations);
            if (jCModuleDecl.getModuleType() == ModuleTree.ModuleKind.OPEN) {
                this.print("open ");
            }
            this.print("module ");
            this.printExpr(jCModuleDecl.qualId);
            if (jCModuleDecl.directives == null) {
                this.print(';');
            } else {
                this.print(' ');
                this.printBlock(jCModuleDecl.directives);
            }
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitExports(JCTree.JCExports jCExports) {
        try {
            this.print("exports ");
            this.printExpr(jCExports.qualid);
            if (jCExports.moduleNames != null) {
                this.print(" to ");
                this.printExprs(jCExports.moduleNames);
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitOpens(JCTree.JCOpens jCOpens) {
        try {
            this.print("opens ");
            this.printExpr(jCOpens.qualid);
            if (jCOpens.moduleNames != null) {
                this.print(" to ");
                this.printExprs(jCOpens.moduleNames);
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitProvides(JCTree.JCProvides jCProvides) {
        try {
            this.print("provides ");
            this.printExpr(jCProvides.serviceName);
            this.print(" with ");
            this.printExprs(jCProvides.implNames);
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitRequires(JCTree.JCRequires jCRequires) {
        try {
            this.print("requires ");
            if (jCRequires.isStaticPhase) {
                this.print("static ");
            }
            if (jCRequires.isTransitive) {
                this.print("transitive ");
            }
            this.printExpr(jCRequires.moduleName);
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitUses(JCTree.JCUses jCUses) {
        try {
            this.print("uses ");
            this.printExpr(jCUses.qualid);
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
        try {
            this.print("import ");
            if (jCImport.staticImport) {
                this.print("static ");
            }
            this.printExpr(jCImport.qualid);
            this.print(';');
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitModuleImport(JCTree.JCModuleImport jCModuleImport) {
        try {
            this.print("import module ");
            this.printExpr(jCModuleImport.module);
            this.print(';');
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        try {
            this.println();
            this.align();
            this.printDocComment(jCClassDecl);
            this.printAnnotations(jCClassDecl.mods.annotations);
            this.printFlags(jCClassDecl.mods.flags & 0xFFFFFFFFFFFFFDFFL);
            Name name = this.enclClassName;
            this.enclClassName = jCClassDecl.name;
            if ((jCClassDecl.mods.flags & 0x200L) != 0L) {
                this.print("interface ");
                this.print(jCClassDecl.name);
                this.printTypeParameters(jCClassDecl.typarams);
                if (jCClassDecl.implementing.nonEmpty()) {
                    this.print(" extends ");
                    this.printExprs(jCClassDecl.implementing);
                }
                if (jCClassDecl.permitting.nonEmpty()) {
                    this.print(" permits ");
                    this.printExprs(jCClassDecl.permitting);
                }
            } else {
                if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                    this.print("enum ");
                } else {
                    this.print("class ");
                }
                this.print(jCClassDecl.name);
                this.printTypeParameters(jCClassDecl.typarams);
                if (jCClassDecl.extending != null) {
                    this.print(" extends ");
                    this.printExpr(jCClassDecl.extending);
                }
                if (jCClassDecl.implementing.nonEmpty()) {
                    this.print(" implements ");
                    this.printExprs(jCClassDecl.implementing);
                }
                if (jCClassDecl.permitting.nonEmpty()) {
                    this.print(" permits ");
                    this.printExprs(jCClassDecl.permitting);
                }
            }
            this.print(' ');
            if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                this.printEnumBody(jCClassDecl.defs);
            } else {
                this.printBlock(jCClassDecl.defs);
            }
            this.enclClassName = name;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        try {
            if (jCMethodDecl.name == jCMethodDecl.name.table.names.init && this.enclClassName == null && this.sourceOutput) {
                return;
            }
            this.println();
            this.align();
            this.printDocComment(jCMethodDecl);
            this.printExpr(jCMethodDecl.mods);
            this.printTypeParameters(jCMethodDecl.typarams);
            if (jCMethodDecl.name == jCMethodDecl.name.table.names.init) {
                this.print(this.enclClassName != null ? this.enclClassName : jCMethodDecl.name);
            } else {
                this.printExpr(jCMethodDecl.restype);
                this.print(' ');
                this.print(jCMethodDecl.name);
            }
            this.print('(');
            if (jCMethodDecl.recvparam != null) {
                this.printExpr(jCMethodDecl.recvparam);
                if (jCMethodDecl.params.size() > 0) {
                    this.print(", ");
                }
            }
            this.printExprs(jCMethodDecl.params);
            this.print(')');
            if (jCMethodDecl.thrown.nonEmpty()) {
                this.print(" throws ");
                this.printExprs(jCMethodDecl.thrown);
            }
            if (jCMethodDecl.defaultValue != null) {
                this.print(" default ");
                this.printExpr(jCMethodDecl.defaultValue);
            }
            if (jCMethodDecl.body != null) {
                this.print(' ');
                this.printStat(jCMethodDecl.body);
            } else {
                this.print(';');
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        try {
            if (this.docComments != null && this.docComments.hasComment(jCVariableDecl)) {
                this.println();
                this.align();
            }
            this.printDocComment(jCVariableDecl);
            if ((jCVariableDecl.mods.flags & 0x4000L) != 0L) {
                this.print("/*public static final*/ ");
                this.print(jCVariableDecl.name);
                if (jCVariableDecl.init != null) {
                    if (jCVariableDecl.init.hasTag(JCTree.Tag.NEWCLASS)) {
                        JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)jCVariableDecl.init;
                        if (this.sourceOutput) {
                            this.print(" /*enum*/ ");
                            if (jCNewClass.args != null && jCNewClass.args.nonEmpty()) {
                                this.print('(');
                                this.print(jCNewClass.args);
                                this.print(')');
                            }
                            if (jCNewClass.def != null && jCNewClass.def.defs != null) {
                                this.print(' ');
                                this.printBlock(jCNewClass.def.defs);
                            }
                            return;
                        }
                        this.print(" /* = ");
                        this.print("new ");
                        if (jCNewClass.def != null && jCNewClass.def.mods.annotations.nonEmpty()) {
                            this.printTypeAnnotations(jCNewClass.def.mods.annotations);
                        }
                        this.printExpr(jCNewClass.clazz);
                        this.print('(');
                        this.printExprs(jCNewClass.args);
                        this.print(')');
                        this.print(" */");
                        this.print(" /*enum*/ ");
                        if (jCNewClass.args != null && jCNewClass.args.nonEmpty()) {
                            this.print('(');
                            this.printExprs(jCNewClass.args);
                            this.print(')');
                        }
                        if (jCNewClass.def != null && jCNewClass.def.defs != null) {
                            this.print(' ');
                            this.printBlock(jCNewClass.def.defs);
                        }
                        return;
                    }
                    this.print(" /* = ");
                    this.printExpr(jCVariableDecl.init);
                    this.print(" */");
                }
            } else {
                this.printExpr(jCVariableDecl.mods);
                if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
                    JCTree.JCExpression jCExpression = jCVariableDecl.vartype;
                    List<JCTree.JCAnnotation> list = null;
                    if (jCExpression instanceof JCTree.JCAnnotatedType) {
                        JCTree.JCAnnotatedType jCAnnotatedType = (JCTree.JCAnnotatedType)jCExpression;
                        list = jCAnnotatedType.annotations;
                        jCExpression = jCAnnotatedType.underlyingType;
                    }
                    this.printExpr(((JCTree.JCArrayTypeTree)jCExpression).elemtype);
                    if (list != null) {
                        this.print(' ');
                        this.printTypeAnnotations(list);
                    }
                    this.print("... ");
                    this.print(jCVariableDecl.name);
                } else {
                    this.printExpr(jCVariableDecl.vartype);
                    this.print(' ');
                    if (jCVariableDecl.name.length() == 0) {
                        this.print('_');
                    } else {
                        this.print(jCVariableDecl.name);
                    }
                }
                if (jCVariableDecl.init != null) {
                    this.print(" = ");
                    this.printExpr(jCVariableDecl.init);
                }
                if (this.prec == -1) {
                    this.print(';');
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
        try {
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        try {
            this.printFlags(jCBlock.flags);
            this.printBlock(jCBlock.stats);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        try {
            this.print("do ");
            this.printStat(jCDoWhileLoop.body);
            this.align();
            this.print(" while ");
            if (jCDoWhileLoop.cond.hasTag(JCTree.Tag.PARENS)) {
                this.printExpr(jCDoWhileLoop.cond);
            } else {
                this.print('(');
                this.printExpr(jCDoWhileLoop.cond);
                this.print(')');
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        try {
            this.print("while ");
            if (jCWhileLoop.cond.hasTag(JCTree.Tag.PARENS)) {
                this.printExpr(jCWhileLoop.cond);
            } else {
                this.print('(');
                this.printExpr(jCWhileLoop.cond);
                this.print(')');
            }
            this.print(' ');
            this.printStat(jCWhileLoop.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        try {
            this.print("for (");
            if (jCForLoop.init.nonEmpty()) {
                if (((JCTree.JCStatement)jCForLoop.init.head).hasTag(JCTree.Tag.VARDEF)) {
                    this.printExpr((JCTree)jCForLoop.init.head);
                    List list = jCForLoop.init.tail;
                    while (list.nonEmpty()) {
                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                        this.print(", ");
                        this.print(jCVariableDecl.name);
                        if (jCVariableDecl.init != null) {
                            this.print(" = ");
                            this.printExpr(jCVariableDecl.init);
                        }
                        list = list.tail;
                    }
                } else {
                    this.printExprs(jCForLoop.init);
                }
            }
            this.print("; ");
            if (jCForLoop.cond != null) {
                this.printExpr(jCForLoop.cond);
            }
            this.print("; ");
            this.printExprs(jCForLoop.step);
            this.print(") ");
            this.printStat(jCForLoop.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        try {
            this.print("for (");
            this.printExpr(jCEnhancedForLoop.var);
            this.print(" : ");
            this.printExpr(jCEnhancedForLoop.expr);
            this.print(") ");
            this.printStat(jCEnhancedForLoop.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        try {
            this.print(jCLabeledStatement.label);
            this.print(": ");
            this.printStat(jCLabeledStatement.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        try {
            this.print("switch ");
            if (jCSwitch.selector.hasTag(JCTree.Tag.PARENS)) {
                this.printExpr(jCSwitch.selector);
            } else {
                this.print('(');
                this.printExpr(jCSwitch.selector);
                this.print(')');
            }
            this.print(" {");
            this.println();
            this.printStats(jCSwitch.cases);
            this.align();
            this.print('}');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        try {
            if (jCCase.labels.size() == 1 && jCCase.labels.get(0).hasTag(JCTree.Tag.DEFAULTCASELABEL)) {
                this.print("default");
            } else {
                this.print("case ");
                this.printExprs(jCCase.labels);
            }
            if (jCCase.guard != null) {
                this.print(" when ");
                this.print(jCCase.guard);
            }
            if (jCCase.caseKind == JCTree.JCCase.STATEMENT) {
                this.print(':');
                this.println();
                this.indent();
                this.printStats(jCCase.stats);
                this.undent();
                this.align();
            } else {
                this.print(" -> ");
                if (jCCase.stats.size() == 1) {
                    this.printStat((JCTree)jCCase.stats.head);
                } else {
                    this.printBlock(jCCase.stats);
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel jCDefaultCaseLabel) {
        try {
            this.print("default");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel jCConstantCaseLabel) {
        try {
            this.print(jCConstantCaseLabel.expr);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel jCPatternCaseLabel) {
        try {
            this.print(jCPatternCaseLabel.pat);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
        try {
            this.print("switch ");
            if (jCSwitchExpression.selector.hasTag(JCTree.Tag.PARENS)) {
                this.printExpr(jCSwitchExpression.selector);
            } else {
                this.print('(');
                this.printExpr(jCSwitchExpression.selector);
                this.print(')');
            }
            this.print(" {");
            this.println();
            this.printStats(jCSwitchExpression.cases);
            this.align();
            this.print('}');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
        try {
            this.printExpr(jCBindingPattern.var);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAnyPattern(JCTree.JCAnyPattern jCAnyPattern) {
        try {
            this.print('_');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern jCRecordPattern) {
        try {
            this.printExpr(jCRecordPattern.deconstructor);
            this.print('(');
            this.printExprs(jCRecordPattern.nested);
            this.print(')');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        try {
            this.print("synchronized ");
            if (jCSynchronized.lock.hasTag(JCTree.Tag.PARENS)) {
                this.printExpr(jCSynchronized.lock);
            } else {
                this.print('(');
                this.printExpr(jCSynchronized.lock);
                this.print(')');
            }
            this.print(' ');
            this.printStat(jCSynchronized.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTry(JCTree.JCTry jCTry) {
        try {
            this.print("try ");
            if (jCTry.resources.nonEmpty()) {
                this.print('(');
                boolean bl = true;
                for (JCTree jCTree : jCTry.resources) {
                    if (!bl) {
                        this.println();
                        this.indent();
                    }
                    this.printStat(jCTree);
                    bl = false;
                }
                this.print(") ");
            }
            this.printStat(jCTry.body);
            List<JCTree.JCCatch> list = jCTry.catchers;
            while (list.nonEmpty()) {
                this.printStat((JCTree)list.head);
                list = list.tail;
            }
            if (jCTry.finalizer != null) {
                this.print(" finally ");
                this.printStat(jCTry.finalizer);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch jCCatch) {
        try {
            this.print(" catch (");
            this.printExpr(jCCatch.param);
            this.print(") ");
            this.printStat(jCCatch.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        try {
            this.open(this.prec, 3);
            this.printExpr(jCConditional.cond, 4);
            this.print(" ? ");
            this.printExpr(jCConditional.truepart);
            this.print(" : ");
            this.printExpr(jCConditional.falsepart, 3);
            this.close(this.prec, 3);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        try {
            this.print("if ");
            if (jCIf.cond.hasTag(JCTree.Tag.PARENS)) {
                this.printExpr(jCIf.cond);
            } else {
                this.print('(');
                this.printExpr(jCIf.cond);
                this.print(')');
            }
            this.print(' ');
            this.printStat(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                this.print(" else ");
                this.printStat(jCIf.elsepart);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        try {
            this.printExpr(jCExpressionStatement.expr);
            if (this.prec == -1) {
                this.print(';');
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        try {
            this.print("break");
            if (jCBreak.label != null) {
                this.print(' ');
                this.print(jCBreak.label);
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitYield(JCTree.JCYield jCYield) {
        try {
            this.print("yield");
            this.print(' ');
            this.printExpr(jCYield.value);
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        try {
            this.print("continue");
            if (jCContinue.label != null) {
                this.print(' ');
                this.print(jCContinue.label);
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        try {
            this.print("return");
            if (jCReturn.expr != null) {
                this.print(' ');
                this.printExpr(jCReturn.expr);
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        try {
            this.print("throw ");
            this.printExpr(jCThrow.expr);
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        try {
            this.print("assert ");
            this.printExpr(jCAssert.cond);
            if (jCAssert.detail != null) {
                this.print(" : ");
                this.printExpr(jCAssert.detail);
            }
            this.print(';');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        try {
            if (!jCMethodInvocation.typeargs.isEmpty()) {
                if (jCMethodInvocation.meth.hasTag(JCTree.Tag.SELECT)) {
                    JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCMethodInvocation.meth;
                    this.printExpr(jCFieldAccess.selected);
                    this.print(".<");
                    this.printExprs(jCMethodInvocation.typeargs);
                    this.print('>');
                    this.print(jCFieldAccess.name);
                } else {
                    this.print('<');
                    this.printExprs(jCMethodInvocation.typeargs);
                    this.print('>');
                    this.printExpr(jCMethodInvocation.meth);
                }
            } else {
                this.printExpr(jCMethodInvocation.meth);
            }
            this.print('(');
            this.printExprs(jCMethodInvocation.args);
            this.print(')');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        try {
            if (jCNewClass.encl != null) {
                this.printExpr(jCNewClass.encl);
                this.print('.');
            }
            this.print("new ");
            if (!jCNewClass.typeargs.isEmpty()) {
                this.print('<');
                this.printExprs(jCNewClass.typeargs);
                this.print('>');
            }
            if (jCNewClass.def != null && jCNewClass.def.mods.annotations.nonEmpty()) {
                this.printTypeAnnotations(jCNewClass.def.mods.annotations);
            }
            this.printExpr(jCNewClass.clazz);
            this.print('(');
            this.printExprs(jCNewClass.args);
            this.print(')');
            if (jCNewClass.def != null) {
                Name name = this.enclClassName;
                Name name2 = jCNewClass.def.name != null ? jCNewClass.def.name : (this.enclClassName = jCNewClass.type != null && jCNewClass.type.tsym.name != jCNewClass.type.tsym.name.table.names.empty ? jCNewClass.type.tsym.name : null);
                if ((jCNewClass.def.mods.flags & 0x4000L) != 0L) {
                    this.print("/*enum*/");
                }
                this.printBlock(jCNewClass.def.defs);
                this.enclClassName = name;
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        try {
            if (jCNewArray.elemtype != null) {
                this.print("new ");
                JCTree.JCExpression jCExpression = jCNewArray.elemtype;
                this.printBaseElementType(jCExpression);
                if (!jCNewArray.annotations.isEmpty()) {
                    this.print(' ');
                    this.printTypeAnnotations(jCNewArray.annotations);
                }
                if (jCNewArray.elems != null) {
                    this.print("[]");
                }
                int n = 0;
                List<List<JCTree.JCAnnotation>> list = jCNewArray.dimAnnotations;
                List<JCTree.JCExpression> list2 = jCNewArray.dims;
                while (list2.nonEmpty()) {
                    if (list.size() > n && !list.get(n).isEmpty()) {
                        this.print(' ');
                        this.printTypeAnnotations(list.get(n));
                    }
                    this.print('[');
                    ++n;
                    this.printExpr((JCTree)list2.head);
                    this.print(']');
                    list2 = list2.tail;
                }
                this.printBrackets(jCExpression);
            }
            if (jCNewArray.elems != null) {
                this.print('{');
                this.printExprs(jCNewArray.elems);
                this.print('}');
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        try {
            this.print('(');
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.EXPLICIT) {
                this.printExprs(jCLambda.params);
            } else {
                String string = "";
                for (JCTree.JCVariableDecl jCVariableDecl : jCLambda.params) {
                    this.print(string);
                    this.print(jCVariableDecl.name);
                    string = ",";
                }
            }
            this.print(")->");
            this.printExpr(jCLambda.body);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        try {
            this.print('(');
            this.printExpr(jCParens.expr);
            this.print(')');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        try {
            this.open(this.prec, 1);
            this.printExpr(jCAssign.lhs, 2);
            this.print(" = ");
            this.printExpr(jCAssign.rhs, 1);
            this.close(this.prec, 1);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public String operatorName(JCTree.Tag tag) {
        switch (tag) {
            case POS: {
                return "+";
            }
            case NEG: {
                return "-";
            }
            case NOT: {
                return "!";
            }
            case COMPL: {
                return "~";
            }
            case PREINC: {
                return "++";
            }
            case PREDEC: {
                return "--";
            }
            case POSTINC: {
                return "++";
            }
            case POSTDEC: {
                return "--";
            }
            case NULLCHK: {
                return "<*nullchk*>";
            }
            case OR: {
                return "||";
            }
            case AND: {
                return "&&";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case BITOR: {
                return "|";
            }
            case BITXOR: {
                return "^";
            }
            case BITAND: {
                return "&";
            }
            case SL: {
                return "<<";
            }
            case SR: {
                return ">>";
            }
            case USR: {
                return ">>>";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
        }
        throw new Error();
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        try {
            this.open(this.prec, 2);
            this.printExpr(jCAssignOp.lhs, 3);
            this.print(' ');
            this.print(this.operatorName(jCAssignOp.getTag().noAssignOp()));
            this.print("= ");
            this.printExpr(jCAssignOp.rhs, 2);
            this.close(this.prec, 2);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        try {
            int n = TreeInfo.opPrec(jCUnary.getTag());
            String string = this.operatorName(jCUnary.getTag());
            this.open(this.prec, n);
            if (!jCUnary.getTag().isPostUnaryOp()) {
                this.print(string);
                this.printExpr(jCUnary.arg, n);
            } else {
                this.printExpr(jCUnary.arg, n);
                this.print(string);
            }
            this.close(this.prec, n);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        try {
            int n = TreeInfo.opPrec(jCBinary.getTag());
            String string = this.operatorName(jCBinary.getTag());
            this.open(this.prec, n);
            this.printExpr(jCBinary.lhs, n);
            this.print(' ');
            this.print(string);
            this.print(' ');
            this.printExpr(jCBinary.rhs, n + 1);
            this.close(this.prec, n);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        try {
            this.open(this.prec, 14);
            this.print('(');
            this.printExpr(jCTypeCast.clazz);
            this.print(')');
            this.printExpr(jCTypeCast.expr, 14);
            this.close(this.prec, 14);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        try {
            this.open(this.prec, 10);
            this.printExpr(jCInstanceOf.expr, 10);
            this.print(" instanceof ");
            if (jCInstanceOf.pattern instanceof JCTree.JCPattern) {
                this.printPattern(jCInstanceOf.pattern);
            } else {
                this.printExpr(jCInstanceOf.getType(), 11);
            }
            this.close(this.prec, 10);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        try {
            this.printExpr(jCArrayAccess.indexed, 15);
            this.print('[');
            this.printExpr(jCArrayAccess.index);
            this.print(']');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        try {
            this.printExpr(jCFieldAccess.selected, 15);
            this.print('.');
            this.print(jCFieldAccess.name);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        try {
            this.printExpr(jCMemberReference.expr);
            this.print("::");
            if (jCMemberReference.typeargs != null) {
                this.print('<');
                this.printExprs(jCMemberReference.typeargs);
                this.print('>');
            }
            this.print(jCMemberReference.getMode() == MemberReferenceTree.ReferenceMode.INVOKE ? jCMemberReference.name : "new");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        try {
            this.print(jCIdent.name);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        try {
            switch (jCLiteral.typetag) {
                case INT: {
                    this.print(jCLiteral.value.toString());
                    break;
                }
                case LONG: {
                    this.print(jCLiteral.value);
                    this.print('L');
                    break;
                }
                case FLOAT: {
                    this.print(jCLiteral.value);
                    this.print('F');
                    break;
                }
                case DOUBLE: {
                    this.print(jCLiteral.value.toString());
                    break;
                }
                case CHAR: {
                    this.print('\'');
                    this.print(Convert.quote((char)((Number)jCLiteral.value).intValue(), true));
                    this.print('\'');
                    break;
                }
                case BOOLEAN: {
                    this.print(((Number)jCLiteral.value).intValue() == 1 ? "true" : "false");
                    break;
                }
                case BOT: {
                    this.print("null");
                    break;
                }
                default: {
                    this.print('\"');
                    this.print(Convert.quote(jCLiteral.value.toString()));
                    this.print('\"');
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        try {
            switch (jCPrimitiveTypeTree.typetag) {
                case BYTE: {
                    this.print("byte");
                    break;
                }
                case CHAR: {
                    this.print("char");
                    break;
                }
                case SHORT: {
                    this.print("short");
                    break;
                }
                case INT: {
                    this.print("int");
                    break;
                }
                case LONG: {
                    this.print("long");
                    break;
                }
                case FLOAT: {
                    this.print("float");
                    break;
                }
                case DOUBLE: {
                    this.print("double");
                    break;
                }
                case BOOLEAN: {
                    this.print("boolean");
                    break;
                }
                case VOID: {
                    this.print("void");
                    break;
                }
                default: {
                    this.print("error");
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        try {
            this.printBaseElementType(jCArrayTypeTree);
            this.printBrackets(jCArrayTypeTree);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private void printBaseElementType(JCTree jCTree) throws IOException {
        this.printExpr(TreeInfo.innermostType(jCTree, false));
    }

    private void printBrackets(JCTree jCTree) throws IOException {
        JCTree jCTree2 = jCTree;
        while (true) {
            if (jCTree2.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                JCTree.JCAnnotatedType jCAnnotatedType = (JCTree.JCAnnotatedType)jCTree2;
                jCTree2 = jCAnnotatedType.underlyingType;
                if (jCTree2.hasTag(JCTree.Tag.TYPEARRAY)) {
                    this.print(' ');
                    this.printTypeAnnotations(jCAnnotatedType.annotations);
                }
            }
            if (!jCTree2.hasTag(JCTree.Tag.TYPEARRAY)) break;
            this.print("[]");
            jCTree2 = ((JCTree.JCArrayTypeTree)jCTree2).elemtype;
        }
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        try {
            this.printExpr(jCTypeApply.clazz);
            this.print('<');
            this.printExprs(jCTypeApply.arguments);
            this.print('>');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion jCTypeUnion) {
        try {
            this.printExprs(jCTypeUnion.alternatives, " | ");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection jCTypeIntersection) {
        try {
            this.printExprs(jCTypeIntersection.bounds, " & ");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        try {
            if (jCTypeParameter.annotations.nonEmpty()) {
                this.printTypeAnnotations(jCTypeParameter.annotations);
            }
            this.print(jCTypeParameter.name);
            if (jCTypeParameter.bounds.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(jCTypeParameter.bounds, " & ");
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        try {
            this.print(jCWildcard.kind);
            if (jCWildcard.kind.kind != BoundKind.UNBOUND) {
                this.printExpr(jCWildcard.inner);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind typeBoundKind) {
        try {
            this.print(String.valueOf((Object)typeBoundKind.kind));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        try {
            this.print("(ERROR)");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        try {
            this.print("(let ");
            this.print(letExpr.defs);
            this.print(" in ");
            this.print(letExpr.expr);
            this.print(')');
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        try {
            this.printAnnotations(jCModifiers.annotations);
            this.printFlags(jCModifiers.flags);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        try {
            this.print('@');
            this.printExpr(jCAnnotation.annotationType);
            if (!jCAnnotation.args.isEmpty()) {
                this.print('(');
                this.printExprs(jCAnnotation.args);
                this.print(')');
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
        try {
            if (jCAnnotatedType.underlyingType.hasTag(JCTree.Tag.SELECT)) {
                JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCAnnotatedType.underlyingType;
                this.printExpr(jCFieldAccess.selected, 15);
                this.print('.');
                this.printTypeAnnotations(jCAnnotatedType.annotations);
                this.print(jCFieldAccess.name);
            } else if (jCAnnotatedType.underlyingType.hasTag(JCTree.Tag.TYPEARRAY)) {
                this.printBaseElementType(jCAnnotatedType);
                this.printBrackets(jCAnnotatedType);
            } else {
                this.printTypeAnnotations(jCAnnotatedType.annotations);
                this.printExpr(jCAnnotatedType.underlyingType);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void visitTree(JCTree jCTree) {
        try {
            this.print("(UNKNOWN: ");
            this.print((Object)jCTree.getTag());
            this.print(')');
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

