/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreeFactory;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.ReferenceParser;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.StringUtils;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import nbjavac.StringWrapper;

public class DocTreeMaker
implements DocTreeFactory {
    protected static final Context.Key<DocTreeMaker> treeMakerKey = new Context.Key();
    public int pos;
    private final JavacTrees trees;
    private final SentenceBreaker breaker;
    private final ReferenceParser referenceParser;

    public static DocTreeMaker instance(Context context) {
        DocTreeMaker docTreeMaker = context.get(treeMakerKey);
        if (docTreeMaker == null) {
            docTreeMaker = new DocTreeMaker(context);
        }
        return docTreeMaker;
    }

    protected DocTreeMaker(Context context) {
        context.put(treeMakerKey, this);
        this.pos = -1;
        this.trees = JavacTrees.instance(context);
        this.referenceParser = new ReferenceParser(ParserFactory.instance(context));
        this.breaker = new SentenceBreaker(this);
    }

    @Override
    public DocTreeMaker at(int n) {
        this.pos = n;
        return this;
    }

    @Override
    public DCTree.DCAttribute newAttributeTree(Name name, AttributeTree.ValueKind valueKind, java.util.List<? extends DocTree> list) {
        DCTree.DCAttribute dCAttribute = new DCTree.DCAttribute(name, valueKind, DocTreeMaker.cast(list));
        dCAttribute.pos = this.pos;
        return dCAttribute;
    }

    @Override
    public DCTree.DCAuthor newAuthorTree(java.util.List<? extends DocTree> list) {
        DCTree.DCAuthor dCAuthor = new DCTree.DCAuthor(DocTreeMaker.cast(list));
        dCAuthor.pos = this.pos;
        return dCAuthor;
    }

    @Override
    public DCTree.DCLiteral newCodeTree(TextTree textTree) {
        DCTree.DCLiteral dCLiteral = new DCTree.DCLiteral(DocTree.Kind.CODE, (DCTree.DCText)textTree);
        dCLiteral.pos = this.pos;
        return dCLiteral;
    }

    @Override
    public DCTree.DCComment newCommentTree(String string) {
        DCTree.DCComment dCComment = new DCTree.DCComment(string);
        dCComment.pos = this.pos;
        return dCComment;
    }

    @Override
    public DCTree.DCDeprecated newDeprecatedTree(java.util.List<? extends DocTree> list) {
        DCTree.DCDeprecated dCDeprecated = new DCTree.DCDeprecated(DocTreeMaker.cast(list));
        dCDeprecated.pos = this.pos;
        return dCDeprecated;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(java.util.List<? extends DocTree> list, java.util.List<? extends DocTree> list2) {
        return this.newDocCommentTree((java.util.List)list, (java.util.List)list2, Collections.emptyList(), Collections.emptyList());
    }

    public DCTree.DCDocComment newDocCommentTree(Tokens.Comment comment, java.util.List<? extends DocTree> list, java.util.List<? extends DocTree> list2, java.util.List<? extends DocTree> list3, java.util.List<? extends DocTree> list4) {
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(list);
        DCTree.DCDocComment dCDocComment = new DCTree.DCDocComment(comment, DocTreeMaker.cast(list), (java.util.List)pair.fst, (java.util.List)pair.snd, DocTreeMaker.cast(list2), DocTreeMaker.cast(list3), DocTreeMaker.cast(list4));
        dCDocComment.pos = this.pos;
        return dCDocComment;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(java.util.List<? extends DocTree> list, java.util.List<? extends DocTree> list2, java.util.List<? extends DocTree> list3, java.util.List<? extends DocTree> list4) {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        listBuffer.addAll((Collection<DCTree>)DocTreeMaker.cast(list));
        List<DCTree> list5 = listBuffer.toList();
        Tokens.Comment comment = new Tokens.Comment(){

            @Override
            public JCDiagnostic.DiagnosticPosition getPos() {
                return null;
            }

            @Override
            public int getSourcePos(int n) {
                return -1;
            }

            @Override
            public String getText() {
                throw new UnsupportedOperationException(this.getClass() + ".getText");
            }

            @Override
            public Tokens.Comment stripIndent() {
                return this;
            }

            @Override
            public Tokens.Comment.CommentStyle getStyle() {
                throw new UnsupportedOperationException(this.getClass() + ".getStyle");
            }

            @Override
            public boolean isDeprecated() {
                throw new UnsupportedOperationException(this.getClass() + ".isDeprecated");
            }
        };
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(list);
        return new DCTree.DCDocComment(comment, list5, (java.util.List)pair.fst, (java.util.List)pair.snd, DocTreeMaker.cast(list2), DocTreeMaker.cast(list3), DocTreeMaker.cast(list4));
    }

    @Override
    public DCTree.DCDocRoot newDocRootTree() {
        DCTree.DCDocRoot dCDocRoot = new DCTree.DCDocRoot();
        dCDocRoot.pos = this.pos;
        return dCDocRoot;
    }

    @Override
    public DCTree.DCDocType newDocTypeTree(String string) {
        DCTree.DCDocType dCDocType = new DCTree.DCDocType(string);
        dCDocType.pos = this.pos;
        return dCDocType;
    }

    @Override
    public DCTree.DCEndElement newEndElementTree(Name name) {
        DCTree.DCEndElement dCEndElement = new DCTree.DCEndElement(name);
        dCEndElement.pos = this.pos;
        return dCEndElement;
    }

    @Override
    public DCTree.DCEntity newEntityTree(Name name) {
        DCTree.DCEntity dCEntity = new DCTree.DCEntity(name);
        dCEntity.pos = this.pos;
        return dCEntity;
    }

    @Override
    public DCTree.DCErroneous newErroneousTree(String string, Diagnostic<JavaFileObject> diagnostic) {
        DCTree.DCErroneous dCErroneous = new DCTree.DCErroneous(string, (JCDiagnostic)diagnostic);
        dCErroneous.pos = this.pos;
        return dCErroneous;
    }

    @Override
    public DCTree.DCEscape newEscapeTree(char c) {
        DCTree.DCEscape dCEscape = new DCTree.DCEscape(c);
        dCEscape.pos = this.pos;
        return dCEscape;
    }

    @Override
    public DCTree.DCThrows newExceptionTree(ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCThrows dCThrows = new DCTree.DCThrows(DocTree.Kind.EXCEPTION, (DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCThrows.pos = this.pos;
        return dCThrows;
    }

    @Override
    public DCTree.DCHidden newHiddenTree(java.util.List<? extends DocTree> list) {
        DCTree.DCHidden dCHidden = new DCTree.DCHidden(DocTreeMaker.cast(list));
        dCHidden.pos = this.pos;
        return dCHidden;
    }

    @Override
    public DCTree.DCIdentifier newIdentifierTree(Name name) {
        DCTree.DCIdentifier dCIdentifier = new DCTree.DCIdentifier(name);
        dCIdentifier.pos = this.pos;
        return dCIdentifier;
    }

    @Override
    public DCTree.DCIndex newIndexTree(DocTree docTree, java.util.List<? extends DocTree> list) {
        DCTree.DCIndex dCIndex = new DCTree.DCIndex((DCTree)docTree, DocTreeMaker.cast(list));
        dCIndex.pos = this.pos;
        return dCIndex;
    }

    @Override
    public DCTree.DCInheritDoc newInheritDocTree() {
        return this.newInheritDocTree(null);
    }

    public DCTree.DCInheritDoc newInheritDocTree(ReferenceTree referenceTree) {
        DCTree.DCInheritDoc dCInheritDoc = new DCTree.DCInheritDoc((DCTree.DCReference)referenceTree);
        dCInheritDoc.pos = this.pos;
        return dCInheritDoc;
    }

    @Override
    public DCTree.DCLink newLinkTree(ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCLink dCLink = new DCTree.DCLink(DocTree.Kind.LINK, (DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCLink.pos = this.pos;
        return dCLink;
    }

    @Override
    public DCTree.DCLink newLinkPlainTree(ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCLink dCLink = new DCTree.DCLink(DocTree.Kind.LINK_PLAIN, (DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCLink.pos = this.pos;
        return dCLink;
    }

    @Override
    public DCTree.DCLiteral newLiteralTree(TextTree textTree) {
        DCTree.DCLiteral dCLiteral = new DCTree.DCLiteral(DocTree.Kind.LITERAL, (DCTree.DCText)textTree);
        dCLiteral.pos = this.pos;
        return dCLiteral;
    }

    public DCTree.DCRawText newRawTextTree(DocTree.Kind kind, String string) {
        DCTree.DCRawText dCRawText = new DCTree.DCRawText(kind, string);
        dCRawText.pos = this.pos;
        return dCRawText;
    }

    @Override
    public DCTree.DCParam newParamTree(boolean bl, IdentifierTree identifierTree, java.util.List<? extends DocTree> list) {
        DCTree.DCParam dCParam = new DCTree.DCParam(bl, (DCTree.DCIdentifier)identifierTree, DocTreeMaker.cast(list));
        dCParam.pos = this.pos;
        return dCParam;
    }

    @Override
    public DCTree.DCProvides newProvidesTree(ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCProvides dCProvides = new DCTree.DCProvides((DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCProvides.pos = this.pos;
        return dCProvides;
    }

    @Override
    public DCTree.DCReference newReferenceTree(String string) {
        try {
            ReferenceParser.Reference reference = this.referenceParser.parse(string, ReferenceParser.Mode.MEMBER_OPTIONAL);
            DCTree.DCReference dCReference = this.newReferenceTree(string, reference);
            dCReference.pos = this.pos;
            return dCReference;
        }
        catch (ReferenceParser.ParseException parseException) {
            throw new IllegalArgumentException("invalid signature", parseException);
        }
    }

    public DCTree.DCReference newReferenceTree(String string, ReferenceParser.Reference reference) {
        DCTree.DCReference dCReference = new DCTree.DCReference(string, reference.moduleName, reference.qualExpr, reference.member, reference.paramTypes);
        dCReference.pos = this.pos;
        return dCReference;
    }

    @Override
    public DCTree.DCReturn newReturnTree(java.util.List<? extends DocTree> list) {
        return this.newReturnTree(false, (java.util.List)list);
    }

    @Override
    public DCTree.DCReturn newReturnTree(boolean bl, java.util.List<? extends DocTree> list) {
        DCTree.DCReturn dCReturn = new DCTree.DCReturn(bl, DocTreeMaker.cast(list));
        dCReturn.pos = this.pos;
        return dCReturn;
    }

    @Override
    public DCTree.DCSee newSeeTree(java.util.List<? extends DocTree> list) {
        DCTree.DCSee dCSee = new DCTree.DCSee(DocTreeMaker.cast(list));
        dCSee.pos = this.pos;
        return dCSee;
    }

    @Override
    public DCTree.DCSerial newSerialTree(java.util.List<? extends DocTree> list) {
        DCTree.DCSerial dCSerial = new DCTree.DCSerial(DocTreeMaker.cast(list));
        dCSerial.pos = this.pos;
        return dCSerial;
    }

    @Override
    public DCTree.DCSerialData newSerialDataTree(java.util.List<? extends DocTree> list) {
        DCTree.DCSerialData dCSerialData = new DCTree.DCSerialData(DocTreeMaker.cast(list));
        dCSerialData.pos = this.pos;
        return dCSerialData;
    }

    @Override
    public DCTree.DCSerialField newSerialFieldTree(IdentifierTree identifierTree, ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCSerialField dCSerialField = new DCTree.DCSerialField((DCTree.DCIdentifier)identifierTree, (DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCSerialField.pos = this.pos;
        return dCSerialField;
    }

    @Override
    public DCTree.DCSince newSinceTree(java.util.List<? extends DocTree> list) {
        DCTree.DCSince dCSince = new DCTree.DCSince(DocTreeMaker.cast(list));
        dCSince.pos = this.pos;
        return dCSince;
    }

    @Override
    public DCTree.DCSnippet newSnippetTree(java.util.List<? extends DocTree> list, TextTree textTree) {
        DCTree.DCSnippet dCSnippet = new DCTree.DCSnippet(DocTreeMaker.cast(list), (DCTree.DCText)textTree);
        dCSnippet.pos = this.pos;
        return dCSnippet;
    }

    @Override
    public DCTree.DCSpec newSpecTree(TextTree textTree, java.util.List<? extends DocTree> list) {
        DCTree.DCSpec dCSpec = new DCTree.DCSpec((DCTree.DCText)textTree, DocTreeMaker.cast(list));
        dCSpec.pos = this.pos;
        return dCSpec;
    }

    @Override
    public DCTree.DCStartElement newStartElementTree(Name name, java.util.List<? extends DocTree> list, boolean bl) {
        DCTree.DCStartElement dCStartElement = new DCTree.DCStartElement(name, DocTreeMaker.cast(list), bl);
        dCStartElement.pos = this.pos;
        return dCStartElement;
    }

    @Override
    public DCTree.DCSummary newSummaryTree(java.util.List<? extends DocTree> list) {
        DCTree.DCSummary dCSummary = new DCTree.DCSummary(DocTreeMaker.cast(list));
        dCSummary.pos = this.pos;
        return dCSummary;
    }

    @Override
    public DCTree.DCSystemProperty newSystemPropertyTree(Name name) {
        DCTree.DCSystemProperty dCSystemProperty = new DCTree.DCSystemProperty(name);
        dCSystemProperty.pos = this.pos;
        return dCSystemProperty;
    }

    @Override
    public DCTree.DCText newTextTree(String string) {
        DCTree.DCText dCText = new DCTree.DCText(string);
        dCText.pos = this.pos;
        return dCText;
    }

    @Override
    public DCTree.DCThrows newThrowsTree(ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCThrows dCThrows = new DCTree.DCThrows(DocTree.Kind.THROWS, (DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCThrows.pos = this.pos;
        return dCThrows;
    }

    @Override
    public DCTree.DCUnknownBlockTag newUnknownBlockTagTree(Name name, java.util.List<? extends DocTree> list) {
        DCTree.DCUnknownBlockTag dCUnknownBlockTag = new DCTree.DCUnknownBlockTag(name, DocTreeMaker.cast(list));
        dCUnknownBlockTag.pos = this.pos;
        return dCUnknownBlockTag;
    }

    @Override
    public DCTree.DCUnknownInlineTag newUnknownInlineTagTree(Name name, java.util.List<? extends DocTree> list) {
        DCTree.DCUnknownInlineTag dCUnknownInlineTag = new DCTree.DCUnknownInlineTag(name, DocTreeMaker.cast(list));
        dCUnknownInlineTag.pos = this.pos;
        return dCUnknownInlineTag;
    }

    @Override
    public DCTree.DCUses newUsesTree(ReferenceTree referenceTree, java.util.List<? extends DocTree> list) {
        DCTree.DCUses dCUses = new DCTree.DCUses((DCTree.DCReference)referenceTree, DocTreeMaker.cast(list));
        dCUses.pos = this.pos;
        return dCUses;
    }

    @Override
    public DCTree.DCValue newValueTree(ReferenceTree referenceTree) {
        return this.newValueTree(null, referenceTree);
    }

    @Override
    public DCTree.DCValue newValueTree(TextTree textTree, ReferenceTree referenceTree) {
        DCTree.DCValue dCValue = new DCTree.DCValue((DCTree.DCText)textTree, (DCTree.DCReference)referenceTree);
        dCValue.pos = this.pos;
        return dCValue;
    }

    @Override
    public DCTree.DCVersion newVersionTree(java.util.List<? extends DocTree> list) {
        DCTree.DCVersion dCVersion = new DCTree.DCVersion(DocTreeMaker.cast(list));
        dCVersion.pos = this.pos;
        return dCVersion;
    }

    @Override
    public java.util.List<DocTree> getFirstSentence(java.util.List<? extends DocTree> list) {
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(list);
        return new ArrayList<DocTree>((Collection)pair.fst);
    }

    private static java.util.List<DCTree> cast(java.util.List<? extends DocTree> list) {
        return list;
    }

    Pair<java.util.List<DCTree>, java.util.List<DCTree>> splitBody(java.util.List<? extends DocTree> list) {
        return this.breaker.splitBody(list);
    }

    static class SentenceBreaker {
        final DocTreeMaker m;
        static final Set<String> sentenceBreakTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("H1", "H2", "H3", "H4", "H5", "H6", "PRE", "P")));
        private static final Pattern INDENT = Pattern.compile(" {4}| {0,3}\t");
        private static final Pattern endPara = Pattern.compile("\n(([ \t]*\n)|( {0,3}[-+*#=_>]))");

        SentenceBreaker(DocTreeMaker docTreeMaker) {
            this.m = docTreeMaker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> splitBody(java.util.List<? extends DocTree> list) {
            if (list.isEmpty()) {
                return new Pair<java.util.List<DCTree>, java.util.List<DCTree>>(Collections.unmodifiableList(Arrays.asList(new DCTree[0])), Collections.unmodifiableList(Arrays.asList(new DCTree[0])));
            }
            int n = this.m.pos;
            try {
                ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
                ListBuffer<DCTree> listBuffer2 = new ListBuffer<DCTree>();
                ArrayList arrayList = new ArrayList(DocTreeMaker.cast(list));
                ListIterator listIterator = arrayList.listIterator();
                boolean bl = false;
                while (listIterator.hasNext() && !bl) {
                    boolean bl2 = !listIterator.hasPrevious();
                    DCTree dCTree = (DCTree)listIterator.next();
                    switch (dCTree.getKind()) {
                        case RETURN: 
                        case SUMMARY: {
                            listBuffer.add(dCTree);
                            bl = true;
                            break;
                        }
                        case TEXT: 
                        case MARKDOWN: {
                            DCTree dCTree2;
                            DCTree dCTree3 = listIterator.hasNext() ? (DCTree)arrayList.get(listIterator.nextIndex()) : null;
                            String string = this.getContent(dCTree);
                            if (bl2 && dCTree.getKind() == DocTree.Kind.MARKDOWN && this.isIndented(string)) {
                                listBuffer2.add(dCTree);
                                bl = true;
                                break;
                            }
                            int n2 = this.getSentenceBreak(dCTree.getKind(), string, dCTree3);
                            if (n2 > 0) {
                                dCTree2 = this.newNode(dCTree.getKind(), dCTree.pos, StringWrapper.stripTrailing(string.substring(0, n2)));
                                listBuffer.add(dCTree2);
                                int n3 = this.skipWhiteSpace(string, n2);
                                if (n3 > 0) {
                                    DCTree dCTree4 = this.newNode(dCTree.getKind(), dCTree.pos + n3, string.substring(n3));
                                    listBuffer2.add(dCTree4);
                                }
                                bl = true;
                                break;
                            }
                            if (dCTree3 != null && this.isSentenceBreak(dCTree3, false)) {
                                dCTree2 = this.newNode(dCTree.getKind(), dCTree.pos, StringWrapper.stripTrailing(string));
                                listBuffer.add(dCTree2);
                                bl = true;
                                break;
                            }
                            listBuffer.add(dCTree);
                            break;
                        }
                        default: {
                            if (this.isSentenceBreak(dCTree, bl2)) {
                                listBuffer2.add(dCTree);
                                bl = true;
                                break;
                            }
                            listBuffer.add(dCTree);
                        }
                    }
                }
                while (listIterator.hasNext()) {
                    listBuffer2.add((DCTree)listIterator.next());
                }
                Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = new Pair<java.util.List<DCTree>, java.util.List<DCTree>>(listBuffer.toList(), listBuffer2.toList());
                return pair;
            }
            finally {
                this.m.pos = n;
            }
        }

        private String getContent(DCTree dCTree) {
            String string;
            switch (dCTree.getKind()) {
                case TEXT: {
                    string = ((DCTree.DCText)dCTree).text;
                    break;
                }
                case MARKDOWN: {
                    string = ((DCTree.DCRawText)dCTree).code;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dCTree.getKind().toString());
                }
            }
            return string;
        }

        private boolean isIndented(String string) {
            return INDENT.matcher(string).lookingAt();
        }

        private DCTree newNode(DocTree.Kind kind, int n, String string) {
            DCTree dCTree;
            switch (kind) {
                case TEXT: {
                    dCTree = this.m.at(n).newTextTree(string);
                    break;
                }
                case MARKDOWN: {
                    dCTree = this.m.at(n).newRawTextTree(kind, string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.toString());
                }
            }
            return dCTree;
        }

        private int getSentenceBreak(DocTree.Kind kind, String string, DCTree dCTree) {
            int n;
            BreakIterator breakIterator = this.m.trees.getBreakIterator();
            if (breakIterator == null) {
                return this.defaultSentenceBreak(kind, string);
            }
            String string2 = this.normalize(kind, kind == DocTree.Kind.MARKDOWN ? SentenceBreaker.firstParaText(string) : string);
            breakIterator.setText(string2);
            int n2 = breakIterator.next();
            switch (kind) {
                case MARKDOWN: {
                    int n3 = SentenceBreaker.endParaPos(string2);
                    if (n3 == -1) break;
                    return Math.min(n2, n3);
                }
            }
            if (dCTree == null || kind == DocTree.Kind.MARKDOWN && string2.length() < string.length()) {
                return n2;
            }
            if (n2 < string.length() - 1) {
                return n2;
            }
            switch (dCTree.getKind()) {
                case TEXT: 
                case MARKDOWN: {
                    String string3 = string2 + this.normalize(dCTree.getKind(), this.getContent(dCTree));
                    breakIterator.setText(string3);
                    n = breakIterator.next();
                    if (n2 >= n) break;
                    return n2;
                }
            }
            if (this.isSentenceBreak(dCTree, false)) {
                return n2;
            }
            String string4 = string + "Dummy Sentence.";
            breakIterator.setText(string4);
            n = breakIterator.next();
            if (n <= n2) {
                return n;
            }
            return -1;
        }

        private int defaultSentenceBreak(DocTree.Kind kind, String string) {
            int n;
            String string2 = this.normalize(kind, string);
            int n2 = -1;
            block12: for (int i = 0; i < string2.length(); ++i) {
                switch (string2.charAt(i)) {
                    case '.': {
                        n2 = i;
                        continue block12;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (n2 < 0) continue block12;
                        switch (kind) {
                            case MARKDOWN: {
                                int n3 = SentenceBreaker.endParaPos(string2);
                                return n3 == -1 || i < n3 ? i : n3;
                            }
                            case TEXT: {
                                return i;
                            }
                        }
                        throw new IllegalArgumentException(kind.toString());
                    }
                    default: {
                        n2 = -1;
                    }
                }
            }
            switch (kind) {
                case MARKDOWN: {
                    n = SentenceBreaker.endParaPos(string2);
                    break;
                }
                case TEXT: {
                    n = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.toString());
                }
            }
            return n;
        }

        private static int endParaPos(String string) {
            Matcher matcher = endPara.matcher(string);
            return matcher.find() ? matcher.start() : -1;
        }

        private static String firstParaText(String string) {
            int n = SentenceBreaker.endParaPos(string);
            return n == -1 ? string : string.substring(0, n);
        }

        private boolean isSentenceBreak(DCTree dCTree, boolean bl) {
            switch (dCTree.getKind()) {
                case START_ELEMENT: {
                    StartElementTree startElementTree = (StartElementTree)((Object)dCTree);
                    return !bl && dCTree.pos > 1 && this.isSentenceBreak(startElementTree.getName());
                }
                case END_ELEMENT: {
                    EndElementTree endElementTree = (EndElementTree)((Object)dCTree);
                    return !bl && dCTree.pos > 1 && this.isSentenceBreak(endElementTree.getName());
                }
            }
            return false;
        }

        private boolean isSentenceBreak(Name name) {
            return sentenceBreakTags.contains(StringUtils.toUpperCase(name.toString()));
        }

        private int skipWhiteSpace(String string, int n) {
            for (int i = n; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return i;
            }
            return -1;
        }

        private String normalize(DocTree.Kind kind, String string) {
            String string2;
            switch (kind) {
                case TEXT: {
                    string2 = string;
                    break;
                }
                case MARKDOWN: {
                    string2 = this.normalizeMarkdown(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(kind.toString());
                }
            }
            return string2;
        }

        private String normalizeMarkdown(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            int n2 = 0;
            block7: while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\\': {
                        stringBuilder.append(c);
                        if (++n2 >= n) continue block7;
                        stringBuilder.append(string.charAt(n2));
                        ++n2;
                        break;
                    }
                    case '<': {
                        n2 = this.skip(stringBuilder, string, n2, c, '>');
                        break;
                    }
                    case '[': {
                        n2 = this.skip(stringBuilder, string, n2, c, ']');
                        break;
                    }
                    case '(': {
                        n2 = this.skip(stringBuilder, string, n2, c, ')');
                        break;
                    }
                    case '`': {
                        int n3 = n2++;
                        while (n2 < n && string.charAt(n2) == '`') {
                            ++n2;
                        }
                        String string2 = string.substring(n3, n2);
                        stringBuilder.append(string2);
                        int n4 = string.indexOf(string2, n2);
                        if (n4 <= n2) continue block7;
                        stringBuilder.append(string.substring(n2, n4).replace('.', '-'));
                        stringBuilder.append(string2);
                        n2 = n4 + string2.length();
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        ++n2;
                    }
                }
            }
            return stringBuilder.toString();
        }

        private int skip(StringBuilder stringBuilder, String string, int n, char c, char c2) {
            stringBuilder.append(c);
            int n2 = string.indexOf(c2, ++n);
            if (n2 != -1) {
                stringBuilder.append(string.substring(n, n2).replace('.', '-'));
                return n2;
            }
            return n;
        }
    }
}

