/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacRoundEnvironment;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MatchingUtils;
import com.sun.tools.javac.util.ModuleHelper;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner14;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;

public class JavacProcessingEnvironment
implements ProcessingEnvironment,
Closeable {
    private final Options options;
    private final boolean printProcessorInfo;
    private final boolean printRounds;
    private final boolean verbose;
    private final boolean fatalErrors;
    private final boolean werror;
    private final boolean showResolveErrors;
    private final JavacFiler filer;
    private final JavacMessager messager;
    private final JavacElements elementUtils;
    private final JavacTypes typeUtils;
    private final JavaCompiler compiler;
    private final Modules modules;
    private final Types types;
    private final Annotate annotate;
    private final Lint lint;
    private DiscoveredProcessors discoveredProcs;
    private final Map<String, String> processorOptions;
    private final Set<String> unmatchedProcessorOptions;
    private final Set<String> platformAnnotations;
    private Set<Symbol.PackageSymbol> specifiedPackages = Collections.emptySet();
    final Log log;
    JCDiagnostic.Factory diags;
    Source source;
    private ClassLoader processorClassLoader;
    private ServiceLoader<Processor> serviceLoader;
    private final JavaFileManager fileManager;
    private JavacMessages messages;
    private MultiTaskListener taskListener;
    private final Symtab symtab;
    private final DeferredCompletionFailureHandler dcfh;
    private final Names names;
    private final Enter enter;
    private final Symbol.Completer initialCompleter;
    private final Check chk;
    private final Context context;
    private final Preview preview;
    private final TreeScanner treeCleaner = new TreeScanner(){
        JCTree.JCCompilationUnit topLevel;

        @Override
        public void scan(JCTree jCTree) {
            super.scan(jCTree);
            if (jCTree != null) {
                jCTree.type = null;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
            if (jCCompilationUnit.packge != null) {
                if (JavacProcessingEnvironment.this.isPkgInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) {
                    jCCompilationUnit.packge.package_info.reset();
                }
                jCCompilationUnit.packge.reset();
            }
            if (JavacProcessingEnvironment.this.isModuleInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) {
                jCCompilationUnit.modle.reset();
                jCCompilationUnit.modle.completer = symbol -> JavacProcessingEnvironment.this.modules.enter(List.of(jCCompilationUnit), jCCompilationUnit.modle.module_info);
                jCCompilationUnit.modle.module_info.reset();
                jCCompilationUnit.modle.module_info.members_field = Scope.WriteableScope.create(jCCompilationUnit.modle.module_info);
            }
            jCCompilationUnit.packge = null;
            this.topLevel = jCCompilationUnit;
            try {
                super.visitTopLevel(jCCompilationUnit);
            }
            finally {
                this.topLevel = null;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            super.visitClassDef(jCClassDecl);
            List<JCTree> list = List.nil();
            List<JCTree> list2 = jCClassDecl.defs;
            while (list2.nonEmpty() && !((JCTree)list2.head).hasTag(JCTree.Tag.METHODDEF)) {
                list = list.prepend((JCTree)list2.head);
                list2 = list2.tail;
            }
            if (list2.nonEmpty() && (((JCTree.JCMethodDecl)list2.head).mods.flags & 0x1000000000L) != 0L) {
                list2 = list2.tail;
                while (list.nonEmpty()) {
                    list2 = list2.prepend((JCTree)list.head);
                    list = list.tail;
                }
                jCClassDecl.defs = list2;
            }
            if (jCClassDecl.sym != null) {
                jCClassDecl.sym.completer = new ImplicitCompleter(this.topLevel);
                java.util.List list3 = jCClassDecl.sym.getRecordComponents();
                for (Symbol.RecordComponent recordComponent : list3) {
                    List<JCTree.JCAnnotation> list4 = recordComponent.getOriginalAnnos();
                    list4.forEach(jCAnnotation -> this.visitAnnotation((JCTree.JCAnnotation)jCAnnotation));
                }
                jCClassDecl.sym.clearPermittedSubclasses();
            }
            jCClassDecl.sym = null;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (TreeInfo.isConstructor(jCMethodDecl) && jCMethodDecl.sym != null && jCMethodDecl.sym.owner.isEnum() && jCMethodDecl.body != null && jCMethodDecl.body.stats.nonEmpty() && TreeInfo.isSuperCall((JCTree)jCMethodDecl.body.stats.head) && ((JCTree.JCStatement)jCMethodDecl.body.stats.head).pos == jCMethodDecl.body.pos) {
                jCMethodDecl.body.stats = jCMethodDecl.body.stats.tail;
            }
            jCMethodDecl.sym = null;
            super.visitMethodDef(jCMethodDecl);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            jCVariableDecl.sym = null;
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            jCNewClass.constructor = null;
            super.visitNewClass(jCNewClass);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            jCAssignOp.operator = null;
            super.visitAssignop(jCAssignOp);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            jCUnary.operator = null;
            super.visitUnary(jCUnary);
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            jCBinary.operator = null;
            super.visitBinary(jCBinary);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            jCFieldAccess.sym = null;
            super.visitSelect(jCFieldAccess);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            jCIdent.sym = null;
            super.visitIdent(jCIdent);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
            jCAnnotation.attribute = null;
            super.visitAnnotation(jCAnnotation);
        }
    };
    public static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public static JavacProcessingEnvironment instance(Context context) {
        JavacProcessingEnvironment javacProcessingEnvironment = context.get(JavacProcessingEnvironment.class);
        if (javacProcessingEnvironment == null) {
            javacProcessingEnvironment = new JavacProcessingEnvironment(context);
        }
        return javacProcessingEnvironment;
    }

    protected JavacProcessingEnvironment(Context context) {
        this.context = context;
        context.put(JavacProcessingEnvironment.class, this);
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.options = Options.instance(context);
        this.printProcessorInfo = this.options.isSet(Option.XPRINTPROCESSORINFO);
        this.printRounds = this.options.isSet(Option.XPRINTROUNDS);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.lint = Lint.instance(context);
        this.compiler = JavaCompiler.instance(context);
        if (this.options.isSet(Option.PROC, "only") || this.options.isSet(Option.XPRINT)) {
            this.compiler.shouldStopPolicyIfNoError = CompileStates.CompileState.PROCESS;
        }
        this.fatalErrors = this.options.isSet("fatalEnterError");
        this.showResolveErrors = this.options.isSet("showResolveErrors");
        this.werror = this.options.isSet(Option.WERROR);
        this.fileManager = context.get(JavaFileManager.class);
        this.platformAnnotations = this.initPlatformAnnotations();
        this.filer = new JavacFiler(context);
        this.messager = new JavacMessager(context, this);
        this.elementUtils = JavacElements.instance(context);
        this.typeUtils = JavacTypes.instance(context);
        this.modules = Modules.instance(context);
        this.types = Types.instance(context);
        this.annotate = Annotate.instance(context);
        this.processorOptions = this.initProcessorOptions();
        this.unmatchedProcessorOptions = this.initUnmatchedProcessorOptions();
        this.messages = JavacMessages.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.symtab = Symtab.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.initialCompleter = ClassFinder.instance(context).getCompleter();
        this.chk = Check.instance(context);
        this.preview = Preview.instance(context);
        this.initProcessorLoader();
    }

    public void setProcessors(Iterable<? extends Processor> iterable) {
        Assert.checkNull(this.discoveredProcs);
        this.initProcessorIterator(iterable);
    }

    private Set<String> initPlatformAnnotations() {
        String string = Source.Feature.MODULES.allowedInSource(this.source) ? "java.base/" : "";
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(string + "java.lang.Deprecated", string + "java.lang.FunctionalInterface", string + "java.lang.Override", string + "java.lang.SafeVarargs", string + "java.lang.SuppressWarnings", string + "java.lang.annotation.Documented", string + "java.lang.annotation.Inherited", string + "java.lang.annotation.Native", string + "java.lang.annotation.Repeatable", string + "java.lang.annotation.Retention", string + "java.lang.annotation.Target", string + "java.io.Serial")));
    }

    private void initProcessorLoader() {
        if (this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH)) {
            try {
                this.serviceLoader = this.fileManager.getServiceLoader(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, Processor.class);
            }
            catch (IOException iOException) {
                throw new Abort(iOException);
            }
        } else {
            ClassLoader classLoader;
            ClassLoader classLoader2 = this.processorClassLoader = this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? this.fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH) : this.fileManager.getClassLoader(StandardLocation.CLASS_PATH);
            if (this.options.isSet("accessInternalAPI")) {
                ModuleHelper.addExports(ModuleWrapper.getModule(this.getClass()), ModuleWrapper.getUnnamedModule(this.processorClassLoader));
            }
            if (this.processorClassLoader != null && (classLoader = this.processorClassLoader) instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)classLoader);
                this.compiler.closeables = this.compiler.closeables.prepend(closeable);
            }
        }
    }

    private void initProcessorIterator(Iterable<? extends Processor> iterable) {
        Object object;
        Iterator<Processor> iterator2;
        if (this.options.isSet(Option.XPRINT)) {
            try {
                iterator2 = List.of(new PrintingProcessor()).iterator();
            }
            catch (Throwable throwable) {
                throw new AssertionError("Problem instantiating PrintingProcessor.", throwable);
            }
        } else if (iterable != null) {
            iterator2 = iterable.iterator();
        } else {
            object = this.options.get(Option.PROCESSOR);
            iterator2 = this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) ? (object == null ? new ServiceIterator(this.serviceLoader, this.log) : new NameServiceIterator(this.serviceLoader, this.log, (String)object)) : (object != null ? new NameProcessIterator((String)object, this.processorClassLoader, this.log) : new ServiceIterator(this.processorClassLoader, this.log));
        }
        object = this.context.get(PlatformDescription.class);
        java.util.List list = Collections.emptyList();
        if (object != null) {
            list = object.getAnnotationProcessors().stream().map(PlatformDescription.PluginInfo::getPlugin).collect(Collectors.toList());
        }
        List list2 = List.of(iterator2, list.iterator());
        Iterator iterator3 = Iterators.createCompoundIterator(list2, iterator -> iterator);
        this.discoveredProcs = new DiscoveredProcessors(iterator3);
    }

    public <S> ServiceLoader<S> getServiceLoader(Class<S> clazz) {
        if (this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH)) {
            try {
                return this.fileManager.getServiceLoader(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, clazz);
            }
            catch (IOException iOException) {
                throw new Abort(iOException);
            }
        }
        return ServiceLoaderWrapper.loadWithClassLoader(clazz, this.getProcessorClassLoader());
    }

    public boolean atLeastOneProcessor() {
        return this.discoveredProcs.iterator().hasNext();
    }

    private Map<String, String> initProcessorOptions() {
        Set<String> set = this.options.keySet();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String object : set) {
            if (!object.startsWith("-A") || object.length() <= 2) continue;
            int pluginInfo = object.indexOf(61);
            String string = null;
            String string2 = null;
            if (pluginInfo == -1) {
                string = object.substring(2);
            } else if (pluginInfo >= 3) {
                string = object.substring(2, pluginInfo);
                string2 = pluginInfo < object.length() - 1 ? object.substring(pluginInfo + 1) : null;
            }
            linkedHashMap.put(string, string2);
        }
        PlatformDescription platformDescription = this.context.get(PlatformDescription.class);
        if (platformDescription != null) {
            for (PlatformDescription.PluginInfo<Processor> pluginInfo : platformDescription.getAnnotationProcessors()) {
                linkedHashMap.putAll(pluginInfo.getOptions());
            }
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private Set<String> initUnmatchedProcessorOptions() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.processorOptions.keySet());
        return hashSet;
    }

    private void discoverAndRunProcs(Set<TypeElement> set, List<Symbol.ClassSymbol> list, List<Symbol.PackageSymbol> list2, List<Symbol.ModuleSymbol> list3) {
        Object object;
        Object object2;
        HashMap<String, TypeElement> hashMap = new HashMap<String, TypeElement>(set.size());
        for (TypeElement set22 : set) {
            object2 = this.elementUtils.getModuleOf(set22);
            object = Source.Feature.MODULES.allowedInSource(this.source) && object2 != null ? object2.getQualifiedName() + "/" : "";
            hashMap.put((String)object + set22.getQualifiedName().toString(), set22);
        }
        if (hashMap.size() == 0) {
            hashMap.put("", null);
        }
        DiscoveredProcessors.ProcessorStateIterator processorStateIterator = this.discoveredProcs.iterator();
        LinkedHashSet<Symbol.TypeSymbol> linkedHashSet = new LinkedHashSet<Symbol.TypeSymbol>();
        linkedHashSet.addAll(list);
        linkedHashSet.addAll(list2);
        linkedHashSet.addAll(list3);
        Set set2 = Collections.unmodifiableSet(linkedHashSet);
        object2 = new JavacRoundEnvironment(false, false, set2, this);
        while (hashMap.size() > 0 && processorStateIterator.hasNext()) {
            object = processorStateIterator.next();
            HashSet<String> hashSet = new HashSet<String>();
            LinkedHashSet<TypeElement> linkedHashSet2 = new LinkedHashSet<TypeElement>();
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                if (!((ProcessorState)object).annotationSupported(string)) continue;
                hashSet.add(string);
                TypeElement typeElement = (TypeElement)entry.getValue();
                if (typeElement == null) continue;
                linkedHashSet2.add(typeElement);
            }
            if (hashSet.size() <= 0 && !((ProcessorState)object).contributed) continue;
            boolean bl = this.callProcessor(((ProcessorState)object).processor, linkedHashSet2, (RoundEnvironment)object2);
            ((ProcessorState)object).contributed = true;
            ((ProcessorState)object).removeSupportedOptions(this.unmatchedProcessorOptions);
            if (this.printProcessorInfo || this.verbose) {
                this.log.printLines("x.print.processor.info", ((ProcessorState)object).processor.getClass().getName(), ((Object)hashSet).toString(), bl);
            }
            if (!bl) continue;
            hashMap.keySet().removeAll(hashSet);
        }
        hashMap.remove("");
        if (this.lint.isEnabled(Lint.LintCategory.PROCESSING) && hashMap.size() > 0) {
            hashMap.keySet().removeAll(this.platformAnnotations);
            if (hashMap.size() > 0) {
                this.log.warning(CompilerProperties.LintWarnings.ProcAnnotationsWithoutProcessors(hashMap.keySet()));
            }
        }
        processorStateIterator.runContributingProcs((RoundEnvironment)object2);
    }

    private boolean callProcessor(Processor processor, Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        DeferredCompletionFailureHandler.Handler handler = this.dcfh.setHandler(this.dcfh.userCodeHandler);
        try {
            boolean bl = processor.process(set, roundEnvironment);
            return bl;
        }
        catch (ClassFinder.BadClassFile badClassFile) {
            this.log.error(CompilerProperties.Errors.ProcCantAccess1(badClassFile.sym, badClassFile.getDetailValue()));
            boolean bl = false;
            return bl;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            StringWriter stringWriter = new StringWriter();
            completionFailure.printStackTrace(new PrintWriter(stringWriter));
            this.log.error(CompilerProperties.Errors.ProcCantAccess(completionFailure.sym, completionFailure.getDetailValue(), stringWriter.toString()));
            boolean bl = false;
            return bl;
        }
        catch (ClientCodeException clientCodeException) {
            throw clientCodeException;
        }
        catch (Throwable throwable) {
            throw new AnnotationProcessingError(throwable);
        }
        finally {
            this.dcfh.setHandler(handler);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean doProcessing(List<JCTree.JCCompilationUnit> list, List<Symbol.ClassSymbol> list2, Iterable<? extends Symbol.PackageSymbol> iterable, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Round round;
        boolean bl4;
        boolean bl5;
        Set<JCTree.JCCompilationUnit> set = Collections.newSetFromMap(new IdentityHashMap());
        for (Env<AttrContext> object2 : this.enter.getEnvs()) {
            set.add(object2.toplevel);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Symbol.PackageSymbol packageSymbol : iterable) {
            linkedHashSet.add(packageSymbol);
        }
        this.specifiedPackages = Collections.unmodifiableSet(linkedHashSet);
        Round round2 = new Round(list, list2, set, deferredDiagnosticHandler);
        do {
            void var7_10;
            var7_10.run(false, false);
            bl4 = var7_10.unrecoverableError();
            bl5 = this.moreToDo();
            var7_10.showDiagnostics(this.showResolveErrors);
            round = var7_10.next(new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects()), new LinkedHashMap<Symbol.ModuleSymbol, Map<String, JavaFileObject>>(this.filer.getGeneratedClasses()));
            if (!round.unrecoverableError()) continue;
            bl4 = true;
        } while (bl5 && !bl4);
        round.run(true, bl4);
        round.showDiagnostics(true);
        this.filer.warnIfUnclosedFiles();
        this.warnIfUnmatchedOptions();
        if (this.messager.errorRaised() || this.werror && round.warningCount() > 0 && round.errorCount() > 0) {
            bl3 = true;
        }
        LinkedHashSet<JavaFileObject> linkedHashSet2 = new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects());
        list = round.roots;
        boolean bl6 = bl2 = bl3 || this.compiler.errorCount() > 0;
        if (linkedHashSet2.size() > 0) {
            list = list.appendList(this.compiler.parseFiles(linkedHashSet2));
        }
        boolean bl7 = bl = bl2 || this.compiler.errorCount() > 0;
        if (bl && this.compiler.errorCount() == 0) {
            ++this.compiler.log.nerrors;
        }
        if (this.compiler.continueAfterProcessAnnotations()) {
            round.finalCompiler();
            this.compiler.enterTrees(this.compiler.initModules(list));
        } else {
            this.compiler.todo.clear();
        }
        this.close();
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
        }
        return true;
    }

    private void warnIfUnmatchedOptions() {
        if (!this.unmatchedProcessorOptions.isEmpty()) {
            this.log.warning(CompilerProperties.Warnings.ProcUnmatchedProcessorOptions(this.unmatchedProcessorOptions.toString()));
        }
    }

    @Override
    public void close() {
        this.filer.close();
        if (this.discoveredProcs != null) {
            this.discoveredProcs.close();
        }
        this.discoveredProcs = null;
    }

    private List<Symbol.ClassSymbol> getTopLevelClasses(List<? extends JCTree.JCCompilationUnit> list) {
        List<Symbol.ClassSymbol> list2 = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            for (JCTree jCTree : jCCompilationUnit.defs) {
                if (!jCTree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)jCTree).sym;
                Assert.checkNonNull(classSymbol);
                list2 = list2.prepend(classSymbol);
            }
        }
        return list2.reverse();
    }

    private List<Symbol.ClassSymbol> getTopLevelClassesFromClasses(List<? extends Symbol.ClassSymbol> list) {
        List<Symbol.ClassSymbol> list2 = List.nil();
        for (Symbol.ClassSymbol classSymbol : list) {
            if (this.isPkgInfo(classSymbol)) continue;
            list2 = list2.prepend(classSymbol);
        }
        return list2.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFiles(List<? extends JCTree.JCCompilationUnit> list) {
        List<Symbol.PackageSymbol> list2 = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            if (!this.isPkgInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) continue;
            list2 = list2.prepend(jCCompilationUnit.packge);
        }
        return list2.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFilesFromClasses(List<? extends Symbol.ClassSymbol> list) {
        List<Symbol.PackageSymbol> list2 = List.nil();
        for (Symbol.ClassSymbol classSymbol : list) {
            if (!this.isPkgInfo(classSymbol)) continue;
            list2 = list2.prepend((Symbol.PackageSymbol)classSymbol.owner);
        }
        return list2.reverse();
    }

    private List<Symbol.ModuleSymbol> getModuleInfoFiles(List<? extends JCTree.JCCompilationUnit> list) {
        List<Symbol.ModuleSymbol> list2 = List.nil();
        block0: for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            if (!this.isModuleInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE) || !jCCompilationUnit.defs.nonEmpty()) continue;
            for (JCTree jCTree : jCCompilationUnit.defs) {
                if (jCTree.hasTag(JCTree.Tag.IMPORT)) continue;
                if (!jCTree.hasTag(JCTree.Tag.MODULEDEF)) continue block0;
                list2 = list2.prepend(jCCompilationUnit.modle);
                continue block0;
            }
        }
        return list2.reverse();
    }

    private static <T> List<T> join(List<T> list, List<T> list2) {
        return list.appendList(list2);
    }

    private boolean isPkgInfo(JavaFileObject javaFileObject, JavaFileObject.Kind kind) {
        return javaFileObject.isNameCompatible("package-info", kind);
    }

    private boolean isPkgInfo(Symbol.ClassSymbol classSymbol) {
        return this.isPkgInfo(classSymbol.classfile, JavaFileObject.Kind.CLASS) && classSymbol.packge().package_info == classSymbol;
    }

    private boolean isModuleInfo(JavaFileObject javaFileObject, JavaFileObject.Kind kind) {
        return javaFileObject.isNameCompatible("module-info", kind);
    }

    private boolean moreToDo() {
        return this.filer.newFiles();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public JavacFiler getFiler() {
        return this.filer;
    }

    @Override
    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public JavacTypes getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    @Override
    public Locale getLocale() {
        return this.messages.getCurrentLocale();
    }

    @Override
    public boolean isPreviewEnabled() {
        return this.preview.isEnabled();
    }

    public Set<Symbol.PackageSymbol> getSpecifiedPackages() {
        return this.specifiedPackages;
    }

    private static Pattern importStringToPattern(boolean bl, String string, Processor processor, Log log, Lint lint) {
        String string2;
        String string3;
        int n = string.indexOf(47);
        if (n == -1) {
            if (string.equals("*")) {
                return MatchingUtils.validImportStringToPattern(string);
            }
            string3 = bl ? ".*/" : "";
            string2 = string;
        } else {
            String string4 = string.substring(0, n);
            if (!SourceVersion.isName(string4)) {
                return JavacProcessingEnvironment.warnAndNoMatches(string, processor, log, lint);
            }
            string3 = Pattern.quote(string4 + "/");
            string2 = string.substring(n + 1);
        }
        if (MatchingUtils.isValidImportString(string2)) {
            return Pattern.compile(string3 + MatchingUtils.validImportStringToPatternString(string2));
        }
        return JavacProcessingEnvironment.warnAndNoMatches(string, processor, log, lint);
    }

    private static Pattern warnAndNoMatches(String string, Processor processor, Log log, Lint lint) {
        lint.logIfEnabled(CompilerProperties.LintWarnings.ProcMalformedSupportedString(string, processor.getClass().getName()));
        return noMatches;
    }

    public Context getContext() {
        return this.context;
    }

    public ClassLoader getProcessorClassLoader() {
        return this.processorClassLoader;
    }

    public String toString() {
        return "javac ProcessingEnvironment";
    }

    public static boolean isValidOptionName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    class DiscoveredProcessors
    implements Iterable<ProcessorState> {
        Iterator<? extends Processor> processorIterator;
        ArrayList<ProcessorState> procStateList;

        public ProcessorStateIterator iterator() {
            return new ProcessorStateIterator(this);
        }

        DiscoveredProcessors(Iterator<? extends Processor> iterator) {
            this.processorIterator = iterator;
            this.procStateList = new ArrayList();
        }

        public void close() {
            Iterator<? extends Processor> iterator;
            if (this.processorIterator != null && (iterator = this.processorIterator) instanceof ServiceIterator) {
                ServiceIterator serviceIterator = (ServiceIterator)iterator;
                serviceIterator.close();
            }
        }

        class ProcessorStateIterator
        implements Iterator<ProcessorState> {
            DiscoveredProcessors psi;
            Iterator<ProcessorState> innerIter;
            boolean onProcIterator;

            ProcessorStateIterator(DiscoveredProcessors discoveredProcessors2) {
                this.psi = discoveredProcessors2;
                this.innerIter = discoveredProcessors2.procStateList.iterator();
                this.onProcIterator = false;
            }

            @Override
            public ProcessorState next() {
                if (!this.onProcIterator) {
                    if (this.innerIter.hasNext()) {
                        return this.innerIter.next();
                    }
                    this.onProcIterator = true;
                }
                if (this.psi.processorIterator.hasNext()) {
                    ProcessorState processorState = new ProcessorState(this.psi.processorIterator.next(), JavacProcessingEnvironment.this.log, JavacProcessingEnvironment.this.source, JavacProcessingEnvironment.this.dcfh, Source.Feature.MODULES.allowedInSource(JavacProcessingEnvironment.this.source), JavacProcessingEnvironment.this, JavacProcessingEnvironment.this.lint);
                    this.psi.procStateList.add(processorState);
                    return processorState;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.onProcIterator) {
                    return this.psi.processorIterator.hasNext();
                }
                return this.innerIter.hasNext() || this.psi.processorIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void runContributingProcs(RoundEnvironment roundEnvironment) {
                if (!this.onProcIterator) {
                    Set set = Collections.emptySet();
                    while (this.innerIter.hasNext()) {
                        ProcessorState processorState = this.innerIter.next();
                        if (!processorState.contributed) continue;
                        JavacProcessingEnvironment.this.callProcessor(processorState.processor, set, roundEnvironment);
                    }
                }
            }
        }
    }

    private class ServiceIterator
    implements Iterator<Processor> {
        Iterator<Processor> iterator;
        Log log;
        ServiceLoader<Processor> loader;

        ServiceIterator(ClassLoader classLoader, Log log) {
            this.log = log;
            try {
                this.loader = ServiceLoaderWrapper.loadWithClassLoader(Processor.class, classLoader);
                this.iterator = this.loader.iterator();
            }
            catch (Throwable throwable) {
                log.error(CompilerProperties.Errors.ProcServiceProblem);
                throw new Abort(throwable);
            }
        }

        ServiceIterator(ServiceLoader<Processor> serviceLoader, Log log) {
            this.log = log;
            this.loader = serviceLoader;
            this.iterator = serviceLoader.iterator();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.internalHasNext();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(serviceConfigurationError.getLocalizedMessage()));
                throw new Abort(serviceConfigurationError);
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                this.log.error(CompilerProperties.Errors.ProcCantLoadClass(unsupportedClassVersionError.getLocalizedMessage()));
                throw new Abort(unsupportedClassVersionError);
            }
            catch (ClassFormatError classFormatError) {
                this.log.error(CompilerProperties.Errors.ProcCantLoadClass(classFormatError.getLocalizedMessage()));
                throw new Abort(classFormatError);
            }
            catch (Throwable throwable) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(throwable.getLocalizedMessage()));
                throw new Abort(throwable);
            }
        }

        boolean internalHasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Processor next() {
            try {
                return this.internalNext();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(serviceConfigurationError.getLocalizedMessage()));
                throw new Abort(serviceConfigurationError);
            }
            catch (Throwable throwable) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(throwable.getLocalizedMessage()));
                throw new Abort(throwable);
            }
        }

        Processor internalNext() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.loader != null) {
                try {
                    this.loader.reload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class NameServiceIterator
    extends ServiceIterator {
        private Map<String, Processor> namedProcessorsMap;
        private Iterator<String> processorNames;
        private Processor nextProc;

        public NameServiceIterator(ServiceLoader<Processor> serviceLoader, Log log, String string) {
            super(serviceLoader, log);
            this.namedProcessorsMap = new HashMap<String, Processor>();
            this.processorNames = null;
            this.nextProc = null;
            this.processorNames = Arrays.asList(string.split(",")).iterator();
        }

        @Override
        boolean internalHasNext() {
            if (this.nextProc != null) {
                return true;
            }
            if (!this.processorNames.hasNext()) {
                this.namedProcessorsMap = null;
                return false;
            }
            String string = this.processorNames.next();
            Processor processor = this.namedProcessorsMap.get(string);
            if (processor != null) {
                this.namedProcessorsMap.remove(string);
                this.nextProc = processor;
                return true;
            }
            while (this.iterator.hasNext()) {
                processor = (Processor)this.iterator.next();
                String string2 = processor.getClass().getName();
                if (string2.equals(string)) {
                    this.nextProc = processor;
                    return true;
                }
                this.namedProcessorsMap.put(string2, processor);
            }
            this.log.error(CompilerProperties.Errors.ProcProcessorNotFound(string));
            return false;
        }

        @Override
        Processor internalNext() {
            if (this.hasNext()) {
                Processor processor = this.nextProc;
                this.nextProc = null;
                return processor;
            }
            throw new NoSuchElementException();
        }
    }

    private static class NameProcessIterator
    implements Iterator<Processor> {
        Processor nextProc = null;
        Iterator<String> names;
        ClassLoader processorCL;
        Log log;

        NameProcessIterator(String string, ClassLoader classLoader, Log log) {
            this.names = Arrays.asList(string.split(",")).iterator();
            this.processorCL = classLoader;
            this.log = log;
        }

        @Override
        public boolean hasNext() {
            if (this.nextProc != null) {
                return true;
            }
            if (!this.names.hasNext()) {
                return false;
            }
            Processor processor = this.getNextProcessor(this.names.next());
            if (processor == null) {
                return false;
            }
            this.nextProc = processor;
            return true;
        }

        private Processor getNextProcessor(String string) {
            try {
                try {
                    Class<?> clazz = this.processorCL.loadClass(string);
                    this.ensureReadable(clazz);
                    return (Processor)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log.error(CompilerProperties.Errors.ProcProcessorNotFound(string));
                    return null;
                }
                catch (ClassCastException classCastException) {
                    this.log.error(CompilerProperties.Errors.ProcProcessorWrongType(string));
                    return null;
                }
                catch (Exception exception) {
                    this.log.error(CompilerProperties.Errors.ProcProcessorCantInstantiate(string));
                    return null;
                }
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
        }

        @Override
        public Processor next() {
            if (this.hasNext()) {
                Processor processor = this.nextProc;
                this.nextProc = null;
                return processor;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void ensureReadable(Class<?> clazz) {
            try {
                Method method = Class.class.getMethod("getModule", new Class[0]);
                Object object = method.invoke(this.getClass(), new Object[0]);
                Object object2 = method.invoke(clazz, new Object[0]);
                Class<?> clazz2 = method.getReturnType();
                Method method2 = clazz2.getMethod("addReads", clazz2);
                method2.invoke(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                throw new InternalError(exception);
            }
        }
    }

    static class ProcessorState {
        public Processor processor;
        public boolean contributed;
        private Set<String> supportedAnnotationStrings;
        private Set<Pattern> supportedAnnotationPatterns;
        private Set<String> supportedOptionNames;

        ProcessorState(Processor processor, Log log, Source source, DeferredCompletionFailureHandler deferredCompletionFailureHandler, boolean bl, ProcessingEnvironment processingEnvironment, Lint lint) {
            this.processor = processor;
            this.contributed = false;
            DeferredCompletionFailureHandler.Handler handler = deferredCompletionFailureHandler.setHandler(deferredCompletionFailureHandler.userCodeHandler);
            try {
                boolean bl2;
                this.processor.init(processingEnvironment);
                this.checkSourceVersionCompatibility(source, log);
                this.supportedAnnotationStrings = new LinkedHashSet<String>();
                this.supportedAnnotationPatterns = new LinkedHashSet<Pattern>();
                for (String string : this.processor.getSupportedAnnotationTypes()) {
                    bl2 = this.supportedAnnotationStrings.add(string);
                    this.supportedAnnotationPatterns.add(JavacProcessingEnvironment.importStringToPattern(bl, string, this.processor, log, lint));
                    if (bl2) continue;
                    lint.logIfEnabled(CompilerProperties.LintWarnings.ProcDuplicateSupportedAnnotation(string, processor.getClass().getName()));
                }
                if (this.supportedAnnotationPatterns.contains(MatchingUtils.validImportStringToPattern("*")) && this.supportedAnnotationPatterns.size() > 1) {
                    lint.logIfEnabled(CompilerProperties.LintWarnings.ProcRedundantTypesWithWildcard(processor.getClass().getName()));
                }
                this.supportedOptionNames = new LinkedHashSet<String>();
                for (String string : this.processor.getSupportedOptions()) {
                    if (!this.checkOptionName(string, log) || (bl2 = this.supportedOptionNames.add(string))) continue;
                    lint.logIfEnabled(CompilerProperties.LintWarnings.ProcDuplicateOptionName(string, processor.getClass().getName()));
                }
            }
            catch (ClientCodeException clientCodeException) {
                throw clientCodeException;
            }
            catch (Throwable throwable) {
                throw new AnnotationProcessingError(throwable);
            }
            finally {
                deferredCompletionFailureHandler.setHandler(handler);
            }
        }

        private void checkSourceVersionCompatibility(Source source, Log log) {
            SourceVersion sourceVersion = this.processor.getSupportedSourceVersion();
            if (sourceVersion.compareTo(Source.toSourceVersion(source)) < 0) {
                log.warning(CompilerProperties.Warnings.ProcProcessorIncompatibleSourceVersion(sourceVersion, this.processor.getClass().getName(), source.name));
            }
        }

        private boolean checkOptionName(String string, Log log) {
            boolean bl = JavacProcessingEnvironment.isValidOptionName(string);
            if (!bl) {
                log.error(CompilerProperties.Errors.ProcProcessorBadOptionName(string, this.processor.getClass().getName()));
            }
            return bl;
        }

        public boolean annotationSupported(String string) {
            for (Pattern pattern : this.supportedAnnotationPatterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }

        public void removeSupportedOptions(Set<String> set) {
            set.removeAll(this.supportedOptionNames);
        }
    }

    class Round {
        final int number;
        final Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
        List<JCTree.JCCompilationUnit> roots;
        Set<JCTree.JCCompilationUnit> treesToClean;
        Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> genClassFiles;
        Set<TypeElement> annotationsPresent;
        List<Symbol.ClassSymbol> topLevelClasses;
        List<Symbol.PackageSymbol> packageInfoFiles;
        List<Symbol.ModuleSymbol> moduleInfoFiles;
        private final Predicate<JCDiagnostic> ACCEPT_NON_RECOVERABLE = jCDiagnostic -> jCDiagnostic.getKind() != Diagnostic.Kind.ERROR || !jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE) || jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.API);
        private final Predicate<JCDiagnostic> ACCEPT_ALL = jCDiagnostic -> true;

        private Round(int n, Set<JCTree.JCCompilationUnit> set, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this.number = n;
            if (n == 1) {
                Assert.checkNonNull(deferredDiagnosticHandler);
                this.deferredDiagnosticHandler = deferredDiagnosticHandler;
            } else {
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(JavacProcessingEnvironment.this.log);
                JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(this.deferredDiagnosticHandler);
            }
            this.topLevelClasses = List.nil();
            this.packageInfoFiles = List.nil();
            this.moduleInfoFiles = List.nil();
            this.treesToClean = set;
        }

        Round(List<JCTree.JCCompilationUnit> list, List<Symbol.ClassSymbol> list2, Set<JCTree.JCCompilationUnit> set, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this(1, set, deferredDiagnosticHandler);
            this.roots = list;
            this.genClassFiles = new HashMap<Symbol.ModuleSymbol, Map<String, JavaFileObject>>();
            this.topLevelClasses = javacProcessingEnvironment.getTopLevelClasses(list).prependList(list2.reverse());
            this.packageInfoFiles = javacProcessingEnvironment.getPackageInfoFiles(list);
            this.moduleInfoFiles = javacProcessingEnvironment.getModuleInfoFiles(list);
            this.findAnnotationsPresent();
        }

        private Round(Round round, Set<JavaFileObject> set, Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> map) {
            this(round.number + 1, round.treesToClean, null);
            round.newRound();
            this.genClassFiles = round.genClassFiles;
            List<JCTree.JCCompilationUnit> list = javacProcessingEnvironment.compiler.parseFiles(set, true);
            this.roots = round.roots.appendList(list);
            if (this.unrecoverableError()) {
                javacProcessingEnvironment.compiler.initModules(List.nil());
                return;
            }
            this.roots = javacProcessingEnvironment.compiler.initModules(this.roots);
            this.enterClassFiles(this.genClassFiles);
            List<Symbol.ClassSymbol> list2 = this.enterClassFiles(map);
            for (Map.Entry<Symbol.ModuleSymbol, Map<String, JavaFileObject>> entry : map.entrySet()) {
                this.genClassFiles.computeIfAbsent(entry.getKey(), moduleSymbol -> new LinkedHashMap()).putAll(entry.getValue());
            }
            this.enterTrees(this.roots);
            if (this.unrecoverableError()) {
                return;
            }
            this.topLevelClasses = JavacProcessingEnvironment.join(javacProcessingEnvironment.getTopLevelClasses(list), javacProcessingEnvironment.getTopLevelClassesFromClasses(list2));
            this.packageInfoFiles = JavacProcessingEnvironment.join(javacProcessingEnvironment.getPackageInfoFiles(list), javacProcessingEnvironment.getPackageInfoFilesFromClasses(list2));
            this.moduleInfoFiles = List.nil();
            this.findAnnotationsPresent();
        }

        Round next(Set<JavaFileObject> set, Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> map) {
            return new Round(this, set, map);
        }

        void finalCompiler() {
            this.newRound();
        }

        int errorCount() {
            return JavacProcessingEnvironment.this.compiler.errorCount();
        }

        int warningCount() {
            return JavacProcessingEnvironment.this.compiler.warningCount();
        }

        boolean unrecoverableError() {
            if (JavacProcessingEnvironment.this.messager.errorRaised()) {
                return true;
            }
            return this.deferredDiagnosticHandler.getDiagnostics().stream().anyMatch(jCDiagnostic -> jCDiagnostic.getKind() == Diagnostic.Kind.WARNING && JavacProcessingEnvironment.this.werror || jCDiagnostic.getKind() == Diagnostic.Kind.ERROR && (JavacProcessingEnvironment.this.fatalErrors || !jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)));
        }

        void findAnnotationsPresent() {
            ComputeAnnotationSet computeAnnotationSet = new ComputeAnnotationSet(JavacProcessingEnvironment.this.elementUtils);
            this.annotationsPresent = new LinkedHashSet<TypeElement>();
            for (Symbol.ClassSymbol typeSymbol : this.topLevelClasses) {
                computeAnnotationSet.scan((Element)typeSymbol, this.annotationsPresent);
            }
            for (Symbol.PackageSymbol packageSymbol : this.packageInfoFiles) {
                computeAnnotationSet.scan((Element)packageSymbol, this.annotationsPresent);
            }
            for (Symbol.ModuleSymbol moduleSymbol : this.moduleInfoFiles) {
                computeAnnotationSet.scan((Element)moduleSymbol, this.annotationsPresent);
            }
        }

        private List<Symbol.ClassSymbol> enterClassFiles(Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> map) {
            List<Symbol.ClassSymbol> list = List.nil();
            for (Map.Entry<Symbol.ModuleSymbol, Map<String, JavaFileObject>> entry : map.entrySet()) {
                for (Map.Entry<String, JavaFileObject> entry2 : entry.getValue().entrySet()) {
                    Symbol.ClassSymbol classSymbol;
                    Name name = JavacProcessingEnvironment.this.names.fromString(entry2.getKey());
                    JavaFileObject javaFileObject = entry2.getValue();
                    if (javaFileObject.getKind() != JavaFileObject.Kind.CLASS) {
                        throw new AssertionError(javaFileObject);
                    }
                    if (JavacProcessingEnvironment.this.isPkgInfo(javaFileObject, JavaFileObject.Kind.CLASS)) {
                        Name name2 = Convert.packagePart(name);
                        Symbol.PackageSymbol packageSymbol = JavacProcessingEnvironment.this.symtab.enterPackage(entry.getKey(), name2);
                        if (packageSymbol.package_info == null) {
                            packageSymbol.package_info = JavacProcessingEnvironment.this.symtab.enterClass(entry.getKey(), Convert.shortName(name), packageSymbol);
                        }
                        classSymbol = packageSymbol.package_info;
                        classSymbol.reset();
                        if (classSymbol.classfile == null) {
                            classSymbol.classfile = javaFileObject;
                        }
                        classSymbol.completer = JavacProcessingEnvironment.this.initialCompleter;
                    } else {
                        classSymbol = JavacProcessingEnvironment.this.symtab.enterClass(entry.getKey(), name);
                        classSymbol.reset();
                        classSymbol.classfile = javaFileObject;
                        classSymbol.completer = JavacProcessingEnvironment.this.initialCompleter;
                        if (classSymbol.owner.kind == Kinds.Kind.PCK) {
                            classSymbol.owner.members().enter(classSymbol);
                        }
                    }
                    list = list.prepend(classSymbol);
                }
            }
            return list.reverse();
        }

        private void enterTrees(List<JCTree.JCCompilationUnit> list) {
            JavacProcessingEnvironment.this.compiler.enterTrees(list);
        }

        void run(boolean bl, boolean bl2) {
            this.printRoundInfo(bl);
            if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                JavacProcessingEnvironment.this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            try {
                if (bl) {
                    JavacProcessingEnvironment.this.filer.setLastRound(true);
                    Set set = Collections.emptySet();
                    JavacRoundEnvironment javacRoundEnvironment = new JavacRoundEnvironment(true, bl2, set, JavacProcessingEnvironment.this);
                    JavacProcessingEnvironment.this.discoveredProcs.iterator().runContributingProcs(javacRoundEnvironment);
                } else {
                    JavacProcessingEnvironment.this.discoverAndRunProcs(this.annotationsPresent, this.topLevelClasses, this.packageInfoFiles, this.moduleInfoFiles);
                }
            }
            catch (Throwable throwable) {
                JavacProcessingEnvironment.this.compiler.reportDeferredDiagnosticAndClearHandler();
                throw throwable;
            }
            finally {
                if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                    JavacProcessingEnvironment.this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
            }
        }

        void showDiagnostics(boolean bl) {
            this.deferredDiagnosticHandler.reportDeferredDiagnostics(bl ? this.ACCEPT_ALL : this.ACCEPT_NON_RECOVERABLE);
            JavacProcessingEnvironment.this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
            JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(null);
        }

        private void printRoundInfo(boolean bl) {
            if (JavacProcessingEnvironment.this.printRounds || JavacProcessingEnvironment.this.verbose) {
                List<Object> list = bl ? List.nil() : this.topLevelClasses;
                Set<Object> set = bl ? Collections.emptySet() : this.annotationsPresent;
                JavacProcessingEnvironment.this.log.printLines("x.print.rounds", this.number, "{" + list.toString(", ") + "}", set, bl);
            }
        }

        private void newRound() {
            for (Env<AttrContext> iterator : JavacProcessingEnvironment.this.enter.getEnvs()) {
                this.treesToClean.add(iterator.toplevel);
            }
            for (JCTree.JCCompilationUnit jCCompilationUnit : this.treesToClean) {
                JavacProcessingEnvironment.this.treeCleaner.scan(jCCompilationUnit);
            }
            JavacProcessingEnvironment.this.chk.newRound();
            JavacProcessingEnvironment.this.enter.newRound();
            JavacProcessingEnvironment.this.filer.newRound();
            JavacProcessingEnvironment.this.messager.newRound();
            JavacProcessingEnvironment.this.compiler.newRound();
            JavacProcessingEnvironment.this.modules.newRound();
            JavacProcessingEnvironment.this.types.newRound();
            JavacProcessingEnvironment.this.annotate.newRound();
            JavacProcessingEnvironment.this.elementUtils.newRound();
            boolean bl = false;
            for (Symbol.ClassSymbol classSymbol : JavacProcessingEnvironment.this.symtab.getAllClasses()) {
                if (classSymbol.kind != Kinds.Kind.ERR) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (Symbol.ClassSymbol classSymbol : JavacProcessingEnvironment.this.symtab.getAllClasses()) {
                    if (classSymbol.classfile == null && classSymbol.kind != Kinds.Kind.ERR) continue;
                    Kinds.Kind kind = classSymbol.kind;
                    classSymbol.reset();
                    if (kind == Kinds.Kind.ERR) {
                        classSymbol.type = new Type.ClassType(classSymbol.type.getEnclosingType(), null, classSymbol);
                    }
                    if (!classSymbol.isCompleted()) continue;
                    classSymbol.completer = JavacProcessingEnvironment.this.initialCompleter;
                }
            }
        }
    }

    class ImplicitCompleter
    implements Symbol.Completer {
        private final JCTree.JCCompilationUnit topLevel;

        public ImplicitCompleter(JCTree.JCCompilationUnit jCCompilationUnit) {
            this.topLevel = jCCompilationUnit;
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            JavacProcessingEnvironment.this.compiler.readSourceFile(this.topLevel, (Symbol.ClassSymbol)symbol);
        }
    }

    public static class ComputeAnnotationSet
    extends ElementScanner14<Set<TypeElement>, Set<TypeElement>> {
        final Elements elements;

        public ComputeAnnotationSet(Elements elements) {
            this.elements = elements;
        }

        @Override
        public Set<TypeElement> visitPackage(PackageElement packageElement, Set<TypeElement> set) {
            return set;
        }

        @Override
        public Set<TypeElement> visitType(TypeElement typeElement, Set<TypeElement> set) {
            this.scan(typeElement.getTypeParameters(), set);
            return (Set)super.visitType(typeElement, set);
        }

        @Override
        public Set<TypeElement> visitExecutable(ExecutableElement executableElement, Set<TypeElement> set) {
            this.scan(executableElement.getTypeParameters(), set);
            return (Set)super.visitExecutable(executableElement, set);
        }

        void addAnnotations(Element element, Set<TypeElement> set) {
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(element)) {
                Element element2 = annotationMirror.getAnnotationType().asElement();
                set.add((TypeElement)element2);
            }
        }

        @Override
        public Set<TypeElement> scan(Element element, Set<TypeElement> set) {
            this.addAnnotations(element, set);
            return (Set)super.scan(element, set);
        }
    }
}

