/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class Scanner
implements Lexer {
    protected Tokens tokens;
    private Tokens.Token token;
    private Tokens.Token prevToken;
    private final List<Tokens.Token> savedTokens = new ArrayList<Tokens.Token>();
    private final JavaTokenizer tokenizer;
    private final Queue<Tokens.Comment> docComments = new ArrayDeque<Tokens.Comment>();

    protected Scanner(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        this(scannerFactory, new JavaTokenizer(scannerFactory, charBuffer));
    }

    protected Scanner(ScannerFactory scannerFactory, char[] cArray, int n) {
        this(scannerFactory, new JavaTokenizer(scannerFactory, cArray, n));
    }

    protected Scanner(ScannerFactory scannerFactory, JavaTokenizer javaTokenizer) {
        this.tokenizer = javaTokenizer;
        this.tokens = scannerFactory.tokens;
        this.token = this.prevToken = Tokens.DUMMY;
    }

    @Override
    public Tokens.Token token() {
        return this.token(0);
    }

    @Override
    public Tokens.Token token(int n) {
        if (n == 0) {
            return this.token;
        }
        this.ensureLookahead(n);
        return this.savedTokens.get(n - 1);
    }

    private void ensureLookahead(int n) {
        for (int i = this.savedTokens.size(); i < n; ++i) {
            this.savedTokens.add(this.tokenizer.readToken());
        }
    }

    @Override
    public Tokens.Token prevToken() {
        return this.prevToken;
    }

    @Override
    public void setPrevToken(Tokens.Token token) {
        this.prevToken = token;
    }

    @Override
    public void nextToken() {
        this.prevToken = this.token;
        if (!this.savedTokens.isEmpty()) {
            this.token = this.savedTokens.remove(0);
        } else {
            this.token = this.tokenizer.readToken();
            if (this.token.comments != null) {
                for (Tokens.Comment comment : this.token.comments) {
                    switch (comment.getStyle()) {
                        case JAVADOC_BLOCK: 
                        case JAVADOC_LINE: {
                            this.docComments.add(comment);
                        }
                    }
                }
            }
        }
    }

    @Override
    public Tokens.Token split() {
        Tokens.Token[] tokenArray = this.token.split(this.tokens);
        this.prevToken = tokenArray[0];
        this.token = tokenArray[1];
        return this.token;
    }

    @Override
    public Position.LineMap getLineMap() {
        return this.tokenizer.getLineMap();
    }

    @Override
    public Queue<Tokens.Comment> getDocComments() {
        return this.docComments;
    }

    @Override
    public int errPos() {
        return this.tokenizer.errPos();
    }

    @Override
    public void errPos(int n) {
        this.tokenizer.errPos(n);
    }
}

