/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import javax.tools.JavaFileObject;
import nbjavac.StringWrapper;

public class ReferenceParser {
    private final ParserFactory fac;

    public ReferenceParser(ParserFactory parserFactory) {
        this.fac = parserFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference parse(String string, Mode mode) throws ParseException {
        List<JCTree> list;
        Name name;
        JCTree jCTree;
        JCTree.JCExpression jCExpression;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int n = string.indexOf("/");
            int n2 = n + 1;
            int n3 = string.indexOf("#", n2);
            int n4 = n3 + 1;
            int n5 = string.indexOf("(", Math.max(n, n3) + 1);
            int n6 = n5 + 1;
            switch (n) {
                case -1: {
                    JCTree.JCExpression jCExpression2 = null;
                    break;
                }
                case 0: {
                    throw new ParseException(0, "dc.ref.syntax.error");
                }
                default: {
                    JCTree.JCExpression jCExpression2 = jCExpression = this.parseModule(string, 0, n, deferredDiagnosticHandler);
                }
            }
            if (n > 0 && string.length() == n2) {
                jCTree = null;
                name = null;
            } else if (n3 == -1) {
                if (n5 == -1 && mode != Mode.MEMBER_REQUIRED) {
                    jCTree = this.parseType(string, n2, string.length(), deferredDiagnosticHandler);
                    name = null;
                } else {
                    if (mode == Mode.MEMBER_DISALLOWED) {
                        throw new ParseException(n3, "dc.ref.unexpected.input");
                    }
                    jCTree = null;
                    name = this.parseMember(string, n2, n5 > -1 ? n5 : string.length(), deferredDiagnosticHandler);
                }
            } else {
                if (mode == Mode.MEMBER_DISALLOWED) {
                    throw new ParseException(n3, "dc.ref.unexpected.input");
                }
                JCTree jCTree2 = jCTree = n3 == n2 ? null : this.parseType(string, n2, n3, deferredDiagnosticHandler);
                if (string.indexOf("#", n4) == n4) {
                    if (mode != Mode.MEMBER_OPTIONAL) {
                        throw new ParseException(n4, "dc.ref.unexpected.input");
                    }
                    name = null;
                } else {
                    name = n5 == -1 ? this.parseMember(string, n4, string.length(), deferredDiagnosticHandler) : this.parseMember(string, n4, n5, deferredDiagnosticHandler);
                }
            }
            if (n5 == -1) {
                list = null;
            } else {
                int n7 = string.indexOf(")", n5);
                if (n7 != string.length() - 1) {
                    throw new ParseException(n7, "dc.ref.bad.parens");
                }
                list = this.parseParams(string, n6, n7, deferredDiagnosticHandler);
            }
            assert (deferredDiagnosticHandler.getDiagnostics().isEmpty());
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return new Reference(jCExpression, jCTree, name, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression parseModule(String string, int n, int n2, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) throws ParseException {
        String string2 = string.substring(n, n2);
        JavaFileObject javaFileObject = this.fac.log.useSource(null);
        try {
            JavacParser javacParser = this.fac.newParser(string2, false, false, false);
            JCTree.JCExpression jCExpression = javacParser.qualident(false);
            if (javacParser.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(n + javacParser.token().pos, "dc.ref.unexpected.input");
            }
            this.checkDiags(deferredDiagnosticHandler, n);
            JCTree.JCExpression jCExpression2 = jCExpression;
            return jCExpression2;
        }
        finally {
            this.fac.log.useSource(javaFileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree parseType(String string, int n, int n2, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) throws ParseException {
        String string2 = string.substring(n, n2);
        JavaFileObject javaFileObject = this.fac.log.useSource(null);
        try {
            JavacParser javacParser = this.fac.newParser(string2, false, false, false);
            JCTree.JCExpression jCExpression = javacParser.parseType();
            if (javacParser.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(n + javacParser.token().pos, "dc.ref.unexpected.input");
            }
            this.checkDiags(deferredDiagnosticHandler, n);
            JCTree.JCExpression jCExpression2 = jCExpression;
            return jCExpression2;
        }
        finally {
            this.fac.log.useSource(javaFileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Name parseMember(String string, int n, int n2, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) throws ParseException {
        String string2 = string.substring(n, n2);
        JavaFileObject javaFileObject = this.fac.log.useSource(null);
        try {
            JavacParser javacParser = this.fac.newParser(string2, false, false, false);
            Name name = javacParser.ident();
            if (javacParser.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(n + javacParser.token().pos, "dc.ref.unexpected.input");
            }
            this.checkDiags(deferredDiagnosticHandler, n);
            Name name2 = name;
            return name2;
        }
        finally {
            this.fac.log.useSource(javaFileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JCTree> parseParams(String string, int n, int n2, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) throws ParseException {
        String string2 = string.substring(n, n2);
        if (StringWrapper.isBlank(string2)) {
            return List.nil();
        }
        JavaFileObject javaFileObject = this.fac.log.useSource(null);
        try {
            JavacParser javacParser = this.fac.newParser(string2.replace("...", "[]"), false, false, false);
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            listBuffer.add(javacParser.parseType());
            if (javacParser.token().kind == Tokens.TokenKind.IDENTIFIER) {
                javacParser.nextToken();
            }
            while (javacParser.token().kind == Tokens.TokenKind.COMMA) {
                javacParser.nextToken();
                listBuffer.add(javacParser.parseType());
                if (javacParser.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
                javacParser.nextToken();
            }
            if (javacParser.token().kind != Tokens.TokenKind.EOF) {
                throw new ParseException(javacParser.token().pos, "dc.ref.unexpected.input");
            }
            Tree tree = (Tree)new TypeAnnotationFinder().scan(listBuffer, null);
            if (tree != null) {
                int n3 = ((JCTree)tree).getStartPosition();
                throw new ParseException(n + n3, "dc.ref.annotations.not.allowed");
            }
            this.checkDiags(deferredDiagnosticHandler, n);
            List<JCTree> list = listBuffer.toList();
            return list;
        }
        finally {
            this.fac.log.useSource(javaFileObject);
        }
    }

    private void checkDiags(Log.DeferredDiagnosticHandler deferredDiagnosticHandler, int n) throws ParseException {
        java.util.List<JCDiagnostic> list = deferredDiagnosticHandler.getDiagnostics();
        if (!list.isEmpty()) {
            int n2 = n + (int)list.get(0).getPosition();
            throw new ParseException(n2, "dc.ref.syntax.error");
        }
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;
        final int pos;

        ParseException(int n, String string) {
            super(string);
            this.pos = n;
        }
    }

    public static enum Mode {
        MEMBER_DISALLOWED,
        MEMBER_OPTIONAL,
        MEMBER_REQUIRED;

    }

    public static class Reference {
        public final JCTree.JCExpression moduleName;
        public final JCTree qualExpr;
        public final Name member;
        public final List<JCTree> paramTypes;

        Reference(JCTree.JCExpression jCExpression, JCTree jCTree, Name name, List<JCTree> list) {
            this.moduleName = jCExpression;
            this.qualExpr = jCTree;
            this.member = name;
            this.paramTypes = list;
        }
    }

    static class TypeAnnotationFinder
    extends TreeScanner<Tree, Void> {
        TypeAnnotationFinder() {
        }

        @Override
        public Tree visitAnnotatedType(AnnotatedTypeTree annotatedTypeTree, Void void_) {
            return annotatedTypeTree;
        }

        @Override
        public Tree reduce(Tree tree, Tree tree2) {
            return tree != null ? tree : tree2;
        }
    }
}

