/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.DocCommentTree;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.DiagnosticSource;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.util.Elements;

public class LazyDocCommentTable
implements DocCommentTable {
    private final ParserFactory fac;
    private final DiagnosticSource diagSource;
    private final Map<JCTree, Entry> table;

    LazyDocCommentTable(ParserFactory parserFactory) {
        this.fac = parserFactory;
        this.diagSource = parserFactory.log.currentSource();
        this.table = new HashMap<JCTree, Entry>();
    }

    @Override
    public boolean hasComment(JCTree jCTree) {
        return this.table.containsKey(jCTree);
    }

    @Override
    public Tokens.Comment getComment(JCTree jCTree) {
        Entry entry = this.table.get(jCTree);
        return entry == null ? null : entry.comment;
    }

    @Override
    public Elements.DocCommentKind getCommentKind(JCTree jCTree) {
        Elements.DocCommentKind docCommentKind;
        Tokens.Comment comment = this.getComment(jCTree);
        if (comment == null) {
            docCommentKind = null;
        } else {
            switch (comment.getStyle()) {
                case JAVADOC_BLOCK: {
                    docCommentKind = Elements.DocCommentKind.TRADITIONAL;
                    break;
                }
                case JAVADOC_LINE: {
                    docCommentKind = Elements.DocCommentKind.END_OF_LINE;
                    break;
                }
                default: {
                    throw new IllegalStateException(comment.getStyle().toString());
                }
            }
        }
        return docCommentKind;
    }

    @Override
    public String getCommentText(JCTree jCTree) {
        Tokens.Comment comment = this.getComment(jCTree);
        return comment == null ? null : comment.getText();
    }

    @Override
    public DocCommentTree getCommentTree(JCTree jCTree) {
        Entry entry = this.table.get(jCTree);
        if (entry == null) {
            return null;
        }
        if (entry.tree == null) {
            entry.tree = this.fac.getTrees().getDocCommentTree(this.diagSource, entry.comment);
        }
        return entry.tree;
    }

    @Override
    public void putComment(JCTree jCTree, Tokens.Comment comment) {
        this.table.put(jCTree, new Entry(comment));
    }

    private static class Entry {
        final Tokens.Comment comment;
        DocCommentTree tree;

        Entry(Tokens.Comment comment) {
            this.comment = comment;
        }
    }
}

