/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.Arrays;

public class JavadocTokenizer
extends JavaTokenizer {
    final ScannerFactory fac;

    protected JavadocTokenizer(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        super(scannerFactory, charBuffer);
        this.fac = scannerFactory;
    }

    protected JavadocTokenizer(ScannerFactory scannerFactory, char[] cArray, int n) {
        super(scannerFactory, cArray, n);
        this.fac = scannerFactory;
    }

    @Override
    protected Tokens.Comment processComment(int n, int n2, Tokens.Comment.CommentStyle commentStyle) {
        return new JavadocComment(commentStyle, this, n, n2);
    }

    @Override
    public Position.LineMap getLineMap() {
        char[] cArray = this.getRawCharacters();
        return Position.makeLineMap(cArray, cArray.length, true);
    }

    protected static class JavadocComment
    extends JavaTokenizer.BasicComment {
        private String docComment = null;
        private StringBuilder sb;
        private boolean firstLine = true;
        OffsetMap offsetMap = new OffsetMap();

        JavadocComment(Tokens.Comment.CommentStyle commentStyle, UnicodeReader unicodeReader, int n, int n2) {
            super(commentStyle, unicodeReader, n, n2);
            this.sb = new StringBuilder();
        }

        @Override
        protected void putLine(UnicodeReader unicodeReader) {
            if (this.firstLine) {
                this.firstLine = false;
            } else {
                this.sb.append('\n');
                this.offsetMap.add(this.sb.length(), unicodeReader.position());
            }
            while (unicodeReader.isAvailable()) {
                this.offsetMap.add(this.sb.length(), unicodeReader.position());
                if (unicodeReader.isSurrogate()) {
                    this.sb.appendCodePoint(unicodeReader.getCodepoint());
                } else {
                    this.sb.append(unicodeReader.get());
                }
                unicodeReader.next();
            }
        }

        @Override
        public String getText() {
            if (!this.scanned) {
                this.scanDocComment();
            }
            return this.docComment;
        }

        @Override
        public int getSourcePos(int n) {
            if (n == -1) {
                return -1;
            }
            if (n < 0 || n > this.docComment.length()) {
                throw new StringIndexOutOfBoundsException(String.valueOf(n));
            }
            return this.offsetMap.getSourcePos(n);
        }

        @Override
        protected void scanDocComment() {
            try {
                super.scanDocComment();
            }
            finally {
                this.docComment = this.sb.toString();
                this.sb = null;
                this.offsetMap.trim();
            }
        }

        @Override
        public Tokens.Comment stripIndent() {
            return StrippedComment.of(this);
        }
    }

    static class StrippedComment
    implements Tokens.Comment {
        String text;
        final OffsetMap strippedMap;
        final OffsetMap sourceMap;
        final JCDiagnostic.DiagnosticPosition diagPos;
        final Tokens.Comment.CommentStyle style;
        final boolean deprecated;

        static Tokens.Comment of(JavadocComment javadocComment) {
            if (javadocComment.getStyle() != Tokens.Comment.CommentStyle.JAVADOC_BLOCK) {
                return javadocComment;
            }
            int n = StrippedComment.getIndent(javadocComment);
            return n > 0 ? new StrippedComment(javadocComment, n) : javadocComment;
        }

        private StrippedComment(JavadocComment javadocComment, int n) {
            this.diagPos = javadocComment.getPos();
            this.style = javadocComment.getStyle();
            this.deprecated = javadocComment.isDeprecated();
            this.strippedMap = new OffsetMap();
            this.sourceMap = javadocComment.offsetMap;
            this.stripComment(javadocComment, n);
        }

        static int getIndent(Tokens.Comment comment) {
            String string = comment.getText();
            int n = string.length();
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                boolean bl = true;
                for (n4 = n3; n4 < n && string.charAt(n4) != '\n'; ++n4) {
                    if (!bl || Character.isWhitespace(string.charAt(n4))) continue;
                    n2 = Math.min(n2, n4 - n3);
                    bl = false;
                }
                n3 = n4 + 1;
            }
            return n2 == Integer.MAX_VALUE ? 0 : n2;
        }

        private void stripComment(JavadocComment javadocComment, int n) {
            String string = javadocComment.getText();
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                for (n4 = n3; n4 < n2 && n4 < n3 + n && string.charAt(n4) != '\n'; ++n4) {
                    assert (Character.isWhitespace(string.charAt(n4)));
                }
                if (n4 == n2) break;
                for (n3 = n4 + 1; n3 < n2 && string.charAt(n3 - 1) != '\n'; ++n3) {
                }
                this.strippedMap.add(stringBuilder.length(), n4);
                stringBuilder.append(string, n4, n3);
            }
            this.text = stringBuilder.toString();
            this.strippedMap.trim();
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public Tokens.Comment stripIndent() {
            return this;
        }

        @Override
        public int getSourcePos(int n) {
            if (n == -1) {
                return -1;
            }
            if (n < 0 || n > this.text.length()) {
                throw new StringIndexOutOfBoundsException(String.valueOf(n));
            }
            return this.sourceMap.getSourcePos(this.strippedMap.getSourcePos(n));
        }

        @Override
        public JCDiagnostic.DiagnosticPosition getPos() {
            return this.diagPos;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.style;
        }

        @Override
        public boolean isDeprecated() {
            return this.deprecated;
        }
    }

    static class OffsetMap {
        private static final int SB_OFFSET = 0;
        private static final int POS_OFFSET = 1;
        private static final int NOFFSETS = 2;
        private int[] map = new int[128];
        private int size = 0;

        OffsetMap() {
        }

        boolean shouldAdd(int n, int n2) {
            return n - this.lastSBOffset() != n2 - this.lastPosOffset();
        }

        void add(int n, int n2) {
            if (this.size == 0 || this.shouldAdd(n, n2)) {
                this.ensure(2);
                this.map[this.size + 0] = n;
                this.map[this.size + 1] = n2;
                this.size += 2;
            }
        }

        private int lastSBOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 0];
        }

        private int lastPosOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 1];
        }

        private void ensure(int n) {
            n += this.size;
            int n2 = this.map.length;
            while (n > n2) {
                if ((n2 <<= 1) > 0) continue;
                throw new IndexOutOfBoundsException();
            }
            if (n2 != this.map.length) {
                this.map = Arrays.copyOf(this.map, n2);
            }
        }

        void trim() {
            this.map = Arrays.copyOf(this.map, this.size);
        }

        int getSourcePos(int n) {
            int n2;
            if (this.size == 0) {
                return -1;
            }
            int n3 = 0;
            int n4 = this.size / 2;
            while (n3 < n4 - 1) {
                n2 = (n3 + n4) / 2;
                int n5 = n2 * 2;
                if (this.map[n5 + 0] < n) {
                    n3 = n2;
                    continue;
                }
                if (this.map[n5 + 0] == n) {
                    return this.map[n5 + 1];
                }
                n4 = n2;
            }
            n2 = n3 * 2;
            return this.map[n2 + 1] + (n - this.map[n2 + 0]);
        }
    }
}

