/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.TextBlockSupport;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.Set;
import nbjavac.StringWrapper;

public class JavaTokenizer
extends UnicodeReader {
    private static final boolean scannerDebug = false;
    private static final int NOT_FOUND = -1;
    private final Source source;
    private final Preview preview;
    protected final boolean enableLineDocComments;
    private final Log log;
    private final Tokens tokens;
    private final Names names;
    protected final ScannerFactory fac;
    protected final StringBuilder sb;
    protected Tokens.TokenKind tk;
    protected int radix;
    protected Name name;
    protected int errPos = -1;
    protected boolean isTextBlock;
    protected boolean hasEscapeSequences;
    protected final Lint lint;

    protected JavaTokenizer(ScannerFactory scannerFactory, CharBuffer charBuffer) {
        this(scannerFactory, JavacFileManager.toArray(charBuffer), charBuffer.limit());
    }

    protected JavaTokenizer(ScannerFactory scannerFactory, char[] cArray, int n) {
        super(scannerFactory, cArray, n);
        this.fac = scannerFactory;
        this.log = scannerFactory.log;
        this.names = scannerFactory.names;
        this.tokens = scannerFactory.tokens;
        this.source = scannerFactory.source;
        this.preview = scannerFactory.preview;
        this.enableLineDocComments = scannerFactory.enableLineDocComments;
        this.lint = scannerFactory.lint;
        this.sb = new StringBuilder(256);
    }

    protected void checkSourceLevel(int n, Source.Feature feature) {
        if (this.preview.isPreview(feature) && !this.preview.isEnabled()) {
            this.lexError(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, n, this.preview.disabledError(feature));
        } else if (!feature.allowedInSource(this.source)) {
            this.lexError(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, n, feature.error(this.source.name));
        } else if (this.preview.isPreview(feature)) {
            this.preview.warnPreview(n, feature);
        }
    }

    protected void lexError(int n, JCDiagnostic.Error error) {
        this.log.error(n, error);
        this.tk = Tokens.TokenKind.ERROR;
        this.errPos = n;
    }

    protected void lexError(JCDiagnostic.DiagnosticFlag diagnosticFlag, int n, JCDiagnostic.Error error) {
        this.log.error(diagnosticFlag, n, error);
        if (diagnosticFlag != JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL) {
            this.tk = Tokens.TokenKind.ERROR;
        }
        this.errPos = n;
    }

    protected void lexWarning(int n, JCDiagnostic.LintWarning lintWarning) {
        JCDiagnostic.SimpleDiagnosticPosition simpleDiagnosticPosition = new JCDiagnostic.SimpleDiagnosticPosition(n);
        this.log.warning(simpleDiagnosticPosition, (JCDiagnostic.Warning)lintWarning);
    }

    protected void put(char c) {
        this.sb.append(c);
    }

    protected void putCodePoint(int n) {
        this.sb.appendCodePoint(n);
    }

    protected void put() {
        if (this.isSurrogate()) {
            this.putCodePoint(this.getCodepoint());
        } else {
            this.put(this.get());
        }
    }

    protected void put(String string) {
        this.sb.append(string);
    }

    protected char putThenNext() {
        this.put();
        return this.next();
    }

    protected boolean acceptThenPut(char c) {
        if (this.is(c)) {
            this.put(this.get());
            this.next();
            return true;
        }
        return false;
    }

    protected boolean acceptOneOfThenPut(char c, char c2) {
        if (this.isOneOf(c, c2)) {
            this.put(this.get());
            this.next();
            return true;
        }
        return false;
    }

    private void skipLineTerminator() {
        int n = this.position();
        this.accept('\r');
        this.accept('\n');
        this.processLineTerminator(n, this.position());
    }

    private void scanLitChar(int n, boolean bl) {
        block11: {
            block10: {
                int n2 = this.position();
                if (!this.acceptThenPut('\\')) break block10;
                this.hasEscapeSequences = true;
                switch (this.get()) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char c = this.get();
                        this.putThenNext();
                        if (this.inRange('0', '7')) {
                            this.putThenNext();
                            if (c <= '3' && this.inRange('0', '7')) {
                                this.putThenNext();
                                break;
                            }
                        }
                        break block11;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        this.putThenNext();
                        break;
                    }
                    case 's': {
                        this.checkSourceLevel(this.position(), Source.Feature.TEXT_BLOCKS);
                        this.putThenNext();
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (this.isTextBlock) {
                            this.skipLineTerminator();
                            this.put('\n');
                            break;
                        }
                        this.lexError(this.position(), CompilerProperties.Errors.IllegalEscChar);
                        break;
                    }
                    default: {
                        this.lexError(this.position(), CompilerProperties.Errors.IllegalEscChar);
                        break;
                    }
                }
                break block11;
            }
            if (!bl && !Character.isBmpCodePoint(this.getCodepoint())) {
                this.lexError(n, CompilerProperties.Errors.IllegalCharLiteralMultipleSurrogates);
            }
            this.putThenNext();
        }
    }

    private void scanString(int n) {
        int n2 = -1;
        this.tk = Tokens.TokenKind.STRINGLITERAL;
        this.isTextBlock = this.accept("\"\"\"");
        if (this.isTextBlock) {
            this.checkSourceLevel(n, Source.Feature.TEXT_BLOCKS);
            this.skipWhitespace();
            if (this.isEOLN()) {
                this.skipLineTerminator();
            } else {
                this.lexError(this.position(), CompilerProperties.Errors.IllegalTextBlockOpen);
                return;
            }
            while (this.isAvailable()) {
                if (this.accept("\"\"\"")) {
                    return;
                }
                if (this.isEOLN()) {
                    this.skipLineTerminator();
                    this.put('\n');
                    if (n2 != -1) continue;
                    n2 = this.position();
                    continue;
                }
                this.scanLitChar(n, true);
            }
        } else {
            this.next();
            while (this.isAvailable()) {
                if (this.accept('\"')) {
                    return;
                }
                if (!this.isEOLN()) {
                    this.scanLitChar(n, true);
                    continue;
                }
                break;
            }
        }
        this.lexError(n, this.isTextBlock ? CompilerProperties.Errors.UnclosedTextBlock : CompilerProperties.Errors.UnclosedStrLit);
        if (n2 != -1) {
            this.reset(n2);
        }
    }

    private void scanDigits(int n, int n2) {
        int n3;
        int n4;
        int n5 = n4 = this.is('_') ? this.position() : -1;
        do {
            if (!this.is('_')) {
                this.put();
                n3 = -1;
            } else {
                n3 = this.position();
            }
            this.next();
        } while (this.digit(n, n2) >= 0 || this.is('_'));
        if (n4 != -1) {
            this.lexError(n4, CompilerProperties.Errors.IllegalUnderscore);
        } else if (n3 != -1) {
            this.lexError(n3, CompilerProperties.Errors.IllegalUnderscore);
        }
    }

    private void scanHexExponentAndSuffix(int n) {
        if (this.acceptOneOfThenPut('p', 'P')) {
            this.skipIllegalUnderscores();
            this.acceptOneOfThenPut('+', '-');
            this.skipIllegalUnderscores();
            if (this.digit(n, 10) >= 0) {
                this.scanDigits(n, 10);
            } else {
                this.lexError(n, CompilerProperties.Errors.MalformedFpLit);
            }
        } else {
            this.lexError(n, CompilerProperties.Errors.MalformedFpLit);
        }
        if (this.acceptOneOfThenPut('f', 'F')) {
            this.tk = Tokens.TokenKind.FLOATLITERAL;
            this.radix = 16;
        } else {
            this.acceptOneOfThenPut('d', 'D');
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
            this.radix = 16;
        }
    }

    private void scanFraction(int n) {
        this.skipIllegalUnderscores();
        if (this.digit(n, 10) >= 0) {
            this.scanDigits(n, 10);
        }
        int n2 = this.sb.length();
        if (this.acceptOneOfThenPut('e', 'E')) {
            this.skipIllegalUnderscores();
            this.acceptOneOfThenPut('+', '-');
            this.skipIllegalUnderscores();
            if (this.digit(n, 10) >= 0) {
                this.scanDigits(n, 10);
                return;
            }
            this.lexError(n, CompilerProperties.Errors.MalformedFpLit);
            this.sb.setLength(n2);
        }
    }

    private void scanFractionAndSuffix(int n) {
        this.radix = 10;
        this.scanFraction(n);
        if (this.acceptOneOfThenPut('f', 'F')) {
            this.tk = Tokens.TokenKind.FLOATLITERAL;
        } else {
            this.acceptOneOfThenPut('d', 'D');
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(int n, boolean bl) {
        this.radix = 16;
        Assert.check(this.is('.'));
        this.putThenNext();
        this.skipIllegalUnderscores();
        if (this.digit(n, 16) >= 0) {
            bl = true;
            this.scanDigits(n, 16);
        }
        if (!bl) {
            this.lexError(n, CompilerProperties.Errors.InvalidHexNumber);
        } else {
            this.scanHexExponentAndSuffix(n);
        }
    }

    private void skipIllegalUnderscores() {
        if (this.is('_')) {
            this.lexError(this.position(), CompilerProperties.Errors.IllegalUnderscore);
            this.skip('_');
        }
    }

    private void scanNumber(int n, int n2) {
        boolean bl;
        this.radix = n2;
        boolean bl2 = n2 == 8 || n2 == 10;
        int n3 = Math.max(10, n2);
        int n4 = this.digit(n, n3);
        boolean bl3 = n4 >= 0;
        boolean bl4 = bl = n4 >= 0 && n4 < n3;
        if (bl3) {
            this.scanDigits(n, n3);
        }
        if (n2 == 16 && this.is('.')) {
            this.scanHexFractionAndSuffix(n, bl3);
        } else if (bl3 && n2 == 16 && this.isOneOf('p', 'P')) {
            this.scanHexExponentAndSuffix(n);
        } else if (bl2 && this.is('.')) {
            this.putThenNext();
            this.scanFractionAndSuffix(n);
        } else if (bl2 && this.isOneOf('e', 'E', 'f', 'F', 'd', 'D')) {
            this.scanFractionAndSuffix(n);
        } else {
            if (!bl) {
                switch (n2) {
                    case 2: {
                        this.lexError(n, CompilerProperties.Errors.InvalidBinaryNumber);
                        break;
                    }
                    case 16: {
                        this.lexError(n, CompilerProperties.Errors.InvalidHexNumber);
                    }
                }
            }
            this.tk = this.acceptOneOf('l', 'L') ? Tokens.TokenKind.LONGLITERAL : Tokens.TokenKind.INTLITERAL;
        }
    }

    private void checkIdent() {
        this.name = this.names.fromString(this.sb.toString());
        this.tk = this.tokens.lookupKind(this.name);
    }

    private void scanIdent() {
        this.putThenNext();
        block5: while (true) {
            switch (this.get()) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u007f': {
                    this.next();
                    continue block5;
                }
                case '\u001a': {
                    if (this.isAvailable()) {
                        this.next();
                        continue block5;
                    }
                    this.checkIdent();
                    return;
                }
                default: {
                    boolean bl;
                    if (this.isASCII()) {
                        bl = false;
                    } else {
                        if (Character.isIdentifierIgnorable(this.get())) {
                            this.next();
                            continue block5;
                        }
                        boolean bl2 = bl = this.isSurrogate() ? Character.isJavaIdentifierPart(this.getCodepoint()) : Character.isJavaIdentifierPart(this.get());
                    }
                    if (bl) break;
                    this.checkIdent();
                    return;
                }
            }
            this.putThenNext();
        }
    }

    private boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.put();
            Tokens.TokenKind tokenKind = this.tokens.lookupKind(this.sb.toString());
            if (tokenKind == Tokens.TokenKind.IDENTIFIER) {
                this.sb.setLength(this.sb.length() - 1);
                break;
            }
            this.tk = tokenKind;
            this.next();
        } while (this.isSpecial(this.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tokens.Token readToken() {
        this.sb.setLength(0);
        this.name = null;
        this.radix = 0;
        this.isTextBlock = false;
        this.hasEscapeSequences = false;
        List<Tokens.Comment> list = null;
        try {
            Object object;
            int n;
            int n2;
            block30: while (true) {
                n2 = this.position();
                switch (this.get()) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        this.skipWhitespace();
                        this.processWhiteSpace(n2, this.position());
                        continue block30;
                    }
                    case '\n': {
                        this.next();
                        this.processLineTerminator(n2, this.position());
                        continue block30;
                    }
                    case '\r': {
                        this.next();
                        this.accept('\n');
                        this.processLineTerminator(n2, this.position());
                        continue block30;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        break block30;
                    }
                    case '0': {
                        this.next();
                        if (this.acceptOneOf('x', 'X')) {
                            this.skipIllegalUnderscores();
                            this.scanNumber(n2, 16);
                            break block30;
                        }
                        if (this.acceptOneOf('b', 'B')) {
                            this.skipIllegalUnderscores();
                            this.scanNumber(n2, 2);
                            break block30;
                        }
                        this.put('0');
                        if (this.is('_')) {
                            n = this.position();
                            this.skip('_');
                            if (this.digit(n2, 10) < 0) {
                                this.lexError(n, CompilerProperties.Errors.IllegalUnderscore);
                            }
                        }
                        this.scanNumber(n2, 8);
                        break block30;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(n2, 10);
                        break block30;
                    }
                    case '.': {
                        if (this.accept("...")) {
                            this.put("...");
                            this.tk = Tokens.TokenKind.ELLIPSIS;
                            break block30;
                        }
                        this.next();
                        n = this.position();
                        if (this.accept('.')) {
                            this.lexError(n, CompilerProperties.Errors.IllegalDot);
                            break block30;
                        }
                        if (this.digit(n2, 10) >= 0) {
                            this.put('.');
                            this.scanFractionAndSuffix(n2);
                            break block30;
                        }
                        this.tk = Tokens.TokenKind.DOT;
                        break block30;
                    }
                    case ',': {
                        this.next();
                        this.tk = Tokens.TokenKind.COMMA;
                        break block30;
                    }
                    case ';': {
                        this.next();
                        this.tk = Tokens.TokenKind.SEMI;
                        break block30;
                    }
                    case '(': {
                        this.next();
                        this.tk = Tokens.TokenKind.LPAREN;
                        break block30;
                    }
                    case ')': {
                        this.next();
                        this.tk = Tokens.TokenKind.RPAREN;
                        break block30;
                    }
                    case '[': {
                        this.next();
                        this.tk = Tokens.TokenKind.LBRACKET;
                        break block30;
                    }
                    case ']': {
                        this.next();
                        this.tk = Tokens.TokenKind.RBRACKET;
                        break block30;
                    }
                    case '{': {
                        this.next();
                        this.tk = Tokens.TokenKind.LBRACE;
                        break block30;
                    }
                    case '}': {
                        this.next();
                        this.tk = Tokens.TokenKind.RBRACE;
                        break block30;
                    }
                    case '/': {
                        this.next();
                        if (this.accept('/')) {
                            if (this.enableLineDocComments && this.accept('/')) {
                                do {
                                    this.skipToEOLN();
                                    n = this.position();
                                    this.skipLineTerminator();
                                    this.skipWhitespace();
                                } while (this.accept("///"));
                                list = this.appendComment(list, this.processComment(n2, n, Tokens.Comment.CommentStyle.JAVADOC_LINE));
                                continue block30;
                            }
                            this.skipToEOLN();
                            if (!this.isAvailable()) continue block30;
                            list = this.appendComment(list, this.processComment(n2, this.position(), Tokens.Comment.CommentStyle.LINE));
                            continue block30;
                        }
                        if (this.accept('*')) {
                            n = 0;
                            if (this.accept('*')) {
                                object = Tokens.Comment.CommentStyle.JAVADOC_BLOCK;
                                if (this.is('/')) {
                                    n = 1;
                                }
                            } else {
                                object = Tokens.Comment.CommentStyle.BLOCK;
                            }
                            if (n == 0) {
                                while (this.isAvailable()) {
                                    if (this.accept('*')) {
                                        if (!this.is('/')) continue;
                                        break;
                                    }
                                    this.next();
                                }
                            }
                            if (this.accept('/')) {
                                list = this.appendComment(list, this.processComment(n2, this.position(), (Tokens.Comment.CommentStyle)((Object)object)));
                                continue block30;
                            }
                            this.lexError(n2, CompilerProperties.Errors.UnclosedComment);
                            break block30;
                        }
                        if (this.accept('=')) {
                            this.tk = Tokens.TokenKind.SLASHEQ;
                            break block30;
                        }
                        this.tk = Tokens.TokenKind.SLASH;
                        break block30;
                    }
                    case '\'': {
                        this.next();
                        if (this.accept('\'')) {
                            this.lexError(n2, CompilerProperties.Errors.EmptyCharLit);
                            break block30;
                        }
                        if (this.isEOLN()) {
                            this.lexError(n2, CompilerProperties.Errors.IllegalLineEndInCharLit);
                        }
                        this.scanLitChar(n2, false);
                        if (this.tk == Tokens.TokenKind.ERROR) {
                            while (this.isAvailable() && !this.is('\'')) {
                                if (this.is('\\')) {
                                    this.next();
                                }
                                this.next();
                            }
                            this.accept('\'');
                            break block30;
                        }
                        if (this.accept('\'')) {
                            this.tk = Tokens.TokenKind.CHARLITERAL;
                            break block30;
                        }
                        this.lexError(n2, CompilerProperties.Errors.UnclosedCharLit);
                        break block30;
                    }
                    case '\"': {
                        this.scanString(n2);
                        break block30;
                    }
                    default: {
                        if (this.isSpecial(this.get())) {
                            this.scanOperator();
                            break block30;
                        }
                        n = this.isASCII() ? 0 : (int)((this.isSurrogate() ? Character.isJavaIdentifierStart(this.getCodepoint()) : Character.isJavaIdentifierStart(this.get())) ? 1 : 0);
                        if (n != 0) {
                            this.scanIdent();
                            break block30;
                        }
                        if (this.digit(n2, 10) >= 0) {
                            this.scanNumber(n2, 10);
                            break block30;
                        }
                        if (this.is('\u001a') || !this.isAvailable()) {
                            this.tk = Tokens.TokenKind.EOF;
                            n2 = this.position();
                            break block30;
                        }
                        if (this.isSurrogate()) {
                            int c = this.getCodepoint();
                            int n3 = Character.highSurrogate(c);
                            char c2 = Character.lowSurrogate(c);
                            object = String.format("\\u%04x\\u%04x", n3, (int)c2);
                        } else {
                            char set = this.get();
                            object = ' ' < set && set < '\u007f' ? String.valueOf(set) : String.format("\\u%04x", set);
                        }
                        this.lexError(n2, CompilerProperties.Errors.IllegalChar((String)object));
                        this.next();
                        break block30;
                    }
                }
                break;
            }
            n = this.position();
            if (this.tk.tag == Tokens.Token.Tag.DEFAULT) {
                object = new Tokens.Token(this.tk, n2, n, list);
                return object;
            }
            if (this.tk.tag == Tokens.Token.Tag.NAMED) {
                object = new Tokens.NamedToken(this.tk, n2, n, this.name, list);
                return object;
            }
            object = this.sb.toString();
            if (this.isTextBlock) {
                if (this.lint.isEnabled(Lint.LintCategory.TEXT_BLOCKS)) {
                    Set<TextBlockSupport.WhitespaceChecks> numericToken = TextBlockSupport.checkWhitespace((String)object);
                    if (numericToken.contains((Object)TextBlockSupport.WhitespaceChecks.INCONSISTENT)) {
                        this.lexWarning(n2, CompilerProperties.LintWarnings.InconsistentWhiteSpaceIndentation);
                    }
                    if (numericToken.contains((Object)TextBlockSupport.WhitespaceChecks.TRAILING)) {
                        this.lexWarning(n2, CompilerProperties.LintWarnings.TrailingWhiteSpaceWillBeRemoved);
                    }
                }
                try {
                    object = StringWrapper.stripIndent((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.hasEscapeSequences) {
                try {
                    object = StringWrapper.translateEscapes((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.tk.tag == Tokens.Token.Tag.STRING) {
                Tokens.StringToken stringToken = new Tokens.StringToken(this.tk, n2, n, (String)object, list);
                return stringToken;
            }
            Tokens.NumericToken numericToken = new Tokens.NumericToken(this.tk, n2, n, (String)object, this.radix, list);
            return numericToken;
        }
        finally {
            int exception = this.position();
        }
    }

    List<Tokens.Comment> appendComment(List<Tokens.Comment> list, Tokens.Comment comment) {
        return list == null ? List.of(comment) : list.prepend(comment);
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int n) {
        this.errPos = n;
    }

    protected Tokens.Comment processComment(int n, int n2, Tokens.Comment.CommentStyle commentStyle) {
        return new BasicComment(commentStyle, this, n, n2);
    }

    protected void processWhiteSpace(int n, int n2) {
    }

    protected void processLineTerminator(int n, int n2) {
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.getRawCharacters(), this.length(), false);
    }

    protected static class BasicComment
    extends UnicodeReader.PositionTrackingReader
    implements Tokens.Comment {
        final Tokens.Comment.CommentStyle cs;
        JCDiagnostic.DiagnosticPosition pos;
        protected boolean deprecatedFlag = false;
        protected boolean scanned = false;

        protected BasicComment(Tokens.Comment.CommentStyle commentStyle, UnicodeReader unicodeReader, int n, final int n2) {
            super(unicodeReader, n, n2);
            this.cs = commentStyle;
            this.pos = new JCDiagnostic.SimpleDiagnosticPosition(n){

                @Override
                public int getEndPosition(EndPosTable endPosTable) {
                    return n2;
                }
            };
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public Tokens.Comment stripIndent() {
            return this;
        }

        @Override
        public JCDiagnostic.DiagnosticPosition getPos() {
            return this.pos;
        }

        @Override
        public int getSourcePos(int n) {
            return -1;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.cs;
        }

        @Override
        public boolean isDeprecated() {
            if (!this.scanned) {
                this.scanDocComment();
            }
            return this.deprecatedFlag;
        }

        UnicodeReader trimEndOfComment(UnicodeReader unicodeReader) {
            int n = unicodeReader.position();
            boolean bl = true;
            while (unicodeReader.isAvailable()) {
                int n2 = unicodeReader.position();
                if (unicodeReader.skip('*') != 0 && unicodeReader.is('/')) {
                    return unicodeReader.lineReader(bl ? n2 : n, n2);
                }
                bl = bl && unicodeReader.isWhitespace();
                unicodeReader.next();
            }
            unicodeReader.reset(n);
            return unicodeReader;
        }

        UnicodeReader trimJavadocComment(UnicodeReader unicodeReader) {
            unicodeReader = this.trimEndOfComment(unicodeReader);
            int n = unicodeReader.position();
            unicodeReader.skipWhitespace();
            if (!unicodeReader.isAvailable()) {
                return unicodeReader;
            }
            if (unicodeReader.skip('*') == 0) {
                unicodeReader.reset(n);
            }
            return unicodeReader;
        }

        int getJavadocLineCommentIndent() {
            int n = Integer.MAX_VALUE;
            UnicodeReader unicodeReader = this.lineReader(this.position(), this.position() + this.length());
            while (unicodeReader.isAvailable()) {
                UnicodeReader unicodeReader2 = unicodeReader.lineReader();
                unicodeReader2.skipWhitespace();
                unicodeReader2.accept("///");
                int n2 = unicodeReader2.position();
                unicodeReader2.skipWhitespace();
                if (!unicodeReader2.isAvailable()) continue;
                n = Integer.min(n, unicodeReader2.position() - n2);
            }
            return n == Integer.MAX_VALUE ? 0 : n;
        }

        UnicodeReader trimJavadocLineComment(UnicodeReader unicodeReader, int n) {
            unicodeReader.skipWhitespace();
            unicodeReader.accept("///");
            for (int i = 0; unicodeReader.isAvailable() && i < n; ++i) {
                unicodeReader.next();
            }
            return unicodeReader;
        }

        protected void putLine(UnicodeReader unicodeReader) {
        }

        protected void scanDocComment() {
            if (!this.scanned) {
                Tokens.Comment.CommentStyle commentStyle;
                this.deprecatedFlag = false;
                this.scanned = true;
                int n = 0;
                int n2 = this.position();
                if (this.accept("/**")) {
                    commentStyle = Tokens.Comment.CommentStyle.JAVADOC_BLOCK;
                    if (this.skip('*') != 0 && this.is('/')) {
                        return;
                    }
                    this.skipWhitespace();
                    if (this.isEOLN()) {
                        this.accept('\r');
                        this.accept('\n');
                    }
                } else if (this.accept("///")) {
                    commentStyle = Tokens.Comment.CommentStyle.JAVADOC_LINE;
                    this.reset(n2);
                    n = this.getJavadocLineCommentIndent();
                } else {
                    return;
                }
                while (this.isAvailable()) {
                    UnicodeReader unicodeReader = this.lineReader();
                    UnicodeReader unicodeReader2 = unicodeReader = commentStyle == Tokens.Comment.CommentStyle.JAVADOC_LINE ? this.trimJavadocLineComment(unicodeReader, n) : this.trimJavadocComment(unicodeReader);
                    if (this.cs == Tokens.Comment.CommentStyle.JAVADOC_BLOCK) {
                        int n3 = unicodeReader.position();
                        unicodeReader.skipWhitespace();
                        if (unicodeReader.accept("@deprecated") && (!unicodeReader.isAvailable() || unicodeReader.isWhitespace() || unicodeReader.isEOLN() || unicodeReader.get() == '\u001a')) {
                            this.deprecatedFlag = true;
                        }
                        unicodeReader.reset(n3);
                    }
                    this.putLine(unicodeReader);
                }
            }
        }
    }
}

