/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.ReferenceParser;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import nbjavac.StringWrapper;

public class DocCommentParser {
    private final ParserFactory fac;
    private final JCDiagnostic.Factory diags;
    private final DiagnosticSource diagSource;
    private final Tokens.Comment comment;
    private final DocTreeMaker m;
    private final Names names;
    private final boolean isHtmlFile;
    private final DocTree.Kind textKind;
    private final Markdown markdown;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int textStart = -1;
    private int lastNonWhite = -1;
    private boolean newline = true;
    private boolean inPre = false;
    private final Map<Name, TagParser> tagParsers;

    public DocCommentParser(ParserFactory parserFactory, DiagnosticSource diagnosticSource, Tokens.Comment comment) {
        this(parserFactory, diagnosticSource, comment, false);
    }

    public DocCommentParser(ParserFactory parserFactory, DiagnosticSource diagnosticSource, Tokens.Comment comment, boolean bl) {
        this.fac = parserFactory;
        this.diags = parserFactory.log.diags;
        this.diagSource = diagnosticSource;
        this.comment = comment.stripIndent();
        this.names = parserFactory.names;
        this.isHtmlFile = bl;
        this.textKind = bl ? DocTree.Kind.TEXT : DocCommentParser.getTextKind(comment);
        this.m = parserFactory.docTreeMaker;
        this.tagParsers = this.createTagParsers();
        this.markdown = this.textKind == DocTree.Kind.MARKDOWN ? new Markdown() : null;
    }

    private static DocTree.Kind getTextKind(Tokens.Comment comment) {
        DocTree.Kind kind;
        switch (comment.getStyle()) {
            case JAVADOC_BLOCK: {
                kind = DocTree.Kind.TEXT;
                break;
            }
            case JAVADOC_LINE: {
                kind = DocTree.Kind.MARKDOWN;
                break;
            }
            default: {
                throw new IllegalArgumentException(comment.getStyle().name());
            }
        }
        return kind;
    }

    public DCTree.DCDocComment parse() {
        List list;
        String string = this.comment.getText();
        this.buf = new char[string.length() + 1];
        string.getChars(0, string.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List list2 = this.isHtmlFile ? this.content(Phase.PREAMBLE) : List.nil();
        List<DCTree> list3 = this.content(Phase.BODY);
        List<DCTree> list4 = this.blockTags();
        List<Object> list5 = list = this.isHtmlFile ? this.content(Phase.POSTAMBLE) : List.nil();
        int n = this.textKind == DocTree.Kind.MARKDOWN ? 0 : (!list2.isEmpty() ? ((DCTree)list2.head).pos : (!list3.isEmpty() ? ((DCTree)list3.head).pos : (!list4.isEmpty() ? ((DCTree)list4.head).pos : (!list.isEmpty() ? ((DCTree)list.head).pos : 0))));
        return this.m.at(n).newDocCommentTree(this.comment, list3, list4, list2, list);
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': {
                this.newline = true;
                break;
            }
            case '\r': {
                if (this.bp + 1 < this.buflen && this.buf[this.bp + 1] == '\n') {
                    ++this.bp;
                    this.ch = (char)10;
                }
                this.newline = true;
            }
        }
    }

    char peekChar() {
        return this.buf[this.bp < this.buflen ? this.bp + 1 : this.buflen];
    }

    protected List<DCTree> blockContent() {
        while (this.isHorizontalWhitespace(this.ch) && this.bp < this.buflen) {
            this.nextChar();
        }
        return this.content(Phase.BODY);
    }

    protected List<DCTree> content(Phase phase) {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        ListBuffer<DCTree> listBuffer2 = null;
        this.textStart = -1;
        int n = 1;
        int n2 = this.bp;
        if (this.textKind == DocTree.Kind.MARKDOWN) {
            this.initMarkdownLine();
        }
        block36: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\r': {
                    this.nextChar();
                    if (this.textKind != DocTree.Kind.MARKDOWN) continue block36;
                    this.initMarkdownLine();
                    continue block36;
                }
                case '\t': 
                case ' ': {
                    if (this.textKind == DocTree.Kind.MARKDOWN && this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block36;
                }
                case '&': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.defaultContentCharacter();
                            continue block36;
                        }
                        case TEXT: {
                            this.entity(listBuffer);
                            continue block36;
                        }
                    }
                    throw this.unknownTextKind(this.textKind);
                }
                case '<': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.defaultContentCharacter();
                            continue block36;
                        }
                        case TEXT: {
                            this.newline = false;
                            if (this.isHtmlFile) {
                                switch (phase.ordinal()) {
                                    case 0: {
                                        if (!this.isEndPreamble()) break;
                                        listBuffer.add(this.html());
                                        if (this.textStart == -1) {
                                            this.textStart = this.bp;
                                            this.lastNonWhite = -1;
                                        }
                                        this.newline = true;
                                        break block36;
                                    }
                                    case 1: {
                                        if (!this.isEndBody()) break;
                                        this.addPendingText(listBuffer, this.lastNonWhite);
                                        break block36;
                                    }
                                }
                            }
                            this.addPendingText(listBuffer, this.bp - 1);
                            listBuffer.add(this.html());
                            if (this.inPre) {
                                if (listBuffer2 == null) {
                                    listBuffer2 = listBuffer;
                                    listBuffer = new ListBuffer<DCTree>();
                                }
                            } else if (listBuffer2 != null) {
                                listBuffer2.addAll((Collection<DCTree>)this.normalizePreContent(listBuffer));
                                listBuffer = listBuffer2;
                                listBuffer2 = null;
                            }
                            if (phase == Phase.PREAMBLE || phase == Phase.POSTAMBLE || this.textStart != -1) continue block36;
                            this.textStart = this.bp;
                            this.lastNonWhite = -1;
                            continue block36;
                        }
                    }
                    throw this.unknownTextKind(this.textKind);
                }
                case '{': {
                    switch (phase.ordinal()) {
                        case 0: 
                        case 2: {
                            this.defaultContentCharacter();
                            break;
                        }
                        case 1: {
                            this.inlineTag(listBuffer);
                            break;
                        }
                        case 3: {
                            if (this.inlineTag(listBuffer)) break;
                            ++n;
                        }
                    }
                    continue block36;
                }
                case '}': {
                    if (phase == Phase.INLINE) {
                        this.newline = false;
                        if (--n == 0) {
                            this.addPendingText(listBuffer, this.bp - 1);
                            this.nextChar();
                            return listBuffer.toList();
                        }
                        this.nextChar();
                        continue block36;
                    }
                    this.defaultContentCharacter();
                    continue block36;
                }
                case '@': {
                    char c;
                    if (this.newline) {
                        c = this.peekChar();
                        if (c == '@' || c == '*') {
                            this.addPendingText(listBuffer, this.bp - 1);
                            this.nextChar();
                            listBuffer.add(this.m.at(this.bp - 1).newEscapeTree(this.ch));
                            this.newline = false;
                            this.nextChar();
                            this.textStart = this.bp;
                            continue block36;
                        }
                        if (phase == Phase.BODY) {
                            this.addPendingText(listBuffer, this.lastNonWhite);
                            break block36;
                        }
                    } else if (this.textStart != -1 && this.buf[this.bp - 1] == '*' && this.peekChar() == '/') {
                        this.addPendingText(listBuffer, this.bp - 1);
                        this.nextChar();
                        listBuffer.add(this.m.at(this.bp - 1).newEscapeTree('/'));
                        this.newline = false;
                        this.nextChar();
                        this.textStart = this.bp;
                        continue block36;
                    }
                    this.defaultContentCharacter();
                    continue block36;
                }
                case '\\': {
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.defaultContentCharacter();
                            this.nextChar();
                            this.defaultContentCharacter();
                            break;
                        }
                        case TEXT: {
                            this.defaultContentCharacter();
                        }
                    }
                    continue block36;
                }
                case '`': 
                case '~': {
                    char c;
                    switch (this.textKind) {
                        case MARKDOWN: {
                            this.newline = false;
                            if (this.textStart == -1) {
                                this.textStart = this.bp;
                            }
                            this.lastNonWhite = this.bp;
                            c = (char)(this.newline ? 1 : 0);
                            boolean bl = this.markdown.isCodeFence();
                            if (this.ch == '`' || this.ch == '~' && bl) {
                                int n3 = this.markdown.skipCode();
                                if (n3 == -1) {
                                    if (bl) {
                                        this.lastNonWhite = this.buflen - 1;
                                        break;
                                    }
                                    this.bp = this.lastNonWhite;
                                    this.newline = c;
                                    this.nextChar();
                                    break;
                                }
                                this.lastNonWhite = n3 - 1;
                                break;
                            }
                            this.nextChar();
                            break;
                        }
                        case TEXT: {
                            this.defaultContentCharacter();
                        }
                    }
                    continue block36;
                }
                default: {
                    this.defaultContentCharacter();
                    continue block36;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(listBuffer, this.lastNonWhite);
        }
        if (listBuffer2 != null) {
            listBuffer2.addAll((Collection<DCTree>)listBuffer);
            listBuffer = listBuffer2;
            listBuffer2 = null;
        }
        return phase == Phase.INLINE ? List.of(this.erroneous("dc.unterminated.inline.tag", n2)) : listBuffer.toList();
    }

    void defaultContentCharacter() {
        this.newline = false;
        if (this.textStart == -1) {
            this.textStart = this.bp;
        }
        this.lastNonWhite = this.bp;
        this.nextChar();
    }

    void initMarkdownLine() {
        if (this.textStart == -1) {
            this.textStart = this.bp;
        }
        this.markdown.update();
        if (this.markdown.isIndentedCodeBlock()) {
            this.markdown.skipLine();
            this.lastNonWhite = this.bp - 1;
        }
    }

    private IllegalStateException unknownTextKind(DocTree.Kind kind) {
        return new IllegalStateException(kind.toString());
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> listBuffer = new ListBuffer<DCTree>();
        while (this.bp < this.buflen && this.ch == '@') {
            listBuffer.add(this.blockTag());
        }
        return listBuffer.toList();
    }

    protected DCTree blockTag() {
        this.newline = false;
        int n = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tagParser = this.tagParsers.get(name);
                if (tagParser == null) {
                    List<DCTree> list = this.blockContent();
                    return this.m.at(n).newUnknownBlockTagTree((javax.lang.model.element.Name)name, list);
                }
                if (tagParser.allowsBlock()) {
                    return tagParser.parse(n, TagParser.Kind.BLOCK);
                }
                return this.erroneous("dc.bad.inline.tag", n);
            }
            int n2 = this.bp;
            this.blockContent();
            return this.erroneous("dc.no.tag.name", n, n2);
        }
        catch (ParseException parseException) {
            this.blockContent();
            return this.erroneous(parseException.getMessage(), n, parseException.pos);
        }
    }

    private String showPos(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(n).append("] ");
        if (n >= 0) {
            for (int i = Math.max(n - 10, 0); i < Math.min(n + 10, this.buflen); ++i) {
                char c;
                if (i == n) {
                    stringBuilder.append("[");
                }
                char c2 = this.buf[i];
                switch (c2) {
                    case '\n': {
                        c = '|';
                        break;
                    }
                    case ' ': {
                        c = '_';
                        break;
                    }
                    default: {
                        c = c2;
                    }
                }
                stringBuilder.append(c);
                if (i != n) continue;
                stringBuilder.append("]");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean inlineTag(ListBuffer<DCTree> listBuffer) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            if (this.peekChar() != '@') {
                this.addPendingText(listBuffer, this.bp - 2);
                listBuffer.add(this.inlineTag());
                this.textStart = this.bp;
                this.lastNonWhite = -1;
                return true;
            }
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.addPendingText(listBuffer, this.bp - 1);
            this.nextChar();
            listBuffer.add(this.m.at(this.bp - 1).newEscapeTree('@'));
            this.nextChar();
            this.textStart = -1;
            this.lastNonWhite = this.bp;
            return false;
        }
        if (this.textStart == -1) {
            this.textStart = this.bp - 1;
        }
        this.lastNonWhite = this.bp;
        return false;
    }

    protected DCTree inlineTag() {
        int n = this.bp - 1;
        try {
            this.nextChar();
            if (!this.isIdentifierStart(this.ch)) {
                return this.erroneous("dc.no.tag.name", n, this.bp);
            }
            Name name = this.readTagName();
            TagParser tagParser = this.tagParsers.get(name);
            if (tagParser == null) {
                this.skipWhitespace();
                DCTree.DCText dCText = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                this.nextChar();
                return ((DCTree.DCEndPosTree)((Object)this.m.at(n).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(dCText)))).setEndPos(this.bp);
            }
            if (!tagParser.retainWhiteSpace) {
                this.skipWhitespace();
            }
            if (tagParser.allowsInline()) {
                DCTree.DCEndPosTree dCEndPosTree = (DCTree.DCEndPosTree)tagParser.parse(n, TagParser.Kind.INLINE);
                return dCEndPosTree.setEndPos(this.bp);
            }
            DCTree.DCText dCText = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
            this.nextChar();
            return ((DCTree.DCEndPosTree)((Object)this.m.at(n).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(dCText)))).setEndPos(this.bp);
        }
        catch (ParseException parseException) {
            return this.erroneous(parseException.getMessage(), n, parseException.pos);
        }
    }

    private DCTree.DCText inlineText(WhitespaceRetentionPolicy whitespaceRetentionPolicy) throws ParseException {
        switch (whitespaceRetentionPolicy.ordinal()) {
            case 2: {
                this.skipWhitespace();
                break;
            }
            case 1: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int n = this.bp;
        int n2 = 1;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++n2;
                    break;
                }
                case '}': {
                    if (--n2 == 0) {
                        return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        throw new ParseException("dc.unterminated.inline.tag");
    }

    protected DCTree.DCReference reference(ReferenceParser.Mode mode) throws ParseException {
        int n = this.bp;
        int n2 = 0;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (n2 != 0) break;
                    break block9;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++n2;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --n2;
                    break;
                }
                case '}': {
                    if (this.bp == n) {
                        return null;
                    }
                    this.newline = false;
                    break block9;
                }
                case '@': {
                    if (!this.newline) break;
                    break block9;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (n2 > 0) {
            throw new ParseException("dc.unterminated.signature");
        }
        String string = this.newString(n, this.bp);
        try {
            ReferenceParser.Reference reference = new ReferenceParser(this.fac).parse(string, mode);
            return (DCTree.DCReference)this.m.at(n).newReferenceTree(string, reference).setEndPos(this.bp);
        }
        catch (ReferenceParser.ParseException parseException) {
            throw new ParseException(n + parseException.pos, parseException.getMessage());
        }
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int n = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(n).newIdentifierTree(name);
        }
        throw new ParseException("dc.identifier.expected");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        this.newline = false;
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText inlineWord() {
        int n = this.bp;
        int n2 = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return this.m.at(n).newTextTree(this.newString(n, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    if (n2 == 0) {
                        return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    }
                    --n2;
                }
            }
            this.newline = false;
            this.nextChar();
        }
        return null;
    }

    private List<DCTree> inlineContent() {
        this.skipWhitespace();
        return this.content(Phase.INLINE);
    }

    protected void entity(ListBuffer<DCTree> listBuffer) {
        this.newline = false;
        this.addPendingText(listBuffer, this.bp - 1);
        listBuffer.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int n = this.bp;
        this.nextChar();
        Name name = null;
        if (this.ch == '#') {
            int n2 = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.bp < this.buflen && this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, n2, this.bp - n2);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.bp < this.buflen && this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, n2, this.bp - n2);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            return this.erroneous("dc.bad.entity", n);
        }
        if (this.ch != ';') {
            return this.erroneous("dc.missing.semicolon", n);
        }
        this.nextChar();
        return this.m.at(n).newEntityTree(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndPreamble() {
        int n = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                String string;
                switch (string = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                    case "body": {
                        while (this.bp < this.buflen && this.ch != '>') {
                            this.nextChar();
                        }
                        if (this.ch == '>') {
                            this.nextChar();
                        }
                        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
                            this.nextChar();
                        }
                        if (this.ch == '<') {
                            this.nextChar();
                            if (this.isIdentifierStart(this.ch) && (string = StringUtils.toLowerCase(this.readIdentifier().toString())).equals("main")) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                    case "main": {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = n;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndBody() {
        int n = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                this.nextChar();
                if (this.isIdentifierStart(this.ch)) {
                    String string;
                    switch (string = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                        case "body": 
                        case "main": {
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = n;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean peek(String string) {
        int n = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                if (string.charAt(0) != this.ch) {
                    boolean bl = false;
                    return bl;
                }
                string = string.substring(1);
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                boolean bl = StringUtils.toLowerCase(name.toString()).equals(string);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = n;
            this.ch = this.buf[this.bp];
        }
    }

    private DCTree html() {
        int n = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> list = this.htmlAttrs();
            if (list != null) {
                boolean bl = false;
                if (this.ch == '/') {
                    this.nextChar();
                    bl = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    if ("pre".equalsIgnoreCase(name.toString())) {
                        this.inPre = true;
                    }
                    return ((DCTree.DCEndPosTree)((Object)this.m.at(n).newStartElementTree((javax.lang.model.element.Name)name, list, bl))).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    if ("pre".equalsIgnoreCase(name.toString())) {
                        this.inPre = false;
                    }
                    return this.m.at(n).newEndElementTree(name).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int n2 = 0;
                        while (this.bp < this.buflen && this.ch == '-') {
                            ++n2;
                            this.nextChar();
                        }
                        if (n2 >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(n).newCommentTree(this.newString(n, this.bp));
                        }
                        this.nextChar();
                    }
                }
            } else if (this.isIdentifierStart(this.ch) && this.peek("doctype")) {
                this.readIdentifier();
                this.nextChar();
                this.skipWhitespace();
                int n3 = this.bp;
                while (this.bp < this.buflen) {
                    if (this.ch == '>') {
                        int n4 = this.bp;
                        this.nextChar();
                        return this.m.at(n3).newDocTypeTree(this.newString(n3, n4));
                    }
                    this.nextChar();
                }
            } else {
                int n5;
                String string = "[CDATA[";
                for (n5 = 0; n5 < string.length(); ++n5) {
                    if (this.ch != string.charAt(n5)) {
                        return this.erroneous("dc.invalid.html", n);
                    }
                    this.nextChar();
                }
                while (this.bp < this.buflen) {
                    if (this.ch == ']') {
                        n5 = 0;
                        while (this.bp < this.buflen && this.ch == ']') {
                            ++n5;
                            this.nextChar();
                        }
                        if (n5 < 2 || this.ch != '>') continue;
                        this.nextChar();
                        return this.m.at(n).newTextTree(this.newString(n, this.bp));
                    }
                    this.nextChar();
                }
                return this.erroneous("dc.invalid.html", n);
            }
        }
        this.bp = n + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", n);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        this.skipWhitespace();
        while (this.bp < this.buflen && this.isIdentifierStart(this.ch)) {
            Object object;
            int n = this.bp;
            Name name = this.readAttributeName();
            this.skipWhitespace();
            List list = null;
            AttributeTree.ValueKind valueKind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                object = new ListBuffer();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    this.newline = false;
                    valueKind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char c = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != c) {
                        this.attrValueChar((ListBuffer<DCTree>)object);
                    }
                    this.addPendingText((ListBuffer<DCTree>)object, this.bp - 1, DocTree.Kind.TEXT);
                    this.nextChar();
                } else {
                    valueKind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar((ListBuffer<DCTree>)object);
                    }
                    this.addPendingText((ListBuffer<DCTree>)object, this.bp - 1, DocTree.Kind.TEXT);
                }
                this.skipWhitespace();
                list = ((ListBuffer)object).toList();
            }
            object = this.m.at(n).newAttributeTree((javax.lang.model.element.Name)name, valueKind, (java.util.List)list);
            listBuffer.add(object);
        }
        return listBuffer.toList();
    }

    ListBuffer<DCTree> normalizePreContent(ListBuffer<DCTree> listBuffer) {
        static enum State {
            BEFORE_CODE,
            AFTER_CODE,
            SUCCEEDED,
            FAILED;

        }
        if (this.textKind == DocTree.Kind.MARKDOWN || this.isHtmlFile) {
            return listBuffer;
        }
        SimpleDocTreeVisitor<DCTree, Context> simpleDocTreeVisitor = new SimpleDocTreeVisitor<DCTree, Context>(){

            @Override
            public DCTree visitText(TextTree textTree, Context context) {
                static enum State {
                    BEFORE_CODE,
                    AFTER_CODE,
                    SUCCEEDED,
                    FAILED;

                }
                class Context {
                    State state = State.BEFORE_CODE;

                    Context() {
                        static enum State {
                            BEFORE_CODE,
                            AFTER_CODE,
                            SUCCEEDED,
                            FAILED;

                        }
                    }

                    void unexpectedTree() {
                        static enum State {
                            BEFORE_CODE,
                            AFTER_CODE,
                            SUCCEEDED,
                            FAILED;

                        }
                        if (this.state != State.SUCCEEDED) {
                            this.state = State.FAILED;
                        }
                    }
                }
                if (context.state == State.BEFORE_CODE && textTree.getBody().matches("[ \t]+")) {
                    return null;
                }
                if (context.state == State.AFTER_CODE && textTree.getBody().startsWith("\n")) {
                    context.state = State.SUCCEEDED;
                    return DocCommentParser.this.m.at(((DCTree.DCText)textTree).pos + 1).newTextTree(textTree.getBody().substring(1));
                }
                context.unexpectedTree();
                return (DCTree)((Object)textTree);
            }

            @Override
            public DCTree visitLiteral(LiteralTree literalTree, Context context) {
                static enum State {
                    BEFORE_CODE,
                    AFTER_CODE,
                    SUCCEEDED,
                    FAILED;

                }
                if (context.state == State.BEFORE_CODE && literalTree.getBody().getBody().startsWith("\n")) {
                    context.state = State.SUCCEEDED;
                    DCTree.DCText dCText = (DCTree.DCText)literalTree.getBody();
                    DCTree.DCText dCText2 = DocCommentParser.this.m.at(dCText.pos + 1).newTextTree(dCText.getBody().substring(1));
                    DocCommentParser.this.m.at(((DCTree)((Object)literalTree)).pos);
                    return literalTree.getKind() == DocTree.Kind.CODE ? DocCommentParser.this.m.newCodeTree(dCText2) : DocCommentParser.this.m.newLiteralTree(dCText2);
                }
                context.unexpectedTree();
                return (DCTree)((Object)literalTree);
            }

            @Override
            public DCTree visitStartElement(StartElementTree startElementTree, Context context) {
                static enum State {
                    BEFORE_CODE,
                    AFTER_CODE,
                    SUCCEEDED,
                    FAILED;

                }
                if (context.state == State.BEFORE_CODE && startElementTree.getName().toString().equalsIgnoreCase("code")) {
                    context.state = State.AFTER_CODE;
                } else {
                    context.unexpectedTree();
                }
                return (DCTree)((Object)startElementTree);
            }

            @Override
            protected DCTree defaultAction(DocTree docTree, Context context) {
                context.unexpectedTree();
                return (DCTree)docTree;
            }
        };
        Context context = new Context();
        ListBuffer<DCTree> listBuffer2 = new ListBuffer<DCTree>();
        for (DCTree dCTree : listBuffer) {
            DCTree dCTree2 = (DCTree)simpleDocTreeVisitor.visit(dCTree, context);
            if (dCTree2 != null) {
                listBuffer2.add(dCTree2);
            }
            if (context.state != State.FAILED) continue;
            return listBuffer;
        }
        return context.state == State.SUCCEEDED ? listBuffer2 : listBuffer;
    }

    protected void attrValueChar(ListBuffer<DCTree> listBuffer) {
        switch (this.ch) {
            case '&': {
                this.entity(listBuffer);
                break;
            }
            case '{': {
                this.inlineTag(listBuffer);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> listBuffer, int n) {
        this.addPendingText(listBuffer, n, this.textKind);
    }

    protected void addPendingText(ListBuffer<DCTree> listBuffer, int n, DocTree.Kind kind) {
        if (this.textStart != -1) {
            if (this.textStart <= n) {
                switch (kind) {
                    case TEXT: {
                        listBuffer.add(this.m.at(this.textStart).newTextTree(this.newString(this.textStart, n + 1)));
                        break;
                    }
                    case MARKDOWN: {
                        listBuffer.add(this.m.at(this.textStart).newRawTextTree(DocTree.Kind.MARKDOWN, this.newString(this.textStart, n + 1)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(kind.toString());
                    }
                }
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String string, int n) {
        return this.erroneous(string, n, -1);
    }

    protected DCTree.DCErroneous erroneous(String string, int n, int n2) {
        int n3;
        block4: for (n3 = this.bp - 1; n3 > n; --n3) {
            switch (this.buf[n3]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        if (n2 == -1) {
            n2 = n3;
        }
        int n4 = n3 + 1;
        this.textStart = -1;
        JCDiagnostic.DiagnosticPosition diagnosticPosition = DCTree.createDiagnosticPosition(this.comment, n, n2, n4);
        JCDiagnostic jCDiagnostic = this.diags.error(null, this.diagSource, diagnosticPosition, string, new Object[0]);
        return ((DCTree.DCErroneous)this.m.at(n).newErroneousTree(this.newString(n, n4), (Diagnostic)jCDiagnostic)).setPrefPos(n2);
    }

    protected boolean isIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStart(c);
    }

    protected Name readIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readAttributeName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readTagName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    protected Name readJavaIdentifier() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected Name readSystemPropertyName() {
        int n = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.') {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, n, this.bp - n);
    }

    protected boolean isDecimalDigit(char c) {
        return '0' <= c && c <= '9';
    }

    protected boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char c) {
        boolean bl;
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    protected boolean isHorizontalWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    protected void skipWhitespace() {
        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int n, int n2) {
        return new String(this.buf, n, n2 - n);
    }

    private Map<Name, TagParser> createTagParsers() {
        TagParser[] tagParserArray = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newAuthorTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE, true){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newCodeTree(dCText);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newDeprecatedTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int n) throws ParseException {
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newDocRootTree();
                }
                int n2 = DocCommentParser.this.bp;
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException(n2, "dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newExceptionTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.HIDDEN){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newHiddenTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INDEX){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText;
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                DCTree.DCText dCText2 = dCText = DocCommentParser.this.ch == '\"' ? DocCommentParser.this.quotedString() : DocCommentParser.this.inlineWord();
                if (dCText == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                List list = List.nil();
                if (DocCommentParser.this.ch != '}') {
                    list = DocCommentParser.this.inlineContent();
                } else {
                    DocCommentParser.this.nextChar();
                }
                return DocCommentParser.this.m.at(n).newIndexTree((DocTree)dCText, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    if (dCReference == null) {
                        return DocCommentParser.this.m.at(n).newInheritDocTree();
                    }
                    return DocCommentParser.this.m.at(n).newInheritDocTree(dCReference);
                }
                int n2 = DocCommentParser.this.bp;
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                DocCommentParser.this.nextChar();
                throw new ParseException(n2, "dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_OPTIONAL);
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newLinkTree((ReferenceTree)dCReference, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_OPTIONAL);
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newLinkPlainTree((ReferenceTree)dCReference, (java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL, true){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newLiteralTree(dCText);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean bl = false;
                if (DocCommentParser.this.ch == '<') {
                    bl = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier dCIdentifier = DocCommentParser.this.identifier();
                if (bl) {
                    if (DocCommentParser.this.ch != '>') {
                        throw new ParseException(DocCommentParser.this.bp, "dc.gt.expected");
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newParamTree(bl, (IdentifierTree)dCIdentifier, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PROVIDES){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newProvidesTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.EITHER, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int n, TagParser.Kind kind) {
                List list;
                switch (kind.ordinal()) {
                    case 1: {
                        list = DocCommentParser.this.blockContent();
                        break;
                    }
                    case 0: {
                        list = DocCommentParser.this.inlineContent();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(kind.toString());
                    }
                }
                List list2 = list;
                return DocCommentParser.this.m.at(n).newReturnTree(kind == TagParser.Kind.INLINE, (java.util.List)list2);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText dCText = DocCommentParser.this.quotedString();
                        if (dCText == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(n).newSeeTree(List.of(dCText));
                    }
                    case '<': {
                        List<DCTree> list = DocCommentParser.this.blockContent();
                        if (list == null) break;
                        return DocCommentParser.this.m.at(n).newSeeTree(list);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        throw new ParseException("dc.no.content");
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        throw new ParseException("dc.no.content");
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_OPTIONAL);
                        List<DCTree> list = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(n).newSeeTree(list.prepend(dCReference));
                    }
                }
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSerialDataTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier dCIdentifier = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> list = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    list = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(n).newSerialFieldTree((IdentifierTree)dCIdentifier, (ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSerialTree(list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newSinceTree(list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SNIPPET){

            @Override
            DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                List<DCTree> list = this.tagAttrs();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newSnippetTree(list, (TextTree)null);
                }
                if (DocCommentParser.this.ch == ':') {
                    DocCommentParser.this.newline = false;
                    DocCommentParser.this.nextChar();
                    while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.isHorizontalWhitespace(DocCommentParser.this.ch)) {
                        DocCommentParser.this.nextChar();
                    }
                    if (!DocCommentParser.this.newline) {
                        if (DocCommentParser.this.bp >= DocCommentParser.this.buf.length - 1) {
                            throw new ParseException("dc.no.content");
                        }
                        throw new ParseException("dc.unexpected.content");
                    }
                    DocCommentParser.this.nextChar();
                    DCTree.DCText dCText = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.RETAIN_ALL);
                    DocCommentParser.this.nextChar();
                    return DocCommentParser.this.m.at(n).newSnippetTree(list, (TextTree)dCText);
                }
                if (DocCommentParser.this.bp >= DocCommentParser.this.buf.length - 1) {
                    throw new ParseException("dc.no.content");
                }
                throw new ParseException("dc.unexpected.content");
            }

            private List<DCTree> tagAttrs() {
                ListBuffer<Object> listBuffer = new ListBuffer<Object>();
                DocCommentParser.this.skipWhitespace();
                while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.isIdentifierStart(DocCommentParser.this.ch)) {
                    Object object;
                    int n = DocCommentParser.this.bp;
                    Name name = DocCommentParser.this.readAttributeName();
                    DocCommentParser.this.skipWhitespace();
                    List list = null;
                    AttributeTree.ValueKind valueKind = AttributeTree.ValueKind.EMPTY;
                    if (DocCommentParser.this.ch == '=') {
                        object = new ListBuffer();
                        DocCommentParser.this.nextChar();
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch == '\'' || DocCommentParser.this.ch == '\"') {
                            DocCommentParser.this.newline = false;
                            valueKind = DocCommentParser.this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                            char c = DocCommentParser.this.ch;
                            DocCommentParser.this.nextChar();
                            DocCommentParser.this.textStart = DocCommentParser.this.bp;
                            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch != c) {
                                DocCommentParser.this.nextChar();
                            }
                            DocCommentParser.this.addPendingText((ListBuffer<DCTree>)object, DocCommentParser.this.bp - 1, DocTree.Kind.TEXT);
                            DocCommentParser.this.nextChar();
                        } else {
                            valueKind = AttributeTree.ValueKind.UNQUOTED;
                            DocCommentParser.this.textStart = DocCommentParser.this.bp;
                            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch != '}' && DocCommentParser.this.ch != ':' && !DocCommentParser.this.isUnquotedAttrValueTerminator(DocCommentParser.this.ch)) {
                                DocCommentParser.this.nextChar();
                            }
                            DocCommentParser.this.addPendingText((ListBuffer<DCTree>)object, DocCommentParser.this.bp - 1, DocTree.Kind.TEXT);
                        }
                        DocCommentParser.this.skipWhitespace();
                        list = ((ListBuffer)object).toList();
                    }
                    object = DocCommentParser.this.m.at(n).newAttributeTree((javax.lang.model.element.Name)name, valueKind, (java.util.List)list);
                    listBuffer.add(object);
                }
                return listBuffer.toList();
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SPEC){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCText dCText = DocCommentParser.this.inlineWord();
                if (dCText == null || dCText.isBlank()) {
                    throw new ParseException("dc.no.url");
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> list = DocCommentParser.this.blockContent();
                if (list.isEmpty() || DCTree.isBlank(list)) {
                    throw new ParseException("dc.no.title");
                }
                return DocCommentParser.this.m.at(n).newSpecTree((TextTree)dCText, list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SUMMARY){

            @Override
            public DCTree parse(int n) {
                List list = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(n).newSummaryTree((java.util.List)list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SYSTEM_PROPERTY){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                Name name = DocCommentParser.this.readSystemPropertyName();
                if (name == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch != '}') {
                    DocCommentParser.this.nextChar();
                    throw new ParseException("dc.unexpected.content");
                }
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(n).newSystemPropertyTree(name);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newThrowsTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.USES){

            @Override
            public DCTree parse(int n) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_DISALLOWED);
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newUsesTree((ReferenceTree)dCReference, list);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int n) throws ParseException {
                DCTree.DCText dCText;
                DocCommentParser.this.skipWhitespace();
                switch (DocCommentParser.this.ch) {
                    case '%': {
                        dCText = DocCommentParser.this.inlineWord();
                        DocCommentParser.this.skipWhitespace();
                        break;
                    }
                    case '\"': {
                        dCText = DocCommentParser.this.quotedString();
                        DocCommentParser.this.skipWhitespace();
                        break;
                    }
                    default: {
                        dCText = null;
                    }
                }
                DCTree.DCReference dCReference = DocCommentParser.this.reference(ReferenceParser.Mode.MEMBER_REQUIRED);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                    return dCText == null ? DocCommentParser.this.m.at(n).newValueTree(dCReference) : DocCommentParser.this.m.at(n).newValueTree(dCText, dCReference);
                }
                DocCommentParser.this.nextChar();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int n) {
                List<DCTree> list = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(n).newVersionTree(list);
            }
        }};
        HashMap<Name, TagParser> hashMap = new HashMap<Name, TagParser>();
        for (TagParser tagParser : tagParserArray) {
            hashMap.put(this.names.fromString(tagParser.getTreeKind().tagName), tagParser);
        }
        return hashMap;
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    class Markdown {
        private final java.util.List<BlockInfo> containers = new ArrayList<BlockInfo>();
        private LeafBlockKind leafKind = LeafBlockKind.NONE;
        private int blockId = 0;

        Markdown() {
        }

        void update() {
            LeafBlockKind leafBlockKind = this.leafKind;
            int n = this.readIndent(0);
            String string = this.peekLine();
            int n2 = 0;
            int n3 = 0;
            while (true) {
                Object object;
                if (n3 == this.containers.size()) {
                    if (leafBlockKind == LeafBlockKind.FENCED_CODE) {
                        return;
                    }
                    int n4 = (this.containers.isEmpty() ? 0 : this.containers.get(this.containers.size() - 1).indent) + 4;
                    if (n >= n4 && leafBlockKind != LeafBlockKind.PARAGRAPH) {
                        this.leafKind = LeafBlockKind.INDENTED_CODE;
                        if (this.leafKind != leafBlockKind) {
                            ++this.blockId;
                        }
                        return;
                    }
                    object = this.getLineKind(string.substring(n2));
                    switch (((Enum)object).ordinal()) {
                        case 5: 
                        case 6: {
                            int n5 = n;
                            while (DocCommentParser.this.ch != ' ' && DocCommentParser.this.ch != '\t') {
                                ++n5;
                                DocCommentParser.this.nextChar();
                            }
                            int n6 = this.readIndent(n5);
                            this.containers.add(new BlockInfo(ContainerBlockKind.LIST_ITEM, n6));
                            ++n3;
                            n2 = n6 - n;
                            ++this.blockId;
                            break;
                        }
                        case 7: {
                            this.containers.add(new BlockInfo(ContainerBlockKind.QUOTE, n + 1));
                            ++n3;
                            ++n2;
                            ++this.blockId;
                            break;
                        }
                        case 8: {
                            this.leafKind = LeafBlockKind.PARAGRAPH;
                            return;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            this.leafKind = LeafBlockKind.NONE;
                            ++this.blockId;
                            return;
                        }
                        case 4: {
                            this.leafKind = LeafBlockKind.FENCED_CODE;
                            ++this.blockId;
                            return;
                        }
                    }
                    continue;
                }
                object = this.containers.get(n3);
                ContainerBlockKind containerBlockKind = ((BlockInfo)object).blockKind;
                switch (containerBlockKind.ordinal()) {
                    case 0: {
                        if (n >= ((BlockInfo)object).indent) {
                            ++n3;
                            break;
                        }
                        LineKind lineKind = this.getLineKind(string.substring(n2));
                        if (lineKind == LineKind.BLANK) {
                            ++n3;
                            break;
                        }
                        if (lineKind == LineKind.OTHER && leafBlockKind == LeafBlockKind.PARAGRAPH) {
                            return;
                        }
                        this.closeContainer(n3);
                        ++this.blockId;
                        break;
                    }
                    case 1: {
                        LineKind lineKind = this.getLineKind(string.substring(n2));
                        if (lineKind == LineKind.BLOCK_QUOTE) {
                            ++n3;
                            ++n2;
                            break;
                        }
                        if (lineKind == LineKind.OTHER && leafBlockKind == LeafBlockKind.PARAGRAPH) {
                            return;
                        }
                        this.closeContainer(n3);
                        ++this.blockId;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(containerBlockKind.toString());
                    }
                }
            }
        }

        boolean isIndentedCodeBlock() {
            return this.leafKind == LeafBlockKind.INDENTED_CODE;
        }

        boolean isCodeFence() {
            return this.leafKind == LeafBlockKind.FENCED_CODE;
        }

        private void closeContainer(int n) {
            this.containers.subList(n, this.containers.size()).clear();
        }

        void skipLine() {
            while (DocCommentParser.this.bp < DocCommentParser.this.buflen) {
                if (DocCommentParser.this.ch == '\n' || DocCommentParser.this.ch == '\r') {
                    return;
                }
                DocCommentParser.this.nextChar();
            }
        }

        int skipCode() {
            char c = DocCommentParser.this.ch;
            int n = this.count(c);
            LeafBlockKind leafBlockKind = this.leafKind;
            boolean bl = this.leafKind == LeafBlockKind.FENCED_CODE;
            int n2 = this.blockId;
            block3: while (DocCommentParser.this.bp < DocCommentParser.this.buflen) {
                switch (DocCommentParser.this.ch) {
                    case '\n': 
                    case '\r': {
                        DocCommentParser.this.nextChar();
                        this.update();
                        if (bl) {
                            if ((this.leafKind != LeafBlockKind.FENCED_CODE || DocCommentParser.this.ch != c || this.count(DocCommentParser.this.ch) < n) && this.blockId == n2) continue block3;
                            this.leafKind = LeafBlockKind.NONE;
                            return DocCommentParser.this.bp;
                        }
                        if (this.blockId == n2) continue block3;
                        return -1;
                    }
                }
                if (DocCommentParser.this.ch == c && leafBlockKind != LeafBlockKind.FENCED_CODE && this.count(DocCommentParser.this.ch) == n) {
                    return DocCommentParser.this.bp;
                }
                DocCommentParser.this.nextChar();
            }
            return -1;
        }

        private int readIndent(int n) {
            int n2 = n;
            while (DocCommentParser.this.bp < DocCommentParser.this.buflen) {
                switch (DocCommentParser.this.ch) {
                    case ' ': {
                        ++n2;
                        break;
                    }
                    case '\t': {
                        n2 += 4 - n2 % 4;
                        break;
                    }
                    default: {
                        return n2;
                    }
                }
                DocCommentParser.this.nextChar();
            }
            return n2;
        }

        private LineKind getLineKind(String string) {
            if (StringWrapper.isBlank(string)) {
                return LineKind.BLANK;
            }
            switch (string.charAt(0)) {
                case '#': 
                case '*': 
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case '=': 
                case '>': 
                case '_': 
                case '`': 
                case '~': {
                    for (LineKind lineKind : LineKind.values()) {
                        if (!lineKind.pattern.matcher(string).matches()) continue;
                        return lineKind;
                    }
                    break;
                }
            }
            return LineKind.OTHER;
        }

        private String peekLine() {
            for (int i = DocCommentParser.this.bp; i < DocCommentParser.this.buflen; ++i) {
                switch (DocCommentParser.this.buf[i]) {
                    case '\n': 
                    case '\r': {
                        return DocCommentParser.this.newString(DocCommentParser.this.bp, i);
                    }
                }
            }
            return DocCommentParser.this.newString(DocCommentParser.this.bp, DocCommentParser.this.buflen);
        }

        private int count(char c) {
            int n = 1;
            DocCommentParser.this.nextChar();
            while (DocCommentParser.this.bp < DocCommentParser.this.buflen && DocCommentParser.this.ch == c) {
                ++n;
                DocCommentParser.this.nextChar();
            }
            return n;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[containers:" + this.containers + ", leafKind:" + (Object)((Object)this.leafKind) + ", blockId:" + this.blockId + "]";
        }

        private static enum LeafBlockKind {
            NONE,
            PARAGRAPH,
            FENCED_CODE,
            INDENTED_CODE;

        }

        private static final class BlockInfo {
            private final ContainerBlockKind blockKind;
            private final int indent;

            private BlockInfo(ContainerBlockKind containerBlockKind, int n) {
                this.blockKind = containerBlockKind;
                this.indent = n;
            }

            public final String toString() {
                return "BlockInfo[" + "blockKind=" + Objects.toString((Object)this.blockKind) + ", indent=" + Integer.toString(this.indent) + "]";
            }

            public final int hashCode() {
                return 31 * (31 * 0 + Objects.hashCode((Object)this.blockKind)) + Integer.hashCode(this.indent);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean equals(Object object) {
                if (!(object instanceof BlockInfo)) return false;
                BlockInfo blockInfo = (BlockInfo)object;
                if (this.indent != blockInfo.indent) return false;
                if (!Objects.equals((Object)this.blockKind, (Object)blockInfo.blockKind)) return false;
                return true;
            }

            public ContainerBlockKind blockKind() {
                return this.blockKind;
            }

            public int indent() {
                return this.indent;
            }
        }

        private static enum ContainerBlockKind {
            LIST_ITEM,
            QUOTE;

        }
    }

    private static enum Phase {
        PREAMBLE,
        BODY,
        POSTAMBLE,
        INLINE;

    }

    private static abstract class TagParser {
        final Kind kind;
        final DocTree.Kind treeKind;
        final boolean retainWhiteSpace;

        TagParser(Kind kind, DocTree.Kind kind2) {
            this.kind = kind;
            this.treeKind = kind2;
            this.retainWhiteSpace = false;
        }

        TagParser(Kind kind, DocTree.Kind kind2, boolean bl) {
            this.kind = kind;
            this.treeKind = kind2;
            this.retainWhiteSpace = bl;
        }

        boolean allowsBlock() {
            return this.kind != Kind.INLINE;
        }

        boolean allowsInline() {
            return this.kind != Kind.BLOCK;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        DCTree parse(int n, Kind kind) throws ParseException {
            if (kind != this.kind && this.kind != Kind.EITHER) {
                throw new IllegalArgumentException(kind.toString());
            }
            return this.parse(n);
        }

        DCTree parse(int n) throws ParseException {
            throw new UnsupportedOperationException();
        }

        static enum Kind {
            INLINE,
            BLOCK,
            EITHER;

        }
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;
        final int pos;

        ParseException(String string) {
            this(-1, string);
        }

        ParseException(int n, String string) {
            super(string);
            this.pos = n;
        }
    }

    static enum LineKind {
        BLANK(Pattern.compile("[ \t]*")),
        ATX_HEADER(Pattern.compile("#{1,6}([ \t].*|$)")),
        SETEXT_UNDERLINE(Pattern.compile("(=+|-+)[ \t]*")),
        THEMATIC_BREAK(Pattern.compile("((\\*[ \t]*+){3,})|((-[ \t]*+){3,})|((_[ \t]*+){3,})")),
        CODE_FENCE(Pattern.compile("(`{3,}[^`]*+)|(~{3,}.*+)")),
        BULLETED_LIST_ITEM(Pattern.compile("[-+*][ \t].*")),
        ORDERED_LIST_ITEM(Pattern.compile("[0-9]{1,9}[.)][ \t].*")),
        BLOCK_QUOTE(Pattern.compile(">.*")),
        OTHER(Pattern.compile(".*"));

        final Pattern pattern;

        private LineKind(Pattern pattern) {
            this.pattern = pattern;
        }
    }
}

