/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class PoolWriter {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    private static final int POOL_BUF_SIZE = Short.MAX_VALUE;
    private final Types types;
    private final Names names;
    final WriteablePoolHelper pool;
    final SharedSignatureGenerator signatureGen;
    LinkedHashSet<Symbol.ClassSymbol> innerClasses = new LinkedHashSet();
    Map<PoolConstant.Dynamic.BsmKey, Integer> bootstrapMethods = new LinkedHashMap<PoolConstant.Dynamic.BsmKey, Integer>();

    public PoolWriter(Types types, Names names) {
        this.types = types;
        this.names = names;
        this.signatureGen = new SharedSignatureGenerator();
        this.pool = new WriteablePoolHelper();
    }

    int putClass(Symbol.ClassSymbol classSymbol) {
        return this.putClass(classSymbol.type);
    }

    int putClass(Type type) {
        return this.pool.writeIfNeeded(this.types.erasure(type));
    }

    int putMember(Symbol symbol) {
        return this.pool.writeIfNeeded(symbol);
    }

    int putDynamic(PoolConstant.Dynamic dynamic) {
        return this.pool.writeIfNeeded(dynamic);
    }

    int putDescriptor(Type type) {
        return this.putName(this.typeSig(this.types.erasure(type)));
    }

    int putDescriptor(Symbol symbol) {
        return this.putDescriptor(this.descriptorType(symbol));
    }

    int putSignature(Symbol symbol) {
        if (symbol.kind == Kinds.Kind.TYP) {
            return this.putName(this.classSig(symbol.type));
        }
        return this.putName(this.typeSig(symbol.type));
    }

    int putConstant(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return this.putConstant(PoolConstant.LoadableConstant.Int(n));
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return this.putConstant(PoolConstant.LoadableConstant.Float(f.floatValue()));
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return this.putConstant(PoolConstant.LoadableConstant.Long(l));
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return this.putConstant(PoolConstant.LoadableConstant.Double(d));
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.putConstant(PoolConstant.LoadableConstant.String(string));
        }
        throw new AssertionError((Object)("unexpected constant: " + object));
    }

    int putConstant(PoolConstant.LoadableConstant loadableConstant) {
        switch (loadableConstant.poolTag()) {
            case 7: {
                return this.putClass((Type)((Object)loadableConstant));
            }
            case 16: {
                return this.pool.writeIfNeeded(this.types.erasure((Type)((Object)loadableConstant)));
            }
        }
        return this.pool.writeIfNeeded(loadableConstant);
    }

    int putName(Name name) {
        return this.pool.writeIfNeeded(name);
    }

    int putNameAndType(Symbol symbol) {
        return this.pool.writeIfNeeded(new PoolConstant.NameAndType(symbol.name, this.descriptorType(symbol)));
    }

    int putPackage(Symbol.PackageSymbol packageSymbol) {
        return this.pool.writeIfNeeded(packageSymbol);
    }

    int putModule(Symbol.ModuleSymbol moduleSymbol) {
        return this.pool.writeIfNeeded(moduleSymbol);
    }

    void enterInner(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.type.isCompound()) {
            throw new AssertionError((Object)("Unexpected intersection type: " + classSymbol.type));
        }
        classSymbol.complete();
        if (classSymbol.owner.enclClass() != null && !this.innerClasses.contains(classSymbol)) {
            this.enterInner(classSymbol.owner.enclClass());
            this.innerClasses.add(classSymbol);
        }
    }

    private Type descriptorType(Symbol symbol) {
        return symbol.kind == Kinds.Kind.MTH ? symbol.externalType(this.types) : symbol.erasure(this.types);
    }

    private int makeBootstrapEntry(PoolConstant.Dynamic dynamic) {
        PoolConstant.Dynamic.BsmKey bsmKey = dynamic.bsmKey(this.types);
        Integer n = this.bootstrapMethods.get(bsmKey);
        if (n == null) {
            n = this.bootstrapMethods.size();
            this.bootstrapMethods.put(bsmKey, n);
        }
        return n;
    }

    void writePool(OutputStream outputStream) throws IOException, ClassWriter.PoolOverflow {
        if (this.pool.overflowString != null) {
            throw new ClassWriter.StringOverflow(this.pool.overflowString);
        }
        int n = this.size();
        if (n > 65535) {
            throw new ClassWriter.PoolOverflow();
        }
        outputStream.write(n >> 8);
        outputStream.write(n);
        outputStream.write(this.pool.poolbuf.elems, 0, this.pool.poolbuf.length);
    }

    int size() {
        return this.pool.currentIndex;
    }

    private Name typeSig(Type type) {
        this.signatureGen.reset();
        this.signatureGen.assembleSig(type);
        return this.signatureGen.toName();
    }

    private Name classSig(Type type) {
        this.signatureGen.reset();
        List<Type> list = type.getTypeArguments();
        if (list.nonEmpty()) {
            this.signatureGen.assembleParamsSig(list);
        }
        this.signatureGen.assembleSig(this.types.supertype(type));
        for (Type type2 : this.types.interfaces(type)) {
            this.signatureGen.assembleSig(type2);
        }
        return this.signatureGen.toName();
    }

    void reset() {
        this.innerClasses.clear();
        this.bootstrapMethods.clear();
        this.pool.reset();
    }

    class SharedSignatureGenerator
    extends Types.SignatureGenerator {
        ByteBuffer sigbuf = new ByteBuffer();

        SharedSignatureGenerator() {
        }

        @Override
        public void assembleSig(Type type) {
            switch (type.getTag()) {
                case UNINITIALIZED_THIS: 
                case UNINITIALIZED_OBJECT: {
                    this.assembleSig(PoolWriter.this.types.erasure(((UninitializedType)type).qtype));
                    break;
                }
                default: {
                    super.assembleSig(type);
                }
            }
        }

        @Override
        protected void append(char c) {
            this.sigbuf.appendByte(c);
        }

        @Override
        protected void append(byte[] byArray) {
            this.sigbuf.appendBytes(byArray);
        }

        @Override
        protected void append(Name name) {
            this.sigbuf.appendName(name);
        }

        @Override
        protected void classReference(Symbol.ClassSymbol classSymbol) {
            PoolWriter.this.enterInner(classSymbol);
        }

        protected void reset() {
            this.sigbuf.reset();
        }

        protected Name toName() {
            try {
                return this.sigbuf.toName(PoolWriter.this.names);
            }
            catch (InvalidUtfException invalidUtfException) {
                throw new AssertionError((Object)invalidUtfException);
            }
        }
    }

    class WriteablePoolHelper {
        private final Map<Object, Integer> keysToPos = new HashMap<Object, Integer>(64);
        final ByteBuffer poolbuf = new ByteBuffer(Short.MAX_VALUE);
        int currentIndex = 1;
        ArrayDeque<PoolConstant> todo = new ArrayDeque();
        String overflowString = null;

        WriteablePoolHelper() {
        }

        private <P extends PoolConstant> int writeIfNeeded(P p) {
            Object object = p.poolKey(PoolWriter.this.types);
            Integer n = this.keysToPos.get(object);
            if (n == null) {
                n = this.currentIndex++;
                this.keysToPos.put(object, n);
                boolean bl = this.todo.isEmpty();
                this.todo.addLast(p);
                if (bl) {
                    while (!this.todo.isEmpty()) {
                        this.writeConstant(this.todo.peekFirst());
                        this.todo.removeFirst();
                    }
                }
            }
            return n;
        }

        void writeConstant(PoolConstant poolConstant) {
            int n = poolConstant.poolTag();
            switch (n) {
                case 7: {
                    Type type = (Type)poolConstant;
                    Name name = type.hasTag(TypeTag.ARRAY) ? PoolWriter.this.typeSig(type) : ClassFile.externalize(type.tsym.flatName());
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.putName(name));
                    if (!type.hasTag(TypeTag.CLASS)) break;
                    PoolWriter.this.enterInner((Symbol.ClassSymbol)type.tsym);
                    break;
                }
                case 1: {
                    Name name = (Name)poolConstant;
                    this.poolbuf.appendByte(n);
                    byte[] byArray = name.toUtf();
                    this.poolbuf.appendChar(byArray.length);
                    this.poolbuf.appendBytes(byArray, 0, byArray.length);
                    if (this.overflowString != null || byArray.length <= 65535) break;
                    this.overflowString = new String(byArray);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    Symbol symbol = (Symbol)poolConstant;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.putClass((Symbol.ClassSymbol)symbol.owner));
                    this.poolbuf.appendChar(PoolWriter.this.putNameAndType(symbol));
                    break;
                }
                case 20: {
                    Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)poolConstant;
                    Name name = ClassFile.externalize(packageSymbol.flatName());
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.putName(name));
                    break;
                }
                case 19: {
                    Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)poolConstant;
                    int n2 = PoolWriter.this.putName(moduleSymbol.name);
                    this.poolbuf.appendByte(moduleSymbol.poolTag());
                    this.poolbuf.appendChar(n2);
                    break;
                }
                case 3: {
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendInt((Integer)((PoolConstant.LoadableConstant.BasicConstant)poolConstant).data);
                    break;
                }
                case 4: {
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendFloat(((Float)((PoolConstant.LoadableConstant.BasicConstant)poolConstant).data).floatValue());
                    break;
                }
                case 5: {
                    ++this.currentIndex;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendLong((Long)((PoolConstant.LoadableConstant.BasicConstant)poolConstant).data);
                    break;
                }
                case 6: {
                    ++this.currentIndex;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendDouble((Double)((PoolConstant.LoadableConstant.BasicConstant)poolConstant).data);
                    break;
                }
                case 15: {
                    Symbol.MethodHandleSymbol methodHandleSymbol = (Symbol.MethodHandleSymbol)poolConstant;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendByte(methodHandleSymbol.referenceKind());
                    this.poolbuf.appendChar(PoolWriter.this.putMember(methodHandleSymbol.baseSymbol()));
                    break;
                }
                case 16: {
                    Type.MethodType methodType = (Type.MethodType)poolConstant;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.putDescriptor(methodType.baseType()));
                    break;
                }
                case 8: {
                    Name name = PoolWriter.this.names.fromString((String)((PoolConstant.LoadableConstant.BasicConstant)poolConstant).data);
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.putName(name));
                    break;
                }
                case 12: {
                    PoolConstant.NameAndType nameAndType = (PoolConstant.NameAndType)poolConstant;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.putName(nameAndType.name));
                    this.poolbuf.appendChar(PoolWriter.this.putDescriptor(nameAndType.type));
                    break;
                }
                case 18: {
                    Symbol.DynamicMethodSymbol dynamicMethodSymbol = (Symbol.DynamicMethodSymbol)poolConstant;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.makeBootstrapEntry(dynamicMethodSymbol));
                    this.poolbuf.appendChar(PoolWriter.this.putNameAndType(dynamicMethodSymbol));
                    break;
                }
                case 17: {
                    Symbol.DynamicVarSymbol dynamicVarSymbol = (Symbol.DynamicVarSymbol)poolConstant;
                    this.poolbuf.appendByte(n);
                    this.poolbuf.appendChar(PoolWriter.this.makeBootstrapEntry(dynamicVarSymbol));
                    this.poolbuf.appendChar(PoolWriter.this.putNameAndType(dynamicVarSymbol));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected constant tag: " + n));
                }
            }
        }

        void reset() {
            this.keysToPos.clear();
            this.currentIndex = 1;
            this.todo.clear();
            this.overflowString = null;
            this.poolbuf.reset();
        }
    }
}

