/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.BitSet;

public class PoolReader {
    private final ClassReader reader;
    private final ByteBuffer buf;
    private final Names names;
    private final Symtab syms;
    private final Convert.Validation utf8validation;
    private ImmutablePoolHelper pool;
    private static final BitSet classCP = new BitSet();
    private static final BitSet constantCP = new BitSet();
    private static final BitSet moduleCP = new BitSet();
    private static final BitSet packageCP = new BitSet();
    private static final BitSet utf8CP = new BitSet();
    private static final BitSet nameAndTypeCP = new BitSet();

    PoolReader(ByteBuffer byteBuffer) {
        this(null, byteBuffer, null, null);
    }

    PoolReader(ClassReader classReader, Names names, Symtab symtab) {
        this(classReader, classReader.buf, names, symtab);
    }

    PoolReader(ClassReader classReader, ByteBuffer byteBuffer, Names names, Symtab symtab) {
        this.reader = classReader;
        this.buf = byteBuffer;
        this.names = names;
        this.syms = symtab;
        this.utf8validation = classReader != null ? classReader.utf8validation : Convert.Validation.NONE;
    }

    Symbol.ClassSymbol getClass(int n) {
        return (Symbol.ClassSymbol)this.pool.readIfNeeded(n, classCP);
    }

    <Z> Z peekClassName(int n, Utf8Mapper<Z> utf8Mapper) {
        return this.peekItemName(n, utf8Mapper);
    }

    <Z> Z peekPackageName(int n, Utf8Mapper<Z> utf8Mapper) {
        return this.peekItemName(n, utf8Mapper);
    }

    <Z> Z peekModuleName(int n, Utf8Mapper<Z> utf8Mapper) {
        return this.peekItemName(n, utf8Mapper);
    }

    private <Z> Z peekItemName(int n, Utf8Mapper<Z> utf8Mapper) {
        try {
            n = this.buf.getChar(this.pool.offset(n));
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(underflowException.getLength()));
        }
        return this.peekName(n, utf8Mapper);
    }

    Symbol.ModuleSymbol getModule(int n) {
        return (Symbol.ModuleSymbol)this.pool.readIfNeeded(n, moduleCP);
    }

    Symbol.PackageSymbol getPackage(int n) {
        return (Symbol.PackageSymbol)this.pool.readIfNeeded(n, packageCP);
    }

    <Z> Z peekName(int n, Utf8Mapper<Z> utf8Mapper) {
        try {
            return this.getUtf8(n, utf8Mapper);
        }
        catch (InvalidUtfException invalidUtfException) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadUtf8ByteSequenceAt(invalidUtfException.getOffset()));
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(underflowException.getLength()));
        }
    }

    Name getName(int n) {
        return (Name)this.pool.readIfNeeded(n, utf8CP);
    }

    Type getType(int n) {
        return this.getName(n).map(this.reader::sigToType);
    }

    PoolConstant.NameAndType getNameAndType(int n) {
        return (PoolConstant.NameAndType)this.pool.readIfNeeded(n, nameAndTypeCP);
    }

    Object getConstant(int n) {
        return this.pool.readIfNeeded(n, constantCP);
    }

    boolean hasTag(int n, int n2) {
        return this.pool.tag(n) == n2;
    }

    private <Z> Z getUtf8(int n, Utf8Mapper<Z> utf8Mapper) throws InvalidUtfException, ByteBuffer.UnderflowException {
        int n2 = this.pool.tag(n);
        int n3 = this.pool.offset(n);
        if (n2 == 1) {
            char c = this.pool.poolbuf.getChar(n3);
            int n4 = n3 + 2;
            this.pool.poolbuf.verifyRange(n4, c);
            return utf8Mapper.map(this.pool.poolbuf.elems, n4, c);
        }
        throw this.reader.badClassFile("unexpected.const.pool.tag.at", Integer.toString(n2), Integer.toString(n3 - 1));
    }

    private Object resolve(ByteBuffer byteBuffer, int n, int n2) throws InvalidUtfException, ByteBuffer.UnderflowException {
        switch (n) {
            case 1: {
                char c = byteBuffer.getChar(n2);
                try {
                    return this.names.fromUtf(byteBuffer.elems, n2 + 2, c, this.utf8validation);
                }
                catch (InvalidUtfException invalidUtfException) {
                    if (this.reader == null || this.reader.warnOnIllegalUtf8) {
                        if (this.reader != null) {
                            this.reader.log.warning(CompilerProperties.Warnings.InvalidUtf8InClassfile(this.reader.currentClassFile, CompilerProperties.Fragments.BadUtf8ByteSequenceAt(invalidUtfException.getOffset())));
                        }
                        return this.names.fromUtfLax(byteBuffer.elems, n2 + 2, c);
                    }
                    throw invalidUtfException;
                }
            }
            case 7: {
                char c = byteBuffer.getChar(n2);
                Name name = ClassFile.internalize(this.getName(c));
                return this.syms.enterClass(this.reader.currentModule, name);
            }
            case 12: {
                Name name = this.getName(byteBuffer.getChar(n2));
                Type type = this.getType(byteBuffer.getChar(n2 + 2));
                return new PoolConstant.NameAndType(name, type);
            }
            case 3: {
                return byteBuffer.getInt(n2);
            }
            case 4: {
                return Float.valueOf(byteBuffer.getFloat(n2));
            }
            case 5: {
                return byteBuffer.getLong(n2);
            }
            case 6: {
                return byteBuffer.getDouble(n2);
            }
            case 8: {
                return this.getName(byteBuffer.getChar(n2)).toString();
            }
            case 20: {
                Name name = this.getName(byteBuffer.getChar(n2));
                return this.syms.enterPackage(this.reader.currentModule, ClassFile.internalize(name));
            }
            case 19: {
                Name name = this.getName(byteBuffer.getChar(n2));
                return this.syms.enterModule(name);
            }
        }
        throw this.reader.badClassFile("unexpected.const.pool.tag.at", Integer.toString(n), Integer.toString(n2 - 1));
    }

    int readPool(ByteBuffer byteBuffer, int n) {
        try {
            return this.readPoolInternal(byteBuffer, n);
        }
        catch (ByteBuffer.UnderflowException underflowException) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(underflowException.getLength()));
        }
    }

    private int readPoolInternal(ByteBuffer byteBuffer, int n) throws ByteBuffer.UnderflowException {
        byte by;
        int n2 = byteBuffer.getChar(n);
        n += 2;
        int[] nArray = new int[n2];
        block7: for (int i = 1; i < n2; i += this.sizeof(by)) {
            by = byteBuffer.getByte(n++);
            nArray[i] = n;
            switch (by) {
                case 1: {
                    char c = byteBuffer.getChar(n);
                    n += 2 + c;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    n += 2;
                    continue block7;
                }
                case 15: {
                    n += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    n += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    n += 8;
                    continue block7;
                }
                default: {
                    throw this.reader.badClassFile("bad.const.pool.tag.at", Byte.toString(by), Integer.toString(n - 1));
                }
            }
        }
        this.pool = new ImmutablePoolHelper(byteBuffer, nArray);
        return n;
    }

    private int sizeof(int n) {
        switch (n) {
            case 5: 
            case 6: {
                return 2;
            }
        }
        return 1;
    }

    static {
        classCP.set(7);
        constantCP.set(3, 9);
        moduleCP.set(19);
        packageCP.set(20);
        utf8CP.set(1);
        nameAndTypeCP.set(12);
    }

    class ImmutablePoolHelper {
        final Object[] values;
        final int[] offsets;
        final ByteBuffer poolbuf;

        public ImmutablePoolHelper(ByteBuffer byteBuffer, int[] nArray) {
            this.offsets = nArray;
            this.values = new Object[nArray.length];
            this.poolbuf = byteBuffer;
        }

        private int checkIndex(int n) {
            if (n <= 0 || n >= this.offsets.length) {
                throw PoolReader.this.reader.badClassFile("bad.const.pool.index", ((PoolReader)PoolReader.this).reader.currentClassFile, n, this.offsets.length);
            }
            return n;
        }

        int offset(int n) {
            return this.offsets[this.checkIndex(n)];
        }

        <P> P readIfNeeded(int n, BitSet bitSet) {
            Object object;
            Object object2 = this.values[this.checkIndex(n)];
            if (object2 != null) {
                return (P)object2;
            }
            int n2 = this.tag(n);
            if (!bitSet.get(n2)) {
                throw PoolReader.this.reader.badClassFile("unexpected.const.pool.tag.at", this.tag(n), this.offset(n));
            }
            try {
                object = PoolReader.this.resolve(this.poolbuf, n2, this.offset(n));
            }
            catch (InvalidUtfException invalidUtfException) {
                throw PoolReader.this.reader.badClassFile(CompilerProperties.Fragments.BadUtf8ByteSequenceAt(invalidUtfException.getOffset()));
            }
            catch (ByteBuffer.UnderflowException underflowException) {
                throw PoolReader.this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(underflowException.getLength()));
            }
            this.values[n] = object;
            return (P)object;
        }

        int tag(int n) {
            return this.poolbuf.elems[this.offset(n) - 1];
        }
    }

    public static interface Utf8Mapper<X> {
        public X map(byte[] var1, int var2, int var3) throws InvalidUtfException;
    }
}

