/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class JNIWriter {
    protected static final Context.Key<JNIWriter> jniWriterKey = new Context.Key();
    private final JavaFileManager fileManager;
    Types types;
    Symtab syms;
    private final Log log;
    private boolean verbose;
    private boolean checkAll;
    private final HashMap<String, String> filesWritten = new HashMap();
    public boolean multiModuleMode;
    private Context context;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public static JNIWriter instance(Context context) {
        JNIWriter jNIWriter = context.get(jniWriterKey);
        if (jNIWriter == null) {
            jNIWriter = new JNIWriter(context);
        }
        return jNIWriter;
    }

    private JNIWriter(Context context) {
        context.put(jniWriterKey, this);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.checkAll = options.isSet("javah:full");
        this.context = context;
    }

    private void lazyInit() {
        if (this.types == null) {
            this.types = Types.instance(this.context);
        }
        if (this.syms == null) {
            this.syms = Symtab.instance(this.context);
        }
    }

    static boolean isSynthetic(Symbol symbol) {
        return JNIWriter.hasFlag(symbol, 4096);
    }

    static boolean isStatic(Symbol symbol) {
        return JNIWriter.hasFlag(symbol, 8);
    }

    static boolean isFinal(Symbol symbol) {
        return JNIWriter.hasFlag(symbol, 16);
    }

    static boolean isNative(Symbol symbol) {
        return JNIWriter.hasFlag(symbol, 256);
    }

    private static boolean hasFlag(Symbol symbol, int n) {
        return (symbol.flags() & (long)n) != 0L;
    }

    public boolean needsHeader(Symbol.ClassSymbol classSymbol) {
        this.lazyInit();
        if (classSymbol.isDirectlyOrIndirectlyLocal() || JNIWriter.isSynthetic(classSymbol)) {
            return false;
        }
        return this.checkAll ? this.needsHeader(classSymbol.outermostClass(), true) : this.needsHeader(classSymbol, false);
    }

    private boolean needsHeader(Symbol.ClassSymbol classSymbol, boolean bl) {
        if (classSymbol.isDirectlyOrIndirectlyLocal() || JNIWriter.isSynthetic(classSymbol)) {
            return false;
        }
        for (Symbol symbol : classSymbol.members_field.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol.kind == Kinds.Kind.MTH && JNIWriter.isNative(symbol)) {
                return true;
            }
            for (Attribute.Compound compound : symbol.getDeclarationAttributes()) {
                if (compound.type.tsym != this.syms.nativeHeaderType.tsym) continue;
                return true;
            }
        }
        if (bl) {
            for (Symbol symbol : classSymbol.members_field.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (symbol.kind != Kinds.Kind.TYP || !this.needsHeader((Symbol.ClassSymbol)symbol, true)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject write(Symbol.ClassSymbol classSymbol) throws IOException {
        JavaFileManager.Location location;
        Object object;
        String string = classSymbol.flatName().toString();
        if (this.multiModuleMode) {
            object = classSymbol.owner.kind == Kinds.Kind.MDL ? (Symbol.ModuleSymbol)classSymbol.owner : classSymbol.packge().modle;
            location = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.NATIVE_HEADER_OUTPUT, ((Symbol.ModuleSymbol)object).name.toString());
        } else {
            location = StandardLocation.NATIVE_HEADER_OUTPUT;
        }
        object = string.replaceAll("[.$]", "_") + ".h";
        String string2 = this.filesWritten.put((String)object, string);
        if (string2 != null) {
            throw new IOException(String.format("native header file collision between %s and %s (both generate %s)", string2, string, object));
        }
        FileObject fileObject = this.fileManager.getFileForOutput(location, "", (String)object, null);
        PrintWriter printWriter = new PrintWriter(fileObject.openWriter());
        try {
            this.write(printWriter, classSymbol);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", fileObject.getName());
            }
            printWriter.close();
            printWriter = null;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                fileObject.delete();
                fileObject = null;
            }
        }
        return fileObject;
    }

    public void write(PrintWriter printWriter, Symbol.ClassSymbol classSymbol) throws IOException {
        this.lazyInit();
        try {
            String string = JNIWriter.encode(classSymbol.fullname, EncoderType.CLASS);
            this.fileTop(printWriter);
            this.includes(printWriter);
            this.guardBegin(printWriter, string);
            this.cppGuardBegin(printWriter);
            this.writeStatics(printWriter, classSymbol);
            this.writeMethods(printWriter, classSymbol, string);
            this.cppGuardEnd(printWriter);
            this.guardEnd(printWriter);
        }
        catch (TypeSignature.SignatureException signatureException) {
            throw new IOException(signatureException);
        }
    }

    protected void writeStatics(PrintWriter printWriter, Symbol.ClassSymbol classSymbol) throws IOException {
        ArrayList<Symbol.ClassSymbol> arrayList = new ArrayList<Symbol.ClassSymbol>();
        Object object = classSymbol;
        while (object != null) {
            arrayList.add((Symbol.ClassSymbol)object);
            object = (Symbol.ClassSymbol)((Symbol.ClassSymbol)object).getSuperclass().tsym;
        }
        Collections.reverse(arrayList);
        for (Symbol.ClassSymbol classSymbol2 : arrayList) {
            for (Symbol symbol : classSymbol2.getEnclosedElements()) {
                Symbol.VarSymbol varSymbol;
                if (!JNIWriter.isFinal(symbol) || !symbol.isStatic() || symbol.kind != Kinds.Kind.VAR || (varSymbol = (Symbol.VarSymbol)symbol).getConstantValue() == null) continue;
                Pair<Symbol.ClassSymbol, Symbol.VarSymbol> pair = new Pair<Symbol.ClassSymbol, Symbol.VarSymbol>(classSymbol, varSymbol);
                JNIWriter.printStaticDefines(printWriter, pair);
            }
        }
    }

    static void printStaticDefines(PrintWriter printWriter, Pair<Symbol.ClassSymbol, Symbol.VarSymbol> pair) {
        Object object;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)pair.fst;
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)pair.snd;
        Object object2 = varSymbol.getConstantValue();
        String string = null;
        switch (((Type)varSymbol.asType()).getKind()) {
            case BOOLEAN: {
                string = (Boolean)object2 != false ? "1L" : "0L";
                break;
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                string = object2.toString() + "L";
                break;
            }
            case LONG: {
                string = object2.toString() + (isWindows ? "i64" : "LL");
                break;
            }
            case CHAR: {
                object = (Character)object2;
                string = String.valueOf(((Character)object).charValue() & 0xFFFF) + "L";
                break;
            }
            case FLOAT: {
                float f = ((Float)object2).floatValue();
                string = Float.isInfinite(f) ? (f < 0.0f ? "-" : "") + "Inff" : object2.toString() + "f";
                break;
            }
            case DOUBLE: {
                double d = (Double)object2;
                string = Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "InfD" : object2.toString();
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            printWriter.print("#undef ");
            object = JNIWriter.encode(classSymbol.getQualifiedName(), EncoderType.CLASS);
            String string2 = JNIWriter.encode(varSymbol.getSimpleName(), EncoderType.FIELDSTUB);
            printWriter.println((String)object + "_" + string2);
            printWriter.print("#define " + (String)object + "_");
            printWriter.println(string2 + " " + string);
        }
    }

    protected void writeMethods(PrintWriter printWriter, Symbol.ClassSymbol classSymbol, String string) throws IOException, TypeSignature.SignatureException {
        List list = classSymbol.getEnclosedElements();
        for (Symbol symbol : list) {
            if (!JNIWriter.isNative(symbol)) continue;
            TypeSignature typeSignature = new TypeSignature(this.types);
            Name name = symbol.getSimpleName();
            boolean bl = false;
            for (Symbol symbol2 : list) {
                if (symbol2 == symbol || !((Object)name).equals(symbol2.getSimpleName()) || !JNIWriter.isNative(symbol2)) continue;
                bl = true;
            }
            printWriter.println("/*");
            printWriter.println(" * Class:     " + string);
            printWriter.println(" * Method:    " + JNIWriter.encode(name, EncoderType.FIELDSTUB));
            printWriter.println(" * Signature: " + typeSignature.getSignature(symbol.type));
            printWriter.println(" */");
            printWriter.println("JNIEXPORT " + this.jniType(this.types.erasure(symbol.type.getReturnType())) + " JNICALL " + this.encodeMethod(symbol, classSymbol, bl));
            printWriter.print("  (JNIEnv *, ");
            printWriter.print(symbol.isStatic() ? "jclass" : "jobject");
            for (Type type : this.types.erasure(symbol.type.getParameterTypes())) {
                printWriter.print(", ");
                printWriter.print(this.jniType(type));
            }
            printWriter.println(");");
            printWriter.println();
        }
    }

    protected final String jniType(Type type) {
        switch (type.getKind()) {
            case ARRAY: {
                Type type2 = ((Type.ArrayType)type).getComponentType();
                switch (type2.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(type2.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (type.tsym.type == this.syms.stringType) {
                    return "jstring";
                }
                if (this.types.isAssignable(type, this.syms.throwableType)) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(type, this.syms.classType)) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        Assert.check(false, "jni unknown type");
        return null;
    }

    protected void fileTop(PrintWriter printWriter) {
        printWriter.println("/* DO NOT EDIT THIS FILE - it is machine generated */");
    }

    protected void includes(PrintWriter printWriter) {
        printWriter.println("#include <jni.h>");
    }

    protected void cppGuardBegin(PrintWriter printWriter) {
        printWriter.println("#ifdef __cplusplus");
        printWriter.println("extern \"C\" {");
        printWriter.println("#endif");
    }

    protected void cppGuardEnd(PrintWriter printWriter) {
        printWriter.println("#ifdef __cplusplus");
        printWriter.println("}");
        printWriter.println("#endif");
    }

    protected void guardBegin(PrintWriter printWriter, String string) {
        printWriter.println("/* Header for class " + string + " */");
        printWriter.println();
        printWriter.println("#ifndef _Included_" + string);
        printWriter.println("#define _Included_" + string);
    }

    protected void guardEnd(PrintWriter printWriter) {
        printWriter.println("#endif");
    }

    String encodeMethod(Symbol symbol, Symbol.ClassSymbol classSymbol, boolean bl) throws TypeSignature.SignatureException {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("Java_");
        stringBuilder.append(JNIWriter.encode(classSymbol.flatname.toString(), EncoderType.JNI));
        stringBuilder.append('_');
        stringBuilder.append(JNIWriter.encode(symbol.getSimpleName(), EncoderType.JNI));
        if (bl) {
            TypeSignature typeSignature = new TypeSignature(this.types);
            StringBuilder stringBuilder2 = typeSignature.getParameterSignature(symbol.type, true);
            stringBuilder.append("__").append(JNIWriter.encode(stringBuilder2, EncoderType.JNI));
        }
        return stringBuilder.toString();
    }

    static String encode(CharSequence charSequence, EncoderType encoderType) {
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = charSequence.length();
        block16: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (JNIWriter.isalnum(c)) {
                stringBuilder.append(c);
                continue;
            }
            switch (encoderType.ordinal()) {
                case 0: {
                    switch (c) {
                        case '.': 
                        case '_': {
                            stringBuilder.append("_");
                            continue block16;
                        }
                        case '$': {
                            stringBuilder.append("__");
                            continue block16;
                        }
                    }
                    stringBuilder.append(JNIWriter.encodeChar(c));
                    continue block16;
                }
                case 3: {
                    switch (c) {
                        case '.': 
                        case '/': {
                            stringBuilder.append("_");
                            continue block16;
                        }
                        case '_': {
                            stringBuilder.append("_1");
                            continue block16;
                        }
                        case ';': {
                            stringBuilder.append("_2");
                            continue block16;
                        }
                        case '[': {
                            stringBuilder.append("_3");
                            continue block16;
                        }
                    }
                    stringBuilder.append(JNIWriter.encodeChar(c));
                    continue block16;
                }
                case 4: {
                    stringBuilder.append(JNIWriter.isprint(c) ? Character.valueOf(c) : JNIWriter.encodeChar(c));
                    continue block16;
                }
                case 1: {
                    stringBuilder.append(c == '_' ? Character.valueOf(c) : JNIWriter.encodeChar(c));
                    continue block16;
                }
                default: {
                    stringBuilder.append(JNIWriter.encodeChar(c));
                }
            }
        }
        return stringBuilder.toString();
    }

    static String encodeChar(char c) {
        int n;
        String string = Integer.toHexString(c);
        int n2 = 5 - string.length();
        char[] cArray = new char[6];
        cArray[0] = 95;
        for (n = 1; n <= n2; ++n) {
            cArray[n] = 48;
        }
        n = n2 + 1;
        int n3 = 0;
        while (n < 6) {
            cArray[n] = string.charAt(n3);
            ++n;
            ++n3;
        }
        return new String(cArray);
    }

    private static boolean isalnum(char c) {
        return c <= '\u007f' && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9');
    }

    private static boolean isprint(char c) {
        return c >= ' ' && c <= '~';
    }

    static enum EncoderType {
        CLASS,
        FIELDSTUB,
        FIELD,
        JNI,
        SIGNATURE;

    }

    private static class TypeSignature {
        JavacElements elems;
        Types types;
        private static final String SIG_VOID = "V";
        private static final String SIG_BOOLEAN = "Z";
        private static final String SIG_BYTE = "B";
        private static final String SIG_CHAR = "C";
        private static final String SIG_SHORT = "S";
        private static final String SIG_INT = "I";
        private static final String SIG_LONG = "J";
        private static final String SIG_FLOAT = "F";
        private static final String SIG_DOUBLE = "D";
        private static final String SIG_ARRAY = "[";
        private static final String SIG_CLASS = "L";

        public TypeSignature(Types types) {
            this.types = types;
        }

        StringBuilder getParameterSignature(Type type, boolean bl) throws SignatureException {
            StringBuilder stringBuilder = new StringBuilder();
            for (Type type2 : type.getParameterTypes()) {
                stringBuilder.append((CharSequence)this.getJvmSignature(type2, bl));
            }
            return stringBuilder;
        }

        StringBuilder getReturnSignature(Type type) throws SignatureException {
            return this.getJvmSignature(type.getReturnType(), false);
        }

        StringBuilder getSignature(Type type) throws SignatureException {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(").append((CharSequence)this.getParameterSignature(type, false)).append(")");
            stringBuilder.append((CharSequence)this.getReturnSignature(type));
            return stringBuilder;
        }

        StringBuilder getJvmSignature(Type type, boolean bl) {
            Type type2 = this.types.erasure(type);
            StringBuilder stringBuilder = new StringBuilder();
            JvmTypeVisitor jvmTypeVisitor = new JvmTypeVisitor(bl);
            jvmTypeVisitor.visitType(type2, stringBuilder);
            return stringBuilder;
        }

        static class JvmTypeVisitor
        extends SimpleTypeVisitor<Type, StringBuilder> {
            private final boolean useFlatname;

            JvmTypeVisitor(boolean bl) {
                this.useFlatname = bl;
            }

            @Override
            public Type visitClassType(Type.ClassType classType, StringBuilder stringBuilder) {
                this.setDeclaredType(classType, stringBuilder);
                return null;
            }

            @Override
            public Type visitArrayType(Type.ArrayType arrayType, StringBuilder stringBuilder) {
                stringBuilder.append(TypeSignature.SIG_ARRAY);
                return arrayType.getComponentType().accept(this, stringBuilder);
            }

            @Override
            public Type visitType(Type type, StringBuilder stringBuilder) {
                if (type.isPrimitiveOrVoid()) {
                    stringBuilder.append(this.getJvmPrimitiveSignature(type));
                    return null;
                }
                return type.accept(this, stringBuilder);
            }

            private void setDeclaredType(Type type, StringBuilder stringBuilder) {
                String string = this.useFlatname ? type.tsym.flatName().toString() : type.tsym.getQualifiedName().toString();
                string = string.replace('.', '/');
                stringBuilder.append(TypeSignature.SIG_CLASS).append(string).append(";");
            }

            private String getJvmPrimitiveSignature(Type type) {
                switch (type.getKind()) {
                    case VOID: {
                        return TypeSignature.SIG_VOID;
                    }
                    case BOOLEAN: {
                        return TypeSignature.SIG_BOOLEAN;
                    }
                    case BYTE: {
                        return TypeSignature.SIG_BYTE;
                    }
                    case CHAR: {
                        return TypeSignature.SIG_CHAR;
                    }
                    case SHORT: {
                        return TypeSignature.SIG_SHORT;
                    }
                    case INT: {
                        return TypeSignature.SIG_INT;
                    }
                    case LONG: {
                        return TypeSignature.SIG_LONG;
                    }
                    case FLOAT: {
                        return TypeSignature.SIG_FLOAT;
                    }
                    case DOUBLE: {
                        return TypeSignature.SIG_DOUBLE;
                    }
                }
                Assert.error("unknown type: should not happen");
                return null;
            }
        }

        static class SignatureException
        extends Exception {
            private static final long serialVersionUID = 1L;

            SignatureException(String string) {
                super(string);
            }
        }
    }

    static class SimpleTypeVisitor<R, P>
    implements Type.Visitor<R, P> {
        protected final R DEFAULT_VALUE;

        protected SimpleTypeVisitor() {
            this.DEFAULT_VALUE = null;
        }

        protected SimpleTypeVisitor(R r) {
            this.DEFAULT_VALUE = r;
        }

        protected R defaultAction(Type type, P p) {
            return this.DEFAULT_VALUE;
        }

        @Override
        public R visitClassType(Type.ClassType classType, P p) {
            return this.defaultAction(classType, p);
        }

        @Override
        public R visitWildcardType(Type.WildcardType wildcardType, P p) {
            return this.defaultAction(wildcardType, p);
        }

        @Override
        public R visitArrayType(Type.ArrayType arrayType, P p) {
            return this.defaultAction(arrayType, p);
        }

        @Override
        public R visitMethodType(Type.MethodType methodType, P p) {
            return this.defaultAction(methodType, p);
        }

        @Override
        public R visitPackageType(Type.PackageType packageType, P p) {
            return this.defaultAction(packageType, p);
        }

        @Override
        public R visitTypeVar(Type.TypeVar typeVar, P p) {
            return this.defaultAction(typeVar, p);
        }

        @Override
        public R visitCapturedType(Type.CapturedType capturedType, P p) {
            return this.defaultAction(capturedType, p);
        }

        @Override
        public R visitForAll(Type.ForAll forAll, P p) {
            return this.defaultAction(forAll, p);
        }

        @Override
        public R visitUndetVar(Type.UndetVar undetVar, P p) {
            return this.defaultAction(undetVar, p);
        }

        @Override
        public R visitErrorType(Type.ErrorType errorType, P p) {
            return this.defaultAction(errorType, p);
        }

        @Override
        public R visitType(Type type, P p) {
            return this.defaultAction(type, p);
        }

        @Override
        public R visitModuleType(Type.ModuleType moduleType, P p) {
            return this.defaultAction(moduleType, p);
        }
    }
}

