/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.CRTFlags;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Position;
import java.util.HashMap;
import java.util.Map;

public class CRTable
implements CRTFlags {
    private final boolean crtDebug = false;
    private ListBuffer<CRTEntry> entries = new ListBuffer();
    private Map<Object, SourceRange> positions = new HashMap<Object, SourceRange>();
    private EndPosTable endPosTable;
    JCTree.JCMethodDecl methodTree;

    public CRTable(JCTree.JCMethodDecl jCMethodDecl, EndPosTable endPosTable) {
        this.methodTree = jCMethodDecl;
        this.endPosTable = endPosTable;
    }

    public void put(Object object, int n, int n2, int n3) {
        this.entries.append(new CRTEntry(object, n, n2, n3));
    }

    public int writeCRT(ByteBuffer byteBuffer, Position.LineMap lineMap, Log log) {
        int n = 0;
        new SourceComputer().csp(this.methodTree);
        List<CRTEntry> list = this.entries.toList();
        while (list.nonEmpty()) {
            CRTEntry cRTEntry = (CRTEntry)list.head;
            if (cRTEntry.startPc != cRTEntry.endPc) {
                int n2;
                int n3;
                SourceRange sourceRange = this.positions.get(cRTEntry.tree);
                Assert.checkNonNull(sourceRange, "CRT: tree source positions are undefined");
                if (sourceRange.startPos != -1 && sourceRange.endPos != -1 && (n3 = this.encodePosition(sourceRange.startPos, lineMap, log)) != -1 && (n2 = this.encodePosition(sourceRange.endPos, lineMap, log)) != -1) {
                    byteBuffer.appendChar(cRTEntry.startPc);
                    byteBuffer.appendChar(cRTEntry.endPc - 1);
                    byteBuffer.appendInt(n3);
                    byteBuffer.appendInt(n2);
                    byteBuffer.appendChar(cRTEntry.flags);
                    ++n;
                }
            }
            list = list.tail;
        }
        return n;
    }

    public int length() {
        return this.entries.length();
    }

    private String getTypes(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = string + " CRT_STATEMENT";
        }
        if ((n & 2) != 0) {
            string = string + " CRT_BLOCK";
        }
        if ((n & 4) != 0) {
            string = string + " CRT_ASSIGNMENT";
        }
        if ((n & 8) != 0) {
            string = string + " CRT_FLOW_CONTROLLER";
        }
        if ((n & 0x10) != 0) {
            string = string + " CRT_FLOW_TARGET";
        }
        if ((n & 0x20) != 0) {
            string = string + " CRT_INVOKE";
        }
        if ((n & 0x40) != 0) {
            string = string + " CRT_CREATE";
        }
        if ((n & 0x80) != 0) {
            string = string + " CRT_BRANCH_TRUE";
        }
        if ((n & 0x100) != 0) {
            string = string + " CRT_BRANCH_FALSE";
        }
        return string;
    }

    private int encodePosition(int n, Position.LineMap lineMap, Log log) {
        int n2;
        int n3 = lineMap.getLineNumber(n);
        int n4 = Position.encodePosition(n3, n2 = lineMap.getColumnNumber(n));
        if (n4 == -1) {
            log.warning(n, CompilerProperties.Warnings.PositionOverflow(n3));
        }
        return n4;
    }

    static class CRTEntry {
        Object tree;
        int flags;
        int startPc;
        int endPc;

        CRTEntry(Object object, int n, int n2, int n3) {
            this.tree = object;
            this.flags = n;
            this.startPc = n2;
            this.endPc = n3;
        }
    }

    class SourceComputer
    extends JCTree.Visitor {
        SourceRange result;

        SourceComputer() {
        }

        public SourceRange csp(JCTree jCTree) {
            if (jCTree == null) {
                return null;
            }
            jCTree.accept(this);
            if (this.result != null) {
                CRTable.this.positions.put(jCTree, this.result);
            }
            return this.result;
        }

        public SourceRange csp(List<? extends JCTree> list) {
            if (list == null || !list.nonEmpty()) {
                return null;
            }
            SourceRange sourceRange = new SourceRange();
            List<JCTree> list2 = list;
            while (list2.nonEmpty()) {
                sourceRange.mergeWith(this.csp((JCTree)list2.head));
                list2 = list2.tail;
            }
            CRTable.this.positions.put(list, sourceRange);
            return sourceRange;
        }

        public SourceRange cspCases(List<JCTree.JCCase> list) {
            if (list == null || !list.nonEmpty()) {
                return null;
            }
            SourceRange sourceRange = new SourceRange();
            List<JCTree.JCCase> list2 = list;
            while (list2.nonEmpty()) {
                sourceRange.mergeWith(this.csp((JCTree)list2.head));
                list2 = list2.tail;
            }
            CRTable.this.positions.put(list, sourceRange);
            return sourceRange;
        }

        public SourceRange cspCatchers(List<JCTree.JCCatch> list) {
            if (list == null || !list.nonEmpty()) {
                return null;
            }
            SourceRange sourceRange = new SourceRange();
            List<JCTree.JCCatch> list2 = list;
            while (list2.nonEmpty()) {
                sourceRange.mergeWith(this.csp((JCTree)list2.head));
                list2 = list2.tail;
            }
            CRTable.this.positions.put(list, sourceRange);
            return sourceRange;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCMethodDecl), this.endPos(jCMethodDecl));
            sourceRange.mergeWith(this.csp(jCMethodDecl.body));
            this.result = sourceRange;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCVariableDecl), this.endPos(jCVariableDecl));
            this.csp(jCVariableDecl.vartype);
            sourceRange.mergeWith(this.csp(jCVariableDecl.init));
            this.result = sourceRange;
        }

        @Override
        public void visitSkip(JCTree.JCSkip jCSkip) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(jCSkip), this.startPos(jCSkip));
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCBlock), this.endPos(jCBlock));
            this.csp(jCBlock.stats);
            this.result = sourceRange;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCDoWhileLoop), this.endPos(jCDoWhileLoop));
            sourceRange.mergeWith(this.csp(jCDoWhileLoop.body));
            sourceRange.mergeWith(this.csp(jCDoWhileLoop.cond));
            this.result = sourceRange;
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCWhileLoop), this.endPos(jCWhileLoop));
            sourceRange.mergeWith(this.csp(jCWhileLoop.cond));
            sourceRange.mergeWith(this.csp(jCWhileLoop.body));
            this.result = sourceRange;
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCForLoop), this.endPos(jCForLoop));
            sourceRange.mergeWith(this.csp(jCForLoop.init));
            sourceRange.mergeWith(this.csp(jCForLoop.cond));
            sourceRange.mergeWith(this.csp(jCForLoop.step));
            sourceRange.mergeWith(this.csp(jCForLoop.body));
            this.result = sourceRange;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCEnhancedForLoop), this.endPos(jCEnhancedForLoop));
            sourceRange.mergeWith(this.csp(jCEnhancedForLoop.var));
            sourceRange.mergeWith(this.csp(jCEnhancedForLoop.expr));
            sourceRange.mergeWith(this.csp(jCEnhancedForLoop.body));
            this.result = sourceRange;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCLabeledStatement), this.endPos(jCLabeledStatement));
            sourceRange.mergeWith(this.csp(jCLabeledStatement.body));
            this.result = sourceRange;
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCSwitch), this.endPos(jCSwitch));
            sourceRange.mergeWith(this.csp(jCSwitch.selector));
            sourceRange.mergeWith(this.cspCases(jCSwitch.cases));
            this.result = sourceRange;
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCSwitchExpression), this.endPos(jCSwitchExpression));
            sourceRange.mergeWith(this.csp(jCSwitchExpression.selector));
            sourceRange.mergeWith(this.cspCases(jCSwitchExpression.cases));
            this.result = sourceRange;
        }

        @Override
        public void visitCase(JCTree.JCCase jCCase) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCCase), this.endPos(jCCase));
            sourceRange.mergeWith(this.csp(jCCase.labels));
            sourceRange.mergeWith(this.csp(jCCase.guard));
            sourceRange.mergeWith(this.csp(jCCase.stats));
            this.result = sourceRange;
        }

        @Override
        public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel jCDefaultCaseLabel) {
            this.result = null;
        }

        @Override
        public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel jCConstantCaseLabel) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCConstantCaseLabel), this.endPos(jCConstantCaseLabel));
            sourceRange.mergeWith(this.csp(jCConstantCaseLabel.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel jCPatternCaseLabel) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCPatternCaseLabel), this.endPos(jCPatternCaseLabel));
            sourceRange.mergeWith(this.csp(jCPatternCaseLabel.pat));
            this.result = sourceRange;
        }

        @Override
        public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCSynchronized), this.endPos(jCSynchronized));
            sourceRange.mergeWith(this.csp(jCSynchronized.lock));
            sourceRange.mergeWith(this.csp(jCSynchronized.body));
            this.result = sourceRange;
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCTry), this.endPos(jCTry));
            sourceRange.mergeWith(this.csp(jCTry.resources));
            sourceRange.mergeWith(this.csp(jCTry.body));
            sourceRange.mergeWith(this.cspCatchers(jCTry.catchers));
            sourceRange.mergeWith(this.csp(jCTry.finalizer));
            this.result = sourceRange;
        }

        @Override
        public void visitCatch(JCTree.JCCatch jCCatch) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCCatch), this.endPos(jCCatch));
            sourceRange.mergeWith(this.csp(jCCatch.param));
            sourceRange.mergeWith(this.csp(jCCatch.body));
            this.result = sourceRange;
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCConditional), this.endPos(jCConditional));
            sourceRange.mergeWith(this.csp(jCConditional.cond));
            sourceRange.mergeWith(this.csp(jCConditional.truepart));
            sourceRange.mergeWith(this.csp(jCConditional.falsepart));
            this.result = sourceRange;
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCIf), this.endPos(jCIf));
            sourceRange.mergeWith(this.csp(jCIf.cond));
            sourceRange.mergeWith(this.csp(jCIf.thenpart));
            sourceRange.mergeWith(this.csp(jCIf.elsepart));
            this.result = sourceRange;
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCExpressionStatement), this.endPos(jCExpressionStatement));
            sourceRange.mergeWith(this.csp(jCExpressionStatement.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(jCBreak), this.endPos(jCBreak));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCYield), this.endPos(jCYield));
            sourceRange.mergeWith(this.csp(jCYield.value));
            this.result = sourceRange;
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(jCContinue), this.endPos(jCContinue));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCReturn), this.endPos(jCReturn));
            sourceRange.mergeWith(this.csp(jCReturn.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCThrow), this.endPos(jCThrow));
            sourceRange.mergeWith(this.csp(jCThrow.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitAssert(JCTree.JCAssert jCAssert) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCAssert), this.endPos(jCAssert));
            sourceRange.mergeWith(this.csp(jCAssert.cond));
            sourceRange.mergeWith(this.csp(jCAssert.detail));
            this.result = sourceRange;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCMethodInvocation), this.endPos(jCMethodInvocation));
            sourceRange.mergeWith(this.csp(jCMethodInvocation.meth));
            sourceRange.mergeWith(this.csp(jCMethodInvocation.args));
            this.result = sourceRange;
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCNewClass), this.endPos(jCNewClass));
            sourceRange.mergeWith(this.csp(jCNewClass.encl));
            sourceRange.mergeWith(this.csp(jCNewClass.clazz));
            sourceRange.mergeWith(this.csp(jCNewClass.args));
            sourceRange.mergeWith(this.csp(jCNewClass.def));
            this.result = sourceRange;
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCNewArray), this.endPos(jCNewArray));
            sourceRange.mergeWith(this.csp(jCNewArray.elemtype));
            sourceRange.mergeWith(this.csp(jCNewArray.dims));
            sourceRange.mergeWith(this.csp(jCNewArray.elems));
            this.result = sourceRange;
        }

        @Override
        public void visitParens(JCTree.JCParens jCParens) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCParens), this.endPos(jCParens));
            sourceRange.mergeWith(this.csp(jCParens.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCAssign), this.endPos(jCAssign));
            sourceRange.mergeWith(this.csp(jCAssign.lhs));
            sourceRange.mergeWith(this.csp(jCAssign.rhs));
            this.result = sourceRange;
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCAssignOp), this.endPos(jCAssignOp));
            sourceRange.mergeWith(this.csp(jCAssignOp.lhs));
            sourceRange.mergeWith(this.csp(jCAssignOp.rhs));
            this.result = sourceRange;
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCUnary), this.endPos(jCUnary));
            sourceRange.mergeWith(this.csp(jCUnary.arg));
            this.result = sourceRange;
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCBinary), this.endPos(jCBinary));
            sourceRange.mergeWith(this.csp(jCBinary.lhs));
            sourceRange.mergeWith(this.csp(jCBinary.rhs));
            this.result = sourceRange;
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCTypeCast), this.endPos(jCTypeCast));
            sourceRange.mergeWith(this.csp(jCTypeCast.clazz));
            sourceRange.mergeWith(this.csp(jCTypeCast.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCInstanceOf), this.endPos(jCInstanceOf));
            sourceRange.mergeWith(this.csp(jCInstanceOf.expr));
            sourceRange.mergeWith(this.csp(jCInstanceOf.pattern));
            this.result = sourceRange;
        }

        @Override
        public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCArrayAccess), this.endPos(jCArrayAccess));
            sourceRange.mergeWith(this.csp(jCArrayAccess.indexed));
            sourceRange.mergeWith(this.csp(jCArrayAccess.index));
            this.result = sourceRange;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCFieldAccess), this.endPos(jCFieldAccess));
            sourceRange.mergeWith(this.csp(jCFieldAccess.selected));
            this.result = sourceRange;
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(jCIdent), this.endPos(jCIdent));
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral jCLiteral) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(jCLiteral), this.endPos(jCLiteral));
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
            SourceRange sourceRange;
            this.result = sourceRange = new SourceRange(this.startPos(jCPrimitiveTypeTree), this.endPos(jCPrimitiveTypeTree));
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCArrayTypeTree), this.endPos(jCArrayTypeTree));
            sourceRange.mergeWith(this.csp(jCArrayTypeTree.elemtype));
            this.result = sourceRange;
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCTypeApply), this.endPos(jCTypeApply));
            sourceRange.mergeWith(this.csp(jCTypeApply.clazz));
            sourceRange.mergeWith(this.csp(jCTypeApply.arguments));
            this.result = sourceRange;
        }

        @Override
        public void visitLetExpr(JCTree.LetExpr letExpr) {
            SourceRange sourceRange = new SourceRange(this.startPos(letExpr), this.endPos(letExpr));
            sourceRange.mergeWith(this.csp(letExpr.defs));
            sourceRange.mergeWith(this.csp(letExpr.expr));
            this.result = sourceRange;
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCTypeParameter), this.endPos(jCTypeParameter));
            sourceRange.mergeWith(this.csp(jCTypeParameter.bounds));
            this.result = sourceRange;
        }

        @Override
        public void visitTypeUnion(JCTree.JCTypeUnion jCTypeUnion) {
            SourceRange sourceRange = new SourceRange(this.startPos(jCTypeUnion), this.endPos(jCTypeUnion));
            sourceRange.mergeWith(this.csp(jCTypeUnion.alternatives));
            this.result = sourceRange;
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard jCWildcard) {
            this.result = null;
        }

        @Override
        public void visitErroneous(JCTree.JCErroneous jCErroneous) {
            this.result = null;
        }

        @Override
        public void visitTree(JCTree jCTree) {
            Assert.error();
        }

        public int startPos(JCTree jCTree) {
            if (jCTree == null) {
                return -1;
            }
            return TreeInfo.getStartPos(jCTree);
        }

        public int endPos(JCTree jCTree) {
            if (jCTree == null) {
                return -1;
            }
            return TreeInfo.getEndPos(jCTree, CRTable.this.endPosTable);
        }
    }

    static class SourceRange {
        int startPos;
        int endPos;

        SourceRange() {
            this.startPos = -1;
            this.endPos = -1;
        }

        SourceRange(int n, int n2) {
            this.startPos = n;
            this.endPos = n2;
        }

        SourceRange mergeWith(SourceRange sourceRange) {
            if (sourceRange == null) {
                return this;
            }
            if (this.startPos == -1) {
                this.startPos = sourceRange.startPos;
            } else if (sourceRange.startPos != -1) {
                int n = this.startPos = this.startPos < sourceRange.startPos ? this.startPos : sourceRange.startPos;
            }
            if (this.endPos == -1) {
                this.endPos = sourceRange.endPos;
            } else if (sourceRange.endPos != -1) {
                this.endPos = this.endPos > sourceRange.endPos ? this.endPos : sourceRange.endPos;
            }
            return this;
        }
    }
}

