/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ModuleNameReader;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import nbjavac.JmodFileWrapper;

public class Locations {
    private Log log;
    private FSInfo fsInfo;
    private Lint lint;
    private ModuleNameReader moduleNameReader;
    private StandardJavaFileManager.PathFactory pathFactory = Paths::get;
    static final Path javaHome = FileSystems.getDefault().getPath(System.getProperty("java.home"), new String[0]);
    static final Path thisSystemModules = javaHome.resolve("lib").resolve("modules");
    Map<Path, FileSystem> fileSystems = new LinkedHashMap<Path, FileSystem>();
    List<Closeable> closeables = new ArrayList<Closeable>();
    private Map<String, String> fsEnv = Collections.emptyMap();
    Map<JavaFileManager.Location, LocationHandler> handlersForLocation;
    Map<Option, LocationHandler> handlersForOption;

    Locations() {
        this.initHandlers();
    }

    Path getPath(String string, String ... stringArray) {
        try {
            return this.pathFactory.getPath(string, stringArray);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IllegalArgumentException(invalidPathException);
        }
    }

    public void close() throws IOException {
        ListBuffer listBuffer = new ListBuffer();
        this.closeables.forEach(closeable -> {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                listBuffer.add(iOException);
            }
        });
        if (listBuffer.nonEmpty()) {
            IOException iOException = new IOException();
            for (IOException iOException2 : listBuffer) {
                iOException.addSuppressed(iOException2);
            }
            throw iOException;
        }
    }

    void update(Log log, Lint lint, FSInfo fSInfo) {
        this.log = log;
        this.lint = lint;
        this.fsInfo = fSInfo;
    }

    void setPathFactory(StandardJavaFileManager.PathFactory pathFactory) {
        this.pathFactory = pathFactory;
    }

    boolean isDefaultBootClassPath() {
        BootClassPathLocationHandler bootClassPathLocationHandler = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return bootClassPathLocationHandler.isDefault();
    }

    boolean isDefaultSystemModulesPath() {
        SystemModulesLocationHandler systemModulesLocationHandler = (SystemModulesLocationHandler)this.getHandler(StandardLocation.SYSTEM_MODULES);
        return !systemModulesLocationHandler.isExplicit();
    }

    private Iterable<Path> getPathEntries(String string) {
        return this.getPathEntries(string, null);
    }

    private Iterable<Path> getPathEntries(String string, Path path) {
        ListBuffer<Path> listBuffer = new ListBuffer<Path>();
        for (String string2 : string.split(Pattern.quote(File.pathSeparator), -1)) {
            if (string2.length() == 0) {
                if (path == null) continue;
                listBuffer.add(path);
                continue;
            }
            try {
                listBuffer.add(this.getPath(string2, new String[0]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.lint.logIfEnabled(CompilerProperties.LintWarnings.InvalidPath(string2));
            }
        }
        return listBuffer;
    }

    public void setMultiReleaseValue(String string) {
        this.fsEnv = Collections.singletonMap("releaseVersion", string);
    }

    private boolean contains(Collection<Path> collection, Path path) throws IOException {
        Comparable<URI> comparable;
        if (collection == null) {
            return false;
        }
        Path path2 = null;
        if (path.getFileSystem().provider() == this.fsInfo.getJarFSProvider() && ((URI)(comparable = path.toUri())).getScheme().equals("jar")) {
            String string = ((URI)comparable).getSchemeSpecificPart();
            int n = string.lastIndexOf("!");
            if (string.startsWith("file:") && n > 0) {
                path2 = Paths.get(URI.create(string.substring(0, n)));
            }
        }
        comparable = Locations.normalize(path);
        for (Path path3 : collection) {
            Path path4 = Locations.normalize(path3);
            if (path4.getFileSystem() == comparable.getFileSystem() && Files.isDirectory(path4, new LinkOption[0]) && comparable.startsWith(path4)) {
                return true;
            }
            if (path2 == null || !Files.isSameFile(path2, path4)) continue;
            return true;
        }
        return false;
    }

    void initHandlers() {
        BasicLocationHandler[] basicLocationHandlerArray;
        this.handlersForLocation = new HashMap<JavaFileManager.Location, LocationHandler>();
        this.handlersForOption = new EnumMap<Option, LocationHandler>(Option.class);
        for (BasicLocationHandler basicLocationHandler : basicLocationHandlerArray = new BasicLocationHandler[]{new BootClassPathLocationHandler(), new ClassPathLocationHandler(), new SimpleLocationHandler(StandardLocation.SOURCE_PATH, Option.SOURCE_PATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_PATH, Option.PROCESSOR_PATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, Option.PROCESSOR_MODULE_PATH), new OutputLocationHandler(StandardLocation.CLASS_OUTPUT, Option.D), new OutputLocationHandler(StandardLocation.SOURCE_OUTPUT, Option.S), new OutputLocationHandler(StandardLocation.NATIVE_HEADER_OUTPUT, Option.H), new ModuleSourcePathLocationHandler(), new PatchModulesLocationHandler(), new ModulePathLocationHandler(StandardLocation.UPGRADE_MODULE_PATH, Option.UPGRADE_MODULE_PATH), new ModulePathLocationHandler(StandardLocation.MODULE_PATH, Option.MODULE_PATH), new SystemModulesLocationHandler()}) {
            this.handlersForLocation.put(basicLocationHandler.location, basicLocationHandler);
            for (Option option : basicLocationHandler.options) {
                this.handlersForOption.put(option, basicLocationHandler);
            }
        }
    }

    boolean handleOption(Option option, String string) {
        LocationHandler locationHandler = this.handlersForOption.get((Object)option);
        return locationHandler == null ? false : locationHandler.handleOption(option, string);
    }

    boolean hasLocation(JavaFileManager.Location location) {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? false : locationHandler.isSet();
    }

    boolean hasExplicitLocation(JavaFileManager.Location location) {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? false : locationHandler.isExplicit();
    }

    Collection<Path> getLocation(JavaFileManager.Location location) {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? null : locationHandler.getPaths();
    }

    Path getOutputLocation(JavaFileManager.Location location) {
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException();
        }
        LocationHandler locationHandler = this.getHandler(location);
        return ((OutputLocationHandler)locationHandler).outputDir;
    }

    void setLocation(JavaFileManager.Location location, Iterable<? extends Path> iterable) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        if (locationHandler == null) {
            locationHandler = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new SimpleLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, locationHandler);
        }
        locationHandler.setPaths(iterable);
    }

    JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String string) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? null : locationHandler.getLocationForModule(string);
    }

    JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, Path path) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? null : locationHandler.getLocationForModule(path);
    }

    void setLocationForModule(JavaFileManager.Location location, String string, Iterable<? extends Path> iterable) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        if (locationHandler == null) {
            locationHandler = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new ModulePathLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, locationHandler);
        }
        locationHandler.setPathsForModule(string, iterable);
    }

    String inferModuleName(JavaFileManager.Location location) {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? null : locationHandler.inferModuleName();
    }

    Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? null : locationHandler.listLocationsForModules();
    }

    boolean contains(JavaFileManager.Location location, Path path) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        if (locationHandler == null) {
            throw new IllegalArgumentException("unknown location");
        }
        return locationHandler.contains(path);
    }

    protected LocationHandler getHandler(JavaFileManager.Location location) {
        LocationHandler locationHandler;
        Objects.requireNonNull(location);
        return location instanceof LocationHandler ? (locationHandler = (LocationHandler)((Object)location)) : this.handlersForLocation.get(location);
    }

    private boolean isArchive(Path path) {
        String string = StringUtils.toLowerCase(path.getFileName().toString());
        return this.fsInfo.isFile(path) && (string.endsWith(".jar") || string.endsWith(".zip"));
    }

    static Path normalize(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            return path.toAbsolutePath().normalize();
        }
    }

    protected static abstract class LocationHandler {
        protected LocationHandler() {
        }

        abstract boolean handleOption(Option var1, String var2);

        boolean isSet() {
            return this.getPaths() != null;
        }

        abstract boolean isExplicit();

        abstract Collection<Path> getPaths();

        abstract void setPaths(Iterable<? extends Path> var1) throws IOException;

        abstract void setPathsForModule(String var1, Iterable<? extends Path> var2) throws IOException;

        JavaFileManager.Location getLocationForModule(String string) throws IOException {
            return null;
        }

        JavaFileManager.Location getLocationForModule(Path path) throws IOException {
            return null;
        }

        String inferModuleName() {
            return null;
        }

        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            return null;
        }

        abstract boolean contains(Path var1) throws IOException;
    }

    private class BootClassPathLocationHandler
    extends BasicLocationHandler {
        private Collection<Path> searchPath;
        final Map<Option, String> optionValues;
        private boolean isDefault;

        BootClassPathLocationHandler() {
            super(StandardLocation.PLATFORM_CLASS_PATH, Option.BOOT_CLASS_PATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS);
            this.optionValues = new EnumMap<Option, String>(Option.class);
        }

        boolean isDefault() {
            this.lazy();
            return this.isDefault;
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            option = this.canonicalize(option);
            this.optionValues.put(option, string);
            if (option == Option.BOOT_CLASS_PATH) {
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_PREPEND);
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_APPEND);
            }
            this.searchPath = null;
            return true;
        }

        private Option canonicalize(Option option) {
            switch (option) {
                case XBOOTCLASSPATH: {
                    return Option.BOOT_CLASS_PATH;
                }
                case DJAVA_ENDORSED_DIRS: {
                    return Option.ENDORSEDDIRS;
                }
                case DJAVA_EXT_DIRS: {
                    return Option.EXTDIRS;
                }
            }
            return option;
        }

        @Override
        Collection<Path> getPaths() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) {
            if (iterable == null) {
                this.searchPath = null;
            } else {
                this.isDefault = false;
                this.explicit = true;
                SearchPath searchPath = new SearchPath().addFiles(iterable, false);
                this.searchPath = Collections.unmodifiableCollection(searchPath);
                this.optionValues.clear();
            }
        }

        SearchPath computePath() throws IOException {
            Iterable<Path> iterable;
            SearchPath searchPath = new SearchPath();
            String string = this.optionValues.get((Object)Option.BOOT_CLASS_PATH);
            String string2 = this.optionValues.get((Object)Option.ENDORSEDDIRS);
            String string3 = this.optionValues.get((Object)Option.EXTDIRS);
            String string4 = this.optionValues.get((Object)Option.XBOOTCLASSPATH_PREPEND);
            String string5 = this.optionValues.get((Object)Option.XBOOTCLASSPATH_APPEND);
            searchPath.addFiles(string4);
            if (string2 != null) {
                searchPath.addDirectories(string2);
            } else {
                searchPath.addDirectories(System.getProperty("java.endorsed.dirs"), false);
            }
            if (string != null) {
                searchPath.addFiles(string);
            } else {
                iterable = this.systemClasses();
                if (iterable != null) {
                    searchPath.addFiles(iterable, false);
                } else {
                    String string6 = System.getProperty("sun.boot.class.path");
                    searchPath.addFiles(string6, false);
                }
            }
            searchPath.addFiles(string5);
            if (string3 != null) {
                searchPath.addDirectories(string3);
            } else {
                iterable = javaHome.resolve("lib/jfxrt.jar");
                if (Files.exists(iterable, new LinkOption[0])) {
                    searchPath.addFile((Path)iterable, false);
                }
                searchPath.addDirectories(System.getProperty("java.ext.dirs"), false);
            }
            this.isDefault = string4 == null && string == null && string5 == null;
            return searchPath;
        }

        private Collection<Path> systemClasses() throws IOException {
            if (Files.isRegularFile(thisSystemModules, new LinkOption[0])) {
                return Collections.singleton(thisSystemModules);
            }
            Path path = javaHome.resolve("modules");
            if (Files.isDirectory(path.resolve("java.base"), new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(path);){
                    Collection collection = stream.collect(Collectors.toList());
                    return collection;
                }
            }
            return null;
        }

        private void lazy() {
            if (this.searchPath == null) {
                try {
                    this.searchPath = Collections.unmodifiableCollection(this.computePath());
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
        }

        @Override
        boolean contains(Path path) throws IOException {
            return Locations.this.contains(this.searchPath, path);
        }
    }

    private class SystemModulesLocationHandler
    extends BasicLocationHandler {
        private Path systemJavaHome;
        private Path modules;
        private ModuleTable moduleTable;

        SystemModulesLocationHandler() {
            super(StandardLocation.SYSTEM_MODULES, Option.SYSTEM);
            this.systemJavaHome = javaHome;
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            if (string == null) {
                this.systemJavaHome = javaHome;
            } else if (string.equals("none")) {
                this.systemJavaHome = null;
            } else {
                this.update(Locations.this.getPath(string, new String[0]));
            }
            this.modules = null;
            return true;
        }

        @Override
        Collection<Path> getPaths() {
            return this.systemJavaHome == null ? null : Collections.singleton(this.systemJavaHome);
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) throws IOException {
            if (iterable == null) {
                this.systemJavaHome = null;
            } else {
                this.explicit = true;
                Path path = this.checkSingletonDirectory(iterable);
                this.update(path);
            }
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) throws IOException {
            List<Path> list = this.checkPaths(iterable);
            this.initSystemModules();
            ModuleLocationHandler moduleLocationHandler = this.moduleTable.get(string);
            if (moduleLocationHandler == null) {
                moduleLocationHandler = new ModuleLocationHandler(this, this.location.getName() + "[" + string + "]", string, list, true);
                this.moduleTable.add(moduleLocationHandler);
            } else {
                moduleLocationHandler.searchPath = list;
                this.moduleTable.updatePaths(moduleLocationHandler);
            }
            this.explicit = true;
        }

        private List<Path> checkPaths(Iterable<? extends Path> iterable) throws IOException {
            Objects.requireNonNull(iterable);
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : iterable) {
                arrayList.add(this.checkDirectory(path));
            }
            return arrayList;
        }

        private void update(Path path) {
            if (!this.isCurrentPlatform(path)) {
                boolean bl = Files.notExists(SystemModulesLocationHandler.resolveInJavaHomeLib(path, "jrt-fs.jar"), new LinkOption[0]);
                boolean bl2 = Files.notExists(SystemModulesLocationHandler.resolveInJavaHomeLib(path, "modules"), new LinkOption[0]);
                if (bl || bl2) {
                    throw new IllegalArgumentException(path.toString());
                }
            }
            this.systemJavaHome = path;
            this.modules = null;
        }

        private boolean isCurrentPlatform(Path path) {
            try {
                return Files.isSameFile(path, javaHome);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(path.toString(), iOException);
            }
        }

        private static Path resolveInJavaHomeLib(Path path, String string) {
            return path.resolve("lib").resolve(string);
        }

        @Override
        JavaFileManager.Location getLocationForModule(String string) throws IOException {
            this.initSystemModules();
            return this.moduleTable.get(string);
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path path) throws IOException {
            this.initSystemModules();
            return this.moduleTable.get(path);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            this.initSystemModules();
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path path) throws IOException {
            this.initSystemModules();
            return this.moduleTable.contains(path);
        }

        private void initSystemModules() throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            block16: {
                if (this.moduleTable != null) {
                    return;
                }
                if (this.systemJavaHome == null) {
                    this.moduleTable = new ModuleTable();
                    return;
                }
                if (this.modules == null) {
                    try {
                        object6 = URI.create("jrt:/");
                        if (this.isCurrentPlatform(this.systemJavaHome)) {
                            object5 = FileSystems.getFileSystem((URI)object6);
                        } else {
                            try {
                                object4 = Collections.singletonMap("java.home", this.systemJavaHome.toString());
                                object5 = FileSystems.newFileSystem((URI)object6, object4);
                            }
                            catch (ProviderNotFoundException providerNotFoundException) {
                                object3 = SystemModulesLocationHandler.resolveInJavaHomeLib(this.systemJavaHome, "jrt-fs.jar").toUri().toURL();
                                object2 = Locations.class.getClassLoader();
                                object = new URLClassLoader(new URL[]{object3}, (ClassLoader)object2);
                                object5 = FileSystems.newFileSystem((URI)object6, Collections.emptyMap(), (ClassLoader)object);
                                Locations.this.closeables.add((Closeable)object);
                            }
                            Locations.this.closeables.add((Closeable)object5);
                        }
                        this.modules = ((FileSystem)object5).getPath("/modules", new String[0]);
                    }
                    catch (FileSystemNotFoundException | ProviderNotFoundException runtimeException) {
                        this.modules = SystemModulesLocationHandler.resolveInJavaHomeLib(this.systemJavaHome, "modules");
                        if (Files.exists(this.modules, new LinkOption[0])) break block16;
                        throw new IOException("can't find system classes", runtimeException);
                    }
                }
            }
            this.moduleTable = new ModuleTable();
            object6 = Files.newDirectoryStream(this.modules, path -> Files.isDirectory(path, new LinkOption[0]));
            try {
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (Path)object5.next();
                    object3 = object4.getFileName().toString();
                    object2 = this.location.getName() + "[" + (String)object3 + "]";
                    object = new ModuleLocationHandler(this, (String)object2, (String)object3, Collections.singletonList(object4), false);
                    this.moduleTable.add((ModuleLocationHandler)object);
                }
            }
            finally {
                if (object6 != null) {
                    object6.close();
                }
            }
        }
    }

    private static abstract class BasicLocationHandler
    extends LocationHandler {
        final JavaFileManager.Location location;
        final Set<Option> options;
        boolean explicit;

        protected BasicLocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            this.location = location;
            this.options = optionArray.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(optionArray));
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) throws IOException {
            throw new UnsupportedOperationException("not supported for " + this.location);
        }

        protected Path checkSingletonDirectory(Iterable<? extends Path> iterable) throws IOException {
            Iterator<? extends Path> iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("empty path for directory");
            }
            Path path = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("path too long for directory");
            }
            this.checkDirectory(path);
            return path;
        }

        protected Path checkDirectory(Path path) throws IOException {
            Objects.requireNonNull(path);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new FileNotFoundException(path + ": does not exist");
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IOException(path + ": not a directory");
            }
            return path;
        }

        @Override
        boolean isExplicit() {
            return this.explicit;
        }
    }

    private class ClassPathLocationHandler
    extends SimpleLocationHandler {
        ClassPathLocationHandler() {
            super(StandardLocation.CLASS_PATH, Option.CLASS_PATH);
        }

        @Override
        Collection<Path> getPaths() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        protected SearchPath computePath(String string) {
            String string2 = string;
            if (string2 == null) {
                string2 = System.getProperty("env.class.path");
            }
            if (string2 == null && System.getProperty("application.home") == null) {
                string2 = System.getProperty("java.class.path");
            }
            if (string2 == null) {
                string2 = ".";
            }
            return this.createPath().addFiles(string2);
        }

        @Override
        protected SearchPath createPath() {
            return new SearchPath().expandJarClassPaths(true).emptyPathDefault(Locations.this.getPath(".", new String[0]));
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.setPaths(null);
            }
        }
    }

    private class SimpleLocationHandler
    extends BasicLocationHandler {
        protected Collection<Path> searchPath;

        SimpleLocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            super(location, optionArray);
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            this.searchPath = string == null ? null : Collections.unmodifiableCollection(this.createPath().addFiles(string));
            return true;
        }

        @Override
        Collection<Path> getPaths() {
            return this.searchPath;
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) {
            SearchPath searchPath;
            if (iterable == null) {
                searchPath = this.computePath(null);
            } else {
                this.explicit = true;
                searchPath = this.createPath().addFiles(iterable);
            }
            this.searchPath = Collections.unmodifiableCollection(searchPath);
        }

        protected SearchPath computePath(String string) {
            return this.createPath().addFiles(string);
        }

        protected SearchPath createPath() {
            return new SearchPath();
        }

        @Override
        boolean contains(Path path) throws IOException {
            return Locations.this.contains(this.searchPath, path);
        }
    }

    private class OutputLocationHandler
    extends BasicLocationHandler {
        private Path outputDir;
        private ModuleTable moduleTable;
        private boolean listed;

        OutputLocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            super(location, optionArray);
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            this.outputDir = string == null ? null : Locations.this.getPath(string, new String[0]);
            return true;
        }

        @Override
        Collection<Path> getPaths() {
            return this.outputDir == null ? null : Collections.singleton(this.outputDir);
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) throws IOException {
            if (iterable == null) {
                this.outputDir = null;
            } else {
                this.explicit = true;
                this.outputDir = this.checkSingletonDirectory(iterable);
            }
            this.moduleTable = null;
            this.listed = false;
        }

        @Override
        JavaFileManager.Location getLocationForModule(String string) {
            ModuleLocationHandler moduleLocationHandler;
            if (this.moduleTable == null) {
                this.moduleTable = new ModuleTable();
            }
            if ((moduleLocationHandler = this.moduleTable.get(string)) == null) {
                Path path = this.outputDir.resolve(string);
                moduleLocationHandler = new ModuleLocationHandler(this, this.location.getName() + "[" + string + "]", string, Collections.singletonList(path), true);
                this.moduleTable.add(moduleLocationHandler);
            }
            return moduleLocationHandler;
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) throws IOException {
            ModuleLocationHandler moduleLocationHandler;
            Path path = this.checkSingletonDirectory(iterable);
            if (this.moduleTable == null) {
                this.moduleTable = new ModuleTable();
            }
            if ((moduleLocationHandler = this.moduleTable.get(string)) == null) {
                moduleLocationHandler = new ModuleLocationHandler(this, this.location.getName() + "[" + string + "]", string, Collections.singletonList(path), true);
                this.moduleTable.add(moduleLocationHandler);
            } else {
                moduleLocationHandler.searchPath = Collections.singletonList(path);
                this.moduleTable.updatePaths(moduleLocationHandler);
            }
            this.explicit = true;
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path path) {
            return this.moduleTable == null ? null : this.moduleTable.get(path);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            if (!this.listed && this.outputDir != null) {
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.outputDir);){
                    for (Path path : directoryStream) {
                        this.getLocationForModule(path.getFileName().toString());
                    }
                }
                this.listed = true;
            }
            if (this.moduleTable == null || this.moduleTable.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path path) throws IOException {
            if (this.moduleTable != null) {
                return this.moduleTable.contains(path);
            }
            return this.outputDir != null && Locations.normalize(path).startsWith(Locations.normalize(this.outputDir));
        }
    }

    private class ModuleSourcePathLocationHandler
    extends BasicLocationHandler {
        private ModuleTable moduleTable;
        private List<Path> paths;
        private final Predicate<Path> checkModuleInfo;

        ModuleSourcePathLocationHandler() {
            super(StandardLocation.MODULE_SOURCE_PATH, Option.MODULE_SOURCE_PATH);
            this.checkModuleInfo = path -> Files.exists(path.resolve("module-info.java"), new LinkOption[0]);
        }

        @Override
        boolean handleOption(Option option, String string) {
            this.explicit = true;
            this.init(string);
            return true;
        }

        void init(String string) {
            Pattern pattern = Pattern.compile("([\\p{Alnum}$_.]+)=(.*)");
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = null;
            for (String string3 : string.split("\u0000")) {
                if (pattern.matcher(string3).matches()) {
                    arrayList.add(string3);
                    continue;
                }
                string2 = string3;
            }
            if (string2 != null) {
                this.initFromPattern(string2);
            }
            arrayList.forEach(this::initForModule);
        }

        void initForModule(String string) {
            int n = string.indexOf(61);
            String string2 = string.substring(0, n);
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (String string3 : string.substring(n + 1).split(File.pathSeparator)) {
                try {
                    arrayList.add(Paths.get(string3, new String[0]));
                }
                catch (InvalidPathException invalidPathException) {
                    throw new IllegalArgumentException("invalid path: " + string3, invalidPathException);
                }
            }
            try {
                this.setPathsForModule(string2, arrayList);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IllegalArgumentException("cannot set path for module " + string2, iOException);
            }
        }

        void initFromPattern(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : string.split(File.pathSeparator)) {
                this.expandBraces(string2, arrayList);
            }
            LinkedHashMap<String, List<Path>> linkedHashMap = new LinkedHashMap<String, List<Path>>();
            ArrayList<Path> arrayList2 = new ArrayList<Path>();
            int n = 0;
            for (String string3 : arrayList) {
                Path path;
                Path path2;
                int n2 = string3.indexOf("*");
                if (n2 == -1) {
                    path2 = Locations.this.getPath(string3, new String[0]);
                    this.add(linkedHashMap, path2, null);
                    arrayList2.add(path2);
                    continue;
                }
                if (n2 == 0 || !this.isSeparator(string3.charAt(n2 - 1))) {
                    throw new IllegalArgumentException("illegal use of * in " + string3);
                }
                path2 = Locations.this.getPath(string3.substring(0, n2 - 1), new String[0]);
                int n3 = n2 + "*".length();
                if (n3 == string3.length()) {
                    path = null;
                } else {
                    if (!this.isSeparator(string3.charAt(n3)) || string3.indexOf("*", n3) != -1) {
                        throw new IllegalArgumentException("illegal use of * in " + string3);
                    }
                    path = Locations.this.getPath(string3.substring(n3 + 1), new String[0]);
                    n = 1;
                }
                this.add(linkedHashMap, path2, path);
                if (path != null) continue;
                arrayList2.add(path2);
            }
            this.initModuleTable(linkedHashMap);
            this.paths = n != 0 ? null : arrayList2;
        }

        private void initModuleTable(Map<String, List<Path>> map) {
            this.moduleTable = new ModuleTable();
            map.forEach((string, list) -> {
                boolean bl = list.stream().anyMatch(this.checkModuleInfo);
                if (bl) {
                    String string2 = this.location.getName() + "[" + string + "]";
                    ModuleLocationHandler moduleLocationHandler = new ModuleLocationHandler(this, string2, (String)string, (Collection<Path>)list, false);
                    this.moduleTable.add(moduleLocationHandler);
                }
            });
        }

        private boolean isSeparator(char c) {
            return c == File.separatorChar || c == '/';
        }

        void add(Map<String, List<Path>> map, Path path2, Path path3) {
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                Locations.this.lint.logIfEnabled(Files.exists(path2, new LinkOption[0]) ? CompilerProperties.LintWarnings.DirPathElementNotDirectory(path2) : CompilerProperties.LintWarnings.DirPathElementNotFound(path2));
                return;
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, path -> Files.isDirectory(path, new LinkOption[0]));){
                for (Path path4 : directoryStream) {
                    Path path5 = path3 == null ? path4 : path4.resolve(path3);
                    if (!Files.isDirectory(path5, new LinkOption[0])) continue;
                    String string = path4.getFileName().toString();
                    List<Path> list = map.get(string);
                    if (list == null) {
                        list = new ArrayList<Path>();
                        map.put(string, list);
                    }
                    list.add(path5);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }

        private void expandBraces(String string, Collection<String> collection) {
            int n = 0;
            int n2 = -1;
            String string2 = null;
            String string3 = null;
            block9: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '{': {
                        if (++n != 1) continue block9;
                        string2 = string.substring(0, i);
                        string3 = string.substring(this.getMatchingBrace(string, i) + 1);
                        n2 = i + 1;
                        continue block9;
                    }
                    case ',': {
                        if (n != 1) continue block9;
                        String string4 = string.substring(n2, i);
                        this.expandBraces(string2 + string4 + string3, collection);
                        n2 = i + 1;
                        continue block9;
                    }
                    case '}': {
                        String string4;
                        switch (n) {
                            case 0: {
                                throw new IllegalArgumentException("mismatched braces");
                            }
                            case 1: {
                                string4 = string.substring(n2, i);
                                this.expandBraces(string2 + string4 + string3, collection);
                                return;
                            }
                        }
                        --n;
                    }
                }
            }
            if (n > 0) {
                throw new IllegalArgumentException("mismatched braces");
            }
            collection.add(string);
        }

        int getMatchingBrace(String string, int n) {
            int n2 = 1;
            block4: for (int i = n + 1; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '{': {
                        ++n2;
                        continue block4;
                    }
                    case '}': {
                        if (--n2 != 0) continue block4;
                        return i;
                    }
                }
            }
            throw new IllegalArgumentException("mismatched braces");
        }

        @Override
        boolean isSet() {
            return this.moduleTable != null;
        }

        @Override
        Collection<Path> getPaths() {
            if (this.paths == null) {
                throw new IllegalStateException("paths not available");
            }
            return this.paths;
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) throws IOException {
            LinkedHashMap<String, List<Path>> linkedHashMap = new LinkedHashMap<String, List<Path>>();
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : iterable) {
                this.add(linkedHashMap, path, null);
                arrayList.add(path);
            }
            this.initModuleTable(linkedHashMap);
            this.explicit = true;
            this.paths = Collections.unmodifiableList(arrayList);
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) throws IOException {
            ModuleLocationHandler moduleLocationHandler;
            List<Path> list = this.checkPaths(iterable);
            if (this.moduleTable == null) {
                this.moduleTable = new ModuleTable();
            }
            if ((moduleLocationHandler = this.moduleTable.get(string)) == null) {
                moduleLocationHandler = new ModuleLocationHandler(this, this.location.getName() + "[" + string + "]", string, list, true);
                this.moduleTable.add(moduleLocationHandler);
            } else {
                moduleLocationHandler.searchPath = list;
                this.moduleTable.updatePaths(moduleLocationHandler);
            }
            this.explicit = true;
        }

        private List<Path> checkPaths(Iterable<? extends Path> iterable) throws IOException {
            Objects.requireNonNull(iterable);
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : iterable) {
                arrayList.add(this.checkDirectory(path));
            }
            return arrayList;
        }

        @Override
        JavaFileManager.Location getLocationForModule(String string) {
            return this.moduleTable == null ? null : this.moduleTable.get(string);
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path path) {
            return this.moduleTable == null ? null : this.moduleTable.get(path);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() {
            if (this.moduleTable == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path path) throws IOException {
            return this.moduleTable == null ? false : this.moduleTable.contains(path);
        }
    }

    private class PatchModulesLocationHandler
    extends BasicLocationHandler {
        private final ModuleTable moduleTable;

        PatchModulesLocationHandler() {
            super(StandardLocation.PATCH_MODULE_PATH, Option.PATCH_MODULE);
            this.moduleTable = new ModuleTable();
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.explicit = true;
            this.moduleTable.clear();
            for (String string2 : string.split("\u0000")) {
                int n = string2.indexOf(61);
                if (n > 0) {
                    String string3 = string2.substring(0, n);
                    SearchPath searchPath = new SearchPath().addFiles(string2.substring(n + 1));
                    String string4 = this.location.getName() + "[" + string3 + "]";
                    ModuleLocationHandler moduleLocationHandler = new ModuleLocationHandler(this, string4, string3, searchPath, false);
                    this.moduleTable.add(moduleLocationHandler);
                    continue;
                }
                Locations.this.log.error(CompilerProperties.Errors.LocnInvalidArgForXpatch(string));
            }
            return true;
        }

        @Override
        boolean isSet() {
            return !this.moduleTable.isEmpty();
        }

        @Override
        Collection<Path> getPaths() {
            throw new UnsupportedOperationException();
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        JavaFileManager.Location getLocationForModule(String string) throws IOException {
            return this.moduleTable.get(string);
        }

        @Override
        JavaFileManager.Location getLocationForModule(Path path) throws IOException {
            return this.moduleTable.get(path);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() throws IOException {
            return Collections.singleton(this.moduleTable.locations());
        }

        @Override
        boolean contains(Path path) throws IOException {
            return this.moduleTable.contains(path);
        }
    }

    private class ModulePathLocationHandler
    extends SimpleLocationHandler {
        private ModuleTable moduleTable;

        ModulePathLocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            super(location, optionArray);
        }

        @Override
        public boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.setPaths(string == null ? null : Locations.this.getPathEntries(string));
            return true;
        }

        @Override
        public JavaFileManager.Location getLocationForModule(String string) {
            this.initModuleLocations();
            return this.moduleTable.get(string);
        }

        @Override
        public JavaFileManager.Location getLocationForModule(Path path) {
            this.initModuleLocations();
            return this.moduleTable.get(path);
        }

        @Override
        Iterable<Set<JavaFileManager.Location>> listLocationsForModules() {
            List<Set<JavaFileManager.Location>> list;
            Set set = this.moduleTable != null ? this.moduleTable.explicitLocations() : Collections.emptySet();
            List<Object> list2 = list = !set.isEmpty() ? Collections.singletonList(set) : Collections.emptyList();
            if (this.searchPath == null) {
                return list;
            }
            Iterable iterable = () -> new ModulePathIterator();
            return () -> Iterators.createCompoundIterator(Arrays.asList(list, iterable), Iterable::iterator);
        }

        @Override
        boolean contains(Path path) throws IOException {
            if (this.moduleTable == null) {
                this.initModuleLocations();
            }
            return this.moduleTable.contains(path);
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) {
            if (iterable != null) {
                for (Path path : iterable) {
                    this.checkValidModulePathEntry(path);
                }
            }
            super.setPaths(iterable);
            this.moduleTable = null;
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) throws IOException {
            List<Path> list = this.checkPaths(iterable);
            this.initModuleLocations();
            ModuleLocationHandler moduleLocationHandler = this.moduleTable.get(string);
            if (moduleLocationHandler == null) {
                moduleLocationHandler = new ModuleLocationHandler(this, this.location.getName() + "[" + string + "]", string, list, true);
                this.moduleTable.add(moduleLocationHandler);
            } else {
                moduleLocationHandler.searchPath = list;
                this.moduleTable.updatePaths(moduleLocationHandler);
            }
            moduleLocationHandler.explicit = true;
            this.explicit = true;
        }

        private List<Path> checkPaths(Iterable<? extends Path> iterable) throws IOException {
            Objects.requireNonNull(iterable);
            ArrayList<Path> arrayList = new ArrayList<Path>();
            for (Path path : iterable) {
                arrayList.add(this.checkDirectory(path));
            }
            return arrayList;
        }

        private void initModuleLocations() {
            if (this.moduleTable != null) {
                return;
            }
            this.moduleTable = new ModuleTable();
            for (Set<JavaFileManager.Location> set : this.listLocationsForModules()) {
                for (JavaFileManager.Location location : set) {
                    if (!(location instanceof ModuleLocationHandler)) continue;
                    ModuleLocationHandler moduleLocationHandler = (ModuleLocationHandler)location;
                    if (this.moduleTable.nameMap.containsKey(moduleLocationHandler.moduleName)) continue;
                    this.moduleTable.add(moduleLocationHandler);
                }
            }
        }

        private void checkValidModulePathEntry(Path path) {
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                return;
            }
            String string = path.getFileName().toString();
            int n = string.lastIndexOf(".");
            if (n > 0) {
                switch (string.substring(n)) {
                    case ".jar": 
                    case ".jmod": {
                        return;
                    }
                }
            }
            throw new IllegalArgumentException(path.toString());
        }

        private boolean isModuleName(String string) {
            String string2;
            int n;
            int n2 = 0;
            while ((n = string.indexOf(46, n2)) != -1) {
                string2 = string.substring(n2, n);
                if (!SourceVersion.isName(string2)) {
                    return false;
                }
                n2 = n + 1;
            }
            string2 = string.substring(n2);
            return SourceVersion.isName(string2);
        }

        class ModulePathIterator
        implements Iterator<Set<JavaFileManager.Location>> {
            Iterator<Path> pathIter;
            int pathIndex;
            Set<JavaFileManager.Location> next;

            ModulePathIterator() {
                this.pathIter = ModulePathLocationHandler.this.searchPath.iterator();
                this.pathIndex = 0;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.next == null) {
                    if (this.pathIter.hasNext()) {
                        Path path = this.pathIter.next();
                        this.next = Files.isDirectory(path, new LinkOption[0]) ? this.scanDirectory(path) : this.scanFile(path);
                        ++this.pathIndex;
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Set<JavaFileManager.Location> next() {
                this.hasNext();
                if (this.next != null) {
                    Set<JavaFileManager.Location> set = this.next;
                    this.next = null;
                    return set;
                }
                throw new NoSuchElementException();
            }

            private Set<JavaFileManager.Location> scanDirectory(Path path) {
                Object object;
                Object object2;
                Object object3;
                LinkedHashSet<Path> linkedHashSet = new LinkedHashSet<Path>();
                Path path2 = null;
                try {
                    object3 = Files.newDirectoryStream(path);
                    try {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = object2.next();
                            if (object.endsWith("module-info.class")) {
                                path2 = object;
                                break;
                            }
                            linkedHashSet.add((Path)object);
                        }
                    }
                    finally {
                        if (object3 != null) {
                            object3.close();
                        }
                    }
                }
                catch (IOException | DirectoryIteratorException exception) {
                    Locations.this.log.error(CompilerProperties.Errors.LocnCantReadDirectory(path));
                    return Collections.emptySet();
                }
                if (path2 != null) {
                    try {
                        object3 = this.readModuleName(path2);
                        object2 = ModulePathLocationHandler.this.location.getName() + "[" + this.pathIndex + ":" + (String)object3 + "]";
                        object = new ModuleLocationHandler(ModulePathLocationHandler.this, (String)object2, (String)object3, Collections.singletonList(path), false);
                        return Collections.singleton(object);
                    }
                    catch (ModuleNameReader.BadClassFile badClassFile) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnBadModuleInfo(path));
                        return Collections.emptySet();
                    }
                    catch (IOException iOException) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(path));
                        return Collections.emptySet();
                    }
                }
                object3 = new LinkedHashSet();
                int n = 0;
                for (Path path3 : linkedHashSet) {
                    Pair<String, Path> pair = this.inferModuleName(path3);
                    if (pair == null) continue;
                    String string = (String)pair.fst;
                    Path path4 = (Path)pair.snd;
                    String string2 = ModulePathLocationHandler.this.location.getName() + "[" + this.pathIndex + "." + n++ + ":" + string + "]";
                    ModuleLocationHandler moduleLocationHandler = new ModuleLocationHandler(ModulePathLocationHandler.this, string2, string, Collections.singletonList(path4), false);
                    object3.add(moduleLocationHandler);
                }
                return object3;
            }

            private Set<JavaFileManager.Location> scanFile(Path path) {
                Pair<String, Path> pair = this.inferModuleName(path);
                if (pair == null) {
                    return Collections.emptySet();
                }
                String string = (String)pair.fst;
                Path path2 = (Path)pair.snd;
                String string2 = ModulePathLocationHandler.this.location.getName() + "[" + this.pathIndex + ":" + string + "]";
                ModuleLocationHandler moduleLocationHandler = new ModuleLocationHandler(ModulePathLocationHandler.this, string2, string, Collections.singletonList(path2), false);
                return Collections.singleton(moduleLocationHandler);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Pair<String, Path> inferModuleName(Path path) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    String string;
                    if (!Files.exists(path.resolve("module-info.class"), new LinkOption[0])) {
                        if (!Files.exists(path.resolve("module-info.sig"), new LinkOption[0])) return null;
                    }
                    if (!SourceVersion.isName(string = path.getFileName().toString())) return null;
                    return new Pair<String, Path>(string, path);
                }
                if (path.getFileName().toString().endsWith(".jar") && Locations.this.fsInfo.exists(path)) {
                    Object object;
                    Object object2;
                    Object object3;
                    block36: {
                        FileSystemProvider fileSystemProvider = Locations.this.fsInfo.getJarFSProvider();
                        if (fileSystemProvider == null) {
                            Locations.this.log.error(CompilerProperties.Errors.NoZipfsForArchive(path));
                            return null;
                        }
                        try {
                            object3 = fileSystemProvider.newFileSystem(path, Locations.this.fsEnv);
                            try {
                                object2 = ((FileSystem)object3).getPath("module-info.class", new String[0]);
                                if (Files.exists((Path)object2, new LinkOption[0])) {
                                    String string = this.readModuleName((Path)object2);
                                    Pair<String, Path> pair = new Pair<String, Path>(string, path);
                                    return pair;
                                }
                                object = ((FileSystem)object3).getPath("META-INF/MANIFEST.MF", new String[0]);
                                if (!Files.exists((Path)object, new LinkOption[0])) break block36;
                                try (InputStream inputStream = Files.newInputStream((Path)object, new OpenOption[0]);){
                                    String string;
                                    Manifest manifest = new Manifest(inputStream);
                                    Attributes attributes = manifest.getMainAttributes();
                                    if (attributes != null && (string = attributes.getValue(new Attributes.Name("Automatic-Module-Name"))) != null) {
                                        if (ModulePathLocationHandler.this.isModuleName(string)) {
                                            Pair<String, Path> pair = new Pair<String, Path>(string, path);
                                            return pair;
                                        }
                                        Locations.this.log.error(CompilerProperties.Errors.LocnCantGetModuleNameForJar(path));
                                        Pair<String, Path> pair = null;
                                        return pair;
                                    }
                                }
                            }
                            finally {
                                if (object3 != null) {
                                    ((FileSystem)object3).close();
                                }
                            }
                        }
                        catch (ModuleNameReader.BadClassFile badClassFile) {
                            Locations.this.log.error(CompilerProperties.Errors.LocnBadModuleInfo(path));
                            return null;
                        }
                        catch (IOException iOException) {
                            Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(path));
                            return null;
                        }
                    }
                    object3 = path.getFileName().toString();
                    object2 = ((String)object3).substring(0, ((String)object3).length() - 4);
                    object = Pattern.compile("-(\\d+(\\.|$))").matcher((CharSequence)object2);
                    if (((Matcher)object).find()) {
                        int n = ((Matcher)object).start();
                        object2 = ((String)object2).substring(0, n);
                    }
                    if (((String)(object2 = ((String)object2).replaceAll("[^A-Za-z0-9]", ".").replaceAll("(\\.)(\\1)+", ".").replaceAll("^\\.", "").replaceAll("\\.$", ""))).length() != 0) {
                        return new Pair<Object, Path>(object2, path);
                    }
                    Locations.this.log.error(CompilerProperties.Errors.LocnCantGetModuleNameForJar(path));
                    return null;
                }
                if (!path.getFileName().toString().endsWith(".jmod")) return null;
                try {
                    JmodFileWrapper.checkMagic(path);
                    FileSystem fileSystem = Locations.this.fileSystems.get(path);
                    if (fileSystem != null) return null;
                    FileSystemProvider fileSystemProvider = Locations.this.fsInfo.getJarFSProvider();
                    if (fileSystemProvider == null) {
                        Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(path));
                        return null;
                    }
                    fileSystem = fileSystemProvider.newFileSystem(path, Collections.emptyMap());
                    try {
                        Path path2 = fileSystem.getPath("classes/module-info.class", new String[0]);
                        String string = this.readModuleName(path2);
                        Path path3 = fileSystem.getPath("classes", new String[0]);
                        Locations.this.fileSystems.put(path, fileSystem);
                        Locations.this.closeables.add(fileSystem);
                        fileSystem = null;
                        Pair<String, Path> pair = new Pair<String, Path>(string, path3);
                        return pair;
                    }
                    finally {
                        if (fileSystem != null) {
                            fileSystem.close();
                        }
                    }
                }
                catch (ModuleNameReader.BadClassFile badClassFile) {
                    Locations.this.log.error(CompilerProperties.Errors.LocnBadModuleInfo(path));
                    return null;
                }
                catch (IOException iOException) {
                    Locations.this.log.error(CompilerProperties.Errors.LocnCantReadFile(path));
                    return null;
                }
            }

            private String readModuleName(Path path) throws IOException, ModuleNameReader.BadClassFile {
                if (Locations.this.moduleNameReader == null) {
                    Locations.this.moduleNameReader = new ModuleNameReader();
                }
                return Locations.this.moduleNameReader.readModuleName(path);
            }
        }
    }

    private class ModuleTable {
        private final Map<String, ModuleLocationHandler> nameMap = new LinkedHashMap<String, ModuleLocationHandler>();
        private final Map<Path, ModuleLocationHandler> pathMap = new LinkedHashMap<Path, ModuleLocationHandler>();

        private ModuleTable() {
        }

        void add(ModuleLocationHandler moduleLocationHandler) {
            this.nameMap.put(moduleLocationHandler.moduleName, moduleLocationHandler);
            for (Path path : moduleLocationHandler.searchPath) {
                this.pathMap.put(Locations.normalize(path), moduleLocationHandler);
            }
        }

        void updatePaths(ModuleLocationHandler moduleLocationHandler) {
            Iterator<Object> iterator = this.pathMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Path, ModuleLocationHandler> entry = iterator.next();
                if (entry.getValue() != moduleLocationHandler) continue;
                iterator.remove();
            }
            for (Path path : moduleLocationHandler.searchPath) {
                this.pathMap.put(Locations.normalize(path), moduleLocationHandler);
            }
        }

        ModuleLocationHandler get(String string) {
            return this.nameMap.get(string);
        }

        ModuleLocationHandler get(Path path) {
            while (path != null) {
                ModuleLocationHandler moduleLocationHandler = this.pathMap.get(path);
                if (moduleLocationHandler != null) {
                    return moduleLocationHandler;
                }
                path = path.getParent();
            }
            return null;
        }

        void clear() {
            this.nameMap.clear();
            this.pathMap.clear();
        }

        boolean isEmpty() {
            return this.nameMap.isEmpty();
        }

        boolean contains(Path path) throws IOException {
            return Locations.this.contains(this.pathMap.keySet(), path);
        }

        Set<JavaFileManager.Location> locations() {
            return Collections.unmodifiableSet(this.nameMap.values().stream().collect(Collectors.toSet()));
        }

        Set<JavaFileManager.Location> explicitLocations() {
            return Collections.unmodifiableSet(this.nameMap.entrySet().stream().filter(entry -> ((ModuleLocationHandler)entry.getValue()).explicit).map(entry -> (ModuleLocationHandler)entry.getValue()).collect(Collectors.toSet()));
        }
    }

    private class ModuleLocationHandler
    extends LocationHandler
    implements JavaFileManager.Location {
        private final LocationHandler parent;
        private final String name;
        private final String moduleName;
        private final boolean output;
        boolean explicit;
        Collection<Path> searchPath;

        ModuleLocationHandler(LocationHandler locationHandler, String string, String string2, Collection<Path> collection, boolean bl) {
            this.parent = locationHandler;
            this.name = string;
            this.moduleName = string2;
            this.searchPath = collection;
            this.output = bl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isOutputLocation() {
            return this.output;
        }

        @Override
        boolean handleOption(Option option, String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        Collection<Path> getPaths() {
            return Collections.unmodifiableCollection(this.searchPath);
        }

        @Override
        boolean isExplicit() {
            return true;
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) throws IOException {
            this.parent.setPathsForModule(this.moduleName, iterable);
        }

        @Override
        void setPathsForModule(String string, Iterable<? extends Path> iterable) {
            throw new UnsupportedOperationException("not supported for " + this.name);
        }

        @Override
        String inferModuleName() {
            return this.moduleName;
        }

        @Override
        boolean contains(Path path) throws IOException {
            return Locations.this.contains(this.searchPath, path);
        }

        public String toString() {
            return this.name;
        }
    }

    private class SearchPath
    extends LinkedHashSet<Path> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private final transient Set<Path> canonicalValues = new HashSet<Path>();
        private transient Path emptyPathDefault = null;

        private SearchPath() {
        }

        public SearchPath expandJarClassPaths(boolean bl) {
            this.expandJarClassPaths = bl;
            return this;
        }

        public SearchPath emptyPathDefault(Path path) {
            this.emptyPathDefault = path;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SearchPath addDirectories(String string, boolean bl) {
            boolean bl2 = this.expandJarClassPaths;
            this.expandJarClassPaths = true;
            try {
                if (string != null) {
                    for (Path path : Locations.this.getPathEntries(string)) {
                        this.addDirectory(path, bl);
                    }
                }
                SearchPath searchPath = this;
                return searchPath;
            }
            finally {
                this.expandJarClassPaths = bl2;
            }
        }

        public SearchPath addDirectories(String string) {
            return this.addDirectories(string, true);
        }

        private void addDirectory(Path path2, boolean bl) {
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                if (bl) {
                    Locations.this.lint.logIfEnabled(CompilerProperties.LintWarnings.DirPathElementNotFound(path2));
                }
                return;
            }
            try (Stream<Path> stream = Files.list(path2);){
                stream.filter(path -> Locations.this.isArchive(path)).forEach(path -> this.addFile((Path)path, bl));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SearchPath addFiles(String string, boolean bl) {
            if (string != null) {
                this.addFiles(Locations.this.getPathEntries(string, this.emptyPathDefault), bl);
            }
            return this;
        }

        public SearchPath addFiles(String string) {
            return this.addFiles(string, true);
        }

        public SearchPath addFiles(Iterable<? extends Path> iterable, boolean bl) {
            if (iterable != null) {
                for (Path path : iterable) {
                    this.addFile(path, bl);
                }
            }
            return this;
        }

        public SearchPath addFiles(Iterable<? extends Path> iterable) {
            return this.addFiles(iterable, true);
        }

        /*
         * Unable to fully structure code
         */
        public void addFile(Path var1_1, boolean var2_2) {
            if (this.contains(var1_1)) {
                return;
            }
            if (!Locations.access$300(Locations.this).exists(var1_1)) {
                if (var2_2) {
                    Locations.access$100(Locations.this).logIfEnabled(CompilerProperties.LintWarnings.PathElementNotFound(var1_1));
                }
                super.add(var1_1);
                return;
            }
            var3_3 = Locations.access$300(Locations.this).getCanonicalFile(var1_1);
            if (this.canonicalValues.contains(var3_3)) {
                return;
            }
            if (Locations.access$300(Locations.this).isFile(var1_1) && !var1_1.getFileName().toString().endsWith(".jmod") && !var1_1.endsWith("modules")) {
                if (!Locations.access$400(Locations.this, var1_1)) {
                    try {
                        FileSystems.newFileSystem(var1_1, (ClassLoader)null).close();
                        if (!var2_2) ** GOTO lbl26
                        Locations.access$100(Locations.this).logIfEnabled(CompilerProperties.LintWarnings.UnexpectedArchiveFile(var1_1));
                    }
                    catch (IOException | ProviderNotFoundException var4_4) {
                        if (var2_2) {
                            Locations.access$100(Locations.this).logIfEnabled(CompilerProperties.LintWarnings.InvalidArchiveFile(var1_1));
                        }
                        return;
                    }
                } else if (Locations.access$300(Locations.this).getJarFSProvider() == null) {
                    Locations.access$500(Locations.this).error(CompilerProperties.Errors.NoZipfsForArchive(var1_1));
                    return;
                }
            }
lbl26:
            // 6 sources

            super.add(var1_1);
            this.canonicalValues.add(var3_3);
            if (this.expandJarClassPaths && Locations.access$300(Locations.this).isFile(var1_1) && !var1_1.endsWith("modules")) {
                this.addJarClassPath(var1_1, var2_2);
            }
        }

        private void addJarClassPath(Path path, boolean bl) {
            try {
                for (Path path2 : Locations.this.fsInfo.getJarClassPath(path)) {
                    this.addFile(path2, bl);
                }
            }
            catch (IOException iOException) {
                Locations.this.log.error(CompilerProperties.Errors.ErrorReadingFile(path, JavacFileManager.getMessage(iOException)));
            }
        }
    }
}

