/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class CacheFSInfo
extends FSInfo {
    protected final ConcurrentHashMap<Path, Path> canonicalPathCache = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Path, Optional<BasicFileAttributes>> attributeCache = new ConcurrentHashMap();
    protected final ConcurrentHashMap<Path, List<Path>> jarClassPathCache = new ConcurrentHashMap();

    public static void preRegister(Context context2) {
        context2.put(FSInfo.class, context -> {
            CacheFSInfo cacheFSInfo = new CacheFSInfo();
            context.put(FSInfo.class, cacheFSInfo);
            return cacheFSInfo;
        });
    }

    public void clearCache() {
        this.canonicalPathCache.clear();
        this.attributeCache.clear();
        this.jarClassPathCache.clear();
    }

    @Override
    public Path getCanonicalFile(Path path2) {
        return this.canonicalPathCache.computeIfAbsent(path2, path -> super.getCanonicalFile((Path)path));
    }

    @Override
    public boolean exists(Path path) {
        return this.getAttributes(path).isPresent();
    }

    @Override
    public boolean isDirectory(Path path) {
        return this.getAttributes(path).map(BasicFileAttributes::isDirectory).orElse(false);
    }

    @Override
    public boolean isFile(Path path) {
        return this.getAttributes(path).map(BasicFileAttributes::isRegularFile).orElse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> getJarClassPath(Path path) throws IOException {
        ConcurrentHashMap<Path, List<Path>> concurrentHashMap = this.jarClassPathCache;
        synchronized (concurrentHashMap) {
            List<Path> list = this.jarClassPathCache.get(path);
            if (list == null) {
                list = super.getJarClassPath(path);
                this.jarClassPathCache.put(path, list);
            }
            return list;
        }
    }

    protected Optional<BasicFileAttributes> getAttributes(Path path) {
        return this.attributeCache.computeIfAbsent(path, this::maybeReadAttributes);
    }

    protected Optional<BasicFileAttributes> maybeReadAttributes(Path path) {
        try {
            return Optional.of(Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }
}

