/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.Locations;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public abstract class BaseFileManager
implements JavaFileManager {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public Log log;
    protected Charset charset;
    protected Options options;
    protected Lint lint;
    protected final Locations locations;
    private final HashSet<Path> outputFilesWritten = new HashSet();
    public boolean autoClose;
    private long lastUsedTime = System.currentTimeMillis();
    protected long deferredCloseTimeout = 0L;
    protected static final Set<Option> javacFileManagerOptions = Option.getJavacFileManagerOptions();
    protected String multiReleaseValue;
    private String encodingName;
    private String defaultEncodingName;
    private byte[] byteArrayCache;
    protected final Map<JavaFileObject, ContentCacheEntry> contentCache = new HashMap<JavaFileObject, ContentCacheEntry>();

    protected BaseFileManager(Charset charset) {
        this.charset = charset;
        this.locations = this.createLocations();
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.options = Options.instance(context);
        this.locations.update(this.log, this.lint, FSInfo.instance(context));
        this.options.whenReady(this::applyOptions);
    }

    protected void applyOptions(Options options) {
        String string = options.get("fileManager.deferClose");
        if (string != null) {
            try {
                this.deferredCloseTimeout = (int)(Float.parseFloat(string) * 1000.0f);
            }
            catch (NumberFormatException numberFormatException) {
                this.deferredCloseTimeout = 60000L;
            }
        }
    }

    protected Locations createLocations() {
        return new Locations();
    }

    protected void deferredClose() {
        Thread thread = new Thread(this.getClass().getName() + " DeferredClose"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BaseFileManager baseFileManager = BaseFileManager.this;
                    synchronized (baseFileManager) {
                        long l = System.currentTimeMillis();
                        while (l < BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout) {
                            BaseFileManager.this.wait(BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout - l);
                            l = System.currentTimeMillis();
                        }
                        BaseFileManager.this.deferredCloseTimeout = 0L;
                        BaseFileManager.this.close();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    synchronized void updateLastUsedTime() {
        if (this.deferredCloseTimeout > 0L) {
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    public void clear() {
        new HashSet<String>(this.options.keySet()).forEach(string -> this.options.remove((String)string));
    }

    protected ClassLoader getClassLoader(URL[] uRLArray) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string = this.options.get("procloader");
        if (string != null) {
            try {
                Class<ClassLoader> clazz = Class.forName(string).asSubclass(ClassLoader.class);
                Class[] classArray = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constructor = clazz.getConstructor(classArray);
                return constructor.newInstance(uRLArray, classLoader);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new URLClassLoader(uRLArray, classLoader);
    }

    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    public boolean isDefaultSystemModulesPath() {
        return this.locations.isDefaultSystemModulesPath();
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        OptionHelper.GrumpyHelper grumpyHelper = new OptionHelper.GrumpyHelper(this.log){

            @Override
            public String get(Option option) {
                return BaseFileManager.this.options.get(option);
            }

            @Override
            public void put(String string, String string2) {
                BaseFileManager.this.options.put(string, string2);
            }

            @Override
            public void remove(String string) {
                BaseFileManager.this.options.remove(string);
            }

            @Override
            public boolean handleFileManagerOption(Option option, String string) {
                return BaseFileManager.this.handleOption(option, string);
            }

            @Override
            public void initialize() {
                BaseFileManager.this.options.initialize();
            }
        };
        Option option = Option.lookup(string, javacFileManagerOptions);
        if (option == null) {
            return false;
        }
        try {
            option.handleOption(grumpyHelper, string, iterator);
        }
        catch (Option.InvalidValueException invalidValueException) {
            throw new IllegalArgumentException(invalidValueException.getMessage(), invalidValueException);
        }
        return true;
    }

    @Override
    public int isSupportedOption(String string) {
        Option option = Option.lookup(string, javacFileManagerOptions);
        return option == null ? -1 : (option.hasArg() ? 1 : 0);
    }

    public boolean handleOption(Option option, String string) {
        switch (option) {
            case ENCODING: {
                this.encodingName = string;
                return true;
            }
            case MULTIRELEASE: {
                this.multiReleaseValue = string;
                this.locations.setMultiReleaseValue(string);
                return true;
            }
        }
        return this.locations.handleOption(option, string);
    }

    public boolean handleOptions(Map<Option, String> map) {
        boolean bl = true;
        for (Map.Entry<Option, String> entry : map.entrySet()) {
            try {
                bl &= this.handleOption(entry.getKey(), entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error(CompilerProperties.Errors.IllegalArgumentForOption(entry.getKey().getPrimaryName(), illegalArgumentException.getMessage()));
                bl = false;
            }
        }
        return bl;
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = Charset.defaultCharset().name();
        }
        return this.defaultEncodingName;
    }

    public String getEncodingName() {
        return this.encodingName != null ? this.encodingName : this.getDefaultEncodingName();
    }

    public CharBuffer decode(ByteBuffer byteBuffer, boolean bl) {
        CoderResult coderResult;
        CharsetDecoder charsetDecoder;
        String string = this.getEncodingName();
        try {
            charsetDecoder = this.getDecoder(string, bl);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            this.log.error(CompilerProperties.Errors.UnsupportedEncoding(string));
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float f = charsetDecoder.averageCharsPerByte() * 0.8f + charsetDecoder.maxCharsPerByte() * 0.2f;
        CharBuffer charBuffer = CharBuffer.allocate(10 + (int)((float)byteBuffer.remaining() * f));
        while (true) {
            coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            charBuffer.flip();
            if (coderResult.isUnderflow()) {
                if (charBuffer.limit() == charBuffer.capacity()) {
                    charBuffer = CharBuffer.allocate(charBuffer.capacity() + 1).put(charBuffer);
                    charBuffer.flip();
                }
                return charBuffer;
            }
            if (coderResult.isOverflow()) {
                int n = 10 + charBuffer.capacity() + (int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte());
                charBuffer = CharBuffer.allocate(n).put(charBuffer);
                continue;
            }
            if (!coderResult.isMalformed() && !coderResult.isUnmappable()) break;
            StringBuilder stringBuilder = new StringBuilder();
            int n = coderResult.length();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(String.format("%02X", byteBuffer.get()));
            }
            String string2 = this.charset == null ? string : this.charset.name();
            this.log.error(charBuffer.limit(), CompilerProperties.Errors.IllegalCharForEncoding(stringBuilder.toString(), string2));
            charBuffer.position(charBuffer.limit());
            charBuffer.limit(charBuffer.capacity());
            charBuffer.put('\ufffd');
        }
        throw new AssertionError(coderResult);
    }

    public CharsetDecoder getDecoder(String string, boolean bl) {
        Charset charset = this.charset == null ? Charset.forName(string) : this.charset;
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CodingErrorAction codingErrorAction = bl ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return charsetDecoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer makeByteBuffer(InputStream inputStream) throws IOException {
        byte[] byArray;
        Object object = this;
        synchronized (object) {
            byArray = this.byteArrayCache;
            if (this.byteArrayCache != null) {
                this.byteArrayCache = null;
            } else {
                byArray = EMPTY_ARRAY;
            }
        }
        object = new com.sun.tools.javac.util.ByteBuffer(byArray);
        ((com.sun.tools.javac.util.ByteBuffer)object).appendStream(inputStream);
        return ((com.sun.tools.javac.util.ByteBuffer)object).asByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            BaseFileManager baseFileManager = this;
            synchronized (baseFileManager) {
                this.byteArrayCache = byteBuffer.array();
            }
        }
    }

    public CharBuffer getCachedContent(JavaFileObject javaFileObject) {
        ContentCacheEntry contentCacheEntry = this.contentCache.get(javaFileObject);
        if (contentCacheEntry == null) {
            return null;
        }
        if (!contentCacheEntry.isValid(javaFileObject)) {
            this.contentCache.remove(javaFileObject);
            return null;
        }
        return contentCacheEntry.getValue();
    }

    public void cache(JavaFileObject javaFileObject, CharBuffer charBuffer) {
        this.contentCache.put(javaFileObject, new ContentCacheEntry(javaFileObject, charBuffer));
    }

    public void flushCache(JavaFileObject javaFileObject) {
        this.contentCache.remove(javaFileObject);
    }

    public synchronized void resetOutputFilesWritten() {
        this.outputFilesWritten.clear();
    }

    public static JavaFileObject.Kind getKind(Path path) {
        return BaseFileManager.getKind(path.getFileName().toString());
    }

    public static JavaFileObject.Kind getKind(String string) {
        if (string.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (string.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (string.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    protected static <T> T nullCheck(T t) {
        return Objects.requireNonNull(t);
    }

    protected static <T> Collection<T> nullCheck(Collection<T> collection) {
        for (T t : collection) {
            Objects.requireNonNull(t);
        }
        return collection;
    }

    synchronized void newOutputToPath(Path path) throws IOException {
        Path path2;
        if (!this.lint.isEnabled(Lint.LintCategory.OUTPUT_FILE_CLASH)) {
            return;
        }
        try {
            path2 = path.toRealPath(new LinkOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
            return;
        }
        if (!this.outputFilesWritten.add(path2)) {
            this.log.warning(CompilerProperties.LintWarnings.OutputFileClash(path));
        }
    }

    protected static class ContentCacheEntry {
        final long timestamp;
        final SoftReference<CharBuffer> ref;

        ContentCacheEntry(JavaFileObject javaFileObject, CharBuffer charBuffer) {
            this.timestamp = javaFileObject.getLastModified();
            this.ref = new SoftReference<CharBuffer>(charBuffer);
        }

        boolean isValid(JavaFileObject javaFileObject) {
            return this.timestamp == javaFileObject.getLastModified();
        }

        CharBuffer getValue() {
            return this.ref.get();
        }
    }
}

