/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TreeHasher
extends TreeScanner {
    private final Map<Symbol, Integer> symbolHashes;
    private final Types types;
    private int result = 17;

    public TreeHasher(Types types, Map<Symbol, Integer> map) {
        this.symbolHashes = Objects.requireNonNull(map);
        this.types = types;
    }

    public static int hash(Types types, JCTree jCTree, Collection<? extends Symbol> collection) {
        if (jCTree == null) {
            return 0;
        }
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        collection.forEach(symbol -> hashMap.put((Symbol)symbol, hashMap.size()));
        TreeHasher treeHasher = new TreeHasher(types, hashMap);
        jCTree.accept(treeHasher);
        return treeHasher.result;
    }

    private void hash(Object object) {
        this.result = 31 * this.result + Objects.hashCode(object);
    }

    @Override
    public void scan(JCTree jCTree) {
        Object object;
        if (jCTree == null) {
            return;
        }
        jCTree = TreeInfo.skipParens(jCTree);
        if (jCTree.type != null && (object = jCTree.type.constValue()) != null) {
            this.hash(object);
            return;
        }
        this.hash((Object)jCTree.getTag());
        jCTree.accept(this);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        this.hash(jCLiteral.value);
        super.visitLiteral(jCLiteral);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        this.hash(jCClassDecl.sym);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        Integer n;
        Symbol symbol = jCIdent.sym;
        if (symbol != null && (n = this.symbolHashes.get(symbol)) != null) {
            this.hash(n);
            return;
        }
        this.hashSymbol(symbol);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        this.hashSymbol(jCFieldAccess.sym);
        super.visitSelect(jCFieldAccess);
    }

    private void hashSymbol(Symbol symbol) {
        if (symbol instanceof PoolConstant.Dynamic) {
            PoolConstant.Dynamic dynamic = (PoolConstant.Dynamic)((Object)symbol);
            this.hash(dynamic.bsmKey(this.types));
        } else {
            this.hash(symbol);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        this.symbolHashes.computeIfAbsent(jCVariableDecl.sym, symbol -> this.symbolHashes.size());
        super.visitVarDef(jCVariableDecl);
    }
}

