/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ThisEscapeAnalyzer
extends TreeScanner {
    protected static final Context.Key<ThisEscapeAnalyzer> contextKey = new Context.Key();
    private final Names names;
    private final Symtab syms;
    private final Types types;
    private final Resolve rs;
    private final Log log;
    private Lint lint;
    private Env<AttrContext> topLevelEnv;
    private final Map<Symbol, MethodInfo> methodMap = new LinkedHashMap<Symbol, MethodInfo>();
    private final Set<Symbol> suppressed = new HashSet<Symbol>();
    private final Set<Symbol.ClassSymbol> nonPublicOuters = new HashSet<Symbol.ClassSymbol>();
    private JCTree.JCClassDecl targetClass;
    private final ArrayList<Warning> warningList = new ArrayList();
    private MethodInfo currentMethod;
    private final ArrayList<StackFrame> callStack = new ArrayList();
    private final Set<Pair<JCTree.JCMethodDecl, RefSet<Ref>>> invocations = new HashSet<Pair<JCTree.JCMethodDecl, RefSet<Ref>>>();
    private int depth = -1;
    private RefSet<Ref> refs;

    public static ThisEscapeAnalyzer instance(Context context) {
        ThisEscapeAnalyzer thisEscapeAnalyzer = context.get(contextKey);
        if (thisEscapeAnalyzer == null) {
            thisEscapeAnalyzer = new ThisEscapeAnalyzer(context);
        }
        return thisEscapeAnalyzer;
    }

    protected ThisEscapeAnalyzer(Context context) {
        context.put(contextKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.rs = Resolve.instance(context);
        this.lint = Lint.instance(context);
    }

    public void analyzeTree(Env<AttrContext> env) {
        this.topLevelEnv = env;
        try {
            this.doAnalyzeTree(env);
        }
        finally {
            this.topLevelEnv = null;
            this.methodMap.clear();
            this.nonPublicOuters.clear();
            this.targetClass = null;
            this.warningList.clear();
            this.currentMethod = null;
            this.callStack.clear();
            this.invocations.clear();
            this.depth = -1;
            this.refs = null;
        }
    }

    private void doAnalyzeTree(Env<AttrContext> env) {
        Assert.check(this.checkInvariants(false, false));
        Assert.check(this.methodMap.isEmpty());
        if (!this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
            return;
        }
        final Set set = Optional.ofNullable(env.toplevel.modle).filter(moduleSymbol -> moduleSymbol != this.syms.noModule).filter(moduleSymbol -> moduleSymbol != this.syms.unnamedModule).map(moduleSymbol -> moduleSymbol.exports.stream().map(Directive.ExportsDirective::getPackage).collect(Collectors.toSet())).orElse(null);
        new TreeScanner(){
            private Lint lint;
            private JCTree.JCClassDecl currentClass;
            private boolean nonPublicOuter;
            {
                this.lint = ThisEscapeAnalyzer.this.lint;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                JCTree.JCClassDecl jCClassDecl2 = this.currentClass;
                boolean bl = this.nonPublicOuter;
                Lint lint = this.lint;
                this.lint = this.lint.augment(jCClassDecl.sym);
                try {
                    this.currentClass = jCClassDecl;
                    this.nonPublicOuter |= jCClassDecl.sym.isAnonymous();
                    this.nonPublicOuter |= (jCClassDecl.mods.flags & 1L) == 0L;
                    if (this.nonPublicOuter) {
                        ThisEscapeAnalyzer.this.nonPublicOuters.add(this.currentClass.sym);
                    }
                    super.visitClassDef(jCClassDecl);
                }
                finally {
                    this.currentClass = jCClassDecl2;
                    this.nonPublicOuter = bl;
                    this.lint = lint;
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                Lint lint = this.lint;
                this.lint = this.lint.augment(jCVariableDecl.sym);
                try {
                    if (jCVariableDecl.sym.owner.kind == Kinds.Kind.TYP && !this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
                        ThisEscapeAnalyzer.this.suppressed.add(jCVariableDecl.sym);
                    }
                    super.visitVarDef(jCVariableDecl);
                }
                finally {
                    this.lint = lint;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                Lint lint = this.lint;
                this.lint = this.lint.augment(jCMethodDecl.sym);
                try {
                    if (TreeInfo.isConstructor(jCMethodDecl) && !this.lint.isEnabled(Lint.LintCategory.THIS_ESCAPE)) {
                        ThisEscapeAnalyzer.this.suppressed.add(jCMethodDecl.sym);
                    }
                    boolean bl = TreeInfo.isConstructor(jCMethodDecl);
                    boolean bl2 = this.currentClassIsExternallyExtendable();
                    boolean bl3 = (jCMethodDecl.sym.flags() & 5L) != 0L;
                    boolean bl4 = (jCMethodDecl.mods.flags & 0x1AL) != 0L;
                    boolean bl5 = bl2 && bl && bl3;
                    boolean bl6 = !bl2 || bl || bl4;
                    ThisEscapeAnalyzer.this.methodMap.put(jCMethodDecl.sym, new MethodInfo(this.currentClass, jCMethodDecl, bl, bl5, bl6));
                    super.visitMethodDef(jCMethodDecl);
                }
                finally {
                    this.lint = lint;
                }
            }

            private boolean currentClassIsExternallyExtendable() {
                return !this.currentClass.sym.isFinal() && this.currentClass.sym.isPublic() && (set == null || set.contains(this.currentClass.sym.packge())) && !this.currentClass.sym.isSealed() && !this.currentClass.sym.isDirectlyOrIndirectlyLocal() && !this.nonPublicOuter;
            }
        }.scan(env.tree);
        this.methodMap.values().stream().filter(MethodInfo::analyzable).forEach(this::analyzeConstructor);
        this.filterWarnings(warning -> !warning.isSuppressed());
        this.warningList.forEach(Warning::trimInitializerFrames);
        this.warningList.sort(Warning::sortByStackFrames);
        AtomicReference atomicReference = new AtomicReference();
        this.filterWarnings(warning -> {
            Warning warning2 = (Warning)atomicReference.get();
            if (warning2 != null && warning.isRedundantWith(warning2)) {
                return false;
            }
            atomicReference.set(warning);
            return true;
        });
        HashSet hashSet = new HashSet();
        this.filterWarnings(warning -> hashSet.add(warning.origin));
        for (Warning warning2 : this.warningList) {
            JCDiagnostic.LintWarning lintWarning = CompilerProperties.LintWarnings.PossibleThisEscape;
            for (StackFrame stackFrame : warning2.stack) {
                this.log.warning(stackFrame.site.pos(), (JCDiagnostic.Warning)lintWarning);
                lintWarning = CompilerProperties.LintWarnings.PossibleThisEscapeLocation;
            }
        }
        this.warningList.clear();
    }

    private void filterWarnings(Predicate<Warning> predicate) {
        int n = 0;
        for (Warning warning : this.warningList) {
            if (!predicate.test(warning)) continue;
            this.warningList.set(n++, warning);
        }
        this.warningList.subList(n, this.warningList.size()).clear();
    }

    @Override
    public void scan(JCTree jCTree) {
        boolean bl;
        if (jCTree == null || jCTree.type == Type.stuckType) {
            return;
        }
        Assert.check(this.checkInvariants(true, false));
        switch (jCTree.getTag()) {
            case SWITCH_EXPRESSION: 
            case CONDEXPR: 
            case YIELD: 
            case APPLY: 
            case NEWCLASS: 
            case NEWARRAY: 
            case LAMBDA: 
            case PARENS: 
            case ASSIGN: 
            case TYPECAST: 
            case INDEXED: 
            case SELECT: 
            case REFERENCE: 
            case IDENT: 
            case NULLCHK: 
            case LETEXPR: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        super.scan(jCTree);
        Assert.check(this.checkInvariants(true, bl));
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        this.visitVarDef(jCVariableDecl.sym, jCVariableDecl.init);
    }

    private void visitVarDef(Symbol.VarSymbol varSymbol, JCTree.JCExpression jCExpression) {
        this.scan(jCExpression);
        if (this.isParamOrVar(varSymbol)) {
            this.refs.replaceExprs(this.depth, exprRef -> new VarRef(varSymbol, (Ref)exprRef));
        } else {
            this.refs.discardExprs(this.depth);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        Assert.check(false);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        Symbol symbol = TreeInfo.symbolFor(jCMethodInvocation.meth);
        this.scan(jCMethodInvocation.meth);
        RefSet<ThisRef> refSet = RefSet.newEmpty();
        if (symbol != null && !symbol.isStatic()) {
            this.refs.removeExprs(this.depth).map(ThisRef::new).forEach(refSet::add);
        } else {
            this.refs.discardExprs(this.depth);
        }
        if (TreeInfo.name(jCMethodInvocation.meth) == this.names._super) {
            ((MethodInfo)this.currentMethod).declaringClass.defs.stream().filter(jCTree -> (TreeInfo.flags(jCTree) & 8L) == 0L).forEach(jCTree -> {
                int n;
                JCTree jCTree2 = jCTree;
                Objects.requireNonNull(jCTree2);
                JCTree jCTree3 = jCTree2;
                int n2 = 0;
                if (jCTree3 == null) {
                    n = -1;
                } else {
                    switch (n2) {
                        case 0: {
                            if (jCTree3 instanceof JCTree.JCBlock) {
                                n = 0;
                                break;
                            }
                        }
                        case 1: {
                            if (jCTree3 instanceof JCTree.JCVariableDecl) {
                                n = 1;
                                break;
                            }
                        }
                        default: {
                            n = 2;
                        }
                    }
                }
                switch (n) {
                    case 0: {
                        JCTree.JCBlock jCBlock = (JCTree.JCBlock)jCTree3;
                        this.analyzeInitializer(jCMethodInvocation, jCBlock, refSet, () -> this.visitBlock(jCBlock));
                        break;
                    }
                    case 1: {
                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree3;
                        this.analyzeInitializer(jCMethodInvocation, jCVariableDecl, refSet, () -> this.scan(jCVariableDecl));
                        break;
                    }
                }
            });
            return;
        }
        this.invoke(jCMethodInvocation, symbol, jCMethodInvocation.args, refSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeInitializer(JCTree.JCMethodInvocation jCMethodInvocation, JCTree jCTree, RefSet<ThisRef> refSet, Runnable runnable) {
        RefSet<Ref> refSet2 = this.refs;
        this.refs = RefSet.newEmpty();
        int n = this.depth;
        this.depth = 0;
        this.callStack.add(new StackFrame(this.currentMethod, jCTree, jCMethodInvocation));
        try {
            this.refs.addAll(refSet);
            runnable.run();
        }
        finally {
            this.callStack.remove(this.callStack.size() - 1);
            this.depth = n;
            this.refs = refSet2;
        }
    }

    private void invoke(JCTree jCTree, Symbol symbol, List<JCTree.JCExpression> list, RefSet<ThisRef> refSet) {
        if (symbol != null && symbol.owner.kind == Kinds.Kind.TYP && symbol.owner.type.tsym == this.syms.objectType.tsym && symbol.isFinal()) {
            return;
        }
        MethodInfo methodInfo2 = this.methodMap.get(symbol);
        if (methodInfo2 == null && refSet.size() == 1) {
            ThisRef thisRef = (ThisRef)refSet.iterator().next();
            methodInfo2 = this.methodMap.values().stream().filter(methodInfo -> this.isTargetMethod((MethodInfo)methodInfo, symbol, thisRef.tsym)).findFirst().orElse(null);
        }
        if (methodInfo2 != null && methodInfo2.invokable) {
            this.invokeInvokable(jCTree, list, refSet, methodInfo2);
        } else {
            this.invokeUnknown(jCTree, list, refSet);
        }
    }

    private boolean isTargetMethod(MethodInfo methodInfo, Symbol symbol, Symbol.TypeSymbol typeSymbol) {
        return symbol.kind == Kinds.Kind.MTH && ((MethodInfo)methodInfo).declaration.name == symbol.name && ((MethodInfo)methodInfo).declaringClass.sym == typeSymbol && !((MethodInfo)methodInfo).declaration.sym.isConstructor() && (((MethodInfo)methodInfo).declaration.sym.flags() & 8L) == 0L && ((MethodInfo)methodInfo).declaration.sym.overrides(symbol, typeSymbol, this.types, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInvokable(JCTree jCTree, List<JCTree.JCExpression> list, RefSet<ThisRef> refSet, MethodInfo methodInfo) {
        Object object;
        Assert.check(methodInfo.invokable);
        JCTree.JCMethodDecl jCMethodDecl = methodInfo.declaration;
        RefSet refSet2 = RefSet.newEmpty();
        List<JCTree.JCVariableDecl> list2 = jCMethodDecl.params;
        while (list.nonEmpty() && list2.nonEmpty()) {
            object = ((JCTree.JCVariableDecl)list2.head).sym;
            this.scan((JCTree)list.head);
            this.refs.removeExprs(this.depth).map(arg_0 -> ThisEscapeAnalyzer.lambda$invokeInvokable$12((Symbol.VarSymbol)object, arg_0)).forEach(refSet2::add);
            list = list.tail;
            list2 = list2.tail;
        }
        object = this.currentMethod;
        this.currentMethod = methodInfo;
        RefSet<Ref> refSet3 = this.refs;
        this.refs = RefSet.newEmpty();
        int n = this.depth;
        this.depth = 0;
        this.callStack.add(new StackFrame((MethodInfo)object, null, jCTree));
        try {
            this.refs.addAll(refSet);
            this.refs.addAll(refSet2);
            if (this.refs.isEmpty()) {
                return;
            }
            Pair<JCTree.JCMethodDecl, Object> pair = Pair.of(methodInfo.declaration, this.refs.clone());
            if (!this.invocations.add(pair)) {
                return;
            }
            try {
                this.scan(jCMethodDecl.body);
            }
            finally {
                this.invocations.remove(pair);
            }
            if (TreeInfo.isConstructor(methodInfo.declaration)) {
                this.refs.remove(ThisRef.class).map(ReturnRef::new).forEach(this.refs::add);
            }
            this.refs.remove(ReturnRef.class).map(returnRef -> new ExprRef(n, (Ref)returnRef)).forEach(refSet3::add);
        }
        finally {
            this.callStack.remove(this.callStack.size() - 1);
            this.depth = n;
            this.refs = refSet3;
            this.currentMethod = object;
        }
    }

    private void invokeUnknown(JCTree jCTree, List<JCTree.JCExpression> list, RefSet<ThisRef> refSet) {
        if (refSet.stream().anyMatch(this::triggersUnknownInvokeLeak)) {
            this.leakAt(jCTree);
        }
        for (JCTree.JCExpression jCExpression : list) {
            this.scan(jCExpression);
            if (!this.refs.removeExprs(this.depth).anyMatch(this::triggersUnknownInvokeLeak)) continue;
            this.leakAt(jCExpression);
        }
        if (jCTree.hasTag(JCTree.Tag.NEWCLASS)) {
            refSet.stream().map(thisRef -> new ExprRef(this.depth, (Ref)thisRef)).forEach(this.refs::add);
        }
    }

    private boolean triggersUnknownInvokeLeak(Ref ref) {
        return !this.nonPublicOuters.contains(ref.tsym) || ref.indirections.stream().anyMatch(indirection -> indirection != Indirection.OUTER);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        MethodInfo methodInfo = this.methodMap.get(jCNewClass.constructor);
        Symbol.TypeSymbol typeSymbol = jCNewClass.def != null ? jCNewClass.def.sym : jCNewClass.clazz.type.tsym;
        RefSet<ThisRef> refSet = this.receiverRefsForConstructor(jCNewClass.encl, typeSymbol);
        if (methodInfo != null && methodInfo.invokable) {
            this.invokeInvokable(jCNewClass, jCNewClass.args, refSet, methodInfo);
        } else {
            this.invokeUnknown(jCNewClass, jCNewClass.args, refSet);
        }
    }

    private RefSet<ThisRef> receiverRefsForConstructor(JCTree.JCExpression jCExpression, Symbol.TypeSymbol typeSymbol) {
        if (jCExpression != null) {
            this.scan(jCExpression);
            return this.refs.removeExprs(this.depth).map(exprRef -> exprRef.toOuter(jCExpression.type.tsym)).flatMap(optional -> optional.isPresent() ? Stream.of((ThisRef)optional.get()) : Stream.empty()).collect(RefSet.collector());
        }
        if (this.hasImplicitOuterInstance(typeSymbol)) {
            return this.refs.find(ThisRef.class).map(thisRef -> thisRef.toOuter(typeSymbol)).flatMap(optional -> optional.isPresent() ? Stream.of((ThisRef)optional.get()) : Stream.empty()).collect(RefSet.collector());
        }
        return RefSet.newEmpty();
    }

    private boolean hasImplicitOuterInstance(Symbol.TypeSymbol typeSymbol) {
        Symbol.ClassSymbol classSymbol = ((MethodInfo)this.currentMethod).declaringClass.sym;
        return typeSymbol != classSymbol && typeSymbol.hasOuterInstance() && typeSymbol.isEnclosedBy(classSymbol);
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        this.visitScoped(false, () -> super.visitBlock(jCBlock));
        Assert.check(this.checkInvariants(true, false));
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop2) {
        this.visitLooped(jCDoWhileLoop2, jCDoWhileLoop -> super.visitDoLoop((JCTree.JCDoWhileLoop)jCDoWhileLoop));
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop2) {
        this.visitLooped(jCWhileLoop2, jCWhileLoop -> super.visitWhileLoop((JCTree.JCWhileLoop)jCWhileLoop));
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop2) {
        this.visitLooped(jCForLoop2, jCForLoop -> super.visitForLoop((JCTree.JCForLoop)jCForLoop));
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        Object object;
        Type type = this.types.elemtype(jCEnhancedForLoop.expr.type);
        Symbol.MethodSymbol methodSymbol = null;
        Symbol.MethodSymbol methodSymbol2 = null;
        Symbol.MethodSymbol methodSymbol3 = null;
        if (type == null && (object = this.rs.resolveQualifiedMethod(jCEnhancedForLoop.expr.pos(), this.topLevelEnv, jCEnhancedForLoop.expr.type, this.names.iterator, List.nil(), List.nil())) instanceof Symbol.MethodSymbol) {
            methodSymbol = (Symbol.MethodSymbol)object;
            Symbol symbol = this.rs.resolveQualifiedMethod(jCEnhancedForLoop.expr.pos(), this.topLevelEnv, methodSymbol.getReturnType(), this.names.hasNext, List.nil(), List.nil());
            Symbol symbol2 = this.rs.resolveQualifiedMethod(jCEnhancedForLoop.expr.pos(), this.topLevelEnv, methodSymbol.getReturnType(), this.names.next, List.nil(), List.nil());
            if (symbol instanceof Symbol.MethodSymbol) {
                methodSymbol2 = (Symbol.MethodSymbol)symbol;
            }
            if (symbol2 instanceof Symbol.MethodSymbol) {
                methodSymbol3 = (Symbol.MethodSymbol)symbol2;
            }
        }
        final class ForeachMethods {
            private final Symbol.MethodSymbol iterator;
            private final Symbol.MethodSymbol hasNext;
            private final Symbol.MethodSymbol next;

            ForeachMethods(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.MethodSymbol methodSymbol3) {
                this.iterator = methodSymbol;
                this.hasNext = methodSymbol2;
                this.next = methodSymbol3;
            }

            public final String toString() {
                return "ForeachMethods[" + "iterator=" + Objects.toString(this.iterator) + ", hasNext=" + Objects.toString(this.hasNext) + ", next=" + Objects.toString(this.next) + "]";
            }

            public final int hashCode() {
                return 31 * (31 * (31 * 0 + Objects.hashCode(this.iterator)) + Objects.hashCode(this.hasNext)) + Objects.hashCode(this.next);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean equals(Object object) {
                if (!(object instanceof ForeachMethods)) return false;
                ForeachMethods foreachMethods = (ForeachMethods)object;
                if (!Objects.equals(this.next, foreachMethods.next)) return false;
                if (!Objects.equals(this.hasNext, foreachMethods.hasNext)) return false;
                if (!Objects.equals(this.iterator, foreachMethods.iterator)) return false;
                return true;
            }

            public Symbol.MethodSymbol iterator() {
                return this.iterator;
            }

            public Symbol.MethodSymbol hasNext() {
                return this.hasNext;
            }

            public Symbol.MethodSymbol next() {
                return this.next;
            }
        }
        object = methodSymbol != null && methodSymbol2 != null && methodSymbol3 != null ? new ForeachMethods(methodSymbol, methodSymbol2, methodSymbol3) : null;
        this.visitLooped(jCEnhancedForLoop, arg_0 -> this.lambda$visitForeachLoop$28(type, (ForeachMethods)object, arg_0));
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        this.visitScoped(false, () -> {
            this.scan(jCSwitch.selector);
            this.refs.discardExprs(this.depth);
            this.scan(jCSwitch.cases);
        });
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
        this.visitScoped(true, () -> {
            this.scan(jCSwitchExpression.selector);
            this.refs.discardExprs(this.depth);
            RefSet refSet = RefSet.newEmpty();
            List<JCTree.JCCase> list = jCSwitchExpression.cases;
            while (list.nonEmpty()) {
                this.scan(((JCTree.JCCase)list.head).stats);
                this.refs.remove(YieldRef.class).map(yieldRef -> new ExprRef(this.depth, (Ref)yieldRef)).forEach(refSet::add);
                this.refs.removeExprs(this.depth).forEach(refSet::add);
                list = list.tail;
            }
            this.refs.addAll(refSet);
        });
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        this.scan(jCCase.stats);
    }

    @Override
    public void visitYield(JCTree.JCYield jCYield) {
        this.scan(jCYield.value);
        this.refs.replaceExprs(this.depth, YieldRef::new);
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        this.visitScoped(true, () -> super.visitLetExpr(letExpr));
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        this.scan(jCReturn.expr);
        this.refs.replaceExprs(this.depth, ReturnRef::new);
    }

    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        this.visitDeferred(() -> this.visitScoped(true, () -> this.scan(jCLambda.body)));
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)TreeInfo.symbolFor(jCAssign.lhs);
        this.scan(jCAssign.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(jCAssign.rhs);
        if (this.isParamOrVar(varSymbol)) {
            this.refs.replaceExprs(this.depth, exprRef -> new VarRef(varSymbol, (Ref)exprRef));
        } else {
            this.refs.discardExprs(this.depth);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.scan(jCArrayAccess.index);
        this.refs.discardExprs(this.depth);
        this.scan(jCArrayAccess.indexed);
        this.refs.removeExprs(this.depth).map(exprRef -> exprRef.toDirect(jCArrayAccess.type.tsym)).flatMap(optional -> optional.isPresent() ? Stream.of((ExprRef)optional.get()) : Stream.empty()).forEach(this.refs::add);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        this.scan(jCFieldAccess.selected);
        Stream<ExprRef> stream = this.refs.removeExprs(this.depth);
        Type.ClassType classType = (Type.ClassType)((MethodInfo)this.currentMethod).declaringClass.sym.type;
        if (TreeInfo.isExplicitThisReference(this.types, classType, jCFieldAccess)) {
            this.refs.find(ThisRef.class).map(thisRef -> new ExprRef(this.depth, (Ref)thisRef)).forEach(this.refs::add);
            return;
        }
        if (this.isExplicitOuterThisReference(this.types, classType, jCFieldAccess)) {
            this.refs.find(ThisRef.class).map(thisRef -> thisRef.fromOuter(this.depth)).flatMap(optional -> optional.isPresent() ? Stream.of((ExprRef)optional.get()) : Stream.empty()).forEach(this.refs::add);
            return;
        }
        if (jCFieldAccess.sym.kind == Kinds.Kind.MTH && (jCFieldAccess.sym.flags() & 8L) == 0L) {
            stream.forEach(this.refs::add);
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        if (jCMemberReference.type.isErroneous()) {
            return;
        }
        this.scan(jCMemberReference.expr);
        RefSet refSet = RefSet.newEmpty();
        switch (jCMemberReference.kind) {
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                this.refs.discardExprs(this.depth);
                return;
            }
            case SUPER: 
            case BOUND: {
                this.refs.removeExprs(this.depth).map(ThisRef::new).forEach(refSet::add);
                break;
            }
            case IMPLICIT_INNER: {
                this.receiverRefsForConstructor(null, jCMemberReference.expr.type.tsym).forEach(refSet::add);
                break;
            }
            default: {
                throw new RuntimeException("non-exhaustive?");
            }
        }
        this.visitDeferred(() -> this.invoke(jCMemberReference, (Symbol.MethodSymbol)jCMemberReference.sym, List.nil(), refSet));
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        block8: {
            block7: {
                if (jCIdent.name == this.names._this) break block7;
                if (jCIdent.name != this.names._super) break block8;
            }
            this.refs.find(ThisRef.class).map(thisRef -> new ExprRef(this.depth, (Ref)thisRef)).forEach(this.refs::add);
            return;
        }
        if (this.isParamOrVar(jCIdent.sym)) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)jCIdent.sym;
            this.refs.find(VarRef.class, varRef -> varRef.sym == varSymbol).map(varRef -> new ExprRef(this.depth, (Ref)varRef)).forEach(this.refs::add);
            return;
        }
        if (jCIdent.sym.kind == Kinds.Kind.MTH && (jCIdent.sym.flags() & 8L) == 0L) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)jCIdent.sym;
            Symbol.ClassSymbol classSymbol = ((MethodInfo)this.currentMethod).declaringClass.sym;
            if (classSymbol.isSubClass(methodSymbol.owner, this.types)) {
                this.refs.find(ThisRef.class).map(thisRef -> new ExprRef(this.depth, (Ref)thisRef)).forEach(this.refs::add);
                return;
            }
            if (classSymbol.isEnclosedBy((Symbol.ClassSymbol)methodSymbol.owner)) {
                this.refs.find(ThisRef.class).map(thisRef -> thisRef.fromOuter(this.depth)).flatMap(optional -> optional.isPresent() ? Stream.of((ExprRef)optional.get()) : Stream.empty()).forEach(this.refs::add);
                return;
            }
            return;
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        this.scan(jCSynchronized.lock);
        this.refs.discardExprs(this.depth);
        this.scan(jCSynchronized.body);
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        this.scan(jCConditional.cond);
        this.refs.discardExprs(this.depth);
        RefSet refSet = RefSet.newEmpty();
        this.scan(jCConditional.truepart);
        this.refs.removeExprs(this.depth).forEach(refSet::add);
        this.scan(jCConditional.falsepart);
        this.refs.removeExprs(this.depth).forEach(refSet::add);
        this.refs.addAll(refSet);
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        this.scan(jCIf.cond);
        this.refs.discardExprs(this.depth);
        this.scan(jCIf.thenpart);
        this.scan(jCIf.elsepart);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        this.scan(jCExpressionStatement.expr);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        this.scan(jCThrow.expr);
        if (this.refs.discardExprs(this.depth)) {
            this.leakAt(jCThrow);
        }
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        this.scan(jCAssert.cond);
        this.refs.discardExprs(this.depth);
        this.scan(jCAssert.detail);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        RefSet refSet = RefSet.newEmpty();
        if (jCNewArray.elems != null) {
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                this.scan((JCTree)list.head);
                this.refs.removeExprs(this.depth).map(exprRef -> exprRef.toIndirect(jCNewArray.type.tsym)).flatMap(optional -> optional.isPresent() ? Stream.of((ExprRef)optional.get()) : Stream.empty()).forEach(refSet::add);
                list = list.tail;
            }
        }
        refSet.stream().forEach(this.refs::add);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.scan(jCTypeCast.expr);
        this.refs.replaceExprs(this.depth, exprRef -> exprRef.withType(jCTypeCast.expr.type.tsym));
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel jCConstantCaseLabel) {
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel jCPatternCaseLabel) {
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern jCRecordPattern) {
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.scan(jCInstanceOf.expr);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion jCTypeUnion) {
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection jCTypeIntersection) {
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind typeBoundKind) {
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        this.scan(jCAssignOp.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(jCAssignOp.rhs);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        this.scan(jCUnary.arg);
        this.refs.discardExprs(this.depth);
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        this.scan(jCBinary.lhs);
        this.refs.discardExprs(this.depth);
        this.scan(jCBinary.rhs);
        this.refs.discardExprs(this.depth);
    }

    private void analyzeConstructor(MethodInfo methodInfo) {
        Assert.check(this.targetClass == null);
        Assert.check(this.currentMethod == null);
        Assert.check(this.depth == -1);
        Assert.check(this.refs == null);
        this.targetClass = methodInfo.declaringClass;
        this.currentMethod = methodInfo;
        try {
            this.refs = RefSet.newEmpty();
            this.refs.add(new ThisRef(this.targetClass.sym, EnumSet.of(Indirection.DIRECT)));
            this.visitScoped(false, () -> this.scan(((MethodInfo)methodInfo).declaration.body));
            Assert.check(this.depth == -1);
        }
        catch (Throwable throwable) {
            Assert.check(this.depth == -1);
            this.currentMethod = null;
            this.targetClass = null;
            this.refs = null;
            throw throwable;
        }
        this.currentMethod = null;
        this.targetClass = null;
        this.refs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends JCTree> void visitDeferred(Runnable runnable) {
        int n = this.warningList.size();
        Object object = this.refs.clone();
        try {
            runnable.run();
            boolean bl = this.warningList.size() > n;
        }
        finally {
            this.refs = object;
            this.warningList.subList(n, this.warningList.size()).clear();
        }
        if (bl |= this.refs.discardExprs(this.depth)) {
            this.refs.add(new ExprRef(this.depth, this.syms.objectType.tsym, EnumSet.of(Indirection.INDIRECT)));
        }
    }

    private <T extends JCTree> void visitLooped(T t, Consumer<T> consumer) {
        this.visitScoped(false, () -> {
            Object object;
            do {
                object = this.refs.clone();
                consumer.accept(t);
            } while (!this.refs.equals(object));
        });
    }

    private void visitScoped(boolean bl, Runnable runnable) {
        this.pushScope();
        try {
            Assert.check(this.checkInvariants(true, false));
            runnable.run();
            Assert.check(this.checkInvariants(true, bl));
            if (bl) {
                Assert.check(this.depth > 0);
                this.refs.removeExprs(this.depth).map(exprRef -> new ExprRef(this.depth - 1, (Ref)exprRef)).forEach(this.refs::add);
            }
        }
        finally {
            this.popScope();
        }
    }

    private void pushScope() {
        ++this.depth;
    }

    private void popScope() {
        Assert.check(this.depth >= 0);
        this.refs.discardExprs(this.depth);
        --this.depth;
    }

    private void leakAt(JCTree jCTree) {
        this.callStack.add(new StackFrame(this.currentMethod, null, jCTree));
        this.warningList.add(new Warning(this.targetClass, new ArrayList<StackFrame>(this.callStack)));
        this.callStack.remove(this.callStack.size() - 1);
    }

    private boolean isParamOrVar(Symbol symbol) {
        return symbol != null && symbol.kind == Kinds.Kind.VAR && (symbol.owner.kind == Kinds.Kind.MTH || symbol.owner.kind == Kinds.Kind.VAR);
    }

    private boolean isExplicitOuterThisReference(Types types, Type.ClassType classType, JCTree.JCFieldAccess jCFieldAccess) {
        Type type = types.erasure(jCFieldAccess.selected.type);
        if (type.hasTag(TypeTag.CLASS)) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
            Symbol.ClassSymbol classSymbol2 = (Symbol.ClassSymbol)type.tsym;
            if (jCFieldAccess.name == this.names._this && classSymbol.hasOuterInstance() && classSymbol.owner.enclClass() == classSymbol2) {
                return true;
            }
        }
        return false;
    }

    private boolean isAnalyzing() {
        return this.targetClass != null;
    }

    private boolean checkInvariants(boolean bl, boolean bl2) {
        Assert.check(bl == this.isAnalyzing());
        if (this.isAnalyzing()) {
            Assert.check(this.currentMethod != null);
            Assert.check(this.targetClass != null);
            Assert.check(this.refs != null);
            Assert.check(this.depth >= 0);
            Assert.check(this.refs.find(ExprRef.class).allMatch(exprRef -> bl2 && exprRef.depth <= this.depth));
        } else {
            Assert.check(this.targetClass == null);
            Assert.check(this.refs == null);
            Assert.check(this.depth == -1);
            Assert.check(this.callStack.isEmpty());
            Assert.check(this.invocations.isEmpty());
        }
        return true;
    }

    private /* synthetic */ void lambda$visitForeachLoop$28(Type type, 1ForeachMethods foreachMethods, JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        this.scan(jCEnhancedForLoop.expr);
        if (type != null) {
            if (this.isParamOrVar(jCEnhancedForLoop.var.sym)) {
                this.refs.removeExprs(this.depth).map(exprRef -> exprRef.toIndirect(type.tsym)).flatMap(optional -> optional.isPresent() ? Stream.of((ExprRef)optional.get()) : Stream.empty()).map(exprRef -> new VarRef(jCEnhancedForLoop.var.sym, (Ref)exprRef)).forEach(this.refs::add);
            } else {
                this.refs.discardExprs(this.depth);
            }
        } else if (foreachMethods != null) {
            RefSet<ThisRef> refSet = this.refs.removeExprs(this.depth).map(ThisRef::new).collect(RefSet.collector());
            this.invoke(jCEnhancedForLoop.expr, foreachMethods.iterator, List.nil(), refSet);
            refSet = this.refs.removeExprs(this.depth).map(ThisRef::new).collect(RefSet.collector());
            this.invoke(jCEnhancedForLoop.expr, foreachMethods.hasNext, List.nil(), refSet);
            this.refs.discardExprs(this.depth);
            this.invoke(jCEnhancedForLoop.expr, foreachMethods.next, List.nil(), refSet);
            if (this.isParamOrVar(jCEnhancedForLoop.var.sym)) {
                this.refs.replaceExprs(this.depth, exprRef -> new VarRef(jCEnhancedForLoop.var.sym, (Ref)exprRef));
            } else {
                this.refs.discardExprs(this.depth);
            }
        } else {
            this.refs.discardExprs(this.depth);
        }
        this.scan(jCEnhancedForLoop.body);
    }

    private static /* synthetic */ VarRef lambda$invokeInvokable$12(Symbol.VarSymbol varSymbol, ExprRef exprRef) {
        return new VarRef(varSymbol, exprRef);
    }

    private static final class MethodInfo {
        private final JCTree.JCClassDecl declaringClass;
        private final JCTree.JCMethodDecl declaration;
        private final boolean constructor;
        private final boolean analyzable;
        private final boolean invokable;

        private MethodInfo(JCTree.JCClassDecl jCClassDecl, JCTree.JCMethodDecl jCMethodDecl, boolean bl, boolean bl2, boolean bl3) {
            this.declaringClass = jCClassDecl;
            this.declaration = jCMethodDecl;
            this.constructor = bl;
            this.analyzable = bl2;
            this.invokable = bl3;
        }

        public String toString() {
            return "MethodInfo[method=" + this.declaringClass.sym.flatname + "." + this.declaration.sym + ",constructor=" + this.constructor + ",analyzable=" + this.analyzable + ",invokable=" + this.invokable + "]";
        }

        public final int hashCode() {
            return 31 * (31 * (31 * (31 * (31 * 0 + Objects.hashCode(this.declaringClass)) + Objects.hashCode(this.declaration)) + Boolean.hashCode(this.constructor)) + Boolean.hashCode(this.analyzable)) + Boolean.hashCode(this.invokable);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object object) {
            if (!(object instanceof MethodInfo)) return false;
            MethodInfo methodInfo = (MethodInfo)object;
            if (this.invokable != methodInfo.invokable) return false;
            if (this.analyzable != methodInfo.analyzable) return false;
            if (this.constructor != methodInfo.constructor) return false;
            if (!Objects.equals(this.declaration, methodInfo.declaration)) return false;
            if (!Objects.equals(this.declaringClass, methodInfo.declaringClass)) return false;
            return true;
        }

        public JCTree.JCClassDecl declaringClass() {
            return this.declaringClass;
        }

        public JCTree.JCMethodDecl declaration() {
            return this.declaration;
        }

        public boolean constructor() {
            return this.constructor;
        }

        public boolean analyzable() {
            return this.analyzable;
        }

        public boolean invokable() {
            return this.invokable;
        }
    }

    private static class RefSet<T extends Ref>
    extends HashSet<T> {
        private RefSet() {
            super(8);
        }

        public static <T extends Ref> RefSet<T> newEmpty() {
            return new RefSet<T>();
        }

        public <T extends Ref> Stream<T> find(Class<T> clazz) {
            return this.find(clazz, ref -> true);
        }

        public <T extends Ref> Stream<T> find(Class<T> clazz, Predicate<? super T> predicate) {
            return this.stream().filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(Collectors.toList()).stream();
        }

        public Stream<ExprRef> findExprs(int n) {
            return this.find(ExprRef.class, exprRef -> exprRef.depth == n);
        }

        public <T extends Ref> Stream<T> remove(Class<T> clazz) {
            return this.remove(clazz, ref -> true);
        }

        public <T extends Ref> Stream<T> remove(Class<T> clazz, Predicate<? super T> predicate) {
            ArrayList arrayList = this.stream().filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(Collectors.toCollection(ArrayList::new));
            this.removeAll(arrayList);
            return arrayList.stream();
        }

        public Stream<ExprRef> removeExprs(int n) {
            return this.remove(ExprRef.class, exprRef -> exprRef.depth == n);
        }

        public boolean discardExprs(int n) {
            return this.removeIf(ref -> {
                if (!(ref instanceof ExprRef)) return false;
                ExprRef exprRef = (ExprRef)ref;
                if (exprRef.depth != n) return false;
                return true;
            });
        }

        public void replaceExprs(int n, Function<? super ExprRef, ? extends T> function) {
            this.removeExprs(n).map(function).forEach(this::add);
        }

        @Override
        public RefSet<T> clone() {
            return (RefSet)super.clone();
        }

        public static <T extends Ref> Collector<T, ?, RefSet<T>> collector() {
            return Collectors.toCollection(RefSet::new);
        }
    }

    private class Warning {
        final JCTree.JCClassDecl declaringClass;
        final ArrayList<StackFrame> stack;
        final JCTree origin;

        Warning(JCTree.JCClassDecl jCClassDecl, ArrayList<StackFrame> arrayList) {
            this.declaringClass = jCClassDecl;
            this.stack = arrayList;
            this.origin = arrayList.stream().map(stackFrame -> stackFrame.initializer).filter(Objects::nonNull).findFirst().orElseGet(() -> ((StackFrame)arrayList.get((int)0)).method.declaration);
        }

        boolean isRedundantWith(Warning warning) {
            int n = this.stack.size() - warning.stack.size();
            return n >= 0 && IntStream.range(0, warning.stack.size()).allMatch(n2 -> this.stack.get(n + n2).comparePos(warning.stack.get(n2)) == 0);
        }

        static int sortByStackFrames(Warning warning, Warning warning2) {
            int n;
            int n2 = warning.stack.size();
            int n3 = warning2.stack.size();
            do {
                boolean bl;
                boolean bl2 = --n2 < 0;
                boolean bl3 = bl = --n3 < 0;
                if (bl2 && bl) {
                    return 0;
                }
                if (bl2) {
                    return -1;
                }
                if (!bl) continue;
                return 1;
            } while ((n = warning.stack.get(n2).comparePos(warning2.stack.get(n3))) == 0);
            return n;
        }

        boolean isSuppressed() {
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                if (!this.stack.get(i).isSuppressed()) continue;
                return true;
            }
            return false;
        }

        void trimInitializerFrames() {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (this.stack.get((int)i).initializer == null) continue;
                this.stack.subList(0, i + 1).clear();
                break;
            }
        }

        public String toString() {
            return "Warning[class=" + this.declaringClass.sym.flatname + ",stack=[\n    " + this.stack.stream().map(StackFrame::toString).collect(Collectors.joining("\n    ")) + "]]";
        }
    }

    private class StackFrame {
        final MethodInfo method;
        final JCTree site;
        final JCTree initializer;
        final boolean suppressible;

        StackFrame(MethodInfo methodInfo, JCTree jCTree, JCTree jCTree2) {
            this.method = methodInfo;
            this.initializer = jCTree;
            this.site = jCTree2;
            this.suppressible = jCTree != null || methodInfo.constructor && methodInfo.declaringClass == ThisEscapeAnalyzer.this.targetClass;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isSuppressed() {
            Symbol symbol;
            if (!this.suppressible) return false;
            Set set = ThisEscapeAnalyzer.this.suppressed;
            JCTree jCTree = this.initializer;
            if (jCTree instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree;
                symbol = jCVariableDecl.sym;
            } else {
                symbol = ((MethodInfo)this.method).declaration.sym;
            }
            if (!set.contains(symbol)) return false;
            return true;
        }

        int comparePos(StackFrame stackFrame) {
            return Integer.compare(this.site.pos().getPreferredPosition(), stackFrame.site.pos().getPreferredPosition());
        }

        public String toString() {
            return "StackFrame[" + ((MethodInfo)this.method).declaration.sym + "@" + this.site.pos().getPreferredPosition() + (this.initializer != null ? ",init@" + this.initializer.pos().getPreferredPosition() : "") + "]";
        }
    }

    private static class ThisRef
    extends Ref {
        ThisRef(Ref ref) {
            super(ref);
        }

        ThisRef(Symbol.TypeSymbol typeSymbol, EnumSet<Indirection> enumSet) {
            super(typeSymbol, enumSet);
        }

        @Override
        public ThisRef withType(Symbol.TypeSymbol typeSymbol) {
            return new ThisRef(typeSymbol, this.indirections);
        }

        public Optional<ExprRef> fromOuter(int n) {
            Symbol.ClassSymbol classSymbol = Optional.of(this.tsym.owner).map(Symbol::enclClass).orElse(null);
            if (classSymbol == null) {
                return Optional.empty();
            }
            return Optional.of(this).filter(thisRef -> thisRef.indirections.contains((Object)Indirection.OUTER)).map(thisRef -> new ExprRef(n, classSymbol, thisRef.modifiedIndirections(enumSet -> {
                enumSet.remove((Object)Indirection.OUTER);
                enumSet.remove((Object)Indirection.INDIRECT);
                enumSet.add(Indirection.DIRECT);
            })));
        }
    }

    private static class ReturnRef
    extends Ref {
        ReturnRef(Ref ref) {
            super(ref);
        }

        ReturnRef(Symbol.TypeSymbol typeSymbol, EnumSet<Indirection> enumSet) {
            super(typeSymbol, enumSet);
        }

        @Override
        public ReturnRef withType(Symbol.TypeSymbol typeSymbol) {
            return new ReturnRef(typeSymbol, this.indirections);
        }
    }

    private static abstract class Ref {
        final Symbol.TypeSymbol tsym;
        final EnumSet<Indirection> indirections;

        Ref(Ref ref) {
            this(ref.tsym, ref.indirections);
        }

        Ref(Symbol.TypeSymbol typeSymbol, EnumSet<Indirection> enumSet) {
            Assert.check(typeSymbol != null);
            Assert.check(enumSet != null);
            this.tsym = typeSymbol;
            this.indirections = EnumSet.copyOf(enumSet);
        }

        public abstract Ref withType(Symbol.TypeSymbol var1);

        public int hashCode() {
            return this.getClass().hashCode() ^ this.tsym.hashCode() ^ this.indirections.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            Ref ref = (Ref)object;
            return this.tsym == ref.tsym && this.indirections.equals(ref.indirections);
        }

        public final String toString() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("tsym=" + this.tsym);
            this.addProperties(arrayList);
            arrayList.add(this.indirections.stream().map(Enum::name).collect(Collectors.joining(",")));
            return this.getClass().getSimpleName() + "[" + arrayList.stream().collect(Collectors.joining(",")) + "]";
        }

        protected void addProperties(ArrayList<String> arrayList) {
        }

        public EnumSet<Indirection> modifiedIndirections(Consumer<? super EnumSet<Indirection>> consumer) {
            EnumSet<Indirection> enumSet = EnumSet.copyOf(this.indirections);
            consumer.accept(enumSet);
            Assert.check(!enumSet.isEmpty());
            return enumSet;
        }

        public Optional<ThisRef> toOuter(Symbol.TypeSymbol typeSymbol) {
            return Optional.of(this).filter(ref -> ref.indirections.contains((Object)Indirection.DIRECT)).map(ref -> new ThisRef(typeSymbol, ref.modifiedIndirections(enumSet -> {
                enumSet.remove((Object)Indirection.DIRECT);
                enumSet.remove((Object)Indirection.INDIRECT);
                enumSet.add(Indirection.OUTER);
            })));
        }
    }

    private static class VarRef
    extends Ref {
        final Symbol.VarSymbol sym;

        VarRef(Symbol.VarSymbol varSymbol, Ref ref) {
            super(ref);
            this.sym = varSymbol;
        }

        VarRef(Symbol.VarSymbol varSymbol, Symbol.TypeSymbol typeSymbol, EnumSet<Indirection> enumSet) {
            super(typeSymbol, enumSet);
            this.sym = varSymbol;
        }

        @Override
        public VarRef withType(Symbol.TypeSymbol typeSymbol) {
            return new VarRef(this.sym, typeSymbol, this.indirections);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.sym);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            VarRef varRef = (VarRef)object;
            return Objects.equals(this.sym, varRef.sym);
        }

        @Override
        protected void addProperties(ArrayList<String> arrayList) {
            super.addProperties(arrayList);
            arrayList.add("sym=" + this.sym);
        }
    }

    static enum Indirection {
        DIRECT,
        OUTER,
        INDIRECT;

    }

    private static class ExprRef
    extends Ref {
        final int depth;

        ExprRef(int n, Ref ref) {
            super(ref);
            this.depth = n;
        }

        ExprRef(int n, Symbol.TypeSymbol typeSymbol, EnumSet<Indirection> enumSet) {
            super(typeSymbol, enumSet);
            this.depth = n;
        }

        @Override
        public ExprRef withType(Symbol.TypeSymbol typeSymbol) {
            return new ExprRef(this.depth, typeSymbol, this.indirections);
        }

        public Optional<ExprRef> toIndirect(Symbol.TypeSymbol typeSymbol) {
            return Optional.of(this).filter(exprRef -> exprRef.indirections.contains((Object)Indirection.DIRECT) || exprRef.indirections.contains((Object)Indirection.INDIRECT)).map(exprRef -> new ExprRef(this.depth, typeSymbol, exprRef.modifiedIndirections(enumSet -> {
                enumSet.remove((Object)Indirection.DIRECT);
                enumSet.remove((Object)Indirection.OUTER);
                enumSet.add(Indirection.INDIRECT);
            })));
        }

        public Optional<ExprRef> toDirect(Symbol.TypeSymbol typeSymbol) {
            return Optional.of(this).filter(exprRef -> exprRef.indirections.contains((Object)Indirection.INDIRECT)).map(exprRef -> new ExprRef(this.depth, typeSymbol, exprRef.modifiedIndirections(enumSet -> {
                enumSet.remove((Object)Indirection.OUTER);
                enumSet.add(Indirection.DIRECT);
            })));
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Integer.hashCode(this.depth);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            ExprRef exprRef = (ExprRef)object;
            return this.depth == exprRef.depth;
        }

        @Override
        protected void addProperties(ArrayList<String> arrayList) {
            super.addProperties(arrayList);
            arrayList.add("depth=" + this.depth);
        }
    }

    private static class YieldRef
    extends Ref {
        YieldRef(Ref ref) {
            super(ref);
        }

        YieldRef(Symbol.TypeSymbol typeSymbol, EnumSet<Indirection> enumSet) {
            super(typeSymbol, enumSet);
        }

        @Override
        public YieldRef withType(Symbol.TypeSymbol typeSymbol) {
            return new YieldRef(typeSymbol, this.indirections);
        }
    }
}

