/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;

public class MatchBindingsComputer
extends TreeScanner {
    public static final MatchBindings EMPTY = new MatchBindings(List.nil(), List.nil());
    protected static final Context.Key<MatchBindingsComputer> matchBindingsComputerKey = new Context.Key();
    private final Log log;

    public static MatchBindingsComputer instance(Context context) {
        MatchBindingsComputer matchBindingsComputer = context.get(matchBindingsComputerKey);
        if (matchBindingsComputer == null) {
            matchBindingsComputer = new MatchBindingsComputer(context);
        }
        return matchBindingsComputer;
    }

    protected MatchBindingsComputer(Context context) {
        this.log = Log.instance(context);
    }

    public MatchBindings conditional(JCTree jCTree, MatchBindings matchBindings, MatchBindings matchBindings2, MatchBindings matchBindings3) {
        if (matchBindings == EMPTY && matchBindings2 == EMPTY && matchBindings3 == EMPTY) {
            return EMPTY;
        }
        JCDiagnostic.DiagnosticPosition diagnosticPosition = jCTree.pos();
        List<Symbol.BindingSymbol> list = this.intersection(diagnosticPosition, matchBindings.bindingsWhenTrue, matchBindings3.bindingsWhenTrue);
        List<Symbol.BindingSymbol> list2 = this.intersection(diagnosticPosition, matchBindings.bindingsWhenFalse, matchBindings2.bindingsWhenTrue);
        List<Symbol.BindingSymbol> list3 = this.intersection(diagnosticPosition, matchBindings2.bindingsWhenTrue, matchBindings3.bindingsWhenTrue);
        List<Symbol.BindingSymbol> list4 = this.intersection(diagnosticPosition, matchBindings.bindingsWhenTrue, matchBindings3.bindingsWhenFalse);
        List<Symbol.BindingSymbol> list5 = this.intersection(diagnosticPosition, matchBindings.bindingsWhenFalse, matchBindings2.bindingsWhenFalse);
        List<Symbol.BindingSymbol> list6 = this.intersection(diagnosticPosition, matchBindings2.bindingsWhenFalse, matchBindings3.bindingsWhenFalse);
        List<Symbol.BindingSymbol> list7 = this.union(diagnosticPosition, list3, list, list2);
        List<Symbol.BindingSymbol> list8 = this.union(diagnosticPosition, list6, list4, list5);
        return new MatchBindings(list7, list8);
    }

    public MatchBindings unary(JCTree jCTree, MatchBindings matchBindings) {
        if (matchBindings == EMPTY || !jCTree.hasTag(JCTree.Tag.NOT)) {
            return matchBindings;
        }
        return new MatchBindings(matchBindings.bindingsWhenFalse, matchBindings.bindingsWhenTrue);
    }

    public MatchBindings binary(JCTree jCTree, MatchBindings matchBindings, MatchBindings matchBindings2) {
        switch (jCTree.getTag()) {
            case AND: {
                return this.andOperation(jCTree.pos(), matchBindings, matchBindings2);
            }
            case OR: {
                List<Symbol.BindingSymbol> list = this.intersection(jCTree.pos(), matchBindings.bindingsWhenTrue, matchBindings2.bindingsWhenTrue);
                List<Symbol.BindingSymbol> list2 = this.union(jCTree.pos(), matchBindings.bindingsWhenFalse, matchBindings2.bindingsWhenFalse);
                return new MatchBindings(list, list2);
            }
        }
        return EMPTY;
    }

    public MatchBindings caseGuard(JCTree.JCCase jCCase, MatchBindings matchBindings, MatchBindings matchBindings2) {
        return this.andOperation(jCCase.pos(), matchBindings, matchBindings2);
    }

    public MatchBindings andOperation(JCDiagnostic.DiagnosticPosition diagnosticPosition, MatchBindings matchBindings, MatchBindings matchBindings2) {
        List<Symbol.BindingSymbol> list = this.union(diagnosticPosition, matchBindings.bindingsWhenTrue, matchBindings2.bindingsWhenTrue);
        List<Symbol.BindingSymbol> list2 = this.intersection(diagnosticPosition, matchBindings.bindingsWhenFalse, matchBindings2.bindingsWhenFalse);
        return new MatchBindings(list, list2);
    }

    public MatchBindings switchCase(JCTree jCTree, MatchBindings matchBindings, MatchBindings matchBindings2) {
        if (matchBindings == null) {
            return matchBindings2;
        }
        if (matchBindings.nullPattern) {
            return matchBindings2;
        }
        if (matchBindings2.nullPattern) {
            return matchBindings;
        }
        return new MatchBindings(this.intersection(jCTree.pos(), matchBindings.bindingsWhenTrue, matchBindings2.bindingsWhenTrue), this.intersection(jCTree.pos(), matchBindings.bindingsWhenFalse, matchBindings2.bindingsWhenFalse));
    }

    public MatchBindings finishBindings(JCTree jCTree, MatchBindings matchBindings) {
        switch (jCTree.getTag()) {
            case AND: 
            case OR: 
            case NOT: 
            case BINDINGPATTERN: 
            case TYPETEST: 
            case PARENS: 
            case RECORDPATTERN: 
            case CONDEXPR: {
                return matchBindings;
            }
        }
        return EMPTY;
    }

    private List<Symbol.BindingSymbol> intersection(JCDiagnostic.DiagnosticPosition diagnosticPosition, List<Symbol.BindingSymbol> list, List<Symbol.BindingSymbol> list2) {
        List<Symbol.BindingSymbol> list3 = List.nil();
        for (Symbol.BindingSymbol bindingSymbol : list) {
            for (Symbol.BindingSymbol bindingSymbol2 : list2) {
                if (bindingSymbol.name != bindingSymbol2.name || (bindingSymbol.flags() & 0x40000000000L) != 0L || (bindingSymbol2.flags() & 0x40000000000L) != 0L) continue;
                this.log.error(diagnosticPosition, CompilerProperties.Errors.MatchBindingExists);
                bindingSymbol2.flags_field |= 0x40000000000L;
                list3 = list3.append(bindingSymbol2);
            }
        }
        return list3;
    }

    @SafeVarargs
    private final List<Symbol.BindingSymbol> union(JCDiagnostic.DiagnosticPosition diagnosticPosition, List<Symbol.BindingSymbol> list, List<Symbol.BindingSymbol> ... listArray) {
        List<Symbol.BindingSymbol> list2 = list;
        for (List<Symbol.BindingSymbol> list3 : listArray) {
            for (Symbol.BindingSymbol bindingSymbol : list3) {
                for (Symbol.BindingSymbol bindingSymbol2 : list2) {
                    if (bindingSymbol2.name != bindingSymbol.name || (bindingSymbol2.flags() & 0x40000000000L) != 0L || (bindingSymbol.flags() & 0x40000000000L) != 0L) continue;
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.MatchBindingExists);
                    bindingSymbol.flags_field |= 0x40000000000L;
                }
                list2 = list2.append(bindingSymbol);
            }
        }
        return list2;
    }

    public static class MatchBindings {
        public final List<Symbol.BindingSymbol> bindingsWhenTrue;
        public final List<Symbol.BindingSymbol> bindingsWhenFalse;
        public final boolean nullPattern;

        public MatchBindings(List<Symbol.BindingSymbol> list, List<Symbol.BindingSymbol> list2) {
            this(list, list2, false);
        }

        public MatchBindings(List<Symbol.BindingSymbol> list, List<Symbol.BindingSymbol> list2, boolean bl) {
            this.bindingsWhenTrue = list;
            this.bindingsWhenFalse = list2;
            this.nullPattern = bl;
        }
    }
}

