/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CaptureScanner;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.comp.TreeDiffer;
import com.sun.tools.javac.comp.TreeHasher;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.InvalidUtfException;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.lang.model.element.ElementKind;

public class LambdaToMethod
extends TreeTranslator {
    private final Attr attr;
    private final JCDiagnostic.Factory diags;
    private final Log log;
    private final Lower lower;
    private final Names names;
    private final Symtab syms;
    private final Resolve rs;
    private final Operators operators;
    private TreeMaker make;
    private final Types types;
    private final TransTypes transTypes;
    private Env<AttrContext> attrEnv;
    private KlassInfo kInfo;
    private LambdaTranslationContext lambdaContext;
    private Symbol.VarSymbol pendingVar;
    private final boolean dumpLambdaToMethodStats;
    private final boolean forceSerializable;
    private final boolean debugLinesOrVars;
    private final boolean verboseDeduplication;
    private final boolean deduplicateLambdas;
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    protected static final Context.Key<LambdaToMethod> unlambdaKey = new Context.Key();

    public static LambdaToMethod instance(Context context) {
        LambdaToMethod lambdaToMethod = context.get(unlambdaKey);
        if (lambdaToMethod == null) {
            lambdaToMethod = new LambdaToMethod(context);
        }
        return lambdaToMethod;
    }

    private LambdaToMethod(Context context) {
        context.put(unlambdaKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.lower = Lower.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.operators = Operators.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.transTypes = TransTypes.instance(context);
        Options options = Options.instance(context);
        this.dumpLambdaToMethodStats = options.isSet("debug.dumpLambdaToMethodStats");
        this.attr = Attr.instance(context);
        this.forceSerializable = options.isSet("forceSerializable");
        boolean bl = options.isUnset(Option.G_CUSTOM) || options.isSet(Option.G_CUSTOM, "lines");
        boolean bl2 = options.isUnset(Option.G_CUSTOM) ? options.isSet(Option.G) : options.isSet(Option.G_CUSTOM, "vars");
        this.debugLinesOrVars = bl || bl2;
        this.verboseDeduplication = options.isSet("debug.dumpLambdaToMethodDeduplication");
        this.deduplicateLambdas = options.getBoolean("deduplicateLambdas", true);
    }

    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
        this.make = treeMaker;
        this.attrEnv = env;
        return this.translate(jCTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        KlassInfo klassInfo = this.kInfo;
        DiagnosticSource diagnosticSource = this.log.currentSource();
        LambdaTranslationContext lambdaTranslationContext = this.lambdaContext;
        Symbol.VarSymbol varSymbol = this.pendingVar;
        try {
            this.kInfo = new KlassInfo(jCClassDecl);
            this.log.useSource(jCClassDecl.sym.sourcefile);
            this.lambdaContext = null;
            this.pendingVar = null;
            super.visitClassDef(jCClassDecl);
            if (lambdaTranslationContext != null) {
                jCClassDecl.sym.owner = lambdaTranslationContext.translatedSym;
            }
            if (!this.kInfo.deserializeCases.isEmpty()) {
                int n = this.make.pos;
                try {
                    this.make.at(jCClassDecl);
                    this.kInfo.addMethod(this.makeDeserializeMethod());
                }
                finally {
                    this.make.at(n);
                }
            }
            List list = this.kInfo.appendedMethodList.toList();
            jCClassDecl.defs = jCClassDecl.defs.appendList(list);
            for (JCTree jCTree : list) {
                jCClassDecl.sym.members().enter(((JCTree.JCMethodDecl)jCTree).sym);
            }
            this.result = jCClassDecl;
        }
        finally {
            this.kInfo = klassInfo;
            this.log.useSource(diagnosticSource.getFile());
            this.lambdaContext = lambdaTranslationContext;
            this.pendingVar = varSymbol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        boolean bl;
        LambdaTranslationContext lambdaTranslationContext = new LambdaTranslationContext(jCLambda);
        Symbol.MethodSymbol methodSymbol = lambdaTranslationContext.translatedSym;
        Type.MethodType methodType = (Type.MethodType)methodSymbol.type;
        Object object2 = jCLambda.owner;
        this.apportionTypeAnnotations(jCLambda, ((Symbol)object2)::getRawTypeAttributes, ((Symbol)object2)::setTypeAttributes, methodSymbol::setTypeAttributes);
        long l = ((Symbol)object2).flags();
        if ((l & 0x100000L) != 0L) {
            Symbol.ClassSymbol object3 = (Symbol.ClassSymbol)((Symbol)object2).owner;
            boolean bl2 = bl = (l & 8L) != 0L;
            this.apportionTypeAnnotations(jCLambda, bl ? object3::getClassInitTypeAttributes : object3::getInitTypeAttributes, bl ? object3::setClassInitTypeAttributes : object3::setInitTypeAttributes, methodSymbol::appendUniqueTypeAttributes);
        }
        if (this.pendingVar != null && this.pendingVar.getKind() == ElementKind.FIELD) {
            this.apportionTypeAnnotations(jCLambda, this.pendingVar::getRawTypeAttributes, this.pendingVar::setTypeAttributes, methodSymbol::appendUniqueTypeAttributes);
        }
        object2 = this.make.MethodDef(this.make.Modifiers(methodSymbol.flags_field), methodSymbol.name, this.make.QualIdent(methodType.getReturnType().tsym), List.nil(), lambdaTranslationContext.syntheticParams, methodType.getThrownTypes() == null ? List.nil() : this.make.Types((List<Type>)methodType.getThrownTypes()), null, null);
        ((JCTree.JCMethodDecl)object2).sym = methodSymbol;
        ((JCTree.JCMethodDecl)object2).type = methodType;
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (!methodSymbol.isStatic()) {
            listBuffer.append(this.makeThis((Type)methodSymbol.owner.enclClass().asType(), jCLambda.owner.enclClass()));
        }
        for (Symbol symbol : lambdaTranslationContext.capturedVars) {
            JCTree.JCExpression jCExpression = this.make.Ident(symbol).setType(symbol.type);
            listBuffer.append(jCExpression);
        }
        List list = this.translate(listBuffer.toList());
        LambdaTranslationContext lambdaTranslationContext2 = this.lambdaContext;
        try {
            this.lambdaContext = lambdaTranslationContext;
            ((JCTree.JCMethodDecl)object2).body = this.translate(this.makeLambdaBody(jCLambda, (JCTree.JCMethodDecl)object2));
        }
        finally {
            this.lambdaContext = lambdaTranslationContext2;
        }
        bl = false;
        if (this.deduplicateLambdas && !this.debugLinesOrVars && !this.isSerializable(jCLambda)) {
            DedupedLambda dedupedLambda = new DedupedLambda(((JCTree.JCMethodDecl)object2).sym, ((JCTree.JCMethodDecl)object2).body);
            DedupedLambda dedupedLambda2 = this.kInfo.dedupedLambdas.putIfAbsent(dedupedLambda, dedupedLambda);
            if (dedupedLambda2 != null) {
                methodSymbol = dedupedLambda2.symbol;
                bl = true;
                if (this.verboseDeduplication) {
                    this.log.note(jCLambda, CompilerProperties.Notes.VerboseL2mDeduplicate(methodSymbol));
                }
            }
        }
        if (!bl) {
            this.kInfo.addMethod((JCTree)object2);
        }
        this.result = this.makeMetafactoryIndyCall(jCLambda, methodSymbol.asHandle(), lambdaTranslationContext.translatedSym, list);
    }

    private void apportionTypeAnnotations(JCTree.JCLambda jCLambda, Supplier<List<Attribute.TypeCompound>> supplier, Consumer<List<Attribute.TypeCompound>> consumer, Consumer<List<Attribute.TypeCompound>> consumer2) {
        ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeCompound : supplier.get()) {
            if (typeCompound.hasUnknownPosition()) {
                typeCompound.tryFixPosition();
            }
            if (typeCompound.position.onLambda == jCLambda) {
                listBuffer2.append(typeCompound);
                continue;
            }
            listBuffer.append(typeCompound);
        }
        if (listBuffer2.nonEmpty()) {
            consumer.accept(listBuffer.toList());
            consumer2.accept(listBuffer2.toList());
        }
    }

    private JCTree.JCIdent makeThis(Type type, Symbol symbol) {
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(0x200001010L, this.names._this, type, symbol);
        return this.make.Ident(varSymbol);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        JCTree.JCExpression jCExpression;
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)jCMemberReference.sym;
        switch (jCMemberReference.kind) {
            default: {
                throw new IllegalStateException(null, null);
            }
            case IMPLICIT_INNER: 
            case SUPER: {
                jCExpression = this.makeThis((Type)jCMemberReference.owner.enclClass().asType(), jCMemberReference.owner.enclClass());
                break;
            }
            case BOUND: {
                jCExpression = this.attr.makeNullCheck(this.transTypes.coerce(this.attrEnv, jCMemberReference.getQualifierExpression(), this.types.erasure(jCMemberReference.sym.owner.type)));
                break;
            }
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                jCExpression = null;
            }
        }
        JCTree.JCIdent jCIdent = jCExpression;
        List<JCTree.JCExpression> list = jCIdent == null ? List.nil() : this.translate(List.of(jCIdent));
        this.result = this.makeMetafactoryIndyCall(jCMemberReference, methodSymbol.asHandle(), methodSymbol, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        if (this.lambdaContext == null) {
            super.visitIdent(jCIdent);
        } else {
            int n = this.make.pos;
            try {
                this.make.at(jCIdent);
                JCTree jCTree = this.lambdaContext.translate(jCIdent);
                if (jCTree != null) {
                    this.result = jCTree;
                } else {
                    super.visitIdent(jCIdent);
                }
            }
            finally {
                this.make.at(n);
            }
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        Symbol.VarSymbol varSymbol = this.pendingVar;
        try {
            this.pendingVar = jCVariableDecl.sym;
            if (this.lambdaContext != null) {
                jCVariableDecl.sym = this.lambdaContext.addLocal(jCVariableDecl.sym);
                jCVariableDecl.init = this.translate(jCVariableDecl.init);
                this.result = jCVariableDecl;
            } else {
                super.visitVarDef(jCVariableDecl);
            }
        }
        finally {
            this.pendingVar = varSymbol;
        }
    }

    private JCTree.JCBlock makeLambdaBody(JCTree.JCLambda jCLambda, JCTree.JCMethodDecl jCMethodDecl) {
        return jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION ? this.makeLambdaExpressionBody((JCTree.JCExpression)jCLambda.body, jCMethodDecl) : this.makeLambdaStatementBody((JCTree.JCBlock)jCLambda.body, jCMethodDecl, jCLambda.canCompleteNormally);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCBlock makeLambdaExpressionBody(JCTree.JCExpression jCExpression, JCTree.JCMethodDecl jCMethodDecl) {
        Type type = jCMethodDecl.type.getReturnType();
        boolean bl = jCExpression.type.hasTag(TypeTag.VOID);
        boolean bl2 = type.hasTag(TypeTag.VOID);
        boolean bl3 = this.types.isSameType(type, this.types.boxedClass((Type)this.syms.voidType).type);
        int n = this.make.pos;
        try {
            if (bl2) {
                JCTree.JCExpressionStatement jCExpressionStatement = this.make.at(jCExpression).Exec(jCExpression);
                JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(jCExpressionStatement));
                return jCBlock;
            }
            if (bl && bl3) {
                ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
                listBuffer.append(this.make.at(jCExpression).Exec(jCExpression));
                listBuffer.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
                JCTree.JCBlock jCBlock = this.make.Block(0L, listBuffer.toList());
                return jCBlock;
            }
            JCTree.JCBlock jCBlock = this.make.at(jCExpression).Block(0L, List.of(this.make.Return(jCExpression)));
            return jCBlock;
        }
        finally {
            this.make.at(n);
        }
    }

    private JCTree.JCBlock makeLambdaStatementBody(JCTree.JCBlock jCBlock, final JCTree.JCMethodDecl jCMethodDecl, boolean bl) {
        Type type = jCMethodDecl.type.getReturnType();
        final boolean bl2 = type.hasTag(TypeTag.VOID);
        boolean bl3 = this.types.isSameType(type, this.types.boxedClass((Type)this.syms.voidType).type);
        class LambdaBodyTranslator
        extends TreeTranslator {
            LambdaBodyTranslator() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                this.result = jCClassDecl;
            }

            @Override
            public void visitLambda(JCTree.JCLambda jCLambda) {
                this.result = jCLambda;
            }

            @Override
            public void visitReturn(JCTree.JCReturn jCReturn) {
                boolean bl;
                boolean bl22 = bl = jCReturn.expr == null;
                if (bl2 && !bl) {
                    Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(4096L, LambdaToMethod.this.names.fromString("$loc"), jCReturn.expr.type, jCMethodDecl.sym);
                    JCTree.JCVariableDecl jCVariableDecl = LambdaToMethod.this.make.VarDef(varSymbol, jCReturn.expr);
                    this.result = LambdaToMethod.this.make.Block(0L, List.of(jCVariableDecl, LambdaToMethod.this.make.Return(null)));
                } else {
                    this.result = jCReturn;
                }
            }
        }
        JCTree.JCBlock jCBlock2 = new LambdaBodyTranslator().translate(jCBlock);
        if (bl && bl3) {
            jCBlock2.stats = jCBlock2.stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
        }
        return jCBlock2;
    }

    private JCTree.JCMethodDecl makeDeserializeMethod() {
        JCTree jCTree2;
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        ListBuffer<JCTree.JCBreak> listBuffer2 = new ListBuffer<JCTree.JCBreak>();
        for (Map.Entry object2 : this.kInfo.deserializeCases.entrySet()) {
            jCTree2 = this.make.Break(null);
            listBuffer2.add((JCTree.JCBreak)jCTree2);
            List<JCTree.JCStatement> list = ((ListBuffer)object2.getValue()).append(jCTree2).toList();
            listBuffer.add(this.make.Case(JCTree.JCCase.STATEMENT, List.of(this.make.ConstantCaseLabel(this.make.Literal(object2.getKey()))), null, list, null));
        }
        JCTree.JCSwitch jCSwitch = this.make.Switch(this.deserGetter("getImplMethodName", this.syms.stringType), listBuffer.toList());
        for (JCTree jCTree2 : listBuffer2) {
            jCTree2.target = jCSwitch;
        }
        JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(jCSwitch, this.make.Throw(this.makeNewClass(this.syms.illegalArgumentExceptionType, List.of(this.make.Literal("Invalid lambda deserialization"))))));
        jCTree2 = this.make.MethodDef(this.make.Modifiers(this.kInfo.deserMethodSym.flags()), this.names.deserializeLambda, this.make.QualIdent(((KlassInfo)this.kInfo).deserMethodSym.getReturnType().tsym), List.nil(), List.of(this.make.VarDef(this.kInfo.deserParamSym, null)), List.nil(), jCBlock, null);
        ((JCTree.JCMethodDecl)jCTree2).sym = this.kInfo.deserMethodSym;
        ((JCTree.JCMethodDecl)jCTree2).type = ((KlassInfo)this.kInfo).deserMethodSym.type;
        return this.lower.translateMethod(this.attrEnv, (JCTree.JCMethodDecl)jCTree2, this.make);
    }

    JCTree.JCNewClass makeNewClass(Type type, List<JCTree.JCExpression> list, Symbol symbol) {
        JCTree.JCNewClass jCNewClass = this.make.NewClass(null, null, this.make.QualIdent(type.tsym), list, null);
        jCNewClass.constructor = symbol;
        jCNewClass.type = type;
        return jCNewClass;
    }

    JCTree.JCNewClass makeNewClass(Type type, List<JCTree.JCExpression> list) {
        return this.makeNewClass(type, list, this.rs.resolveConstructor(null, this.attrEnv, type, TreeInfo.types(list), List.nil()));
    }

    private void addDeserializationCase(Symbol.MethodHandleSymbol methodHandleSymbol, Type type, Symbol.MethodSymbol methodSymbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, List<PoolConstant.LoadableConstant> list, Type.MethodType methodType) {
        ListBuffer listBuffer3;
        Symbol symbol;
        String string = this.classSig(type);
        String string2 = ((Name)methodSymbol.getSimpleName()).toString();
        String string3 = this.typeSig(this.types.erasure(methodSymbol.type));
        Symbol symbol2 = methodHandleSymbol.baseSymbol();
        if (symbol2 != (symbol = symbol2.baseSymbol()) && symbol.owner == this.syms.objectType.tsym) {
            methodHandleSymbol = ((Symbol.MethodSymbol)symbol).asHandle();
        }
        String string4 = this.classSig(this.types.erasure(methodHandleSymbol.owner.type));
        String string5 = methodHandleSymbol.getQualifiedName().toString();
        String string6 = this.typeSig(this.types.erasure(methodHandleSymbol.type));
        JCTree.JCExpression jCExpression = this.eqTest(this.syms.intType, this.deserGetter("getImplMethodKind", this.syms.intType), this.make.Literal(methodHandleSymbol.referenceKind()));
        ListBuffer<JCTree.JCTypeCast> listBuffer2 = new ListBuffer<JCTree.JCTypeCast>();
        int n = 0;
        for (ListBuffer listBuffer3 : methodType.getParameterTypes()) {
            List<JCTree.JCExpression> list2 = new ListBuffer<JCTree.JCLiteral>().append(this.make.Literal(n)).toList();
            List<Type> list3 = new ListBuffer<Type.JCPrimitiveType>().append(this.syms.intType).toList();
            listBuffer2.add(this.make.TypeCast(this.types.erasure((Type)((Object)listBuffer3)), this.deserGetter("getCapturedArg", this.syms.objectType, list3, list2)));
            ++n;
        }
        JCTree.JCIf jCIf = this.make.If(this.deserTest(this.deserTest(this.deserTest(this.deserTest(this.deserTest(jCExpression, "getFunctionalInterfaceClass", string), "getFunctionalInterfaceMethodName", string2), "getFunctionalInterfaceMethodSignature", string3), "getImplClass", string4), "getImplMethodSignature", string6), this.make.Return(this.makeIndyCall(diagnosticPosition, this.syms.lambdaMetafactory, this.names.altMetafactory, list, methodType, listBuffer2.toList(), methodSymbol.name)), null);
        listBuffer3 = (ListBuffer)this.kInfo.deserializeCases.get(string5);
        if (listBuffer3 == null) {
            listBuffer3 = new ListBuffer();
            this.kInfo.deserializeCases.put(string5, listBuffer3);
        }
        listBuffer3.append(jCIf);
    }

    private JCTree.JCExpression eqTest(Type type, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        JCTree.JCBinary jCBinary = this.make.Binary(JCTree.Tag.EQ, jCExpression, jCExpression2);
        jCBinary.operator = this.operators.resolveBinary(jCBinary, JCTree.Tag.EQ, type, type);
        jCBinary.setType(this.syms.booleanType);
        return jCBinary;
    }

    private JCTree.JCExpression deserTest(JCTree.JCExpression jCExpression, String string, String string2) {
        Type.MethodType methodType = new Type.MethodType(List.of(this.syms.objectType), this.syms.booleanType, List.nil(), this.syms.methodClass);
        Symbol symbol = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.objectType, this.names.equals, List.of(this.syms.objectType), List.nil());
        JCTree.JCMethodInvocation jCMethodInvocation = this.make.Apply(List.nil(), this.make.Select(this.deserGetter(string, this.syms.stringType), symbol).setType(methodType), List.of(this.make.Literal(string2)));
        jCMethodInvocation.setType(this.syms.booleanType);
        JCTree.JCBinary jCBinary = this.make.Binary(JCTree.Tag.AND, jCExpression, jCMethodInvocation);
        jCBinary.operator = this.operators.resolveBinary(jCBinary, JCTree.Tag.AND, this.syms.booleanType, this.syms.booleanType);
        jCBinary.setType(this.syms.booleanType);
        return jCBinary;
    }

    private JCTree.JCExpression deserGetter(String string, Type type) {
        return this.deserGetter(string, type, List.nil(), List.nil());
    }

    private JCTree.JCExpression deserGetter(String string, Type type, List<Type> list, List<JCTree.JCExpression> list2) {
        Type.MethodType methodType = new Type.MethodType(list, type, List.nil(), this.syms.methodClass);
        Symbol symbol = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.serializedLambdaType, this.names.fromString(string), list, List.nil());
        return this.make.Apply(List.nil(), this.make.Select(this.make.Ident(this.kInfo.deserParamSym).setType(this.syms.serializedLambdaType), symbol).setType(methodType), list2).setType(type);
    }

    private Symbol.MethodSymbol makePrivateSyntheticMethod(long l, Name name, Type type, Symbol symbol) {
        return new Symbol.MethodSymbol(l | 0x1000L | 2L, name, type, symbol);
    }

    private Type.MethodType typeToMethodType(Type type) {
        Type type2 = this.types.erasure(type);
        return new Type.MethodType(type2.getParameterTypes(), type2.getReturnType(), type2.getThrownTypes(), this.syms.methodClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeMetafactoryIndyCall(JCTree.JCFunctionalExpression jCFunctionalExpression, Symbol.MethodHandleSymbol methodHandleSymbol, Symbol.MethodSymbol methodSymbol, List<JCTree.JCExpression> list) {
        Name name;
        Symbol.MethodSymbol methodSymbol2 = (Symbol.MethodSymbol)this.types.findDescriptorSymbol(jCFunctionalExpression.target.tsym);
        List<PoolConstant.LoadableConstant> list2 = List.of(this.typeToMethodType(methodSymbol2.type), methodHandleSymbol.asHandle(), this.typeToMethodType(jCFunctionalExpression.getDescriptorType(this.types)));
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (JCTree.JCExpression object2 : list) {
            listBuffer.append(object2.type);
        }
        Type.MethodType methodType = new Type.MethodType(listBuffer.toList(), jCFunctionalExpression.type, List.nil(), this.syms.methodClass);
        List<Symbol> list3 = this.bridges(jCFunctionalExpression);
        boolean bl = this.isSerializable(jCFunctionalExpression);
        boolean bl2 = jCFunctionalExpression.target.isIntersection() || bl || list3.length() > 1;
        this.dumpStats(jCFunctionalExpression, bl2, methodSymbol);
        Name name2 = name = bl2 ? this.names.altMetafactory : this.names.metafactory;
        if (bl2) {
            ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
            List<Type> list4 = jCFunctionalExpression.target.isIntersection() ? this.types.directSupertypes(jCFunctionalExpression.target) : List.nil();
            for (Type bl3 : list4) {
                bl3 = this.types.erasure(bl3);
                if (bl3.tsym == this.syms.serializableType.tsym || bl3.tsym == jCFunctionalExpression.type.tsym || bl3.tsym == this.syms.objectType.tsym) continue;
                listBuffer2.append(bl3);
            }
            int n = bl ? 1 : 0;
            boolean bl3 = listBuffer2.nonEmpty();
            boolean bl4 = list3.nonEmpty();
            if (bl3) {
                n |= 2;
            }
            if (bl4) {
                n |= 4;
            }
            list2 = list2.append(PoolConstant.LoadableConstant.Int(n));
            if (bl3) {
                list2 = list2.append(PoolConstant.LoadableConstant.Int(listBuffer2.length()));
                list2 = list2.appendList(List.convert(PoolConstant.LoadableConstant.class, listBuffer2.toList()));
            }
            if (bl4) {
                list2 = list2.append(PoolConstant.LoadableConstant.Int(list3.length() - 1));
                for (Symbol symbol : list3) {
                    Type type = symbol.erasure(this.types);
                    if (this.types.isSameType(type, methodSymbol2.erasure(this.types))) continue;
                    list2 = list2.append((Type.MethodType)symbol.erasure(this.types));
                }
            }
            if (bl) {
                int n2 = this.make.pos;
                try {
                    this.make.at(this.kInfo.clazz);
                    this.addDeserializationCase(methodHandleSymbol, jCFunctionalExpression.type, methodSymbol2, jCFunctionalExpression, list2, methodType);
                }
                finally {
                    this.make.at(n2);
                }
            }
        }
        return this.makeIndyCall(jCFunctionalExpression, this.syms.lambdaMetafactory, name, list2, methodType, list, methodSymbol2.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeIndyCall(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, List<PoolConstant.LoadableConstant> list, Type.MethodType methodType, List<JCTree.JCExpression> list2, Name name2) {
        int n = this.make.pos;
        try {
            this.make.at(diagnosticPosition);
            List<Type> list3 = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).appendList(list.map(this.types::constantType));
            Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.attrEnv, type, name, list3, List.nil());
            Symbol.DynamicMethodSymbol dynamicMethodSymbol = new Symbol.DynamicMethodSymbol(name2, this.syms.noSymbol, methodSymbol.asHandle(), (Type)methodType, list.toArray(new PoolConstant.LoadableConstant[list.length()]));
            JCTree.JCFieldAccess jCFieldAccess = this.make.Select(this.make.QualIdent(type.tsym), name);
            Symbol.DynamicMethodSymbol dynamicMethodSymbol2 = this.kInfo.dynMethSyms.putIfAbsent(dynamicMethodSymbol.poolKey(this.types), dynamicMethodSymbol);
            jCFieldAccess.sym = dynamicMethodSymbol2 != null ? dynamicMethodSymbol2 : dynamicMethodSymbol;
            jCFieldAccess.type = methodType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation = this.make.Apply(List.nil(), jCFieldAccess, list2);
            jCMethodInvocation.type = methodType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation2 = jCMethodInvocation;
            return jCMethodInvocation2;
        }
        finally {
            this.make.at(n);
        }
    }

    List<Symbol> bridges(JCTree.JCFunctionalExpression jCFunctionalExpression) {
        Symbol.ClassSymbol classSymbol = this.types.makeFunctionalInterfaceClass(this.attrEnv, this.names.empty, jCFunctionalExpression.target, 1536L);
        return this.types.functionalInterfaceBridges(classSymbol);
    }

    boolean isSerializable(JCTree.JCFunctionalExpression jCFunctionalExpression) {
        if (this.forceSerializable) {
            return true;
        }
        return this.types.asSuper(jCFunctionalExpression.target, this.syms.serializableType.tsym) != null;
    }

    void dumpStats(JCTree.JCFunctionalExpression jCFunctionalExpression, boolean bl, Symbol symbol) {
        if (this.dumpLambdaToMethodStats) {
            if (jCFunctionalExpression instanceof JCTree.JCLambda) {
                JCTree.JCLambda jCLambda = (JCTree.JCLambda)jCFunctionalExpression;
                this.log.note(jCFunctionalExpression, this.diags.noteKey(jCLambda.wasMethodReference ? "mref.stat.1" : "lambda.stat", bl, symbol));
            } else if (jCFunctionalExpression instanceof JCTree.JCMemberReference) {
                this.log.note(jCFunctionalExpression, CompilerProperties.Notes.MrefStat(bl, null));
            }
        }
    }

    private String typeSig(Type type) {
        return this.typeSig(type, false);
    }

    private String typeSig(Type type, boolean bl) {
        try {
            L2MSignatureGenerator l2MSignatureGenerator = new L2MSignatureGenerator(bl);
            l2MSignatureGenerator.assembleSig(type);
            return l2MSignatureGenerator.toString();
        }
        catch (Types.SignatureGenerator.InvalidSignatureException invalidSignatureException) {
            Symbol.ClassSymbol classSymbol = this.attrEnv.enclClass.sym;
            this.log.error(CompilerProperties.Errors.CannotGenerateClass(classSymbol, CompilerProperties.Fragments.IllegalSignature(classSymbol, invalidSignatureException.type())));
            return "<ERRONEOUS>";
        }
    }

    private String classSig(Type type) {
        try {
            L2MSignatureGenerator l2MSignatureGenerator = new L2MSignatureGenerator(false);
            l2MSignatureGenerator.assembleClassSig(type);
            return l2MSignatureGenerator.toString();
        }
        catch (Types.SignatureGenerator.InvalidSignatureException invalidSignatureException) {
            Symbol.ClassSymbol classSymbol = this.attrEnv.enclClass.sym;
            this.log.error(CompilerProperties.Errors.CannotGenerateClass(classSymbol, CompilerProperties.Fragments.IllegalSignature(classSymbol, invalidSignatureException.type())));
            return "<ERRONEOUS>";
        }
    }

    private class KlassInfo {
        private ListBuffer<JCTree> appendedMethodList = new ListBuffer();
        private final Map<DedupedLambda, DedupedLambda> dedupedLambdas = new HashMap<DedupedLambda, DedupedLambda>();
        private final Map<Object, Symbol.DynamicMethodSymbol> dynMethSyms = new HashMap<Object, Symbol.DynamicMethodSymbol>();
        private final Map<String, ListBuffer<JCTree.JCStatement>> deserializeCases = new HashMap<String, ListBuffer<JCTree.JCStatement>>();
        private final Symbol.MethodSymbol deserMethodSym;
        private final Symbol.VarSymbol deserParamSym;
        private final JCTree.JCClassDecl clazz;
        private final Map<String, Integer> syntheticNames = new HashMap<String, Integer>();

        private KlassInfo(JCTree.JCClassDecl jCClassDecl) {
            this.clazz = jCClassDecl;
            Type.MethodType methodType = new Type.MethodType(List.of(((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType), ((LambdaToMethod)LambdaToMethod.this).syms.objectType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass);
            this.deserMethodSym = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.deserializeLambda, methodType, jCClassDecl.sym);
            this.deserParamSym = new Symbol.VarSymbol(16L, LambdaToMethod.this.names.fromString("lambda"), ((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType, this.deserMethodSym);
        }

        private void addMethod(JCTree jCTree) {
            this.appendedMethodList = this.appendedMethodList.prepend(jCTree);
        }

        int syntheticNameIndex(StringBuilder stringBuilder, int n) {
            String string = stringBuilder.toString();
            Integer n2 = this.syntheticNames.get(string);
            if (n2 == null) {
                n2 = n;
            }
            this.syntheticNames.put(string, n2 + 1);
            return n2;
        }
    }

    class LambdaTranslationContext {
        final JCTree.JCFunctionalExpression tree;
        final Map<Symbol.VarSymbol, Symbol.VarSymbol> lambdaProxies = new HashMap<Symbol.VarSymbol, Symbol.VarSymbol>();
        final List<Symbol.VarSymbol> capturedVars;
        final Symbol.MethodSymbol translatedSym;
        final List<JCTree.JCVariableDecl> syntheticParams;

        LambdaTranslationContext(JCTree.JCLambda jCLambda) {
            Symbol.VarSymbol varSymbol;
            Object object;
            this.tree = jCLambda;
            Symbol symbol = jCLambda.owner;
            if (symbol.kind == Kinds.Kind.MTH) {
                object = (Symbol.MethodSymbol)symbol.clone(symbol.owner);
                this.translatedSym = new Symbol.MethodSymbol(0L, null, null, symbol.enclClass(), (Symbol.MethodSymbol)object){
                    final /* synthetic */ Symbol.MethodSymbol val$originalOwner;
                    {
                        this.val$originalOwner = methodSymbol;
                        super(l, name, type, symbol);
                    }

                    @Override
                    public Symbol.MethodSymbol originalEnclosingMethod() {
                        return this.val$originalOwner;
                    }
                };
            } else {
                this.translatedSym = LambdaToMethod.this.makePrivateSyntheticMethod(0L, null, null, symbol.enclClass());
            }
            object = new ListBuffer();
            ListBuffer<Symbol.VarSymbol> listBuffer = new ListBuffer<Symbol.VarSymbol>();
            LambdaCaptureScanner lambdaCaptureScanner = new LambdaCaptureScanner(jCLambda);
            this.capturedVars = lambdaCaptureScanner.analyzeCaptures();
            for (Symbol.VarSymbol object2 : this.capturedVars) {
                varSymbol = this.addSymbol(object2, LambdaSymbolKind.CAPTURED_VAR);
                ((ListBuffer)object).append(LambdaToMethod.this.make.VarDef(varSymbol, null));
                listBuffer.add(varSymbol);
            }
            for (JCTree.JCVariableDecl jCVariableDecl : jCLambda.params) {
                varSymbol = this.addSymbol(jCVariableDecl.sym, LambdaSymbolKind.PARAM);
                ((ListBuffer)object).append(LambdaToMethod.this.make.VarDef(varSymbol, null));
                listBuffer.add(varSymbol);
            }
            this.syntheticParams = ((ListBuffer)object).toList();
            this.completeLambdaMethodSymbol(symbol, lambdaCaptureScanner.capturesThis);
            this.translatedSym.params = listBuffer.toList();
        }

        void completeLambdaMethodSymbol(Symbol symbol, boolean bl) {
            boolean bl2 = symbol.enclClass().isInterface();
            Name name = LambdaToMethod.this.isSerializable(this.tree) ? this.serializedLambdaName(symbol) : this.lambdaName(symbol);
            Type type = LambdaToMethod.this.types.createMethodTypeWithParameters(this.generatedLambdaSig(), TreeInfo.types(this.syntheticParams));
            long l = 0x2000000001000L | symbol.flags_field & 0x800L | symbol.owner.flags_field & 0x800L | 2L | (bl ? (bl2 ? 0x80000000000L : 0L) : 8L);
            this.translatedSym.type = type;
            this.translatedSym.name = name;
            this.translatedSym.flags_field = l;
        }

        private String serializedLambdaDisambiguation(Symbol symbol) {
            StringBuilder stringBuilder = new StringBuilder();
            Assert.check(symbol.type != null || LambdaToMethod.this.lambdaContext != null);
            if (symbol.type != null) {
                stringBuilder.append(LambdaToMethod.this.typeSig(symbol.type, true));
                stringBuilder.append(":");
            }
            stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)this.tree.type.tsym).owner.flatName());
            stringBuilder.append(" ");
            if (LambdaToMethod.this.pendingVar != null) {
                stringBuilder.append(LambdaToMethod.this.pendingVar.flatName());
                stringBuilder.append("=");
            }
            for (Symbol symbol2 : this.capturedVars) {
                if (symbol2 == symbol) continue;
                stringBuilder.append(LambdaToMethod.this.typeSig(symbol2.type, true));
                stringBuilder.append(" ");
                stringBuilder.append(symbol2.flatName());
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }

        private Name lambdaName(Symbol symbol) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
            stringBuilder.append(this.syntheticMethodNameComponent(symbol));
            stringBuilder.append("$");
            stringBuilder.append(LambdaToMethod.this.kInfo.syntheticNameIndex(stringBuilder, 0));
            return LambdaToMethod.this.names.fromString(stringBuilder.toString());
        }

        String syntheticMethodNameComponent(Symbol symbol) {
            long l = symbol.flags();
            if ((l & 0x100000L) != 0L) {
                return (l & 8L) != 0L ? "static" : "new";
            }
            if (symbol.isConstructor()) {
                return "new";
            }
            return symbol.name.toString();
        }

        private Name serializedLambdaName(Symbol symbol) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
            stringBuilder.append(this.syntheticMethodNameComponent(symbol));
            stringBuilder.append('$');
            String string = this.serializedLambdaDisambiguation(symbol);
            stringBuilder.append(Integer.toHexString(string.hashCode()));
            stringBuilder.append('$');
            stringBuilder.append(LambdaToMethod.this.kInfo.syntheticNameIndex(stringBuilder, 1));
            String string2 = stringBuilder.toString();
            return LambdaToMethod.this.names.fromString(string2);
        }

        Symbol.VarSymbol translate(Symbol.VarSymbol varSymbol, LambdaSymbolKind lambdaSymbolKind) {
            Symbol.VarSymbol varSymbol2;
            boolean bl = true;
            switch (lambdaSymbolKind.ordinal()) {
                case 2: {
                    Name name = (varSymbol.flags() & 0x2000000000000L) != 0L ? varSymbol.baseSymbol().name : varSymbol.name;
                    varSymbol2 = new Symbol.VarSymbol(0x200001010L, name, LambdaToMethod.this.types.erasure(varSymbol.type), this.translatedSym);
                    bl = false;
                    break;
                }
                case 1: {
                    varSymbol2 = new Symbol.VarSymbol(varSymbol.flags() & 0x10L, varSymbol.name, varSymbol.type, this.translatedSym);
                    varSymbol2.pos = varSymbol.pos;
                    if (!varSymbol.isExceptionParameter()) break;
                    varSymbol2.setData((Object)ElementKind.EXCEPTION_PARAMETER);
                    break;
                }
                case 0: {
                    varSymbol2 = new Symbol.VarSymbol(varSymbol.flags() & 0x10L | 0x200000000L, varSymbol.name, LambdaToMethod.this.types.erasure(varSymbol.type), this.translatedSym);
                    varSymbol2.pos = varSymbol.pos;
                    break;
                }
                default: {
                    Assert.error(lambdaSymbolKind.name());
                    throw new AssertionError();
                }
            }
            if (varSymbol2 != varSymbol && bl) {
                varSymbol2.setDeclarationAttributes(varSymbol.getRawAttributes());
                varSymbol2.setTypeAttributes(varSymbol.getRawTypeAttributes());
            }
            return varSymbol2;
        }

        Symbol.VarSymbol addLocal(Symbol.VarSymbol varSymbol) {
            return this.addSymbol(varSymbol, LambdaSymbolKind.LOCAL_VAR);
        }

        private Symbol.VarSymbol addSymbol(Symbol.VarSymbol varSymbol2, LambdaSymbolKind lambdaSymbolKind) {
            return this.lambdaProxies.computeIfAbsent(varSymbol2, varSymbol -> this.translate((Symbol.VarSymbol)varSymbol, lambdaSymbolKind));
        }

        JCTree translate(JCTree.JCIdent jCIdent) {
            Symbol symbol = this.lambdaProxies.get(jCIdent.sym);
            return symbol != null ? LambdaToMethod.this.make.Ident(symbol).setType(jCIdent.type) : null;
        }

        Type generatedLambdaSig() {
            return LambdaToMethod.this.types.erasure(this.tree.getDescriptorType(LambdaToMethod.this.types));
        }

        class LambdaCaptureScanner
        extends CaptureScanner {
            boolean capturesThis;
            Set<Symbol.ClassSymbol> seenClasses;

            LambdaCaptureScanner(JCTree.JCLambda jCLambda) {
                super(jCLambda);
                this.seenClasses = new HashSet<Symbol.ClassSymbol>();
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
                this.seenClasses.add(jCClassDecl.sym);
                super.visitClassDef(jCClassDecl);
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                if (!(jCIdent.sym.isStatic() || jCIdent.sym.owner.kind != Kinds.Kind.TYP || jCIdent.sym.kind != Kinds.Kind.VAR && jCIdent.sym.kind != Kinds.Kind.MTH || this.seenClasses.contains(jCIdent.sym.owner))) {
                    if ((jCIdent.sym.flags() & 0x2000000000000L) != 0L) {
                        this.addFreeVar((Symbol.VarSymbol)jCIdent.sym);
                    } else {
                        this.capturesThis = true;
                    }
                } else {
                    super.visitIdent(jCIdent);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                if (!(jCFieldAccess.sym.kind != Kinds.Kind.VAR || jCFieldAccess.sym.name != ((LambdaToMethod)LambdaToMethod.this).names._this && jCFieldAccess.sym.name != ((LambdaToMethod)LambdaToMethod.this).names._super || this.seenClasses.contains(jCFieldAccess.sym.type.tsym))) {
                    this.capturesThis = true;
                }
                super.visitSelect(jCFieldAccess);
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
            }
        }

        static enum LambdaSymbolKind {
            PARAM,
            LOCAL_VAR,
            CAPTURED_VAR;

        }
    }

    class DedupedLambda {
        private final Symbol.MethodSymbol symbol;
        private final JCTree tree;
        private int hashCode;

        DedupedLambda(Symbol.MethodSymbol methodSymbol, JCTree jCTree) {
            this.symbol = methodSymbol;
            this.tree = jCTree;
        }

        public int hashCode() {
            int n = this.hashCode;
            if (n == 0) {
                this.hashCode = n = TreeHasher.hash(LambdaToMethod.this.types, this.tree, this.symbol.params());
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof DedupedLambda)) return false;
            DedupedLambda dedupedLambda = (DedupedLambda)object;
            if (!LambdaToMethod.this.types.isSameType((Type)this.symbol.asType(), (Type)dedupedLambda.symbol.asType())) return false;
            if (!new TreeDiffer(LambdaToMethod.this.types, this.symbol.params(), dedupedLambda.symbol.params()).scan(this.tree, dedupedLambda.tree)) return false;
            return true;
        }
    }

    private class L2MSignatureGenerator
    extends Types.SignatureGenerator {
        StringBuilder sb = new StringBuilder();
        boolean allowIllegalSignatures;

        L2MSignatureGenerator(boolean bl) {
            this.allowIllegalSignatures = bl;
        }

        @Override
        protected void reportIllegalSignature(Type type) {
            if (!this.allowIllegalSignatures) {
                super.reportIllegalSignature(type);
            }
        }

        @Override
        protected void append(char c) {
            this.sb.append(c);
        }

        @Override
        protected void append(byte[] byArray) {
            Name name;
            try {
                name = LambdaToMethod.this.names.fromUtf(byArray);
            }
            catch (InvalidUtfException invalidUtfException) {
                throw new AssertionError((Object)invalidUtfException);
            }
            this.sb.append(name.toString());
        }

        @Override
        protected void append(Name name) {
            this.sb.append(name.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

