/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Warner;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class InferenceContext {
    List<Type> undetvars;
    List<Type> inferencevars;
    Map<Infer.FreeTypeListener, List<Type>> freeTypeListeners = new LinkedHashMap<Infer.FreeTypeListener, List<Type>>();
    Types types;
    Infer infer;
    InferenceContext parentIC;
    Types.TypeMapping<Void> asTypeVarFun = new Type.StructuralTypeMapping<Void>(){

        @Override
        public Type visitUndetVar(Type.UndetVar undetVar, Void void_) {
            return undetVar.qtype;
        }
    };
    Map<JCTree, Type> captureTypeCache = new LinkedHashMap<JCTree, Type>();

    Type update(Type type) {
        return type;
    }

    public InferenceContext(Infer infer, List<Type> list) {
        this(infer, list, list.map(infer.fromTypeVarFun));
    }

    public InferenceContext(Infer infer, List<Type> list, List<Type> list2) {
        this.inferencevars = list;
        this.undetvars = list2;
        this.infer = infer;
        this.types = infer.types;
    }

    void addVar(Type.TypeVar typeVar) {
        this.undetvars = this.undetvars.prepend(this.infer.fromTypeVarFun.apply(typeVar));
        this.inferencevars = this.inferencevars.prepend(typeVar);
    }

    List<Type> inferenceVars() {
        return this.inferencevars;
    }

    public List<Type> undetVars() {
        return this.undetvars;
    }

    List<Type> restvars() {
        return this.filterVars(undetVar -> undetVar.getInst() == null);
    }

    List<Type> instvars() {
        return this.filterVars(undetVar -> undetVar.getInst() != null);
    }

    final List<Type> boundedVars() {
        return this.filterVars(undetVar -> undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).diff(undetVar.getDeclaredBounds()).appendList(undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)).nonEmpty());
    }

    private List<Type> filterVars(Predicate<Type.UndetVar> predicate) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : this.undetvars) {
            Type.UndetVar undetVar = (Type.UndetVar)type;
            if (!predicate.test(undetVar)) continue;
            listBuffer.append(undetVar.qtype);
        }
        return listBuffer.toList();
    }

    final boolean free(Type type) {
        return type.containsAny(this.inferencevars);
    }

    final boolean free(List<Type> list) {
        for (Type type : list) {
            if (!this.free(type)) continue;
            return true;
        }
        return false;
    }

    final List<Type> freeVarsIn(Type type) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type2 : this.inferenceVars()) {
            if (!type.contains(type2)) continue;
            listBuffer.add(type2);
        }
        return listBuffer.toList();
    }

    final List<Type> freeVarsIn(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type object : list) {
            listBuffer.appendList(this.freeVarsIn(object));
        }
        ListBuffer listBuffer2 = new ListBuffer();
        for (Type type : listBuffer) {
            if (listBuffer2.contains(type)) continue;
            listBuffer2.add(type);
        }
        return listBuffer2.toList();
    }

    public final Type asUndetVar(Type type) {
        return this.types.subst(type, this.inferencevars, this.undetvars);
    }

    final List<Type> asUndetVars(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            listBuffer.append(this.asUndetVar(type));
        }
        return listBuffer.toList();
    }

    public final Type asTypeVar(Type type) {
        return this.asTypeVarFun.apply(type);
    }

    List<Type> instTypes() {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : this.undetvars) {
            Type.UndetVar undetVar = (Type.UndetVar)type;
            listBuffer.append(undetVar.getInst() != null ? undetVar.getInst() : undetVar.qtype);
        }
        return listBuffer.toList();
    }

    Type asInstType(Type type) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
        listBuffer.addAll((Collection<Type>)this.inferencevars);
        listBuffer2.addAll((Collection<Type>)this.instTypes());
        InferenceContext inferenceContext = this.parentIC;
        while (inferenceContext != null) {
            listBuffer.addAll((Collection<Type>)inferenceContext.inferencevars);
            listBuffer2.addAll((Collection<Type>)inferenceContext.instTypes());
            inferenceContext = inferenceContext.parentIC;
        }
        return this.types.subst(type, listBuffer.toList(), listBuffer2.toList());
    }

    List<Type> asInstTypes(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            listBuffer.append(this.asInstType(type));
        }
        return listBuffer.toList();
    }

    void addFreeTypeListener(List<Type> list, Infer.FreeTypeListener freeTypeListener) {
        this.freeTypeListeners.put(freeTypeListener, this.freeVarsIn(list));
    }

    void notifyChange() {
        this.notifyChange(this.inferencevars.diff(this.restvars()));
    }

    void notifyChange(List<Type> list) {
        Infer.InferenceException inferenceException = null;
        for (Map.Entry<Infer.FreeTypeListener, List<Type>> entry : new LinkedHashMap<Infer.FreeTypeListener, List<Type>>(this.freeTypeListeners).entrySet()) {
            if (Type.containsAny(entry.getValue(), this.inferencevars.diff(list))) continue;
            try {
                entry.getKey().typesInferred(this);
                this.freeTypeListeners.remove(entry.getKey());
            }
            catch (Infer.InferenceException inferenceException2) {
                if (inferenceException != null) continue;
                inferenceException = inferenceException2;
            }
        }
        if (inferenceException != null) {
            throw inferenceException;
        }
    }

    public List<Type> save() {
        ListBuffer<Type.UndetVar> listBuffer = new ListBuffer<Type.UndetVar>();
        for (Type type : this.undetvars) {
            listBuffer.add(((Type.UndetVar)type).dup(this.infer.types));
        }
        return listBuffer.toList();
    }

    public void rollback(List<Type> list) {
        Assert.check(list != null);
        ListBuffer<Type.UndetVar> listBuffer = new ListBuffer<Type.UndetVar>();
        ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
        while (list.nonEmpty() && this.undetvars.nonEmpty()) {
            Type.UndetVar undetVar = (Type.UndetVar)this.undetvars.head;
            Type.UndetVar undetVar2 = (Type.UndetVar)list.head;
            if (undetVar.qtype == undetVar2.qtype) {
                undetVar2.dupTo(undetVar, this.types);
                this.undetvars = this.undetvars.tail;
                list = list.tail;
                listBuffer.add(undetVar);
                listBuffer2.add(undetVar.qtype);
                continue;
            }
            this.undetvars = this.undetvars.tail;
        }
        this.undetvars = listBuffer.toList();
        this.inferencevars = listBuffer2.toList();
    }

    void dupTo(InferenceContext inferenceContext) {
        this.dupTo(inferenceContext, false);
    }

    void dupTo(InferenceContext inferenceContext2, boolean bl) {
        inferenceContext2.inferencevars = inferenceContext2.inferencevars.appendList(this.inferencevars.diff(inferenceContext2.inferencevars));
        List<Type> list = bl ? this.save() : this.undetvars;
        inferenceContext2.undetvars = inferenceContext2.undetvars.appendList(list.diff(inferenceContext2.undetvars));
        for (Type type : this.inferencevars) {
            inferenceContext2.freeTypeListeners.put(inferenceContext -> this.notifyChange(), List.of(type));
        }
    }

    InferenceContext min(List<Type> list, boolean bl, Warner warner) {
        if (list.length() == this.inferencevars.length()) {
            return this;
        }
        for (Type object2 : this.inferencevars) {
            if (!object2.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)object2).isCaptured()) continue;
            return this;
        }
        ReachabilityVisitor reachabilityVisitor = new ReachabilityVisitor();
        reachabilityVisitor.scan(list);
        if (reachabilityVisitor.min.size() == this.inferencevars.length()) {
            return this;
        }
        List<Type> list2 = List.from(reachabilityVisitor.min);
        List<Type> list3 = this.inferencevars.diff(list2);
        ListBuffer<Type.UndetVar> listBuffer = new ListBuffer<Type.UndetVar>();
        for (List<Type> list4 : list2) {
            Type type2 = (Type.UndetVar)this.asUndetVar((Type)((Object)list4));
            Assert.check(((Type.UndetVar)type2).incorporationActions.isEmpty());
            Type.UndetVar undetVar = ((Type.UndetVar)type2).dup(this.types);
            for (Type.UndetVar.InferenceBound inferenceBound : Type.UndetVar.InferenceBound.values()) {
                List<Type> list5 = ((Type.UndetVar)type2).getBounds(inferenceBound).stream().filter(type -> !list3.contains(type)).collect(List.collector());
                undetVar.setBounds(inferenceBound, list5);
            }
            listBuffer.add(undetVar);
        }
        InferenceContext inferenceContext2 = new InferenceContext(this.infer, list2, listBuffer.toList());
        for (Type type2 : inferenceContext2.inferencevars) {
            inferenceContext2.addFreeTypeListener(List.of(type2), inferenceContext -> {
                Type type2 = inferenceContext.asInstType(type2);
                for (Type type3 : reachabilityVisitor.minMap.get(type2)) {
                    ((Type.UndetVar)this.asUndetVar(type3)).setInst(type2);
                }
                this.infer.doIncorporation(this, warner);
                this.notifyChange();
            });
        }
        if (bl) {
            List<Type> list4;
            list4 = list3.diff(List.from(reachabilityVisitor.equiv));
            inferenceContext2.addFreeTypeListener(list2, inferenceContext -> {
                this.solve(list2, warner);
                this.notifyChange();
            });
        }
        return inferenceContext2;
    }

    private void solve(Infer.GraphStrategy graphStrategy, Warner warner) {
        Infer infer = this.infer;
        Objects.requireNonNull(infer);
        Infer.GraphSolver graphSolver = infer.new Infer.GraphSolver(this, warner);
        graphSolver.solve(graphStrategy);
    }

    public void solve(Warner warner) {
        this.solve(new Infer.LeafSolver(this.infer){

            @Override
            public boolean done() {
                return InferenceContext.this.restvars().isEmpty();
            }
        }, warner);
    }

    public void solve(final List<Type> list, Warner warner) {
        Infer infer = this.infer;
        Objects.requireNonNull(infer);
        this.solve(new Infer.BestLeafSolver(infer, list){
            {
                Infer infer2 = infer;
                Objects.requireNonNull(infer2);
                super(list3);
            }

            @Override
            public boolean done() {
                return !InferenceContext.this.free(InferenceContext.this.asInstTypes(list));
            }
        }, warner);
    }

    public void solveAny(List<Type> list, Warner warner) {
        Infer infer = this.infer;
        Objects.requireNonNull(infer);
        this.solve(new Infer.BestLeafSolver(infer, list.intersect(this.restvars())){
            {
                Infer infer2 = infer;
                Objects.requireNonNull(infer2);
                super(list);
            }

            @Override
            public boolean done() {
                return InferenceContext.this.instvars().intersect(this.varsToSolve).nonEmpty();
            }
        }, warner);
    }

    List<Type> solveBasic(List<Type> list, EnumSet<Infer.InferenceStep> enumSet) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        block0: for (Type type : list.intersect(this.restvars())) {
            Type.UndetVar undetVar = (Type.UndetVar)this.asUndetVar(type);
            for (Infer.InferenceStep inferenceStep : enumSet) {
                if (!inferenceStep.accepts(undetVar, this)) continue;
                undetVar.setInst(inferenceStep.solve(undetVar, this));
                listBuffer.add(undetVar.qtype);
                continue block0;
            }
        }
        return listBuffer.toList();
    }

    public String toString() {
        String string = "Inference vars: " + this.inferencevars + '\n' + "Undet vars: " + this.undetvars + '\n';
        if (this.parentIC != null) {
            string = string + "\nParent : " + this.parentIC.toString();
        }
        return string;
    }

    Type cachedCapture(JCTree jCTree, Type type, boolean bl) {
        Type type2 = this.captureTypeCache.get(jCTree);
        if (type2 != null) {
            return type2;
        }
        Type type3 = this.types.capture(type);
        if (type3 != type && !bl) {
            this.captureTypeCache.put(jCTree, type3);
        }
        return type3;
    }

    class ReachabilityVisitor
    extends Types.UnaryVisitor<Void> {
        Set<Type> equiv = new LinkedHashSet<Type>();
        Set<Type> min = new LinkedHashSet<Type>();
        Map<Type, Set<Type>> minMap = new LinkedHashMap<Type, Set<Type>>();

        ReachabilityVisitor() {
        }

        void scan(List<Type> list) {
            list.forEach(this::visit);
        }

        @Override
        public Void visitType(Type type, Void void_) {
            return null;
        }

        @Override
        public Void visitUndetVar(Type.UndetVar undetVar, Void void_) {
            if (this.min.add(undetVar.qtype)) {
                Set set = this.minMap.getOrDefault(undetVar.qtype, new LinkedHashSet<Type>(Collections.singleton(undetVar.qtype)));
                for (Type.UndetVar.InferenceBound inferenceBound : Type.UndetVar.InferenceBound.values()) {
                    for (Type type : undetVar.getBounds(inferenceBound)) {
                        Type type2 = InferenceContext.this.asUndetVar(type);
                        if (!type2.hasTag(TypeTag.UNDETVAR)) {
                            this.visit(type2);
                            continue;
                        }
                        if (this.isEquiv(undetVar, type, inferenceBound)) {
                            set.add(type);
                            this.equiv.add(type);
                            continue;
                        }
                        this.visit(type2);
                    }
                }
                this.minMap.put(undetVar.qtype, set);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            return (Void)this.visit(wildcardType.type);
        }

        @Override
        public Void visitTypeVar(Type.TypeVar typeVar, Void void_) {
            Type type = InferenceContext.this.asUndetVar(typeVar);
            if (type.hasTag(TypeTag.UNDETVAR)) {
                this.visitUndetVar((Type.UndetVar)type, null);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType arrayType, Void void_) {
            return (Void)this.visit(arrayType.elemtype);
        }

        @Override
        public Void visitClassType(Type.ClassType classType, Void void_) {
            this.visit(classType.getEnclosingType());
            for (Type type : classType.getTypeArguments()) {
                this.visit(type);
            }
            return null;
        }

        boolean isEquiv(Type.UndetVar undetVar, Type type, Type.UndetVar.InferenceBound inferenceBound) {
            Type.UndetVar undetVar2 = (Type.UndetVar)InferenceContext.this.asUndetVar(type);
            for (Type.UndetVar.InferenceBound inferenceBound2 : Type.UndetVar.InferenceBound.values()) {
                List<Type> list = undetVar.getBounds(inferenceBound2);
                if (inferenceBound2 == inferenceBound) {
                    list = list.diff(List.of(type));
                }
                List<Type> list2 = undetVar2.getBounds(inferenceBound2);
                if (inferenceBound2 == inferenceBound.complement()) {
                    list2 = list2.diff(List.of(undetVar.qtype));
                }
                if (list.containsAll(list2) && list2.containsAll(list)) continue;
                return false;
            }
            return true;
        }
    }
}

