/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Flow {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private TreeMaker make;
    private final Resolve rs;
    private final JCDiagnostic.Factory diags;
    private Env<AttrContext> attrEnv;
    private Lint lint;
    private final Infer infer;

    public static Flow instance(Context context) {
        Flow flow = context.get(flowKey);
        if (flow == null) {
            flow = new Flow(context);
        }
        return flow;
    }

    public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
        new AliveAnalyzer().analyzeTree(env, treeMaker);
        new AssignAnalyzer().analyzeTree(env, treeMaker);
        new FlowAnalyzer().analyzeTree(env, treeMaker);
        new CaptureAnalyzer().analyzeTree(env, treeMaker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeLambda(Env<AttrContext> env, JCTree.JCLambda jCLambda, TreeMaker treeMaker, boolean bl) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = null;
        if (!bl) {
            discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        }
        try {
            new LambdaAliveAnalyzer().analyzeTree(env, jCLambda, treeMaker);
        }
        finally {
            if (!bl) {
                this.log.popDiagnosticHandler(discardDiagnosticHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> analyzeLambdaThrownTypes(Env<AttrContext> env, JCTree.JCLambda jCLambda, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            new LambdaAssignAnalyzer(env).analyzeTree(env, jCLambda, treeMaker);
            LambdaFlowAnalyzer lambdaFlowAnalyzer = new LambdaFlowAnalyzer();
            lambdaFlowAnalyzer.analyzeTree(env, jCLambda, treeMaker);
            List<Type> list = lambdaFlowAnalyzer.inferredThrownTypes;
            return list;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aliveAfter(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            SnippetAliveAnalyzer snippetAliveAnalyzer = new SnippetAliveAnalyzer();
            snippetAliveAnalyzer.analyzeTree(env, jCTree, treeMaker);
            boolean bl = snippetAliveAnalyzer.isAlive();
            return bl;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean breaksToTree(Env<AttrContext> env, JCTree jCTree, JCTree jCTree2, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            SnippetBreakToAnalyzer snippetBreakToAnalyzer = new SnippetBreakToAnalyzer(jCTree);
            snippetBreakToAnalyzer.analyzeTree(env, jCTree2, treeMaker);
            boolean bl = snippetBreakToAnalyzer.breaksTo();
            return bl;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.lint = Lint.instance(context);
        this.infer = Infer.instance(context);
        this.rs = Resolve.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
    }

    private boolean isBpCovered(Type type, PatternDescription patternDescription) {
        if (patternDescription instanceof BindingPattern) {
            BindingPattern bindingPattern = (BindingPattern)patternDescription;
            Type type2 = this.types.erasure(type);
            Type type3 = this.types.erasure(bindingPattern.type);
            return type2.isPrimitive() ? this.types.isUnconditionallyExact(type2, type3) : bindingPattern.type.isPrimitive() && this.types.isUnconditionallyExact(this.types.unboxedType(type2), bindingPattern.type) || this.types.isSubtype(type2, type3);
        }
        return false;
    }

    public PatternDescription makePatternDescription(Type type, JCTree.JCPattern jCPattern2) {
        if (jCPattern2 instanceof JCTree.JCBindingPattern) {
            JCTree.JCBindingPattern jCBindingPattern = (JCTree.JCBindingPattern)jCPattern2;
            Type type2 = !type.isPrimitive() && this.types.isSubtype(type, jCBindingPattern.type) ? type : jCBindingPattern.type;
            return new BindingPattern(type2);
        }
        if (jCPattern2 instanceof JCTree.JCRecordPattern) {
            JCTree.JCRecordPattern jCRecordPattern = (JCTree.JCRecordPattern)jCPattern2;
            Type[] typeArray = !jCRecordPattern.type.isErroneous() ? ((List)((Symbol.ClassSymbol)jCRecordPattern.type.tsym).getRecordComponents()).map(recordComponent -> this.types.memberType(jCRecordPattern.type, (Symbol)recordComponent)).toArray(new Type[0]) : jCRecordPattern.nested.map(jCPattern -> this.types.createErrorType(jCPattern.type)).toArray(new Type[0]);
            PatternDescription[] patternDescriptionArray = new PatternDescription[jCRecordPattern.nested.size()];
            int n = 0;
            List<JCTree.JCPattern> list = jCRecordPattern.nested;
            while (list.nonEmpty()) {
                Type type3 = n < typeArray.length ? typeArray[n] : this.syms.errType;
                patternDescriptionArray[n] = this.makePatternDescription(this.types.erasure(type3), (JCTree.JCPattern)list.head);
                list = list.tail;
                ++n;
            }
            return new RecordPattern(jCRecordPattern.type, typeArray, patternDescriptionArray);
        }
        if (jCPattern2 instanceof JCTree.JCAnyPattern) {
            return new BindingPattern(type);
        }
        throw Assert.error();
    }

    static interface PatternDescription {
    }

    class AliveAnalyzer
    extends BaseAnalyzer {
        private Liveness alive;

        AliveAnalyzer() {
        }

        @Override
        void markDead() {
            this.alive = Liveness.DEAD;
        }

        void scanDef(JCTree jCTree) {
            this.scanStat(jCTree);
            if (jCTree != null && jCTree.hasTag(JCTree.Tag.BLOCK) && this.alive == Liveness.DEAD) {
                Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.InitializerMustBeAbleToCompleteNormally);
            }
        }

        void scanStat(JCTree jCTree) {
            if (this.alive == Liveness.DEAD && jCTree != null) {
                Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.UnreachableStmt);
                if (!jCTree.hasTag(JCTree.Tag.SKIP)) {
                    this.alive = Liveness.RECOVERY;
                }
            }
            this.scan(jCTree);
        }

        void scanStats(List<? extends JCTree.JCStatement> list) {
            if (list != null) {
                List<JCTree.JCStatement> list2 = list;
                while (list2.nonEmpty()) {
                    this.scanStat((JCTree)list2.head);
                    list2 = list2.tail;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            Liveness liveness = this.alive;
            ListBuffer listBuffer = this.pendingExits;
            Lint lint = Flow.this.lint;
            this.pendingExits = new ListBuffer();
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                List<JCTree> list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (((JCTree)list.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        this.scan((JCTree)list.head);
                    }
                    list = list.tail;
                }
                this.forEachInitializer(jCClassDecl, true, jCTree -> {
                    this.scanDef((JCTree)jCTree);
                    this.clearPendingExits(false);
                });
                this.forEachInitializer(jCClassDecl, false, jCTree -> {
                    this.scanDef((JCTree)jCTree);
                    this.clearPendingExits(false);
                });
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)list.head);
                    }
                    list = list.tail;
                }
            }
            finally {
                this.pendingExits = listBuffer;
                this.alive = liveness;
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                this.alive = Liveness.ALIVE;
                this.scanStat(jCMethodDecl.body);
                boolean bl = jCMethodDecl.completesNormally = this.alive != Liveness.DEAD;
                if (this.alive == Liveness.ALIVE && !jCMethodDecl.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    Flow.this.log.error(TreeInfo.diagEndPos(jCMethodDecl.body), CompilerProperties.Errors.MissingRetStmt);
                }
                this.clearPendingExits(true);
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        private void clearPendingExits(boolean bl) {
            List list = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (list.nonEmpty()) {
                BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list.head;
                list = list.tail;
                Assert.check(bl && pendingExit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(pendingExit.tree.pos()));
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.init != null) {
                Lint lint = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
                try {
                    this.scan(jCVariableDecl.init);
                }
                finally {
                    Flow.this.lint = lint;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            this.scanStats(jCBlock.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(jCDoWhileLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCDoWhileLoop));
            this.scan(jCDoWhileLoop.cond);
            this.alive = this.alive.and(!jCDoWhileLoop.cond.type.isTrue());
            this.alive = this.alive.or(this.resolveBreaks(jCDoWhileLoop, listBuffer));
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCWhileLoop.cond);
            this.alive = Liveness.from(!jCWhileLoop.cond.type.isFalse());
            this.scanStat(jCWhileLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCWhileLoop));
            this.alive = this.resolveBreaks(jCWhileLoop, listBuffer).or(!jCWhileLoop.cond.type.isTrue());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.scanStats(jCForLoop.init);
            this.pendingExits = new ListBuffer();
            if (jCForLoop.cond != null) {
                this.scan(jCForLoop.cond);
                this.alive = Liveness.from(!jCForLoop.cond.type.isFalse());
            } else {
                this.alive = Liveness.ALIVE;
            }
            this.scanStat(jCForLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCForLoop));
            this.scan(jCForLoop.step);
            this.alive = this.resolveBreaks(jCForLoop, listBuffer).or(jCForLoop.cond != null && !jCForLoop.cond.type.isTrue());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCEnhancedForLoop.expr);
            this.pendingExits = new ListBuffer();
            this.scanStat(jCEnhancedForLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCEnhancedForLoop));
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
            this.alive = Liveness.ALIVE;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(jCLabeledStatement.body);
            this.alive = this.alive.or(this.resolveBreaks(jCLabeledStatement, listBuffer));
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCSwitch.selector);
            boolean bl = TreeInfo.expectedExhaustive(jCSwitch);
            List<JCTree.JCCase> list = jCSwitch.cases;
            while (list.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCCase jCCase = (JCTree.JCCase)list.head;
                for (JCTree.JCCaseLabel jCCaseLabel : jCCase.labels) {
                    this.scan(jCCaseLabel);
                }
                this.scanStats(jCCase.stats);
                if (this.alive != Liveness.DEAD && jCCase.caseKind == JCTree.JCCase.RULE) {
                    this.scanSyntheticBreak(Flow.this.make, jCSwitch);
                    this.alive = Liveness.DEAD;
                }
                if (this.alive == Liveness.ALIVE && jCCase.stats.nonEmpty() && list.tail.nonEmpty()) {
                    Flow.this.lint.logIfEnabled(((JCTree.JCCase)list.tail.head).pos(), CompilerProperties.LintWarnings.PossibleFallThroughIntoCase);
                }
                list = list.tail;
            }
            boolean bl2 = jCSwitch.isExhaustive = jCSwitch.hasUnconditionalPattern || TreeInfo.isErrorEnumSwitch(jCSwitch.selector, jCSwitch.cases);
            if (bl) {
                jCSwitch.isExhaustive |= this.exhausts(jCSwitch.selector, jCSwitch.cases);
                if (!jCSwitch.isExhaustive) {
                    Flow.this.log.error(jCSwitch, CompilerProperties.Errors.NotExhaustiveStatement);
                }
            }
            if (!jCSwitch.hasUnconditionalPattern && !bl) {
                this.alive = Liveness.ALIVE;
            }
            this.alive = this.alive.or(this.resolveBreaks(jCSwitch, listBuffer));
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCSwitchExpression.selector);
            Liveness liveness = this.alive;
            List<JCTree.JCCase> list = jCSwitchExpression.cases;
            while (list.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCCase jCCase = (JCTree.JCCase)list.head;
                for (JCTree.JCCaseLabel jCCaseLabel : jCCase.labels) {
                    this.scan(jCCaseLabel);
                }
                this.scanStats(jCCase.stats);
                if (this.alive == Liveness.ALIVE) {
                    if (jCCase.caseKind == JCTree.JCCase.RULE) {
                        Flow.this.log.error(TreeInfo.diagEndPos(jCCase.body), CompilerProperties.Errors.RuleCompletesNormally);
                    } else if (list.tail.isEmpty()) {
                        Flow.this.log.error(TreeInfo.diagEndPos(jCSwitchExpression), CompilerProperties.Errors.SwitchExpressionCompletesNormally);
                    }
                }
                list = list.tail;
            }
            jCSwitchExpression.isExhaustive = jCSwitchExpression.hasUnconditionalPattern || TreeInfo.isErrorEnumSwitch(jCSwitchExpression.selector, jCSwitchExpression.cases) ? true : this.exhausts(jCSwitchExpression.selector, jCSwitchExpression.cases);
            if (!jCSwitchExpression.isExhaustive) {
                Flow.this.log.error(jCSwitchExpression, CompilerProperties.Errors.NotExhaustive);
            }
            this.alive = liveness;
            this.alive = this.alive.or(this.resolveYields(jCSwitchExpression, listBuffer));
        }

        private boolean exhausts(JCTree.JCExpression jCExpression, List<JCTree.JCCase> list) {
            HashSet<PatternDescription> hashSet = new HashSet<PatternDescription>();
            HashMap<Symbol, Set> hashMap = new HashMap<Symbol, Set>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>(Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(0, 1))));
            for (JCTree.JCCase object : list) {
                if (!TreeInfo.unguardedCase(object)) continue;
                for (JCTree.JCCaseLabel jCCaseLabel : object.labels) {
                    Object object2;
                    if (jCCaseLabel instanceof JCTree.JCPatternCaseLabel) {
                        JCTree.JCPatternCaseLabel jCPatternCaseLabel = (JCTree.JCPatternCaseLabel)jCCaseLabel;
                        for (Type type : this.components(jCExpression.type)) {
                            hashSet.add(Flow.this.makePatternDescription(type, jCPatternCaseLabel.pat));
                        }
                        continue;
                    }
                    if (!(jCCaseLabel instanceof JCTree.JCConstantCaseLabel)) continue;
                    JCTree.JCConstantCaseLabel jCConstantCaseLabel = (JCTree.JCConstantCaseLabel)jCCaseLabel;
                    if (Flow.this.types.unboxedTypeOrType(jCExpression.type).hasTag(TypeTag.BOOLEAN)) {
                        object2 = ((JCTree.JCLiteral)jCConstantCaseLabel.expr).value;
                        hashSet2.remove(object2);
                        continue;
                    }
                    object2 = TreeInfo.symbol(jCConstantCaseLabel.expr);
                    if (object2 == null || !((Symbol)object2).isEnum()) continue;
                    hashMap.computeIfAbsent(((Symbol)object2).owner, arg_0 -> AliveAnalyzer.lambda$exhausts$3((Symbol)object2, arg_0)).remove(object2);
                }
            }
            if (Flow.this.types.unboxedTypeOrType(jCExpression.type).hasTag(TypeTag.BOOLEAN) && hashSet2.isEmpty()) {
                return true;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!((Set)entry.getValue()).isEmpty()) continue;
                hashSet.add(new BindingPattern(((Symbol)entry.getKey()).type));
            }
            Set<PatternDescription> set = hashSet;
            boolean bl = true;
            try {
                boolean bl2 = true;
                while (bl2) {
                    boolean bl3;
                    Set<PatternDescription> set5 = this.reduceBindingPatterns(jCExpression.type, set);
                    set5 = this.reduceNestedPatterns(set5, bl3);
                    set5 = this.reduceRecordPatterns(set5);
                    set5 = this.removeCoveredRecordPatterns(set5);
                    boolean bl4 = bl2 = !set5.equals(set);
                    if (this.checkCovered(jCExpression.type, (Iterable<PatternDescription>)set)) {
                        return true;
                    }
                    if (!bl2) {
                        bl2 = bl3;
                        bl3 = false;
                    } else {
                        bl3 = true;
                    }
                    set = set5;
                }
                return this.checkCovered(jCExpression.type, (Iterable<PatternDescription>)set);
            }
            catch (Symbol.CompletionFailure completionFailure) {
                Flow.this.chk.completionError(jCExpression.pos(), completionFailure);
                return true;
            }
        }

        private boolean checkCovered(Type type, Iterable<PatternDescription> iterable) {
            for (Type type2 : this.components(type)) {
                for (PatternDescription patternDescription : iterable) {
                    if (!Flow.this.isBpCovered(type2, patternDescription)) continue;
                    return true;
                }
            }
            return false;
        }

        private List<Type> components(Type type2) {
            List<Type> list;
            switch (type2.getTag()) {
                case CLASS: {
                    if (type2.isCompound()) {
                        if (type2.isIntersection()) {
                            list = ((Type.IntersectionClassType)type2).getComponents().stream().flatMap(type -> this.components((Type)type).stream()).collect(List.collector());
                            break;
                        }
                        list = List.nil();
                        break;
                    }
                    list = List.of(Flow.this.types.erasure(type2));
                    break;
                }
                case TYPEVAR: {
                    list = this.components(((Type.TypeVar)type2).getUpperBound());
                    break;
                }
                default: {
                    list = List.of(Flow.this.types.erasure(type2));
                }
            }
            return list;
        }

        private Set<PatternDescription> reduceBindingPatterns(Type type, Set<PatternDescription> set) {
            Set set2 = set.stream().filter(patternDescription -> patternDescription instanceof BindingPattern).map(patternDescription -> ((BindingPattern)((BindingPattern)patternDescription)).type.tsym).collect(Collectors.toSet());
            for (PatternDescription patternDescription2 : set) {
                if (!(patternDescription2 instanceof BindingPattern)) continue;
                BindingPattern bindingPattern = (BindingPattern)patternDescription2;
                HashSet<BindingPattern> hashSet = new HashSet<BindingPattern>();
                for (Type type3 : Flow.this.types.directSupertypes(bindingPattern.type)) {
                    Symbol.ClassSymbol classSymbol2 = (Symbol.ClassSymbol)((Flow)Flow.this).types.erasure((Type)type3).tsym;
                    classSymbol2.complete();
                    if (!classSymbol2.isSealed() || !classSymbol2.isAbstract() || set2.contains(classSymbol2)) continue;
                    ListBuffer listBuffer = new ListBuffer();
                    Type type4 = Flow.this.types.erasure(classSymbol2.type);
                    if (this.components(type).stream().map(Flow.this.types::erasure).noneMatch(type2 -> Flow.this.types.isSubtype(type4, (Type)type2))) continue;
                    Set<Symbol> set3 = this.allPermittedSubTypes(classSymbol2, classSymbol -> {
                        Type type2 = classSymbol.type.allparams().isEmpty() ? classSymbol.type : Flow.this.infer.instantiatePatternType(type, (Symbol.TypeSymbol)classSymbol);
                        return type2 != null && Flow.this.types.isCastable(type, type2);
                    });
                    for (PatternDescription patternDescription3 : set) {
                        if (!(patternDescription3 instanceof BindingPattern)) continue;
                        BindingPattern bindingPattern2 = (BindingPattern)patternDescription3;
                        Set<Symbol> set4 = this.allPermittedSubTypes(((BindingPattern)bindingPattern2).type.tsym, classSymbol -> true);
                        Iterator<Symbol> iterator = set3.iterator();
                        block3: while (iterator.hasNext()) {
                            Symbol symbol = iterator.next();
                            for (Symbol symbol2 : set4) {
                                if (!Flow.this.types.isSubtype(Flow.this.types.erasure(symbol2.type), Flow.this.types.erasure(symbol.type))) continue;
                                iterator.remove();
                                continue block3;
                            }
                            if (!Flow.this.types.isSubtype(Flow.this.types.erasure(symbol.type), Flow.this.types.erasure(bindingPattern2.type))) continue;
                            iterator.remove();
                        }
                    }
                    if (!set3.isEmpty()) continue;
                    hashSet.add(new BindingPattern(classSymbol2.type));
                }
                if (hashSet.isEmpty()) continue;
                HashSet<PatternDescription> hashSet2 = new HashSet<PatternDescription>(set);
                hashSet2.addAll(hashSet);
                return hashSet2;
            }
            return set;
        }

        private Set<Symbol> allPermittedSubTypes(Symbol.TypeSymbol typeSymbol, Predicate<Symbol.ClassSymbol> predicate) {
            HashSet<Symbol> hashSet = new HashSet<Symbol>();
            List<Symbol.ClassSymbol> list = this.baseClasses(typeSymbol);
            while (list.nonEmpty()) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)list.head;
                list = list.tail;
                classSymbol.complete();
                if (!classSymbol.isSealed() || !classSymbol.isAbstract()) continue;
                for (Type type : classSymbol.getPermittedSubclasses()) {
                    Symbol.ClassSymbol classSymbol2 = (Symbol.ClassSymbol)type.tsym;
                    if (!predicate.test(classSymbol2)) continue;
                    list = list.prepend(classSymbol2);
                    hashSet.add(classSymbol2);
                }
            }
            return hashSet;
        }

        private List<Symbol.ClassSymbol> baseClasses(Symbol.TypeSymbol typeSymbol) {
            if (typeSymbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeSymbol;
                return List.of(classSymbol);
            }
            if (typeSymbol instanceof Symbol.TypeVariableSymbol) {
                Symbol.TypeVariableSymbol typeVariableSymbol = (Symbol.TypeVariableSymbol)typeSymbol;
                ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
                for (Type type : typeVariableSymbol.getBounds()) {
                    listBuffer.appendList(this.baseClasses(type.tsym));
                }
                return listBuffer.toList();
            }
            return List.nil();
        }

        private Set<PatternDescription> reduceNestedPatterns(Set<PatternDescription> set, boolean bl) {
            Map<Symbol.ClassSymbol, java.util.List<RecordPattern>> map = set.stream().filter(patternDescription -> patternDescription instanceof RecordPattern).map(patternDescription -> (RecordPattern)patternDescription).collect(Collectors.groupingBy(recordPattern -> (Symbol.ClassSymbol)((RecordPattern)recordPattern).recordType.tsym));
            for (Map.Entry<Symbol.ClassSymbol, java.util.List<RecordPattern>> entry : map.entrySet()) {
                int n = ((List)entry.getKey().getRecordComponents()).size();
                HashSet<RecordPattern> hashSet = new HashSet<RecordPattern>((Collection)entry.getValue());
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    Map<Integer, java.util.List<RecordPattern>> map2 = hashSet.stream().filter(recordPattern -> ((RecordPattern)recordPattern).nested.length == n).collect(Collectors.groupingBy(recordPattern -> bl ? recordPattern.hashCode(n2) : 0));
                    for (java.util.List<RecordPattern> list : map2.values()) {
                        RecordPattern[] recordPatternArray = list.toArray(new RecordPattern[0]);
                        for (int j = 0; j < recordPatternArray.length; ++j) {
                            PatternDescription[] patternDescriptionArray;
                            Set<PatternDescription> set2;
                            RecordPattern recordPattern2 = recordPatternArray[j];
                            ListBuffer<Object> listBuffer = new ListBuffer<Object>();
                            listBuffer.append(recordPattern2);
                            block4: for (int k = 0; k < recordPatternArray.length; ++k) {
                                if (j == k) continue;
                                set2 = recordPatternArray[k];
                                if (((RecordPattern)recordPattern2).recordType.tsym != ((RecordPattern)((Object)set2)).recordType.tsym) continue;
                                for (int i2 = 0; i2 < recordPattern2.nested.length; ++i2) {
                                    PatternDescription patternDescription2;
                                    if (i2 == i || recordPattern2.nested[i2].equals(((RecordPattern)set2).nested[i2])) continue;
                                    if (bl || !((patternDescription2 = recordPattern2.nested[i2]) instanceof BindingPattern)) continue block4;
                                    PatternDescription patternDescription3 = (BindingPattern)patternDescription2;
                                    patternDescription2 = ((RecordPattern)set2).nested[i2];
                                    if (!(patternDescription2 instanceof BindingPattern)) continue block4;
                                    patternDescriptionArray = (BindingPattern)patternDescription2;
                                    if (!Flow.this.types.isSubtype(Flow.this.types.erasure(((BindingPattern)patternDescription3).type), Flow.this.types.erasure(((BindingPattern)patternDescriptionArray).type))) continue block4;
                                }
                                listBuffer.append(set2);
                            }
                            Set<PatternDescription> set3 = listBuffer.stream().map(recordPattern -> ((RecordPattern)recordPattern).nested[n2]).collect(Collectors.toSet());
                            set2 = this.reduceNestedPatterns(set3, bl);
                            set2 = this.reduceRecordPatterns(set2);
                            set2 = this.removeCoveredRecordPatterns(set2);
                            set2 = this.reduceBindingPatterns(recordPattern2.fullComponentTypes()[n2], set2);
                            if (set3.equals(set2)) continue;
                            if (bl) {
                                hashSet.removeAll(listBuffer);
                            }
                            for (PatternDescription patternDescription3 : set2) {
                                patternDescriptionArray = Arrays.copyOf(recordPattern2.nested, recordPattern2.nested.length);
                                patternDescriptionArray[n2] = patternDescription3;
                                hashSet.add(new RecordPattern(recordPattern2.recordType(), recordPattern2.fullComponentTypes(), patternDescriptionArray));
                            }
                        }
                    }
                }
                if (hashSet.equals(new HashSet(entry.getValue()))) continue;
                HashSet<PatternDescription> hashSet2 = new HashSet<PatternDescription>(set);
                hashSet2.removeAll((Collection)entry.getValue());
                hashSet2.addAll(hashSet);
                return hashSet2;
            }
            return set;
        }

        private Set<PatternDescription> reduceRecordPatterns(Set<PatternDescription> set) {
            HashSet<PatternDescription> hashSet = new HashSet<PatternDescription>();
            boolean bl = false;
            for (PatternDescription patternDescription : set) {
                RecordPattern recordPattern;
                PatternDescription patternDescription2;
                if (patternDescription instanceof RecordPattern && (patternDescription2 = this.reduceRecordPattern(recordPattern = (RecordPattern)patternDescription)) != recordPattern) {
                    hashSet.add(patternDescription2);
                    bl = true;
                    continue;
                }
                hashSet.add(patternDescription);
            }
            return bl ? hashSet : set;
        }

        private PatternDescription reduceRecordPattern(PatternDescription patternDescription) {
            if (patternDescription instanceof RecordPattern) {
                RecordPattern recordPattern = (RecordPattern)patternDescription;
                Type[] typeArray = recordPattern.fullComponentTypes();
                if (typeArray.length != recordPattern.nested.length) {
                    return patternDescription;
                }
                PatternDescription[] patternDescriptionArray = null;
                boolean bl = true;
                for (int i = 0; i < typeArray.length; ++i) {
                    PatternDescription patternDescription2 = this.reduceRecordPattern(recordPattern.nested[i]);
                    if (patternDescription2 != recordPattern.nested[i]) {
                        if (patternDescriptionArray == null) {
                            patternDescriptionArray = Arrays.copyOf(recordPattern.nested, recordPattern.nested.length);
                        }
                        patternDescriptionArray[i] = patternDescription2;
                    }
                    bl &= this.checkCovered(typeArray[i], List.of(patternDescription2));
                }
                if (bl) {
                    return new BindingPattern(recordPattern.recordType);
                }
                if (patternDescriptionArray != null) {
                    return new RecordPattern(recordPattern.recordType, recordPattern.fullComponentTypes(), patternDescriptionArray);
                }
            }
            return patternDescription;
        }

        private Set<PatternDescription> removeCoveredRecordPatterns(Set<PatternDescription> set) {
            Set set2 = set.stream().filter(patternDescription -> patternDescription instanceof BindingPattern).map(patternDescription -> ((BindingPattern)((BindingPattern)patternDescription)).type.tsym).collect(Collectors.toSet());
            HashSet<PatternDescription> hashSet = new HashSet<PatternDescription>(set);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                PatternDescription patternDescription2 = (PatternDescription)iterator.next();
                if (!(patternDescription2 instanceof RecordPattern)) continue;
                RecordPattern recordPattern = (RecordPattern)patternDescription2;
                if (!set2.contains(((RecordPattern)recordPattern).recordType.tsym)) continue;
                iterator.remove();
            }
            return hashSet;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            void var4_6;
            JCTree jCTree;
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree object2 : jCTry.resources) {
                if (object2 instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)object2;
                    this.visitVarDef(jCVariableDecl);
                    continue;
                }
                if (object2 instanceof JCTree.JCExpression) {
                    jCTree = (JCTree.JCExpression)object2;
                    this.scan(jCTree);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            this.scanStat(jCTry.body);
            Object object3 = this.alive;
            List<JCTree.JCCatch> list = jCTry.catchers;
            while (var4_6.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                jCTree = ((JCTree.JCCatch)var4_6.head).param;
                this.scan(jCTree);
                this.scanStat(((JCTree.JCCatch)var4_6.head).body);
                object3 = ((Liveness)((Object)object3)).or(this.alive);
                List list2 = var4_6.tail;
            }
            if (jCTry.finalizer != null) {
                ListBuffer listBuffer2 = this.pendingExits;
                this.pendingExits = listBuffer;
                this.alive = Liveness.ALIVE;
                this.scanStat(jCTry.finalizer);
                boolean bl = jCTry.finallyCanCompleteNormally = this.alive != Liveness.DEAD;
                if (this.alive == Liveness.DEAD) {
                    Flow.this.lint.logIfEnabled(TreeInfo.diagEndPos(jCTry.finalizer), CompilerProperties.LintWarnings.FinallyCannotComplete);
                } else {
                    while (listBuffer2.nonEmpty()) {
                        this.pendingExits.append((BaseAnalyzer.PendingExit)listBuffer2.next());
                    }
                    this.alive = object3;
                }
            } else {
                this.alive = object3;
                ListBuffer listBuffer3 = this.pendingExits;
                this.pendingExits = listBuffer;
                while (listBuffer3.nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)listBuffer3.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.cond);
            this.scanStat(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                Liveness liveness = this.alive;
                this.alive = Liveness.ALIVE;
                this.scanStat(jCIf.elsepart);
                this.alive = this.alive.or(liveness);
            } else {
                this.alive = Liveness.ALIVE;
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCBreak));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            this.scan(jCYield.value);
            this.recordExit(new BaseAnalyzer.PendingExit(jCYield));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCContinue));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scan(jCReturn.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scan(jCThrow.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scan(jCMethodInvocation.meth);
            this.scan(jCMethodInvocation.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.args);
            if (jCNewClass.def != null) {
                this.scan(jCNewClass.def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous()) {
                return;
            }
            ListBuffer listBuffer = this.pendingExits;
            Liveness liveness = this.alive;
            try {
                this.pendingExits = new ListBuffer();
                this.alive = Liveness.ALIVE;
                this.scanStat(jCLambda.body);
                jCLambda.canCompleteNormally = this.alive != Liveness.DEAD;
            }
            finally {
                this.pendingExits = listBuffer;
                this.alive = liveness;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.alive = Liveness.ALIVE;
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }

        private static /* synthetic */ Set lambda$exhausts$3(Symbol symbol2, Symbol symbol3) {
            HashSet hashSet = new HashSet();
            symbol2.owner.members().getSymbols(symbol -> symbol.kind == Kinds.Kind.VAR && symbol.isEnum()).forEach(hashSet::add);
            return hashSet;
        }
    }

    public class AssignAnalyzer
    extends BaseAnalyzer {
        final Bits inits;
        final Bits uninits;
        final Bits uninitsTry;
        final Bits initsWhenTrue;
        final Bits initsWhenFalse;
        final Bits uninitsWhenTrue;
        final Bits uninitsWhenFalse;
        protected JCTree.JCVariableDecl[] vardecls;
        JCTree.JCClassDecl classDef;
        int firstadr;
        protected int nextadr;
        protected int returnadr;
        Scope.WriteableScope unrefdResources;
        FlowKind flowKind = FlowKind.NORMAL;
        int startPos;
        private boolean isConstructor;

        public AssignAnalyzer() {
            this.inits = new Bits();
            this.uninits = new Bits();
            this.uninitsTry = new Bits();
            this.initsWhenTrue = new Bits(true);
            this.initsWhenFalse = new Bits(true);
            this.uninitsWhenTrue = new Bits(true);
            this.uninitsWhenFalse = new Bits(true);
        }

        @Override
        protected void markDead() {
            this.inits.inclRange(this.returnadr, this.nextadr);
            this.uninits.inclRange(this.returnadr, this.nextadr);
        }

        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            return varSymbol.pos >= this.startPos && (varSymbol.owner.kind == Kinds.Kind.MTH || varSymbol.owner.kind == Kinds.Kind.VAR || this.isFinalUninitializedField(varSymbol));
        }

        boolean isFinalUninitializedField(Symbol.VarSymbol varSymbol) {
            return varSymbol.owner.kind == Kinds.Kind.TYP && (varSymbol.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)varSymbol.owner);
        }

        void newVar(JCTree.JCVariableDecl jCVariableDecl) {
            Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
            this.vardecls = ArrayUtils.ensureCapacity(this.vardecls, this.nextadr);
            if ((varSymbol.flags() & 0x10L) == 0L) {
                varSymbol.flags_field |= 0x20000000000L;
            }
            varSymbol.adr = this.nextadr;
            this.vardecls[this.nextadr] = jCVariableDecl;
            this.inits.excl(this.nextadr);
            this.uninits.incl(this.nextadr);
            ++this.nextadr;
        }

        void letInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            if (varSymbol.adr >= this.firstadr && this.trackable(varSymbol)) {
                if ((varSymbol.flags() & 0x20000000000L) != 0L) {
                    if (!this.uninits.isMember(varSymbol.adr)) {
                        varSymbol.flags_field &= 0xFFFFFDFFFFFFFFFFL;
                    } else {
                        this.uninit(varSymbol);
                    }
                } else if ((varSymbol.flags() & 0x10L) != 0L) {
                    if ((varSymbol.flags() & 0x200000000L) != 0L) {
                        if ((varSymbol.flags() & 0x8000000000L) != 0L) {
                            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.MulticatchParameterMayNotBeAssigned(varSymbol));
                        } else {
                            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.FinalParameterMayNotBeAssigned(varSymbol));
                        }
                    } else if (!this.uninits.isMember(varSymbol.adr)) {
                        Flow.this.log.error(diagnosticPosition, Flow.this.diags.errorKey(this.flowKind.errKey, varSymbol));
                    } else {
                        this.uninit(varSymbol);
                    }
                }
                this.inits.incl(varSymbol.adr);
            } else if ((varSymbol.flags() & 0x10L) != 0L) {
                Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.VarMightAlreadyBeAssigned(varSymbol));
            }
        }

        void uninit(Symbol.VarSymbol varSymbol) {
            if (!this.inits.isMember(varSymbol.adr)) {
                this.uninits.excl(varSymbol.adr);
                this.uninitsTry.excl(varSymbol.adr);
            } else {
                this.uninits.excl(varSymbol.adr);
            }
        }

        void letInit(JCTree jCTree) {
            if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.IDENT) || jCTree.hasTag(JCTree.Tag.SELECT)) {
                Symbol symbol = TreeInfo.symbol(jCTree);
                if (symbol.kind == Kinds.Kind.VAR) {
                    this.letInit(jCTree.pos(), (Symbol.VarSymbol)symbol);
                }
            }
        }

        void checkInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            this.checkInit(diagnosticPosition, varSymbol, CompilerProperties.Errors.VarMightNotHaveBeenInitialized(varSymbol));
        }

        void checkInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol, JCDiagnostic.Error error) {
            if ((varSymbol.adr >= this.firstadr || varSymbol.owner.kind != Kinds.Kind.TYP) && this.trackable(varSymbol) && !this.inits.isMember(varSymbol.adr) && (varSymbol.flags_field & 0x40000000000L) == 0L) {
                Flow.this.log.error(diagnosticPosition, error);
                this.inits.incl(varSymbol.adr);
            }
        }

        private void resetBits(Bits ... bitsArray) {
            for (Bits bits : bitsArray) {
                bits.reset();
            }
        }

        void split(boolean bl) {
            this.initsWhenFalse.assign(this.inits);
            this.uninitsWhenFalse.assign(this.uninits);
            this.initsWhenTrue.assign(this.inits);
            this.uninitsWhenTrue.assign(this.uninits);
            if (bl) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        protected void merge() {
            this.inits.assign(this.initsWhenFalse.andSet(this.initsWhenTrue));
            this.uninits.assign(this.uninitsWhenFalse.andSet(this.uninitsWhenTrue));
        }

        void scanExpr(JCTree jCTree) {
            if (jCTree != null) {
                this.scan(jCTree);
                if (this.inits.isReset()) {
                    this.merge();
                }
            }
        }

        void scanExprs(List<? extends JCTree.JCExpression> list) {
            if (list != null) {
                List<JCTree.JCExpression> list2 = list;
                while (list2.nonEmpty()) {
                    this.scanExpr((JCTree)list2.head);
                    list2 = list2.tail;
                }
            }
        }

        void scanPattern(JCTree jCTree) {
            this.scan(jCTree);
        }

        void scanCond(JCTree jCTree) {
            if (jCTree.type.isFalse()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenTrue.assign(this.inits);
                this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenTrue.assign(this.uninits);
                this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.initsWhenFalse.assign(this.inits);
                this.uninitsWhenFalse.assign(this.uninits);
            } else if (jCTree.type.isTrue()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenFalse.assign(this.inits);
                this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenFalse.assign(this.uninits);
                this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.initsWhenTrue.assign(this.inits);
                this.uninitsWhenTrue.assign(this.uninits);
            } else {
                this.scan(jCTree);
                if (!this.inits.isReset()) {
                    this.split(jCTree.type != ((Flow)Flow.this).syms.unknownType);
                }
            }
            if (jCTree.type != ((Flow)Flow.this).syms.unknownType) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                JCTree.JCClassDecl jCClassDecl2 = this.classDef;
                int n = this.firstadr;
                int n2 = this.nextadr;
                ListBuffer listBuffer = this.pendingExits;
                this.pendingExits = new ListBuffer();
                if (jCClassDecl.name != ((Flow)Flow.this).names.empty) {
                    this.firstadr = this.nextadr;
                }
                this.classDef = jCClassDecl;
                try {
                    Symbol.VarSymbol varSymbol;
                    JCTree.JCVariableDecl jCVariableDecl;
                    List<JCTree> list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.VARDEF)) {
                            jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                            if ((jCVariableDecl.mods.flags & 8L) != 0L && this.trackable(varSymbol = jCVariableDecl.sym)) {
                                this.newVar(jCVariableDecl);
                            }
                        }
                        list = list.tail;
                    }
                    this.forEachInitializer(jCClassDecl, true, jCTree -> {
                        this.scan((JCTree)jCTree);
                        this.clearPendingExits(false);
                    });
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        jCVariableDecl = this.vardecls[i];
                        varSymbol = jCVariableDecl.sym;
                        if (varSymbol.owner != this.classDef.sym || !varSymbol.isStatic()) continue;
                        this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCVariableDecl), varSymbol);
                    }
                    List<JCTree> list2 = jCClassDecl.defs;
                    while (list2.nonEmpty()) {
                        if (((JCTree)list2.head).hasTag(JCTree.Tag.VARDEF)) {
                            jCVariableDecl = (JCTree.JCVariableDecl)list2.head;
                            if ((jCVariableDecl.mods.flags & 8L) == 0L && this.trackable(varSymbol = jCVariableDecl.sym)) {
                                this.newVar(jCVariableDecl);
                            }
                        }
                        list2 = list2.tail;
                    }
                    list2 = jCClassDecl.defs;
                    while (list2.nonEmpty()) {
                        if (((JCTree)list2.head).hasTag(JCTree.Tag.METHODDEF)) {
                            this.scan((JCTree)list2.head);
                        }
                        list2 = list2.tail;
                    }
                    list2 = jCClassDecl.defs;
                    while (list2.nonEmpty()) {
                        if (((JCTree)list2.head).hasTag(JCTree.Tag.CLASSDEF)) {
                            this.scan((JCTree)list2.head);
                        }
                        list2 = list2.tail;
                    }
                }
                finally {
                    this.pendingExits = listBuffer;
                    this.nextadr = n2;
                    this.firstadr = n;
                    this.classDef = jCClassDecl2;
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            if ((jCMethodDecl.sym.flags() & 0x1000L) != 0L) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            try {
                Bits bits = new Bits(this.inits);
                Bits bits2 = new Bits(this.uninits);
                int n = this.nextadr;
                int n2 = this.firstadr;
                int n3 = this.returnadr;
                Assert.check(this.pendingExits.isEmpty());
                boolean bl = this.isConstructor;
                try {
                    boolean bl2;
                    this.isConstructor = TreeInfo.isConstructor(jCMethodDecl);
                    if (!this.isConstructor) {
                        this.firstadr = this.nextadr;
                    }
                    List<JCTree.JCVariableDecl> list = jCMethodDecl.params;
                    while (list.nonEmpty()) {
                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                        this.scan(jCVariableDecl);
                        Assert.check((jCVariableDecl.sym.flags() & 0x200000000L) != 0L, "Method parameter without PARAMETER flag");
                        this.initParam(jCVariableDecl);
                        list = list.tail;
                    }
                    this.scan(jCMethodDecl.body);
                    boolean bl3 = bl2 = (jCMethodDecl.sym.flags() & 0x8000000000000L) != 0L || (jCMethodDecl.sym.flags() & 0x2000001000000000L) == 0x2000001000000000L;
                    if (this.isConstructor) {
                        boolean bl4 = (jCMethodDecl.sym.flags() & 0x1000000000L) != 0L;
                        for (int i = this.firstadr; i < this.nextadr; ++i) {
                            JCTree.JCVariableDecl jCVariableDecl = this.vardecls[i];
                            Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
                            if (varSymbol.owner != this.classDef.sym || varSymbol.isStatic()) continue;
                            if (bl4 && !bl2) {
                                this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCVariableDecl), varSymbol, CompilerProperties.Errors.VarNotInitializedInDefaultConstructor(varSymbol));
                                continue;
                            }
                            if (bl2) {
                                boolean bl5;
                                boolean bl6 = bl5 = varSymbol.enclClass().isRecord() && (varSymbol.flags_field & 0x2000000001000012L) != 0L && varSymbol.owner.kind == Kinds.Kind.TYP;
                                if (bl5) {
                                    boolean bl7;
                                    boolean bl8 = bl7 = !this.inits.isMember(varSymbol.adr);
                                    if (bl7 && this.uninits.isMember(varSymbol.adr) && jCMethodDecl.completesNormally) {
                                        varSymbol.flags_field |= 0x8000000000000L;
                                        continue;
                                    }
                                    this.checkInit(TreeInfo.diagEndPos(jCMethodDecl.body), varSymbol);
                                    continue;
                                }
                                this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCVariableDecl), varSymbol);
                                continue;
                            }
                            this.checkInit(TreeInfo.diagEndPos(jCMethodDecl.body), varSymbol);
                        }
                    }
                    this.clearPendingExits(true);
                }
                finally {
                    this.inits.assign(bits);
                    this.uninits.assign(bits2);
                    this.nextadr = n;
                    this.firstadr = n2;
                    this.returnadr = n3;
                    this.isConstructor = bl;
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        private void clearPendingExits(boolean bl) {
            List list = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (list.nonEmpty()) {
                BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list.head;
                list = list.tail;
                Assert.check(bl && pendingExit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(pendingExit.tree.pos()), pendingExit.tree);
                if (!bl || !this.isConstructor) continue;
                Assert.check(pendingExit instanceof AssignPendingExit);
                this.inits.assign(((AssignPendingExit)pendingExit).exit_inits);
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.checkInit(pendingExit.tree.pos(), this.vardecls[i].sym);
                }
            }
        }

        protected void initParam(JCTree.JCVariableDecl jCVariableDecl) {
            this.inits.incl(jCVariableDecl.sym.adr);
            this.uninits.excl(jCVariableDecl.sym.adr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
            try {
                boolean bl = this.trackable(jCVariableDecl.sym);
                if (bl && (jCVariableDecl.sym.owner.kind == Kinds.Kind.MTH || jCVariableDecl.sym.owner.kind == Kinds.Kind.VAR)) {
                    this.newVar(jCVariableDecl);
                }
                if (jCVariableDecl.init != null) {
                    this.scanExpr(jCVariableDecl.init);
                    if (bl) {
                        this.letInit(jCVariableDecl.pos(), jCVariableDecl.sym);
                    }
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            int n = this.nextadr;
            this.scan(jCBlock.stats);
            this.nextadr = n;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                this.scan(jCDoWhileLoop.body);
                this.resolveContinues(jCDoWhileLoop);
                this.scanCond(jCDoWhileLoop.cond);
                if (!this.flowKind.isFinal()) {
                    bits.assign(this.initsWhenFalse);
                    bits2.assign(this.uninitsWhenFalse);
                }
                if (((Flow)Flow.this).log.nerrors != n || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(bits3.andSet(this.uninitsWhenTrue));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n = ((Flow)Flow.this).log.nerrors;
            Bits bits3 = new Bits(this.uninits);
            bits3.excludeFrom(this.nextadr);
            while (true) {
                this.scanCond(jCWhileLoop.cond);
                if (!this.flowKind.isFinal()) {
                    bits.assign(this.initsWhenFalse);
                    bits2.assign(this.uninitsWhenFalse);
                }
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(this.uninitsWhenTrue);
                this.scan(jCWhileLoop.body);
                this.resolveContinues(jCWhileLoop);
                if (((Flow)Flow.this).log.nerrors != n || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCWhileLoop, listBuffer);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int n = this.nextadr;
            this.scan(jCForLoop.init);
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n2 = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                if (jCForLoop.cond != null) {
                    this.scanCond(jCForLoop.cond);
                    if (!this.flowKind.isFinal()) {
                        bits.assign(this.initsWhenFalse);
                        bits2.assign(this.uninitsWhenFalse);
                    }
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                } else if (!this.flowKind.isFinal()) {
                    bits.assign(this.inits);
                    bits.inclRange(this.firstadr, this.nextadr);
                    bits2.assign(this.uninits);
                    bits2.inclRange(this.firstadr, this.nextadr);
                }
                this.scan(jCForLoop.body);
                this.resolveContinues(jCForLoop);
                this.scan(jCForLoop.step);
                if (((Flow)Flow.this).log.nerrors != n2 || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCForLoop, listBuffer);
            this.nextadr = n;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int n = this.nextadr;
            this.scan(jCEnhancedForLoop.expr);
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            this.letInit(jCEnhancedForLoop.pos(), jCEnhancedForLoop.var.sym);
            this.pendingExits = new ListBuffer();
            int n2 = ((Flow)Flow.this).log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                this.scan(jCEnhancedForLoop.body);
                this.resolveContinues(jCEnhancedForLoop);
                if (((Flow)Flow.this).log.nerrors != n2 || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2.andSet(this.uninits));
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
            this.nextadr = n;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCLabeledStatement.body);
            this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            this.handleSwitch(jCSwitch, jCSwitch.selector, jCSwitch.cases, jCSwitch.isExhaustive);
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            this.handleSwitch(jCSwitchExpression, jCSwitchExpression.selector, jCSwitchExpression.cases, jCSwitchExpression.isExhaustive);
        }

        private void handleSwitch(JCTree jCTree, JCTree.JCExpression jCExpression, List<JCTree.JCCase> list, boolean bl) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            int n = this.nextadr;
            this.scanExpr(jCExpression);
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            List<JCTree.JCCase> list2 = list;
            while (list2.nonEmpty()) {
                this.inits.assign(bits);
                this.uninits.assign(this.uninits.andSet(bits2));
                JCTree.JCCase jCCase = (JCTree.JCCase)list2.head;
                for (JCTree.JCCaseLabel jCCaseLabel : jCCase.labels) {
                    this.scanPattern(jCCaseLabel);
                }
                this.scan(jCCase.guard);
                if (this.inits.isReset()) {
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                }
                this.scan(jCCase.stats);
                if (jCCase.completesNormally && jCCase.caseKind == JCTree.JCCase.RULE) {
                    this.scanSyntheticBreak(Flow.this.make, jCTree);
                }
                this.addVars(jCCase.stats, bits, bits2);
                list2 = list2.tail;
            }
            if (!bl) {
                if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                    this.markDead();
                } else if (jCTree.hasTag(JCTree.Tag.SWITCH) && !TreeInfo.expectedExhaustive((JCTree.JCSwitch)jCTree)) {
                    this.inits.assign(bits);
                    this.uninits.assign(this.uninits.andSet(bits2));
                }
            }
            if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                this.resolveYields(jCTree, listBuffer);
            } else {
                this.resolveBreaks(jCTree, listBuffer);
            }
            this.nextadr = n;
        }

        private void addVars(List<JCTree.JCStatement> list, Bits bits, Bits bits2) {
            while (list.nonEmpty()) {
                JCTree jCTree = (JCTree)list.head;
                if (jCTree.hasTag(JCTree.Tag.VARDEF)) {
                    int n = ((JCTree.JCVariableDecl)jCTree).sym.adr;
                    bits.excl(n);
                    bits2.incl(n);
                }
                list = list.tail;
            }
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            Object object;
            Iterator iterator;
            ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
            Bits bits = new Bits(this.uninitsTry);
            ListBuffer listBuffer2 = this.pendingExits;
            this.pendingExits = new ListBuffer();
            Bits bits2 = new Bits(this.inits);
            this.uninitsTry.assign(this.uninits);
            for (JCTree object32 : jCTry.resources) {
                if (object32 instanceof JCTree.JCVariableDecl) {
                    iterator = (JCTree.JCVariableDecl)object32;
                    this.visitVarDef((JCTree.JCVariableDecl)((Object)iterator));
                    this.unrefdResources.enter(((JCTree.JCVariableDecl)((Object)iterator)).sym);
                    listBuffer.append((JCTree.JCVariableDecl)((Object)iterator));
                    continue;
                }
                if (object32 instanceof JCTree.JCExpression) {
                    JCTree.JCExpression n = (JCTree.JCExpression)object32;
                    this.scanExpr(n);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            this.scan(jCTry.body);
            this.uninitsTry.andSet(this.uninits);
            Bits bits3 = new Bits(this.inits);
            Bits bits4 = new Bits(this.uninits);
            int n = this.nextadr;
            if (!listBuffer.isEmpty() && Flow.this.lint.isEnabled(Lint.LintCategory.TRY)) {
                for (JCTree.JCVariableDecl jCVariableDecl : listBuffer) {
                    if (!this.unrefdResources.includes(jCVariableDecl.sym) || jCVariableDecl.sym.isUnnamedVariable()) continue;
                    Flow.this.log.warning(jCVariableDecl.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.TryResourceNotReferenced(jCVariableDecl.sym));
                    this.unrefdResources.remove(jCVariableDecl.sym);
                }
            }
            iterator = new Bits(bits2);
            Bits bits5 = new Bits(this.uninitsTry);
            AbstractCollection abstractCollection = jCTry.catchers;
            while (((List)abstractCollection).nonEmpty()) {
                object = ((JCTree.JCCatch)((List)abstractCollection).head).param;
                this.inits.assign((Bits)((Object)iterator));
                this.uninits.assign(bits5);
                this.scan((JCTree)object);
                this.initParam((JCTree.JCVariableDecl)object);
                this.scan(((JCTree.JCCatch)((List)abstractCollection).head).body);
                bits3.andSet(this.inits);
                bits4.andSet(this.uninits);
                this.nextadr = n;
                abstractCollection = ((List)abstractCollection).tail;
            }
            if (jCTry.finalizer != null) {
                this.inits.assign(bits2);
                this.uninits.assign(this.uninitsTry);
                abstractCollection = this.pendingExits;
                this.pendingExits = listBuffer2;
                this.scan(jCTry.finalizer);
                if (jCTry.finallyCanCompleteNormally) {
                    this.uninits.andSet(bits4);
                    while (((ListBuffer)abstractCollection).nonEmpty()) {
                        object = (BaseAnalyzer.PendingExit)((ListBuffer)abstractCollection).next();
                        if (object instanceof AssignPendingExit) {
                            AssignPendingExit assignPendingExit = (AssignPendingExit)object;
                            assignPendingExit.exit_inits.orSet(this.inits);
                            assignPendingExit.exit_uninits.andSet(this.uninits);
                        }
                        this.pendingExits.append(object);
                    }
                    this.inits.orSet(bits3);
                }
            } else {
                this.inits.assign(bits3);
                this.uninits.assign(bits4);
                abstractCollection = this.pendingExits;
                this.pendingExits = listBuffer2;
                while (((ListBuffer)abstractCollection).nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)((ListBuffer)abstractCollection).next());
                }
            }
            this.uninitsTry.andSet(bits).andSet(this.uninits);
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            this.scanCond(jCConditional.cond);
            Bits bits = new Bits(this.initsWhenFalse);
            Bits bits2 = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            if (jCConditional.truepart.type.hasTag(TypeTag.BOOLEAN) && jCConditional.falsepart.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(jCConditional.truepart);
                Bits bits3 = new Bits(this.initsWhenTrue);
                Bits bits4 = new Bits(this.initsWhenFalse);
                Bits bits5 = new Bits(this.uninitsWhenTrue);
                Bits bits6 = new Bits(this.uninitsWhenFalse);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scanCond(jCConditional.falsepart);
                this.initsWhenTrue.andSet(bits3);
                this.initsWhenFalse.andSet(bits4);
                this.uninitsWhenTrue.andSet(bits5);
                this.uninitsWhenFalse.andSet(bits6);
            } else {
                this.scanExpr(jCConditional.truepart);
                Bits bits7 = new Bits(this.inits);
                Bits bits8 = new Bits(this.uninits);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scanExpr(jCConditional.falsepart);
                this.inits.andSet(bits7);
                this.uninits.andSet(bits8);
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scanCond(jCIf.cond);
            Bits bits = new Bits(this.initsWhenFalse);
            Bits bits2 = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            this.scan(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                Bits bits3 = new Bits(this.inits);
                Bits bits4 = new Bits(this.uninits);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scan(jCIf.elsepart);
                this.inits.andSet(bits3);
                this.uninits.andSet(bits4);
            } else {
                this.inits.andSet(bits);
                this.uninits.andSet(bits2);
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new AssignPendingExit(jCBreak, this.inits, this.uninits));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            JCTree.JCSwitchExpression jCSwitchExpression = (JCTree.JCSwitchExpression)jCYield.target;
            if (jCSwitchExpression != null && jCSwitchExpression.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(jCYield.value);
                final Bits bits = new Bits(this.initsWhenTrue);
                final Bits bits2 = new Bits(this.initsWhenFalse);
                final Bits bits3 = new Bits(this.uninitsWhenTrue);
                final Bits bits4 = new Bits(this.uninitsWhenFalse);
                BaseAnalyzer.PendingExit pendingExit = new BaseAnalyzer.PendingExit(jCYield){

                    @Override
                    void resolveJump() {
                        if (!AssignAnalyzer.this.inits.isReset()) {
                            AssignAnalyzer.this.split(true);
                        }
                        AssignAnalyzer.this.initsWhenTrue.andSet(bits);
                        AssignAnalyzer.this.initsWhenFalse.andSet(bits2);
                        AssignAnalyzer.this.uninitsWhenTrue.andSet(bits3);
                        AssignAnalyzer.this.uninitsWhenFalse.andSet(bits4);
                    }
                };
                this.merge();
                this.recordExit(pendingExit);
                return;
            }
            this.scanExpr(jCYield.value);
            this.recordExit(new AssignPendingExit(jCYield, this.inits, this.uninits));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new AssignPendingExit(jCContinue, this.inits, this.uninits));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scanExpr(jCReturn.expr);
            this.recordExit(new AssignPendingExit(jCReturn, this.inits, this.uninits));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scanExpr(jCThrow.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scanExpr(jCMethodInvocation.meth);
            this.scanExprs(jCMethodInvocation.args);
            if (this.isConstructor) {
                Name name = TreeInfo.name(jCMethodInvocation.meth);
                if (name == ((Flow)Flow.this).names._super) {
                    this.forEachInitializer(this.classDef, false, jCTree -> {
                        this.scan((JCTree)jCTree);
                        this.clearPendingExits(false);
                    });
                } else if (name == ((Flow)Flow.this).names._this) {
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        Symbol.VarSymbol varSymbol = this.vardecls[i].sym;
                        if (!this.isFinalUninitializedField(varSymbol) || varSymbol.isStatic()) continue;
                        this.letInit(jCMethodInvocation.pos(), varSymbol);
                    }
                }
            }
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scanExpr(jCNewClass.encl);
            this.scanExprs(jCNewClass.args);
            this.scan(jCNewClass.def);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            Bits bits = new Bits(this.uninits);
            Bits bits2 = new Bits(this.uninitsTry);
            Bits bits3 = new Bits(this.inits);
            int n = this.returnadr;
            int n2 = this.nextadr;
            ListBuffer listBuffer = this.pendingExits;
            try {
                this.uninits.excludeFrom(this.firstadr);
                this.returnadr = this.nextadr;
                this.pendingExits = new ListBuffer();
                List<JCTree.JCVariableDecl> list = jCLambda.params;
                while (list.nonEmpty()) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.scan(jCVariableDecl);
                    this.inits.incl(jCVariableDecl.sym.adr);
                    this.uninits.excl(jCVariableDecl.sym.adr);
                    list = list.tail;
                }
                if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    this.scanExpr(jCLambda.body);
                } else {
                    this.scan(jCLambda.body);
                }
            }
            finally {
                this.returnadr = n;
                this.uninits.assign(bits);
                this.uninitsTry.assign(bits2);
                this.inits.assign(bits3);
                this.pendingExits = listBuffer;
                this.nextadr = n2;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            this.scanExprs(jCNewArray.dims);
            this.scanExprs(jCNewArray.elems);
        }

        @Override
        public void visitAssert(JCTree.JCAssert jCAssert) {
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            this.scanCond(jCAssert.cond);
            bits2.andSet(this.uninitsWhenTrue);
            if (jCAssert.detail != null) {
                this.inits.assign(this.initsWhenFalse);
                this.uninits.assign(this.uninitsWhenFalse);
                this.scanExpr(jCAssert.detail);
            }
            this.inits.assign(bits);
            this.uninits.assign(bits2);
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            if (!TreeInfo.isIdentOrThisDotIdent(jCAssign.lhs)) {
                this.scanExpr(jCAssign.lhs);
            }
            this.scanExpr(jCAssign.rhs);
            this.letInit(jCAssign.lhs);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            super.visitSelect(jCFieldAccess);
            if (TreeInfo.isThisQualifier(jCFieldAccess.selected) && jCFieldAccess.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(jCFieldAccess.pos(), (Symbol.VarSymbol)jCFieldAccess.sym);
            }
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            this.scanExpr(jCAssignOp.lhs);
            this.scanExpr(jCAssignOp.rhs);
            this.letInit(jCAssignOp.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case NOT: {
                    this.scanCond(jCUnary.arg);
                    Bits bits = new Bits(this.initsWhenFalse);
                    this.initsWhenFalse.assign(this.initsWhenTrue);
                    this.initsWhenTrue.assign(bits);
                    bits.assign(this.uninitsWhenFalse);
                    this.uninitsWhenFalse.assign(this.uninitsWhenTrue);
                    this.uninitsWhenTrue.assign(bits);
                    break;
                }
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scanExpr(jCUnary.arg);
                    this.letInit(jCUnary.arg);
                    break;
                }
                default: {
                    this.scanExpr(jCUnary.arg);
                }
            }
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            switch (jCBinary.getTag()) {
                case AND: {
                    this.scanCond(jCBinary.lhs);
                    Bits bits = new Bits(this.initsWhenFalse);
                    Bits bits2 = new Bits(this.uninitsWhenFalse);
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                    this.scanCond(jCBinary.rhs);
                    this.initsWhenFalse.andSet(bits);
                    this.uninitsWhenFalse.andSet(bits2);
                    break;
                }
                case OR: {
                    this.scanCond(jCBinary.lhs);
                    Bits bits = new Bits(this.initsWhenTrue);
                    Bits bits3 = new Bits(this.uninitsWhenTrue);
                    this.inits.assign(this.initsWhenFalse);
                    this.uninits.assign(this.uninitsWhenFalse);
                    this.scanCond(jCBinary.rhs);
                    this.initsWhenTrue.andSet(bits);
                    this.uninitsWhenTrue.andSet(bits3);
                    break;
                }
                default: {
                    this.scanExpr(jCBinary.lhs);
                    this.scanExpr(jCBinary.rhs);
                }
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(jCIdent.pos(), (Symbol.VarSymbol)jCIdent.sym);
                this.referenced(jCIdent.sym);
            }
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
            this.scanExpr(jCInstanceOf.expr);
            this.scan(jCInstanceOf.pattern);
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
            this.scan(jCBindingPattern.var);
            this.initParam(jCBindingPattern.var);
        }

        void referenced(Symbol symbol) {
            this.unrefdResources.remove(symbol);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            jCAnnotatedType.underlyingType.accept(this);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<?> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<?> env, JCTree jCTree, TreeMaker treeMaker) {
            int n;
            try {
                this.startPos = jCTree.pos().getStartPosition();
                if (this.vardecls == null) {
                    this.vardecls = new JCTree.JCVariableDecl[32];
                } else {
                    for (n = 0; n < this.vardecls.length; ++n) {
                        this.vardecls[n] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.classDef = null;
                this.unrefdResources = Scope.WriteableScope.create(env.enclClass.sym);
                this.scan(jCTree);
                this.startPos = -1;
            }
            catch (Throwable throwable) {
                this.startPos = -1;
                this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
                if (this.vardecls != null) {
                    for (int i = 0; i < this.vardecls.length; ++i) {
                        this.vardecls[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                Flow.this.make = null;
                this.pendingExits = null;
                this.classDef = null;
                this.unrefdResources = null;
                throw throwable;
            }
            this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
            if (this.vardecls != null) {
                for (n = 0; n < this.vardecls.length; ++n) {
                    this.vardecls[n] = null;
                }
            }
            this.firstadr = 0;
            this.nextadr = 0;
            Flow.this.make = null;
            this.pendingExits = null;
            this.classDef = null;
            this.unrefdResources = null;
        }

        public class AssignPendingExit
        extends BaseAnalyzer.PendingExit {
            final Bits inits;
            final Bits uninits;
            final Bits exit_inits;
            final Bits exit_uninits;

            public AssignPendingExit(JCTree jCTree, Bits bits, Bits bits2) {
                super(jCTree);
                this.exit_inits = new Bits(true);
                this.exit_uninits = new Bits(true);
                this.inits = bits;
                this.uninits = bits2;
                this.exit_inits.assign(bits);
                this.exit_uninits.assign(bits2);
            }

            @Override
            public void resolveJump() {
                this.inits.andSet(this.exit_inits);
                this.uninits.andSet(this.exit_uninits);
            }
        }
    }

    class FlowAnalyzer
    extends BaseAnalyzer {
        HashMap<Symbol, List<Type>> preciseRethrowTypes;
        JCTree.JCClassDecl classDef;
        List<Type> thrown;
        List<Type> caught;

        FlowAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void errorUncaught() {
            BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)this.pendingExits.next();
            while (pendingExit != null) {
                if (pendingExit instanceof ThrownPendingExit) {
                    ThrownPendingExit thrownPendingExit = (ThrownPendingExit)pendingExit;
                    if (this.classDef != null && this.classDef.pos == pendingExit.tree.pos) {
                        Flow.this.log.error(pendingExit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionDefaultConstructor(thrownPendingExit.thrown));
                    } else if (pendingExit.tree.hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)pendingExit.tree).sym.isResourceVariable()) {
                        Flow.this.log.error(pendingExit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionImplicitClose(thrownPendingExit.thrown, ((JCTree.JCVariableDecl)pendingExit.tree).sym.name));
                    } else {
                        Flow.this.log.error(pendingExit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionNeedToCatchOrThrow(thrownPendingExit.thrown));
                    }
                } else {
                    Assert.check(Flow.this.log.hasErrorOn(pendingExit.tree.pos()));
                }
                pendingExit = (BaseAnalyzer.PendingExit)this.pendingExits.next();
            }
        }

        void markThrown(JCTree jCTree, Type type) {
            if (!Flow.this.chk.isUnchecked(jCTree.pos(), type)) {
                if (!Flow.this.chk.isHandled(type, this.caught)) {
                    this.pendingExits.append(new ThrownPendingExit(jCTree, type));
                }
                this.thrown = Flow.this.chk.incl(type, this.thrown);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            JCTree.JCClassDecl jCClassDecl2 = this.classDef;
            List<Type> list = this.thrown;
            List<Type> list2 = this.caught;
            ListBuffer listBuffer = this.pendingExits;
            Lint lint = Flow.this.lint;
            boolean bl = jCClassDecl.name == ((Flow)Flow.this).names.empty;
            this.pendingExits = new ListBuffer();
            if (!bl) {
                this.caught = List.nil();
            }
            this.classDef = jCClassDecl;
            this.thrown = List.nil();
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                List<JCTree> list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (((JCTree)list3.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        this.scan((JCTree)list3.head);
                    }
                    list3 = list3.tail;
                }
                this.forEachInitializer(jCClassDecl, true, jCTree -> {
                    this.scan((JCTree)jCTree);
                    this.errorUncaught();
                });
                if (bl) {
                    list3 = jCClassDecl.defs;
                    while (list3.nonEmpty()) {
                        if (TreeInfo.isConstructor((JCTree)list3.head)) {
                            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)list3.head;
                            this.scan(jCMethodDecl);
                            jCMethodDecl.thrown = Flow.this.make.Types(this.thrown);
                            jCMethodDecl.sym.type = Flow.this.types.createMethodTypeWithThrown(jCMethodDecl.sym.type, this.thrown);
                        }
                        list3 = list3.tail;
                    }
                    list = Flow.this.chk.union(this.thrown, list);
                }
                list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!(bl && TreeInfo.isConstructor((JCTree)list3.head) || !((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF))) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                this.thrown = list;
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list2;
                this.classDef = jCClassDecl2;
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            List<Type> list = this.caught;
            List<Type> list2 = jCMethodDecl.sym.type.getThrownTypes();
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                Object object;
                List<JCTree.JCVariableDecl> list3 = jCMethodDecl.params;
                while (list3.nonEmpty()) {
                    object = (JCTree.JCVariableDecl)list3.head;
                    this.scan((JCTree)object);
                    list3 = list3.tail;
                }
                if (TreeInfo.hasConstructorCall(jCMethodDecl, ((Flow)Flow.this).names._super)) {
                    this.caught = Flow.this.chk.union(this.caught, list2);
                } else if ((jCMethodDecl.sym.flags() & 0x100008L) != 0x100000L) {
                    this.caught = list2;
                }
                this.scan(jCMethodDecl.body);
                list3 = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list3.nonEmpty()) {
                    object = (BaseAnalyzer.PendingExit)list3.head;
                    list3 = list3.tail;
                    if (!(object instanceof ThrownPendingExit)) {
                        Assert.check(((BaseAnalyzer.PendingExit)object).tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(((BaseAnalyzer.PendingExit)object).tree.pos()));
                        continue;
                    }
                    this.pendingExits.append(object);
                }
            }
            finally {
                this.caught = list;
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.init != null) {
                Lint lint = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
                try {
                    this.scan(jCVariableDecl.init);
                }
                finally {
                    Flow.this.lint = lint;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            this.scan(jCBlock.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCDoWhileLoop.body);
            this.resolveContinues(jCDoWhileLoop);
            this.scan(jCDoWhileLoop.cond);
            this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCWhileLoop.cond);
            this.scan(jCWhileLoop.body);
            this.resolveContinues(jCWhileLoop);
            this.resolveBreaks(jCWhileLoop, listBuffer);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCForLoop.init);
            this.pendingExits = new ListBuffer();
            if (jCForLoop.cond != null) {
                this.scan(jCForLoop.cond);
            }
            this.scan(jCForLoop.body);
            this.resolveContinues(jCForLoop);
            this.scan(jCForLoop.step);
            this.resolveBreaks(jCForLoop, listBuffer);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCEnhancedForLoop.expr);
            this.pendingExits = new ListBuffer();
            this.scan(jCEnhancedForLoop.body);
            this.resolveContinues(jCEnhancedForLoop);
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCLabeledStatement.body);
            this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            this.handleSwitch(jCSwitch, jCSwitch.selector, jCSwitch.cases);
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            this.handleSwitch(jCSwitchExpression, jCSwitchExpression.selector, jCSwitchExpression.cases);
        }

        private void handleSwitch(JCTree jCTree, JCTree.JCExpression jCExpression, List<JCTree.JCCase> list) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCExpression);
            List<JCTree.JCCase> list2 = list;
            while (list2.nonEmpty()) {
                JCTree.JCCase jCCase = (JCTree.JCCase)list2.head;
                this.scan(jCCase.labels);
                this.scan(jCCase.stats);
                list2 = list2.tail;
            }
            if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                this.resolveYields(jCTree, listBuffer);
            } else {
                this.resolveBreaks(jCTree, listBuffer);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            void var6_12;
            Object object;
            List<Type> list;
            Object object2;
            AbstractCollection abstractCollection;
            Object object4;
            List<Type> list2 = this.caught;
            List<Type> list3 = this.thrown;
            this.thrown = List.nil();
            AbstractCollection abstractCollection2 = jCTry.catchers;
            while (abstractCollection2.nonEmpty()) {
                object4 = TreeInfo.isMultiCatch((JCTree.JCCatch)abstractCollection2.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)abstractCollection2.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)abstractCollection2.head).param.vartype);
                Iterator object32 = ((List)object4).iterator();
                while (object32.hasNext()) {
                    abstractCollection = (JCTree.JCExpression)object32.next();
                    this.caught = Flow.this.chk.incl(((JCTree.JCExpression)((Object)abstractCollection)).type, this.caught);
                }
                abstractCollection2 = abstractCollection2.tail;
            }
            abstractCollection2 = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree jCTree : jCTry.resources) {
                if (jCTree instanceof JCTree.JCVariableDecl) {
                    object2 = (JCTree.JCVariableDecl)jCTree;
                    this.visitVarDef((JCTree.JCVariableDecl)object2);
                    continue;
                }
                if (jCTree instanceof JCTree.JCExpression) {
                    abstractCollection = (JCTree.JCExpression)jCTree;
                    this.scan((JCTree)((Object)abstractCollection));
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            for (JCTree jCTree : jCTry.resources) {
                abstractCollection = jCTree.type.isCompound() ? Flow.this.types.interfaces(jCTree.type).prepend(Flow.this.types.supertype(jCTree.type)) : List.of(jCTree.type);
                for (Object object3 : abstractCollection) {
                    if (Flow.this.types.asSuper((Type)object3, ((Flow)Flow.this).syms.autoCloseableType.tsym) == null) continue;
                    list = Flow.this.rs.resolveQualifiedMethod(jCTry, Flow.this.attrEnv, Flow.this.types.skipTypeVars((Type)object3, false), ((Flow)Flow.this).names.close, List.nil(), List.nil());
                    object = Flow.this.types.memberType(jCTree.type, (Symbol)((Object)list));
                    if (((Symbol)((Object)list)).kind != Kinds.Kind.MTH) continue;
                    for (Type type : ((Type)object).getThrownTypes()) {
                        this.markThrown(jCTree, type);
                    }
                }
            }
            this.scan(jCTry.body);
            object4 = Flow.this.chk.union(this.thrown, List.of(((Flow)Flow.this).syms.runtimeExceptionType, ((Flow)Flow.this).syms.errorType));
            this.thrown = list3;
            this.caught = list2;
            List list4 = List.nil();
            abstractCollection = jCTry.catchers;
            while (((List)abstractCollection).nonEmpty()) {
                Object object3;
                object2 = ((JCTree.JCCatch)((List)abstractCollection).head).param;
                object3 = TreeInfo.isMultiCatch((JCTree.JCCatch)((List)abstractCollection).head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)((List)abstractCollection).head).param.vartype).alternatives : List.of(((JCTree.JCCatch)((List)abstractCollection).head).param.vartype);
                list = List.nil();
                object = Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12);
                Iterator<Object> iterator = ((List)object3).iterator();
                while (iterator.hasNext()) {
                    JCTree.JCExpression jCExpression = (JCTree.JCExpression)iterator.next();
                    Type type = jCExpression.type;
                    if (type == ((Flow)Flow.this).syms.unknownType) continue;
                    list = list.append(type);
                    if (Flow.this.types.isSameType(type, ((Flow)Flow.this).syms.objectType)) continue;
                    JCDiagnostic.DiagnosticPosition diagnosticPosition = ((List)object3).size() > 1 ? jCExpression.pos() : ((JCTree.JCCatch)((List)abstractCollection).head).pos();
                    this.checkCaughtType(diagnosticPosition, type, (List<Type>)object4, (List<Type>)var6_12);
                    List<Type> list5 = Flow.this.chk.incl(type, (List<Type>)var6_12);
                }
                this.scan((JCTree)object2);
                this.preciseRethrowTypes.put(((JCTree.JCVariableDecl)object2).sym, Flow.this.chk.intersect(list, (List<Type>)object));
                this.scan(((JCTree.JCCatch)((List)abstractCollection).head).body);
                this.preciseRethrowTypes.remove(((JCTree.JCVariableDecl)object2).sym);
                abstractCollection = ((List)abstractCollection).tail;
            }
            if (jCTry.finalizer != null) {
                abstractCollection = this.thrown;
                this.thrown = List.nil();
                object2 = this.pendingExits;
                this.pendingExits = abstractCollection2;
                this.scan(jCTry.finalizer);
                if (!jCTry.finallyCanCompleteNormally) {
                    this.thrown = Flow.this.chk.union(this.thrown, list3);
                } else {
                    this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12));
                    this.thrown = Flow.this.chk.union(this.thrown, (List<Type>)abstractCollection);
                    while (((ListBuffer)object2).nonEmpty()) {
                        this.pendingExits.append((BaseAnalyzer.PendingExit)((ListBuffer)object2).next());
                    }
                }
            } else {
                this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12));
                abstractCollection = this.pendingExits;
                this.pendingExits = abstractCollection2;
                while (((ListBuffer)abstractCollection).nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)((ListBuffer)abstractCollection).next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.cond);
            this.scan(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                this.scan(jCIf.elsepart);
            }
        }

        void checkCaughtType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type> list, List<Type> list2) {
            if (Flow.this.chk.subset(type, list2)) {
                Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.ExceptAlreadyCaught(type));
            } else if (!(Flow.this.chk.isUnchecked(diagnosticPosition, type) || this.isExceptionOrThrowable(type) || Flow.this.chk.intersects(type, list))) {
                Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.ExceptNeverThrownInTry(type));
            } else {
                List<Type> list3 = Flow.this.chk.intersect(List.of(type), list);
                if (Flow.this.chk.diff(list3, list2).isEmpty() && !this.isExceptionOrThrowable(type)) {
                    JCDiagnostic.Warning warning = list3.length() == 1 ? CompilerProperties.Warnings.UnreachableCatch(list3) : CompilerProperties.Warnings.UnreachableCatch1(list3);
                    Flow.this.log.warning(diagnosticPosition, warning);
                }
            }
        }

        private boolean isExceptionOrThrowable(Type type) {
            return type.tsym == ((Flow)Flow.this).syms.throwableType.tsym || type.tsym == ((Flow)Flow.this).syms.exceptionType.tsym;
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCBreak));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            this.scan(jCYield.value);
            this.recordExit(new BaseAnalyzer.PendingExit(jCYield));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCContinue));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scan(jCReturn.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scan(jCThrow.expr);
            Symbol symbol = TreeInfo.symbol(jCThrow.expr);
            if (symbol != null && symbol.kind == Kinds.Kind.VAR && (symbol.flags() & 0x20000000010L) != 0L && this.preciseRethrowTypes.get(symbol) != null) {
                for (Type type : this.preciseRethrowTypes.get(symbol)) {
                    this.markThrown(jCThrow, type);
                }
            } else {
                this.markThrown(jCThrow, jCThrow.expr.type);
            }
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scan(jCMethodInvocation.meth);
            this.scan(jCMethodInvocation.args);
            List<Type> list = jCMethodInvocation.meth.type.getThrownTypes();
            while (list.nonEmpty()) {
                this.markThrown(jCMethodInvocation, (Type)list.head);
                list = list.tail;
            }
            if (TreeInfo.name(jCMethodInvocation.meth) == ((Flow)Flow.this).names._super) {
                this.forEachInitializer(this.classDef, false, jCTree -> {
                    this.scan((JCTree)jCTree);
                    this.errorUncaught();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.args);
            List<Type> list = jCNewClass.constructorType.getThrownTypes();
            while (list.nonEmpty()) {
                this.markThrown(jCNewClass, (Type)list.head);
                list = list.tail;
            }
            list = this.caught;
            try {
                if (jCNewClass.def != null) {
                    List<Type> list2 = jCNewClass.constructor.type.getThrownTypes();
                    while (list2.nonEmpty()) {
                        this.caught = Flow.this.chk.incl((Type)list2.head, this.caught);
                        list2 = list2.tail;
                    }
                }
                this.scan(jCNewClass.def);
            }
            finally {
                this.caught = list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous()) {
                return;
            }
            List<Type> list = this.caught;
            List<Type> list2 = this.thrown;
            ListBuffer listBuffer = this.pendingExits;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = jCLambda.getDescriptorType(Flow.this.types).getThrownTypes();
                this.thrown = List.nil();
                this.scan(jCLambda.body);
                List list3 = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list3.nonEmpty()) {
                    BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list3.head;
                    list3 = list3.tail;
                    if (!(pendingExit instanceof ThrownPendingExit)) {
                        Assert.check(pendingExit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(pendingExit.tree.pos()));
                        continue;
                    }
                    this.pendingExits.append(pendingExit);
                }
                this.errorUncaught();
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list;
                this.thrown = list2;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.preciseRethrowTypes = new HashMap();
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
            }
        }

        class ThrownPendingExit
        extends BaseAnalyzer.PendingExit {
            Type thrown;

            ThrownPendingExit(JCTree jCTree, Type type) {
                super(jCTree);
                this.thrown = type;
            }
        }
    }

    class CaptureAnalyzer
    extends BaseAnalyzer {
        JCTree currentTree;
        Scope.WriteableScope declaredInsideGuard;

        CaptureAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void checkEffectivelyFinal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            if (this.currentTree != null && varSymbol.owner.kind == Kinds.Kind.MTH && varSymbol.pos < this.getCurrentTreeStartPosition()) {
                switch (this.currentTree.getTag()) {
                    case CLASSDEF: 
                    case CASE: 
                    case LAMBDA: {
                        if ((varSymbol.flags() & 0x20000000010L) != 0L) break;
                        this.reportEffectivelyFinalError(diagnosticPosition, varSymbol);
                    }
                }
            }
        }

        int getCurrentTreeStartPosition() {
            int n;
            JCTree jCTree = this.currentTree;
            if (jCTree instanceof JCTree.JCCase) {
                JCTree.JCCase jCCase = (JCTree.JCCase)jCTree;
                n = jCCase.guard.getStartPosition();
            } else {
                n = this.currentTree.getStartPosition();
            }
            return n;
        }

        void letInit(JCTree jCTree) {
            if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.IDENT) || jCTree.hasTag(JCTree.Tag.SELECT)) {
                Symbol symbol = TreeInfo.symbol(jCTree);
                if (this.currentTree != null) {
                    switch (this.currentTree.getTag()) {
                        case CLASSDEF: 
                        case LAMBDA: {
                            if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind != Kinds.Kind.MTH || ((Symbol.VarSymbol)symbol).pos >= this.currentTree.getStartPosition()) break;
                            this.reportEffectivelyFinalError(jCTree, symbol);
                            break;
                        }
                        case CASE: {
                            if (this.declaredInsideGuard.includes(symbol)) break;
                            Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.CannotAssignNotDeclaredGuard(symbol));
                        }
                    }
                }
            }
        }

        void reportEffectivelyFinalError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            JCDiagnostic.Fragment fragment;
            switch (this.currentTree.getTag()) {
                case LAMBDA: {
                    fragment = CompilerProperties.Fragments.Lambda;
                    break;
                }
                case CASE: {
                    fragment = CompilerProperties.Fragments.Guard;
                    break;
                }
                case CLASSDEF: {
                    fragment = CompilerProperties.Fragments.InnerCls;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected tree kind: " + (Object)((Object)this.currentTree.getTag())));
                }
            }
            JCDiagnostic.Fragment fragment2 = fragment;
            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.CantRefNonEffectivelyFinalVar(symbol, Flow.this.diags.fragment(fragment2)));
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCClassDecl.sym.isDirectlyOrIndirectlyLocal() ? jCClassDecl : null;
                super.visitClassDef(jCClassDecl);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCLambda;
                super.visitLambda(jCLambda);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
            this.scan(jCBindingPattern.var);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitCase(JCTree.JCCase jCCase) {
            this.scan(jCCase.labels);
            if (jCCase.guard != null) {
                JCTree jCTree = this.currentTree;
                Scope.WriteableScope writeableScope = this.declaredInsideGuard;
                try {
                    this.currentTree = jCCase;
                    this.declaredInsideGuard = Scope.WriteableScope.create(((Flow)Flow.this).attrEnv.enclClass.sym);
                    this.scan(jCCase.guard);
                }
                finally {
                    this.currentTree = jCTree;
                    this.declaredInsideGuard = writeableScope;
                }
            }
            this.scan(jCCase.stats);
        }

        @Override
        public void visitRecordPattern(JCTree.JCRecordPattern jCRecordPattern) {
            this.scan(jCRecordPattern.deconstructor);
            this.scan(jCRecordPattern.nested);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.kind == Kinds.Kind.VAR) {
                this.checkEffectivelyFinal(jCIdent, (Symbol.VarSymbol)jCIdent.sym);
            }
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCAssign.lhs);
            if (!(jCExpression instanceof JCTree.JCIdent)) {
                this.scan(jCExpression);
            }
            this.scan(jCAssign.rhs);
            this.letInit(jCExpression);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            this.scan(jCAssignOp.lhs);
            this.scan(jCAssignOp.rhs);
            this.letInit(jCAssignOp.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scan(jCUnary.arg);
                    this.letInit(jCUnary.arg);
                    break;
                }
                default: {
                    this.scan(jCUnary.arg);
                }
            }
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            for (JCTree jCTree : jCTry.resources) {
                Symbol symbol;
                if (jCTree.hasTag(JCTree.Tag.VARDEF) || (symbol = TreeInfo.symbol(jCTree)) == null || (symbol.flags() & 0x20000000010L) != 0L) continue;
                Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.TryWithResourcesExprEffectivelyFinalVar(symbol));
            }
            super.visitTry(jCTry);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (this.declaredInsideGuard != null) {
                this.declaredInsideGuard.enter(jCVariableDecl.sym);
            }
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            this.scan(jCYield.value);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    class LambdaAliveAnalyzer
    extends AliveAnalyzer {
        boolean inLambda;

        LambdaAliveAnalyzer() {
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inLambda || jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    class LambdaAssignAnalyzer
    extends AssignAnalyzer {
        Scope.WriteableScope enclosedSymbols;
        boolean inLambda;

        LambdaAssignAnalyzer(Env<AttrContext> env) {
            this.enclosedSymbols = Scope.WriteableScope.create(env.enclClass.sym);
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inLambda) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            this.enclosedSymbols.enter(jCVariableDecl.sym);
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            return this.enclosedSymbols.includes(varSymbol) && varSymbol.owner.kind == Kinds.Kind.MTH;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    class LambdaFlowAnalyzer
    extends FlowAnalyzer {
        List<Type> inferredThrownTypes;
        boolean inLambda;

        LambdaFlowAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous() || this.inLambda) {
                return;
            }
            List list = this.caught;
            List list2 = this.thrown;
            ListBuffer listBuffer = this.pendingExits;
            this.inLambda = true;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = List.of(((Flow)Flow.this).syms.throwableType);
                this.thrown = List.nil();
                this.scan(jCLambda.body);
                this.inferredThrownTypes = this.thrown;
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list;
                this.thrown = list2;
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    class SnippetAliveAnalyzer
    extends AliveAnalyzer {
        SnippetAliveAnalyzer() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
        }

        public boolean isAlive() {
            return ((AliveAnalyzer)this).alive != Liveness.DEAD;
        }
    }

    class SnippetBreakToAnalyzer
    extends AliveAnalyzer {
        private final JCTree breakTo;
        private boolean breaksTo;

        public SnippetBreakToAnalyzer(JCTree jCTree) {
            this.breakTo = jCTree;
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.breaksTo |= this.breakTo == jCBreak.target && ((AliveAnalyzer)this).alive == Liveness.ALIVE;
        }

        public boolean breaksTo() {
            return this.breaksTo;
        }
    }

    static final class BindingPattern
    implements PatternDescription {
        private final Type type;

        BindingPattern(Type type) {
            this.type = type;
        }

        public int hashCode() {
            return this.type.tsym.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof BindingPattern)) return false;
            BindingPattern bindingPattern = (BindingPattern)object;
            if (this.type.tsym != bindingPattern.type.tsym) return false;
            return true;
        }

        public String toString() {
            return this.type.tsym + " _";
        }

        public Type type() {
            return this.type;
        }
    }

    static final class RecordPattern
    implements PatternDescription {
        private final Type recordType;
        private final int _hashCode;
        private final Type[] fullComponentTypes;
        private final PatternDescription[] nested;

        public RecordPattern(Type type, Type[] typeArray, PatternDescription[] patternDescriptionArray) {
            this(type, RecordPattern.hashCode(-1, type, patternDescriptionArray), typeArray, patternDescriptionArray);
        }

        RecordPattern(Type type, int n, Type[] typeArray, PatternDescription ... patternDescriptionArray) {
            this.recordType = type;
            this._hashCode = n;
            this.fullComponentTypes = typeArray;
            this.nested = patternDescriptionArray;
        }

        public int hashCode() {
            return this._hashCode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof RecordPattern)) return false;
            RecordPattern recordPattern = (RecordPattern)object;
            if (this.recordType.tsym != recordPattern.recordType.tsym) return false;
            if (!Arrays.equals(this.nested, recordPattern.nested)) return false;
            return true;
        }

        public int hashCode(int n) {
            return RecordPattern.hashCode(n, this.recordType, this.nested);
        }

        public static int hashCode(int n, Type type, PatternDescription ... patternDescriptionArray) {
            int n2 = 5;
            n2 = 41 * n2 + type.tsym.hashCode();
            for (int i = 0; i < patternDescriptionArray.length; ++i) {
                if (i == n) continue;
                n2 = 41 * n2 + patternDescriptionArray[i].hashCode();
            }
            return n2;
        }

        public String toString() {
            return this.recordType.tsym + "(" + Arrays.stream(this.nested).map(patternDescription -> patternDescription.toString()).collect(Collectors.joining(", ")) + ")";
        }

        public Type recordType() {
            return this.recordType;
        }

        public int _hashCode() {
            return this._hashCode;
        }

        public Type[] fullComponentTypes() {
            return this.fullComponentTypes;
        }

        public PatternDescription[] nested() {
            return this.nested;
        }
    }

    static enum Liveness {
        ALIVE{

            @Override
            public Liveness or(Liveness liveness) {
                return this;
            }

            @Override
            public Liveness and(Liveness liveness) {
                return liveness;
            }
        }
        ,
        DEAD{

            @Override
            public Liveness or(Liveness liveness) {
                return liveness;
            }

            @Override
            public Liveness and(Liveness liveness) {
                return this;
            }
        }
        ,
        RECOVERY{

            @Override
            public Liveness or(Liveness liveness) {
                if (liveness == ALIVE) {
                    return ALIVE;
                }
                return this;
            }

            @Override
            public Liveness and(Liveness liveness) {
                if (liveness == DEAD) {
                    return DEAD;
                }
                return this;
            }
        };


        public abstract Liveness or(Liveness var1);

        public abstract Liveness and(Liveness var1);

        public Liveness or(boolean bl) {
            return this.or(Liveness.from(bl));
        }

        public Liveness and(boolean bl) {
            return this.and(Liveness.from(bl));
        }

        public static Liveness from(boolean bl) {
            return bl ? ALIVE : DEAD;
        }
    }

    static abstract class BaseAnalyzer
    extends TreeScanner {
        ListBuffer<PendingExit> pendingExits;
        JCTree.JCClassDecl initScanClass;

        BaseAnalyzer() {
        }

        abstract void markDead();

        void recordExit(PendingExit pendingExit) {
            this.pendingExits.append(pendingExit);
            this.markDead();
        }

        private Liveness resolveJump(JCTree jCTree, ListBuffer<PendingExit> listBuffer, JumpKind jumpKind) {
            boolean bl = false;
            List<PendingExit> list = this.pendingExits.toList();
            this.pendingExits = listBuffer;
            while (list.nonEmpty()) {
                PendingExit pendingExit = (PendingExit)list.head;
                if (pendingExit.tree.hasTag(jumpKind.treeTag) && jumpKind.getTarget(pendingExit.tree) == jCTree) {
                    pendingExit.resolveJump();
                    bl = true;
                } else {
                    this.pendingExits.append(pendingExit);
                }
                list = list.tail;
            }
            return Liveness.from(bl);
        }

        Liveness resolveContinues(JCTree jCTree) {
            return this.resolveJump(jCTree, new ListBuffer<PendingExit>(), JumpKind.CONTINUE);
        }

        Liveness resolveBreaks(JCTree jCTree, ListBuffer<PendingExit> listBuffer) {
            return this.resolveJump(jCTree, listBuffer, JumpKind.BREAK);
        }

        Liveness resolveYields(JCTree jCTree, ListBuffer<PendingExit> listBuffer) {
            return this.resolveJump(jCTree, listBuffer, JumpKind.YIELD);
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null && (jCTree.type == null || jCTree.type != Type.stuckType)) {
                super.scan(jCTree);
            }
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl jCPackageDecl) {
        }

        protected void scanSyntheticBreak(TreeMaker treeMaker, JCTree jCTree) {
            if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                JCTree.JCYield jCYield = treeMaker.at(-1).Yield(treeMaker.Erroneous().setType(jCTree.type));
                jCYield.target = jCTree;
                this.scan(jCYield);
            } else {
                JCTree.JCBreak jCBreak = treeMaker.at(-1).Break(null);
                jCBreak.target = jCTree;
                this.scan(jCBreak);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forEachInitializer(JCTree.JCClassDecl jCClassDecl, boolean bl, Consumer<? super JCTree> consumer) {
            if (jCClassDecl == this.initScanClass) {
                return;
            }
            JCTree.JCClassDecl jCClassDecl2 = this.initScanClass;
            this.initScanClass = jCClassDecl;
            try {
                List<JCTree> list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    JCTree jCTree = (JCTree)list.head;
                    if (!jCTree.hasTag(JCTree.Tag.CLASSDEF)) {
                        boolean bl2;
                        boolean bl3 = bl2 = ((TreeInfo.flags(jCTree) | (TreeInfo.symbolFor(jCTree) == null ? 0L : TreeInfo.symbolFor((JCTree)jCTree).flags_field)) & 8L) != 0L;
                        if (!jCTree.hasTag(JCTree.Tag.METHODDEF) && bl2 == bl) {
                            consumer.accept(jCTree);
                        }
                    }
                    list = list.tail;
                }
            }
            finally {
                this.initScanClass = jCClassDecl2;
            }
        }

        static class PendingExit {
            JCTree tree;

            PendingExit(JCTree jCTree) {
                this.tree = jCTree;
            }

            void resolveJump() {
            }
        }

        static enum JumpKind {
            BREAK(JCTree.Tag.BREAK){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCBreak)jCTree).target;
                }
            }
            ,
            CONTINUE(JCTree.Tag.CONTINUE){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCContinue)jCTree).target;
                }
            }
            ,
            YIELD(JCTree.Tag.YIELD){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCYield)jCTree).target;
                }
            };

            final JCTree.Tag treeTag;

            private JumpKind(JCTree.Tag tag) {
                this.treeTag = tag;
            }

            abstract JCTree getTarget(JCTree var1);
        }
    }

    static enum FlowKind {
        NORMAL("var.might.already.be.assigned", false),
        SPECULATIVE_LOOP("var.might.be.assigned.in.loop", true);

        final String errKey;
        final boolean isFinal;

        private FlowKind(String string2, boolean bl) {
            this.errKey = string2;
            this.isFinal = bl;
        }

        boolean isFinal() {
            return this.isFinal;
        }
    }
}

