/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.CaseTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.InferenceContext;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.lang.annotation.Documented;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor14;
import javax.tools.JavaFileManager;
import nbjavac.ObjectsWrapper;

public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private static final int FIRST = 1;
    private static final int SECOND = 2;
    private final Names names;
    private final Log log;
    private final Resolve rs;
    private final Symtab syms;
    private final Enter enter;
    private final DeferredAttr deferredAttr;
    private final Infer infer;
    private final Types types;
    private final TypeAnnotations typeAnnotations;
    private final JCDiagnostic.Factory diags;
    private final JavaFileManager fileManager;
    private final Source source;
    private final Target target;
    private final Profile profile;
    private final Preview preview;
    private final boolean warnOnAnyAccessToMembers;
    public boolean disablePreviewCheck;
    Lint lint;
    private Symbol.MethodSymbol method;
    char syntheticNameChar;
    private Map<Pair<Symbol.ModuleSymbol, Name>, Symbol.ClassSymbol> compiled = new HashMap<Pair<Symbol.ModuleSymbol, Name>, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler removalHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private DeferredLintHandler deferredLintHandler;
    private final boolean allowModules;
    private final boolean allowRecords;
    private final boolean allowSealed;
    private boolean importSuppression;
    private Map<Pair<Name, Name>, Integer> localClassNameIndexes = new HashMap<Pair<Name, Name>, Integer>();
    CheckContext basicHandler = new CheckContext(){

        @Override
        public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
            Check.this.log.error(diagnosticPosition, CompilerProperties.Errors.ProbFoundReq(jCDiagnostic));
        }

        @Override
        public boolean compatible(Type type, Type type2, Warner warner) {
            return Check.this.types.isAssignable(type, type2, warner);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
            return Check.this.convertWarner(diagnosticPosition, type, type2);
        }

        @Override
        public InferenceContext inferenceContext() {
            return ((Check)Check.this).infer.emptyContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return ((Check)Check.this).deferredAttr.emptyDeferredAttrContext;
        }

        public String toString() {
            return "CheckContext: basicHandler";
        }
    };
    private static final boolean ignoreAnnotatedCasts = true;
    private static final Types.SimpleVisitor<Boolean, Void> denotableChecker = new Types.SimpleVisitor<Boolean, Void>(){

        @Override
        public Boolean visitType(Type type, Void void_) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType classType, Void void_) {
            if (classType.isUnion() || classType.isIntersection()) {
                return false;
            }
            for (Type type : classType.allparams()) {
                if (((Boolean)this.visit(type, void_)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return (typeVar.tsym.flags() & 0x1000L) == 0L;
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType capturedType, Void void_) {
            return false;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType arrayType, Void void_) {
            return (Boolean)this.visit(arrayType.elemtype, void_);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            return (Boolean)this.visit(wildcardType.type, void_);
        }
    };
    Types.UnaryVisitor<Boolean> isTypeArgErroneous = new Types.UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type type, Void void_) {
            return type.isErroneous();
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar typeVar, Void void_) {
            return (Boolean)this.visit(typeVar.getUpperBound());
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType capturedType, Void void_) {
            return (Boolean)this.visit(capturedType.getUpperBound()) != false || (Boolean)this.visit(capturedType.getLowerBound()) != false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType wildcardType, Void void_) {
            return (Boolean)this.visit(wildcardType.type);
        }
    };
    Warner overrideWarner = new Warner();
    private Predicate<Symbol> equalsHasCodeFilter = symbol -> Symbol.MethodSymbol.implementation_filter.test((Symbol)symbol) && (symbol.flags() & 0x200000000000L) == 0L;
    private Set<Name> defaultTargets;
    private Name[] dfltTargetMeta;

    public static Check instance(Context context) {
        Check check = context.get(checkKey);
        if (check == null) {
            check = new Check(context);
        }
        return check;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.rs = Resolve.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.source = Source.instance(context);
        this.target = Target.instance(context);
        this.warnOnAnyAccessToMembers = options.isSet("warnOnAccessToMembers");
        this.disablePreviewCheck = false;
        Target target = Target.instance(context);
        this.syntheticNameChar = target.syntheticNameChar();
        this.profile = Profile.instance(context);
        this.preview = Preview.instance(context);
        boolean bl = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean bl2 = this.lint.isEnabled(Lint.LintCategory.REMOVAL);
        boolean bl3 = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        boolean bl4 = true;
        this.deprecationHandler = new MandatoryWarningHandler(this.log, null, bl, bl4, Lint.LintCategory.DEPRECATION, "deprecated");
        this.removalHandler = new MandatoryWarningHandler(this.log, null, bl2, bl4, Lint.LintCategory.REMOVAL);
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, null, bl3, bl4, Lint.LintCategory.UNCHECKED);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.allowModules = Source.Feature.MODULES.allowedInSource(this.source);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(this.source);
        this.allowSealed = Source.Feature.SEALED_CLASSES.allowedInSource(this.source);
    }

    Lint setLint(Lint lint) {
        Lint lint2 = this.lint;
        this.lint = lint;
        return lint2;
    }

    boolean setImportSuppression(boolean bl) {
        boolean bl2 = this.importSuppression;
        this.importSuppression = bl;
        return bl2;
    }

    Symbol.MethodSymbol setMethod(Symbol.MethodSymbol methodSymbol) {
        Symbol.MethodSymbol methodSymbol2 = this.method;
        this.method = methodSymbol;
        return methodSymbol2;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (symbol.isDeprecatedForRemoval()) {
            if (!this.lint.isSuppressed(Lint.LintCategory.REMOVAL)) {
                if (symbol.kind == Kinds.Kind.MDL) {
                    this.removalHandler.report(diagnosticPosition, CompilerProperties.LintWarnings.HasBeenDeprecatedForRemovalModule(symbol));
                } else {
                    this.removalHandler.report(diagnosticPosition, CompilerProperties.LintWarnings.HasBeenDeprecatedForRemoval(symbol, symbol.location()));
                }
            }
        } else if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            if (symbol.kind == Kinds.Kind.MDL) {
                this.deprecationHandler.report(diagnosticPosition, CompilerProperties.LintWarnings.HasBeenDeprecatedModule(symbol));
            } else {
                this.deprecationHandler.report(diagnosticPosition, CompilerProperties.LintWarnings.HasBeenDeprecated(symbol, symbol.location()));
            }
        }
    }

    public void warnPreviewAPI(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.LintWarning lintWarning) {
        if (!this.importSuppression && !this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.preview.reportPreviewWarning(diagnosticPosition, lintWarning);
        }
    }

    public void warnRestrictedAPI(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.RestrictedMethod(symbol.enclClass(), symbol));
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.LintWarning lintWarning) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(diagnosticPosition, lintWarning);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.removalHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.CompletionFailure completionFailure) {
        this.log.error(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE, diagnosticPosition, CompilerProperties.Errors.CantAccess(completionFailure.sym, completionFailure.getDetailValue()));
        return this.syms.errType;
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic, Object object) {
        Type type;
        if (object instanceof Type && (type = (Type)object).hasTag(TypeTag.VOID)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.IllegalStartOfType);
            return this.syms.errType;
        }
        this.log.error(diagnosticPosition, CompilerProperties.Errors.TypeFoundReq(object, jCDiagnostic));
        return this.types.createErrorType(object instanceof Type ? (type = (Type)object) : this.syms.errType);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (!symbol.type.isErroneous()) {
            Symbol symbol2 = symbol.location();
            if (symbol2.kind == Kinds.Kind.MTH && ((Symbol.MethodSymbol)symbol2).isStaticOrInstanceInit()) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.AlreadyDefinedInClinit(Kinds.kindName(symbol), symbol, Kinds.kindName(symbol.location()), Kinds.kindName(symbol.location().enclClass()), symbol.location().enclClass()));
            } else if (symbol2.kind != Kinds.Kind.MTH || (symbol.owner.flags_field & 0x1000000000L) == 0L || (symbol.owner.flags_field & 0x2000000000000000L) == 0L) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.AlreadyDefined(Kinds.kindName(symbol), symbol, Kinds.kindName(symbol.location()), symbol.location()));
            }
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        if (!symbol.type.isErroneous() && !symbol2.type.isErroneous()) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.ArrayAndVarargs(symbol, symbol2, symbol2.location()));
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol, Scope scope) {
        for (Symbol symbol : scope.getSymbolsByName(varSymbol.name)) {
            if (symbol.owner != varSymbol.owner) break;
            if (symbol.kind != Kinds.Kind.VAR || !symbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || varSymbol.name == this.names.error) continue;
            this.duplicateError(diagnosticPosition, symbol);
            return;
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol, Scope scope) {
        for (Symbol symbol : scope.getSymbolsByName(classSymbol.name)) {
            if (symbol.owner != classSymbol.owner) break;
            if (symbol.kind != Kinds.Kind.TYP || symbol.type.hasTag(TypeTag.TYPEVAR) || !symbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || classSymbol.name == this.names.error) continue;
            this.duplicateError(diagnosticPosition, symbol);
            return;
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition diagnosticPosition, Name name, Scope scope) {
        for (Symbol symbol : scope.getSymbolsByName(name, Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol.kind != Kinds.Kind.TYP || symbol.name == this.names.error) continue;
            this.duplicateError(diagnosticPosition, symbol);
            return false;
        }
        Object object = scope.owner;
        while (object != null) {
            if (((Symbol)object).kind == Kinds.Kind.TYP && ((Symbol)object).name == name && ((Symbol)object).name != this.names.error && !((Symbol)object).isImplicit()) {
                this.duplicateError(diagnosticPosition, (Symbol)object);
                return true;
            }
            object = ((Symbol)object).owner;
        }
        return true;
    }

    public Name localClassName(Symbol.ClassSymbol classSymbol) {
        int n;
        Name name = classSymbol.owner.enclClass().flatname;
        String string = name.toString();
        Pair<Name, Name> pair = new Pair<Name, Name>(name, classSymbol.name);
        Integer n2 = this.localClassNameIndexes.get(pair);
        int n3 = n = n2 == null ? 1 : n2;
        while (true) {
            Name name2;
            if (this.getCompiled(classSymbol.packge().modle, name2 = this.names.fromString(string + this.syntheticNameChar + n + classSymbol.name)) == null) {
                this.localClassNameIndexes.put(pair, n + 1);
                return name2;
            }
            ++n;
        }
    }

    public void clearLocalClassNameIndexes(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner != null && classSymbol.owner.kind != Kinds.Kind.NIL) {
            this.localClassNameIndexes.remove(new Pair<Name, Name>(classSymbol.owner.enclClass().flatname, classSymbol.name));
        }
    }

    public void newRound() {
        this.compiled.clear();
        this.localClassNameIndexes.clear();
    }

    public void clear() {
        this.deprecationHandler.clear();
        this.removalHandler.clear();
        this.uncheckedHandler.clear();
    }

    public void putCompiled(Symbol.ClassSymbol classSymbol) {
        this.compiled.put(Pair.of(classSymbol.packge().modle, classSymbol.flatname), classSymbol);
    }

    public Symbol.ClassSymbol getCompiled(Symbol.ClassSymbol classSymbol) {
        return this.compiled.get(Pair.of(classSymbol.packge().modle, classSymbol.flatname));
    }

    public Symbol.ClassSymbol getCompiled(Symbol.ModuleSymbol moduleSymbol, Name name) {
        return this.compiled.get(Pair.of(moduleSymbol, name));
    }

    public void removeCompiled(Symbol.ClassSymbol classSymbol) {
        this.compiled.remove(Pair.of(classSymbol.packge().modle, classSymbol.flatname));
    }

    public Type checkType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return this.checkType(diagnosticPosition, type, type2, this.basicHandler);
    }

    Type checkType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, CheckContext checkContext) {
        InferenceContext inferenceContext2 = checkContext.inferenceContext();
        if (inferenceContext2.free(type2) || inferenceContext2.free(type)) {
            inferenceContext2.addFreeTypeListener(List.of(type2, type), inferenceContext -> this.checkType(diagnosticPosition, inferenceContext.asInstType(type), inferenceContext.asInstType(type2), checkContext));
        }
        if (type2.hasTag(TypeTag.ERROR)) {
            return type2;
        }
        if (type2.hasTag(TypeTag.NONE)) {
            return type;
        }
        if (checkContext.compatible(type, type2, checkContext.checkWarner(diagnosticPosition, type, type2))) {
            return type;
        }
        if (type.isNumeric() && type2.isNumeric()) {
            checkContext.report(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.PossibleLossOfPrecision(type, type2)));
            return this.types.createErrorType(type);
        }
        checkContext.report(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.InconvertibleTypes(type, type2)));
        return this.types.createErrorType(type);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return this.checkCastable(diagnosticPosition, type, type2, this.basicHandler);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, CheckContext checkContext) {
        if (this.types.isCastable(type, type2, this.castWarner(diagnosticPosition, type, type2))) {
            return type2;
        }
        checkContext.report(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.InconvertibleTypes(type, type2)));
        return this.types.createErrorType(type);
    }

    public void checkRedundantCast(Env<AttrContext> env, JCTree.JCTypeCast jCTypeCast) {
        if (!jCTypeCast.type.isErroneous() && this.types.isSameType(jCTypeCast.expr.type, jCTypeCast.clazz.type) && !TreeInfo.containsTypeAnnotation(jCTypeCast.clazz) && !this.is292targetTypeCast(jCTypeCast)) {
            this.deferredLintHandler.report(lint -> this.lint.logIfEnabled(jCTypeCast.pos(), CompilerProperties.LintWarnings.RedundantCast(jCTypeCast.clazz.type)));
        }
    }

    private boolean is292targetTypeCast(JCTree.JCTypeCast jCTypeCast) {
        boolean bl = false;
        JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCTypeCast.expr);
        if (jCExpression.hasTag(JCTree.Tag.APPLY)) {
            JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)jCExpression;
            Symbol symbol = TreeInfo.symbol(jCMethodInvocation.meth);
            bl = symbol != null && symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x2000000000L) != 0L;
        }
        return bl;
    }

    private boolean checkExtends(Type type, Type type2) {
        if (type.isUnbound()) {
            return true;
        }
        if (!type.hasTag(TypeTag.WILDCARD)) {
            type = this.types.cvarUpperBound(type);
            return this.types.isSubtype(type, type2);
        }
        if (type.isExtendsBound()) {
            return this.types.isCastable(type2, this.types.wildUpperBound(type), this.types.noWarnings);
        }
        if (type.isSuperBound()) {
            return !this.types.notSoftSubtype(this.types.wildLowerBound(type), type2);
        }
        return true;
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.hasTag(TypeTag.VOID)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.VoidNotAllowedHere);
            return this.types.createErrorType(type);
        }
        return type;
    }

    Type checkClassOrArrayType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (!(type.hasTag(TypeTag.CLASS) || type.hasTag(TypeTag.ARRAY) || type.hasTag(TypeTag.ERROR))) {
            return this.typeTagError(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.TypeReqClassArray), this.asTypeParam(type));
        }
        return type;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (!type.hasTag(TypeTag.CLASS) && !type.hasTag(TypeTag.ERROR)) {
            return this.typeTagError(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.TypeReqClass), this.asTypeParam(type));
        }
        return type;
    }

    private Object asTypeParam(Type type) {
        return type.hasTag(TypeTag.TYPEVAR) ? this.diags.fragment(CompilerProperties.Fragments.TypeParameter(type)) : type;
    }

    Type checkConstructorRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if ((type = this.checkClassOrArrayType(diagnosticPosition, type)).hasTag(TypeTag.CLASS)) {
            if ((type.tsym.flags() & 0x600L) != 0L) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.AbstractCantBeInstantiated(type.tsym));
                type = this.types.createErrorType(type);
            } else if ((type.tsym.flags() & 0x4000L) != 0L) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.EnumCantBeInstantiated);
                type = this.types.createErrorType(type);
            } else {
                type = this.checkClassType(diagnosticPosition, type, true);
            }
        } else if (type.hasTag(TypeTag.ARRAY) && !this.types.isReifiable(((Type.ArrayType)type).elemtype)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.GenericArrayCreation);
            type = this.types.createErrorType(type);
        }
        return type;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, boolean bl) {
        type = this.checkClassType(diagnosticPosition, type);
        if (bl && type.isParameterized()) {
            List<Type> list = type.getTypeArguments();
            while (list.nonEmpty()) {
                if (((Type)list.head).hasTag(TypeTag.WILDCARD)) {
                    return this.typeTagError(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.TypeReqExact), list.head);
                }
                list = list.tail;
            }
        }
        return type;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isReference()) {
            return type;
        }
        return this.typeTagError(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.TypeReqRef), type);
    }

    List<Type> checkRefTypes(List<JCTree.JCExpression> list, List<Type> list2) {
        List<JCTree.JCExpression> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list4.head = this.checkRefType(((JCTree.JCExpression)list3.head).pos(), (Type)list4.head);
            list3 = list3.tail;
            list4 = list4.tail;
        }
        return list2;
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isReference() || type.hasTag(TypeTag.BOT)) {
            return type;
        }
        return this.typeTagError(diagnosticPosition, this.diags.fragment(CompilerProperties.Fragments.TypeReqRef), type);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition diagnosticPosition, long l, long l2, long l3) {
        if ((l & l2) != 0L && (l & l3) != 0L) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.IllegalCombinationOfModifiers(Flags.asFlagSet(TreeInfo.firstFlag(l & l2)), Flags.asFlagSet(TreeInfo.firstFlag(l & l3))));
            return false;
        }
        return true;
    }

    Type checkDiamond(JCTree.JCNewClass jCNewClass, Type type) {
        if (!TreeInfo.isDiamond(jCNewClass) || type.isErroneous()) {
            return this.checkClassType(jCNewClass.clazz.pos(), type, true);
        }
        if (jCNewClass.def != null && !Source.Feature.DIAMOND_WITH_ANONYMOUS_CLASS_CREATION.allowedInSource(this.source)) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, jCNewClass.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(type, Source.Feature.DIAMOND_WITH_ANONYMOUS_CLASS_CREATION.fragment(this.source.name)));
        }
        if (type.tsym.type.getTypeArguments().isEmpty()) {
            this.log.error(jCNewClass.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(type, CompilerProperties.Fragments.DiamondNonGeneric(type)));
            return this.types.createErrorType(type);
        }
        if (jCNewClass.typeargs != null && jCNewClass.typeargs.nonEmpty()) {
            this.log.error(jCNewClass.clazz.pos(), CompilerProperties.Errors.CantApplyDiamond1(type, CompilerProperties.Fragments.DiamondAndExplicitParams(type)));
            return this.types.createErrorType(type);
        }
        return type;
    }

    List<Type> checkDiamondDenotable(Type.ClassType classType) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : classType.allparams()) {
            if (this.checkDenotable(type)) continue;
            listBuffer.append(type);
        }
        return listBuffer.toList();
    }

    public boolean checkDenotable(Type type) {
        return (Boolean)denotableChecker.visit(type, null);
    }

    void checkVarargsMethodDecl(Env<AttrContext> env, JCTree.JCMethodDecl jCMethodDecl) {
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        boolean bl = methodSymbol.attribute(this.syms.trustMeType.tsym) != null;
        Type type = null;
        if (methodSymbol.isVarArgs()) {
            type = this.types.elemtype(jCMethodDecl.params.last().type);
        }
        if (bl && !this.isTrustMeAllowedOnMethod(methodSymbol)) {
            if (type != null) {
                JCDiagnostic jCDiagnostic = Source.Feature.PRIVATE_SAFE_VARARGS.allowedInSource(this.source) ? this.diags.fragment(CompilerProperties.Fragments.VarargsTrustmeOnVirtualVarargs(methodSymbol)) : this.diags.fragment(CompilerProperties.Fragments.VarargsTrustmeOnVirtualVarargsFinalOnly(methodSymbol));
                this.log.error(jCMethodDecl, CompilerProperties.Errors.VarargsInvalidTrustmeAnno((Symbol)this.syms.trustMeType.tsym, jCDiagnostic));
            } else {
                this.log.error(jCMethodDecl, CompilerProperties.Errors.VarargsInvalidTrustmeAnno((Symbol)this.syms.trustMeType.tsym, CompilerProperties.Fragments.VarargsTrustmeOnNonVarargsMeth(methodSymbol)));
            }
        } else if (bl && type != null && this.types.isReifiable(type)) {
            this.lint.logIfEnabled(jCMethodDecl, CompilerProperties.LintWarnings.VarargsRedundantTrustmeAnno((Symbol)this.syms.trustMeType.tsym, this.diags.fragment(CompilerProperties.Fragments.VarargsTrustmeOnReifiableVarargs(type))));
        } else if (!bl && type != null && !this.types.isReifiable(type)) {
            this.warnUnchecked(((JCTree.JCVariableDecl)jCMethodDecl.params.head).pos(), CompilerProperties.LintWarnings.UncheckedVarargsNonReifiableType(type));
        }
    }

    private boolean isTrustMeAllowedOnMethod(Symbol symbol) {
        return (symbol.flags() & 0x400000000L) != 0L && (symbol.isConstructor() || (symbol.flags() & (long)(0x18 | (Source.Feature.PRIVATE_SAFE_VARARGS.allowedInSource(this.source) ? 2 : 0))) != 0L);
    }

    Type checkLocalVarType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name) {
        if (type.hasTag(TypeTag.BOT)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.CantInferLocalVarType(name, CompilerProperties.Fragments.LocalCantInferNull));
            return this.types.createErrorType(type);
        }
        if (type.hasTag(TypeTag.VOID)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.CantInferLocalVarType(name, CompilerProperties.Fragments.LocalCantInferVoid));
            return this.types.createErrorType(type);
        }
        return this.types.upward(type, this.types.captures(type)).baseType();
    }

    Type checkMethod(Type type, Symbol symbol, Env<AttrContext> env, List<JCTree.JCExpression> list, List<Type> list2, boolean bl, InferenceContext inferenceContext2) {
        Object object;
        List<JCTree.JCExpression> list3;
        Type type2;
        if (inferenceContext2.free(type)) {
            inferenceContext2.addFreeTypeListener(List.of(type), inferenceContext -> this.checkMethod(inferenceContext.asInstType(type), symbol, env, list, list2, bl, inferenceContext));
            return type;
        }
        Type type3 = type;
        List<Type> list4 = type3.getParameterTypes();
        List<Type> list5 = symbol.type.getParameterTypes();
        if (list5.length() != list4.length()) {
            list5 = list4;
        }
        Type type4 = type2 = bl ? list4.last() : null;
        if (symbol.name == this.names.init && symbol.owner == this.syms.enumSym) {
            list4 = list4.tail.tail;
            list5 = list5.tail.tail;
        }
        if ((symbol.flags() & 0x200000000000000L) != 0L) {
            list4 = list4.tail;
            list5 = list5.tail;
        }
        if ((list3 = list) != null) {
            Object object2;
            while (list4.head != type2) {
                object = (JCTree)list3.head;
                object2 = this.convertWarner(((JCTree)object).pos(), ((JCTree)object).type, (Type)list5.head);
                this.assertConvertible((JCTree)object, ((JCTree)object).type, (Type)list4.head, (Warner)object2);
                list3 = list3.tail;
                list4 = list4.tail;
                list5 = list5.tail;
            }
            if (bl) {
                object = this.types.elemtype(type2);
                while (list3.tail != null) {
                    object2 = (JCTree)list3.head;
                    Warner warner = this.convertWarner(((JCTree)object2).pos(), ((JCTree)object2).type, (Type)object);
                    this.assertConvertible((JCTree)object2, ((JCTree)object2).type, (Type)object, warner);
                    list3 = list3.tail;
                }
            } else if ((symbol.flags() & 0x400400000000L) == 0x400000000L) {
                object = type3.getParameterTypes().last();
                object2 = list2.last();
                if (this.types.isSubtypeUnchecked((Type)object2, this.types.elemtype((Type)object)) && !this.types.isSameType(this.types.erasure((Type)object), this.types.erasure((Type)object2))) {
                    this.log.warning(list.last().pos(), CompilerProperties.Warnings.InexactNonVarargsCall(this.types.elemtype((Type)object), (Type)object));
                }
            }
        }
        if (bl) {
            object = type3.getParameterTypes().last();
            if (!(this.types.isReifiable((Type)object) || symbol.baseSymbol().attribute(this.syms.trustMeType.tsym) != null && this.isTrustMeAllowedOnMethod(symbol))) {
                this.warnUnchecked(env.tree.pos(), CompilerProperties.LintWarnings.UncheckedGenericArrayCreation((Type)object));
            }
            TreeInfo.setVarargsElement(env.tree, this.types.elemtype((Type)object));
        }
        return type3;
    }

    private void assertConvertible(JCTree jCTree, Type type, Type type2, Warner warner) {
        if (this.types.isConvertible(type, type2, warner)) {
            return;
        }
        if (type2.isCompound() && this.types.isSubtype(type, this.types.supertype(type2)) && this.types.isSubtypeUnchecked(type, this.types.interfaces(type2), warner)) {
            return;
        }
    }

    public boolean checkValidGenericType(Type type) {
        return this.firstIncompatibleTypeArg(type) == null;
    }

    private Type firstIncompatibleTypeArg(Type type) {
        List<Type> list = type.tsym.type.allparams();
        List<Type> list2 = type.allparams();
        List<Type> list3 = type.getTypeArguments();
        List<Type> list4 = type.tsym.type.getTypeArguments();
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        while (list3.nonEmpty() && list4.nonEmpty()) {
            listBuffer.append(this.types.subst(((Type)list4.head).getUpperBound(), list, list2));
            list3 = list3.tail;
            list4 = list4.tail;
        }
        list3 = type.getTypeArguments();
        List<Type> list5 = this.types.substBounds(list, list, this.types.capture(type).allparams());
        while (list3.nonEmpty() && list5.nonEmpty()) {
            ((Type)list3.head).withTypeVar((Type.TypeVar)list5.head);
            list3 = list3.tail;
            list5 = list5.tail;
        }
        list3 = type.getTypeArguments();
        List list6 = listBuffer.toList();
        while (list3.nonEmpty() && list6.nonEmpty()) {
            Type type2 = (Type)list3.head;
            if (!(this.isTypeArgErroneous(type2) || ((Type)list6.head).isErroneous() || this.checkExtends(type2, (Type)list6.head))) {
                return (Type)list3.head;
            }
            list3 = list3.tail;
            list6 = list6.tail;
        }
        list3 = type.getTypeArguments();
        list6 = listBuffer.toList();
        for (Type type3 : this.types.capture(type).getTypeArguments()) {
            if (type3.hasTag(TypeTag.TYPEVAR) && type3.getUpperBound().isErroneous() && !((Type)list6.head).isErroneous() && !this.isTypeArgErroneous((Type)list3.head)) {
                return (Type)list3.head;
            }
            list6 = list6.tail;
            list3 = list3.tail;
        }
        return null;
    }

    boolean isTypeArgErroneous(Type type) {
        return this.isTypeArgErroneous.visit(type);
    }

    long checkFlags(long l, Symbol symbol, JCTree jCTree) {
        long l2;
        JCDiagnostic.DiagnosticPosition diagnosticPosition = jCTree.pos();
        long l3 = 0L;
        switch (symbol.kind) {
            case VAR: {
                if (TreeInfo.isReceiverParam(jCTree)) {
                    l2 = 0x200000000L;
                    break;
                }
                if (symbol.owner.kind != Kinds.Kind.TYP) {
                    l2 = 0x200000010L;
                    break;
                }
                if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    l3 = 25L;
                    l2 = 25L;
                    break;
                }
                l2 = 16607L;
                break;
            }
            case MTH: {
                if (symbol.name == this.names.init) {
                    if ((symbol.owner.flags_field & 0x4000L) != 0L) {
                        l3 = 2L;
                        l2 = 2L;
                    } else {
                        l2 = 7L;
                    }
                } else if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    if ((symbol.owner.flags_field & 0x2000L) != 0L) {
                        l2 = 1025L;
                        l3 = 1025L;
                    } else if ((l & 0x8000000000AL) != 0L) {
                        l2 = 8796093025291L;
                        long l4 = l3 = (l & 2L) != 0L ? 0L : 1L;
                        if ((l & 0x80000000000L) != 0L) {
                            l3 |= 0x400L;
                        }
                    } else {
                        l3 = 1025L;
                        l2 = 1025L;
                    }
                } else {
                    l2 = (symbol.owner.flags_field & 0x2000000000000000L) != 0L ? 3135L : 3391L;
                }
                if ((l & 0x800L) != 0L) {
                    this.warnOnExplicitStrictfp(jCTree);
                }
                if (((l | l3) & 0x400L) != 0L && (l & 0x80000000000L) == 0L) break;
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            case TYP: {
                if (symbol.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || symbol.isDirectlyOrIndirectlyLocal() && (l & 0x2000L) != 0L) {
                    boolean bl = !symbol.isAnonymous() && ((l & 0x2000000000000000L) != 0L || (l & 0x4000L) != 0L || (l & 0x200L) != 0L);
                    boolean bl2 = (l & 8L) != 0L || bl;
                    l2 = bl2 && this.allowRecords && (l & 0x2000L) == 0L ? 24088L : 23568L;
                    l3 = bl ? 8L : l3;
                } else if (symbol.owner.kind == Kinds.Kind.TYP) {
                    long l5 = l2 = (l & 8L) != 0L && this.allowRecords && (l & 0x2000L) == 0L ? -4611686018427363809L : -4611686018427363817L;
                    if (symbol.owner.owner.kind == Kinds.Kind.PCK || (symbol.owner.flags_field & 8L) != 0L) {
                        l2 |= 8L;
                    } else if (!(this.allowRecords || (l & 0x4000L) == 0L && (l & 0x2000000000000000L) == 0L)) {
                        this.log.error(diagnosticPosition, CompilerProperties.Errors.StaticDeclarationNotAllowedInInnerClasses);
                    }
                    if ((l & 0x2000000000004200L) != 0L) {
                        l3 = 8L;
                    }
                } else {
                    l2 = -4611686018427355631L;
                }
                if ((l & 0x200L) != 0L) {
                    l3 |= 0x400L;
                }
                if ((l & 0x4000L) != 0L) {
                    l2 &= 0x3FFFFFFFFFFFFBEFL;
                    l3 |= this.implicitEnumFinalFlag(jCTree);
                }
                if ((l & 0x2000000000000000L) != 0L) {
                    l2 &= 0xFFFFFFFFFFFFFBFFL;
                    l3 |= 0x10L;
                }
                if ((l & 0x800L) != 0L) {
                    this.warnOnExplicitStrictfp(jCTree);
                }
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long l6 = l & 0xC000080000000FFFL & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (l6 != 0L) {
            if ((l6 & 0x200L) != 0L) {
                this.log.error(diagnosticPosition, (l & 0x2000L) != 0L ? CompilerProperties.Errors.AnnotationDeclNotAllowedHere : CompilerProperties.Errors.IntfNotAllowedHere);
                l2 |= 0x200L;
            } else {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.ModNotAllowedHere(Flags.asFlagSet(l6)));
            }
        } else if (symbol.kind != Kinds.Kind.TYP && !this.checkDisjoint(diagnosticPosition, l, 1024L, 0x8000000000AL) || !this.checkDisjoint(diagnosticPosition, l, 10L, 0x80000000000L) || !this.checkDisjoint(diagnosticPosition, l, 1536L, 304L) || !this.checkDisjoint(diagnosticPosition, l, 1L, 6L) || !this.checkDisjoint(diagnosticPosition, l, 2L, 5L) || !this.checkDisjoint(diagnosticPosition, l, 16L, 64L) || symbol.kind != Kinds.Kind.TYP && !this.checkDisjoint(diagnosticPosition, l, 1280L, 2048L) || !this.checkDisjoint(diagnosticPosition, l, 16L, -4611686018427387904L) || !this.checkDisjoint(diagnosticPosition, l, 0x4000000000000000L, -9223372036854775792L) || this.checkDisjoint(diagnosticPosition, l, 0x4000000000000000L, 8192L)) {
            // empty if block
        }
        return l & (l2 | 0x3FFFF7FFFFFFF000L) | l3;
    }

    private void warnOnExplicitStrictfp(JCTree jCTree) {
        this.deferredLintHandler.push(jCTree);
        try {
            this.deferredLintHandler.report(lint -> this.lint.logIfEnabled(jCTree.pos(), CompilerProperties.LintWarnings.Strictfp));
        }
        finally {
            this.deferredLintHandler.pop();
        }
    }

    private long implicitEnumFinalFlag(JCTree jCTree) {
        if (!jCTree.hasTag(JCTree.Tag.CLASSDEF)) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends JCTree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            @Override
            public void visitTree(JCTree jCTree) {
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                JCTree.JCExpression jCExpression;
                if ((jCVariableDecl.mods.flags & 0x4000L) != 0L && (jCExpression = jCVariableDecl.init) instanceof JCTree.JCNewClass) {
                    JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)jCExpression;
                    if (jCNewClass.def != null) {
                        this.specialized = true;
                    }
                }
            }
        }
        SpecialTreeVisitor specialTreeVisitor = new SpecialTreeVisitor();
        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree;
        for (JCTree jCTree2 : jCClassDecl.defs) {
            jCTree2.accept(specialTreeVisitor);
            if (!specialTreeVisitor.specialized) continue;
            return this.allowSealed ? 0x4000000000000000L : 0L;
        }
        return 16L;
    }

    void validate(JCTree jCTree, Env<AttrContext> env) {
        this.validate(jCTree, env, true);
    }

    void validate(JCTree jCTree, Env<AttrContext> env, boolean bl) {
        new Validator(env).validateTree(jCTree, bl, true);
    }

    void validate(List<? extends JCTree> list, Env<AttrContext> env) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.validate((JCTree)list2.head, env);
            list2 = list2.tail;
        }
    }

    void checkRaw(JCTree jCTree, Env<AttrContext> env) {
        if (jCTree.type.hasTag(TypeTag.CLASS) && !TreeInfo.isDiamond(jCTree) && !this.withinAnonConstr(env) && jCTree.type.isRaw()) {
            this.lint.logIfEnabled(jCTree.pos(), CompilerProperties.LintWarnings.RawClassUse(jCTree.type, jCTree.type.tsym.type));
        }
    }

    private boolean withinAnonConstr(Env<AttrContext> env) {
        return env.enclClass.name.length() == 0 && env.enclMethod != null && env.enclMethod.name == this.names.init;
    }

    boolean subset(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubtype(type, (Type)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    boolean intersects(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubtype(type, (Type)list2.head) || this.types.isSubtype((Type)list2.head, type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    List<Type> incl(Type type, List<Type> list) {
        return this.subset(type, list) ? list : this.excl(type, list).prepend(type);
    }

    List<Type> excl(Type type, List<Type> list) {
        if (list.isEmpty()) {
            return list;
        }
        List<Type> list2 = this.excl(type, list.tail);
        if (this.types.isSubtype((Type)list.head, type)) {
            return list2;
        }
        if (list2 == list.tail) {
            return list;
        }
        return list2.prepend((Type)list.head);
    }

    List<Type> union(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.incl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    List<Type> diff(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.excl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    public List<Type> intersect(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list2)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        list4 = list2;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    boolean isUnchecked(Symbol.ClassSymbol classSymbol) {
        return classSymbol.kind == Kinds.Kind.ERR || classSymbol.isSubClass(this.syms.errorType.tsym, this.types) || classSymbol.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type type) {
        return type.hasTag(TypeTag.TYPEVAR) ? this.isUnchecked(this.types.supertype(type)) : (type.hasTag(TypeTag.CLASS) ? this.isUnchecked((Symbol.ClassSymbol)type.tsym) : type.hasTag(TypeTag.BOT));
    }

    boolean isChecked(Type type) {
        return !this.isUnchecked(type);
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        try {
            return this.isUnchecked(type);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(diagnosticPosition, completionFailure);
            return true;
        }
    }

    boolean isHandled(Type type, List<Type> list) {
        return this.isUnchecked(type) || this.subset(type, list);
    }

    List<Type> unhandled(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (!this.isHandled((Type)list4.head, list2)) {
                list3 = list3.prepend((Type)list4.head);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    static int protection(long l) {
        switch ((short)(l & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    JCDiagnostic.Fragment cannotOverride(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        Symbol symbol = methodSymbol.location();
        Symbol symbol2 = methodSymbol2.location();
        if ((methodSymbol2.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.CantOverride(methodSymbol, symbol, methodSymbol2, symbol2);
        }
        if ((methodSymbol.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.CantImplement(methodSymbol, symbol, methodSymbol2, symbol2);
        }
        return CompilerProperties.Fragments.ClashesWith(methodSymbol, symbol, methodSymbol2, symbol2);
    }

    JCDiagnostic.Fragment uncheckedOverrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        Symbol symbol = methodSymbol.location();
        Symbol symbol2 = methodSymbol2.location();
        if ((methodSymbol2.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.UncheckedOverride(methodSymbol, symbol, methodSymbol2, symbol2);
        }
        if ((methodSymbol.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.UncheckedImplement(methodSymbol, symbol, methodSymbol2, symbol2);
        }
        return CompilerProperties.Fragments.UncheckedClashWith(methodSymbol, symbol, methodSymbol2, symbol2);
    }

    JCDiagnostic.Fragment varargsOverrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        Symbol symbol = methodSymbol.location();
        Symbol symbol2 = methodSymbol2.location();
        if ((methodSymbol2.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.VarargsOverride(methodSymbol, symbol, methodSymbol2, symbol2);
        }
        if ((methodSymbol.owner.flags() & 0x200L) == 0L) {
            return CompilerProperties.Fragments.VarargsImplement(methodSymbol, symbol, methodSymbol2, symbol2);
        }
        return CompilerProperties.Fragments.VarargsClashWith(methodSymbol, symbol, methodSymbol2, symbol2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkOverride(JCTree jCTree, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.ClassSymbol classSymbol) {
        if ((methodSymbol.flags() & 0x80001000L) != 0L || (methodSymbol2.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((methodSymbol.flags() & 8L) != 0L && (methodSymbol2.flags() & 8L) == 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.Errors.OverrideStatic(this.cannotOverride(methodSymbol, methodSymbol2)));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if ((methodSymbol2.flags() & 0x10L) != 0L || (methodSymbol.flags() & 8L) == 0L && (methodSymbol2.flags() & 8L) != 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.Errors.OverrideMeth(this.cannotOverride(methodSymbol, methodSymbol2), Flags.asFlagSet(methodSymbol2.flags() & 0x18L)));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if ((methodSymbol.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        if (Check.protection(methodSymbol.flags()) > Check.protection(methodSymbol2.flags())) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), (methodSymbol2.flags() & 7L) == 0L ? CompilerProperties.Errors.OverrideWeakerAccess(this.cannotOverride(methodSymbol, methodSymbol2), "package") : CompilerProperties.Errors.OverrideWeakerAccess(this.cannotOverride(methodSymbol, methodSymbol2), Flags.asFlagSet(methodSymbol2.flags() & 7L)));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if (this.shouldCheckPreview(methodSymbol, methodSymbol2, classSymbol)) {
            this.checkPreview(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), methodSymbol, classSymbol.type, methodSymbol2);
        }
        Type type = this.types.memberType(classSymbol.type, methodSymbol);
        Type type2 = this.types.memberType(classSymbol.type, methodSymbol2);
        List<Type> list = type.getTypeArguments();
        List<Type> list2 = type2.getTypeArguments();
        Type type3 = type.getReturnType();
        Type type4 = this.types.subst(type2.getReturnType(), list2, list);
        this.overrideWarner.clear();
        boolean bl = this.types.returnTypeSubstitutable(type, type2, type4, this.overrideWarner);
        if (!bl) {
            if ((methodSymbol.flags() & 8L) != 0L && (methodSymbol2.flags() & 8L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.Errors.OverrideIncompatibleRet(CompilerProperties.Fragments.CantHide(methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location()), type3, type4));
                methodSymbol.flags_field |= 0x200000000000L;
            } else {
                this.log.error(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.Errors.OverrideIncompatibleRet(this.cannotOverride(methodSymbol, methodSymbol2), type3, type4));
                methodSymbol.flags_field |= 0x200000000000L;
            }
            return;
        }
        if (this.overrideWarner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.LintWarnings.OverrideUncheckedRet(this.uncheckedOverrides(methodSymbol, methodSymbol2), type3, type4));
        }
        List<Type> list3 = this.types.subst(type2.getThrownTypes(), list2, list);
        List<Type> list4 = this.unhandled(type.getThrownTypes(), this.types.erasure(list3));
        List<Type> list5 = this.unhandled(type.getThrownTypes(), list3);
        if (list4.nonEmpty()) {
            this.log.error(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.Errors.OverrideMethDoesntThrow(this.cannotOverride(methodSymbol, methodSymbol2), (Type)list5.head));
            methodSymbol.flags_field |= 0x200000000000L;
            return;
        }
        if (list5.nonEmpty()) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.LintWarnings.OverrideUncheckedThrown(this.cannotOverride(methodSymbol, methodSymbol2), (Type)list5.head));
            return;
        }
        if (((methodSymbol.flags() ^ methodSymbol2.flags()) & 0x400000000L) != 0L) {
            this.lint.logIfEnabled(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), (methodSymbol.flags() & 0x400000000L) != 0L ? CompilerProperties.LintWarnings.OverrideVarargsMissing(this.varargsOverrides(methodSymbol, methodSymbol2)) : CompilerProperties.LintWarnings.OverrideVarargsExtra(this.varargsOverrides(methodSymbol, methodSymbol2)));
        }
        if ((methodSymbol2.flags() & 0x80000000L) != 0L) {
            this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), CompilerProperties.Warnings.OverrideBridge(this.uncheckedOverrides(methodSymbol, methodSymbol2)));
        }
        if (!this.isDeprecatedOverrideIgnorable(methodSymbol2, classSymbol)) {
            Lint lint = this.setLint(this.lint.augment(methodSymbol));
            try {
                this.checkDeprecated(() -> TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCTree), (Symbol)methodSymbol, (Symbol)methodSymbol2);
            }
            finally {
                this.setLint(lint);
            }
        }
    }

    private boolean shouldCheckPreview(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.ClassSymbol classSymbol) {
        if (methodSymbol.owner != classSymbol || (methodSymbol2.flags() & 0x100000000000000L) == 0L && (methodSymbol2.owner.flags() & 0x100000000000000L) == 0L) {
            return false;
        }
        for (Symbol symbol : this.types.membersClosure(classSymbol.type, false).getSymbolsByName(methodSymbol.name)) {
            if (methodSymbol == symbol || !methodSymbol.overrides(symbol, classSymbol, this.types, false)) continue;
            return symbol == methodSymbol2;
        }
        return false;
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol methodSymbol, Symbol.ClassSymbol classSymbol) {
        Symbol.ClassSymbol classSymbol2 = methodSymbol.enclClass();
        Type type = this.types.supertype(classSymbol.type);
        if (!type.hasTag(TypeTag.CLASS)) {
            return true;
        }
        Symbol.MethodSymbol methodSymbol2 = methodSymbol.implementation((Symbol.ClassSymbol)type.tsym, this.types, false);
        if (classSymbol2 != null && (classSymbol2.flags() & 0x200L) != 0L) {
            List<Type> list = this.types.interfaces(classSymbol.type);
            return list.contains(classSymbol2.type) ? false : methodSymbol2 != null;
        }
        return methodSymbol2 != methodSymbol;
    }

    public void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        Type type2 = this.types.supertype(type);
        if (!type2.hasTag(TypeTag.CLASS)) {
            return;
        }
        Type type3 = type2;
        while (type3.hasTag(TypeTag.CLASS) && type3.tsym.type.isParameterized()) {
            for (Symbol symbol : type3.tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 0x80001008L) != 0L || !symbol.isInheritedIn(type.tsym, this.types) || ((Symbol.MethodSymbol)symbol).implementation(type.tsym, this.types, true) != symbol) continue;
                Type type4 = this.types.memberType(type3, symbol);
                int n = type4.getParameterTypes().length();
                if (type4 == symbol.type) continue;
                Type type5 = type2;
                while (type5.hasTag(TypeTag.CLASS)) {
                    for (Symbol symbol2 : type5.tsym.members().getSymbolsByName(symbol.name)) {
                        Type type6;
                        if (symbol2 == symbol || symbol2.kind != Kinds.Kind.MTH || (symbol2.flags() & 0x80001008L) != 0L || symbol2.type.getParameterTypes().length() != n || !symbol2.isInheritedIn(type.tsym, this.types) || ((Symbol.MethodSymbol)symbol2).implementation(type.tsym, this.types, true) != symbol2 || !this.types.overrideEquivalent(type4, type6 = this.types.memberType(type5, symbol2))) continue;
                        this.log.error(diagnosticPosition, CompilerProperties.Errors.ConcreteInheritanceConflict(symbol, type3, symbol2, type5, type2));
                    }
                    type5 = this.types.supertype(type5);
                }
            }
            type3 = this.types.supertype(type3);
        }
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        if ((type3.tsym.flags() & 0x1000000L) != 0L) {
            type = this.types.capture(type);
            type2 = this.types.capture(type2);
        }
        return this.firstIncompatibility(diagnosticPosition, type, type2, type3) == null;
    }

    private Symbol firstIncompatibility(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        HashMap<Symbol.TypeSymbol, Type> hashMap;
        HashMap<Symbol.TypeSymbol, Type> hashMap2 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(type, hashMap2);
        if (type == type2) {
            hashMap = hashMap2;
        } else {
            hashMap = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(type2, hashMap2, hashMap);
        }
        for (Type type4 : hashMap2.values()) {
            for (Type type5 : hashMap.values()) {
                Symbol symbol = this.firstDirectIncompatibility(diagnosticPosition, type4, type5, type3);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return null;
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map) {
        if (!type.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (map.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map);
            }
        }
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map, Map<Symbol.TypeSymbol, Type> map2) {
        if (!type.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (map.get(type.tsym) != null) {
            return;
        }
        if (map2.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map, map2);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map, map2);
            }
        }
    }

    private Symbol firstDirectIncompatibility(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2, Type type3) {
        for (Symbol symbol : type.tsym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            Symbol.MethodSymbol methodSymbol;
            Type type4 = null;
            if (symbol.kind != Kinds.Kind.MTH || !symbol.isInheritedIn(type3.tsym, this.types) || (symbol.flags() & 0x1000L) != 0L || (methodSymbol = ((Symbol.MethodSymbol)symbol).implementation(type3.tsym, this.types, false)) != null && (methodSymbol.flags() & 0x400L) == 0L) continue;
            for (Symbol symbol2 : type2.tsym.members().getSymbolsByName(symbol.name)) {
                Type type5;
                if (symbol == symbol2 || symbol2.kind != Kinds.Kind.MTH || !symbol2.isInheritedIn(type3.tsym, this.types) || (symbol2.flags() & 0x1000L) != 0L) continue;
                if (type4 == null) {
                    type4 = this.types.memberType(type, symbol);
                }
                if (this.types.overrideEquivalent(type4, type5 = this.types.memberType(type2, symbol2))) {
                    Type type6;
                    List<Type> list = type4.getTypeArguments();
                    List<Type> list2 = type5.getTypeArguments();
                    Type type7 = type4.getReturnType();
                    boolean bl = this.types.isSameType(type7, type6 = this.types.subst(type5.getReturnType(), list2, list)) || !type7.isPrimitiveOrVoid() && !type6.isPrimitiveOrVoid() && (this.types.covariantReturnType(type7, type6, this.types.noWarnings) || this.types.covariantReturnType(type6, type7, this.types.noWarnings)) || this.checkCommonOverriderIn(symbol, symbol2, type3);
                    if (bl) continue;
                    if (this.types.isSameType(type, type2)) {
                        this.log.error(diagnosticPosition, CompilerProperties.Errors.IncompatibleDiffRetSameType(type, symbol2.name, this.types.memberType(type2, symbol2).getParameterTypes()));
                    } else {
                        this.log.error(diagnosticPosition, CompilerProperties.Errors.TypesIncompatible(type, type2, CompilerProperties.Fragments.IncompatibleDiffRet(symbol2.name, this.types.memberType(type2, symbol2).getParameterTypes())));
                    }
                    return symbol2;
                }
                if (!this.checkNameClash((Symbol.ClassSymbol)type3.tsym, symbol, symbol2) || this.checkCommonOverriderIn(symbol, symbol2, type3)) continue;
                this.log.error(diagnosticPosition, CompilerProperties.Errors.NameClashSameErasureNoOverride(symbol.name, this.types.memberType(type3, symbol).asMethodType().getParameterTypes(), symbol.location(), symbol2.name, this.types.memberType(type3, symbol2).asMethodType().getParameterTypes(), symbol2.location()));
                return symbol2;
            }
        }
        return null;
    }

    boolean checkCommonOverriderIn(Symbol symbol, Symbol symbol2, Type type) {
        HashMap<Symbol.TypeSymbol, Type> hashMap = new HashMap<Symbol.TypeSymbol, Type>();
        Type type2 = this.types.memberType(type, symbol);
        Type type3 = this.types.memberType(type, symbol2);
        this.closure(type, hashMap);
        for (Type type4 : hashMap.values()) {
            for (Symbol symbol3 : type4.tsym.members().getSymbolsByName(symbol.name)) {
                Type type5;
                if (symbol3 == symbol || symbol3 == symbol2 || symbol3.kind != Kinds.Kind.MTH || (symbol3.flags() & 0x80001000L) != 0L || !this.types.overrideEquivalent(type5 = this.types.memberType(type, symbol3), type2) || !this.types.overrideEquivalent(type5, type3) || !this.types.returnTypeSubstitutable(type5, type2) || !this.types.returnTypeSubstitutable(type5, type3)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    void checkOverride(Env<AttrContext> env, JCTree.JCMethodDecl jCMethodDecl, Symbol.MethodSymbol methodSymbol) {
        boolean bl;
        Object object;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        if ((classSymbol.flags() & 0x4000L) != 0L && this.names.finalize.equals(methodSymbol.name) && methodSymbol.overrides(this.syms.enumFinalFinalize, classSymbol, this.types, false)) {
            this.log.error(jCMethodDecl.pos(), CompilerProperties.Errors.EnumNoFinalize);
            return;
        }
        if (this.allowRecords && classSymbol.isRecord() && ((Optional)(object = classSymbol.getRecordComponents().stream().filter(recordComponent -> recordComponent.accessor == jCMethodDecl.sym && (recordComponent.accessor.flags_field & 0x1000000L) == 0L).findFirst())).isPresent()) {
            return;
        }
        object = classSymbol.type;
        while (((Type)object).hasTag(TypeTag.CLASS)) {
            if (object != classSymbol.type) {
                this.checkOverride((JCTree)jCMethodDecl, (Type)object, classSymbol, methodSymbol);
            }
            for (Type object2 : this.types.interfaces((Type)object)) {
                this.checkOverride((JCTree)jCMethodDecl, object2, classSymbol, methodSymbol);
            }
            object = this.types.supertype((Type)object);
        }
        boolean bl2 = methodSymbol.attribute(this.syms.overrideType.tsym) != null;
        boolean bl3 = bl = bl2 || ((AttrContext)env.info).isAnonymousDiamond && !methodSymbol.isConstructor() && !methodSymbol.isPrivate();
        if (bl && !this.isOverrider(methodSymbol)) {
            void var7_12;
            JCDiagnostic.DiagnosticPosition diagnosticPosition = jCMethodDecl.pos();
            for (JCTree.JCAnnotation jCAnnotation : jCMethodDecl.getModifiers().annotations) {
                if (jCAnnotation.annotationType.type.tsym != this.syms.overrideType.tsym) continue;
                JCDiagnostic.DiagnosticPosition diagnosticPosition2 = jCAnnotation.pos();
                break;
            }
            this.log.error((JCDiagnostic.DiagnosticPosition)var7_12, bl2 ? (methodSymbol.isStatic() ? CompilerProperties.Errors.StaticMethodsCannotBeAnnotatedWithOverride : CompilerProperties.Errors.MethodDoesNotOverrideSuperclass) : CompilerProperties.Errors.AnonymousDiamondMethodDoesNotOverrideSuperclass(CompilerProperties.Fragments.DiamondAnonymousMethodsImplicitlyOverride));
        }
    }

    void checkOverride(JCTree jCTree, Type type, Symbol.ClassSymbol classSymbol, Symbol.MethodSymbol methodSymbol) {
        Symbol.TypeSymbol typeSymbol = type.tsym;
        for (Symbol symbol : typeSymbol.members().getSymbolsByName(methodSymbol.name)) {
            if (!methodSymbol.overrides(symbol, classSymbol, this.types, false) || (symbol.flags() & 0x400L) != 0L) continue;
            this.checkOverride(jCTree, methodSymbol, (Symbol.MethodSymbol)symbol, classSymbol);
        }
    }

    public void checkClassOverrideEqualsAndHashIfNeeded(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        List<Type> list;
        if (classSymbol == (Symbol.ClassSymbol)this.syms.objectType.tsym || classSymbol.isInterface() || classSymbol.isEnum() || (classSymbol.flags() & 0x2000L) != 0L || (classSymbol.flags() & 0x400L) != 0L) {
            return;
        }
        if (classSymbol.isAnonymous() && (list = this.types.interfaces(classSymbol.type)) != null && !list.isEmpty() && ((Type)list.head).tsym == this.syms.comparatorType.tsym) {
            return;
        }
        this.checkClassOverrideEqualsAndHash(diagnosticPosition, classSymbol);
    }

    private void checkClassOverrideEqualsAndHash(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        if (this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            boolean bl;
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().findFirst(this.names.equals);
            Symbol.MethodSymbol methodSymbol2 = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().findFirst(this.names.hashCode);
            Symbol.MethodSymbol methodSymbol3 = this.types.implementation(methodSymbol, classSymbol, false, this.equalsHasCodeFilter);
            boolean bl2 = methodSymbol3 != null && methodSymbol3.owner == classSymbol;
            boolean bl3 = bl = this.types.implementation(methodSymbol2, classSymbol, false, this.equalsHasCodeFilter) != methodSymbol2;
            if (bl2 && !bl) {
                this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.OverrideEqualsButNotHashcode(classSymbol));
            }
        }
    }

    public void checkHasMain(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        boolean bl = false;
        for (Symbol symbol : classSymbol.members().getSymbolsByName(this.names.main)) {
            Symbol.MethodSymbol methodSymbol;
            if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 2L) != 0L || !this.types.isSameType((methodSymbol = (Symbol.MethodSymbol)symbol).getReturnType(), this.syms.voidType)) continue;
            if (methodSymbol.params.isEmpty()) {
                bl = true;
                break;
            }
            if (methodSymbol.params.size() != 1 || !this.types.isSameType(((Symbol.VarSymbol)methodSymbol.params.head).type, this.types.makeArrayType(this.syms.stringType))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.ImplicitClassDoesNotHaveMainMethod);
        }
    }

    public void checkModuleName(JCTree.JCModuleDecl jCModuleDecl) {
        Name name = jCModuleDecl.sym.name;
        Assert.checkNonNull(name);
        if (this.lint.isEnabled(Lint.LintCategory.MODULE)) {
            JCTree.JCExpression jCExpression = jCModuleDecl.qualId;
            while (jCExpression != null) {
                int n;
                JCDiagnostic.DiagnosticPosition diagnosticPosition;
                Name name2;
                Object object;
                switch (jCExpression.getTag()) {
                    case SELECT: {
                        object = (JCTree.JCFieldAccess)jCExpression;
                        name2 = ((JCTree.JCFieldAccess)object).name;
                        diagnosticPosition = ((JCTree)object).pos();
                        jCExpression = ((JCTree.JCFieldAccess)object).selected;
                        break;
                    }
                    case IDENT: {
                        name2 = ((JCTree.JCIdent)jCExpression).name;
                        diagnosticPosition = jCExpression.pos();
                        jCExpression = null;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected qualified identifier: " + jCExpression.toString()));
                    }
                }
                if (name2 == null || (n = ((String)(object = name2.toString())).length()) <= 0 || !Character.isDigit(((String)object).charAt(n - 1))) continue;
                this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.PoorChoiceForModuleName(name2));
            }
        }
    }

    private boolean checkNameClash(Symbol.ClassSymbol classSymbol, Symbol symbol, Symbol symbol2) {
        ClashFilter clashFilter = new ClashFilter(classSymbol.type);
        return clashFilter.test(symbol) && clashFilter.test(symbol2) && this.types.hasSameArgs(symbol.erasure(this.types), symbol2.erasure(this.types));
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol) {
        Symbol.MethodSymbol methodSymbol = this.types.firstUnimplementedAbstract(classSymbol);
        if (methodSymbol != null) {
            Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(methodSymbol.flags(), methodSymbol.name, this.types.memberType(classSymbol.type, methodSymbol), methodSymbol.owner);
            this.log.error(diagnosticPosition, CompilerProperties.Errors.DoesNotOverrideAbstract(classSymbol, methodSymbol2, methodSymbol2.location()));
        }
    }

    void checkNonCyclicDecl(JCTree.JCClassDecl jCClassDecl) {
        CycleChecker cycleChecker = new CycleChecker();
        cycleChecker.scan(jCClassDecl);
        if (!cycleChecker.errorFound && !cycleChecker.partialCheck) {
            jCClassDecl.sym.flags_field |= 0x40000000L;
        }
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkNonCyclicInternal(diagnosticPosition, type);
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type.TypeVar typeVar) {
        this.checkNonCyclic1(diagnosticPosition, typeVar, List.nil());
    }

    private void checkNonCyclic1(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type.TypeVar> list) {
        if (type.hasTag(TypeTag.TYPEVAR) && (type.tsym.flags() & 0x10000000L) != 0L) {
            return;
        }
        if (list.contains(type)) {
            Type.TypeVar typeVar = (Type.TypeVar)type;
            typeVar.setUpperBound(this.types.createErrorType(type));
            this.log.error(diagnosticPosition, CompilerProperties.Errors.CyclicInheritance(type));
        } else if (type.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar typeVar = (Type.TypeVar)type;
            list = list.prepend(typeVar);
            for (Type type2 : this.types.getBounds(typeVar)) {
                this.checkNonCyclic1(diagnosticPosition, type2, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        boolean bl = true;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        if ((typeSymbol.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.CyclicInheritance(typeSymbol));
            this.handleCyclic((Symbol.ClassSymbol)typeSymbol);
        } else if (!typeSymbol.type.isErroneous()) {
            try {
                typeSymbol.flags_field |= 0x8000000L;
                if (typeSymbol.type.hasTag(TypeTag.CLASS)) {
                    List list;
                    Type.ClassType classType = (Type.ClassType)typeSymbol.type;
                    if (classType.interfaces_field != null) {
                        list = classType.interfaces_field;
                        while (list.nonEmpty()) {
                            bl &= this.checkNonCyclicInternal(diagnosticPosition, (Type)list.head);
                            list = list.tail;
                        }
                    }
                    if (classType.supertype_field != null && (list = classType.supertype_field) != null && ((Type)((Object)list)).hasTag(TypeTag.CLASS)) {
                        bl &= this.checkNonCyclicInternal(diagnosticPosition, (Type)((Object)list));
                    }
                    if (typeSymbol.owner.kind == Kinds.Kind.TYP) {
                        bl &= this.checkNonCyclicInternal(diagnosticPosition, typeSymbol.owner.type);
                    }
                }
            }
            finally {
                typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
        }
        if (bl) {
            boolean bl2 = bl = (typeSymbol.flags_field & 0x10000000L) == 0L && typeSymbol.isCompleted();
        }
        if (bl) {
            typeSymbol.flags_field |= 0x40000000L;
        }
        return bl;
    }

    private void handleCyclic(Symbol.ClassSymbol classSymbol) {
        Object object = this.types.interfaces(classSymbol.type);
        while (((List)object).nonEmpty()) {
            ((List)object).head = this.types.createErrorType((Symbol.ClassSymbol)((Type)((List)object).head).tsym, Type.noType);
            object = ((List)object).tail;
        }
        object = this.types.supertype(classSymbol.type);
        if (((Type)object).hasTag(TypeTag.CLASS)) {
            ((Type.ClassType)classSymbol.type).supertype_field = this.types.createErrorType((Symbol.ClassSymbol)((Type)object).tsym, Type.noType);
        }
        classSymbol.type = this.types.createErrorType(classSymbol, classSymbol.type);
        classSymbol.flags_field |= 0x40000000L;
    }

    void checkImplementations(JCTree.JCClassDecl jCClassDecl) {
        this.checkImplementations(jCClassDecl, jCClassDecl.sym, jCClassDecl.sym);
    }

    void checkImplementations(JCTree jCTree, Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        List<Type> list = this.types.closure(classSymbol2.type);
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol3 = (Symbol.ClassSymbol)((Type)list.head).tsym;
            if ((classSymbol3.flags() & 0x400L) != 0L) {
                for (Symbol symbol : classSymbol3.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                    Symbol.MethodSymbol methodSymbol;
                    Symbol.MethodSymbol methodSymbol2;
                    if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 0x408L) != 1024L || (methodSymbol2 = (methodSymbol = (Symbol.MethodSymbol)symbol).implementation(classSymbol, this.types, false)) == null || methodSymbol2 == methodSymbol || (methodSymbol2.owner.flags() & 0x200L) != (classSymbol.flags() & 0x200L)) continue;
                    this.checkOverride(jCTree, methodSymbol2, methodSymbol, classSymbol);
                }
            }
            list = list.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        List<Type> list = this.types.interfaces(type);
        Type type2 = this.types.supertype(type);
        if (type2.hasTag(TypeTag.CLASS) && (type2.tsym.flags() & 0x400L) != 0L) {
            list = list.prepend(type2);
        }
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (!((Type)list2.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(diagnosticPosition, (Type)list2.head, (Type)list2.head, type)) {
                return;
            }
            List<Type> list3 = list;
            while (list3 != list2) {
                if (!this.checkCompatibleAbstracts(diagnosticPosition, (Type)list2.head, (Type)list3.head, type)) {
                    return;
                }
                list3 = list3.tail;
            }
            list2 = list2.tail;
        }
        this.checkCompatibleConcretes(diagnosticPosition, type);
    }

    void checkOverrideClashes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Symbol.MethodSymbol methodSymbol) {
        ClashFilter clashFilter = new ClashFilter(type);
        ArrayList arrayList = new ArrayList();
        this.types.membersClosure(type, false).getSymbolsByName(methodSymbol.name, clashFilter).forEach(arrayList::add);
        for (Symbol symbol : arrayList) {
            if (!methodSymbol.overrides(symbol, type.tsym, this.types, false)) continue;
            for (Symbol symbol2 : arrayList) {
                if (symbol2 == symbol || this.types.isSubSignature(methodSymbol.type, this.types.memberType(type, symbol2)) || !this.types.hasSameArgs(symbol2.erasure(this.types), symbol.erasure(this.types))) continue;
                methodSymbol.flags_field |= 0x40000000000L;
                if (symbol == methodSymbol) {
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.NameClashSameErasureNoOverride(symbol.name, this.types.memberType(type, symbol).asMethodType().getParameterTypes(), symbol.location(), symbol2.name, this.types.memberType(type, symbol2).asMethodType().getParameterTypes(), symbol2.location()));
                } else {
                    Type.ClassType classType = (Type.ClassType)type;
                    String string = classType.isInterface() ? "interface" : "class";
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.NameClashSameErasureNoOverride1(string, classType.tsym.name, symbol.name, this.types.memberType(type, symbol).asMethodType().getParameterTypes(), symbol.location(), symbol2.name, this.types.memberType(type, symbol2).asMethodType().getParameterTypes(), symbol2.location()));
                }
                return;
            }
        }
    }

    void checkHideClashes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Symbol.MethodSymbol methodSymbol) {
        ClashFilter clashFilter = new ClashFilter(type);
        for (Symbol symbol : this.types.membersClosure(type, true).getSymbolsByName(methodSymbol.name, clashFilter)) {
            if (this.types.isSubSignature(methodSymbol.type, this.types.memberType(type, symbol)) || !this.types.hasSameArgs(symbol.erasure(this.types), methodSymbol.erasure(this.types))) continue;
            this.log.error(diagnosticPosition, CompilerProperties.Errors.NameClashSameErasureNoHide(methodSymbol, methodSymbol.location(), symbol, symbol.location()));
            return;
        }
    }

    void checkDefaultMethodClashes(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        DefaultMethodClashFilter defaultMethodClashFilter = new DefaultMethodClashFilter(type);
        block0: for (Symbol symbol : this.types.membersClosure(type, false).getSymbols(defaultMethodClashFilter)) {
            Assert.check(symbol.kind == Kinds.Kind.MTH);
            List<Symbol.MethodSymbol> list = this.types.interfaceCandidates(type, (Symbol.MethodSymbol)symbol);
            if (list.size() <= 1) continue;
            ListBuffer<Object> listBuffer = new ListBuffer<Symbol.MethodSymbol>();
            ListBuffer<Object> listBuffer2 = new ListBuffer<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol methodSymbol : list) {
                JCDiagnostic.Fragment fragment;
                Symbol symbol2;
                if ((methodSymbol.flags() & 0x80000000000L) != 0L) {
                    listBuffer2 = listBuffer2.append(methodSymbol);
                } else if ((methodSymbol.flags() & 0x400L) != 0L) {
                    listBuffer = listBuffer.append(methodSymbol);
                }
                if (!listBuffer2.nonEmpty() || listBuffer2.size() + listBuffer.size() < 2) continue;
                Symbol symbol3 = (Symbol)listBuffer2.first();
                if (listBuffer2.size() > 1) {
                    symbol2 = (Symbol)listBuffer2.toList().tail.head;
                    fragment = CompilerProperties.Fragments.IncompatibleUnrelatedDefaults(Kinds.kindName(type.tsym), type, symbol.name, this.types.memberType(type, symbol).getParameterTypes(), symbol3.location(), symbol2.location());
                } else {
                    symbol2 = (Symbol)listBuffer.first();
                    fragment = CompilerProperties.Fragments.IncompatibleAbstractDefault(Kinds.kindName(type.tsym), type, symbol.name, this.types.memberType(type, symbol).getParameterTypes(), symbol3.location(), symbol2.location());
                }
                this.log.error(diagnosticPosition, CompilerProperties.Errors.TypesIncompatible(symbol3.location().type, symbol2.location().type, fragment));
                continue block0;
            }
        }
    }

    void checkPotentiallyAmbiguousOverloads(JCTree.JCClassDecl jCClassDecl, Type type) {
        if (!this.lint.isEnabled(Lint.LintCategory.OVERLOADS)) {
            return;
        }
        List<java.util.List> list2 = this.methodsGroupedByName(type, new PotentiallyAmbiguousFilter(type), ArrayList::new);
        BiPredicate<Symbol.MethodSymbol, Symbol.MethodSymbol> biPredicate = this.buildResponsiblePredicate(type, list2);
        list2.forEach(list -> this.removePreempted((java.util.List)list, (methodSymbol, methodSymbol2) -> methodSymbol.overrides((Symbol)methodSymbol2, type.tsym, this.types, false)));
        list2.forEach(list -> list.removeIf(methodSymbol -> methodSymbol.owner == type.tsym && !this.lint.augment((Symbol)methodSymbol).isEnabled(Lint.LintCategory.OVERLOADS)));
        list2.forEach(list -> this.compareAndRemove((java.util.List)list, (methodSymbol, methodSymbol2) -> {
            if (!this.potentiallyAmbiguousOverload(type, (Symbol.MethodSymbol)methodSymbol, (Symbol.MethodSymbol)methodSymbol2) || !biPredicate.test((Symbol.MethodSymbol)methodSymbol, (Symbol.MethodSymbol)methodSymbol2)) {
                return 0;
            }
            JCDiagnostic.DiagnosticPosition diagnosticPosition = methodSymbol.owner == type.tsym ? TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl) : (methodSymbol2.owner == type.tsym ? TreeInfo.diagnosticPositionFor((Symbol)methodSymbol2, jCClassDecl) : jCClassDecl.pos());
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.PotentiallyAmbiguousOverload(methodSymbol.asMemberOf(type, this.types), methodSymbol.location(), methodSymbol2.asMemberOf(type, this.types), methodSymbol2.location()));
            return 3;
        }));
    }

    BiPredicate<Symbol.MethodSymbol, Symbol.MethodSymbol> buildResponsiblePredicate(Type type, List<? extends Collection<Symbol.MethodSymbol>> list) {
        BiPredicate<Symbol.MethodSymbol, Symbol.MethodSymbol> biPredicate = (methodSymbol, methodSymbol2) -> methodSymbol.overrides((Symbol)methodSymbol2, type.tsym, this.types, false);
        HashMap hashMap = new HashMap();
        list.forEach(collection -> {
            for (Symbol.MethodSymbol methodSymbol : collection) {
                if (methodSymbol.owner != type.tsym) continue;
                ArrayList arrayList = collection.stream().filter(methodSymbol2 -> methodSymbol2 != methodSymbol && biPredicate.test(methodSymbol, (Symbol.MethodSymbol)methodSymbol2)).collect(Collectors.toCollection(ArrayList::new));
                this.removePreempted(arrayList, biPredicate);
                hashMap.put(methodSymbol, arrayList);
            }
        });
        return (methodSymbol, methodSymbol2) -> {
            java.util.List<Symbol.MethodSymbol> list = (java.util.List<Symbol.MethodSymbol>)hashMap.get(methodSymbol);
            java.util.List<Symbol.MethodSymbol> list2 = (java.util.List<Symbol.MethodSymbol>)hashMap.get(methodSymbol2);
            if (list != null && list.isEmpty()) {
                return true;
            }
            if (list2 != null && list2.isEmpty()) {
                return true;
            }
            java.util.List<Symbol.MethodSymbol> list3 = list != null ? list : Collections.singletonList(methodSymbol);
            java.util.List<Symbol.MethodSymbol> list4 = list2 != null ? list2 : Collections.singletonList(methodSymbol2);
            return this.types.directSupertypes(type).stream().filter(type -> type != this.syms.objectType).map(type -> type.tsym.type).noneMatch(type -> {
                for (Symbol.MethodSymbol methodSymbol : list3) {
                    if (!this.types.isSubtype(this.types.erasure((Type)type), this.types.erasure(methodSymbol.owner.type))) continue;
                    for (Symbol.MethodSymbol methodSymbol2 : list4) {
                        if (!this.types.isSubtype(this.types.erasure((Type)type), this.types.erasure(methodSymbol2.owner.type)) || !this.potentiallyAmbiguousOverload((Type)type, methodSymbol, methodSymbol2)) continue;
                        return true;
                    }
                }
                return false;
            });
        };
    }

    <C extends Collection<Symbol.MethodSymbol>> List<C> methodsGroupedByName(Type type, Predicate<Symbol> predicate, Supplier<? extends C> supplier) {
        Iterable<Symbol> iterable = this.types.membersClosure(type, false).getSymbols(predicate, Scope.LookupKind.RECURSIVE);
        return StreamSupport.stream(iterable.spliterator(), false).map(Symbol.MethodSymbol.class::cast).collect(Collectors.groupingBy(methodSymbol -> methodSymbol.name, Collectors.toCollection(supplier))).entrySet().stream().sorted(Comparator.comparing(entry -> ((Name)entry.getKey()).toString())).map(Map.Entry::getValue).collect(List.collector());
    }

    <T> void compareAndRemove(java.util.List<T> list, ToIntBiFunction<? super T, ? super T> toIntBiFunction) {
        block0: for (int i = 0; i < list.size() - 1; ++i) {
            T t = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                T t2 = list.get(j);
                int n = toIntBiFunction.applyAsInt(t, t2);
                if ((n & 2) != 0) {
                    list.remove(j--);
                }
                if ((n & 1) == 0) continue;
                list.remove(i--);
                continue block0;
            }
        }
    }

    <T> void removePreempted(java.util.List<T> list, BiPredicate<? super T, ? super T> biPredicate) {
        this.compareAndRemove(list, (object, object2) -> {
            int n = 0;
            if (biPredicate.test(object, object2)) {
                n |= 2;
            }
            if (biPredicate.test(object2, object)) {
                n |= 1;
            }
            return n;
        });
    }

    boolean potentiallyAmbiguousOverload(Type type, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        Assert.check(methodSymbol.name == methodSymbol2.name);
        if (methodSymbol == methodSymbol2) {
            return false;
        }
        Type type2 = this.types.memberType(type, methodSymbol);
        Type type3 = this.types.memberType(type, methodSymbol2);
        if (type2.hasTag(TypeTag.FORALL) && type3.hasTag(TypeTag.FORALL) && this.types.hasSameBounds((Type.ForAll)type2, (Type.ForAll)type3)) {
            type3 = this.types.subst(type3, ((Type.ForAll)type3).tvars, ((Type.ForAll)type2).tvars);
        }
        int n = Math.max(type2.getParameterTypes().length(), type3.getParameterTypes().length());
        List<Type> list = this.rs.adjustArgs(type2.getParameterTypes(), methodSymbol, n, true);
        List<Type> list2 = this.rs.adjustArgs(type3.getParameterTypes(), methodSymbol2, n, true);
        if (list.length() != list2.length()) {
            return false;
        }
        boolean bl = false;
        while (list.nonEmpty() && list2.nonEmpty()) {
            Type type4 = (Type)list2.head;
            Type type5 = (Type)list.head;
            if (!this.types.isSubtype(type4, type5) && !this.types.isSubtype(type5, type4)) {
                if (this.types.isFunctionalInterface(type5) && this.types.isFunctionalInterface(type4) && this.types.findDescriptorType(type5).getParameterTypes().length() > 0 && this.types.findDescriptorType(type5).getParameterTypes().length() == this.types.findDescriptorType(type4).getParameterTypes().length()) {
                    bl = true;
                } else {
                    return false;
                }
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAccessFromSerializableElement(JCTree jCTree, boolean bl) {
        Lint lint = this.setLint(this.warnOnAnyAccessToMembers ? this.lint.enable(Lint.LintCategory.SERIAL) : this.lint);
        try {
            if (this.warnOnAnyAccessToMembers || bl) {
                this.checkAccessFromSerializableElementInner(jCTree, bl);
            }
        }
        finally {
            this.setLint(lint);
        }
    }

    private void checkAccessFromSerializableElementInner(JCTree jCTree, boolean bl) {
        if (this.lint.isEnabled(Lint.LintCategory.SERIAL)) {
            Symbol symbol = TreeInfo.symbol(jCTree);
            if (!symbol.kind.matches(Kinds.KindSelector.VAL_MTH)) {
                return;
            }
            if (symbol.kind == Kinds.Kind.VAR && ((symbol.flags() & 0x200000000L) != 0L || symbol.isDirectlyOrIndirectlyLocal() || symbol.name == this.names._this || symbol.name == this.names._super)) {
                return;
            }
            if (!this.types.isSubtype(symbol.owner.type, this.syms.serializableType) && this.isEffectivelyNonPublic(symbol)) {
                if (bl) {
                    if (this.belongsToRestrictedPackage(symbol)) {
                        this.log.warning(jCTree.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.AccessToMemberFromSerializableLambda(symbol));
                    }
                } else {
                    this.log.warning(jCTree.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.AccessToMemberFromSerializableElement(symbol));
                }
            }
        }
    }

    private boolean isEffectivelyNonPublic(Symbol symbol) {
        if (symbol.packge() == this.syms.rootPackage) {
            return false;
        }
        while (symbol.kind != Kinds.Kind.PCK) {
            if ((symbol.flags() & 1L) == 0L) {
                return true;
            }
            symbol = symbol.owner;
        }
        return false;
    }

    private boolean belongsToRestrictedPackage(Symbol symbol) {
        String string = symbol.packge().fullname.toString();
        return string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("sun.") || string.contains(".internal.");
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkClassBounds(diagnosticPosition, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition diagnosticPosition, Map<Symbol.TypeSymbol, Type> map, Type type) {
        if (type.isErroneous()) {
            return;
        }
        List list = this.types.interfaces(type);
        while (list.nonEmpty()) {
            Type type2 = (Type)list.head;
            if (!type.hasTag(TypeTag.CLASS) || type2.hasTag(TypeTag.CLASS)) {
                List<Type> list2;
                List<Type> list3;
                Type type3 = map.put(type2.tsym, type2);
                if (type3 != null && !this.types.containsTypeEquivalent(list3 = type3.allparams(), list2 = type2.allparams())) {
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.CantInheritDiffArg(type2.tsym, Type.toString(list3), Type.toString(list2)));
                }
                this.checkClassBounds(diagnosticPosition, map, type2);
            }
            list = list.tail;
        }
        list = this.types.supertype(type);
        if (type.hasTag(TypeTag.CLASS) && !((Type)((Object)list)).hasTag(TypeTag.CLASS)) {
            return;
        }
        if (list != Type.noType) {
            this.checkClassBounds(diagnosticPosition, map, (Type)((Object)list));
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Set<Symbol> set) {
        if (set.contains(type.tsym)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.RepeatedInterface);
        } else {
            set.add(type.tsym);
        }
    }

    void validateAnnotationTree(JCTree jCTree) {
        class AnnotationValidator
        extends TreeScanner {
            AnnotationValidator() {
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
                if (!jCAnnotation.type.isErroneous() && jCAnnotation.type.tsym.isAnnotationType()) {
                    super.visitAnnotation(jCAnnotation);
                    Check.this.validateAnnotation(jCAnnotation);
                }
            }
        }
        jCTree.accept(new AnnotationValidator());
    }

    void validateAnnotationType(JCTree jCTree) {
        if (jCTree != null) {
            this.validateAnnotationType(jCTree.pos(), jCTree.type);
        }
    }

    void validateAnnotationType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.cvarLowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(diagnosticPosition, this.types.elemtype(type));
            return;
        }
        this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidAnnotationMemberType);
    }

    void validateAnnotationMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.MethodSymbol methodSymbol) {
        Type type = this.syms.annotationType;
        while (type.hasTag(TypeTag.CLASS)) {
            Scope.WriteableScope writeableScope = type.tsym.members();
            for (Symbol symbol : writeableScope.getSymbolsByName(methodSymbol.name)) {
                if (symbol.kind != Kinds.Kind.MTH || (symbol.flags() & 5L) == 0L || !this.types.overrideEquivalent(methodSymbol.type, symbol.type)) continue;
                this.log.error(diagnosticPosition, CompilerProperties.Errors.IntfAnnotationMemberClash(symbol, type));
            }
            type = this.types.supertype(type);
        }
    }

    public void validateAnnotations(List<JCTree.JCAnnotation> list, JCTree jCTree, Symbol symbol) {
        for (JCTree.JCAnnotation jCAnnotation : list) {
            this.validateAnnotation(jCAnnotation, jCTree, symbol);
        }
    }

    public void validateTypeAnnotations(List<JCTree.JCAnnotation> list, Symbol symbol, boolean bl) {
        for (JCTree.JCAnnotation jCAnnotation : list) {
            this.validateTypeAnnotation(jCAnnotation, symbol, bl);
        }
    }

    private void validateAnnotation(JCTree.JCAnnotation jCAnnotation, JCTree jCTree, Symbol symbol) {
        Object object32;
        Object object2;
        boolean bl;
        this.validateAnnotationTree(jCAnnotation);
        boolean bl2 = (symbol.flags_field & 0x2000000000000000L) != 0L || symbol.enclClass() != null && symbol.enclClass().isRecord();
        boolean bl3 = bl = (symbol.flags_field & 0x2000000000000000L) != 0L && jCTree.hasTag(JCTree.Tag.VARDEF) && symbol.owner.kind == Kinds.Kind.TYP;
        if (bl) {
            object2 = this.getTargetNames(jCAnnotation);
            boolean bl4 = false;
            for (Object object32 : object2) {
                boolean bl5 = bl4 = object32 == this.names.FIELD || object32 == this.names.PARAMETER || object32 == this.names.METHOD || object32 == this.names.TYPE_USE || object32 == this.names.RECORD_COMPONENT;
                if (bl4) break;
            }
            if (!bl4) {
                this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicable);
            } else {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol.owner;
                Symbol.RecordComponent recordComponent = classSymbol.getRecordComponent((Symbol.VarSymbol)symbol);
                SymbolMetadata symbolMetadata = recordComponent.getMetadata();
                if (symbolMetadata == null || symbolMetadata.isEmpty()) {
                    recordComponent.appendAttributes(symbol.getRawAttributes().stream().filter(compound -> Arrays.stream(this.getTargetNames(compound.type.tsym)).anyMatch(name -> name == this.names.RECORD_COMPONENT)).collect(List.collector()));
                    object32 = (JCTree.JCVariableDecl)jCTree;
                    block1: for (JCTree.JCAnnotation object4 : ((JCTree.JCVariableDecl)object32).mods.annotations) {
                        for (JCTree.JCAnnotation jCAnnotation2 : recordComponent.declarationFor().mods.annotations) {
                            if (jCAnnotation2.pos != object4.pos) continue;
                            jCAnnotation2.setType(object4.type);
                            continue block1;
                        }
                    }
                }
            }
        }
        if (jCAnnotation.type.tsym.isAnnotationType() && ((Optional)(object2 = this.getApplicableTargets(jCAnnotation, symbol))).isPresent()) {
            int n;
            Set set = (Set)((Optional)object2).get();
            boolean bl6 = set.isEmpty() || set.size() == 1 && set.contains(this.names.TYPE_USE);
            int n2 = bl2 && (symbol.flags_field & 0x1000000L) != 0L ? 1 : 0;
            int n3 = n = n2 != 0 && bl6 ? 1 : 0;
            if (set.isEmpty() || n != 0) {
                if (n != 0) {
                    object32 = TreeInfo.getModifiers(jCTree);
                    if (object32 != null && set.isEmpty()) {
                        ListBuffer listBuffer = new ListBuffer();
                        for (JCTree.JCAnnotation jCAnnotation3 : ((JCTree.JCModifiers)object32).annotations) {
                            if (jCAnnotation3 == jCAnnotation) continue;
                            listBuffer.add(jCAnnotation3);
                        }
                        ((JCTree.JCModifiers)object32).annotations = listBuffer.toList();
                    }
                    symbol.getMetadata().removeDeclarationMetadata(jCAnnotation.attribute);
                } else {
                    this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicable);
                }
            }
            if (n2 != 0 && !bl && jCAnnotation.type.tsym == this.syms.trustMeType.tsym && jCTree.hasTag(JCTree.Tag.METHODDEF)) {
                this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.VarargsInvalidTrustmeAnno((Symbol)this.syms.trustMeType.tsym, CompilerProperties.Fragments.VarargsTrustmeOnNonVarargsAccessor(symbol)));
            }
        }
        if (jCAnnotation.annotationType.type.tsym == this.syms.functionalInterfaceType.tsym) {
            if (symbol.kind != Kinds.Kind.TYP) {
                this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.BadFunctionalIntfAnno);
            } else if (!symbol.isInterface() || (symbol.flags() & 0x2000L) != 0L) {
                this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.BadFunctionalIntfAnno1(CompilerProperties.Fragments.NotAFunctionalIntf(symbol)));
            }
        }
    }

    public void validateTypeAnnotation(JCTree.JCAnnotation jCAnnotation, Symbol symbol, boolean bl) {
        Assert.checkNonNull(jCAnnotation.type);
        if (symbol != null) {
            this.getApplicableTargets(jCAnnotation, symbol);
        }
        this.validateAnnotationTree(jCAnnotation);
        if (jCAnnotation.hasTag(JCTree.Tag.TYPE_ANNOTATION) && !jCAnnotation.annotationType.type.isErroneous() && !this.isTypeAnnotation(jCAnnotation, bl)) {
            this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.AnnotationTypeNotApplicableToType(jCAnnotation.type));
        }
    }

    public void validateRepeatable(Symbol.TypeSymbol typeSymbol, Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Assert.check(this.types.isSameType(compound.type, this.syms.repeatableType));
        Type type = null;
        List<Pair<Symbol.MethodSymbol, Attribute>> list = compound.values;
        if (!list.isEmpty()) {
            Assert.check(((Symbol.MethodSymbol)((Pair)list.head).fst).name == this.names.value);
            if (((Pair)list.head).snd instanceof Attribute.Class) {
                type = ((Attribute.Class)((Pair)list.head).snd).getValue();
            }
        }
        if (type == null) {
            return;
        }
        this.validateValue(type.tsym, typeSymbol, diagnosticPosition);
        this.validateRetention(type.tsym, typeSymbol, diagnosticPosition);
        this.validateDocumented(type.tsym, typeSymbol, diagnosticPosition);
        this.validateInherited(type.tsym, typeSymbol, diagnosticPosition);
        this.validateTarget(type.tsym, typeSymbol, diagnosticPosition);
        this.validateDefault(type.tsym, diagnosticPosition);
    }

    private void validateValue(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Symbol symbol = typeSymbol.members().findFirst(this.names.value);
        if (symbol != null && symbol.kind == Kinds.Kind.MTH) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            Type type = methodSymbol.getReturnType();
            if (!type.hasTag(TypeTag.ARRAY) || !this.types.isSameType(((Type.ArrayType)type).elemtype, typeSymbol2.type)) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationValueReturn(typeSymbol, type, (Type)this.types.makeArrayType(typeSymbol2.type)));
            }
        } else {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationNoValue(typeSymbol));
        }
    }

    private void validateRetention(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Attribute.RetentionPolicy retentionPolicy = this.types.getRetention(typeSymbol);
        Attribute.RetentionPolicy retentionPolicy2 = this.types.getRetention(typeSymbol2);
        boolean bl = false;
        switch (retentionPolicy2) {
            case RUNTIME: {
                if (retentionPolicy == Attribute.RetentionPolicy.RUNTIME) break;
                bl = true;
                break;
            }
            case CLASS: {
                if (retentionPolicy != Attribute.RetentionPolicy.SOURCE) break;
                bl = true;
            }
        }
        if (bl) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationRetention(typeSymbol, retentionPolicy.name(), typeSymbol2, retentionPolicy2.name()));
        }
    }

    private void validateDocumented(Symbol symbol, Symbol symbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (symbol2.attribute(this.syms.documentedType.tsym) != null && symbol.attribute(this.syms.documentedType.tsym) == null) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationNotDocumented(symbol, symbol2));
        }
    }

    private void validateInherited(Symbol symbol, Symbol symbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (symbol2.attribute(this.syms.inheritedType.tsym) != null && symbol.attribute(this.syms.inheritedType.tsym) == null) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationNotInherited(symbol, symbol2));
        }
    }

    private void validateTarget(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Object object;
        Set<Name> set;
        Attribute.Array array = this.getAttributeTargetAttribute(typeSymbol);
        if (array == null) {
            set = this.getDefaultTargetSet();
        } else {
            set = new HashSet<Name>();
            for (Attribute attribute : array.values) {
                if (!(attribute instanceof Attribute.Enum)) continue;
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                set.add(enum_.value.name);
            }
        }
        Attribute.Array array2 = this.getAttributeTargetAttribute(typeSymbol2);
        if (array2 == null) {
            object = this.getDefaultTargetSet();
        } else {
            object = new HashSet();
            for (Attribute attribute : array2.values) {
                if (!(attribute instanceof Attribute.Enum)) continue;
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                object.add(enum_.value.name);
            }
        }
        if (!this.isTargetSubsetOf(set, (Set<Name>)object)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationIncompatibleTarget(typeSymbol, typeSymbol2));
        }
    }

    private Set<Name> getDefaultTargetSet() {
        if (this.defaultTargets == null) {
            this.defaultTargets = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(this.defaultTargetMetaInfo())));
        }
        return this.defaultTargets;
    }

    private boolean isTargetSubsetOf(Set<Name> set, Set<Name> set2) {
        for (Name name : set) {
            boolean bl = false;
            for (Name name2 : set2) {
                if (name2 == name) {
                    bl = true;
                    break;
                }
                if (name2 == this.names.TYPE && name == this.names.ANNOTATION_TYPE) {
                    bl = true;
                    break;
                }
                if (name2 != this.names.TYPE_USE || name != this.names.TYPE && name != this.names.ANNOTATION_TYPE && name != this.names.TYPE_PARAMETER) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void validateDefault(Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Scope.WriteableScope writeableScope = symbol.members();
        for (Symbol symbol2 : writeableScope.getSymbols()) {
            if (symbol2.name == this.names.value || symbol2.kind != Kinds.Kind.MTH || ((Symbol.MethodSymbol)symbol2).defaultValue != null) continue;
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationElemNondefault(symbol, symbol2));
        }
    }

    boolean isOverrider(Symbol symbol) {
        if (symbol.kind != Kinds.Kind.MTH || symbol.isStatic()) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)methodSymbol.owner;
        for (Type type : this.types.closure(typeSymbol.type)) {
            if (type == typeSymbol.type) continue;
            Scope.WriteableScope writeableScope = type.tsym.members();
            for (Symbol symbol2 : writeableScope.getSymbolsByName(methodSymbol.name)) {
                if (symbol2.isStatic() || !methodSymbol.overrides(symbol2, typeSymbol, this.types, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTypeAnnotation(JCTree.JCAnnotation jCAnnotation, boolean bl) {
        List<Attribute> list = this.typeAnnotations.annotationTargets(jCAnnotation.annotationType.type.tsym);
        return list == null ? Source.Feature.NO_TARGET_ANNOTATION_APPLICABILITY.allowedInSource(this.source) && bl : list.stream().anyMatch(attribute -> this.isTypeAnnotation((Attribute)attribute, bl));
    }

    boolean isTypeAnnotation(Attribute attribute, boolean bl) {
        Attribute.Enum enum_ = (Attribute.Enum)attribute;
        return enum_.value.name == this.names.TYPE_USE || bl && enum_.value.name == this.names.TYPE_PARAMETER;
    }

    Name[] getTargetNames(JCTree.JCAnnotation jCAnnotation) {
        return this.getTargetNames(jCAnnotation.annotationType.type.tsym);
    }

    public Name[] getTargetNames(Symbol.TypeSymbol typeSymbol) {
        Name[] nameArray;
        Attribute.Array array = this.getAttributeTargetAttribute(typeSymbol);
        if (array == null) {
            nameArray = this.defaultTargetMetaInfo();
        } else {
            nameArray = new Name[array.values.length];
            for (int i = 0; i < array.values.length; ++i) {
                Attribute attribute = array.values[i];
                if (!(attribute instanceof Attribute.Enum)) {
                    return new Name[0];
                }
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                nameArray[i] = enum_.value.name;
            }
        }
        return nameArray;
    }

    boolean annotationApplicable(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        Optional<Set<Name>> optional = this.getApplicableTargets(jCAnnotation, symbol);
        return !optional.isPresent() || optional.isPresent() && !optional.get().isEmpty();
    }

    Optional<Set<Name>> getApplicableTargets(JCTree.JCAnnotation jCAnnotation, Symbol symbol) {
        Name[] nameArray;
        Attribute.Array array = this.getAttributeTargetAttribute(jCAnnotation.annotationType.type.tsym);
        HashSet<Name> hashSet = new HashSet<Name>();
        if (array == null) {
            nameArray = this.defaultTargetMetaInfo();
        } else {
            nameArray = new Name[array.values.length];
            for (int i = 0; i < array.values.length; ++i) {
                Attribute attribute = array.values[i];
                if (!(attribute instanceof Attribute.Enum)) {
                    return Optional.empty();
                }
                Attribute.Enum enum_ = (Attribute.Enum)attribute;
                nameArray[i] = enum_.value.name;
            }
        }
        for (Name name : nameArray) {
            if (name == this.names.TYPE) {
                if (symbol.kind != Kinds.Kind.TYP) continue;
                hashSet.add(this.names.TYPE);
                continue;
            }
            if (name == this.names.FIELD) {
                if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind == Kinds.Kind.MTH) continue;
                hashSet.add(this.names.FIELD);
                continue;
            }
            if (name == this.names.RECORD_COMPONENT) {
                if (symbol.getKind() != ElementKind.RECORD_COMPONENT) continue;
                hashSet.add(this.names.RECORD_COMPONENT);
                continue;
            }
            if (name == this.names.METHOD) {
                if (symbol.kind != Kinds.Kind.MTH || symbol.isConstructor()) continue;
                hashSet.add(this.names.METHOD);
                continue;
            }
            if (name == this.names.PARAMETER) {
                if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind != Kinds.Kind.MTH || (symbol.flags() & 0x200000000L) == 0L) continue;
                hashSet.add(this.names.PARAMETER);
                continue;
            }
            if (name == this.names.CONSTRUCTOR) {
                if (symbol.kind != Kinds.Kind.MTH || !symbol.isConstructor()) continue;
                hashSet.add(this.names.CONSTRUCTOR);
                continue;
            }
            if (name == this.names.LOCAL_VARIABLE) {
                if (symbol.kind != Kinds.Kind.VAR || symbol.owner.kind != Kinds.Kind.MTH || (symbol.flags() & 0x200000000L) != 0L) continue;
                hashSet.add(this.names.LOCAL_VARIABLE);
                continue;
            }
            if (name == this.names.ANNOTATION_TYPE) {
                if (symbol.kind != Kinds.Kind.TYP || (symbol.flags() & 0x2000L) == 0L) continue;
                hashSet.add(this.names.ANNOTATION_TYPE);
                continue;
            }
            if (name == this.names.PACKAGE) {
                if (symbol.kind != Kinds.Kind.PCK) continue;
                hashSet.add(this.names.PACKAGE);
                continue;
            }
            if (name == this.names.TYPE_USE) {
                if (symbol.kind == Kinds.Kind.VAR && symbol.owner.kind == Kinds.Kind.MTH && symbol.type.hasTag(TypeTag.NONE) || symbol.kind != Kinds.Kind.TYP && symbol.kind != Kinds.Kind.VAR && (symbol.kind != Kinds.Kind.MTH || symbol.isConstructor() || symbol.type.getReturnType().hasTag(TypeTag.VOID)) && (symbol.kind != Kinds.Kind.MTH || !symbol.isConstructor())) continue;
                hashSet.add(this.names.TYPE_USE);
                continue;
            }
            if (name == this.names.TYPE_PARAMETER) {
                if (symbol.kind != Kinds.Kind.TYP || !symbol.type.hasTag(TypeTag.TYPEVAR)) continue;
                hashSet.add(this.names.TYPE_PARAMETER);
                continue;
            }
            if (name == this.names.MODULE) {
                if (symbol.kind != Kinds.Kind.MDL) continue;
                hashSet.add(this.names.MODULE);
                continue;
            }
            this.log.error(jCAnnotation, CompilerProperties.Errors.AnnotationUnrecognizedAttributeName(jCAnnotation.type, name));
            return Optional.empty();
        }
        return Optional.of(hashSet);
    }

    Attribute.Array getAttributeTargetAttribute(Symbol.TypeSymbol typeSymbol) {
        Attribute.Array array;
        Attribute.Compound compound = typeSymbol.getAnnotationTypeMetadata().getTarget();
        if (compound == null) {
            return null;
        }
        Attribute attribute = compound.member(this.names.value);
        return attribute instanceof Attribute.Array ? (array = (Attribute.Array)attribute) : null;
    }

    private Name[] defaultTargetMetaInfo() {
        if (this.dfltTargetMeta == null) {
            ArrayList<Name> arrayList = new ArrayList<Name>();
            arrayList.add(this.names.PACKAGE);
            arrayList.add(this.names.TYPE);
            arrayList.add(this.names.FIELD);
            arrayList.add(this.names.METHOD);
            arrayList.add(this.names.CONSTRUCTOR);
            arrayList.add(this.names.ANNOTATION_TYPE);
            arrayList.add(this.names.LOCAL_VARIABLE);
            arrayList.add(this.names.PARAMETER);
            if (this.allowRecords) {
                arrayList.add(this.names.RECORD_COMPONENT);
            }
            if (this.allowModules) {
                arrayList.add(this.names.MODULE);
            }
            this.dfltTargetMeta = arrayList.toArray(new Name[0]);
        }
        return this.dfltTargetMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAnnotationDeferErrors(JCTree.JCAnnotation jCAnnotation) {
        boolean bl = false;
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            bl = this.validateAnnotation(jCAnnotation);
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
        return bl;
    }

    private boolean validateAnnotation(JCTree.JCAnnotation jCAnnotation) {
        Object object;
        boolean bl = true;
        Annotate.AnnotationTypeMetadata annotationTypeMetadata = jCAnnotation.annotationType.type.tsym.getAnnotationTypeMetadata();
        Set<Symbol.MethodSymbol> set = annotationTypeMetadata.getAnnotationElements();
        for (JCTree object22 : jCAnnotation.args) {
            if (!object22.hasTag(JCTree.Tag.ASSIGN)) continue;
            object = (JCTree.JCAssign)object22;
            Symbol symbol = TreeInfo.symbol(((JCTree.JCAssign)object).lhs);
            if (symbol == null || symbol.type.isErroneous() || set.remove(symbol)) continue;
            bl = false;
            this.log.error(((JCTree.JCAssign)object).lhs.pos(), CompilerProperties.Errors.DuplicateAnnotationMemberValue(symbol.name, jCAnnotation.type));
        }
        List<Name> list = List.nil();
        Set<Symbol.MethodSymbol> set2 = annotationTypeMetadata.getAnnotationElementsWithDefault();
        for (Symbol.MethodSymbol methodSymbol : set) {
            if (methodSymbol.type.isErroneous() || set2.contains(methodSymbol)) continue;
            list = list.append(methodSymbol.name);
        }
        if ((list = list.reverse()).nonEmpty()) {
            bl = false;
            object = list.size() > 1 ? CompilerProperties.Errors.AnnotationMissingDefaultValue1(jCAnnotation.type, list) : CompilerProperties.Errors.AnnotationMissingDefaultValue(jCAnnotation.type, list);
            this.log.error(jCAnnotation.pos(), (JCDiagnostic.Error)object);
        }
        return bl && this.validateTargetAnnotationValue(jCAnnotation);
    }

    boolean validateTargetAnnotationValue(JCTree.JCAnnotation jCAnnotation) {
        if (jCAnnotation.annotationType.type.tsym != this.syms.annotationTargetType.tsym || jCAnnotation.args.tail == null) {
            return true;
        }
        boolean bl = true;
        if (!((JCTree.JCExpression)jCAnnotation.args.head).hasTag(JCTree.Tag.ASSIGN)) {
            return false;
        }
        JCTree.JCAssign jCAssign = (JCTree.JCAssign)jCAnnotation.args.head;
        Symbol symbol = TreeInfo.symbol(jCAssign.lhs);
        if (symbol.name != this.names.value) {
            return false;
        }
        JCTree.JCExpression jCExpression = jCAssign.rhs;
        if (!jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
            return false;
        }
        JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        for (JCTree jCTree : jCNewArray.elems) {
            if (hashSet.add(TreeInfo.symbol(jCTree))) continue;
            bl = false;
            this.log.error(jCTree.pos(), CompilerProperties.Errors.RepeatedAnnotationTarget);
        }
        return bl;
    }

    void checkDeprecatedAnnotation(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && symbol.isDeprecatableViaAnnotation() && (symbol.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && symbol.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.MissingDeprecatedAnnotation);
        }
        if (this.lint.isEnabled(Lint.LintCategory.DEPRECATION) && !symbol.isDeprecatableViaAnnotation() && !this.syms.deprecatedType.isErroneous() && symbol.attribute(this.syms.deprecatedType.tsym) != null) {
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.DeprecatedAnnotationHasNoEffect(Kinds.kindName(symbol)));
        }
    }

    void checkDeprecated(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        this.checkDeprecated(() -> diagnosticPosition, symbol, symbol2);
    }

    void checkDeprecated(Supplier<JCDiagnostic.DiagnosticPosition> supplier, Symbol symbol, Symbol symbol2) {
        if (!this.importSuppression && (symbol2.isDeprecatedForRemoval() || symbol2.isDeprecated() && !symbol.isDeprecated()) && (symbol2.outermostClass() != symbol.outermostClass() || symbol2.outermostClass() == null) && symbol2.kind != Kinds.Kind.PCK) {
            this.deferredLintHandler.report(lint -> this.warnDeprecated((JCDiagnostic.DiagnosticPosition)supplier.get(), symbol2));
        }
    }

    void checkSunAPI(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if ((symbol.flags() & 0x4000000000L) != 0L) {
            this.deferredLintHandler.report(lint -> this.log.mandatoryWarning(diagnosticPosition, CompilerProperties.Warnings.SunProprietary(symbol)));
        }
    }

    void checkProfile(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (this.profile != Profile.DEFAULT && (symbol.flags() & 0x200000000000L) != 0L) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.NotInProfile(symbol, (Object)this.profile));
        }
    }

    void checkPreview(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        this.checkPreview(diagnosticPosition, symbol, Type.noType, symbol2);
    }

    void checkPreview(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type, Symbol symbol2) {
        Symbol symbol3;
        boolean bl;
        if ((symbol2.flags() & 0x100000000000000L) != 0L) {
            bl = true;
            symbol3 = symbol2;
        } else if ((symbol2.kind == Kinds.Kind.MTH || symbol2.kind == Kinds.Kind.VAR) && type.tsym != null && (type.tsym.flags() & 0x100000000000000L) == 0L && (symbol2.owner.flags() & 0x100000000000000L) != 0L) {
            bl = true;
            symbol3 = symbol2.owner;
        } else {
            bl = false;
            symbol3 = null;
        }
        if (bl && !this.preview.participatesInPreview(this.syms, symbol, symbol2) && !this.disablePreviewCheck) {
            if ((symbol3.flags() & 0x400000000000000L) == 0L) {
                if (!this.preview.isEnabled()) {
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.IsPreview(symbol2));
                } else {
                    this.preview.markUsesPreview(diagnosticPosition);
                    this.warnPreviewAPI(diagnosticPosition, CompilerProperties.LintWarnings.IsPreview(symbol2));
                }
            } else {
                this.warnPreviewAPI(diagnosticPosition, CompilerProperties.LintWarnings.IsPreviewReflective(symbol2));
            }
        }
        if (this.preview.declaredUsingPreviewFeature(symbol2) && this.preview.isEnabled()) {
            this.preview.markUsesPreview(diagnosticPosition);
            this.warnPreviewAPI(diagnosticPosition, CompilerProperties.LintWarnings.DeclaredUsingPreview(Kinds.kindName(symbol2), symbol2));
        }
    }

    void checkRestricted(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        if (symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x4000000000000000L) != 0L) {
            this.deferredLintHandler.report(lint -> this.warnRestrictedAPI(diagnosticPosition, symbol));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(JCTree.JCClassDecl jCClassDecl) {
        if ((jCClassDecl.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        Assert.check((jCClassDecl.sym.flags_field & 0x8000000L) == 0L);
        try {
            jCClassDecl.sym.flags_field |= 0x8000000L;
            for (JCTree jCTree : jCClassDecl.defs) {
                if (!jCTree.hasTag(JCTree.Tag.METHODDEF)) continue;
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                this.checkAnnotationResType(jCMethodDecl.pos(), jCMethodDecl.restype.type);
            }
        }
        finally {
            jCClassDecl.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            jCClassDecl.sym.flags_field |= 0x800000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if ((typeSymbol.flags_field & 0x800000000L) != 0L) {
            return;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.CyclicAnnotationElement(typeSymbol));
            return;
        }
        try {
            typeSymbol.flags_field |= 0x8000000L;
            for (Symbol symbol : typeSymbol.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (symbol.kind != Kinds.Kind.MTH) continue;
                this.checkAnnotationResType(diagnosticPosition, ((Symbol.MethodSymbol)symbol).type.getReturnType());
            }
        }
        finally {
            typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            typeSymbol.flags_field |= 0x800000000L;
        }
    }

    void checkAnnotationResType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.getTag()) {
            case CLASS: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(diagnosticPosition, type.tsym);
                break;
            }
            case ARRAY: {
                this.checkAnnotationResType(diagnosticPosition, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(JCTree.JCClassDecl jCClassDecl) {
        LinkedHashMap<Symbol, Symbol> linkedHashMap = new LinkedHashMap<Symbol, Symbol>();
        Object object = jCClassDecl.defs;
        while (object.nonEmpty()) {
            if (TreeInfo.isConstructor((JCTree)object.head)) {
                JCTree.JCMethodDecl object2 = (JCTree.JCMethodDecl)object.head;
                JCTree.JCMethodInvocation jCMethodInvocation = TreeInfo.findConstructorCall(object2);
                if (jCMethodInvocation != null && TreeInfo.name(jCMethodInvocation.meth) == this.names._this) {
                    linkedHashMap.put(object2.sym, TreeInfo.symbol(jCMethodInvocation.meth));
                } else {
                    object2.sym.flags_field |= 0x40000000L;
                }
            }
            object = object.tail;
        }
        object = new Symbol[]{};
        for (Symbol symbol : object = linkedHashMap.keySet().toArray((T[])object)) {
            this.checkCyclicConstructor(jCClassDecl, symbol, linkedHashMap);
        }
    }

    private void checkCyclicConstructor(JCTree.JCClassDecl jCClassDecl, Symbol symbol, Map<Symbol, Symbol> map) {
        if (symbol != null && (symbol.flags_field & 0x40000000L) == 0L) {
            if ((symbol.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(symbol, jCClassDecl, false, jCTree -> jCTree.hasTag(JCTree.Tag.IDENT)), CompilerProperties.Errors.RecursiveCtorInvocation);
            } else {
                symbol.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(jCClassDecl, map.remove(symbol), map);
                symbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            symbol.flags_field |= 0x40000000L;
        }
    }

    void checkSuperInitCalls(JCTree.JCClassDecl jCClassDecl) {
        new SuperThisChecker().check(jCClassDecl);
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Type type) {
        int n;
        if (type.constValue() != null && type.getTag().isSubRangeOf(TypeTag.LONG) && ((Number)type.constValue()).longValue() == 0L && ((n = ((Symbol.OperatorSymbol)symbol).opcode) == 108 || n == 112 || n == 109 || n == 113)) {
            this.deferredLintHandler.report(lint -> this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.DivZero));
        }
    }

    void checkLossOfPrecision(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        if (type.isNumeric() && type2.isNumeric() && !this.types.isAssignable(type, type2)) {
            this.deferredLintHandler.report(lint -> this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.PossibleLossOfPrecision(type, type2)));
        }
    }

    void checkEmptyIf(JCTree.JCIf jCIf) {
        if (jCIf.thenpart.hasTag(JCTree.Tag.SKIP) && jCIf.elsepart == null) {
            this.lint.logIfEnabled(jCIf.thenpart.pos(), CompilerProperties.LintWarnings.EmptyIf);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Scope scope) {
        if (symbol.type.isErroneous()) {
            return true;
        }
        if (symbol.owner.name == this.names.any) {
            return false;
        }
        for (Symbol symbol2 : scope.getSymbolsByName(symbol.name, Scope.LookupKind.NON_RECURSIVE)) {
            if (symbol == symbol2 || (symbol2.flags() & 0x40000000000L) != 0L || symbol.kind != symbol2.kind || symbol.name == this.names.error || symbol.kind == Kinds.Kind.MTH && !this.types.hasSameArgs(symbol.type, symbol2.type) && !this.types.hasSameArgs(this.types.erasure(symbol.type), this.types.erasure(symbol2.type))) continue;
            if ((symbol.flags() & 0x400000000L) != (symbol2.flags() & 0x400000000L)) {
                symbol.flags_field |= 0x40000000000L;
                this.varargsDuplicateError(diagnosticPosition, symbol, symbol2);
                return true;
            }
            if (symbol.kind == Kinds.Kind.MTH && !this.types.hasSameArgs(symbol.type, symbol2.type, false)) {
                this.duplicateErasureError(diagnosticPosition, symbol, symbol2);
                symbol.flags_field |= 0x40000000000L;
                return true;
            }
            if ((symbol.flags() & 0x800000000000000L) != 0L && (symbol2.flags() & 0x800000000000000L) != 0L && (symbol2.flags() & 0x1000000000000000L) == 0L) {
                if (!symbol.type.isErroneous()) {
                    this.log.error(diagnosticPosition, CompilerProperties.Errors.MatchBindingExists);
                    symbol.flags_field |= 0x40000000000L;
                }
                return false;
            }
            this.duplicateError(diagnosticPosition, symbol2);
            return false;
        }
        return true;
    }

    void duplicateErasureError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol symbol2) {
        if (!symbol.type.isErroneous() && !symbol2.type.isErroneous()) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.NameClashSameErasure(symbol, symbol2));
        }
    }

    void checkImportsUnique(JCTree.JCCompilationUnit jCCompilationUnit) {
        Scope.WriteableScope writeableScope = Scope.WriteableScope.create(jCCompilationUnit.packge);
        Scope.WriteableScope writeableScope2 = Scope.WriteableScope.create(jCCompilationUnit.packge);
        Scope.WriteableScope writeableScope3 = jCCompilationUnit.toplevelScope;
        for (JCTree jCTree : jCCompilationUnit.defs) {
            if (!jCTree.hasTag(JCTree.Tag.IMPORT)) continue;
            JCTree.JCImport jCImport = (JCTree.JCImport)jCTree;
            if (jCImport.importScope == null) continue;
            for (Symbol symbol2 : jCImport.importScope.getSymbols(symbol -> symbol.kind == Kinds.Kind.TYP)) {
                if (jCImport.isStatic()) {
                    this.checkUniqueImport(jCImport.pos(), writeableScope, writeableScope2, writeableScope3, symbol2, true);
                    writeableScope2.enter(symbol2);
                    continue;
                }
                this.checkUniqueImport(jCImport.pos(), writeableScope, writeableScope2, writeableScope3, symbol2, false);
                writeableScope.enter(symbol2);
            }
            jCImport.importScope = null;
        }
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition diagnosticPosition, Scope scope, Scope scope2, Scope scope3, Symbol symbol, boolean bl) {
        Predicate<Symbol> predicate = symbol2 -> symbol2 != symbol && !symbol2.type.isErroneous();
        Symbol symbol3 = scope.findFirst(symbol.name, predicate);
        Symbol symbol4 = null;
        if (symbol3 == null && !bl) {
            symbol4 = scope2.findFirst(symbol.name, predicate);
        }
        if (symbol3 != null || symbol4 != null) {
            if (symbol3 != null) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.AlreadyDefinedSingleImport(symbol3));
            } else {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.AlreadyDefinedStaticSingleImport(symbol4));
            }
            return false;
        }
        Symbol symbol5 = scope3.findFirst(symbol.name, predicate);
        if (symbol5 != null) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.AlreadyDefinedThisUnit(symbol5));
            return false;
        }
        return true;
    }

    public void checkCanonical(JCTree jCTree) {
        if (!this.isCanonical(jCTree)) {
            this.log.error(jCTree.pos(), CompilerProperties.Errors.ImportRequiresCanonical(TreeInfo.symbol(jCTree)));
        }
    }

    private boolean isCanonical(JCTree jCTree) {
        while (jCTree.hasTag(JCTree.Tag.SELECT)) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCTree;
            if (jCFieldAccess.sym.owner.getQualifiedName() != TreeInfo.symbol(jCFieldAccess.selected).getQualifiedName()) {
                return false;
            }
            jCTree = jCFieldAccess.selected;
        }
        return true;
    }

    void checkForBadAuxiliaryClassAccess(JCDiagnostic.DiagnosticPosition diagnosticPosition, Env<AttrContext> env, Symbol.ClassSymbol classSymbol) {
        if ((classSymbol.flags() & 0x100000000000L) != 0L && this.rs.isAccessible(env, classSymbol) && !this.fileManager.isSameFile(classSymbol.sourcefile, env.toplevel.sourcefile)) {
            this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.AuxiliaryClassAccessedFromOutsideOfItsSourceFile((Symbol)classSymbol, classSymbol.sourcefile));
        }
    }

    void checkDefaultConstructor(Symbol.ClassSymbol classSymbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (this.lint.isEnabled(Lint.LintCategory.MISSING_EXPLICIT_CTOR) && (classSymbol.flags() & 0x2000000000004000L) == 0L && !classSymbol.isAnonymous() && (classSymbol.flags() & 5L) != 0L && Source.Feature.MODULES.allowedInSource(this.source)) {
            Symbol symbol;
            NestingKind nestingKind = classSymbol.getNestingKind();
            switch (nestingKind) {
                case ANONYMOUS: 
                case LOCAL: {
                    return;
                }
                case TOP_LEVEL: {
                    break;
                }
                case MEMBER: {
                    symbol = classSymbol.owner;
                    while (symbol != null && symbol.kind == Kinds.Kind.TYP) {
                        if ((symbol.flags() & 5L) == 0L) {
                            return;
                        }
                        symbol = symbol.owner;
                    }
                    break;
                }
            }
            symbol = classSymbol.packge();
            if (!((Symbol.PackageSymbol)symbol).isUnnamed()) {
                Symbol.ModuleSymbol moduleSymbol = ((Symbol.PackageSymbol)symbol).modle;
                for (Directive.ExportsDirective exportsDirective : moduleSymbol.exports) {
                    if (!exportsDirective.packge.equals(symbol)) continue;
                    if (exportsDirective.modules == null || exportsDirective.modules.isEmpty()) {
                        this.deferredLintHandler.report(arg_0 -> this.lambda$checkDefaultConstructor$35(diagnosticPosition, classSymbol, (Symbol.PackageSymbol)symbol, moduleSymbol, arg_0));
                        continue;
                    }
                    return;
                }
            }
        }
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return new ConversionWarner(diagnosticPosition, "unchecked.cast.to.type", type, type2);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
        return new ConversionWarner(diagnosticPosition, "unchecked.assign", type, type2);
    }

    public void checkFunctionalInterface(JCTree.JCClassDecl jCClassDecl, Symbol.ClassSymbol classSymbol) {
        Attribute.Compound compound = classSymbol.attribute(this.syms.functionalInterfaceType.tsym);
        if (compound != null) {
            try {
                this.types.findDescriptorSymbol(classSymbol);
            }
            catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                JCDiagnostic.DiagnosticPosition diagnosticPosition = jCClassDecl.pos();
                for (JCTree.JCAnnotation jCAnnotation : jCClassDecl.getModifiers().annotations) {
                    if (jCAnnotation.annotationType.type.tsym != this.syms.functionalInterfaceType.tsym) continue;
                    diagnosticPosition = jCAnnotation.pos();
                    break;
                }
                this.log.error(diagnosticPosition, CompilerProperties.Errors.BadFunctionalIntfAnno1(functionDescriptorLookupError.getDiagnostic()));
            }
        }
    }

    public void checkImportsResolvable(JCTree.JCCompilationUnit jCCompilationUnit) {
        for (JCTree.JCImportBase jCImportBase : jCCompilationUnit.getImports()) {
            Symbol.TypeSymbol typeSymbol;
            Symbol symbol;
            if (!(jCImportBase instanceof JCTree.JCImport)) continue;
            JCTree.JCImport jCImport = (JCTree.JCImport)jCImportBase;
            if (!jCImport.staticImport || !jCImport.qualid.hasTag(JCTree.Tag.SELECT)) continue;
            JCTree.JCFieldAccess jCFieldAccess = jCImport.qualid;
            if (jCFieldAccess.name == this.names.asterisk || (symbol = TreeInfo.symbol(jCFieldAccess.selected)) == null || symbol.kind != Kinds.Kind.TYP || this.checkTypeContainsImportableElement(typeSymbol = (Symbol.TypeSymbol)TreeInfo.symbol(jCFieldAccess.selected), typeSymbol, jCCompilationUnit.packge, jCFieldAccess.name, new HashSet<Symbol>())) continue;
            this.log.error(jCImport.pos(), CompilerProperties.Errors.CantResolveLocation(Kinds.KindName.STATIC, jCFieldAccess.name, null, null, CompilerProperties.Fragments.Location(Kinds.kindName(typeSymbol), typeSymbol, null)));
        }
    }

    public void checkImportedPackagesObservable(JCTree.JCCompilationUnit jCCompilationUnit) {
        for (JCTree.JCImportBase jCImportBase : jCCompilationUnit.getImports()) {
            if (!(jCImportBase instanceof JCTree.JCImport)) continue;
            JCTree.JCImport jCImport = (JCTree.JCImport)jCImportBase;
            if (jCImport.staticImport || TreeInfo.name(jCImport.qualid) != this.names.asterisk) continue;
            Symbol.TypeSymbol typeSymbol = jCImport.qualid.selected.type.tsym;
            if (typeSymbol.kind != Kinds.Kind.PCK || !typeSymbol.members().isEmpty() || Source.Feature.IMPORT_ON_DEMAND_OBSERVABLE_PACKAGES.allowedInSource(this.source) && typeSymbol.exists()) continue;
            this.log.error(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR, jCImport.qualid.selected.pos(), CompilerProperties.Errors.DoesntExist(typeSymbol));
        }
    }

    private boolean checkTypeContainsImportableElement(Symbol.TypeSymbol typeSymbol, Symbol.TypeSymbol typeSymbol2, Symbol.PackageSymbol packageSymbol, Name name, Set<Symbol> set) {
        if (typeSymbol == null || !set.add(typeSymbol)) {
            return false;
        }
        if (this.checkTypeContainsImportableElement(this.types.supertype((Type)typeSymbol.type).tsym, typeSymbol2, packageSymbol, name, set)) {
            return true;
        }
        for (Type annoConstruct : this.types.interfaces(typeSymbol.type)) {
            if (!this.checkTypeContainsImportableElement(annoConstruct.tsym, typeSymbol2, packageSymbol, name, set)) continue;
            return true;
        }
        for (Symbol symbol : typeSymbol.members().getSymbolsByName(name)) {
            if (!symbol.isStatic() || !this.importAccessible(symbol, packageSymbol) || !symbol.isMemberOf(typeSymbol2, this.types)) continue;
            return true;
        }
        return false;
    }

    public boolean importAccessible(Symbol symbol, Symbol.PackageSymbol packageSymbol) {
        try {
            int n = (int)(symbol.flags() & 7L);
            switch (n) {
                default: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 0: 
                case 4: 
            }
            return symbol.packge() == packageSymbol;
        }
        catch (ClassFinder.BadClassFile badClassFile) {
            throw badClassFile;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return false;
        }
    }

    public void checkLeaksNotAccessible(final Env<AttrContext> env, final JCTree.JCClassDecl jCClassDecl) {
        final JCTree.JCCompilationUnit jCCompilationUnit = env.toplevel;
        if (jCCompilationUnit.modle == this.syms.unnamedModule || jCCompilationUnit.modle == this.syms.noModule || (jCClassDecl.sym.flags() & 0x1000000L) != 0L) {
            return;
        }
        Directive.ExportsDirective exportsDirective = this.findExport(jCCompilationUnit.packge);
        if (exportsDirective == null || exportsDirective.modules != null) {
            return;
        }
        new TreeScanner(){
            Lint lint;
            boolean inSuperType;
            {
                this.lint = ((AttrContext)env.info).lint;
            }

            @Override
            public void visitBlock(JCTree.JCBlock jCBlock) {
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
                if (!Check.this.isAPISymbol(jCMethodDecl.sym)) {
                    return;
                }
                Lint lint = this.lint;
                try {
                    this.lint = this.lint.augment(jCMethodDecl.sym);
                    if (this.lint.isEnabled(Lint.LintCategory.EXPORTS)) {
                        super.visitMethodDef(jCMethodDecl);
                    }
                }
                finally {
                    this.lint = lint;
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
                if (!Check.this.isAPISymbol(jCVariableDecl.sym) && jCVariableDecl.sym.owner.kind != Kinds.Kind.MTH) {
                    return;
                }
                Lint lint = this.lint;
                try {
                    this.lint = this.lint.augment(jCVariableDecl.sym);
                    if (this.lint.isEnabled(Lint.LintCategory.EXPORTS)) {
                        this.scan(jCVariableDecl.mods);
                        this.scan(jCVariableDecl.vartype);
                    }
                }
                finally {
                    this.lint = lint;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl2) {
                block8: {
                    if (jCClassDecl2 != jCClassDecl) {
                        return;
                    }
                    if (!Check.this.isAPISymbol(jCClassDecl2.sym)) {
                        return;
                    }
                    Lint lint = this.lint;
                    try {
                        this.lint = this.lint.augment(jCClassDecl2.sym);
                        if (!this.lint.isEnabled(Lint.LintCategory.EXPORTS)) break block8;
                        this.scan(jCClassDecl2.mods);
                        this.scan(jCClassDecl2.typarams);
                        try {
                            this.inSuperType = true;
                            this.scan(jCClassDecl2.extending);
                            this.scan(jCClassDecl2.implementing);
                        }
                        finally {
                            this.inSuperType = false;
                        }
                        this.scan(jCClassDecl2.defs);
                    }
                    finally {
                        this.lint = lint;
                    }
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
                this.scan(jCTypeApply.clazz);
                boolean bl = this.inSuperType;
                try {
                    this.inSuperType = false;
                    this.scan(jCTypeApply.arguments);
                }
                finally {
                    this.inSuperType = bl;
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                Symbol symbol = TreeInfo.symbol(jCIdent);
                if (symbol.kind == Kinds.Kind.TYP && !symbol.type.hasTag(TypeTag.TYPEVAR)) {
                    Check.this.checkVisible(jCIdent.pos(), symbol, jCCompilationUnit.packge, this.inSuperType);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                Symbol symbol = TreeInfo.symbol(jCFieldAccess);
                Symbol symbol2 = TreeInfo.symbol(jCFieldAccess.selected);
                if (symbol.kind == Kinds.Kind.TYP && symbol2.kind == Kinds.Kind.PCK) {
                    Check.this.checkVisible(jCFieldAccess.pos(), symbol, jCCompilationUnit.packge, this.inSuperType);
                } else {
                    super.visitSelect(jCFieldAccess);
                }
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
                if (jCAnnotation.attribute.type.tsym.getAnnotation(Documented.class) != null) {
                    super.visitAnnotation(jCAnnotation);
                }
            }
        }.scan(jCClassDecl);
    }

    private Directive.ExportsDirective findExport(Symbol.PackageSymbol packageSymbol) {
        for (Directive.ExportsDirective exportsDirective : packageSymbol.modle.exports) {
            if (exportsDirective.packge != packageSymbol) continue;
            return exportsDirective;
        }
        return null;
    }

    private boolean isAPISymbol(Symbol symbol) {
        while (symbol.kind != Kinds.Kind.PCK) {
            if ((symbol.flags() & 1L) == 0L && (symbol.flags() & 4L) == 0L) {
                return false;
            }
            symbol = symbol.owner;
        }
        return true;
    }

    private void checkVisible(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Symbol.PackageSymbol packageSymbol, boolean bl) {
        if (!this.isAPISymbol(symbol) && !bl) {
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.LeaksNotAccessible(Kinds.kindName(symbol), symbol, symbol.packge().modle));
            return;
        }
        Symbol.PackageSymbol packageSymbol2 = symbol.packge();
        Directive.ExportsDirective exportsDirective = this.findExport(packageSymbol2);
        Directive.ExportsDirective exportsDirective2 = this.findExport(packageSymbol);
        if (exportsDirective == null) {
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.LeaksNotAccessibleUnexported(Kinds.kindName(symbol), symbol, symbol.packge().modle));
            return;
        }
        if (!(exportsDirective.modules == null || exportsDirective2.modules != null && exportsDirective.modules.containsAll(exportsDirective2.modules))) {
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.LeaksNotAccessibleUnexportedQualified(Kinds.kindName(symbol), symbol, symbol.packge().modle));
        }
        if (packageSymbol2.modle != packageSymbol.modle && packageSymbol2.modle != this.syms.java_base) {
            List<Symbol.ModuleSymbol> list = List.of(packageSymbol.modle);
            while (list.nonEmpty()) {
                Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)list.head;
                list = list.tail;
                if (moduleSymbol == packageSymbol2.modle) {
                    return;
                }
                if ((moduleSymbol.flags() & 0x10000000000000L) != 0L) continue;
                for (Directive.RequiresDirective requiresDirective : moduleSymbol.requires) {
                    if (!requiresDirective.isTransitive()) continue;
                    list = list.prepend(requiresDirective.module);
                }
            }
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.LeaksNotAccessibleNotRequiredTransitive(Kinds.kindName(symbol), symbol, symbol.packge().modle));
        }
    }

    void checkModuleExists(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ModuleSymbol moduleSymbol) {
        if (moduleSymbol.kind != Kinds.Kind.MDL) {
            this.deferredLintHandler.report(lint -> this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.ModuleNotFound(moduleSymbol)));
        }
    }

    void checkPackageExistsForOpens(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.PackageSymbol packageSymbol) {
        if (packageSymbol.members().isEmpty() && (packageSymbol.flags() & 0x10000000000000L) == 0L) {
            this.deferredLintHandler.report(lint -> this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.PackageEmptyOrNotFound(packageSymbol)));
        }
    }

    void checkModuleRequires(JCDiagnostic.DiagnosticPosition diagnosticPosition, Directive.RequiresDirective requiresDirective) {
        if ((requiresDirective.module.flags() & 0x10000000000000L) != 0L) {
            this.deferredLintHandler.report(lint -> {
                if (requiresDirective.isTransitive() && this.lint.isEnabled(Lint.LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC)) {
                    this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)CompilerProperties.LintWarnings.RequiresTransitiveAutomatic);
                } else {
                    this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.RequiresAutomatic);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void checkSwitchCaseStructure(List<JCTree.JCCase> var1_1) {
        block20: {
            var2_2 /* !! */  = var1_1;
            while (var2_2 /* !! */ .nonEmpty()) {
                var3_4 = (JCTree.JCCase)var2_2 /* !! */ .head;
                var5_7 /* !! */  = var3_4.labels.head;
                if (var5_7 /* !! */  instanceof JCTree.JCConstantCaseLabel) {
                    var4_6 = (JCTree.JCConstantCaseLabel)var5_7 /* !! */ ;
                    if (TreeInfo.isNull(var4_6.expr)) {
                        if (var3_4.labels.tail.nonEmpty()) {
                            var6_8 = var3_4.labels.tail.head;
                            if (var6_8 instanceof JCTree.JCDefaultCaseLabel) {
                                var5_7 /* !! */  = (JCTree.JCDefaultCaseLabel)var6_8;
                                if (var3_4.labels.tail.tail.nonEmpty()) {
                                    this.log.error(((JCTree.JCCaseLabel)var3_4.labels.tail.tail.head).pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                                }
                            } else {
                                this.log.error(((JCTree.JCCaseLabel)var3_4.labels.tail.head).pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                            }
                        }
                    } else {
                        for (JCTree.JCCaseLabel var6_9 : var3_4.labels.tail) {
                            if (var6_9 instanceof JCTree.JCConstantCaseLabel && !TreeInfo.isNullCaseLabel(var6_9)) continue;
                            this.log.error(var6_9.pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                            break;
                        }
                    }
                } else if (var3_4.labels.tail.nonEmpty()) {
                    var5_7 /* !! */  = var3_4.labels.stream().filter((Predicate<JCTree.JCCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkSwitchCaseStructure$39(com.sun.tools.javac.tree.JCTree$JCCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCCaseLabel;)Z)()).map((Function<JCTree.JCCaseLabel, JCTree.JCPatternCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkSwitchCaseStructure$40(com.sun.tools.javac.tree.JCTree$JCCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCCaseLabel;)Lcom/sun/tools/javac/tree/JCTree$JCPatternCaseLabel;)());
                    var6_10 = var5_7 /* !! */ .allMatch((Predicate<JCTree.JCPatternCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkSwitchCaseStructure$41(com.sun.tools.javac.tree.JCTree$JCPatternCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCPatternCaseLabel;)Z)((Check)this));
                    if (!var6_10) {
                        this.log.error(((JCTree.JCCaseLabel)var3_4.labels.tail.head).pos(), CompilerProperties.Errors.FlowsThroughFromPattern);
                    }
                    if (var7_12 = var3_4.labels.stream().allMatch((Predicate<JCTree.JCCaseLabel>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkSwitchCaseStructure$42(com.sun.tools.javac.tree.JCTree$JCCaseLabel ), (Lcom/sun/tools/javac/tree/JCTree$JCCaseLabel;)Z)())) {
                        this.preview.checkSourceLevel(((JCTree.JCCaseLabel)var3_4.labels.tail.head).pos(), Source.Feature.UNNAMED_VARIABLES);
                    }
                    var8_14 = var3_4.labels.tail.iterator();
                    while (var8_14.hasNext()) {
                        var9_15 = (JCTree.JCCaseLabel)var8_14.next();
                        if (!(var9_15 instanceof JCTree.JCConstantCaseLabel)) continue;
                        this.log.error(var9_15.pos(), CompilerProperties.Errors.InvalidCaseLabelCombination);
                        break;
                    }
                }
                var2_2 /* !! */  = var2_2 /* !! */ .tail;
            }
            v0 = var2_3 = var1_1.nonEmpty() != false && ((JCTree.JCCase)var1_1.head).caseKind == CaseTree.CaseKind.STATEMENT;
            if (!var2_3) break block20;
            var3_5 = false;
            var4_6 = var1_1;
            while (var4_6.nonEmpty()) {
                var5_7 /* !! */  = (JCTree.JCCase)var4_6.head;
                if (!var3_5 || !var5_7 /* !! */ .stats.nonEmpty() || !((var8_14 = var5_7 /* !! */ .labels.head) instanceof JCTree.JCPatternCaseLabel)) ** GOTO lbl-1000
                var6_11 = (JCTree.JCPatternCaseLabel)var8_14;
                if (this.hasBindings(var6_11.pat) || this.hasBindings(var5_7 /* !! */ .guard)) {
                    this.log.error(((JCTree.JCCaseLabel)var5_7 /* !! */ .labels.head).pos(), CompilerProperties.Errors.FlowsThroughToPattern);
                } else if (var5_7 /* !! */ .stats.isEmpty() && (var8_14 = var5_7 /* !! */ .labels.head) instanceof JCTree.JCPatternCaseLabel) {
                    var7_13 = (JCTree.JCPatternCaseLabel)var8_14;
                    if ((this.hasBindings(var7_13.pat) || this.hasBindings(var5_7 /* !! */ .guard)) && this.hasStatements(var4_6.tail)) {
                        this.log.error(((JCTree.JCCaseLabel)var5_7 /* !! */ .labels.head).pos(), CompilerProperties.Errors.FlowsThroughFromPattern);
                    }
                }
                var3_5 = var5_7 /* !! */ .completesNormally;
                var4_6 = var4_6.tail;
            }
        }
    }

    boolean hasBindings(JCTree jCTree) {
        final boolean[] blArray = new boolean[1];
        new TreeScanner(){

            @Override
            public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
                blArray[0] = blArray[0] | !jCBindingPattern.var.sym.isUnnamedVariable();
                super.visitBindingPattern(jCBindingPattern);
            }
        }.scan(jCTree);
        return blArray[0];
    }

    boolean hasStatements(List<JCTree.JCCase> list) {
        List<JCTree.JCCase> list2 = list;
        while (list2.nonEmpty()) {
            if (((JCTree.JCCase)list2.head).stats.nonEmpty()) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    void checkSwitchCaseLabelDominated(JCTree.JCCaseLabel jCCaseLabel, List<JCTree.JCCase> list) {
        List<Pair<JCTree.JCCase, JCTree.JCCaseLabel>> list2 = List.nil();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        List<JCTree.JCCase> list3 = list;
        while (list3.nonEmpty()) {
            JCTree.JCCase jCCase = (JCTree.JCCase)list3.head;
            for (JCTree.JCCaseLabel jCCaseLabel2 : jCCase.labels) {
                if (jCCaseLabel2.hasTag(JCTree.Tag.DEFAULTCASELABEL)) {
                    bl = true;
                    bl2 |= TreeInfo.isNullCaseLabel((JCTree.JCCaseLabel)jCCase.labels.head);
                    continue;
                }
                if (TreeInfo.isNullCaseLabel(jCCaseLabel2)) {
                    if (!bl) continue;
                    this.log.error(jCCaseLabel2.pos(), CompilerProperties.Errors.PatternDominated);
                    continue;
                }
                if (bl && !bl3 && (jCCaseLabel2.hasTag(JCTree.Tag.PATTERNCASELABEL) || jCCaseLabel2 instanceof JCTree.JCConstantCaseLabel && bl2)) {
                    this.log.error(jCCaseLabel2.pos(), CompilerProperties.Errors.PatternDominated);
                    bl3 = true;
                }
                Type type = this.labelType(jCCaseLabel2);
                for (Pair pair : list2) {
                    JCTree.JCCase jCCase2 = (JCTree.JCCase)pair.fst;
                    JCTree.JCCaseLabel jCCaseLabel3 = (JCTree.JCCaseLabel)pair.snd;
                    Type type2 = this.labelType(jCCaseLabel3);
                    boolean bl5 = false;
                    if (this.types.isUnconditionallyExact(type, type2) && !type.hasTag(TypeTag.ERROR) && !type2.hasTag(TypeTag.ERROR)) {
                        if (jCCaseLabel2 instanceof JCTree.JCConstantCaseLabel) {
                            bl5 |= !(jCCaseLabel3 instanceof JCTree.JCConstantCaseLabel) && TreeInfo.unguardedCase(jCCase2);
                        } else if (jCCaseLabel2 instanceof JCTree.JCPatternCaseLabel) {
                            JCTree.JCPatternCaseLabel jCPatternCaseLabel = (JCTree.JCPatternCaseLabel)jCCaseLabel2;
                            if (jCCaseLabel3 instanceof JCTree.JCPatternCaseLabel) {
                                JCTree.JCPatternCaseLabel jCPatternCaseLabel2 = (JCTree.JCPatternCaseLabel)jCCaseLabel3;
                                if (jCCase2.equals(jCCase) || TreeInfo.unguardedCase(jCCase2)) {
                                    bl5 = this.patternDominated(jCPatternCaseLabel2.pat, jCPatternCaseLabel.pat);
                                }
                            }
                        }
                    }
                    if (!bl5) continue;
                    this.log.error(jCCaseLabel2.pos(), CompilerProperties.Errors.PatternDominated);
                }
                list2 = list2.prepend(Pair.of(jCCase, jCCaseLabel2));
            }
            list3 = list3.tail;
        }
    }

    private Type labelType(JCTree.JCCaseLabel jCCaseLabel) {
        Type type;
        switch (jCCaseLabel.getTag()) {
            case PATTERNCASELABEL: {
                type = ((JCTree.JCPatternCaseLabel)jCCaseLabel).pat.type;
                break;
            }
            case CONSTANTCASELABEL: {
                type = ((JCTree.JCConstantCaseLabel)jCCaseLabel).expr.type;
                break;
            }
            default: {
                throw Assert.error("Unexpected tree kind: " + (Object)((Object)jCCaseLabel.getTag()));
            }
        }
        return this.types.erasure(type);
    }

    private boolean patternDominated(JCTree.JCPattern jCPattern, JCTree.JCPattern jCPattern2) {
        Type type = this.types.erasure(jCPattern.type);
        Type type2 = this.types.erasure(jCPattern2.type);
        if (!this.types.isUnconditionallyExact(type2, type)) {
            return false;
        }
        if (jCPattern2 instanceof JCTree.JCBindingPattern || jCPattern2 instanceof JCTree.JCAnyPattern) {
            return jCPattern instanceof JCTree.JCBindingPattern || jCPattern instanceof JCTree.JCAnyPattern;
        }
        if (jCPattern2 instanceof JCTree.JCRecordPattern) {
            JCTree.JCRecordPattern jCRecordPattern = (JCTree.JCRecordPattern)jCPattern2;
            if (jCPattern instanceof JCTree.JCBindingPattern || jCPattern instanceof JCTree.JCAnyPattern) {
                return true;
            }
            if (jCPattern instanceof JCTree.JCRecordPattern) {
                JCTree.JCRecordPattern jCRecordPattern2 = (JCTree.JCRecordPattern)jCPattern;
                List<JCTree.JCPattern> list = jCRecordPattern2.nested;
                List<JCTree.JCPattern> list2 = jCRecordPattern.nested;
                if (list.size() != list2.size()) {
                    return false;
                }
                while (list.nonEmpty()) {
                    if (!this.patternDominated((JCTree.JCPattern)list.head, (JCTree.JCPattern)list2.head)) {
                        return false;
                    }
                    list = list.tail;
                    list2 = list2.tail;
                }
                return true;
            }
            Assert.error("Unknown pattern: " + (Object)((Object)jCPattern.getTag()));
        } else {
            Assert.error("Unknown pattern: " + (Object)((Object)jCPattern2.getTag()));
        }
        return false;
    }

    boolean isExternalizable(Type type) {
        try {
            this.syms.externalizableType.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            return false;
        }
        return this.types.isSubtype(type, this.syms.externalizableType);
    }

    public void checkSerialStructure(JCTree.JCClassDecl jCClassDecl, Symbol.ClassSymbol classSymbol) {
        new SerialTypeVisitor().visit(classSymbol, jCClassDecl);
    }

    void checkRequiresIdentity(JCTree jCTree, Lint lint) {
        JCTree jCTree2 = jCTree;
        Objects.requireNonNull(jCTree2);
        JCTree jCTree3 = jCTree2;
        int n = 0;
        block18: while (true) {
            int n2;
            if (jCTree3 == null) {
                n2 = -1;
            } else {
                switch (n) {
                    case 0: {
                        if (jCTree3 instanceof JCTree.JCClassDecl) {
                            n2 = 0;
                            break;
                        }
                    }
                    case 1: {
                        if (jCTree3 instanceof JCTree.JCVariableDecl) {
                            n2 = 1;
                            break;
                        }
                    }
                    case 2: {
                        if (jCTree3 instanceof JCTree.JCTypeCast) {
                            n2 = 2;
                            break;
                        }
                    }
                    case 3: {
                        if (jCTree3 instanceof JCTree.JCBindingPattern) {
                            n2 = 3;
                            break;
                        }
                    }
                    case 4: {
                        if (jCTree3 instanceof JCTree.JCMethodDecl) {
                            n2 = 4;
                            break;
                        }
                    }
                    case 5: {
                        if (jCTree3 instanceof JCTree.JCMemberReference) {
                            n2 = 5;
                            break;
                        }
                    }
                    case 6: {
                        if (jCTree3 instanceof JCTree.JCPolyExpression) {
                            n2 = 6;
                            break;
                        }
                    }
                    default: {
                        n2 = 7;
                    }
                }
            }
            switch (n2) {
                case 0: {
                    JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)jCTree3;
                    Type type = this.types.supertype(jCClassDecl.sym.type);
                    if (type != null && type.tsym != this.syms.objectType.tsym && jCClassDecl.extending != null) {
                        this.checkIfIdentityIsExpected(jCClassDecl.extending.pos(), type, lint);
                    }
                    for (JCTree.JCExpression jCExpression : jCClassDecl.implementing) {
                        this.checkIfIdentityIsExpected(jCExpression.pos(), jCExpression.type, lint);
                    }
                    for (JCTree.JCTypeParameter jCTypeParameter : jCClassDecl.typarams) {
                        this.checkIfIdentityIsExpected(jCTypeParameter.pos(), jCTypeParameter.type, lint);
                    }
                    break block18;
                }
                case 1: {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree3;
                    if ((jCVariableDecl.vartype == null || (jCVariableDecl.sym.flags_field & 0x2000000000000000L) != 0L) && (jCVariableDecl.sym.flags_field & 0xDFFFFFFDFEFFFFFFL) == 0L) break block18;
                    this.checkIfIdentityIsExpected(jCVariableDecl.vartype.pos(), jCVariableDecl.vartype.type, lint);
                    break block18;
                }
                case 2: {
                    JCTree.JCTypeCast jCTypeCast = (JCTree.JCTypeCast)jCTree3;
                    this.checkIfIdentityIsExpected(jCTypeCast.clazz.pos(), jCTypeCast.clazz.type, lint);
                    break block18;
                }
                case 3: {
                    JCTree.JCBindingPattern jCBindingPattern = (JCTree.JCBindingPattern)jCTree3;
                    if (jCBindingPattern.var.vartype == null) break block18;
                    this.checkIfIdentityIsExpected(jCBindingPattern.var.vartype.pos(), jCBindingPattern.var.vartype.type, lint);
                    break block18;
                }
                case 4: {
                    JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree3;
                    for (JCTree.JCTypeParameter jCTypeParameter : jCMethodDecl.typarams) {
                        this.checkIfIdentityIsExpected(jCTypeParameter.pos(), jCTypeParameter.type, lint);
                    }
                    if (jCMethodDecl.restype == null || jCMethodDecl.restype.type.hasTag(TypeTag.VOID)) break block18;
                    this.checkIfIdentityIsExpected(jCMethodDecl.restype.pos(), jCMethodDecl.restype.type, lint);
                    break block18;
                }
                case 5: {
                    JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)jCTree3;
                    this.checkIfIdentityIsExpected(jCMemberReference.expr.pos(), jCMemberReference.target, lint);
                    this.checkIfTypeParamsRequiresIdentity(jCMemberReference.sym.getMetadata(), jCMemberReference.typeargs, lint);
                    break block18;
                }
                case 6: {
                    List list;
                    JCTree.JCPolyExpression jCTree5 = (JCTree.JCPolyExpression)jCTree3;
                    if (!(jCTree5 instanceof JCTree.JCNewClass) && !(jCTree5 instanceof JCTree.JCMethodInvocation)) {
                        n = 7;
                        continue block18;
                    }
                    if (jCTree5 instanceof JCTree.JCNewClass) {
                        list = (JCTree.JCNewClass)jCTree5;
                        this.checkIfIdentityIsExpected(((JCTree.JCNewClass)((Object)list)).clazz.pos(), ((JCTree.JCNewClass)((Object)list)).clazz.type, lint);
                    }
                    list = jCTree5 instanceof JCTree.JCNewClass ? ((JCTree.JCNewClass)jCTree5).args : ((JCTree.JCMethodInvocation)jCTree5).args;
                    Symbol symbol = TreeInfo.symbolFor(jCTree5);
                    if (symbol == null) break block18;
                    if (!list.isEmpty() && symbol instanceof Symbol.MethodSymbol) {
                        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                        if (methodSymbol.params != null) {
                            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)methodSymbol.params.head;
                            for (Symbol.VarSymbol varSymbol2 : methodSymbol.params) {
                                if ((varSymbol2.flags_field & 0x4000000000000000L) != 0L && ((JCTree.JCExpression)list.head).type.isValueBased()) {
                                    lint.logIfEnabled(((JCTree.JCExpression)list.head).pos(), CompilerProperties.LintWarnings.AttemptToUseValueBasedWhereIdentityExpected);
                                }
                                varSymbol = varSymbol2;
                                list = list.tail;
                            }
                            while (list != null && !list.isEmpty() && varSymbol != null) {
                                if ((varSymbol.flags_field & 0x4000000000000000L) != 0L && ((JCTree.JCExpression)list.head).type.isValueBased()) {
                                    lint.logIfEnabled(((JCTree.JCExpression)list.head).pos(), CompilerProperties.LintWarnings.AttemptToUseValueBasedWhereIdentityExpected);
                                }
                                list = list.tail;
                            }
                        }
                    }
                    this.checkIfTypeParamsRequiresIdentity(symbol.getMetadata(), jCTree5 instanceof JCTree.JCNewClass ? ((JCTree.JCNewClass)jCTree5).typeargs : ((JCTree.JCMethodInvocation)jCTree5).typeargs, lint);
                    break block18;
                }
                default: {
                    throw new AssertionError((Object)("unexpected tree " + jCTree));
                }
            }
            break;
        }
    }

    private boolean checkIfIdentityIsExpected(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Lint lint) {
        if (type != null && lint != null && lint.isEnabled(Lint.LintCategory.IDENTITY)) {
            RequiresIdentityVisitor requiresIdentityVisitor = new RequiresIdentityVisitor();
            requiresIdentityVisitor.visit(type, new HashSet());
            if (requiresIdentityVisitor.requiresWarning) {
                lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.AttemptToUseValueBasedWhereIdentityExpected);
                return true;
            }
        }
        return false;
    }

    private void checkIfTypeParamsRequiresIdentity(SymbolMetadata symbolMetadata, List<JCTree.JCExpression> list, Lint lint) {
        if (list != null && !list.isEmpty()) {
            for (JCTree.JCExpression jCExpression : list) {
                this.checkIfIdentityIsExpected(jCExpression.pos(), jCExpression.type, lint);
            }
            if (symbolMetadata != null) {
                symbolMetadata.getTypeAttributes().stream().filter(typeCompound -> this.isRequiresIdentityAnnotation(typeCompound.type.tsym) && ((JCTree.JCExpression)list.get((int)typeCompound.position.parameter_index)).type != null && ((JCTree.JCExpression)list.get((int)typeCompound.position.parameter_index)).type.isValueBased()).forEach(typeCompound -> lint.logIfEnabled(((JCTree.JCExpression)list.get(typeCompound.position.parameter_index)).pos(), CompilerProperties.LintWarnings.AttemptToUseValueBasedWhereIdentityExpected));
            }
        }
    }

    private boolean isRequiresIdentityAnnotation(Symbol.TypeSymbol typeSymbol) {
        return typeSymbol == this.syms.requiresIdentityType.tsym || typeSymbol.flatName() == this.syms.requiresIdentityInternalType.tsym.flatName();
    }

    private static /* synthetic */ boolean lambda$checkSwitchCaseStructure$42(JCTree.JCCaseLabel jCCaseLabel) {
        return jCCaseLabel instanceof JCTree.JCPatternCaseLabel;
    }

    private /* synthetic */ boolean lambda$checkSwitchCaseStructure$41(JCTree.JCPatternCaseLabel jCPatternCaseLabel) {
        return !this.hasBindings(jCPatternCaseLabel.getPattern());
    }

    private static /* synthetic */ JCTree.JCPatternCaseLabel lambda$checkSwitchCaseStructure$40(JCTree.JCCaseLabel jCCaseLabel) {
        return (JCTree.JCPatternCaseLabel)jCCaseLabel;
    }

    private static /* synthetic */ boolean lambda$checkSwitchCaseStructure$39(JCTree.JCCaseLabel jCCaseLabel) {
        return jCCaseLabel instanceof JCTree.JCPatternCaseLabel;
    }

    private /* synthetic */ void lambda$checkDefaultConstructor$35(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.ClassSymbol classSymbol, Symbol.PackageSymbol packageSymbol, Symbol.ModuleSymbol moduleSymbol, Lint lint) {
        this.lint.logIfEnabled(diagnosticPosition, CompilerProperties.LintWarnings.MissingExplicitCtor(classSymbol, packageSymbol, moduleSymbol));
    }

    public static interface CheckContext {
        public boolean compatible(Type var1, Type var2, Warner var3);

        public void report(JCDiagnostic.DiagnosticPosition var1, JCDiagnostic var2);

        public Warner checkWarner(JCDiagnostic.DiagnosticPosition var1, Type var2, Type var3);

        public InferenceContext inferenceContext();

        public DeferredAttr.DeferredAttrContext deferredAttrContext();
    }

    class Validator
    extends JCTree.Visitor {
        boolean checkRaw;
        boolean isOuter;
        Env<AttrContext> env;

        Validator(Env<AttrContext> env) {
            this.env = env;
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            this.validateTree(jCArrayTypeTree.elemtype, this.checkRaw, this.isOuter);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
            if (jCTypeApply.type.hasTag(TypeTag.CLASS)) {
                boolean bl;
                List<JCTree.JCExpression> list = jCTypeApply.arguments;
                List<Type> list2 = jCTypeApply.type.tsym.type.getTypeArguments();
                Type type = Check.this.firstIncompatibleTypeArg(jCTypeApply.type);
                if (type != null) {
                    for (JCTree jCTree : jCTypeApply.arguments) {
                        if (jCTree.type == type) {
                            Check.this.log.error(jCTree, CompilerProperties.Errors.NotWithinBounds(type, (Type)list2.head));
                        }
                        list2 = list2.tail;
                    }
                }
                list2 = jCTypeApply.type.tsym.type.getTypeArguments();
                boolean bl2 = bl = jCTypeApply.type.tsym.flatName() == ((Check)Check.this).names.java_lang_Class;
                while (list.nonEmpty() && list2.nonEmpty()) {
                    this.validateTree((JCTree)list.head, !this.isOuter || !bl, false);
                    list = list.tail;
                    list2 = list2.tail;
                }
                if (jCTypeApply.type.getEnclosingType().isRaw()) {
                    Check.this.log.error(jCTypeApply.pos(), CompilerProperties.Errors.ImproperlyFormedTypeInnerRawParam);
                }
                if (jCTypeApply.clazz.hasTag(JCTree.Tag.SELECT)) {
                    this.visitSelectInternal((JCTree.JCFieldAccess)jCTypeApply.clazz);
                }
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            this.validateTrees(jCTypeParameter.bounds, true, this.isOuter);
            Check.this.checkClassBounds(jCTypeParameter.pos(), jCTypeParameter.type);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard jCWildcard) {
            if (jCWildcard.inner != null) {
                this.validateTree(jCWildcard.inner, true, this.isOuter);
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.type.hasTag(TypeTag.CLASS)) {
                this.visitSelectInternal(jCFieldAccess);
                if (jCFieldAccess.selected.type.isParameterized() && jCFieldAccess.type.tsym.type.getTypeArguments().nonEmpty()) {
                    Check.this.log.error(jCFieldAccess.pos(), CompilerProperties.Errors.ImproperlyFormedTypeParamMissing);
                }
            }
        }

        public void visitSelectInternal(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.type.tsym.isStatic() && jCFieldAccess.selected.type.isParameterized()) {
                Check.this.log.error(jCFieldAccess.pos(), CompilerProperties.Errors.CantSelectStaticClassFromParamType);
            } else {
                jCFieldAccess.selected.accept(this);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            jCAnnotatedType.underlyingType.accept(this);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
            if (jCPrimitiveTypeTree.type.hasTag(TypeTag.VOID)) {
                Check.this.log.error(jCPrimitiveTypeTree.pos(), CompilerProperties.Errors.VoidNotAllowedHere);
            }
            super.visitTypeIdent(jCPrimitiveTypeTree);
        }

        @Override
        public void visitTree(JCTree jCTree) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateTree(JCTree jCTree, boolean bl, boolean bl2) {
            if (jCTree != null) {
                boolean bl3 = this.checkRaw;
                this.checkRaw = bl;
                this.isOuter = bl2;
                try {
                    jCTree.accept(this);
                    if (bl) {
                        Check.this.checkRaw(jCTree, this.env);
                    }
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    Check.this.completionError(jCTree.pos(), completionFailure);
                }
                finally {
                    this.checkRaw = bl3;
                }
            }
        }

        public void validateTrees(List<? extends JCTree> list, boolean bl, boolean bl2) {
            List<JCTree> list2 = list;
            while (list2.nonEmpty()) {
                this.validateTree((JCTree)list2.head, bl, bl2);
                list2 = list2.tail;
            }
        }
    }

    private class ClashFilter
    implements Predicate<Symbol> {
        Type site;

        ClashFilter(Type type) {
            this.site = type;
        }

        boolean shouldSkip(Symbol symbol) {
            return (symbol.flags() & 0x40000000000L) != 0L && symbol.owner == this.site.tsym;
        }

        @Override
        public boolean test(Symbol symbol) {
            return symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x1000L) == 0L && !this.shouldSkip(symbol) && symbol.isInheritedIn(this.site.tsym, Check.this.types) && !symbol.isConstructor();
        }
    }

    class CycleChecker
    extends TreeScanner {
        Set<Symbol> seenClasses = new HashSet<Symbol>();
        boolean errorFound = false;
        boolean partialCheck = false;

        CycleChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSymbol(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            if (symbol != null && symbol.kind == Kinds.Kind.TYP) {
                Env<AttrContext> env = Check.this.enter.getEnv((Symbol.TypeSymbol)symbol);
                if (env != null) {
                    DiagnosticSource diagnosticSource = Check.this.log.currentSource();
                    try {
                        Check.this.log.useSource(env.toplevel.sourcefile);
                        this.scan(env.tree);
                    }
                    finally {
                        Check.this.log.useSource(diagnosticSource.getFile());
                    }
                } else if (symbol.kind == Kinds.Kind.TYP) {
                    this.checkClass(diagnosticPosition, symbol, List.nil());
                }
            } else if (symbol == null || symbol.kind != Kinds.Kind.PCK) {
                this.partialCheck = true;
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            super.visitSelect(jCFieldAccess);
            this.checkSymbol(jCFieldAccess.pos(), jCFieldAccess.sym);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            this.checkSymbol(jCIdent.pos(), jCIdent.sym);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
            this.scan(jCTypeApply.clazz);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            this.scan(jCArrayTypeTree.elemtype);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            List<JCTree> list = List.nil();
            if (jCClassDecl.getExtendsClause() != null) {
                list = list.prepend(jCClassDecl.getExtendsClause());
            }
            if (jCClassDecl.getImplementsClause() != null) {
                for (JCTree jCTree : jCClassDecl.getImplementsClause()) {
                    list = list.prepend(jCTree);
                }
            }
            this.checkClass(jCClassDecl.pos(), jCClassDecl.sym, list);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkClass(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol2, List<JCTree> list) {
            if ((symbol2.flags_field & 0x40000000L) != 0L) {
                return;
            }
            if (this.seenClasses.contains(symbol2)) {
                this.errorFound = true;
                Check.this.log.error(diagnosticPosition, CompilerProperties.Errors.CyclicInheritance(symbol2));
                this.seenClasses.stream().filter(symbol -> !symbol.type.isErroneous()).filter(Symbol.ClassSymbol.class::isInstance).map(Symbol.ClassSymbol.class::cast).forEach(classSymbol -> Check.this.handleCyclic(classSymbol));
            } else if (!symbol2.type.isErroneous()) {
                try {
                    this.seenClasses.add(symbol2);
                    if (symbol2.type.hasTag(TypeTag.CLASS)) {
                        if (list.nonEmpty()) {
                            this.scan(list);
                        } else {
                            Type.ClassType classType = (Type.ClassType)symbol2.type;
                            if (classType.supertype_field == null || classType.interfaces_field == null) {
                                this.partialCheck = true;
                                return;
                            }
                            this.checkSymbol(diagnosticPosition, classType.supertype_field.tsym);
                            for (Type type : classType.interfaces_field) {
                                this.checkSymbol(diagnosticPosition, type.tsym);
                            }
                        }
                        if (symbol2.owner.kind == Kinds.Kind.TYP) {
                            this.checkSymbol(diagnosticPosition, symbol2.owner);
                        }
                    }
                }
                finally {
                    this.seenClasses.remove(symbol2);
                }
            }
        }
    }

    private class DefaultMethodClashFilter
    implements Predicate<Symbol> {
        Type site;

        DefaultMethodClashFilter(Type type) {
            this.site = type;
        }

        @Override
        public boolean test(Symbol symbol) {
            return symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x80000000000L) != 0L && symbol.isInheritedIn(this.site.tsym, Check.this.types) && !symbol.isConstructor();
        }
    }

    class PotentiallyAmbiguousFilter
    extends ClashFilter {
        PotentiallyAmbiguousFilter(Type type) {
            super(type);
        }

        @Override
        boolean shouldSkip(Symbol symbol) {
            return symbol.owner.type.tsym == ((Check)Check.this).syms.objectType.tsym || super.shouldSkip(symbol);
        }
    }

    private class SuperThisChecker
    extends TreeScanner {
        private static final int MATCH_SCAN_DEPTH = 3;
        private boolean constructor;
        private boolean firstStatement;
        private JCTree.JCReturn earlyReturn;
        private Name initCall;
        private int scanDepth;

        private SuperThisChecker() {
        }

        public void check(JCTree.JCClassDecl jCClassDecl) {
            this.scan(jCClassDecl.defs);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            Assert.check(!this.constructor);
            Assert.check(this.earlyReturn == null);
            Assert.check(this.initCall == null);
            Assert.check(this.scanDepth == 1);
            this.constructor = TreeInfo.isConstructor(jCMethodDecl);
            try {
                if (jCMethodDecl.body != null) {
                    this.firstStatement = true;
                    List<JCTree.JCStatement> list = jCMethodDecl.body.stats;
                    while (list.nonEmpty()) {
                        this.scan((JCTree)list.head);
                        this.firstStatement = false;
                        list = list.tail;
                    }
                }
                if (this.constructor && this.earlyReturn != null && this.initCall != null) {
                    Check.this.log.error(this.earlyReturn.pos(), CompilerProperties.Errors.ReturnBeforeSuperclassInitialized);
                }
            }
            finally {
                this.firstStatement = false;
                this.constructor = false;
                this.earlyReturn = null;
                this.initCall = null;
            }
        }

        @Override
        public void scan(JCTree jCTree) {
            ++this.scanDepth;
            try {
                super.scan(jCTree);
            }
            finally {
                --this.scanDepth;
            }
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            Name name = TreeInfo.name(jCMethodInvocation.meth);
            if (name == ((Check)Check.this).names._super || name == ((Check)Check.this).names._this) {
                if (!this.constructor) {
                    Check.this.log.error(jCMethodInvocation.pos(), CompilerProperties.Errors.CallMustOnlyAppearInCtor);
                } else if (this.scanDepth != 3) {
                    Check.this.log.error(jCMethodInvocation.pos(), CompilerProperties.Errors.CtorCallsNotAllowedHere);
                } else if (this.initCall != null) {
                    Check.this.log.error(jCMethodInvocation.pos(), CompilerProperties.Errors.RedundantSuperclassInit);
                } else {
                    if (!this.firstStatement) {
                        Check.this.preview.checkSourceLevel(jCMethodInvocation.pos(), Source.Feature.FLEXIBLE_CONSTRUCTORS);
                    }
                    this.initCall = name;
                }
            }
            super.visitApply(jCMethodInvocation);
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            if (this.constructor && this.initCall == null && this.earlyReturn == null) {
                this.earlyReturn = jCReturn;
            }
            super.visitReturn(jCReturn);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            boolean bl = this.constructor;
            boolean bl2 = this.firstStatement;
            JCTree.JCReturn jCReturn = this.earlyReturn;
            Name name = this.initCall;
            int n = this.scanDepth;
            this.constructor = false;
            this.firstStatement = false;
            this.earlyReturn = null;
            this.initCall = null;
            this.scanDepth = 0;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.constructor = bl;
                this.firstStatement = bl2;
                this.earlyReturn = jCReturn;
                this.initCall = name;
                this.scanDepth = n;
            }
        }
    }

    private class ConversionWarner
    extends Warner {
        final String uncheckedKey;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Type type, Type type2) {
            super(diagnosticPosition);
            this.uncheckedKey = string;
            this.found = type;
            this.expected = type2;
        }

        @Override
        public void warn(Lint.LintCategory lintCategory) {
            boolean bl = this.warned;
            super.warn(lintCategory);
            if (bl) {
                return;
            }
            switch (lintCategory) {
                case UNCHECKED: {
                    Check.this.warnUnchecked(this.pos(), CompilerProperties.LintWarnings.ProbFoundReq(Check.this.diags.fragment(this.uncheckedKey, new Object[0]), this.found, this.expected));
                    break;
                }
                case VARARGS: {
                    if (Check.this.method == null || Check.this.method.attribute(((Check)Check.this).syms.trustMeType.tsym) == null || !Check.this.isTrustMeAllowedOnMethod(Check.this.method) || Check.this.types.isReifiable(((Check)Check.this).method.type.getParameterTypes().last())) break;
                    Check.this.lint.logIfEnabled(this.pos(), CompilerProperties.LintWarnings.VarargsUnsafeUseVarargsParam(((Check)Check.this).method.params.last()));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected lint: " + (Object)((Object)lintCategory)));
                }
            }
        }
    }

    private class SerialTypeVisitor
    extends ElementKindVisitor14<Void, JCTree.JCClassDecl> {
        private static final Set<String> serialMethodNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("writeObject", "writeReplace", "readObject", "readObjectNoData", "readResolve")));
        private static final Set<String> serialFieldNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("serialVersionUID", "serialPersistentFields")));
        private final Type OSF_TYPE;
        Lint lint;

        SerialTypeVisitor() {
            this.OSF_TYPE = new Type.ArrayType(((Check)Check.this).syms.objectStreamFieldType, ((Check)Check.this).syms.arrayClass);
            this.lint = Check.this.lint;
        }

        @Override
        public Void defaultAction(Element element, JCTree.JCClassDecl jCClassDecl) {
            throw new IllegalArgumentException(ObjectsWrapper.requireNonNullElse(element.toString(), ""));
        }

        @Override
        public Void visitType(TypeElement typeElement2, JCTree.JCClassDecl jCClassDecl2) {
            this.runUnderLint(typeElement2, jCClassDecl2, (typeElement, jCClassDecl) -> super.visitType((TypeElement)typeElement, jCClassDecl));
            return null;
        }

        @Override
        public Void visitTypeAsClass(TypeElement typeElement, JCTree.JCClassDecl jCClassDecl2) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
            this.checkCtorAccess(jCClassDecl2, classSymbol);
            Symbol.VarSymbol varSymbol = null;
            for (Symbol object : classSymbol.members().getSymbolsByName(((Check)Check.this).names.serialVersionUID)) {
                if (object.kind != Kinds.Kind.VAR) continue;
                varSymbol = (Symbol.VarSymbol)object;
                break;
            }
            if (varSymbol == null) {
                Check.this.log.warning(jCClassDecl2.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.MissingSVUID(classSymbol));
            }
            boolean bl = classSymbol.members().getSymbolsByName(((Check)Check.this).names.serialPersistentFields, symbol -> symbol.kind == Kinds.Kind.VAR).iterator().hasNext();
            for (Symbol symbol2 : classSymbol.getEnclosedElements()) {
                this.runUnderLint(symbol2, jCClassDecl2, (symbol, jCClassDecl) -> {
                    String string = null;
                    block0 : switch (symbol.getKind()) {
                        case FIELD: {
                            long l;
                            if (!bl && ((l = symbol.flags()) & 0x80L) == 0L && (l & 8L) == 0L) {
                                Type type = symbol.asType();
                                if (!this.canBeSerialized(type)) {
                                    Check.this.log.warning(TreeInfo.diagnosticPositionFor(symbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.NonSerializableInstanceField);
                                } else if (type.hasTag(TypeTag.ARRAY)) {
                                    Type.ArrayType arrayType = (Type.ArrayType)type;
                                    Type type2 = arrayType.elemtype;
                                    while (type2.hasTag(TypeTag.ARRAY)) {
                                        arrayType = (Type.ArrayType)type2;
                                        type2 = arrayType.elemtype;
                                    }
                                    if (!this.canBeSerialized(type2)) {
                                        Check.this.log.warning(TreeInfo.diagnosticPositionFor(symbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.NonSerializableInstanceFieldArray(type2));
                                    }
                                }
                            }
                            if (!serialFieldNames.contains(string = symbol.getSimpleName().toString())) break;
                            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                            switch (string) {
                                case "serialVersionUID": {
                                    this.checkSerialVersionUID((JCTree.JCClassDecl)jCClassDecl, typeElement, varSymbol);
                                    break block0;
                                }
                                case "serialPersistentFields": {
                                    this.checkSerialPersistentFields((JCTree.JCClassDecl)jCClassDecl, typeElement, varSymbol);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                        case METHOD: {
                            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                            string = ((Name)methodSymbol.getSimpleName()).toString();
                            if (!serialMethodNames.contains(string)) break;
                            switch (string) {
                                case "writeObject": {
                                    this.checkWriteObject((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "writeReplace": {
                                    this.checkWriteReplace((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "readObject": {
                                    this.checkReadObject((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "readObjectNoData": {
                                    this.checkReadObjectNoData((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "readResolve": {
                                    this.checkReadResolve((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                    }
                });
            }
            return null;
        }

        boolean canBeSerialized(Type type) {
            return type.isPrimitive() || Check.this.rs.isSerializable(type);
        }

        private void checkCtorAccess(JCTree.JCClassDecl jCClassDecl, Symbol.ClassSymbol classSymbol) {
            if (Check.this.isExternalizable(classSymbol.type)) {
                for (Symbol symbol : classSymbol.getEnclosedElements()) {
                    if (!symbol.isConstructor() || (symbol.flags() & 1L) != 1L || !((List)((Symbol.MethodSymbol)symbol).getParameters()).isEmpty()) continue;
                    return;
                }
            } else {
                Type type = classSymbol.getSuperclass();
                while (Check.this.rs.isSerializable(type)) {
                    try {
                        type = (Type)((TypeElement)((DeclaredType)((Object)type)).asElement()).getSuperclass();
                    }
                    catch (ClassCastException classCastException) {
                        return;
                    }
                }
                try {
                    Symbol.ClassSymbol classSymbol2 = (Symbol.ClassSymbol)((DeclaredType)((Object)type)).asElement();
                    for (Symbol symbol : classSymbol2.getEnclosedElements()) {
                        Symbol.MethodSymbol methodSymbol;
                        if (!symbol.isConstructor() || !((List)(methodSymbol = (Symbol.MethodSymbol)symbol).getParameters()).isEmpty() || (methodSymbol.flags() & 2L) != 2L && (classSymbol2.getNestingKind() != NestingKind.MEMBER || (classSymbol2.flags() & 8L) != 0L)) continue;
                        Check.this.log.warning(jCClassDecl.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerializableMissingAccessNoArgCtor(classSymbol2.getQualifiedName()));
                    }
                }
                catch (ClassCastException classCastException) {
                    return;
                }
                return;
            }
            Check.this.log.warning(jCClassDecl.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.ExternalizableMissingPublicNoArgCtor);
        }

        private void checkSerialVersionUID(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.VarSymbol varSymbol) {
            if ((varSymbol.flags() & 0x18L) != 24L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.ImproperSVUID((Symbol)element));
            }
            if (!varSymbol.type.hasTag(TypeTag.LONG)) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.LongSVUID((Symbol)element));
            }
            if (varSymbol.getConstValue() == null) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.ConstantSVUID((Symbol)element));
            }
        }

        private void checkSerialPersistentFields(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.VarSymbol varSymbol) {
            JCTree jCTree;
            if ((varSymbol.flags() & 0x1AL) != 26L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.ImproperSPF);
            }
            if (!Check.this.types.isSameType(varSymbol.type, this.OSF_TYPE)) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.OSFArraySPF);
            }
            if (Check.this.isExternalizable((Type)element.asType())) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialFieldExternalizable);
            }
            if ((jCTree = TreeInfo.declarationFor(varSymbol, jCClassDecl)) != null && jCTree.getTag() == JCTree.Tag.VARDEF) {
                JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)jCTree;
                JCTree.JCExpression jCExpression = jCVariableDecl.init;
                if (jCExpression != null && TreeInfo.isNull(jCExpression)) {
                    Check.this.log.warning(jCExpression.pos(), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SPFNullInit);
                }
            }
        }

        private void checkWriteObject(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkPrivateNonStaticMethod(jCClassDecl, methodSymbol);
            this.checkReturnType(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.voidType);
            this.checkOneArg(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectOutputStreamType);
            this.checkExceptions(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.ioExceptionType);
            this.checkExternalizable(jCClassDecl, element, methodSymbol);
        }

        private void checkWriteReplace(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkConcreteInstanceMethod(jCClassDecl, element, methodSymbol);
            this.checkReturnType(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectType);
            this.checkNoArgs(jCClassDecl, element, methodSymbol);
            this.checkExceptions(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectStreamExceptionType);
        }

        private void checkReadObject(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkPrivateNonStaticMethod(jCClassDecl, methodSymbol);
            this.checkReturnType(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.voidType);
            this.checkOneArg(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectInputStreamType);
            this.checkExceptions(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.ioExceptionType, ((Check)Check.this).syms.classNotFoundExceptionType);
            this.checkExternalizable(jCClassDecl, element, methodSymbol);
        }

        private void checkReadObjectNoData(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkPrivateNonStaticMethod(jCClassDecl, methodSymbol);
            this.checkReturnType(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.voidType);
            this.checkNoArgs(jCClassDecl, element, methodSymbol);
            this.checkExceptions(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectStreamExceptionType);
            this.checkExternalizable(jCClassDecl, element, methodSymbol);
        }

        private void checkReadResolve(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkConcreteInstanceMethod(jCClassDecl, element, methodSymbol);
            this.checkReturnType(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectType);
            this.checkNoArgs(jCClassDecl, element, methodSymbol);
            this.checkExceptions(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectStreamExceptionType);
        }

        private void checkWriteExternalRecord(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, boolean bl) {
            this.checkExternMethodRecord(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectOutputType, bl);
        }

        private void checkReadExternalRecord(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, boolean bl) {
            this.checkExternMethodRecord(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectInputType, bl);
        }

        private void checkExternMethodRecord(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type type, boolean bl) {
            if (bl && this.isExternMethod(jCClassDecl, element, methodSymbol, type)) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualExternalizableMethodRecord(((Name)methodSymbol.getSimpleName()).toString()));
            }
        }

        void checkPrivateNonStaticMethod(JCTree.JCClassDecl jCClassDecl, Symbol.MethodSymbol methodSymbol) {
            long l = methodSymbol.flags();
            if ((l & 2L) == 0L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodNotPrivate((Name)methodSymbol.getSimpleName()));
            }
            if ((l & 8L) != 0L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodStatic((Name)methodSymbol.getSimpleName()));
            }
        }

        @Override
        public Void visitTypeAsEnum(TypeElement typeElement, JCTree.JCClassDecl jCClassDecl) {
            boolean bl = Check.this.isExternalizable((Type)typeElement.asType());
            for (Element element2 : typeElement.getEnclosedElements()) {
                this.runUnderLint(element2, jCClassDecl, (element, jCClassDecl2) -> {
                    String string = element.getSimpleName().toString();
                    switch (element.getKind()) {
                        case FIELD: {
                            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)element;
                            if (!serialFieldNames.contains(string)) break;
                            Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl2), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialFieldEnum(string));
                            break;
                        }
                        case METHOD: {
                            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
                            if (serialMethodNames.contains(string)) {
                                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl2), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialMethodEnum(string));
                            }
                            if (bl) {
                                switch (string) {
                                    case "writeExternal": {
                                        this.checkWriteExternalEnum((JCTree.JCClassDecl)jCClassDecl2, typeElement, methodSymbol);
                                        break;
                                    }
                                    case "readExternal": {
                                        this.checkReadExternalEnum((JCTree.JCClassDecl)jCClassDecl2, typeElement, methodSymbol);
                                    }
                                }
                            }
                            break;
                        }
                        case ENUM_CONSTANT: {
                            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)element;
                            JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)TreeInfo.declarationFor(varSymbol, jCClassDecl);
                            Object object = jCVariableDecl.init;
                            if (!(object instanceof JCTree.JCNewClass)) break;
                            JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)object;
                            if (jCNewClass.def == null) break;
                            object = jCNewClass.def.sym;
                            this.visitTypeAsEnum((TypeElement)object, jCClassDecl);
                        }
                    }
                });
            }
            return null;
        }

        private void checkWriteExternalEnum(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkExternMethodEnum(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectOutputType);
        }

        private void checkReadExternalEnum(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            this.checkExternMethodEnum(jCClassDecl, element, methodSymbol, ((Check)Check.this).syms.objectInputType);
        }

        private void checkExternMethodEnum(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type type) {
            if (this.isExternMethod(jCClassDecl, element, methodSymbol, type)) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualExternMethodEnum(((Name)methodSymbol.getSimpleName()).toString()));
            }
        }

        private boolean isExternMethod(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type type) {
            long l = methodSymbol.flags();
            Type type2 = methodSymbol.getReturnType();
            return (l & 1L) != 0L && (l & 8L) == 0L && Check.this.types.isSameType(((Check)Check.this).syms.voidType, type2) && this.hasExactlyOneArgWithType(jCClassDecl, element, methodSymbol, type);
        }

        @Override
        public Void visitTypeAsInterface(TypeElement typeElement, JCTree.JCClassDecl jCClassDecl2) {
            for (Element element2 : typeElement.getEnclosedElements()) {
                this.runUnderLint(element2, jCClassDecl2, (element, jCClassDecl) -> {
                    String string = null;
                    block0 : switch (element.getKind()) {
                        case FIELD: {
                            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)element;
                            switch (string = ((Name)varSymbol.getSimpleName()).toString()) {
                                case "serialPersistentFields": {
                                    Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialFieldInterface);
                                    break;
                                }
                                case "serialVersionUID": {
                                    this.checkSerialVersionUID((JCTree.JCClassDecl)jCClassDecl, typeElement, varSymbol);
                                }
                            }
                            break;
                        }
                        case METHOD: {
                            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
                            string = element.getSimpleName().toString();
                            if (!serialMethodNames.contains(string)) break;
                            switch (string) {
                                case "readObject": 
                                case "readObjectNoData": 
                                case "writeObject": {
                                    this.checkPrivateMethod((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "writeReplace": 
                                case "readResolve": {
                                    this.checkDefaultIneffective((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                            }
                            throw new AssertionError();
                        }
                    }
                });
            }
            return null;
        }

        private void checkPrivateMethod(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            if ((methodSymbol.flags() & 2L) == 0L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.NonPrivateMethodWeakerAccess);
            }
        }

        private void checkDefaultIneffective(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            if ((methodSymbol.flags() & 0x80000000000L) == 0x80000000000L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.DefaultIneffective);
            }
        }

        @Override
        public Void visitTypeAsAnnotationType(TypeElement typeElement, JCTree.JCClassDecl jCClassDecl) {
            return null;
        }

        @Override
        public Void visitTypeAsRecord(TypeElement typeElement, JCTree.JCClassDecl jCClassDecl2) {
            boolean bl = Check.this.isExternalizable((Type)typeElement.asType());
            for (Element element2 : typeElement.getEnclosedElements()) {
                this.runUnderLint(element2, jCClassDecl2, (element, jCClassDecl) -> {
                    String string = element.getSimpleName().toString();
                    block0 : switch (element.getKind()) {
                        case FIELD: {
                            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)element;
                            switch (string) {
                                case "serialPersistentFields": {
                                    Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialFieldRecord);
                                    break;
                                }
                                case "serialVersionUID": {
                                    this.checkSerialVersionUID((JCTree.JCClassDecl)jCClassDecl, typeElement, varSymbol);
                                }
                            }
                            break;
                        }
                        case METHOD: {
                            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
                            switch (string) {
                                case "writeReplace": {
                                    this.checkWriteReplace((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "readResolve": {
                                    this.checkReadResolve((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol);
                                    break block0;
                                }
                                case "writeExternal": {
                                    this.checkWriteExternalRecord((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol, bl);
                                    break block0;
                                }
                                case "readExternal": {
                                    this.checkReadExternalRecord((JCTree.JCClassDecl)jCClassDecl, typeElement, methodSymbol, bl);
                                    break block0;
                                }
                            }
                            if (!serialMethodNames.contains(string)) break;
                            Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialMethodRecord(string));
                        }
                    }
                });
            }
            return null;
        }

        void checkConcreteInstanceMethod(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            if ((methodSymbol.flags() & 0x408L) != 0L) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialConcreteInstanceMethod((Name)methodSymbol.getSimpleName()));
            }
        }

        private void checkReturnType(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type type) {
            Type type2 = methodSymbol.getReturnType();
            if (!Check.this.types.isSameType(type, type2)) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodUnexpectedReturnType((Name)methodSymbol.getSimpleName(), type2, type));
            }
        }

        private void checkOneArg(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type type) {
            String string = ((Name)methodSymbol.getSimpleName()).toString();
            java.util.List list = methodSymbol.getParameters();
            if (((List)list).size() != 1) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodOneArg((Name)methodSymbol.getSimpleName(), ((List)list).size()));
                return;
            }
            TypeMirror typeMirror = ((Symbol.VarSymbol)((List)list).get(0)).asType();
            if (!Check.this.types.isSameType((Type)typeMirror, type)) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodParameterType((Name)methodSymbol.getSimpleName(), type, (Type)typeMirror));
            }
        }

        private boolean hasExactlyOneArgWithType(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type type) {
            java.util.List list = methodSymbol.getParameters();
            return ((List)list).size() == 1 && Check.this.types.isSameType((Type)((Symbol.VarSymbol)((List)list).get(0)).asType(), type);
        }

        private void checkNoArgs(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            java.util.List list = methodSymbol.getParameters();
            if (!((List)list).isEmpty()) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)((List)list).get(0), jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodNoArgs((Name)methodSymbol.getSimpleName()));
            }
        }

        private void checkExternalizable(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol) {
            if (Check.this.isExternalizable((Type)element.asType())) {
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.IneffectualSerialMethodExternalizable((Name)methodSymbol.getSimpleName()));
            }
        }

        private void checkExceptions(JCTree.JCClassDecl jCClassDecl, Element element, Symbol.MethodSymbol methodSymbol, Type ... typeArray) {
            for (Type type : methodSymbol.getThrownTypes()) {
                if (Check.this.types.isSubtype(type, ((Check)Check.this).syms.runtimeExceptionType) || Check.this.types.isSubtype(type, ((Check)Check.this).syms.errorType)) continue;
                boolean bl = false;
                for (Type type2 : typeArray) {
                    if (!Check.this.types.isSubtype(type, type2)) continue;
                    bl = true;
                }
                if (bl) continue;
                Check.this.log.warning(TreeInfo.diagnosticPositionFor((Symbol)methodSymbol, jCClassDecl), (JCDiagnostic.Warning)CompilerProperties.LintWarnings.SerialMethodUnexpectedException((Name)methodSymbol.getSimpleName(), type));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <E extends Element> Void runUnderLint(E e, JCTree.JCClassDecl jCClassDecl, BiConsumer<E, JCTree.JCClassDecl> biConsumer) {
            Lint lint = this.lint;
            try {
                this.lint = this.lint.augment((Symbol)e);
                if (this.lint.isEnabled(Lint.LintCategory.SERIAL)) {
                    biConsumer.accept(e, jCClassDecl);
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.lint = lint;
            }
        }
    }

    private class RequiresIdentityVisitor
    extends Types.SimpleVisitor<Void, Set<Type>> {
        boolean requiresWarning = false;

        private RequiresIdentityVisitor() {
        }

        @Override
        public Void visitType(Type type, Set<Type> set) {
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType wildcardType, Set<Type> set) {
            return (Void)this.visit(wildcardType.type, set);
        }

        @Override
        public Void visitTypeVar(Type.TypeVar typeVar, Set<Type> set) {
            if (set.add(typeVar)) {
                this.visit(typeVar.getUpperBound(), set);
            }
            return null;
        }

        @Override
        public Void visitCapturedType(Type.CapturedType capturedType, Set<Type> set) {
            if (set.add(capturedType)) {
                this.visit(capturedType.getUpperBound(), set);
                this.visit(capturedType.getLowerBound(), set);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType arrayType, Set<Type> set) {
            return (Void)this.visit(arrayType.elemtype, set);
        }

        @Override
        public Void visitClassType(Type.ClassType classType, Set<Type> set) {
            Object object;
            if (classType != null && classType.tsym != null && (object = classType.tsym.getMetadata()) != null && !((List)classType.getTypeArguments()).isEmpty() && ((SymbolMetadata)object).getTypeAttributes().stream().filter(typeCompound -> Check.this.isRequiresIdentityAnnotation(typeCompound.type.tsym) && ((List)classType.getTypeArguments()).get(typeCompound.position.parameter_index) != null && ((Type)((List)classType.getTypeArguments()).get(typeCompound.position.parameter_index)).isValueBased()).findAny().isPresent()) {
                this.requiresWarning = true;
                return null;
            }
            this.visit(classType.getEnclosingType(), set);
            for (Type type : classType.getTypeArguments()) {
                this.visit(type, set);
            }
            return null;
        }
    }

    static class NestedCheckContext
    implements CheckContext {
        CheckContext enclosingContext;

        NestedCheckContext(CheckContext checkContext) {
            this.enclosingContext = checkContext;
        }

        @Override
        public boolean compatible(Type type, Type type2, Warner warner) {
            return this.enclosingContext.compatible(type, type2, warner);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic jCDiagnostic) {
            this.enclosingContext.report(diagnosticPosition, jCDiagnostic);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Type type2) {
            return this.enclosingContext.checkWarner(diagnosticPosition, type, type2);
        }

        @Override
        public InferenceContext inferenceContext() {
            return this.enclosingContext.inferenceContext();
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.enclosingContext.deferredAttrContext();
        }
    }
}

