/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CaptureScanner
extends TreeScanner {
    private final JCTree tree;
    private final Set<Symbol.VarSymbol> seenVars = new HashSet<Symbol.VarSymbol>();
    private final LinkedHashSet<Symbol.VarSymbol> fvs = new LinkedHashSet();

    public CaptureScanner(JCTree jCTree) {
        this.tree = jCTree;
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        Symbol.VarSymbol varSymbol;
        Symbol symbol = jCIdent.sym;
        if (symbol.kind == Kinds.Kind.VAR && symbol.owner.kind == Kinds.Kind.MTH && (varSymbol = (Symbol.VarSymbol)symbol).getConstValue() == null && !this.seenVars.contains(varSymbol)) {
            this.addFreeVar(varSymbol);
        }
    }

    protected void addFreeVar(Symbol.VarSymbol varSymbol) {
        this.fvs.add(varSymbol);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        if (jCVariableDecl.sym.owner.kind == Kinds.Kind.MTH) {
            this.seenVars.add(jCVariableDecl.sym);
        }
        super.visitVarDef(jCVariableDecl);
    }

    List<Symbol.VarSymbol> analyzeCaptures() {
        this.scan(this.tree);
        return List.from(this.fvs);
    }
}

