/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Iterator;

public class TypeAnnotationPosition {
    public static final List<TypePathEntry> emptyPath = List.nil();
    public final TargetType type;
    public List<TypePathEntry> location;
    public final int pos;
    public boolean isValidOffset = false;
    public int offset = -1;
    public int[] lvarOffset = null;
    public int[] lvarLength = null;
    public int[] lvarIndex = null;
    public final int bound_index;
    public int parameter_index;
    public final int type_index;
    private int exception_index = Integer.MIN_VALUE;
    private int exceptionStartPos = Integer.MIN_VALUE;
    public final JCTree.JCLambda onLambda;
    public static final TypeAnnotationPosition unknown = new TypeAnnotationPosition(TargetType.UNKNOWN, -1, Integer.MIN_VALUE, null, Integer.MIN_VALUE, Integer.MIN_VALUE, emptyPath);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append((Object)this.type);
        switch (this.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                stringBuilder.append(", offset = ");
                stringBuilder.append(this.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                if (this.lvarOffset == null) {
                    stringBuilder.append(", lvarOffset is null!");
                    break;
                }
                stringBuilder.append(", {");
                for (int i = 0; i < this.lvarOffset.length; ++i) {
                    if (i != 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append("start_pc = ");
                    stringBuilder.append(this.lvarOffset[i]);
                    stringBuilder.append(", length = ");
                    stringBuilder.append(this.lvarLength[i]);
                    stringBuilder.append(", index = ");
                    stringBuilder.append(this.lvarIndex[i]);
                }
                stringBuilder.append("}");
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                stringBuilder.append(", param_index = ");
                stringBuilder.append(this.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                stringBuilder.append(", param_index = ");
                stringBuilder.append(this.parameter_index);
                stringBuilder.append(", bound_index = ");
                stringBuilder.append(this.bound_index);
                break;
            }
            case CLASS_EXTENDS: {
                stringBuilder.append(", type_index = ");
                stringBuilder.append(this.type_index);
                break;
            }
            case THROWS: {
                stringBuilder.append(", type_index = ");
                stringBuilder.append(this.type_index);
                break;
            }
            case EXCEPTION_PARAMETER: {
                stringBuilder.append(", exception_index = ");
                stringBuilder.append(this.exception_index);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                stringBuilder.append(", param_index = ");
                stringBuilder.append(this.parameter_index);
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                stringBuilder.append(", offset = ");
                stringBuilder.append(this.offset);
                stringBuilder.append(", type_index = ");
                stringBuilder.append(this.type_index);
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                stringBuilder.append(", position UNKNOWN!");
                break;
            }
            default: {
                Assert.error("Unknown target type: " + (Object)((Object)this.type));
            }
        }
        if (!this.location.isEmpty()) {
            stringBuilder.append(", location = (");
            stringBuilder.append(this.location);
            stringBuilder.append(")");
        }
        stringBuilder.append(", pos = ");
        stringBuilder.append(this.pos);
        if (this.onLambda != null) {
            stringBuilder.append(", onLambda hash = ");
            stringBuilder.append(this.onLambda.hashCode());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public boolean emitToClassfile() {
        return !this.type.isLocal() || this.isValidOffset;
    }

    public boolean matchesPos(int n) {
        return this.pos == n;
    }

    public void updatePosOffset(int n) {
        this.offset = n;
        this.isValidOffset = true;
    }

    public boolean hasExceptionIndex() {
        return this.exception_index >= 0;
    }

    public int getExceptionIndex() {
        Assert.check(this.exception_index >= 0, "exception_index is not set");
        return this.exception_index;
    }

    public void setExceptionIndex(int n) {
        Assert.check(!this.hasExceptionIndex(), "exception_index already set");
        Assert.check(n >= 0, "Expected a valid index into exception table");
        this.exception_index = n;
        this.isValidOffset = true;
    }

    public boolean hasCatchType() {
        return this.exception_index < 0 && this.exception_index != Integer.MIN_VALUE;
    }

    public int getCatchType() {
        Assert.check(this.hasCatchType(), "exception_index does not contain valid catch info");
        return -this.exception_index - 1;
    }

    public int getStartPos() {
        Assert.check(this.exceptionStartPos >= 0, "exceptionStartPos does not contain valid start position");
        return this.exceptionStartPos;
    }

    public void setCatchInfo(int n, int n2) {
        Assert.check(!this.hasExceptionIndex(), "exception_index is already set");
        Assert.check(n >= 0, "Expected a valid catch type");
        Assert.check(n2 >= 0, "Expected a valid start position");
        this.exception_index = -(n + 1);
        this.exceptionStartPos = n2;
    }

    public static List<TypePathEntry> getTypePathFromBinary(java.util.List<Integer> list) {
        ListBuffer<TypePathEntry> listBuffer = new ListBuffer<TypePathEntry>();
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            Assert.check(iterator.hasNext());
            Integer n2 = iterator.next();
            listBuffer = listBuffer.append(TypePathEntry.fromBinary(n, n2));
        }
        return listBuffer.toList();
    }

    public static List<Integer> getBinaryFromTypePath(java.util.List<TypePathEntry> list) {
        ListBuffer<Object> listBuffer = new ListBuffer<Integer>();
        for (TypePathEntry typePathEntry : list) {
            listBuffer = listBuffer.append(typePathEntry.tag.tag);
            listBuffer = listBuffer.append(typePathEntry.arg);
        }
        return listBuffer.toList();
    }

    private TypeAnnotationPosition(TargetType targetType, int n, int n2, JCTree.JCLambda jCLambda, int n3, int n4, List<TypePathEntry> list) {
        Assert.checkNonNull(list);
        this.type = targetType;
        this.pos = n;
        this.parameter_index = n2;
        this.onLambda = jCLambda;
        this.type_index = n3;
        this.bound_index = n4;
        this.location = list;
    }

    public static TypeAnnotationPosition methodReturn(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.METHOD_RETURN, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodReturn(List<TypePathEntry> list) {
        return TypeAnnotationPosition.methodReturn(list, null, -1);
    }

    public static TypeAnnotationPosition methodReturn(int n) {
        return TypeAnnotationPosition.methodReturn(emptyPath, null, n);
    }

    public static TypeAnnotationPosition methodReceiver(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.METHOD_RECEIVER, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodReceiver(List<TypePathEntry> list) {
        return TypeAnnotationPosition.methodReceiver(list, null, -1);
    }

    public static TypeAnnotationPosition methodReceiver(int n) {
        return TypeAnnotationPosition.methodReceiver(emptyPath, null, n);
    }

    public static TypeAnnotationPosition methodParameter(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.METHOD_FORMAL_PARAMETER, n2, n, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodParameter(JCTree.JCLambda jCLambda, int n, int n2) {
        return TypeAnnotationPosition.methodParameter(emptyPath, jCLambda, n, n2);
    }

    public static TypeAnnotationPosition methodParameter(int n, int n2) {
        return TypeAnnotationPosition.methodParameter(null, n, n2);
    }

    public static TypeAnnotationPosition methodParameter(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.methodParameter(list, null, n, -1);
    }

    public static TypeAnnotationPosition methodRef(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.METHOD_REFERENCE, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodRef(List<TypePathEntry> list) {
        return TypeAnnotationPosition.methodRef(list, null, -1);
    }

    public static TypeAnnotationPosition constructorRef(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.CONSTRUCTOR_REFERENCE, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition constructorRef(List<TypePathEntry> list) {
        return TypeAnnotationPosition.constructorRef(list, null, -1);
    }

    public static TypeAnnotationPosition field(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.FIELD, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition field(List<TypePathEntry> list) {
        return TypeAnnotationPosition.field(list, null, -1);
    }

    public static TypeAnnotationPosition field(int n) {
        return TypeAnnotationPosition.field(emptyPath, null, n);
    }

    public static TypeAnnotationPosition localVariable(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.LOCAL_VARIABLE, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition localVariable(JCTree.JCLambda jCLambda, int n) {
        return TypeAnnotationPosition.localVariable(emptyPath, jCLambda, n);
    }

    public static TypeAnnotationPosition localVariable(List<TypePathEntry> list) {
        return TypeAnnotationPosition.localVariable(list, null, -1);
    }

    public static TypeAnnotationPosition exceptionParameter(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.EXCEPTION_PARAMETER, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition exceptionParameter(JCTree.JCLambda jCLambda, int n) {
        return TypeAnnotationPosition.exceptionParameter(emptyPath, jCLambda, n);
    }

    public static TypeAnnotationPosition exceptionParameter(List<TypePathEntry> list) {
        return TypeAnnotationPosition.exceptionParameter(list, null, -1);
    }

    public static TypeAnnotationPosition resourceVariable(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.RESOURCE_VARIABLE, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition resourceVariable(JCTree.JCLambda jCLambda, int n) {
        return TypeAnnotationPosition.resourceVariable(emptyPath, jCLambda, n);
    }

    public static TypeAnnotationPosition resourceVariable(List<TypePathEntry> list) {
        return TypeAnnotationPosition.resourceVariable(list, null, -1);
    }

    public static TypeAnnotationPosition newObj(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.NEW, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition newObj(int n) {
        return TypeAnnotationPosition.newObj(emptyPath, null, n);
    }

    public static TypeAnnotationPosition newObj(List<TypePathEntry> list) {
        return TypeAnnotationPosition.newObj(list, null, -1);
    }

    public static TypeAnnotationPosition classExtends(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.CLASS_EXTENDS, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition classExtends(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return TypeAnnotationPosition.classExtends(list, jCLambda, 65535, n);
    }

    public static TypeAnnotationPosition classExtends(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.classExtends(list, null, n, -1);
    }

    public static TypeAnnotationPosition classExtends(int n, int n2) {
        return TypeAnnotationPosition.classExtends(emptyPath, null, n, n2);
    }

    public static TypeAnnotationPosition classExtends(int n) {
        return TypeAnnotationPosition.classExtends(65535, n);
    }

    public static TypeAnnotationPosition instanceOf(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n) {
        return new TypeAnnotationPosition(TargetType.INSTANCEOF, n, Integer.MIN_VALUE, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition instanceOf(List<TypePathEntry> list) {
        return TypeAnnotationPosition.instanceOf(list, null, -1);
    }

    public static TypeAnnotationPosition typeCast(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.CAST, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition typeCast(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.typeCast(list, null, n, -1);
    }

    public static TypeAnnotationPosition methodInvocationTypeArg(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.METHOD_INVOCATION_TYPE_ARGUMENT, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodInvocationTypeArg(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.methodInvocationTypeArg(list, null, n, -1);
    }

    public static TypeAnnotationPosition constructorInvocationTypeArg(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition constructorInvocationTypeArg(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.constructorInvocationTypeArg(list, null, n, -1);
    }

    public static TypeAnnotationPosition typeParameter(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.CLASS_TYPE_PARAMETER, n2, n, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition typeParameter(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.typeParameter(list, null, n, -1);
    }

    public static TypeAnnotationPosition methodTypeParameter(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.METHOD_TYPE_PARAMETER, n2, n, jCLambda, Integer.MIN_VALUE, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodTypeParameter(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.methodTypeParameter(list, null, n, -1);
    }

    public static TypeAnnotationPosition methodThrows(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.THROWS, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodThrows(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.methodThrows(list, null, n, -1);
    }

    public static TypeAnnotationPosition methodRefTypeArg(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.METHOD_REFERENCE_TYPE_ARGUMENT, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition methodRefTypeArg(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.methodRefTypeArg(list, null, n, -1);
    }

    public static TypeAnnotationPosition constructorRefTypeArg(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2) {
        return new TypeAnnotationPosition(TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, n2, Integer.MIN_VALUE, jCLambda, n, Integer.MIN_VALUE, list);
    }

    public static TypeAnnotationPosition constructorRefTypeArg(List<TypePathEntry> list, int n) {
        return TypeAnnotationPosition.constructorRefTypeArg(list, null, n, -1);
    }

    public static TypeAnnotationPosition typeParameterBound(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2, int n3) {
        return new TypeAnnotationPosition(TargetType.CLASS_TYPE_PARAMETER_BOUND, n3, n, jCLambda, Integer.MIN_VALUE, n2, list);
    }

    public static TypeAnnotationPosition typeParameterBound(List<TypePathEntry> list, int n, int n2) {
        return TypeAnnotationPosition.typeParameterBound(list, null, n, n2, -1);
    }

    public static TypeAnnotationPosition methodTypeParameterBound(List<TypePathEntry> list, JCTree.JCLambda jCLambda, int n, int n2, int n3) {
        return new TypeAnnotationPosition(TargetType.METHOD_TYPE_PARAMETER_BOUND, n3, n, jCLambda, Integer.MIN_VALUE, n2, list);
    }

    public static TypeAnnotationPosition methodTypeParameterBound(List<TypePathEntry> list, int n, int n2) {
        return TypeAnnotationPosition.methodTypeParameterBound(list, null, n, n2, -1);
    }

    public static class TypePathEntry {
        public static final int bytesPerEntry = 2;
        public final TypePathEntryKind tag;
        public final int arg;
        public static final TypePathEntry ARRAY = new TypePathEntry(TypePathEntryKind.ARRAY);
        public static final TypePathEntry INNER_TYPE = new TypePathEntry(TypePathEntryKind.INNER_TYPE);
        public static final TypePathEntry WILDCARD = new TypePathEntry(TypePathEntryKind.WILDCARD);

        private TypePathEntry(TypePathEntryKind typePathEntryKind) {
            Assert.check(typePathEntryKind == TypePathEntryKind.ARRAY || typePathEntryKind == TypePathEntryKind.INNER_TYPE || typePathEntryKind == TypePathEntryKind.WILDCARD);
            this.tag = typePathEntryKind;
            this.arg = 0;
        }

        public TypePathEntry(TypePathEntryKind typePathEntryKind, int n) {
            Assert.check(typePathEntryKind == TypePathEntryKind.TYPE_ARGUMENT);
            this.tag = typePathEntryKind;
            this.arg = n;
        }

        public static TypePathEntry fromBinary(int n, int n2) {
            Assert.check(n2 == 0 || n == TypePathEntryKind.TYPE_ARGUMENT.tag);
            switch (n) {
                case 0: {
                    return ARRAY;
                }
                case 1: {
                    return INNER_TYPE;
                }
                case 2: {
                    return WILDCARD;
                }
                case 3: {
                    return new TypePathEntry(TypePathEntryKind.TYPE_ARGUMENT, n2);
                }
            }
            Assert.error("Invalid TypePathEntryKind tag: " + n);
            return null;
        }

        public String toString() {
            return this.tag.toString() + (this.tag == TypePathEntryKind.TYPE_ARGUMENT ? "(" + this.arg + ")" : "");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof TypePathEntry)) return false;
            TypePathEntry typePathEntry = (TypePathEntry)object;
            if (this.tag != typePathEntry.tag) return false;
            if (this.arg != typePathEntry.arg) return false;
            return true;
        }

        public int hashCode() {
            return this.tag.hashCode() * 17 + this.arg;
        }
    }

    public static enum TypePathEntryKind {
        ARRAY(0),
        INNER_TYPE(1),
        WILDCARD(2),
        TYPE_ARGUMENT(3);

        public final int tag;

        private TypePathEntryKind(int n2) {
            this.tag = n2;
        }
    }
}

