/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class Preview {
    private final boolean enabled;
    private final boolean verbose;
    private final MandatoryWarningHandler previewHandler;
    private final boolean forcePreview;
    private final Map<Integer, Source> majorVersionToSource;
    private final Set<JavaFileObject> sourcesWithPreviewFeatures = new HashSet<JavaFileObject>();
    private final Names names;
    private final Log log;
    private final Source source;
    protected static final Context.Key<Preview> previewKey = new Context.Key();

    public static Preview instance(Context context) {
        Preview preview = context.get(previewKey);
        if (preview == null) {
            preview = new Preview(context);
        }
        return preview;
    }

    protected Preview(Context context) {
        context.put(previewKey, this);
        Options options = Options.instance(context);
        this.names = Names.instance(context);
        this.enabled = options.isSet(Option.PREVIEW);
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.verbose = Lint.instance(context).isEnabled(Lint.LintCategory.PREVIEW);
        this.previewHandler = new MandatoryWarningHandler(this.log, this.source, this.verbose, true, Lint.LintCategory.PREVIEW);
        this.forcePreview = options.isSet("forcePreview");
        this.majorVersionToSource = this.initMajorVersionToSourceMap();
    }

    private Map<Integer, Source> initMajorVersionToSourceMap() {
        HashMap<Integer, Source> hashMap = new HashMap<Integer, Source>();
        for (Target target : Target.values()) {
            int n = target.majorVersion;
            Source source = Source.lookup(target.name);
            if (source == null) continue;
            hashMap.put(n, source);
        }
        return hashMap;
    }

    public boolean participatesInPreview(Symtab symtab, Symbol symbol, Symbol symbol2) {
        if (symbol2.packge().modle == symbol.packge().modle) {
            return true;
        }
        return this.participatesInPreview(symtab, symbol.packge().modle);
    }

    public boolean participatesInPreview(Symtab symtab, Symbol.ModuleSymbol moduleSymbol) {
        return symtab.java_base.exports.stream().filter(exportsDirective -> exportsDirective.packge.fullname == this.names.jdk_internal_javac).anyMatch(exportsDirective -> exportsDirective.modules.contains(moduleSymbol));
    }

    public void warnPreview(int n, Source.Feature feature) {
        this.warnPreview(new JCDiagnostic.SimpleDiagnosticPosition(n), feature);
    }

    public void warnPreview(JCDiagnostic.DiagnosticPosition diagnosticPosition, Source.Feature feature) {
        Assert.check(this.isEnabled());
        Assert.check(this.isPreview(feature));
        this.markUsesPreview(diagnosticPosition);
        this.previewHandler.report(diagnosticPosition, feature.isPlural() ? CompilerProperties.LintWarnings.PreviewFeatureUsePlural(feature.nameFragment()) : CompilerProperties.LintWarnings.PreviewFeatureUse(feature.nameFragment()));
    }

    public void warnPreview(JavaFileObject javaFileObject, int n) {
        Assert.check(this.isEnabled());
        if (this.verbose) {
            this.log.mandatoryWarning(null, CompilerProperties.LintWarnings.PreviewFeatureUseClassfile(javaFileObject, this.majorVersionToSource.get((Object)Integer.valueOf((int)n)).name));
        }
    }

    public void markUsesPreview(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.sourcesWithPreviewFeatures.add(this.log.currentSourceFile());
    }

    public void reportPreviewWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.LintWarning lintWarning) {
        this.previewHandler.report(diagnosticPosition, lintWarning);
    }

    public boolean usesPreview(JavaFileObject javaFileObject) {
        return this.sourcesWithPreviewFeatures.contains(javaFileObject);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPreview(Source.Feature feature) {
        boolean bl;
        switch (feature) {
            case PRIMITIVE_PATTERNS: {
                bl = true;
                break;
            }
            default: {
                bl = this.forcePreview;
            }
        }
        return bl;
    }

    public JCDiagnostic.Error disabledError(Source.Feature feature) {
        Assert.check(!this.isEnabled());
        return feature.isPlural() ? CompilerProperties.Errors.PreviewFeatureDisabledPlural(feature.nameFragment()) : CompilerProperties.Errors.PreviewFeatureDisabled(feature.nameFragment());
    }

    public JCDiagnostic.Error disabledError(JavaFileObject javaFileObject, int n) {
        Assert.check(!this.isEnabled());
        return CompilerProperties.Errors.PreviewFeatureDisabledClassfile(javaFileObject, this.majorVersionToSource.get((Object)Integer.valueOf((int)n)).name);
    }

    public boolean declaredUsingPreviewFeature(Symbol symbol) {
        return false;
    }

    public void reportDeferredDiagnostics() {
        this.previewHandler.reportDeferredDiagnostic();
    }

    public void clear() {
        this.previewHandler.clear();
    }

    public void checkSourceLevel(JCDiagnostic.DiagnosticPosition diagnosticPosition, Source.Feature feature) {
        if (this.isPreview(feature) && !this.isEnabled()) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, diagnosticPosition, this.disabledError(feature));
        } else {
            if (!feature.allowedInSource(this.source)) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, diagnosticPosition, feature.error(this.source.name));
            }
            if (this.isEnabled() && this.isPreview(feature)) {
                this.warnPreview(diagnosticPosition, feature);
            }
        }
    }
}

