/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final Context context;
    private final Options options;
    private final Log log;
    private Symtab syms;
    private Names names;
    private EnumSet<LintCategory> values;
    private EnumSet<LintCategory> suppressedValues;
    private static final Map<String, LintCategory> map = new LinkedHashMap<String, LintCategory>(40);

    public static Lint instance(Context context) {
        Lint lint = context.get(lintKey);
        if (lint == null) {
            lint = new Lint(context);
        }
        return lint;
    }

    public Lint augment(Symbol symbol) {
        EnumSet<LintCategory> enumSet = this.suppressionsFrom(symbol);
        if (!enumSet.isEmpty()) {
            Lint lint = new Lint(this);
            lint.values.removeAll(enumSet);
            lint.suppressedValues.addAll(enumSet);
            return lint;
        }
        return this;
    }

    public Lint enable(LintCategory ... lintCategoryArray) {
        Lint lint = new Lint(this);
        lint.values.addAll(Arrays.asList(lintCategoryArray));
        lint.suppressedValues.removeAll(Arrays.asList(lintCategoryArray));
        return lint;
    }

    public Lint suppress(LintCategory ... lintCategoryArray) {
        Lint lint = new Lint(this);
        lint.values.removeAll(Arrays.asList(lintCategoryArray));
        lint.suppressedValues.addAll(Arrays.asList(lintCategoryArray));
        return lint;
    }

    protected Lint(Context context) {
        this.context = context;
        context.put(lintKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
    }

    protected Lint(Lint lint) {
        lint.initializeRootIfNeeded();
        this.context = lint.context;
        this.options = lint.options;
        this.log = lint.log;
        this.syms = lint.syms;
        this.names = lint.names;
        this.values = lint.values.clone();
        this.suppressedValues = lint.suppressedValues.clone();
    }

    private void initializeRootIfNeeded() {
        if (this.values != null) {
            return;
        }
        if (this.options.isSet(Option.XLINT) || this.options.isSet(Option.XLINT_CUSTOM, "all")) {
            this.values = EnumSet.allOf(LintCategory.class);
        } else if (this.options.isSet(Option.XLINT_CUSTOM, "none")) {
            this.values = LintCategory.newEmptySet();
        } else {
            this.values = LintCategory.newEmptySet();
            Source object = Source.instance(this.context);
            if (object.compareTo(Source.JDK9) >= 0) {
                this.values.add(LintCategory.DEP_ANN);
            }
            if (Source.Feature.REDUNDANT_STRICTFP.allowedInSource(object)) {
                this.values.add(LintCategory.STRICTFP);
            }
            this.values.add(LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC);
            this.values.add(LintCategory.OPENS);
            this.values.add(LintCategory.MODULE);
            this.values.add(LintCategory.REMOVAL);
            if (!this.options.isSet(Option.PREVIEW)) {
                this.values.add(LintCategory.PREVIEW);
            }
            this.values.add(LintCategory.IDENTITY);
            this.values.add(LintCategory.INCUBATING);
        }
        for (LintCategory lintCategory : LintCategory.values()) {
            if (this.options.isExplicitlyEnabled(Option.XLINT, lintCategory)) {
                this.values.add(lintCategory);
                continue;
            }
            if (!this.options.isExplicitlyDisabled(Option.XLINT, lintCategory)) continue;
            this.values.remove((Object)lintCategory);
        }
        this.suppressedValues = LintCategory.newEmptySet();
    }

    public String toString() {
        this.initializeRootIfNeeded();
        return "Lint:[enable" + this.values + ",suppress" + this.suppressedValues + "]";
    }

    public boolean isEnabled(LintCategory lintCategory) {
        this.initializeRootIfNeeded();
        return this.values.contains((Object)lintCategory);
    }

    public boolean isSuppressed(LintCategory lintCategory) {
        this.initializeRootIfNeeded();
        return this.suppressedValues.contains((Object)lintCategory);
    }

    public void logIfEnabled(JCDiagnostic.LintWarning lintWarning) {
        this.logIfEnabled(null, lintWarning);
    }

    public void logIfEnabled(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.LintWarning lintWarning) {
        if (this.isEnabled(lintWarning.getLintCategory())) {
            this.log.warning(diagnosticPosition, (JCDiagnostic.Warning)lintWarning);
        }
    }

    public EnumSet<LintCategory> suppressionsFrom(Symbol symbol) {
        EnumSet<LintCategory> enumSet = this.suppressionsFrom(symbol.getDeclarationAttributes().stream());
        if (symbol.isDeprecated() && symbol.isDeprecatableViaAnnotation()) {
            enumSet.add(LintCategory.DEPRECATION);
        }
        return enumSet;
    }

    private EnumSet<LintCategory> suppressionsFrom(Stream<Attribute.Compound> stream) {
        this.initializeSymbolsIfNeeded();
        EnumSet<LintCategory> enumSet = LintCategory.newEmptySet();
        stream.filter(compound -> compound.type.tsym == this.syms.suppressWarningsType.tsym).map(this::suppressionsFrom).forEach(enumSet::addAll);
        return enumSet;
    }

    private EnumSet<LintCategory> suppressionsFrom(Attribute.Compound compound) {
        EnumSet<LintCategory> enumSet = LintCategory.newEmptySet();
        Attribute.Array array = (Attribute.Array)compound.member(this.names.value);
        for (Attribute attribute : array.values) {
            Optional.of((String)((Attribute.Constant)attribute).value).flatMap(LintCategory::get).filter(lintCategory -> lintCategory.annotationSuppression).ifPresent(enumSet::add);
        }
        return enumSet;
    }

    private void initializeSymbolsIfNeeded() {
        if (this.syms == null) {
            this.syms = Symtab.instance(this.context);
            this.names = Names.instance(this.context);
        }
    }

    public static enum LintCategory {
        AUXILIARYCLASS("auxiliaryclass"),
        CAST("cast"),
        CLASSFILE("classfile", false, new String[0]),
        DANGLING_DOC_COMMENTS("dangling-doc-comments"),
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann"),
        DIVZERO("divzero"),
        EMPTY("empty"),
        EXPORTS("exports"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        IDENTITY("identity", true, "synchronization"),
        INCUBATING("incubating", false, new String[0]),
        LOSSY_CONVERSIONS("lossy-conversions"),
        MISSING_EXPLICIT_CTOR("missing-explicit-ctor"),
        MODULE("module"),
        OPENS("opens"),
        OPTIONS("options", false, new String[0]),
        OUTPUT_FILE_CLASH("output-file-clash", false, new String[0]),
        OVERLOADS("overloads"),
        OVERRIDES("overrides"),
        PATH("path", false, new String[0]),
        PROCESSING("processing"),
        RAW("rawtypes"),
        REMOVAL("removal"),
        REQUIRES_AUTOMATIC("requires-automatic"),
        REQUIRES_TRANSITIVE_AUTOMATIC("requires-transitive-automatic"),
        SERIAL("serial"),
        STATIC("static"),
        STRICTFP("strictfp"),
        TEXT_BLOCKS("text-blocks", false, new String[0]),
        THIS_ESCAPE("this-escape"),
        TRY("try"),
        UNCHECKED("unchecked"),
        VARARGS("varargs"),
        PREVIEW("preview"),
        RESTRICTED("restricted");

        public final String option;
        public final List<String> optionList;
        public final boolean annotationSuppression;

        private LintCategory(String string2) {
            this(string2, true, new String[0]);
        }

        private LintCategory(String string3, boolean bl, String ... stringArray) {
            this.option = string3;
            this.annotationSuppression = bl;
            ArrayList<String> arrayList = new ArrayList<String>(1 + stringArray.length);
            arrayList.add(string3);
            Collections.addAll(arrayList, stringArray);
            this.optionList = Collections.unmodifiableList(arrayList);
            this.optionList.forEach(string -> map.put(string, this));
        }

        public static Optional<LintCategory> get(String string) {
            return Optional.ofNullable((LintCategory)((Object)map.get(string)));
        }

        public static Set<String> options() {
            return Collections.unmodifiableSet(map.keySet());
        }

        public static EnumSet<LintCategory> newEmptySet() {
            return EnumSet.noneOf(LintCategory.class);
        }
    }
}

