/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import nbjavac.VMWrapper;

public class DeferredLintHandler {
    protected static final Context.Key<DeferredLintHandler> deferredLintHandlerKey = new Context.Key();
    private final HashMap<JCTree, ArrayList<LintLogger>> deferralMap = new HashMap();
    private final ArrayDeque<Consumer<LintLogger>> reporterStack = new ArrayDeque();

    public static DeferredLintHandler instance(Context context) {
        DeferredLintHandler deferredLintHandler = context.get(deferredLintHandlerKey);
        if (deferredLintHandler == null) {
            deferredLintHandler = new DeferredLintHandler(context);
        }
        return deferredLintHandler;
    }

    protected DeferredLintHandler(Context context) {
        context.put(deferredLintHandlerKey, this);
        Lint lint = Lint.instance(context);
        this.pushImmediate(lint);
    }

    public void push(JCTree jCTree) {
        Assert.check(jCTree.getTag() == JCTree.Tag.MODULEDEF || jCTree.getTag() == JCTree.Tag.PACKAGEDEF || jCTree.getTag() == JCTree.Tag.CLASSDEF || jCTree.getTag() == JCTree.Tag.METHODDEF || jCTree.getTag() == JCTree.Tag.VARDEF);
        this.reporterStack.push(lintLogger -> this.deferralMap.computeIfAbsent(jCTree, jCTree -> new ArrayList()).add(lintLogger));
    }

    public void pushImmediate(Lint lint) {
        this.reporterStack.push(lintLogger -> lintLogger.report(lint));
    }

    public void pop() {
        Assert.check(this.reporterStack.size() > 1);
        this.reporterStack.pop();
    }

    public void report(LintLogger lintLogger) {
        Assert.check(!this.reporterStack.isEmpty());
        this.reporterStack.peek().accept(lintLogger);
    }

    public void flush(JCTree jCTree, Lint lint) {
        VMWrapper.optional2Stream(Optional.of(jCTree).map(this.deferralMap::remove)).flatMap(Collection::stream).forEach(lintLogger -> lintLogger.report(lint));
    }

    public static interface LintLogger {
        public void report(Lint var1);
    }
}

