/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Map;

public class DeferredCompletionFailureHandler {
    protected static final Context.Key<DeferredCompletionFailureHandler> deferredCompletionFailureHandlerKey = new Context.Key();
    public final Handler userCodeHandler = new Handler(){
        private final Map<Symbol.ClassSymbol, FlipSymbolDescription> class2Flip = new HashMap<Symbol.ClassSymbol, FlipSymbolDescription>();

        @Override
        public void install() {
            this.class2Flip.values().forEach(flipSymbolDescription -> flipSymbolDescription.flip());
        }

        @Override
        public void handleAPICompletionFailure(Symbol.CompletionFailure completionFailure) {
        }

        @Override
        public void classSymbolCompleteFailed(Symbol.ClassSymbol classSymbol, Symbol.Completer completer) {
            this.class2Flip.put(classSymbol, new FlipSymbolDescription(classSymbol, new DeferredCompleter(completer){

                @Override
                public void complete(Symbol symbol) throws Symbol.CompletionFailure {
                    class2Flip.remove(symbol);
                    super.complete(symbol);
                }
            }));
        }

        @Override
        public void classSymbolRemoved(Symbol.ClassSymbol classSymbol) {
            this.class2Flip.remove(classSymbol);
        }

        @Override
        public void uninstall() {
            this.class2Flip.values().forEach(flipSymbolDescription -> flipSymbolDescription.flip());
        }
    };
    public final Handler speculativeCodeHandler = new Handler(){
        private final Map<Symbol.ClassSymbol, FlipSymbolDescription> class2Flip = new HashMap<Symbol.ClassSymbol, FlipSymbolDescription>();

        @Override
        public void install() {
        }

        @Override
        public void handleAPICompletionFailure(Symbol.CompletionFailure completionFailure) {
            throw completionFailure;
        }

        @Override
        public void classSymbolCompleteFailed(Symbol.ClassSymbol classSymbol, Symbol.Completer completer) {
            this.class2Flip.put(classSymbol, new FlipSymbolDescription(classSymbol, new DeferredCompleter(completer)));
        }

        @Override
        public void classSymbolRemoved(Symbol.ClassSymbol classSymbol) {
            this.class2Flip.remove(classSymbol);
        }

        @Override
        public void uninstall() {
            this.class2Flip.values().forEach(flipSymbolDescription -> flipSymbolDescription.flip());
            this.class2Flip.clear();
        }
    };
    public final Handler javacCodeHandler;
    private Handler handler = this.javacCodeHandler = new Handler(){

        @Override
        public void install() {
        }

        @Override
        public void handleAPICompletionFailure(Symbol.CompletionFailure completionFailure) {
            throw completionFailure;
        }

        @Override
        public void classSymbolCompleteFailed(Symbol.ClassSymbol classSymbol, Symbol.Completer completer) {
        }

        @Override
        public void classSymbolRemoved(Symbol.ClassSymbol classSymbol) {
        }

        @Override
        public void uninstall() {
        }
    };

    public static DeferredCompletionFailureHandler instance(Context context) {
        DeferredCompletionFailureHandler deferredCompletionFailureHandler = context.get(deferredCompletionFailureHandlerKey);
        if (deferredCompletionFailureHandler == null) {
            deferredCompletionFailureHandler = new DeferredCompletionFailureHandler(context);
        }
        return deferredCompletionFailureHandler;
    }

    protected DeferredCompletionFailureHandler(Context context) {
        context.put(deferredCompletionFailureHandlerKey, this);
    }

    public Handler setHandler(Handler handler) {
        if (handler == this.handler) {
            return this.handler;
        }
        this.handler.uninstall();
        Handler handler2 = this.handler;
        this.handler = handler;
        this.handler.install();
        return handler2;
    }

    public void handleAPICompletionFailure(Symbol.CompletionFailure completionFailure) {
        this.handler.handleAPICompletionFailure(completionFailure);
    }

    public void classSymbolCompleteFailed(Symbol.ClassSymbol classSymbol, Symbol.Completer completer) {
        this.handler.classSymbolCompleteFailed(classSymbol, completer);
    }

    public void classSymbolRemoved(Symbol.ClassSymbol classSymbol) {
        this.handler.classSymbolRemoved(classSymbol);
    }

    public boolean isDeferredCompleter(Symbol.Completer completer) {
        return completer instanceof DeferredCompleter;
    }

    public static interface Handler {
        public void install();

        public void handleAPICompletionFailure(Symbol.CompletionFailure var1);

        public void classSymbolCompleteFailed(Symbol.ClassSymbol var1, Symbol.Completer var2);

        public void classSymbolRemoved(Symbol.ClassSymbol var1);

        public void uninstall();
    }

    private class DeferredCompleter
    implements Symbol.Completer {
        private final Symbol.Completer origCompleter;

        public DeferredCompleter(Symbol.Completer completer) {
            this.origCompleter = completer;
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            this.origCompleter.complete(symbol);
        }
    }

    private static class FlipSymbolDescription {
        public final Symbol.ClassSymbol sym;
        public Type type;
        public Kinds.Kind kind;
        public Scope.WriteableScope members;
        public Symbol.Completer completer;

        public FlipSymbolDescription(Symbol.ClassSymbol classSymbol, Symbol.Completer completer) {
            this.sym = classSymbol;
            this.type = classSymbol.type;
            this.kind = classSymbol.kind;
            this.members = null;
            this.completer = completer;
        }

        public void flip() {
            Type type = this.sym.type;
            this.sym.type = this.type;
            this.type = type;
            Kinds.Kind kind = this.sym.kind;
            this.sym.kind = this.kind;
            this.kind = kind;
            Symbol.Completer completer = this.sym.completer;
            this.sym.completer = this.completer;
            this.completer = completer;
            Scope.WriteableScope writeableScope = this.sym.members_field;
            this.sym.members_field = this.members;
            this.members = writeableScope;
        }
    }
}

