/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.PropagatedException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends BasicJavacTask {
    private final Arguments args;
    private JavaCompiler compiler;
    private JavaFileManager fileManager;
    private DeferredCompletionFailureHandler dcfh;
    private Locale locale;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private final AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private ListBuffer<String> addModules = new ListBuffer();
    private boolean parsed = false;

    protected JavacTaskImpl(Context context) {
        super(context, true);
        this.args = Arguments.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.dcfh.setHandler(this.dcfh.userCodeHandler);
    }

    @Override
    public Boolean call() {
        return this.doCall().isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Main.Result doCall() {
        try {
            Pair<Main.Result, Throwable> pair = this.invocationHelper(() -> {
                this.prepareCompiler(false);
                if (this.compiler.errorCount() > 0) {
                    return Main.Result.ERROR;
                }
                this.compiler.compile(this.args.getFileObjects(), this.args.getClassNames(), this.processors, this.addModules);
                return this.compiler.errorCount() > 0 ? Main.Result.ERROR : Main.Result.OK;
            });
            if (pair.snd == null) {
                Main.Result result = (Main.Result)((Object)pair.fst);
                return result;
            }
            Main.Result result = pair.snd instanceof FatalError ? Main.Result.SYSERR : Main.Result.ABNORMAL;
            return result;
        }
        finally {
            try {
                this.cleanup();
            }
            catch (ClientCodeException clientCodeException) {
                throw new RuntimeException(clientCodeException.getCause());
            }
        }
    }

    @Override
    public void addModules(Iterable<String> iterable) {
        Objects.requireNonNull(iterable);
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        for (String string : iterable) {
            Objects.requireNonNull(string);
            this.addModules.add(string);
        }
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> iterable) {
        Objects.requireNonNull(iterable);
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = iterable;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Pair<T, Throwable> invocationHelper(Callable<T> callable) {
        DeferredCompletionFailureHandler.Handler handler = this.dcfh.setHandler(this.dcfh.javacCodeHandler);
        try {
            Pair<T, Object> pair = new Pair<T, Object>(callable.call(), null);
            return pair;
        }
        catch (FatalError fatalError) {
            Log log = Log.instance(this.context);
            Options options = Options.instance(this.context);
            log.printRawLines(fatalError.getMessage());
            if (fatalError.getCause() != null && options.isSet("dev")) {
                fatalError.getCause().printStackTrace(log.getWriter(Log.WriterKind.NOTICE));
            }
            Pair<Object, FatalError> pair = new Pair<Object, FatalError>(null, fatalError);
            return pair;
        }
        catch (AnnotationProcessingError | ClientCodeException throwable) {
            throw new RuntimeException(throwable.getCause());
        }
        catch (PropagatedException propagatedException) {
            throw propagatedException.getCause();
        }
        catch (IllegalStateException illegalStateException) {
            throw illegalStateException;
        }
        catch (Error | Exception throwable) {
            Object object;
            if (this.compiler == null || this.compiler.errorCount() == 0 || Options.instance(this.context).isSet("dev")) {
                object = Log.instance(this.context);
                ((Log)object).printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
                throwable.printStackTrace(((Log)object).getWriter(Log.WriterKind.NOTICE));
            }
            object = new Pair<Object, Throwable>(null, throwable);
            return object;
        }
        finally {
            this.dcfh.setHandler(handler);
        }
    }

    private void prepareCompiler(boolean bl) {
        if (this.used.getAndSet(true)) {
            if (this.compiler == null) {
                throw new PropagatedException(new IllegalStateException());
            }
        } else {
            this.args.validate();
            this.context.put(Locale.class, this.locale);
            JavacMessages javacMessages = this.context.get(JavacMessages.messagesKey);
            if (javacMessages != null && !javacMessages.getCurrentLocale().equals(this.locale)) {
                javacMessages.setCurrentLocale(this.locale);
            }
            this.initPlugins(this.args.getPluginOpts());
            this.initDocLint(this.args.getDocLintOpts());
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.compiler.genEndPos = true;
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            if (bl) {
                this.compiler.initProcessAnnotations(this.processors, this.args.getFileObjects(), this.args.getClassNames());
                for (JavaFileObject javaFileObject : this.args.getFileObjects()) {
                    this.notYetEntered.put(javaFileObject, null);
                }
                this.genList = new ListBuffer();
            }
        }
    }

    <T> String toString(Iterable<T> iterable, String string) {
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : iterable) {
            stringBuilder.append(string2);
            stringBuilder.append(t.toString());
            string2 = string;
        }
        return stringBuilder.toString();
    }

    void cleanup() {
        JavaFileManager javaFileManager;
        if (this.compiler != null) {
            this.compiler.close();
        }
        if ((javaFileManager = this.fileManager) instanceof BaseFileManager) {
            BaseFileManager baseFileManager = (BaseFileManager)javaFileManager;
            if (baseFileManager.autoClose) {
                try {
                    this.fileManager.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.compiler = null;
        this.context = null;
        this.notYetEntered = null;
    }

    @Override
    public Iterable<? extends CompilationUnitTree> parse() {
        Pair<Iterable, Throwable> pair = this.invocationHelper(this::parseInternal);
        if (pair.snd == null) {
            return (Iterable)pair.fst;
        }
        throw new IllegalStateException((Throwable)pair.snd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends CompilationUnitTree> parseInternal() {
        try {
            this.prepareCompiler(true);
            List<JCTree.JCCompilationUnit> list = this.compiler.parseFiles(this.args.getFileObjects());
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                JavaFileObject javaFileObject = jCCompilationUnit.getSourceFile();
                if (!this.notYetEntered.containsKey(javaFileObject)) continue;
                this.notYetEntered.put(javaFileObject, jCCompilationUnit);
            }
            List<JCTree.JCCompilationUnit> list2 = list;
            return list2;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends Element> enter() {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> enter(Iterable<? extends CompilationUnitTree> iterable) {
        Object object;
        if (iterable == null && this.notYetEntered != null && this.notYetEntered.isEmpty()) {
            return List.nil();
        }
        boolean bl = this.compiler != null;
        this.prepareCompiler(true);
        ListBuffer<JCTree.JCCompilationUnit> listBuffer = null;
        if (iterable == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parseInternal();
                }
                for (JavaFileObject object2 : this.args.getFileObjects()) {
                    object = this.notYetEntered.remove(object2);
                    if (object == null) continue;
                    if (listBuffer == null) {
                        listBuffer = new ListBuffer();
                    }
                    listBuffer.append((JCTree.JCCompilationUnit)object);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : iterable) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    object = (JCTree.JCCompilationUnit)compilationUnitTree;
                    if (listBuffer == null) {
                        listBuffer = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    listBuffer.append((JCTree.JCCompilationUnit)object);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (listBuffer == null) {
            if (iterable == null && !bl) {
                this.compiler.initModules(List.nil());
            }
            return List.nil();
        }
        List<JCTree.JCCompilationUnit> list = this.compiler.initModules(listBuffer.toList());
        try {
            list = this.compiler.enterTrees(list);
            if (this.notYetEntered.isEmpty()) {
                this.compiler.processAnnotations(list);
            }
            ListBuffer<Symbol.TypeSymbol> listBuffer2 = new ListBuffer<Symbol.TypeSymbol>();
            for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
                boolean bl2 = jCCompilationUnit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
                if (bl2) {
                    listBuffer2.append(jCCompilationUnit.packge);
                    continue;
                }
                for (JCTree jCTree : jCCompilationUnit.defs) {
                    JCTree jCTree2;
                    if (jCTree.hasTag(JCTree.Tag.CLASSDEF)) {
                        jCTree2 = (JCTree.JCClassDecl)jCTree;
                        if (jCTree2.sym == null) continue;
                        listBuffer2.append(jCTree2.sym);
                        continue;
                    }
                    if (!jCTree.hasTag(JCTree.Tag.MODULEDEF)) continue;
                    jCTree2 = (JCTree.JCModuleDecl)jCTree;
                    if (((JCTree.JCModuleDecl)jCTree2).sym == null) continue;
                    listBuffer2.append(((JCTree.JCModuleDecl)jCTree2).sym);
                }
            }
            object = listBuffer2.toList();
            return object;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    @Override
    public Iterable<? extends Element> analyze() {
        Pair<Iterable, Throwable> pair = this.invocationHelper(() -> this.analyze(null));
        if (pair.snd == null) {
            return (Iterable)pair.fst;
        }
        throw new IllegalStateException((Throwable)pair.snd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends Element> iterable) {
        this.enter(null);
        final ListBuffer<Element> listBuffer = new ListBuffer<Element>();
        try {
            if (iterable == null) {
                this.handleFlowResults(this.compiler.warn(this.compiler.flow(this.compiler.attribute(this.compiler.todo))), listBuffer);
            } else {
                Filter filter = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.warn(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env))), listBuffer);
                    }
                };
                filter.run(this.compiler.todo, iterable);
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return listBuffer;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> listBuffer) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case CLASSDEF: {
                    JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)env.tree;
                    if (jCClassDecl.sym == null) break;
                    listBuffer.append(jCClassDecl.sym);
                    break;
                }
                case MODULEDEF: {
                    JCTree.JCModuleDecl jCModuleDecl = (JCTree.JCModuleDecl)env.tree;
                    if (jCModuleDecl.sym == null) break;
                    listBuffer.append(jCModuleDecl.sym);
                    break;
                }
                case PACKAGEDEF: {
                    JCTree.JCCompilationUnit jCCompilationUnit = env.toplevel;
                    if (jCCompilationUnit.packge == null) break;
                    listBuffer.append(jCCompilationUnit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() {
        Pair<Iterable, Throwable> pair = this.invocationHelper(() -> this.generate(null));
        if (pair.snd == null) {
            return (Iterable)pair.fst;
        }
        throw new IllegalStateException((Throwable)pair.snd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends Element> iterable) {
        final ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (iterable == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), listBuffer);
                this.genList.clear();
            } else {
                Filter filter = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), listBuffer);
                    }
                };
                filter.run(this.genList, iterable);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.cleanup();
            }
        }
        finally {
            if (this.compiler != null) {
                this.compiler.log.flush();
            }
        }
        return listBuffer;
    }

    public void ensureEntered() {
        this.args.allowEmpty();
        this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String string, TypeElement typeElement) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject javaFileObject = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            CharBuffer charBuffer = CharBuffer.wrap((string + "\u0000").toCharArray(), 0, string.length());
            JavacParser javacParser = parserFactory.newParser(charBuffer, false, false, false);
            JCTree.JCExpression jCExpression = javacParser.parseType();
            Type type = attr.attribType((JCTree)jCExpression, (Symbol.TypeSymbol)((Object)typeElement));
            return type;
        }
        finally {
            this.compiler.log.useSource(javaFileObject);
        }
    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> queue, Iterable<? extends Element> iterable) {
            HashSet<Element> hashSet = new HashSet<Element>();
            for (Element object : iterable) {
                hashSet.add(object);
            }
            ListBuffer<Env<AttrContext>> listBuffer = new ListBuffer();
            while (queue.peek() != null) {
                Env<AttrContext> env = queue.remove();
                Symbol.TypeSymbol typeSymbol = null;
                if (env.tree.hasTag(JCTree.Tag.MODULEDEF)) {
                    typeSymbol = ((JCTree.JCModuleDecl)env.tree).sym;
                } else if (env.tree.hasTag(JCTree.Tag.PACKAGEDEF)) {
                    typeSymbol = env.toplevel.packge;
                } else {
                    Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                    if (classSymbol != null) {
                        typeSymbol = classSymbol.outermostClass();
                    }
                }
                if (typeSymbol != null && hashSet.contains(typeSymbol)) {
                    this.process(env);
                    continue;
                }
                listBuffer = listBuffer.append(env);
            }
            queue.addAll((Collection<Env<AttrContext>>)listBuffer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

