/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";

    private ToolProvider() {
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return (JavaCompiler)JavaCompiler.class.cast(((Supplier<Object>)() -> {
            try {
                JavaCompiler javaCompiler;
                try {
                    javaCompiler = ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
                }
                catch (Error error) {
                    javaCompiler = null;
                }
                if (javaCompiler == null) {
                    javaCompiler = Class.forName(systemJavaCompilerName).newInstance();
                }
                return JavaCompiler.class.cast(javaCompiler);
            }
            catch (Throwable throwable) {
                throw new Error(throwable);
            }
        }).get());
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return (DocumentationTool)DocumentationTool.class.cast(((Supplier<Object>)() -> {
            try {
                DocumentationTool documentationTool;
                try {
                    documentationTool = ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
                }
                catch (Error error) {
                    documentationTool = null;
                }
                if (documentationTool == null) {
                    documentationTool = Class.forName(systemDocumentationToolName).newInstance();
                }
                return DocumentationTool.class.cast(documentationTool);
            }
            catch (Throwable throwable) {
                throw new Error(throwable);
            }
        }).get());
    }

    @Deprecated
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String string, String string2) {
        try {
            ServiceLoader serviceLoader = ServiceLoaderWrapper.loadTool(clazz);
            for (Object s : serviceLoader) {
                if (!Objects.equals(ModuleWrapper.getModule(s.getClass()).getName(), string)) continue;
                return (T)s;
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new Error(serviceConfigurationError);
        }
        return null;
    }
}

