/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.tools.JavaFileManager;

public enum StandardLocation implements JavaFileManager.Location
{
    CLASS_OUTPUT,
    SOURCE_OUTPUT,
    CLASS_PATH,
    SOURCE_PATH,
    ANNOTATION_PROCESSOR_PATH,
    ANNOTATION_PROCESSOR_MODULE_PATH,
    PLATFORM_CLASS_PATH,
    NATIVE_HEADER_OUTPUT,
    MODULE_SOURCE_PATH,
    UPGRADE_MODULE_PATH,
    SYSTEM_MODULES,
    MODULE_PATH,
    PATCH_MODULE_PATH;

    private static final ConcurrentHashMap<String, JavaFileManager.Location> LOCATIONS;

    static final boolean computeIsModuleOrientedLocation(String string) {
        return LazyPatternHolder.MODULE_WORD_PATTERN.matcher(string).matches();
    }

    public static JavaFileManager.Location locationFor(final String string) {
        Objects.requireNonNull(string, "name");
        JavaFileManager.Location location = LOCATIONS.get(string);
        if (location != null) {
            return location;
        }
        JavaFileManager.Location location2 = null;
        Object object = StandardLocation.values();
        int n = ((StandardLocation[])object).length;
        for (int i = 0; i < n; i += 1) {
            StandardLocation standardLocation = object[i];
            if (!standardLocation.getName().equals(string)) continue;
            location2 = standardLocation;
            break;
        }
        if (location2 == null) {
            final boolean bl = string.endsWith("_OUTPUT");
            n = StandardLocation.computeIsModuleOrientedLocation(string) ? 1 : 0;
            location2 = new JavaFileManager.Location(){
                final /* synthetic */ boolean val$isModuleOrientedLocation;
                {
                    this.val$isModuleOrientedLocation = bl2;
                }

                @Override
                public String getName() {
                    return string;
                }

                @Override
                public boolean isOutputLocation() {
                    return bl;
                }

                @Override
                public boolean isModuleOrientedLocation() {
                    return this.val$isModuleOrientedLocation;
                }
            };
        }
        return (object = (JavaFileManager.Location)LOCATIONS.putIfAbsent(string, location2)) != null ? object : location2;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public boolean isOutputLocation() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isModuleOrientedLocation() {
        switch (this.ordinal()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    static {
        LOCATIONS = new ConcurrentHashMap();
    }

    private static class LazyPatternHolder {
        static final Pattern MODULE_WORD_PATTERN = Pattern.compile("\\bMODULE\\b");

        private LazyPatternHolder() {
        }
    }
}

