/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class SimpleJavaFileObject
implements JavaFileObject {
    protected final URI uri;
    protected final JavaFileObject.Kind kind;

    protected SimpleJavaFileObject(URI uRI, JavaFileObject.Kind kind) {
        Objects.requireNonNull(uRI);
        Objects.requireNonNull(kind);
        if (uRI.getPath() == null) {
            throw new IllegalArgumentException("URI must have a path: " + uRI);
        }
        this.uri = uRI;
        this.kind = kind;
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.toUri().getPath();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        CharBuffer charBuffer;
        CharSequence charSequence = this.getCharContent(bl);
        if (charSequence == null) {
            throw new UnsupportedOperationException();
        }
        if (charSequence instanceof CharBuffer && (charBuffer = (CharBuffer)charSequence).hasArray()) {
            return new CharArrayReader(charBuffer.array());
        }
        return new StringReader(charSequence.toString());
    }

    @Override
    public CharSequence getCharContent(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        String string2 = string + kind.extension;
        return kind.equals((Object)this.getKind()) && (string2.equals(this.toUri().getPath()) || this.toUri().getPath().endsWith("/" + string2));
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.toUri() + "]";
    }

    public static JavaFileObject forSource(URI uRI, final String string) {
        return new SimpleJavaFileObject(uRI, JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean bl) {
                return string;
            }
        };
    }
}

