/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model;

import nbjavac.RuntimeWR;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum SourceVersion {
    RELEASE_0,
    RELEASE_1,
    RELEASE_2,
    RELEASE_3,
    RELEASE_4,
    RELEASE_5,
    RELEASE_6,
    RELEASE_7,
    RELEASE_8,
    RELEASE_9,
    RELEASE_10,
    RELEASE_11,
    RELEASE_12,
    RELEASE_13,
    RELEASE_14,
    RELEASE_15,
    RELEASE_16,
    RELEASE_17,
    RELEASE_18,
    RELEASE_19,
    RELEASE_20,
    RELEASE_21,
    RELEASE_22,
    RELEASE_23,
    RELEASE_24,
    RELEASE_25;

    private static final SourceVersion latestSupported;

    public static SourceVersion latest() {
        return RELEASE_25;
    }

    private static SourceVersion getLatestSupported() {
        int n = "1.8".equals(System.getProperty("java.specification.version")) ? 8 : Integer.parseInt(System.getProperty("java.specification.version"));
        return n >= 11 ? SourceVersion.valueOf("RELEASE_" + Math.min(25, n)) : RELEASE_10;
    }

    public static SourceVersion latestSupported() {
        return latestSupported;
    }

    public static boolean isIdentifier(CharSequence charSequence) {
        String string = charSequence.toString();
        if (string.length() == 0) {
            return false;
        }
        int n = string.codePointAt(0);
        if (!Character.isJavaIdentifierStart(n)) {
            return false;
        }
        for (int i = Character.charCount(n); i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (Character.isJavaIdentifierPart(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isName(CharSequence charSequence) {
        return SourceVersion.isName(charSequence, SourceVersion.latest());
    }

    public static boolean isName(CharSequence charSequence, SourceVersion sourceVersion) {
        String string = charSequence.toString();
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2) && !SourceVersion.isKeyword(string2, sourceVersion)) continue;
            return false;
        }
        return true;
    }

    public static boolean isKeyword(CharSequence charSequence) {
        return SourceVersion.isKeyword(charSequence, SourceVersion.latest());
    }

    public static boolean isKeyword(CharSequence charSequence, SourceVersion sourceVersion) {
        String string;
        switch (string = charSequence.toString()) {
            case "strictfp": {
                return sourceVersion.compareTo(RELEASE_2) >= 0;
            }
            case "assert": {
                return sourceVersion.compareTo(RELEASE_4) >= 0;
            }
            case "enum": {
                return sourceVersion.compareTo(RELEASE_5) >= 0;
            }
            case "_": {
                return sourceVersion.compareTo(RELEASE_9) >= 0;
            }
            case "public": 
            case "protected": 
            case "private": 
            case "abstract": 
            case "static": 
            case "final": 
            case "transient": 
            case "volatile": 
            case "synchronized": 
            case "native": 
            case "class": 
            case "interface": 
            case "extends": 
            case "package": 
            case "throws": 
            case "implements": 
            case "boolean": 
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "void": 
            case "if": 
            case "else": 
            case "try": 
            case "catch": 
            case "finally": 
            case "do": 
            case "while": 
            case "for": 
            case "continue": 
            case "switch": 
            case "case": 
            case "default": 
            case "break": 
            case "throw": 
            case "return": 
            case "this": 
            case "new": 
            case "super": 
            case "import": 
            case "instanceof": 
            case "goto": 
            case "const": 
            case "null": 
            case "true": 
            case "false": {
                return true;
            }
        }
        return false;
    }

    public static SourceVersion valueOf(RuntimeWR.Version version) {
        return SourceVersion.valueOf("RELEASE_" + version.feature());
    }

    public RuntimeWR.Version runtimeVersion() {
        if (this.compareTo(RELEASE_6) >= 0) {
            return RuntimeWR.Version.parse((String)Integer.toString(this.ordinal()));
        }
        return null;
    }

    static {
        latestSupported = SourceVersion.getLatestSupported();
    }
}

