/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class TreePath
implements Iterable<Tree> {
    private CompilationUnitTree compilationUnit;
    private Tree leaf;
    private TreePath parent;

    public static TreePath getPath(CompilationUnitTree compilationUnitTree, Tree tree) {
        return TreePath.getPath(new TreePath(compilationUnitTree), tree);
    }

    public static TreePath getPath(TreePath treePath, Tree tree) {
        Objects.requireNonNull(treePath);
        Objects.requireNonNull(tree);
        class PathFinder
        extends TreePathScanner<TreePath, Tree> {
            private TreePath result;

            PathFinder() {
            }

            @Override
            public TreePath scan(TreePath treePath, Tree tree) {
                super.scan(treePath, tree);
                return this.result;
            }

            @Override
            public TreePath scan(Tree tree, Tree tree2) {
                if (this.result == null) {
                    if (tree == tree2) {
                        this.result = new TreePath(this.getCurrentPath(), tree2);
                    } else {
                        super.scan(tree, tree2);
                    }
                }
                return this.result;
            }

            @Override
            public TreePath scan(Iterable<? extends Tree> iterable, Tree tree) {
                if (iterable != null && this.result == null) {
                    for (Tree tree2 : iterable) {
                        this.scan(tree2, tree);
                        if (this.result == null) continue;
                        break;
                    }
                }
                return this.result;
            }
        }
        return treePath.getLeaf() == tree ? treePath : new PathFinder().scan(treePath, tree);
    }

    public TreePath(CompilationUnitTree compilationUnitTree) {
        this(null, compilationUnitTree);
    }

    public TreePath(TreePath treePath, Tree tree) {
        if (tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
            this.compilationUnit = (CompilationUnitTree)tree;
            this.parent = null;
        } else {
            this.compilationUnit = treePath.compilationUnit;
            this.parent = treePath;
        }
        this.leaf = tree;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this.compilationUnit;
    }

    public Tree getLeaf() {
        return this.leaf;
    }

    public TreePath getParentPath() {
        return this.parent;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new Iterator<Tree>(){
            private TreePath next;
            {
                this.next = TreePath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Tree next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Tree tree = this.next.leaf;
                this.next = this.next.parent;
                return tree;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

