/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.DocTypeTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.EscapeTree;
import com.sun.source.doctree.HiddenTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.RawTextTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.SnippetTree;
import com.sun.source.doctree.SpecTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.SummaryTree;
import com.sun.source.doctree.SystemPropertyTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;

public class DocTreeScanner<R, P>
implements DocTreeVisitor<R, P> {
    public R scan(DocTree docTree, P p) {
        return docTree == null ? null : (R)docTree.accept(this, p);
    }

    private R scanAndReduce(DocTree docTree, P p, R r) {
        return this.reduce(this.scan(docTree, p), r);
    }

    public R scan(Iterable<? extends DocTree> iterable, P p) {
        R r = null;
        if (iterable != null) {
            boolean bl = true;
            for (DocTree docTree : iterable) {
                r = (R)(bl ? this.scan(docTree, p) : this.scanAndReduce(docTree, p, r));
                bl = false;
            }
        }
        return r;
    }

    private R scanAndReduce(Iterable<? extends DocTree> iterable, P p, R r) {
        return this.reduce(this.scan(iterable, p), r);
    }

    public R reduce(R r, R r2) {
        return r;
    }

    @Override
    public R visitAttribute(AttributeTree attributeTree, P p) {
        return this.scan(attributeTree.getValue(), p);
    }

    @Override
    public R visitAuthor(AuthorTree authorTree, P p) {
        return this.scan(authorTree.getName(), p);
    }

    @Override
    public R visitComment(CommentTree commentTree, P p) {
        return null;
    }

    @Override
    public R visitDeprecated(DeprecatedTree deprecatedTree, P p) {
        return this.scan(deprecatedTree.getBody(), p);
    }

    @Override
    public R visitDocComment(DocCommentTree docCommentTree, P p) {
        R r = this.scan(docCommentTree.getFirstSentence(), p);
        r = this.scanAndReduce(docCommentTree.getBody(), p, r);
        r = this.scanAndReduce(docCommentTree.getBlockTags(), p, r);
        return r;
    }

    @Override
    public R visitDocRoot(DocRootTree docRootTree, P p) {
        return null;
    }

    @Override
    public R visitDocType(DocTypeTree docTypeTree, P p) {
        return null;
    }

    @Override
    public R visitEndElement(EndElementTree endElementTree, P p) {
        return null;
    }

    @Override
    public R visitEntity(EntityTree entityTree, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree erroneousTree, P p) {
        return null;
    }

    @Override
    public R visitEscape(EscapeTree escapeTree, P p) {
        return null;
    }

    @Override
    public R visitHidden(HiddenTree hiddenTree, P p) {
        return this.scan(hiddenTree.getBody(), p);
    }

    @Override
    public R visitIdentifier(IdentifierTree identifierTree, P p) {
        return null;
    }

    @Override
    public R visitIndex(IndexTree indexTree, P p) {
        R r = this.scan(indexTree.getSearchTerm(), p);
        r = this.scanAndReduce(indexTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitInheritDoc(InheritDocTree inheritDocTree, P p) {
        return this.scan(inheritDocTree.getSupertype(), p);
    }

    @Override
    public R visitLink(LinkTree linkTree, P p) {
        R r = this.scan(linkTree.getReference(), p);
        r = this.scanAndReduce(linkTree.getLabel(), p, r);
        return r;
    }

    @Override
    public R visitLiteral(LiteralTree literalTree, P p) {
        return this.scan(literalTree.getBody(), p);
    }

    @Override
    public R visitParam(ParamTree paramTree, P p) {
        R r = this.scan(paramTree.getName(), p);
        r = this.scanAndReduce(paramTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitProvides(ProvidesTree providesTree, P p) {
        R r = this.scan(providesTree.getServiceType(), p);
        r = this.scanAndReduce(providesTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitRawText(RawTextTree rawTextTree, P p) {
        return null;
    }

    @Override
    public R visitReference(ReferenceTree referenceTree, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree returnTree, P p) {
        return this.scan(returnTree.getDescription(), p);
    }

    @Override
    public R visitSee(SeeTree seeTree, P p) {
        return this.scan(seeTree.getReference(), p);
    }

    @Override
    public R visitSerial(SerialTree serialTree, P p) {
        return this.scan(serialTree.getDescription(), p);
    }

    @Override
    public R visitSerialData(SerialDataTree serialDataTree, P p) {
        return this.scan(serialDataTree.getDescription(), p);
    }

    @Override
    public R visitSerialField(SerialFieldTree serialFieldTree, P p) {
        R r = this.scan(serialFieldTree.getName(), p);
        r = this.scanAndReduce(serialFieldTree.getType(), p, r);
        r = this.scanAndReduce(serialFieldTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitSince(SinceTree sinceTree, P p) {
        return this.scan(sinceTree.getBody(), p);
    }

    @Override
    public R visitSnippet(SnippetTree snippetTree, P p) {
        R r = this.scan(snippetTree.getAttributes(), p);
        r = this.scanAndReduce(snippetTree.getBody(), p, r);
        return r;
    }

    @Override
    public R visitSpec(SpecTree specTree, P p) {
        R r = this.scan(specTree.getURL(), p);
        r = this.scanAndReduce(specTree.getTitle(), p, r);
        return r;
    }

    @Override
    public R visitStartElement(StartElementTree startElementTree, P p) {
        return this.scan(startElementTree.getAttributes(), p);
    }

    @Override
    public R visitSummary(SummaryTree summaryTree, P p) {
        return this.scan(summaryTree.getSummary(), p);
    }

    @Override
    public R visitSystemProperty(SystemPropertyTree systemPropertyTree, P p) {
        return null;
    }

    @Override
    public R visitText(TextTree textTree, P p) {
        return null;
    }

    @Override
    public R visitThrows(ThrowsTree throwsTree, P p) {
        R r = this.scan(throwsTree.getExceptionName(), p);
        r = this.scanAndReduce(throwsTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, P p) {
        return this.scan(unknownBlockTagTree.getContent(), p);
    }

    @Override
    public R visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, P p) {
        return this.scan(unknownInlineTagTree.getContent(), p);
    }

    @Override
    public R visitUses(UsesTree usesTree, P p) {
        R r = this.scan(usesTree.getServiceType(), p);
        r = this.scanAndReduce(usesTree.getDescription(), p, r);
        return r;
    }

    @Override
    public R visitValue(ValueTree valueTree, P p) {
        R r = this.scan(valueTree.getFormat(), p);
        r = this.scanAndReduce(valueTree.getReference(), p, r);
        return r;
    }

    @Override
    public R visitVersion(VersionTree versionTree, P p) {
        return this.scan(versionTree.getBody(), p);
    }

    @Override
    public R visitOther(DocTree docTree, P p) {
        return null;
    }
}

