/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final DiagnosticInfo diagnosticInfo;
    private final Set<DiagnosticFlag> flags;
    private SourcePosition sourcePosition;
    private final UnaryOperator<JCDiagnostic> rewriter;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String string, Object ... objectArray) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticInfo.of(DiagnosticType.FRAGMENT, null, "compiler", string, objectArray), EnumSet.noneOf(DiagnosticFlag.class), null, null);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter, DiagnosticInfo diagnosticInfo, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition) {
        this(diagnosticFormatter, diagnosticInfo, set, diagnosticSource, diagnosticPosition, null);
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter, DiagnosticInfo diagnosticInfo, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, UnaryOperator<JCDiagnostic> unaryOperator) {
        if (diagnosticSource == null && diagnosticPosition != null && diagnosticPosition.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = diagnosticFormatter;
        this.diagnosticInfo = diagnosticInfo;
        this.flags = set;
        this.source = diagnosticSource;
        this.position = diagnosticPosition;
        this.rewriter = unaryOperator;
    }

    public DiagnosticType getType() {
        return this.diagnosticInfo.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.flags.contains((Object)DiagnosticFlag.MANDATORY);
    }

    public boolean hasLintCategory() {
        return this.getLintCategory() != null;
    }

    public Lint.LintCategory getLintCategory() {
        Lint.LintCategory lintCategory;
        DiagnosticInfo diagnosticInfo = this.diagnosticInfo;
        if (diagnosticInfo instanceof LintWarning) {
            LintWarning lintWarning = (LintWarning)diagnosticInfo;
            lintCategory = lintWarning.category;
        } else {
            lintCategory = null;
        }
        return lintCategory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public DiagnosticPosition getDiagnosticPosition() {
        return this.position;
    }

    @Override
    public long getLineNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getColumnNumber();
    }

    public Object[] getArgs() {
        return this.diagnosticInfo.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.diagnosticInfo.type);
    }

    public String getPrefix(DiagnosticType diagnosticType) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.diagnosticInfo.type.ordinal()) {
            case 1: {
                return Diagnostic.Kind.NOTE;
            }
            case 2: {
                return this.flags.contains((Object)DiagnosticFlag.MANDATORY) ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case 3: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.diagnosticInfo.key();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public void setFlag(DiagnosticFlag diagnosticFlag) {
        this.flags.add(diagnosticFlag);
        if (this.diagnosticInfo.type == DiagnosticType.ERROR) {
            switch (diagnosticFlag.ordinal()) {
                case 2: {
                    this.flags.remove((Object)DiagnosticFlag.RECOVERABLE);
                    break;
                }
                case 1: {
                    this.flags.add(DiagnosticFlag.RECOVERABLE);
                }
            }
        }
    }

    public boolean isFlagSet(DiagnosticFlag diagnosticFlag) {
        return this.flags.contains((Object)diagnosticFlag);
    }

    boolean hasRewriter() {
        return this.rewriter != null;
    }

    JCDiagnostic rewrite() {
        return (JCDiagnostic)this.rewriter.apply(this);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String string2) {
            this.key = string2;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class DiagnosticInfo {
        DiagnosticType type;
        String prefix;
        String code;
        Object[] args;

        private DiagnosticInfo(DiagnosticType diagnosticType, String string, String string2, Object ... objectArray) {
            this.type = diagnosticType;
            this.prefix = string;
            this.code = string2;
            this.args = objectArray;
        }

        public String key() {
            return this.prefix + "." + this.type.key + "." + this.code;
        }

        public static DiagnosticInfo of(DiagnosticType diagnosticType, String string, String string2, Object ... objectArray) {
            return DiagnosticInfo.of(diagnosticType, null, string, string2, objectArray);
        }

        public static DiagnosticInfo of(DiagnosticType diagnosticType, Lint.LintCategory lintCategory, String string, String string2, Object ... objectArray) {
            switch (diagnosticType.ordinal()) {
                case 3: {
                    return new Error(string, string2, objectArray);
                }
                case 2: {
                    return lintCategory == null ? new Warning(string, string2, objectArray) : new LintWarning(lintCategory, string, string2, objectArray);
                }
                case 1: {
                    return new Note(string, string2, objectArray);
                }
                case 0: {
                    return new Fragment(string, string2, objectArray);
                }
            }
            Assert.error("Wrong diagnostic type: " + String.valueOf((Object)diagnosticType));
            return null;
        }

        public String getCode() {
            return this.code;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object[] objectArray) {
            this.args = objectArray;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum DiagnosticFlag {
        MANDATORY,
        RESOLVE_ERROR,
        SYNTAX,
        RECOVERABLE,
        NON_DEFERRABLE,
        COMPRESSED,
        API,
        SOURCE_LEVEL;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(EndPosTable var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class LintWarning
    extends Warning {
        final Lint.LintCategory category;

        public LintWarning(Lint.LintCategory lintCategory, String string, String string2, Object ... objectArray) {
            super(string, string2, objectArray);
            this.category = lintCategory;
        }

        public Lint.LintCategory getLintCategory() {
            return this.category;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class SourcePosition {
        private final int line;
        private final int column;

        SourcePosition() {
            int n;
            int n2 = n = JCDiagnostic.this.position == null ? -1 : JCDiagnostic.this.position.getPreferredPosition();
            if (n == -1 || JCDiagnostic.this.source == null) {
                this.column = -1;
                this.line = -1;
            } else {
                this.line = JCDiagnostic.this.source.getLineNumber(n);
                this.column = JCDiagnostic.this.source.getColumnNumber(n, true);
            }
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic jCDiagnostic, List<JCDiagnostic> list) {
            super(jCDiagnostic.defaultFormatter, jCDiagnostic.diagnosticInfo, jCDiagnostic.flags, jCDiagnostic.getDiagnosticSource(), jCDiagnostic.position);
            this.subdiagnostics = list;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record AnnotatedType(Type type) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Fragment
    extends DiagnosticInfo {
        public Fragment(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.FRAGMENT, string, string2, objectArray);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Note
    extends DiagnosticInfo {
        public Note(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.NOTE, string, string2, objectArray);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Warning
    extends DiagnosticInfo {
        public Warning(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.WARNING, string, string2, objectArray);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Error
    extends DiagnosticInfo {
        public Error(String string, String string2, Object ... objectArray) {
            super(DiagnosticType.ERROR, string, string2, objectArray);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int n) {
            this.pos = n;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            return this.pos;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;
        final Set<DiagnosticFlag> defaultErrorFlags;

        public static Factory instance(Context context) {
            Factory factory = context.get(diagnosticFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
            Options.instance(context).whenReady(this::initOptions);
        }

        private void initOptions(Options options) {
            if (options.isSet("onlySyntaxErrorsUnrecoverable")) {
                this.defaultErrorFlags.add(DiagnosticFlag.RECOVERABLE);
            }
        }

        public Factory(JavacMessages javacMessages, String string) {
            this.prefix = string;
            this.formatter = new BasicDiagnosticFormatter(javacMessages);
            this.defaultErrorFlags = EnumSet.of(DiagnosticFlag.MANDATORY);
        }

        public JCDiagnostic error(DiagnosticFlag diagnosticFlag, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.error(diagnosticFlag, diagnosticSource, diagnosticPosition, this.errorKey(string, objectArray));
        }

        public JCDiagnostic error(DiagnosticFlag diagnosticFlag, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Error error) {
            JCDiagnostic jCDiagnostic = this.create(EnumSet.copyOf(this.defaultErrorFlags), diagnosticSource, diagnosticPosition, error);
            if (diagnosticFlag != null) {
                jCDiagnostic.setFlag(diagnosticFlag);
            }
            return jCDiagnostic;
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.mandatoryWarning(diagnosticSource, diagnosticPosition, this.warningKey(lintCategory, string, objectArray));
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Warning warning) {
            return this.create(EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, diagnosticPosition, warning);
        }

        public JCDiagnostic warning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.warning(diagnosticSource, diagnosticPosition, this.warningKey(lintCategory, string, objectArray));
        }

        public JCDiagnostic warning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Warning warning) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, warning);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource diagnosticSource, String string, Object ... objectArray) {
            return this.mandatoryNote(diagnosticSource, this.noteKey(string, objectArray));
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource diagnosticSource, Note note) {
            return this.create(EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, null, note);
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.note(diagnosticSource, diagnosticPosition, this.noteKey(string, objectArray));
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, Note note) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, note);
        }

        public JCDiagnostic fragment(String string, Object ... objectArray) {
            return this.fragment(this.fragmentKey(string, objectArray));
        }

        public JCDiagnostic fragment(Fragment fragment) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), null, null, fragment);
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, DiagnosticInfo.of(diagnosticType, this.prefix, string, objectArray));
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, UnaryOperator<JCDiagnostic> unaryOperator, Object ... objectArray) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, DiagnosticInfo.of(diagnosticType, this.prefix, string, objectArray), unaryOperator);
        }

        public JCDiagnostic create(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, DiagnosticInfo diagnosticInfo) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, diagnosticInfo);
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, Lint.LintCategory lintCategory, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(set, diagnosticSource, diagnosticPosition, DiagnosticInfo.of(diagnosticType, lintCategory, this.prefix, string, objectArray));
        }

        public JCDiagnostic create(Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, DiagnosticInfo diagnosticInfo) {
            return new JCDiagnostic(this.formatter, this.normalize(diagnosticInfo), set, diagnosticSource, diagnosticPosition);
        }

        public JCDiagnostic create(Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, DiagnosticInfo diagnosticInfo, UnaryOperator<JCDiagnostic> unaryOperator) {
            return new JCDiagnostic(this.formatter, this.normalize(diagnosticInfo), set, diagnosticSource, diagnosticPosition, unaryOperator);
        }

        DiagnosticInfo normalize(DiagnosticInfo diagnosticInfo) {
            Lint.LintCategory lintCategory;
            if (diagnosticInfo instanceof LintWarning) {
                LintWarning lintWarning = (LintWarning)diagnosticInfo;
                lintCategory = lintWarning.category;
            } else {
                lintCategory = null;
            }
            Lint.LintCategory lintCategory2 = lintCategory;
            return DiagnosticInfo.of(diagnosticInfo.type, lintCategory2, diagnosticInfo.prefix, diagnosticInfo.code, Stream.of(diagnosticInfo.args).map(object -> {
                Object object2;
                if (object instanceof Fragment) {
                    Fragment fragment = (Fragment)object;
                    object2 = this.fragment(fragment);
                } else {
                    object2 = object;
                }
                return object2;
            }).toArray());
        }

        public Error errorKey(String string, Object ... objectArray) {
            return (Error)DiagnosticInfo.of(DiagnosticType.ERROR, this.prefix, string, objectArray);
        }

        Warning warningKey(Lint.LintCategory lintCategory, String string, Object ... objectArray) {
            return (Warning)DiagnosticInfo.of(DiagnosticType.WARNING, lintCategory, this.prefix, string, objectArray);
        }

        public Note noteKey(String string, Object ... objectArray) {
            return (Note)DiagnosticInfo.of(DiagnosticType.NOTE, this.prefix, string, objectArray);
        }

        Fragment fragmentKey(String string, Object ... objectArray) {
            return (Fragment)DiagnosticInfo.of(DiagnosticType.FRAGMENT, this.prefix, string, objectArray);
        }
    }
}

